// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: currency.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Currency represents a specific monetary currency.
type Currency struct {
	// System identifier of the currency.
	// E.g. "eur" or "usd"
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Human readable name of the currency
	// E.g. "US Dollar"
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Human readable sign for the currency.
	// E.g. "$"
	Sign string `protobuf:"bytes,3,opt,name=sign,proto3" json:"sign,omitempty"`
	// ISO 4217 currency code.
	// E.g. "USD"
	Iso4217Code          string   `protobuf:"bytes,4,opt,name=iso4217_code,json=iso4217Code,proto3" json:"iso4217_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Currency) Reset()         { *m = Currency{} }
func (m *Currency) String() string { return proto.CompactTextString(m) }
func (*Currency) ProtoMessage()    {}
func (*Currency) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3dc60ed002193ea, []int{0}
}
func (m *Currency) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Currency) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Currency.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Currency) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Currency.Merge(m, src)
}
func (m *Currency) XXX_Size() int {
	return m.Size()
}
func (m *Currency) XXX_DiscardUnknown() {
	xxx_messageInfo_Currency.DiscardUnknown(m)
}

var xxx_messageInfo_Currency proto.InternalMessageInfo

func (m *Currency) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Currency) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Currency) GetSign() string {
	if m != nil {
		return m.Sign
	}
	return ""
}

func (m *Currency) GetIso4217Code() string {
	if m != nil {
		return m.Iso4217Code
	}
	return ""
}

// List of currencies.
type CurrencyList struct {
	Items                []*Currency `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CurrencyList) Reset()         { *m = CurrencyList{} }
func (m *CurrencyList) String() string { return proto.CompactTextString(m) }
func (*CurrencyList) ProtoMessage()    {}
func (*CurrencyList) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3dc60ed002193ea, []int{1}
}
func (m *CurrencyList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CurrencyList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CurrencyList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CurrencyList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CurrencyList.Merge(m, src)
}
func (m *CurrencyList) XXX_Size() int {
	return m.Size()
}
func (m *CurrencyList) XXX_DiscardUnknown() {
	xxx_messageInfo_CurrencyList.DiscardUnknown(m)
}

var xxx_messageInfo_CurrencyList proto.InternalMessageInfo

func (m *CurrencyList) GetItems() []*Currency {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for GetDefaultCurrency.
type GetDefaultCurrencyRequest struct {
	// Optional identifier for the organization to request the default
	// currency for.
	OrganizationId       string   `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDefaultCurrencyRequest) Reset()         { *m = GetDefaultCurrencyRequest{} }
func (m *GetDefaultCurrencyRequest) String() string { return proto.CompactTextString(m) }
func (*GetDefaultCurrencyRequest) ProtoMessage()    {}
func (*GetDefaultCurrencyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_d3dc60ed002193ea, []int{2}
}
func (m *GetDefaultCurrencyRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDefaultCurrencyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDefaultCurrencyRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDefaultCurrencyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDefaultCurrencyRequest.Merge(m, src)
}
func (m *GetDefaultCurrencyRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDefaultCurrencyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDefaultCurrencyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDefaultCurrencyRequest proto.InternalMessageInfo

func (m *GetDefaultCurrencyRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func init() {
	proto.RegisterType((*Currency)(nil), "arangodb.cloud.currency.v1.Currency")
	proto.RegisterType((*CurrencyList)(nil), "arangodb.cloud.currency.v1.CurrencyList")
	proto.RegisterType((*GetDefaultCurrencyRequest)(nil), "arangodb.cloud.currency.v1.GetDefaultCurrencyRequest")
}

func init() { proto.RegisterFile("currency.proto", fileDescriptor_d3dc60ed002193ea) }

var fileDescriptor_d3dc60ed002193ea = []byte{
	// 480 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x53, 0x41, 0x8b, 0xd3, 0x40,
	0x14, 0x36, 0xdd, 0x2a, 0x3a, 0x5d, 0xbb, 0xf0, 0x0e, 0x52, 0xe3, 0x1a, 0xdb, 0x74, 0xc5, 0x0a,
	0x36, 0xa1, 0x55, 0x11, 0x3c, 0x08, 0xba, 0x95, 0x52, 0x11, 0x94, 0x15, 0x3c, 0x78, 0x59, 0xa6,
	0x99, 0x67, 0x1c, 0x68, 0x66, 0x62, 0x66, 0x12, 0xa8, 0xe2, 0x65, 0x0f, 0xfe, 0x01, 0x2f, 0x1e,
	0xfc, 0x23, 0xfe, 0x03, 0x8f, 0x82, 0x7f, 0x40, 0xaa, 0x3f, 0x44, 0x32, 0x49, 0xea, 0x42, 0xc9,
	0xd2, 0xdb, 0xe3, 0x7b, 0xf3, 0xbe, 0xef, 0x7b, 0xef, 0x4b, 0x48, 0x3b, 0x48, 0x93, 0x04, 0x45,
	0xb0, 0xf4, 0xe2, 0x44, 0x6a, 0x09, 0x36, 0x4d, 0xa8, 0x08, 0x25, 0x9b, 0x7b, 0xc1, 0x42, 0xa6,
	0xcc, 0x5b, 0xb7, 0xb3, 0x91, 0x7d, 0x25, 0x90, 0x51, 0x24, 0x85, 0x9f, 0x8d, 0xfc, 0xa2, 0x2a,
	0x66, 0xec, 0xfd, 0x50, 0xca, 0x70, 0x81, 0x3e, 0x8d, 0xb9, 0x4f, 0x85, 0x90, 0x9a, 0x6a, 0x2e,
	0x85, 0x2a, 0xba, 0x2e, 0x92, 0x8b, 0x87, 0x25, 0x09, 0xb4, 0x49, 0x83, 0xb3, 0x8e, 0xd5, 0xb5,
	0x06, 0x97, 0x8e, 0x1a, 0x9c, 0x01, 0x90, 0xa6, 0xa0, 0x11, 0x76, 0x1a, 0x06, 0x31, 0x75, 0x8e,
	0x29, 0x1e, 0x8a, 0xce, 0x4e, 0x81, 0xe5, 0x35, 0xf4, 0xc8, 0x2e, 0x57, 0xf2, 0xde, 0x78, 0xf4,
	0xe0, 0x38, 0x90, 0x0c, 0x3b, 0x4d, 0xd3, 0x6b, 0x95, 0xd8, 0xa1, 0x64, 0xe8, 0x3e, 0x23, 0xbb,
	0x95, 0xcc, 0x73, 0xae, 0x34, 0x3c, 0x24, 0xe7, 0xb9, 0xc6, 0x48, 0x75, 0xac, 0xee, 0xce, 0xa0,
	0x35, 0x3e, 0xf0, 0xea, 0x17, 0xf3, 0xaa, 0xc1, 0xa3, 0x62, 0xc4, 0x9d, 0x90, 0xab, 0x53, 0xd4,
	0x13, 0x7c, 0x4b, 0xd3, 0x85, 0x5e, 0x37, 0xf1, 0x7d, 0x8a, 0x4a, 0xc3, 0x2d, 0xb2, 0x27, 0x93,
	0x90, 0x0a, 0xfe, 0xc1, 0xac, 0x79, 0xbc, 0x5e, 0xa8, 0x7d, 0x1a, 0x9e, 0xb1, 0xf1, 0xf7, 0x26,
	0xd9, 0xab, 0x86, 0x5f, 0x61, 0x92, 0xf1, 0x00, 0x61, 0x49, 0x2e, 0x4f, 0x51, 0x3f, 0x7e, 0x39,
	0x7b, 0x8d, 0x89, 0xe2, 0x52, 0xc0, 0x8d, 0x0d, 0x5f, 0xc5, 0x65, 0xb3, 0x91, 0xf7, 0x34, 0x8a,
	0xf5, 0xd2, 0xee, 0xd5, 0x3f, 0x28, 0x39, 0xdc, 0x83, 0x93, 0x5f, 0x7f, 0xbf, 0x34, 0x1c, 0xd8,
	0x37, 0x09, 0x54, 0x8b, 0xe5, 0x31, 0xd1, 0x98, 0x0f, 0xb3, 0x52, 0xe9, 0xb3, 0x45, 0xda, 0xf9,
	0x65, 0x4a, 0x4b, 0x1c, 0x15, 0xdc, 0xac, 0xe7, 0xce, 0x5f, 0xbe, 0x88, 0x4d, 0x8e, 0xf6, 0x60,
	0x9b, 0xdb, 0xe5, 0x03, 0x6e, 0xdf, 0x38, 0xb9, 0x0e, 0xd7, 0x36, 0x9c, 0x04, 0xff, 0x55, 0x4f,
	0x2c, 0xd2, 0x9a, 0xe2, 0xfa, 0xae, 0xd0, 0xaf, 0x77, 0x31, 0x9b, 0x54, 0x1e, 0xb6, 0xca, 0xcf,
	0x1d, 0x18, 0x7d, 0x17, 0xba, 0x67, 0xe8, 0xfb, 0x1f, 0x39, 0xfb, 0x04, 0xdf, 0x2c, 0x02, 0x9b,
	0x19, 0xc3, 0xfd, 0xb3, 0x64, 0x6a, 0xbf, 0x89, 0x2d, 0xdd, 0xdd, 0x36, 0xee, 0xfa, 0xd0, 0xdb,
	0x70, 0xc7, 0x0a, 0xda, 0x61, 0x85, 0x3d, 0x79, 0xf4, 0x63, 0xe5, 0x58, 0x3f, 0x57, 0x8e, 0xf5,
	0x7b, 0xe5, 0x58, 0x5f, 0xff, 0x38, 0xe7, 0xde, 0xdc, 0x09, 0xb9, 0x7e, 0x97, 0xce, 0xf3, 0xe3,
	0xf8, 0x95, 0xd8, 0x30, 0xa2, 0x82, 0x86, 0xc8, 0x72, 0x3e, 0x75, 0x9a, 0x70, 0x7e, 0xc1, 0xfc,
	0x7b, 0x77, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0xaa, 0xa5, 0xac, 0x9b, 0xdf, 0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CurrencyServiceClient is the client API for CurrencyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CurrencyServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all providers that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListCurrencies(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*CurrencyList, error)
	// Fetch a currency by its id.
	// Required permissions:
	// - None
	GetCurrency(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Currency, error)
	// Fetch the default currency for a given (optional) organization.
	// Required permissions:
	// - resourcemanager.organization.get On the organization identified by given id.
	// - None In case no organization identifier was given.
	GetDefaultCurrency(ctx context.Context, in *GetDefaultCurrencyRequest, opts ...grpc.CallOption) (*Currency, error)
}

type currencyServiceClient struct {
	cc *grpc.ClientConn
}

func NewCurrencyServiceClient(cc *grpc.ClientConn) CurrencyServiceClient {
	return &currencyServiceClient{cc}
}

func (c *currencyServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.currency.v1.CurrencyService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *currencyServiceClient) ListCurrencies(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*CurrencyList, error) {
	out := new(CurrencyList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.currency.v1.CurrencyService/ListCurrencies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *currencyServiceClient) GetCurrency(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Currency, error) {
	out := new(Currency)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.currency.v1.CurrencyService/GetCurrency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *currencyServiceClient) GetDefaultCurrency(ctx context.Context, in *GetDefaultCurrencyRequest, opts ...grpc.CallOption) (*Currency, error) {
	out := new(Currency)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.currency.v1.CurrencyService/GetDefaultCurrency", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CurrencyServiceServer is the server API for CurrencyService service.
type CurrencyServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all providers that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListCurrencies(context.Context, *v1.ListOptions) (*CurrencyList, error)
	// Fetch a currency by its id.
	// Required permissions:
	// - None
	GetCurrency(context.Context, *v1.IDOptions) (*Currency, error)
	// Fetch the default currency for a given (optional) organization.
	// Required permissions:
	// - resourcemanager.organization.get On the organization identified by given id.
	// - None In case no organization identifier was given.
	GetDefaultCurrency(context.Context, *GetDefaultCurrencyRequest) (*Currency, error)
}

// UnimplementedCurrencyServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCurrencyServiceServer struct {
}

func (*UnimplementedCurrencyServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedCurrencyServiceServer) ListCurrencies(ctx context.Context, req *v1.ListOptions) (*CurrencyList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCurrencies not implemented")
}
func (*UnimplementedCurrencyServiceServer) GetCurrency(ctx context.Context, req *v1.IDOptions) (*Currency, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCurrency not implemented")
}
func (*UnimplementedCurrencyServiceServer) GetDefaultCurrency(ctx context.Context, req *GetDefaultCurrencyRequest) (*Currency, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDefaultCurrency not implemented")
}

func RegisterCurrencyServiceServer(s *grpc.Server, srv CurrencyServiceServer) {
	s.RegisterService(&_CurrencyService_serviceDesc, srv)
}

func _CurrencyService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CurrencyServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.currency.v1.CurrencyService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CurrencyServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _CurrencyService_ListCurrencies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CurrencyServiceServer).ListCurrencies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.currency.v1.CurrencyService/ListCurrencies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CurrencyServiceServer).ListCurrencies(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CurrencyService_GetCurrency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CurrencyServiceServer).GetCurrency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.currency.v1.CurrencyService/GetCurrency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CurrencyServiceServer).GetCurrency(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CurrencyService_GetDefaultCurrency_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDefaultCurrencyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CurrencyServiceServer).GetDefaultCurrency(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.currency.v1.CurrencyService/GetDefaultCurrency",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CurrencyServiceServer).GetDefaultCurrency(ctx, req.(*GetDefaultCurrencyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CurrencyService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.currency.v1.CurrencyService",
	HandlerType: (*CurrencyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _CurrencyService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListCurrencies",
			Handler:    _CurrencyService_ListCurrencies_Handler,
		},
		{
			MethodName: "GetCurrency",
			Handler:    _CurrencyService_GetCurrency_Handler,
		},
		{
			MethodName: "GetDefaultCurrency",
			Handler:    _CurrencyService_GetDefaultCurrency_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "currency.proto",
}

func (m *Currency) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Currency) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Currency) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Iso4217Code) > 0 {
		i -= len(m.Iso4217Code)
		copy(dAtA[i:], m.Iso4217Code)
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.Iso4217Code)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Sign) > 0 {
		i -= len(m.Sign)
		copy(dAtA[i:], m.Sign)
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.Sign)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CurrencyList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CurrencyList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CurrencyList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCurrency(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetDefaultCurrencyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDefaultCurrencyRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDefaultCurrencyRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintCurrency(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintCurrency(dAtA []byte, offset int, v uint64) int {
	offset -= sovCurrency(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Currency) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	l = len(m.Sign)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	l = len(m.Iso4217Code)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CurrencyList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovCurrency(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetDefaultCurrencyRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovCurrency(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCurrency(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCurrency(x uint64) (n int) {
	return sovCurrency(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Currency) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCurrency
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Currency: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Currency: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sign", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sign = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Iso4217Code", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Iso4217Code = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCurrency(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CurrencyList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCurrency
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CurrencyList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CurrencyList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Currency{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCurrency(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDefaultCurrencyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCurrency
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDefaultCurrencyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDefaultCurrencyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCurrency
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCurrency
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCurrency(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCurrency
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCurrency(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCurrency
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCurrency
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCurrency
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthCurrency
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCurrency
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCurrency(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthCurrency
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCurrency = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCurrency   = fmt.Errorf("proto: integer overflow")
)
