// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: replication.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	v11 "github.com/arangodb-managed/apis/data/v1"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// CloneDeploymentFromBackupRequest defines a request object for clone deployment call.
type CloneDeploymentFromBackupRequest struct {
	// The ID of the backup to clone a deployment from.
	BackupId string `protobuf:"bytes,1,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Target region.
	// This is an optional field
	RegionId             string   `protobuf:"bytes,2,opt,name=region_id,json=regionId,proto3" json:"region_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloneDeploymentFromBackupRequest) Reset()         { *m = CloneDeploymentFromBackupRequest{} }
func (m *CloneDeploymentFromBackupRequest) String() string { return proto.CompactTextString(m) }
func (*CloneDeploymentFromBackupRequest) ProtoMessage()    {}
func (*CloneDeploymentFromBackupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed0454e9e09fb71a, []int{0}
}
func (m *CloneDeploymentFromBackupRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CloneDeploymentFromBackupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CloneDeploymentFromBackupRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CloneDeploymentFromBackupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloneDeploymentFromBackupRequest.Merge(m, src)
}
func (m *CloneDeploymentFromBackupRequest) XXX_Size() int {
	return m.Size()
}
func (m *CloneDeploymentFromBackupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CloneDeploymentFromBackupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CloneDeploymentFromBackupRequest proto.InternalMessageInfo

func (m *CloneDeploymentFromBackupRequest) GetBackupId() string {
	if m != nil {
		return m.BackupId
	}
	return ""
}

func (m *CloneDeploymentFromBackupRequest) GetRegionId() string {
	if m != nil {
		return m.RegionId
	}
	return ""
}

func init() {
	proto.RegisterType((*CloneDeploymentFromBackupRequest)(nil), "arangodb.cloud.replication.v1.CloneDeploymentFromBackupRequest")
}

func init() { proto.RegisterFile("replication.proto", fileDescriptor_ed0454e9e09fb71a) }

var fileDescriptor_ed0454e9e09fb71a = []byte{
	// 368 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x51, 0xcd, 0x4a, 0xf3, 0x40,
	0x14, 0xfd, 0xd2, 0xc5, 0xc7, 0xd7, 0xc0, 0xb7, 0x70, 0x16, 0xa2, 0x51, 0xd3, 0x36, 0x1b, 0x45,
	0xec, 0x0c, 0xd1, 0x85, 0xe0, 0x46, 0x5a, 0xff, 0xe8, 0x4e, 0x2a, 0xb8, 0x10, 0x41, 0x26, 0xc9,
	0x10, 0x07, 0x93, 0xb9, 0x31, 0x99, 0x04, 0x8a, 0xba, 0xf1, 0x15, 0xdc, 0xf8, 0x2a, 0xbe, 0x81,
	0x2b, 0x11, 0x7c, 0x01, 0xa9, 0x3e, 0x88, 0x4c, 0x26, 0xda, 0x52, 0xac, 0xae, 0x66, 0x38, 0xe7,
	0xde, 0x73, 0xef, 0x39, 0xd7, 0x9c, 0x49, 0x59, 0x12, 0x71, 0x9f, 0x4a, 0x0e, 0x02, 0x27, 0x29,
	0x48, 0x40, 0x4b, 0x34, 0xa5, 0x22, 0x84, 0xc0, 0xc3, 0x7e, 0x04, 0x79, 0x80, 0xc7, 0x2b, 0x0a,
	0xd7, 0x9a, 0xf5, 0x21, 0x8e, 0x41, 0x90, 0xc2, 0x25, 0xfa, 0xa7, 0xdb, 0x2c, 0x14, 0x50, 0x49,
	0x15, 0xaa, 0xde, 0x0a, 0x5b, 0x0c, 0x01, 0xc2, 0x88, 0x11, 0x9a, 0x70, 0x42, 0x85, 0x00, 0x59,
	0xaa, 0x64, 0x9a, 0x75, 0x4e, 0xcd, 0xe6, 0x4e, 0x04, 0x82, 0xed, 0xb2, 0x24, 0x82, 0x41, 0xcc,
	0x84, 0xdc, 0x4f, 0x21, 0xee, 0x52, 0xff, 0x22, 0x4f, 0xfa, 0xec, 0x32, 0x67, 0x99, 0x44, 0x0b,
	0x66, 0xdd, 0x2b, 0x81, 0x33, 0x1e, 0xcc, 0x19, 0x4d, 0x63, 0xa5, 0xde, 0xff, 0xa7, 0x81, 0x5e,
	0xa0, 0xc8, 0x94, 0x85, 0x1c, 0x84, 0x22, 0x6b, 0x9a, 0xd4, 0x40, 0x2f, 0x58, 0x7f, 0xaa, 0x99,
	0xa8, 0x3f, 0x5a, 0xfd, 0x88, 0xa5, 0x05, 0xf7, 0x19, 0xba, 0x36, 0xff, 0x1f, 0x30, 0xd9, 0x39,
	0xec, 0x1d, 0xb3, 0x34, 0xe3, 0x20, 0x50, 0x03, 0x4f, 0xf8, 0xad, 0x5c, 0x15, 0x2e, 0xde, 0x8b,
	0x13, 0x39, 0xb0, 0x5a, 0xd3, 0x0b, 0x2a, 0x0d, 0x67, 0xf9, 0xf6, 0xe5, 0xfd, 0xae, 0xd6, 0x42,
	0x8d, 0xd2, 0xe9, 0x58, 0x60, 0x2a, 0x0f, 0x9a, 0xf0, 0x76, 0x51, 0x0d, 0x7b, 0x30, 0xcc, 0xf9,
	0xa9, 0x9e, 0xd1, 0x36, 0xfe, 0x31, 0x7a, 0xfc, 0x5b, 0x5a, 0x96, 0x33, 0x29, 0x50, 0xde, 0xa2,
	0x70, 0xf1, 0xa8, 0xc9, 0xd9, 0x2c, 0x77, 0x75, 0x9d, 0xb5, 0xef, 0x76, 0xd5, 0xd1, 0x92, 0xab,
	0xaf, 0xcc, 0x6f, 0x88, 0xaf, 0x86, 0x6e, 0x19, 0xab, 0xdd, 0xce, 0xe3, 0xd0, 0x36, 0x9e, 0x87,
	0xb6, 0xf1, 0x3a, 0xb4, 0x8d, 0xfb, 0x37, 0xfb, 0xcf, 0x09, 0x09, 0xb9, 0x3c, 0xcf, 0x3d, 0x15,
	0x08, 0xf9, 0x1c, 0xdc, 0x8e, 0xa9, 0xa0, 0x21, 0x0b, 0x94, 0x7a, 0x36, 0x21, 0xef, 0xfd, 0x2d,
	0x0f, 0xbf, 0xf1, 0x11, 0x00, 0x00, 0xff, 0xff, 0xcd, 0xf4, 0x50, 0x52, 0x76, 0x02, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ReplicationServiceClient is the client API for ReplicationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ReplicationServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Takes a backup and creates a deployment from it. For all intents and purposes this new deployment
	// will be the same as the deployment at that exact moment when the backup was taken from it. This means that
	// the new deployment will be in the same project and use the same provider as the old deployment did. Optionally
	// a different region can be provided using the region id field on the request. Furthermore, the new deployment
	// will have the same server settings ( count, mode, replication factor ) as the old deployment did at the time
	// of taking the backup. After the new deployment successfully started, the backup will be used to restore the
	// data into the new deployment. The new deployment will have a different endpoint, and the password will also
	// be reset for it. All other user settings will remain the same.
	// The old deployment will not be touched.
	// Required permissions:
	// - replication.deployment.clone-from-backup
	CloneDeploymentFromBackup(ctx context.Context, in *CloneDeploymentFromBackupRequest, opts ...grpc.CallOption) (*v11.Deployment, error)
}

type replicationServiceClient struct {
	cc *grpc.ClientConn
}

func NewReplicationServiceClient(cc *grpc.ClientConn) ReplicationServiceClient {
	return &replicationServiceClient{cc}
}

func (c *replicationServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.replication.v1.ReplicationService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *replicationServiceClient) CloneDeploymentFromBackup(ctx context.Context, in *CloneDeploymentFromBackupRequest, opts ...grpc.CallOption) (*v11.Deployment, error) {
	out := new(v11.Deployment)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.replication.v1.ReplicationService/CloneDeploymentFromBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReplicationServiceServer is the server API for ReplicationService service.
type ReplicationServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Takes a backup and creates a deployment from it. For all intents and purposes this new deployment
	// will be the same as the deployment at that exact moment when the backup was taken from it. This means that
	// the new deployment will be in the same project and use the same provider as the old deployment did. Optionally
	// a different region can be provided using the region id field on the request. Furthermore, the new deployment
	// will have the same server settings ( count, mode, replication factor ) as the old deployment did at the time
	// of taking the backup. After the new deployment successfully started, the backup will be used to restore the
	// data into the new deployment. The new deployment will have a different endpoint, and the password will also
	// be reset for it. All other user settings will remain the same.
	// The old deployment will not be touched.
	// Required permissions:
	// - replication.deployment.clone-from-backup
	CloneDeploymentFromBackup(context.Context, *CloneDeploymentFromBackupRequest) (*v11.Deployment, error)
}

// UnimplementedReplicationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedReplicationServiceServer struct {
}

func (*UnimplementedReplicationServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedReplicationServiceServer) CloneDeploymentFromBackup(ctx context.Context, req *CloneDeploymentFromBackupRequest) (*v11.Deployment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloneDeploymentFromBackup not implemented")
}

func RegisterReplicationServiceServer(s *grpc.Server, srv ReplicationServiceServer) {
	s.RegisterService(&_ReplicationService_serviceDesc, srv)
}

func _ReplicationService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReplicationServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.replication.v1.ReplicationService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReplicationServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReplicationService_CloneDeploymentFromBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloneDeploymentFromBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReplicationServiceServer).CloneDeploymentFromBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.replication.v1.ReplicationService/CloneDeploymentFromBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReplicationServiceServer).CloneDeploymentFromBackup(ctx, req.(*CloneDeploymentFromBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ReplicationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.replication.v1.ReplicationService",
	HandlerType: (*ReplicationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _ReplicationService_GetAPIVersion_Handler,
		},
		{
			MethodName: "CloneDeploymentFromBackup",
			Handler:    _ReplicationService_CloneDeploymentFromBackup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "replication.proto",
}

func (m *CloneDeploymentFromBackupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CloneDeploymentFromBackupRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CloneDeploymentFromBackupRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.RegionId) > 0 {
		i -= len(m.RegionId)
		copy(dAtA[i:], m.RegionId)
		i = encodeVarintReplication(dAtA, i, uint64(len(m.RegionId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.BackupId) > 0 {
		i -= len(m.BackupId)
		copy(dAtA[i:], m.BackupId)
		i = encodeVarintReplication(dAtA, i, uint64(len(m.BackupId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintReplication(dAtA []byte, offset int, v uint64) int {
	offset -= sovReplication(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CloneDeploymentFromBackupRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.BackupId)
	if l > 0 {
		n += 1 + l + sovReplication(uint64(l))
	}
	l = len(m.RegionId)
	if l > 0 {
		n += 1 + l + sovReplication(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovReplication(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozReplication(x uint64) (n int) {
	return sovReplication(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CloneDeploymentFromBackupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowReplication
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CloneDeploymentFromBackupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CloneDeploymentFromBackupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BackupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BackupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RegionId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowReplication
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthReplication
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthReplication
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RegionId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipReplication(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthReplication
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthReplication
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipReplication(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowReplication
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReplication
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowReplication
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthReplication
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthReplication
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowReplication
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipReplication(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthReplication
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthReplication = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowReplication   = fmt.Errorf("proto: integer overflow")
)
