// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: audit.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// AuditLog holds a specification destinations that audit events should be
// sent to and it acts as a grouping of audit log archives.
type AuditLog struct {
	// The ID of this resource.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the audit log
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the audit log
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The creation timestamp of the resource
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the resource
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,6,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this resource is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,7,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the user who created this resource.
	// This is a read-only value.
	CreatedById string `protobuf:"bytes,8,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// Identifier of the organization that owns this audit log.
	// This is a read-only value.
	OrganizationId string `protobuf:"bytes,9,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, this AuditLog is the default for the organization.
	IsDefault bool `protobuf:"varint,10,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// Destinations that events of this AuditLog should be sent to.
	// Note that there can only be 1 destination of type "cloud".
	Destinations         []*AuditLog_Destination `protobuf:"bytes,100,rep,name=destinations,proto3" json:"destinations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *AuditLog) Reset()         { *m = AuditLog{} }
func (m *AuditLog) String() string { return proto.CompactTextString(m) }
func (*AuditLog) ProtoMessage()    {}
func (*AuditLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0}
}
func (m *AuditLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog.Merge(m, src)
}
func (m *AuditLog) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog proto.InternalMessageInfo

func (m *AuditLog) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AuditLog) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *AuditLog) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AuditLog) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AuditLog) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *AuditLog) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *AuditLog) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *AuditLog) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *AuditLog) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *AuditLog) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *AuditLog) GetDestinations() []*AuditLog_Destination {
	if m != nil {
		return m.Destinations
	}
	return nil
}

// Settings for a destination of type "https-post"
type AuditLog_HttpsPostSettings struct {
	// URL of the server to POST to.
	// The scheme of the URL must be "https".
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// PEM encoded public key of the CA used to sign
	// the server TLS certificate.
	// This public key will be used to verify the
	// TLS connection provided by the server.
	// If this field is empty, a well known CA is expected.
	TrustedServerCaPem string `protobuf:"bytes,2,opt,name=trusted_server_ca_pem,json=trustedServerCaPem,proto3" json:"trusted_server_ca_pem,omitempty"`
	// PEM encoded public key of the client certificate
	// used to make the request.
	ClientCertificatePem string `protobuf:"bytes,3,opt,name=client_certificate_pem,json=clientCertificatePem,proto3" json:"client_certificate_pem,omitempty"`
	// PEM encoded private key of the client certificate
	// used to make the request.
	ClientKeyPem string `protobuf:"bytes,4,opt,name=client_key_pem,json=clientKeyPem,proto3" json:"client_key_pem,omitempty"`
	// HTTP headers to add to the request.
	// It is allowed to pass multiple headers with the same key.
	Headers []*AuditLog_Header `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty"`
	// Do not send audit events with these topics to this destination.
	ExcludedTopics       []string `protobuf:"bytes,100,rep,name=excluded_topics,json=excludedTopics,proto3" json:"excluded_topics,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLog_HttpsPostSettings) Reset()         { *m = AuditLog_HttpsPostSettings{} }
func (m *AuditLog_HttpsPostSettings) String() string { return proto.CompactTextString(m) }
func (*AuditLog_HttpsPostSettings) ProtoMessage()    {}
func (*AuditLog_HttpsPostSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0, 0}
}
func (m *AuditLog_HttpsPostSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog_HttpsPostSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog_HttpsPostSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog_HttpsPostSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog_HttpsPostSettings.Merge(m, src)
}
func (m *AuditLog_HttpsPostSettings) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog_HttpsPostSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog_HttpsPostSettings.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog_HttpsPostSettings proto.InternalMessageInfo

func (m *AuditLog_HttpsPostSettings) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *AuditLog_HttpsPostSettings) GetTrustedServerCaPem() string {
	if m != nil {
		return m.TrustedServerCaPem
	}
	return ""
}

func (m *AuditLog_HttpsPostSettings) GetClientCertificatePem() string {
	if m != nil {
		return m.ClientCertificatePem
	}
	return ""
}

func (m *AuditLog_HttpsPostSettings) GetClientKeyPem() string {
	if m != nil {
		return m.ClientKeyPem
	}
	return ""
}

func (m *AuditLog_HttpsPostSettings) GetHeaders() []*AuditLog_Header {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *AuditLog_HttpsPostSettings) GetExcludedTopics() []string {
	if m != nil {
		return m.ExcludedTopics
	}
	return nil
}

// HTTP header pair
type AuditLog_Header struct {
	// Key of the header
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value of the header
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLog_Header) Reset()         { *m = AuditLog_Header{} }
func (m *AuditLog_Header) String() string { return proto.CompactTextString(m) }
func (*AuditLog_Header) ProtoMessage()    {}
func (*AuditLog_Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0, 1}
}
func (m *AuditLog_Header) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog_Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog_Header.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog_Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog_Header.Merge(m, src)
}
func (m *AuditLog_Header) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog_Header) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog_Header.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog_Header proto.InternalMessageInfo

func (m *AuditLog_Header) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *AuditLog_Header) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// Specification of a destination for audit events.
type AuditLog_Destination struct {
	// Type of destination.
	// Possible values are: "cloud", "https-post"
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Settings for destinations of type "https-post"
	HttpPost             *AuditLog_HttpsPostSettings `protobuf:"bytes,10,opt,name=http_post,json=httpPost,proto3" json:"http_post,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *AuditLog_Destination) Reset()         { *m = AuditLog_Destination{} }
func (m *AuditLog_Destination) String() string { return proto.CompactTextString(m) }
func (*AuditLog_Destination) ProtoMessage()    {}
func (*AuditLog_Destination) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0, 2}
}
func (m *AuditLog_Destination) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog_Destination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog_Destination.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog_Destination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog_Destination.Merge(m, src)
}
func (m *AuditLog_Destination) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog_Destination) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog_Destination.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog_Destination proto.InternalMessageInfo

func (m *AuditLog_Destination) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *AuditLog_Destination) GetHttpPost() *AuditLog_HttpsPostSettings {
	if m != nil {
		return m.HttpPost
	}
	return nil
}

// List of AuditLog's.
type AuditLogList struct {
	Items                []*AuditLog `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AuditLogList) Reset()         { *m = AuditLogList{} }
func (m *AuditLogList) String() string { return proto.CompactTextString(m) }
func (*AuditLogList) ProtoMessage()    {}
func (*AuditLogList) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{1}
}
func (m *AuditLogList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogList.Merge(m, src)
}
func (m *AuditLogList) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogList) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogList.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogList proto.InternalMessageInfo

func (m *AuditLogList) GetItems() []*AuditLog {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListAuditLogs
type ListAuditLogsRequest struct {
	// Identifier of the organization to request the audit logs for.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, the result includes all audit logs, including those who set to deleted,
	// however are not removed from the system currently.
	// If not set, only audit logs not indicated as deleted are returned.
	IncludeDeleted bool `protobuf:"varint,2,opt,name=include_deleted,json=includeDeleted,proto3" json:"include_deleted,omitempty"`
	// Optional common list options, the context_id is ignored
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListAuditLogsRequest) Reset()         { *m = ListAuditLogsRequest{} }
func (m *ListAuditLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAuditLogsRequest) ProtoMessage()    {}
func (*ListAuditLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{2}
}
func (m *ListAuditLogsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAuditLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAuditLogsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAuditLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAuditLogsRequest.Merge(m, src)
}
func (m *ListAuditLogsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListAuditLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAuditLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAuditLogsRequest proto.InternalMessageInfo

func (m *ListAuditLogsRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListAuditLogsRequest) GetIncludeDeleted() bool {
	if m != nil {
		return m.IncludeDeleted
	}
	return false
}

func (m *ListAuditLogsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// AuditLogArchive collects files of audit events in a specific region,
// usually for a specific deployment.
type AuditLogArchive struct {
	// The ID of this resource.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// The creation timestamp of the resource
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the resource
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,4,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this resource is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,5,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the auditlog that owns this audit log archive.
	// This is a read-only value.
	AuditlogId string `protobuf:"bytes,6,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	// If set, this archive is collecting audit events for a deployment with this ID.
	// Note that the deployment may have already been deleted.
	DeploymentId string `protobuf:"bytes,7,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Last known size of this archive in bytes.
	// Note that this field is only update periodically.
	// This is a read-only value.
	SizeInBytes uint64 `protobuf:"varint,8,opt,name=size_in_bytes,json=sizeInBytes,proto3" json:"size_in_bytes,omitempty"`
	// The timestamp of the last modification of size_in_bytes.
	// This is a read-only value.
	SizeInBytesChangedAt *types.Timestamp `protobuf:"bytes,9,opt,name=size_in_bytes_changed_at,json=sizeInBytesChangedAt,proto3" json:"size_in_bytes_changed_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *AuditLogArchive) Reset()         { *m = AuditLogArchive{} }
func (m *AuditLogArchive) String() string { return proto.CompactTextString(m) }
func (*AuditLogArchive) ProtoMessage()    {}
func (*AuditLogArchive) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{3}
}
func (m *AuditLogArchive) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogArchive) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogArchive.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogArchive) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogArchive.Merge(m, src)
}
func (m *AuditLogArchive) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogArchive) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogArchive.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogArchive proto.InternalMessageInfo

func (m *AuditLogArchive) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AuditLogArchive) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *AuditLogArchive) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *AuditLogArchive) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *AuditLogArchive) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *AuditLogArchive) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func (m *AuditLogArchive) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *AuditLogArchive) GetSizeInBytes() uint64 {
	if m != nil {
		return m.SizeInBytes
	}
	return 0
}

func (m *AuditLogArchive) GetSizeInBytesChangedAt() *types.Timestamp {
	if m != nil {
		return m.SizeInBytesChangedAt
	}
	return nil
}

// List of AuditLogArchive's.
type AuditLogArchiveList struct {
	Items                []*AuditLogArchive `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *AuditLogArchiveList) Reset()         { *m = AuditLogArchiveList{} }
func (m *AuditLogArchiveList) String() string { return proto.CompactTextString(m) }
func (*AuditLogArchiveList) ProtoMessage()    {}
func (*AuditLogArchiveList) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{4}
}
func (m *AuditLogArchiveList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogArchiveList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogArchiveList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogArchiveList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogArchiveList.Merge(m, src)
}
func (m *AuditLogArchiveList) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogArchiveList) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogArchiveList.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogArchiveList proto.InternalMessageInfo

func (m *AuditLogArchiveList) GetItems() []*AuditLogArchive {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListAuditLogArchives
type ListAuditLogArchivesRequest struct {
	// Identifier of the audit log to request the audit log archives for.
	AuditlogId string `protobuf:"bytes,1,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	// If set, the result includes all audit log archives, including those who set to deleted,
	// however are not removed from the system currently.
	// If not set, only audit log archives not indicated as deleted are returned.
	IncludeDeleted bool `protobuf:"varint,2,opt,name=include_deleted,json=includeDeleted,proto3" json:"include_deleted,omitempty"`
	// Optional common list options, the context_id is ignored
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListAuditLogArchivesRequest) Reset()         { *m = ListAuditLogArchivesRequest{} }
func (m *ListAuditLogArchivesRequest) String() string { return proto.CompactTextString(m) }
func (*ListAuditLogArchivesRequest) ProtoMessage()    {}
func (*ListAuditLogArchivesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{5}
}
func (m *ListAuditLogArchivesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAuditLogArchivesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAuditLogArchivesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAuditLogArchivesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAuditLogArchivesRequest.Merge(m, src)
}
func (m *ListAuditLogArchivesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListAuditLogArchivesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAuditLogArchivesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAuditLogArchivesRequest proto.InternalMessageInfo

func (m *ListAuditLogArchivesRequest) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func (m *ListAuditLogArchivesRequest) GetIncludeDeleted() bool {
	if m != nil {
		return m.IncludeDeleted
	}
	return false
}

func (m *ListAuditLogArchivesRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// Single audit log event
type AuditLogEvent struct {
	// When did the event happen
	Timestamp *types.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Topic of the event
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// ID of the project that the event happened in (if applicable)
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the deployment that the event happened in (if applicable)
	DeploymentId string `protobuf:"bytes,4,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// ID of the server that the event happened in (if applicable)
	ServerId string `protobuf:"bytes,5,opt,name=server_id,json=serverId,proto3" json:"server_id,omitempty"`
	// Instance ID of the server that the event happened in (if applicable)
	InstanceId string `protobuf:"bytes,6,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Sequence number. Must be even increasing for (deployment_id, server_id, instance_id) pairs.
	Sequence uint64 `protobuf:"varint,7,opt,name=sequence,proto3" json:"sequence,omitempty"`
	// ID of the user that caused the event
	UserId string `protobuf:"bytes,8,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Name of database the operation is in (if applicable)
	Database string `protobuf:"bytes,9,opt,name=database,proto3" json:"database,omitempty"`
	// IP address of source of operation (if available)
	ClientIp string `protobuf:"bytes,10,opt,name=client_ip,json=clientIp,proto3" json:"client_ip,omitempty"`
	// Authentication details
	Authentication string `protobuf:"bytes,11,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// Free format text describing the event
	Message string `protobuf:"bytes,12,opt,name=message,proto3" json:"message,omitempty"`
	// ID of the AuditLogArchive that contains this event (if applicable)
	AuditlogarchiveId    string   `protobuf:"bytes,13,opt,name=auditlogarchive_id,json=auditlogarchiveId,proto3" json:"auditlogarchive_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLogEvent) Reset()         { *m = AuditLogEvent{} }
func (m *AuditLogEvent) String() string { return proto.CompactTextString(m) }
func (*AuditLogEvent) ProtoMessage()    {}
func (*AuditLogEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{6}
}
func (m *AuditLogEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogEvent.Merge(m, src)
}
func (m *AuditLogEvent) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogEvent.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogEvent proto.InternalMessageInfo

func (m *AuditLogEvent) GetTimestamp() *types.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *AuditLogEvent) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *AuditLogEvent) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *AuditLogEvent) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *AuditLogEvent) GetServerId() string {
	if m != nil {
		return m.ServerId
	}
	return ""
}

func (m *AuditLogEvent) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *AuditLogEvent) GetSequence() uint64 {
	if m != nil {
		return m.Sequence
	}
	return 0
}

func (m *AuditLogEvent) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *AuditLogEvent) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *AuditLogEvent) GetClientIp() string {
	if m != nil {
		return m.ClientIp
	}
	return ""
}

func (m *AuditLogEvent) GetAuthentication() string {
	if m != nil {
		return m.Authentication
	}
	return ""
}

func (m *AuditLogEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *AuditLogEvent) GetAuditlogarchiveId() string {
	if m != nil {
		return m.AuditlogarchiveId
	}
	return ""
}

// List of AuditLogEvent's.
type AuditLogEventList struct {
	Items                []*AuditLogEvent `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *AuditLogEventList) Reset()         { *m = AuditLogEventList{} }
func (m *AuditLogEventList) String() string { return proto.CompactTextString(m) }
func (*AuditLogEventList) ProtoMessage()    {}
func (*AuditLogEventList) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{7}
}
func (m *AuditLogEventList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogEventList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogEventList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogEventList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogEventList.Merge(m, src)
}
func (m *AuditLogEventList) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogEventList) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogEventList.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogEventList proto.InternalMessageInfo

func (m *AuditLogEventList) GetItems() []*AuditLogEvent {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListAuditLogEvents.
type GetAuditLogEventsRequest struct {
	// Identifier of the audit log to request events for.
	AuditlogId string `protobuf:"bytes,1,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	// If set, include only events from this AuditLogArchive.
	AuditlogarchiveId string `protobuf:"bytes,2,opt,name=auditlogarchive_id,json=auditlogarchiveId,proto3" json:"auditlogarchive_id,omitempty"`
	// Request events created at or after this timestamp.
	// This is an optional field.
	From *types.Timestamp `protobuf:"bytes,3,opt,name=from,proto3" json:"from,omitempty"`
	// Request events created before this timestamp.
	// This is an optional field.
	To *types.Timestamp `protobuf:"bytes,4,opt,name=to,proto3" json:"to,omitempty"`
	// If non-empty, only request events with one of these topics.
	IncludedTopics []string `protobuf:"bytes,5,rep,name=included_topics,json=includedTopics,proto3" json:"included_topics,omitempty"`
	// If non-empty, leave out events with one of these topics.
	// If a topic is specified in included_topics as well as excluded_topics,
	// events of that topic will not be included in the results.
	ExcludedTopics []string `protobuf:"bytes,6,rep,name=excluded_topics,json=excludedTopics,proto3" json:"excluded_topics,omitempty"`
	// Limit the number of audit log events. Defaults to 0, meaning no limit.
	Limit                int32    `protobuf:"varint,10,opt,name=limit,proto3" json:"limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAuditLogEventsRequest) Reset()         { *m = GetAuditLogEventsRequest{} }
func (m *GetAuditLogEventsRequest) String() string { return proto.CompactTextString(m) }
func (*GetAuditLogEventsRequest) ProtoMessage()    {}
func (*GetAuditLogEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{8}
}
func (m *GetAuditLogEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetAuditLogEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetAuditLogEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetAuditLogEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAuditLogEventsRequest.Merge(m, src)
}
func (m *GetAuditLogEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetAuditLogEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAuditLogEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAuditLogEventsRequest proto.InternalMessageInfo

func (m *GetAuditLogEventsRequest) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func (m *GetAuditLogEventsRequest) GetAuditlogarchiveId() string {
	if m != nil {
		return m.AuditlogarchiveId
	}
	return ""
}

func (m *GetAuditLogEventsRequest) GetFrom() *types.Timestamp {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *GetAuditLogEventsRequest) GetTo() *types.Timestamp {
	if m != nil {
		return m.To
	}
	return nil
}

func (m *GetAuditLogEventsRequest) GetIncludedTopics() []string {
	if m != nil {
		return m.IncludedTopics
	}
	return nil
}

func (m *GetAuditLogEventsRequest) GetExcludedTopics() []string {
	if m != nil {
		return m.ExcludedTopics
	}
	return nil
}

func (m *GetAuditLogEventsRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

// Request arguments for DeleteAuditLogArchiveEvents.
type DeleteAuditLogArchiveEventsRequest struct {
	// Identifier of the audit log archive to delete events from.
	AuditlogarchiveId string `protobuf:"bytes,1,opt,name=auditlogarchive_id,json=auditlogarchiveId,proto3" json:"auditlogarchive_id,omitempty"`
	// Remove events created before this timestamp.
	// Note that this timestamp will be rounded down to the nearest hour.
	To                   *types.Timestamp `protobuf:"bytes,2,opt,name=to,proto3" json:"to,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *DeleteAuditLogArchiveEventsRequest) Reset()         { *m = DeleteAuditLogArchiveEventsRequest{} }
func (m *DeleteAuditLogArchiveEventsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAuditLogArchiveEventsRequest) ProtoMessage()    {}
func (*DeleteAuditLogArchiveEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{9}
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteAuditLogArchiveEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAuditLogArchiveEventsRequest.Merge(m, src)
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAuditLogArchiveEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAuditLogArchiveEventsRequest proto.InternalMessageInfo

func (m *DeleteAuditLogArchiveEventsRequest) GetAuditlogarchiveId() string {
	if m != nil {
		return m.AuditlogarchiveId
	}
	return ""
}

func (m *DeleteAuditLogArchiveEventsRequest) GetTo() *types.Timestamp {
	if m != nil {
		return m.To
	}
	return nil
}

// Request arguments for AttachProjectToAuditLog.
type AttachProjectToAuditLogRequest struct {
	// ID of project to attach the AuditLog to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the AuditLog to attach.
	AuditlogId           string   `protobuf:"bytes,2,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachProjectToAuditLogRequest) Reset()         { *m = AttachProjectToAuditLogRequest{} }
func (m *AttachProjectToAuditLogRequest) String() string { return proto.CompactTextString(m) }
func (*AttachProjectToAuditLogRequest) ProtoMessage()    {}
func (*AttachProjectToAuditLogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{10}
}
func (m *AttachProjectToAuditLogRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttachProjectToAuditLogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachProjectToAuditLogRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttachProjectToAuditLogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachProjectToAuditLogRequest.Merge(m, src)
}
func (m *AttachProjectToAuditLogRequest) XXX_Size() int {
	return m.Size()
}
func (m *AttachProjectToAuditLogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachProjectToAuditLogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AttachProjectToAuditLogRequest proto.InternalMessageInfo

func (m *AttachProjectToAuditLogRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *AttachProjectToAuditLogRequest) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func init() {
	proto.RegisterType((*AuditLog)(nil), "arangodb.cloud.audit.v1.AuditLog")
	proto.RegisterType((*AuditLog_HttpsPostSettings)(nil), "arangodb.cloud.audit.v1.AuditLog.HttpsPostSettings")
	proto.RegisterType((*AuditLog_Header)(nil), "arangodb.cloud.audit.v1.AuditLog.Header")
	proto.RegisterType((*AuditLog_Destination)(nil), "arangodb.cloud.audit.v1.AuditLog.Destination")
	proto.RegisterType((*AuditLogList)(nil), "arangodb.cloud.audit.v1.AuditLogList")
	proto.RegisterType((*ListAuditLogsRequest)(nil), "arangodb.cloud.audit.v1.ListAuditLogsRequest")
	proto.RegisterType((*AuditLogArchive)(nil), "arangodb.cloud.audit.v1.AuditLogArchive")
	proto.RegisterType((*AuditLogArchiveList)(nil), "arangodb.cloud.audit.v1.AuditLogArchiveList")
	proto.RegisterType((*ListAuditLogArchivesRequest)(nil), "arangodb.cloud.audit.v1.ListAuditLogArchivesRequest")
	proto.RegisterType((*AuditLogEvent)(nil), "arangodb.cloud.audit.v1.AuditLogEvent")
	proto.RegisterType((*AuditLogEventList)(nil), "arangodb.cloud.audit.v1.AuditLogEventList")
	proto.RegisterType((*GetAuditLogEventsRequest)(nil), "arangodb.cloud.audit.v1.GetAuditLogEventsRequest")
	proto.RegisterType((*DeleteAuditLogArchiveEventsRequest)(nil), "arangodb.cloud.audit.v1.DeleteAuditLogArchiveEventsRequest")
	proto.RegisterType((*AttachProjectToAuditLogRequest)(nil), "arangodb.cloud.audit.v1.AttachProjectToAuditLogRequest")
}

func init() { proto.RegisterFile("audit.proto", fileDescriptor_5594839dd8e38a1b) }

var fileDescriptor_5594839dd8e38a1b = []byte{
	// 1606 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x4b, 0x6f, 0x1b, 0x47,
	0x12, 0xde, 0xa1, 0x9e, 0x2c, 0x4a, 0xf4, 0xaa, 0x57, 0xb6, 0xc7, 0x94, 0x57, 0x96, 0xc6, 0x96,
	0xa5, 0xd5, 0x5a, 0xa4, 0x25, 0x1b, 0x2b, 0xbf, 0x60, 0x43, 0x0f, 0xaf, 0x4d, 0xac, 0x17, 0x2b,
	0x8f, 0xed, 0x3d, 0xe4, 0xc2, 0xb4, 0x66, 0x5a, 0x54, 0xc7, 0x9c, 0x47, 0xa6, 0x9b, 0x44, 0x68,
	0x47, 0x30, 0x92, 0x43, 0x80, 0xe4, 0x64, 0x20, 0x39, 0x04, 0xb9, 0xe5, 0x12, 0x24, 0x87, 0xe4,
	0x07, 0xe4, 0x14, 0xe4, 0x94, 0x63, 0x80, 0xfc, 0x81, 0xc0, 0xc9, 0x0f, 0x09, 0xba, 0x7b, 0x9a,
	0x22, 0x69, 0x8e, 0x66, 0x60, 0x08, 0xb9, 0x4d, 0x57, 0x57, 0x75, 0x7f, 0x5d, 0xf5, 0xd5, 0x83,
	0x84, 0x02, 0x6e, 0xba, 0x94, 0x97, 0xc3, 0x28, 0xe0, 0x01, 0x3a, 0x8d, 0x23, 0xec, 0xd7, 0x03,
	0x77, 0xb7, 0xec, 0x34, 0x82, 0xa6, 0x5b, 0x56, 0x7b, 0xad, 0xd5, 0xd2, 0x29, 0x27, 0xf0, 0xbc,
	0xc0, 0xaf, 0xb4, 0x56, 0x2b, 0xea, 0x4b, 0x19, 0x94, 0x6e, 0xd6, 0x29, 0xdf, 0x6f, 0xee, 0x96,
	0x9d, 0xc0, 0xab, 0xd4, 0x83, 0x06, 0xf6, 0xeb, 0x15, 0xb9, 0xb1, 0xdb, 0xdc, 0xab, 0x84, 0xbc,
	0x1d, 0x12, 0x56, 0xe1, 0xd4, 0x23, 0x8c, 0x63, 0x2f, 0x3c, 0xfc, 0x8a, 0x8d, 0xcf, 0xd6, 0x83,
	0xa0, 0xde, 0x20, 0x15, 0x1c, 0xd2, 0x0a, 0xf6, 0xfd, 0x80, 0x63, 0x4e, 0x03, 0x9f, 0xa9, 0x5d,
	0xeb, 0x83, 0x31, 0x18, 0xdf, 0x10, 0xf7, 0x3f, 0x08, 0xea, 0xa8, 0x08, 0x39, 0xea, 0x9a, 0xc6,
	0x9c, 0xb1, 0x94, 0xb7, 0x73, 0xd4, 0x45, 0x7f, 0x85, 0xa1, 0x66, 0xd4, 0x30, 0x73, 0x52, 0x20,
	0x3e, 0x11, 0x82, 0x61, 0x1f, 0x7b, 0xc4, 0x1c, 0x92, 0x22, 0xf9, 0x8d, 0xe6, 0xa0, 0xe0, 0x12,
	0xe6, 0x44, 0x34, 0x14, 0x07, 0x9b, 0xc3, 0x72, 0xab, 0x5b, 0x84, 0xae, 0x03, 0x38, 0x11, 0xc1,
	0x9c, 0xb8, 0x35, 0xcc, 0xcd, 0x91, 0x39, 0x63, 0xa9, 0xb0, 0x56, 0x2a, 0x2b, 0x5c, 0x65, 0xfd,
	0x92, 0xf2, 0x63, 0x0d, 0xdc, 0xce, 0xc7, 0xda, 0x1b, 0x5c, 0x98, 0xba, 0xa4, 0x41, 0x62, 0xd3,
	0xd1, 0x74, 0xd3, 0x58, 0x7b, 0x83, 0xa3, 0xbf, 0x03, 0x50, 0x56, 0x8b, 0xd7, 0xe6, 0xd8, 0x9c,
	0xb1, 0x34, 0x6e, 0xe7, 0x29, 0xdb, 0x56, 0x02, 0x64, 0xc1, 0xa4, 0x06, 0xb5, 0xdb, 0xae, 0x51,
	0xd7, 0x1c, 0x57, 0xc0, 0x63, 0xe1, 0x66, 0xbb, 0xea, 0xa2, 0x45, 0x38, 0x11, 0x44, 0x75, 0xec,
	0xd3, 0x67, 0xd2, 0x69, 0x42, 0x2b, 0x2f, 0xb5, 0x8a, 0xdd, 0xe2, 0xaa, 0xdb, 0xb9, 0x6b, 0x0f,
	0x37, 0x1b, 0xdc, 0x84, 0xc3, 0xbb, 0xa4, 0x00, 0x3d, 0x84, 0x09, 0x97, 0x30, 0x4e, 0x7d, 0xe5,
	0x7b, 0xd3, 0x9d, 0x1b, 0x5a, 0x2a, 0xac, 0xad, 0x94, 0x13, 0x88, 0x50, 0xd6, 0x11, 0x29, 0x6f,
	0x1f, 0x5a, 0xd9, 0x3d, 0x47, 0x94, 0xbe, 0xcc, 0xc1, 0xd4, 0x7d, 0xce, 0x43, 0xb6, 0x13, 0x30,
	0xfe, 0x88, 0x70, 0x4e, 0xfd, 0x3a, 0xd3, 0x11, 0x33, 0x0e, 0x23, 0xb6, 0x0a, 0x27, 0x79, 0xd4,
	0x64, 0xe2, 0x99, 0x8c, 0x44, 0x2d, 0x12, 0xd5, 0x1c, 0x5c, 0x0b, 0x89, 0x17, 0x47, 0x15, 0xc5,
	0x9b, 0x8f, 0xe4, 0xde, 0x16, 0xde, 0x21, 0x1e, 0xba, 0x0a, 0xa7, 0x9c, 0x06, 0x25, 0x3e, 0xaf,
	0x39, 0x24, 0xe2, 0x74, 0x8f, 0x3a, 0x98, 0x13, 0x69, 0xa3, 0xc2, 0x3e, 0xad, 0x76, 0xb7, 0x0e,
	0x37, 0x85, 0xd5, 0x05, 0x28, 0xc6, 0x56, 0x4f, 0x49, 0x5b, 0x6a, 0x2b, 0x26, 0x4c, 0x28, 0xe9,
	0x7f, 0x48, 0x5b, 0x68, 0x6d, 0xc2, 0xd8, 0x3e, 0xc1, 0x2e, 0x89, 0x98, 0x39, 0x22, 0x9d, 0xb0,
	0x94, 0xee, 0x84, 0xfb, 0xd2, 0xc0, 0xd6, 0x86, 0x22, 0x2a, 0xe4, 0x3d, 0xa7, 0xd1, 0x74, 0x89,
	0x5b, 0xe3, 0x41, 0x48, 0x1d, 0xe5, 0xd0, 0xbc, 0x5d, 0xd4, 0xe2, 0xc7, 0x52, 0x5a, 0xba, 0x0c,
	0xa3, 0xca, 0x56, 0xf8, 0xe5, 0x29, 0x69, 0x6b, 0xbf, 0x3c, 0x25, 0x6d, 0x34, 0x0d, 0x23, 0x2d,
	0xdc, 0x68, 0x92, 0xd8, 0x0f, 0x6a, 0x51, 0x62, 0x50, 0xe8, 0x72, 0xb9, 0xa0, 0xbb, 0x48, 0xaf,
	0xd8, 0x4e, 0x7e, 0xa3, 0x1d, 0xc8, 0xef, 0x73, 0x1e, 0xd6, 0xc2, 0x80, 0xa9, 0x48, 0x17, 0xd6,
	0xae, 0x64, 0x78, 0x43, 0x7f, 0xa8, 0xec, 0x71, 0x71, 0x8a, 0x90, 0x58, 0xf7, 0x60, 0x42, 0xeb,
	0x3d, 0xa0, 0x8c, 0xa3, 0x75, 0x18, 0xa1, 0x9c, 0x78, 0xcc, 0x34, 0xa4, 0x87, 0xe6, 0x53, 0x4f,
	0xb7, 0x95, 0xbe, 0xf5, 0x8d, 0x01, 0xd3, 0xe2, 0x04, 0x2d, 0x67, 0x36, 0x79, 0xb7, 0x49, 0x18,
	0x1f, 0xc4, 0x63, 0x63, 0x20, 0x8f, 0x17, 0xe1, 0x04, 0xf5, 0xa5, 0x0f, 0x3b, 0x89, 0x93, 0x93,
	0x64, 0x2e, 0xc6, 0x62, 0x9d, 0x3d, 0x77, 0x60, 0x2c, 0x08, 0x15, 0x99, 0x95, 0x0f, 0x16, 0xfa,
	0x51, 0xc6, 0x15, 0xac, 0xb5, 0x5a, 0x16, 0x90, 0xfe, 0xa7, 0x94, 0x6d, 0x6d, 0x65, 0x7d, 0x34,
	0x04, 0x27, 0x34, 0xce, 0x8d, 0xc8, 0xd9, 0xa7, 0x2d, 0x92, 0xa1, 0xfe, 0xf4, 0x56, 0x92, 0xa1,
	0x37, 0xaf, 0x24, 0xc3, 0x6f, 0x5e, 0x49, 0x46, 0xfa, 0x2b, 0xc9, 0xb9, 0xb8, 0xbc, 0x37, 0x82,
	0xba, 0xf0, 0xec, 0xa8, 0x84, 0x0b, 0x5a, 0x54, 0x75, 0xd1, 0x79, 0x98, 0x74, 0x49, 0xd8, 0x08,
	0xda, 0x9e, 0x48, 0x0f, 0xaa, 0x8a, 0x51, 0x5e, 0x24, 0xb4, 0x16, 0x56, 0x65, 0x3d, 0x62, 0xf4,
	0x19, 0xa9, 0x51, 0xbf, 0xb6, 0xdb, 0xe6, 0x84, 0xc9, 0x7a, 0x34, 0x6c, 0x17, 0x84, 0xb0, 0xea,
	0x6f, 0x0a, 0x11, 0xb2, 0xc1, 0xec, 0xd1, 0xa9, 0x39, 0xfb, 0xd8, 0xaf, 0xab, 0x17, 0xe5, 0x53,
	0x5f, 0x34, 0xdd, 0x75, 0xd4, 0x96, 0x32, 0xdc, 0xe0, 0xd6, 0x13, 0xf8, 0x5b, 0x5f, 0x1c, 0x24,
	0x09, 0x6f, 0xf7, 0x92, 0x30, 0x3d, 0x4d, 0x63, 0x63, 0xcd, 0xc5, 0xaf, 0x0d, 0x98, 0xe9, 0xe6,
	0x62, 0xbc, 0xdd, 0xa1, 0x64, 0x9f, 0xd3, 0x8c, 0xd7, 0x9c, 0xf6, 0xe7, 0x51, 0xf1, 0x87, 0x21,
	0x98, 0xd4, 0x30, 0xef, 0xb6, 0x88, 0xcf, 0xd1, 0x35, 0xc8, 0x77, 0xda, 0xa8, 0x84, 0x96, 0x42,
	0x95, 0x8e, 0xb2, 0x28, 0x2b, 0xb2, 0x24, 0xe9, 0xb2, 0x22, 0x17, 0x82, 0x40, 0x61, 0x14, 0xbc,
	0x43, 0x1c, 0x19, 0x7d, 0x55, 0x45, 0xf3, 0xb1, 0x64, 0x10, 0x3f, 0x86, 0x07, 0xf0, 0x63, 0x06,
	0xf2, 0x71, 0x01, 0xa7, 0x8a, 0x83, 0x79, 0x7b, 0x5c, 0x09, 0xaa, 0x92, 0x82, 0xd4, 0x67, 0x1c,
	0xfb, 0x0e, 0xe9, 0xa2, 0xa0, 0x16, 0x55, 0x5d, 0x54, 0x82, 0x71, 0x26, 0x3c, 0xef, 0x3b, 0x44,
	0xb2, 0x6f, 0xd8, 0xee, 0xac, 0xd1, 0x69, 0x18, 0x6b, 0x32, 0x75, 0xae, 0xea, 0x81, 0xa3, 0x62,
	0xa9, 0x8c, 0x5c, 0xcc, 0xf1, 0x2e, 0x66, 0x24, 0xee, 0x7b, 0x9d, 0xb5, 0x80, 0x13, 0x97, 0x7b,
	0x1a, 0x4a, 0xbf, 0xe7, 0xed, 0x71, 0x25, 0xa8, 0x86, 0xe8, 0x22, 0x14, 0x71, 0x93, 0xef, 0x13,
	0x9f, 0x8b, 0xf6, 0x20, 0xa6, 0x82, 0x82, 0x2a, 0x37, 0xbd, 0x52, 0x64, 0xc2, 0x98, 0x47, 0x18,
	0xc3, 0x75, 0x62, 0x4e, 0x48, 0x05, 0xbd, 0x44, 0x2b, 0x80, 0x34, 0x17, 0xb0, 0x62, 0x8e, 0x80,
	0x37, 0x29, 0x95, 0xa6, 0xfa, 0x76, 0xaa, 0xae, 0xf5, 0x10, 0xa6, 0x7a, 0x22, 0x28, 0x29, 0x7c,
	0xab, 0x97, 0xc2, 0x17, 0x53, 0x29, 0x2c, 0x4d, 0x35, 0x81, 0xbf, 0xcb, 0x81, 0x79, 0x8f, 0xf0,
	0x9e, 0xbd, 0xec, 0xec, 0x1d, 0x8c, 0x3f, 0x97, 0x80, 0x1f, 0x95, 0x61, 0x78, 0x2f, 0x0a, 0xbc,
	0x0c, 0x15, 0x4d, 0xea, 0xa1, 0x65, 0xc8, 0xf1, 0x20, 0x43, 0x11, 0xcb, 0xf1, 0xa0, 0x2b, 0x91,
	0x3a, 0xed, 0x72, 0x44, 0xb5, 0x4b, 0x2d, 0x56, 0xed, 0x72, 0x50, 0x5f, 0x1d, 0x1d, 0xd4, 0x57,
	0x05, 0xc9, 0x1b, 0xd4, 0xa3, 0xaa, 0xfd, 0x8d, 0xd8, 0x6a, 0x61, 0xbd, 0x00, 0x4b, 0xa5, 0x64,
	0x5f, 0xca, 0xf7, 0x7a, 0x6e, 0xb0, 0x63, 0x8c, 0x24, 0xc7, 0xa8, 0x87, 0xe6, 0xb2, 0x3c, 0xd4,
	0x7a, 0x1b, 0x66, 0x37, 0x38, 0xc7, 0xce, 0xfe, 0x8e, 0xca, 0xac, 0xc7, 0x41, 0xa7, 0x41, 0xc6,
	0x97, 0xf7, 0xe6, 0xa1, 0xd1, 0x9f, 0x87, 0x7d, 0x51, 0xcd, 0xf5, 0x47, 0x75, 0xed, 0xe3, 0xa9,
	0xb8, 0x55, 0x8b, 0x71, 0x89, 0x3a, 0x04, 0xb5, 0x60, 0x52, 0x70, 0x64, 0xa7, 0xfa, 0x7f, 0x12,
	0x31, 0xc1, 0xe8, 0x73, 0xc9, 0xb5, 0xe7, 0xae, 0x17, 0xf2, 0x76, 0x69, 0x3e, 0x59, 0x21, 0x3e,
	0xc3, 0x9a, 0xff, 0xf0, 0x97, 0xdf, 0x3f, 0xcd, 0xcd, 0xa0, 0x33, 0x6a, 0x66, 0x17, 0xf7, 0x89,
	0x9f, 0x04, 0x38, 0xa4, 0x2b, 0xad, 0xf8, 0x9a, 0xaf, 0x0c, 0x98, 0xec, 0xe9, 0xf4, 0x28, 0x79,
	0x98, 0x1c, 0x34, 0x11, 0x94, 0x16, 0x52, 0x93, 0x41, 0x98, 0x59, 0x77, 0x24, 0x94, 0xeb, 0x68,
	0xbd, 0x17, 0x4a, 0xf7, 0xd4, 0xc0, 0x2a, 0xcf, 0xfb, 0x66, 0x8b, 0x83, 0x8a, 0x76, 0x19, 0x43,
	0xcf, 0xa1, 0xd0, 0x95, 0x44, 0xe8, 0x7c, 0xf2, 0xeb, 0xab, 0xdb, 0x71, 0x61, 0x2e, 0xa5, 0x0f,
	0x3c, 0xd6, 0x05, 0x89, 0x6b, 0x16, 0x9d, 0xed, 0x73, 0x91, 0xbe, 0xb7, 0xf2, 0x9c, 0xba, 0x07,
	0xe8, 0x0b, 0x03, 0x8a, 0x5b, 0x72, 0x00, 0xe8, 0x00, 0x48, 0x3f, 0x3b, 0xcb, 0xf5, 0x9b, 0xf2,
	0xfa, 0x5b, 0xd6, 0x9b, 0xba, 0xe5, 0x86, 0xb1, 0x8c, 0x5e, 0x40, 0xf1, 0x49, 0xe8, 0x1e, 0x3f,
	0xb6, 0x45, 0x89, 0x6d, 0x7e, 0xed, 0x48, 0xd7, 0x08, 0x00, 0xef, 0x43, 0xb1, 0x37, 0x5f, 0xb3,
	0x45, 0x27, 0x8d, 0xe1, 0x3a, 0x36, 0xcb, 0x47, 0xc7, 0xe6, 0xfb, 0xbe, 0x59, 0x55, 0xcf, 0x07,
	0xe8, 0x6a, 0x26, 0x22, 0xf7, 0x8d, 0x13, 0xa5, 0x4b, 0x59, 0xe7, 0x13, 0x49, 0xeb, 0xdb, 0x12,
	0xe2, 0x35, 0xf4, 0xaf, 0x44, 0x88, 0x5d, 0x75, 0xe0, 0x30, 0x6e, 0x58, 0x63, 0x7c, 0x69, 0x00,
	0xea, 0xa2, 0xb5, 0x9e, 0x5f, 0x33, 0xf9, 0x2f, 0xf3, 0x24, 0x65, 0xfd, 0x53, 0xa2, 0x5c, 0x40,
	0xe7, 0x07, 0xa3, 0xd4, 0x68, 0x94, 0x3f, 0x3f, 0x31, 0xe0, 0xe4, 0xc0, 0xf2, 0x7b, 0x4c, 0x51,
	0x8d, 0xc1, 0x2c, 0x67, 0x02, 0xf3, 0xa3, 0x01, 0x33, 0x47, 0xf4, 0x02, 0x74, 0x33, 0xd1, 0x07,
	0xe9, 0x1d, 0x24, 0x1d, 0xea, 0x5d, 0x09, 0xf5, 0xce, 0xf2, 0x8d, 0x34, 0xa8, 0xaf, 0x37, 0xa2,
	0x83, 0x0a, 0x91, 0x77, 0x89, 0xfc, 0xf8, 0xd6, 0x80, 0xa9, 0xd7, 0x06, 0x00, 0xb4, 0x9a, 0x08,
	0x3d, 0x69, 0x58, 0x28, 0x2d, 0x67, 0x1b, 0x3c, 0x24, 0x33, 0xd7, 0x25, 0xf6, 0x55, 0xeb, 0x52,
	0x36, 0x66, 0x76, 0xd0, 0x5e, 0x36, 0xd0, 0x67, 0x06, 0x9c, 0xed, 0x26, 0xa5, 0x6c, 0x85, 0xa2,
	0x67, 0xc7, 0xed, 0xf0, 0xd8, 0x8a, 0xef, 0x25, 0x89, 0xf1, 0x22, 0xba, 0xd0, 0x8b, 0x31, 0xee,
	0xa3, 0x8a, 0x02, 0x1d, 0xc4, 0x82, 0x0b, 0xa7, 0x13, 0xda, 0x32, 0x5a, 0x4f, 0xbe, 0xec, 0xc8,
	0x46, 0x9e, 0xce, 0x81, 0xff, 0x4a, 0x8c, 0xf7, 0xac, 0xcd, 0x24, 0x8c, 0x87, 0x73, 0xc0, 0x41,
	0x72, 0xde, 0x4b, 0x10, 0x82, 0x0b, 0x2f, 0x0d, 0x38, 0xb3, 0x4d, 0xba, 0x20, 0xfd, 0x3b, 0x0a,
	0xbc, 0x63, 0xae, 0x9b, 0x2b, 0x12, 0xf2, 0xe2, 0xf2, 0x42, 0x16, 0xb7, 0xb2, 0xcd, 0x9b, 0x3f,
	0xbd, 0x9a, 0x35, 0x7e, 0x7e, 0x35, 0x6b, 0xfc, 0xfa, 0x6a, 0xd6, 0xf8, 0xfc, 0xb7, 0xd9, 0xbf,
	0xbc, 0xf5, 0x8f, 0xae, 0xbf, 0x09, 0xf5, 0x5d, 0x2b, 0x1e, 0xf6, 0x71, 0x9d, 0xb8, 0xe2, 0x4c,
	0xd6, 0x39, 0x74, 0x77, 0x54, 0x8e, 0x50, 0x57, 0xfe, 0x08, 0x00, 0x00, 0xff, 0xff, 0x35, 0x98,
	0x5e, 0xe3, 0x98, 0x14, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AuditServiceClient is the client API for AuditService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AuditServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all audit logs in the organization identified by the given ID.
	// Required permissions:
	// - audit.auditlog.list on the organization identified by the given ID.
	ListAuditLogs(ctx context.Context, in *ListAuditLogsRequest, opts ...grpc.CallOption) (*AuditLogList, error)
	// Fetch a specific AuditLog identified by the given ID.
	// Required permissions:
	// - audit.auditlog.get on the audit log identified by the given ID.
	GetAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLog, error)
	// Create a new audit log.
	// Required permissions:
	// - audit.auditlog.create on the organization identified by the given ID.
	CreateAuditLog(ctx context.Context, in *AuditLog, opts ...grpc.CallOption) (*AuditLog, error)
	// Update an audit log.
	// Required permissions:
	// - audit.auditlog.update on the audit log identified by the given ID.
	UpdateAuditLog(ctx context.Context, in *AuditLog, opts ...grpc.CallOption) (*AuditLog, error)
	// Delete an audit log.
	// Note that audit logs are initially only marked for deleted.
	// Once all their resources are removed the audit log itself is deleted
	// and cannot be restored.
	// Note that deleting an AuditLog will detach it from all Projects that
	// it was attached to.
	// Required permissions:
	// - audit.auditlog.delete on the audit log.
	DeleteAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch all audit log archives in the audit log identified by the given ID.
	// Required permissions:
	// - audit.auditlogarchive.list on the audit log identified by the given ID.
	ListAuditLogArchives(ctx context.Context, in *ListAuditLogArchivesRequest, opts ...grpc.CallOption) (*AuditLogArchiveList, error)
	// Fetch a specific AuditLogArchive identified by the given ID.
	// Required permissions:
	// - audit.auditlogarchive.get on the audit log archive identified by the given ID.
	GetAuditLogArchive(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLogArchive, error)
	// Delete an audit log archive.
	// Note that this method will return a precondition-failed error
	// if there is a non-deleted deployment using this archive.
	// Note that audit log archives are initially only marked for deleted.
	// Once all their resources are removed the audit log archive itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - audit.auditlogarchive.delete on the audit log archive.
	DeleteAuditLogArchive(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Remove all audit events that match the given filter from the AuditLogArchive
	// identified by the given ID.
	// Note that this method will return a precondition-failed error
	// if there is no destination of type "cloud" in the AuditLog.
	// Required permissions:
	// - audit.auditlogevent.delete on the audit log archive identified by the given ID.
	DeleteAuditLogArchiveEvents(ctx context.Context, in *DeleteAuditLogArchiveEventsRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch all audit events that match the given filter.
	// Note that this method will return a precondition-failed error
	// if there is no destination of type "cloud" in the AuditLog.
	// Required permissions:
	// - audit.auditlogevents.get on the audit log identified by the given ID.
	GetAuditLogEvents(ctx context.Context, in *GetAuditLogEventsRequest, opts ...grpc.CallOption) (AuditService_GetAuditLogEventsClient, error)
	// Fetch the AuditLog that is attached to the project identified by the given ID.
	// If no AuditLog is attached to the project, a not-found error is returned.
	// Required permissions:
	// - audit.auditlogattachment.get on the project identified by the given ID.
	GetAuditLogAttachedToProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLog, error)
	// Attach the AuditLog identified by given ID to the project identified with given ID.
	// This replaces any existing AuditLog attachment for the project.
	// Required permissions:
	// - audit.auditlogattachment.create on the project identified by the given ID.
	AttachProjectToAuditLog(ctx context.Context, in *AttachProjectToAuditLogRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Detach the current AuditLog from the project identified with given ID.
	// After a detachment, no audit events in the context of the project will be sent
	// to an AuditLog.
	// Required permissions:
	// - audit.auditlogattachment.delete on the project identified by the given ID.
	DetachProjectFromAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
}

type auditServiceClient struct {
	cc *grpc.ClientConn
}

func NewAuditServiceClient(cc *grpc.ClientConn) AuditServiceClient {
	return &auditServiceClient{cc}
}

func (c *auditServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) ListAuditLogs(ctx context.Context, in *ListAuditLogsRequest, opts ...grpc.CallOption) (*AuditLogList, error) {
	out := new(AuditLogList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/ListAuditLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) GetAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLog, error) {
	out := new(AuditLog)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/GetAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) CreateAuditLog(ctx context.Context, in *AuditLog, opts ...grpc.CallOption) (*AuditLog, error) {
	out := new(AuditLog)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/CreateAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) UpdateAuditLog(ctx context.Context, in *AuditLog, opts ...grpc.CallOption) (*AuditLog, error) {
	out := new(AuditLog)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/UpdateAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) DeleteAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) ListAuditLogArchives(ctx context.Context, in *ListAuditLogArchivesRequest, opts ...grpc.CallOption) (*AuditLogArchiveList, error) {
	out := new(AuditLogArchiveList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/ListAuditLogArchives", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) GetAuditLogArchive(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLogArchive, error) {
	out := new(AuditLogArchive)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/GetAuditLogArchive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) DeleteAuditLogArchive(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLogArchive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) DeleteAuditLogArchiveEvents(ctx context.Context, in *DeleteAuditLogArchiveEventsRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLogArchiveEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) GetAuditLogEvents(ctx context.Context, in *GetAuditLogEventsRequest, opts ...grpc.CallOption) (AuditService_GetAuditLogEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AuditService_serviceDesc.Streams[0], "/arangodb.cloud.audit.v1.AuditService/GetAuditLogEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &auditServiceGetAuditLogEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AuditService_GetAuditLogEventsClient interface {
	Recv() (*AuditLogEventList, error)
	grpc.ClientStream
}

type auditServiceGetAuditLogEventsClient struct {
	grpc.ClientStream
}

func (x *auditServiceGetAuditLogEventsClient) Recv() (*AuditLogEventList, error) {
	m := new(AuditLogEventList)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *auditServiceClient) GetAuditLogAttachedToProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLog, error) {
	out := new(AuditLog)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/GetAuditLogAttachedToProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) AttachProjectToAuditLog(ctx context.Context, in *AttachProjectToAuditLogRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/AttachProjectToAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) DetachProjectFromAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/DetachProjectFromAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AuditServiceServer is the server API for AuditService service.
type AuditServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all audit logs in the organization identified by the given ID.
	// Required permissions:
	// - audit.auditlog.list on the organization identified by the given ID.
	ListAuditLogs(context.Context, *ListAuditLogsRequest) (*AuditLogList, error)
	// Fetch a specific AuditLog identified by the given ID.
	// Required permissions:
	// - audit.auditlog.get on the audit log identified by the given ID.
	GetAuditLog(context.Context, *v1.IDOptions) (*AuditLog, error)
	// Create a new audit log.
	// Required permissions:
	// - audit.auditlog.create on the organization identified by the given ID.
	CreateAuditLog(context.Context, *AuditLog) (*AuditLog, error)
	// Update an audit log.
	// Required permissions:
	// - audit.auditlog.update on the audit log identified by the given ID.
	UpdateAuditLog(context.Context, *AuditLog) (*AuditLog, error)
	// Delete an audit log.
	// Note that audit logs are initially only marked for deleted.
	// Once all their resources are removed the audit log itself is deleted
	// and cannot be restored.
	// Note that deleting an AuditLog will detach it from all Projects that
	// it was attached to.
	// Required permissions:
	// - audit.auditlog.delete on the audit log.
	DeleteAuditLog(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch all audit log archives in the audit log identified by the given ID.
	// Required permissions:
	// - audit.auditlogarchive.list on the audit log identified by the given ID.
	ListAuditLogArchives(context.Context, *ListAuditLogArchivesRequest) (*AuditLogArchiveList, error)
	// Fetch a specific AuditLogArchive identified by the given ID.
	// Required permissions:
	// - audit.auditlogarchive.get on the audit log archive identified by the given ID.
	GetAuditLogArchive(context.Context, *v1.IDOptions) (*AuditLogArchive, error)
	// Delete an audit log archive.
	// Note that this method will return a precondition-failed error
	// if there is a non-deleted deployment using this archive.
	// Note that audit log archives are initially only marked for deleted.
	// Once all their resources are removed the audit log archive itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - audit.auditlogarchive.delete on the audit log archive.
	DeleteAuditLogArchive(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Remove all audit events that match the given filter from the AuditLogArchive
	// identified by the given ID.
	// Note that this method will return a precondition-failed error
	// if there is no destination of type "cloud" in the AuditLog.
	// Required permissions:
	// - audit.auditlogevent.delete on the audit log archive identified by the given ID.
	DeleteAuditLogArchiveEvents(context.Context, *DeleteAuditLogArchiveEventsRequest) (*v1.Empty, error)
	// Fetch all audit events that match the given filter.
	// Note that this method will return a precondition-failed error
	// if there is no destination of type "cloud" in the AuditLog.
	// Required permissions:
	// - audit.auditlogevents.get on the audit log identified by the given ID.
	GetAuditLogEvents(*GetAuditLogEventsRequest, AuditService_GetAuditLogEventsServer) error
	// Fetch the AuditLog that is attached to the project identified by the given ID.
	// If no AuditLog is attached to the project, a not-found error is returned.
	// Required permissions:
	// - audit.auditlogattachment.get on the project identified by the given ID.
	GetAuditLogAttachedToProject(context.Context, *v1.IDOptions) (*AuditLog, error)
	// Attach the AuditLog identified by given ID to the project identified with given ID.
	// This replaces any existing AuditLog attachment for the project.
	// Required permissions:
	// - audit.auditlogattachment.create on the project identified by the given ID.
	AttachProjectToAuditLog(context.Context, *AttachProjectToAuditLogRequest) (*v1.Empty, error)
	// Detach the current AuditLog from the project identified with given ID.
	// After a detachment, no audit events in the context of the project will be sent
	// to an AuditLog.
	// Required permissions:
	// - audit.auditlogattachment.delete on the project identified by the given ID.
	DetachProjectFromAuditLog(context.Context, *v1.IDOptions) (*v1.Empty, error)
}

// UnimplementedAuditServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAuditServiceServer struct {
}

func (*UnimplementedAuditServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedAuditServiceServer) ListAuditLogs(ctx context.Context, req *ListAuditLogsRequest) (*AuditLogList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuditLogs not implemented")
}
func (*UnimplementedAuditServiceServer) GetAuditLog(ctx context.Context, req *v1.IDOptions) (*AuditLog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) CreateAuditLog(ctx context.Context, req *AuditLog) (*AuditLog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) UpdateAuditLog(ctx context.Context, req *AuditLog) (*AuditLog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) DeleteAuditLog(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) ListAuditLogArchives(ctx context.Context, req *ListAuditLogArchivesRequest) (*AuditLogArchiveList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuditLogArchives not implemented")
}
func (*UnimplementedAuditServiceServer) GetAuditLogArchive(ctx context.Context, req *v1.IDOptions) (*AuditLogArchive, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuditLogArchive not implemented")
}
func (*UnimplementedAuditServiceServer) DeleteAuditLogArchive(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuditLogArchive not implemented")
}
func (*UnimplementedAuditServiceServer) DeleteAuditLogArchiveEvents(ctx context.Context, req *DeleteAuditLogArchiveEventsRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuditLogArchiveEvents not implemented")
}
func (*UnimplementedAuditServiceServer) GetAuditLogEvents(req *GetAuditLogEventsRequest, srv AuditService_GetAuditLogEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetAuditLogEvents not implemented")
}
func (*UnimplementedAuditServiceServer) GetAuditLogAttachedToProject(ctx context.Context, req *v1.IDOptions) (*AuditLog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuditLogAttachedToProject not implemented")
}
func (*UnimplementedAuditServiceServer) AttachProjectToAuditLog(ctx context.Context, req *AttachProjectToAuditLogRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachProjectToAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) DetachProjectFromAuditLog(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachProjectFromAuditLog not implemented")
}

func RegisterAuditServiceServer(s *grpc.Server, srv AuditServiceServer) {
	s.RegisterService(&_AuditService_serviceDesc, srv)
}

func _AuditService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_ListAuditLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuditLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).ListAuditLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/ListAuditLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).ListAuditLogs(ctx, req.(*ListAuditLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_GetAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).GetAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/GetAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).GetAuditLog(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_CreateAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuditLog)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).CreateAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/CreateAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).CreateAuditLog(ctx, req.(*AuditLog))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_UpdateAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuditLog)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).UpdateAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/UpdateAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).UpdateAuditLog(ctx, req.(*AuditLog))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_DeleteAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).DeleteAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).DeleteAuditLog(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_ListAuditLogArchives_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuditLogArchivesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).ListAuditLogArchives(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/ListAuditLogArchives",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).ListAuditLogArchives(ctx, req.(*ListAuditLogArchivesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_GetAuditLogArchive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).GetAuditLogArchive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/GetAuditLogArchive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).GetAuditLogArchive(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_DeleteAuditLogArchive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).DeleteAuditLogArchive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLogArchive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).DeleteAuditLogArchive(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_DeleteAuditLogArchiveEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAuditLogArchiveEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).DeleteAuditLogArchiveEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLogArchiveEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).DeleteAuditLogArchiveEvents(ctx, req.(*DeleteAuditLogArchiveEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_GetAuditLogEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetAuditLogEventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AuditServiceServer).GetAuditLogEvents(m, &auditServiceGetAuditLogEventsServer{stream})
}

type AuditService_GetAuditLogEventsServer interface {
	Send(*AuditLogEventList) error
	grpc.ServerStream
}

type auditServiceGetAuditLogEventsServer struct {
	grpc.ServerStream
}

func (x *auditServiceGetAuditLogEventsServer) Send(m *AuditLogEventList) error {
	return x.ServerStream.SendMsg(m)
}

func _AuditService_GetAuditLogAttachedToProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).GetAuditLogAttachedToProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/GetAuditLogAttachedToProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).GetAuditLogAttachedToProject(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_AttachProjectToAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachProjectToAuditLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).AttachProjectToAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/AttachProjectToAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).AttachProjectToAuditLog(ctx, req.(*AttachProjectToAuditLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_DetachProjectFromAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).DetachProjectFromAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/DetachProjectFromAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).DetachProjectFromAuditLog(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _AuditService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.audit.v1.AuditService",
	HandlerType: (*AuditServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _AuditService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListAuditLogs",
			Handler:    _AuditService_ListAuditLogs_Handler,
		},
		{
			MethodName: "GetAuditLog",
			Handler:    _AuditService_GetAuditLog_Handler,
		},
		{
			MethodName: "CreateAuditLog",
			Handler:    _AuditService_CreateAuditLog_Handler,
		},
		{
			MethodName: "UpdateAuditLog",
			Handler:    _AuditService_UpdateAuditLog_Handler,
		},
		{
			MethodName: "DeleteAuditLog",
			Handler:    _AuditService_DeleteAuditLog_Handler,
		},
		{
			MethodName: "ListAuditLogArchives",
			Handler:    _AuditService_ListAuditLogArchives_Handler,
		},
		{
			MethodName: "GetAuditLogArchive",
			Handler:    _AuditService_GetAuditLogArchive_Handler,
		},
		{
			MethodName: "DeleteAuditLogArchive",
			Handler:    _AuditService_DeleteAuditLogArchive_Handler,
		},
		{
			MethodName: "DeleteAuditLogArchiveEvents",
			Handler:    _AuditService_DeleteAuditLogArchiveEvents_Handler,
		},
		{
			MethodName: "GetAuditLogAttachedToProject",
			Handler:    _AuditService_GetAuditLogAttachedToProject_Handler,
		},
		{
			MethodName: "AttachProjectToAuditLog",
			Handler:    _AuditService_AttachProjectToAuditLog_Handler,
		},
		{
			MethodName: "DetachProjectFromAuditLog",
			Handler:    _AuditService_DetachProjectFromAuditLog_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetAuditLogEvents",
			Handler:       _AuditService_GetAuditLogEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "audit.proto",
}

func (m *AuditLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Destinations) > 0 {
		for iNdEx := len(m.Destinations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Destinations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xa2
		}
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x42
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLog_HttpsPostSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog_HttpsPostSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog_HttpsPostSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExcludedTopics) > 0 {
		for iNdEx := len(m.ExcludedTopics) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExcludedTopics[iNdEx])
			copy(dAtA[i:], m.ExcludedTopics[iNdEx])
			i = encodeVarintAudit(dAtA, i, uint64(len(m.ExcludedTopics[iNdEx])))
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xa2
		}
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.ClientKeyPem) > 0 {
		i -= len(m.ClientKeyPem)
		copy(dAtA[i:], m.ClientKeyPem)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ClientKeyPem)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClientCertificatePem) > 0 {
		i -= len(m.ClientCertificatePem)
		copy(dAtA[i:], m.ClientCertificatePem)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ClientCertificatePem)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.TrustedServerCaPem) > 0 {
		i -= len(m.TrustedServerCaPem)
		copy(dAtA[i:], m.TrustedServerCaPem)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.TrustedServerCaPem)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLog_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog_Header) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog_Header) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLog_Destination) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog_Destination) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog_Destination) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HttpPost != nil {
		{
			size, err := m.HttpPost.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListAuditLogsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAuditLogsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAuditLogsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.IncludeDeleted {
		i--
		if m.IncludeDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogArchive) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogArchive) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogArchive) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SizeInBytesChangedAt != nil {
		{
			size, err := m.SizeInBytesChangedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.SizeInBytes != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.SizeInBytes))
		i--
		dAtA[i] = 0x40
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0x32
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogArchiveList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogArchiveList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogArchiveList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListAuditLogArchivesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAuditLogArchivesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAuditLogArchivesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.IncludeDeleted {
		i--
		if m.IncludeDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AuditlogarchiveId) > 0 {
		i -= len(m.AuditlogarchiveId)
		copy(dAtA[i:], m.AuditlogarchiveId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogarchiveId)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.Authentication) > 0 {
		i -= len(m.Authentication)
		copy(dAtA[i:], m.Authentication)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Authentication)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ClientIp) > 0 {
		i -= len(m.ClientIp)
		copy(dAtA[i:], m.ClientIp)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ClientIp)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Database) > 0 {
		i -= len(m.Database)
		copy(dAtA[i:], m.Database)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Database)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.UserId) > 0 {
		i -= len(m.UserId)
		copy(dAtA[i:], m.UserId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.UserId)))
		i--
		dAtA[i] = 0x42
	}
	if m.Sequence != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.Sequence))
		i--
		dAtA[i] = 0x38
	}
	if len(m.InstanceId) > 0 {
		i -= len(m.InstanceId)
		copy(dAtA[i:], m.InstanceId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.InstanceId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ServerId) > 0 {
		i -= len(m.ServerId)
		copy(dAtA[i:], m.ServerId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ServerId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != nil {
		{
			size, err := m.Timestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogEventList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogEventList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogEventList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetAuditLogEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetAuditLogEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetAuditLogEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Limit != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x50
	}
	if len(m.ExcludedTopics) > 0 {
		for iNdEx := len(m.ExcludedTopics) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExcludedTopics[iNdEx])
			copy(dAtA[i:], m.ExcludedTopics[iNdEx])
			i = encodeVarintAudit(dAtA, i, uint64(len(m.ExcludedTopics[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.IncludedTopics) > 0 {
		for iNdEx := len(m.IncludedTopics) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.IncludedTopics[iNdEx])
			copy(dAtA[i:], m.IncludedTopics[iNdEx])
			i = encodeVarintAudit(dAtA, i, uint64(len(m.IncludedTopics[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.To != nil {
		{
			size, err := m.To.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.From != nil {
		{
			size, err := m.From.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.AuditlogarchiveId) > 0 {
		i -= len(m.AuditlogarchiveId)
		copy(dAtA[i:], m.AuditlogarchiveId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogarchiveId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeleteAuditLogArchiveEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteAuditLogArchiveEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteAuditLogArchiveEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.To != nil {
		{
			size, err := m.To.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.AuditlogarchiveId) > 0 {
		i -= len(m.AuditlogarchiveId)
		copy(dAtA[i:], m.AuditlogarchiveId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogarchiveId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachProjectToAuditLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachProjectToAuditLogRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachProjectToAuditLogRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAudit(dAtA []byte, offset int, v uint64) int {
	offset -= sovAudit(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *AuditLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IsDefault {
		n += 2
	}
	if len(m.Destinations) > 0 {
		for _, e := range m.Destinations {
			l = e.Size()
			n += 2 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLog_HttpsPostSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.TrustedServerCaPem)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ClientCertificatePem)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ClientKeyPem)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if len(m.ExcludedTopics) > 0 {
		for _, s := range m.ExcludedTopics {
			l = len(s)
			n += 2 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLog_Header) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLog_Destination) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.HttpPost != nil {
		l = m.HttpPost.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAuditLogsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IncludeDeleted {
		n += 2
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogArchive) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.SizeInBytes != 0 {
		n += 1 + sovAudit(uint64(m.SizeInBytes))
	}
	if m.SizeInBytesChangedAt != nil {
		l = m.SizeInBytesChangedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogArchiveList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAuditLogArchivesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IncludeDeleted {
		n += 2
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Topic)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ServerId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.InstanceId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.Sequence != 0 {
		n += 1 + sovAudit(uint64(m.Sequence))
	}
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ClientIp)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Authentication)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.AuditlogarchiveId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogEventList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetAuditLogEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.AuditlogarchiveId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.From != nil {
		l = m.From.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.To != nil {
		l = m.To.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if len(m.IncludedTopics) > 0 {
		for _, s := range m.IncludedTopics {
			l = len(s)
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if len(m.ExcludedTopics) > 0 {
		for _, s := range m.ExcludedTopics {
			l = len(s)
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.Limit != 0 {
		n += 1 + sovAudit(uint64(m.Limit))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteAuditLogArchiveEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AuditlogarchiveId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.To != nil {
		l = m.To.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachProjectToAuditLogRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAudit(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAudit(x uint64) (n int) {
	return sovAudit(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AuditLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destinations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Destinations = append(m.Destinations, &AuditLog_Destination{})
			if err := m.Destinations[len(m.Destinations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLog_HttpsPostSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpsPostSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpsPostSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustedServerCaPem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrustedServerCaPem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertificatePem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertificatePem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientKeyPem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientKeyPem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &AuditLog_Header{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludedTopics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExcludedTopics = append(m.ExcludedTopics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLog_Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLog_Destination) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Destination: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Destination: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpPost", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpPost == nil {
				m.HttpPost = &AuditLog_HttpsPostSettings{}
			}
			if err := m.HttpPost.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &AuditLog{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAuditLogsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAuditLogsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAuditLogsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogArchive) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogArchive: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogArchive: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeInBytes", wireType)
			}
			m.SizeInBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SizeInBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeInBytesChangedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SizeInBytesChangedAt == nil {
				m.SizeInBytesChangedAt = &types.Timestamp{}
			}
			if err := m.SizeInBytesChangedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogArchiveList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogArchiveList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogArchiveList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &AuditLogArchive{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAuditLogArchivesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAuditLogArchivesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAuditLogArchivesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &types.Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Topic = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstanceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstanceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authentication", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Authentication = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogarchiveId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogarchiveId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogEventList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogEventList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogEventList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &AuditLogEvent{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetAuditLogEventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetAuditLogEventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetAuditLogEventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogarchiveId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogarchiveId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.From == nil {
				m.From = &types.Timestamp{}
			}
			if err := m.From.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = &types.Timestamp{}
			}
			if err := m.To.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludedTopics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncludedTopics = append(m.IncludedTopics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludedTopics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExcludedTopics = append(m.ExcludedTopics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteAuditLogArchiveEventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteAuditLogArchiveEventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteAuditLogArchiveEventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogarchiveId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogarchiveId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = &types.Timestamp{}
			}
			if err := m.To.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttachProjectToAuditLogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttachProjectToAuditLogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttachProjectToAuditLogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAudit(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAudit
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthAudit
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAudit
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAudit(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthAudit
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAudit = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAudit   = fmt.Errorf("proto: integer overflow")
)
