// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: example.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// ExampleDataset represents a single example dataaset.
type ExampleDataset struct {
	// System identifier of the example dataset.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource.
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the example dataset
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the example dataset
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Guide contains description of the example dataset including several example queries.
	// Content type of guide is markdown.
	Guide string `protobuf:"bytes,6,opt,name=guide,proto3" json:"guide,omitempty"`
	// The creation timestamp of the example dataset (database object)
	// This is a read-only value.
	CreatedAt            *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *ExampleDataset) Reset()         { *m = ExampleDataset{} }
func (m *ExampleDataset) String() string { return proto.CompactTextString(m) }
func (*ExampleDataset) ProtoMessage()    {}
func (*ExampleDataset) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{0}
}
func (m *ExampleDataset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDataset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDataset.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDataset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDataset.Merge(m, src)
}
func (m *ExampleDataset) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDataset) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDataset.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDataset proto.InternalMessageInfo

func (m *ExampleDataset) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ExampleDataset) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *ExampleDataset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExampleDataset) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *ExampleDataset) GetGuide() string {
	if m != nil {
		return m.Guide
	}
	return ""
}

func (m *ExampleDataset) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

// ExampleDatasetInstallation represents an installation of a dataset initiated by the user.
type ExampleDatasetInstallation struct {
	// System identifier of the installation.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Identifier of the deployment that owns this installation.
	// After creation, this value cannot be changed.
	DeploymentId string `protobuf:"bytes,3,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Identifier of the example dataset which will be installed.
	// After creation, this value cannot be changed.
	ExampledatasetId string `protobuf:"bytes,4,opt,name=exampledataset_id,json=exampledatasetId,proto3" json:"exampledataset_id,omitempty"`
	// The creation timestamp of the installation.
	CreatedAt *types.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the installation
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,6,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this installation is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,7,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Status of the actual installation.
	Status               *ExampleDatasetInstallation_Status `protobuf:"bytes,100,opt,name=status,proto3" json:"status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ExampleDatasetInstallation) Reset()         { *m = ExampleDatasetInstallation{} }
func (m *ExampleDatasetInstallation) String() string { return proto.CompactTextString(m) }
func (*ExampleDatasetInstallation) ProtoMessage()    {}
func (*ExampleDatasetInstallation) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{1}
}
func (m *ExampleDatasetInstallation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDatasetInstallation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDatasetInstallation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDatasetInstallation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDatasetInstallation.Merge(m, src)
}
func (m *ExampleDatasetInstallation) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDatasetInstallation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDatasetInstallation.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDatasetInstallation proto.InternalMessageInfo

func (m *ExampleDatasetInstallation) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ExampleDatasetInstallation) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *ExampleDatasetInstallation) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ExampleDatasetInstallation) GetExampledatasetId() string {
	if m != nil {
		return m.ExampledatasetId
	}
	return ""
}

func (m *ExampleDatasetInstallation) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *ExampleDatasetInstallation) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *ExampleDatasetInstallation) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *ExampleDatasetInstallation) GetStatus() *ExampleDatasetInstallation_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

// Status of the installation.
// All members of this field are read-only.
type ExampleDatasetInstallation_Status struct {
	// Name of the database into which this example dataset was installed.
	DatabaseName string `protobuf:"bytes,1,opt,name=database_name,json=databaseName,proto3" json:"database_name,omitempty"`
	// The state of the installation.
	// Will be one of the following: "InProgress|Create|Ready|Failed"
	State string `protobuf:"bytes,3,opt,name=state,proto3" json:"state,omitempty"`
	// Set when the installation is failed.
	IsFailed bool `protobuf:"varint,4,opt,name=is_failed,json=isFailed,proto3" json:"is_failed,omitempty"`
	// Set when once the installation finished successfully and the dataset is available to be used.
	IsAvailable          bool     `protobuf:"varint,5,opt,name=is_available,json=isAvailable,proto3" json:"is_available,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExampleDatasetInstallation_Status) Reset()         { *m = ExampleDatasetInstallation_Status{} }
func (m *ExampleDatasetInstallation_Status) String() string { return proto.CompactTextString(m) }
func (*ExampleDatasetInstallation_Status) ProtoMessage()    {}
func (*ExampleDatasetInstallation_Status) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{1, 0}
}
func (m *ExampleDatasetInstallation_Status) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDatasetInstallation_Status) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDatasetInstallation_Status.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDatasetInstallation_Status) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDatasetInstallation_Status.Merge(m, src)
}
func (m *ExampleDatasetInstallation_Status) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDatasetInstallation_Status) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDatasetInstallation_Status.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDatasetInstallation_Status proto.InternalMessageInfo

func (m *ExampleDatasetInstallation_Status) GetDatabaseName() string {
	if m != nil {
		return m.DatabaseName
	}
	return ""
}

func (m *ExampleDatasetInstallation_Status) GetState() string {
	if m != nil {
		return m.State
	}
	return ""
}

func (m *ExampleDatasetInstallation_Status) GetIsFailed() bool {
	if m != nil {
		return m.IsFailed
	}
	return false
}

func (m *ExampleDatasetInstallation_Status) GetIsAvailable() bool {
	if m != nil {
		return m.IsAvailable
	}
	return false
}

// ListExampleDatasetsRequest provides an extendable list request for listing datasets.
type ListExampleDatasetsRequest struct {
	// Optional common list options, the context_id is ignored.
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, the result includes all example datasets which are available for the
	// organization identified by this ID.
	// If not set, only datasets are returned that are available to all organizations.
	OrganizationId       string   `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListExampleDatasetsRequest) Reset()         { *m = ListExampleDatasetsRequest{} }
func (m *ListExampleDatasetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListExampleDatasetsRequest) ProtoMessage()    {}
func (*ListExampleDatasetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{2}
}
func (m *ListExampleDatasetsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListExampleDatasetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListExampleDatasetsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListExampleDatasetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExampleDatasetsRequest.Merge(m, src)
}
func (m *ListExampleDatasetsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListExampleDatasetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExampleDatasetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListExampleDatasetsRequest proto.InternalMessageInfo

func (m *ListExampleDatasetsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListExampleDatasetsRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

// List of example datasets.
type ExampleDatasetList struct {
	Items                []*ExampleDataset `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ExampleDatasetList) Reset()         { *m = ExampleDatasetList{} }
func (m *ExampleDatasetList) String() string { return proto.CompactTextString(m) }
func (*ExampleDatasetList) ProtoMessage()    {}
func (*ExampleDatasetList) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{3}
}
func (m *ExampleDatasetList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDatasetList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDatasetList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDatasetList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDatasetList.Merge(m, src)
}
func (m *ExampleDatasetList) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDatasetList) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDatasetList.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDatasetList proto.InternalMessageInfo

func (m *ExampleDatasetList) GetItems() []*ExampleDataset {
	if m != nil {
		return m.Items
	}
	return nil
}

// List of example datasets.
type ExampleDatasetInstallationList struct {
	Items                []*ExampleDatasetInstallation `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *ExampleDatasetInstallationList) Reset()         { *m = ExampleDatasetInstallationList{} }
func (m *ExampleDatasetInstallationList) String() string { return proto.CompactTextString(m) }
func (*ExampleDatasetInstallationList) ProtoMessage()    {}
func (*ExampleDatasetInstallationList) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{4}
}
func (m *ExampleDatasetInstallationList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ExampleDatasetInstallationList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ExampleDatasetInstallationList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ExampleDatasetInstallationList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExampleDatasetInstallationList.Merge(m, src)
}
func (m *ExampleDatasetInstallationList) XXX_Size() int {
	return m.Size()
}
func (m *ExampleDatasetInstallationList) XXX_DiscardUnknown() {
	xxx_messageInfo_ExampleDatasetInstallationList.DiscardUnknown(m)
}

var xxx_messageInfo_ExampleDatasetInstallationList proto.InternalMessageInfo

func (m *ExampleDatasetInstallationList) GetItems() []*ExampleDatasetInstallation {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListExampleDatasetInstallations.
type ListExampleDatasetInstallationsRequest struct {
	// Identifier of the deployment to request the installations for.
	DeploymentId string `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Optional common list options, the context_id is ignored.
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListExampleDatasetInstallationsRequest) Reset() {
	*m = ListExampleDatasetInstallationsRequest{}
}
func (m *ListExampleDatasetInstallationsRequest) String() string { return proto.CompactTextString(m) }
func (*ListExampleDatasetInstallationsRequest) ProtoMessage()    {}
func (*ListExampleDatasetInstallationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_15a1dc8d40dadaa6, []int{5}
}
func (m *ListExampleDatasetInstallationsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListExampleDatasetInstallationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListExampleDatasetInstallationsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListExampleDatasetInstallationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListExampleDatasetInstallationsRequest.Merge(m, src)
}
func (m *ListExampleDatasetInstallationsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListExampleDatasetInstallationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListExampleDatasetInstallationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListExampleDatasetInstallationsRequest proto.InternalMessageInfo

func (m *ListExampleDatasetInstallationsRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ListExampleDatasetInstallationsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func init() {
	proto.RegisterType((*ExampleDataset)(nil), "arangodb.cloud.example.v1.ExampleDataset")
	proto.RegisterType((*ExampleDatasetInstallation)(nil), "arangodb.cloud.example.v1.ExampleDatasetInstallation")
	proto.RegisterType((*ExampleDatasetInstallation_Status)(nil), "arangodb.cloud.example.v1.ExampleDatasetInstallation.Status")
	proto.RegisterType((*ListExampleDatasetsRequest)(nil), "arangodb.cloud.example.v1.ListExampleDatasetsRequest")
	proto.RegisterType((*ExampleDatasetList)(nil), "arangodb.cloud.example.v1.ExampleDatasetList")
	proto.RegisterType((*ExampleDatasetInstallationList)(nil), "arangodb.cloud.example.v1.ExampleDatasetInstallationList")
	proto.RegisterType((*ListExampleDatasetInstallationsRequest)(nil), "arangodb.cloud.example.v1.ListExampleDatasetInstallationsRequest")
}

func init() { proto.RegisterFile("example.proto", fileDescriptor_15a1dc8d40dadaa6) }

var fileDescriptor_15a1dc8d40dadaa6 = []byte{
	// 906 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0x67, 0x92, 0xd8, 0xb5, 0x9f, 0x9b, 0xd0, 0x0e, 0x05, 0x99, 0x2d, 0x71, 0xdd, 0xb5, 0x5a,
	0x42, 0xa3, 0xec, 0xca, 0x06, 0x84, 0x5a, 0x40, 0x95, 0x21, 0x21, 0x32, 0x7f, 0xab, 0x6d, 0xcb,
	0x81, 0x8b, 0x35, 0xf6, 0x4c, 0x97, 0x91, 0xf6, 0x1f, 0x3b, 0x63, 0xab, 0xa1, 0xea, 0x01, 0x90,
	0x38, 0x22, 0x24, 0x2e, 0x5c, 0x11, 0x5f, 0x81, 0x0b, 0xdf, 0x00, 0x21, 0x0e, 0x48, 0x7c, 0x01,
	0x64, 0x38, 0xf3, 0x19, 0xd0, 0xce, 0xec, 0x92, 0x5d, 0x27, 0x76, 0x6c, 0xc3, 0x81, 0xdb, 0xee,
	0x9b, 0x79, 0xef, 0xfd, 0x7e, 0xbf, 0xf7, 0x9b, 0x9d, 0x85, 0x4d, 0xf6, 0x90, 0xf8, 0x91, 0xc7,
	0xac, 0x28, 0x0e, 0x65, 0x88, 0x9f, 0x25, 0x31, 0x09, 0xdc, 0x90, 0x0e, 0xac, 0xa1, 0x17, 0x8e,
	0xa8, 0x95, 0xad, 0x8e, 0xdb, 0xc6, 0x33, 0xc3, 0xd0, 0xf7, 0xc3, 0xc0, 0x1e, 0xb7, 0x6d, 0xfd,
	0xa4, 0x53, 0x8c, 0x57, 0x5d, 0x2e, 0x3f, 0x1e, 0x0d, 0xac, 0x61, 0xe8, 0xdb, 0x6e, 0xe8, 0x91,
	0xc0, 0xb5, 0xd5, 0xc2, 0x60, 0xf4, 0xc0, 0x8e, 0xe4, 0x51, 0xc4, 0x84, 0x2d, 0xb9, 0xcf, 0x84,
	0x24, 0x7e, 0x74, 0xfc, 0x94, 0x26, 0x3f, 0xe7, 0x86, 0xa1, 0xeb, 0x31, 0x9b, 0x44, 0xdc, 0x26,
	0x41, 0x10, 0x4a, 0x22, 0x79, 0x18, 0x08, 0xbd, 0x6a, 0xfe, 0x88, 0x60, 0xeb, 0x40, 0x23, 0xd8,
	0x27, 0x92, 0x08, 0x26, 0xf1, 0x16, 0xac, 0x71, 0x5a, 0x47, 0x4d, 0xb4, 0x53, 0x75, 0xd6, 0x38,
	0xc5, 0x17, 0x60, 0x7d, 0x14, 0x7b, 0xf5, 0x35, 0x15, 0x48, 0x1e, 0x31, 0x86, 0x8d, 0x80, 0xf8,
	0xac, 0xbe, 0xae, 0x42, 0xea, 0x19, 0x37, 0xa1, 0x46, 0x99, 0x18, 0xc6, 0x3c, 0x4a, 0xca, 0xd7,
	0x37, 0xd4, 0x52, 0x3e, 0x84, 0x2f, 0x41, 0xc9, 0x1d, 0x71, 0xca, 0xea, 0x65, 0xb5, 0xa6, 0x5f,
	0xf0, 0x4d, 0x80, 0x61, 0xcc, 0x88, 0x64, 0xb4, 0x4f, 0x64, 0xfd, 0x5c, 0x13, 0xed, 0xd4, 0x3a,
	0x86, 0xa5, 0x31, 0x5b, 0x19, 0x4b, 0xeb, 0x5e, 0x46, 0xca, 0xa9, 0xa6, 0xbb, 0xbb, 0xd2, 0xfc,
	0x6c, 0x03, 0x8c, 0x22, 0xf6, 0x5e, 0x20, 0x24, 0xf1, 0x3c, 0xc5, 0x70, 0x01, 0x1e, 0x2d, 0xd8,
	0xa4, 0x2c, 0xf2, 0xc2, 0x23, 0x9f, 0x05, 0xb2, 0xcf, 0x69, 0x4a, 0xe8, 0xfc, 0x71, 0xb0, 0x47,
	0xf1, 0x2e, 0x5c, 0x4c, 0x47, 0x44, 0x75, 0x93, 0x64, 0xa3, 0xa6, 0x77, 0xa1, 0xb8, 0xd0, 0xa3,
	0x53, 0x6c, 0x4a, 0x4b, 0xb0, 0x49, 0x52, 0x29, 0xf3, 0x58, 0x9a, 0x5a, 0x3e, 0x3b, 0x35, 0xdd,
	0xdd, 0x95, 0x78, 0x1b, 0x80, 0x8b, 0x7e, 0xfa, 0xae, 0x34, 0xac, 0x38, 0x55, 0x2e, 0xf6, 0x75,
	0x00, 0xdf, 0x83, 0xb2, 0x90, 0x44, 0x8e, 0x44, 0x9d, 0xaa, 0xaa, 0xaf, 0x59, 0x33, 0x2d, 0x68,
	0xcd, 0xd6, 0xd3, 0xba, 0xab, 0x6a, 0x38, 0x69, 0x2d, 0xe3, 0x0b, 0x04, 0x65, 0x1d, 0x52, 0x3a,
	0x12, 0x49, 0x06, 0x44, 0xb0, 0xbe, 0x32, 0x06, 0x4a, 0x75, 0x4c, 0x83, 0xef, 0x27, 0x06, 0xb9,
	0x04, 0xa5, 0x24, 0x33, 0x73, 0x8d, 0x7e, 0xc1, 0x97, 0xa1, 0xca, 0x45, 0xff, 0x01, 0xe1, 0x1e,
	0xd3, 0xaa, 0x56, 0x9c, 0x0a, 0x17, 0x6f, 0xa9, 0x77, 0x7c, 0x15, 0xce, 0x73, 0xd1, 0x27, 0x63,
	0xc2, 0x3d, 0x32, 0xf0, 0x98, 0xd2, 0xb3, 0xe2, 0xd4, 0xb8, 0xe8, 0x66, 0x21, 0xf3, 0x4b, 0x04,
	0xc6, 0xbb, 0x5c, 0xc8, 0x22, 0x6e, 0xe1, 0xb0, 0x4f, 0x46, 0x4c, 0x48, 0x7c, 0x1b, 0xce, 0x85,
	0xca, 0x7d, 0x42, 0x61, 0xaa, 0x75, 0xae, 0x4d, 0x73, 0x4f, 0x0f, 0xda, 0xb8, 0x6d, 0x25, 0x65,
	0x3e, 0xd0, 0x9b, 0x9d, 0x2c, 0x0b, 0x3f, 0x0f, 0x4f, 0x86, 0xb1, 0x4b, 0x02, 0xfe, 0xa9, 0x12,
	0x21, 0x99, 0xbd, 0x36, 0xd0, 0x56, 0x3e, 0xdc, 0xa3, 0xe6, 0x7d, 0xc0, 0x45, 0x0c, 0x49, 0x39,
	0x7c, 0x1b, 0x4a, 0x5c, 0x32, 0x3f, 0xe9, 0xbe, 0xbe, 0x53, 0xeb, 0xbc, 0xb0, 0xb0, 0xf2, 0x8e,
	0xce, 0x33, 0x7d, 0x68, 0xcc, 0x1e, 0x89, 0x6a, 0xf1, 0x4e, 0xb1, 0xc5, 0xcb, 0x2b, 0x0d, 0x37,
	0x6b, 0xf7, 0x15, 0x82, 0xeb, 0x27, 0xe5, 0xcc, 0xef, 0xfc, 0x47, 0xda, 0x13, 0x87, 0x07, 0x9d,
	0x72, 0x78, 0x72, 0xfa, 0xc3, 0x2a, 0xfa, 0x77, 0x7e, 0xae, 0xc1, 0xd3, 0x45, 0x30, 0x77, 0x59,
	0x3c, 0xe6, 0x43, 0x86, 0x1f, 0xc2, 0xe6, 0x21, 0x93, 0xdd, 0x3b, 0xbd, 0x0f, 0x59, 0x2c, 0x92,
	0xf3, 0x7e, 0x65, 0x76, 0xe9, 0x03, 0x3f, 0x92, 0x47, 0xc6, 0xd5, 0xd9, 0x1b, 0xd2, 0x1a, 0x66,
	0xeb, 0xf3, 0xdf, 0xfe, 0xfc, 0x66, 0x6d, 0x1b, 0x5f, 0x56, 0x9f, 0xcb, 0x54, 0xba, 0xe4, 0x7b,
	0x4c, 0x22, 0xbe, 0x37, 0x4e, 0x1b, 0x7d, 0x8f, 0xe0, 0xa9, 0x53, 0x3c, 0x87, 0xe7, 0x49, 0x3f,
	0xdb, 0xa3, 0xc6, 0xde, 0xc2, 0x13, 0x4b, 0x8a, 0x98, 0xd7, 0x15, 0xc4, 0x26, 0x6e, 0x4c, 0x43,
	0x2c, 0x7e, 0x8c, 0xf0, 0xd7, 0x08, 0x2e, 0x1e, 0xb2, 0xa9, 0xa6, 0xb8, 0x35, 0x5b, 0x83, 0xde,
	0x7e, 0xaa, 0xbe, 0xb1, 0xb8, 0x4d, 0xcd, 0x5d, 0x85, 0xe6, 0x1a, 0x6e, 0xcd, 0x47, 0x63, 0x3f,
	0xe2, 0xf4, 0x31, 0xfe, 0x0b, 0xc1, 0x95, 0x33, 0xdc, 0x85, 0xbb, 0x4b, 0x89, 0x78, 0x9a, 0x33,
	0x8d, 0x9b, 0x2b, 0x1d, 0x01, 0x25, 0xee, 0x7b, 0x8a, 0xce, 0x21, 0x3e, 0x98, 0xa6, 0x73, 0xec,
	0x6a, 0xfb, 0x51, 0xc1, 0xf6, 0x8f, 0xa7, 0x98, 0xf2, 0xfc, 0x15, 0xf4, 0x03, 0x82, 0xed, 0x13,
	0x33, 0x28, 0x5c, 0x52, 0x0b, 0xcd, 0x63, 0xb5, 0x33, 0x6d, 0xbe, 0xa2, 0xc8, 0xb4, 0xb1, 0x3d,
	0x7f, 0x36, 0x79, 0xc4, 0x7a, 0x4e, 0x13, 0x04, 0xcd, 0x37, 0xd5, 0xc5, 0x34, 0x07, 0xf9, 0x6a,
	0xa0, 0x56, 0xe5, 0x72, 0x47, 0x71, 0x79, 0xdb, 0xfc, 0x6f, 0x06, 0x73, 0x0b, 0xdd, 0xc0, 0xbf,
	0x20, 0x68, 0xde, 0x8f, 0xe8, 0xff, 0x89, 0xe4, 0x2d, 0x45, 0xf2, 0xa5, 0xce, 0xb2, 0x03, 0x4b,
	0xe8, 0x7c, 0x87, 0xa0, 0xa9, 0x2f, 0xfc, 0x7f, 0xeb, 0xb6, 0xb3, 0xbe, 0xa3, 0x99, 0xaf, 0x6e,
	0x2c, 0x0b, 0xf3, 0x8d, 0xd7, 0x7f, 0x9a, 0x34, 0xd0, 0xaf, 0x93, 0x06, 0xfa, 0x7d, 0xd2, 0x40,
	0xdf, 0xfe, 0xd1, 0x78, 0xe2, 0xa3, 0xdd, 0xdc, 0x9f, 0x6d, 0xd6, 0x75, 0xcf, 0x27, 0x01, 0x71,
	0x19, 0x4d, 0xaa, 0x8b, 0x5c, 0xf9, 0x41, 0x59, 0xfd, 0x05, 0xbd, 0xf8, 0x77, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xe4, 0xe6, 0x73, 0xd4, 0x51, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ExampleDatasetServiceClient is the client API for ExampleDatasetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExampleDatasetServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all example datasets.
	// Required permissions:
	// - None: Caller must be authenticated.
	ListExampleDatasets(ctx context.Context, in *ListExampleDatasetsRequest, opts ...grpc.CallOption) (*ExampleDatasetList, error)
	// Fetch an example dataset identified by the given ID.
	// Required permissions:
	// - None: Caller must be authenticated.
	GetExampleDataset(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ExampleDataset, error)
	// Fetch all installations for a specific deployment.
	// Required permissions:
	// - example.exampledatasetinstallation.list on the deployment that owns the installation and is identified by the given ID.
	ListExampleDatasetInstallations(ctx context.Context, in *ListExampleDatasetInstallationsRequest, opts ...grpc.CallOption) (*ExampleDatasetInstallationList, error)
	// Fetch an installations identified by the given ID.
	// Required permissions:
	// - example.exampledatasetinstallation.get on the installation identified by the given ID.
	GetExampleDatasetInstallation(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error)
	// Create a new example installation. This represents a request made by the user to create an installation
	// for a deployment given a specified example dataset.
	// Required permissions:
	// -  example.exampledatasetinstallation.create on the deployment that the installation is for and is identified by the given ID.
	CreateExampleDatasetInstallation(ctx context.Context, in *ExampleDatasetInstallation, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error)
	// Update an installation.
	// Required permissions:
	// -  example.exampledatasetinstallation.update on the installation identified by the given ID.
	UpdateExampleDatasetInstallation(ctx context.Context, in *ExampleDatasetInstallation, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error)
	// Delete an installation identified by the given ID.
	// Required permissions:
	// -  example.exampledatasetinstallation.delete on the installation identified by the given ID.
	DeleteExampleDatasetInstallation(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
}

type exampleDatasetServiceClient struct {
	cc *grpc.ClientConn
}

func NewExampleDatasetServiceClient(cc *grpc.ClientConn) ExampleDatasetServiceClient {
	return &exampleDatasetServiceClient{cc}
}

func (c *exampleDatasetServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) ListExampleDatasets(ctx context.Context, in *ListExampleDatasetsRequest, opts ...grpc.CallOption) (*ExampleDatasetList, error) {
	out := new(ExampleDatasetList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/ListExampleDatasets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) GetExampleDataset(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ExampleDataset, error) {
	out := new(ExampleDataset)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/GetExampleDataset", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) ListExampleDatasetInstallations(ctx context.Context, in *ListExampleDatasetInstallationsRequest, opts ...grpc.CallOption) (*ExampleDatasetInstallationList, error) {
	out := new(ExampleDatasetInstallationList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/ListExampleDatasetInstallations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) GetExampleDatasetInstallation(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error) {
	out := new(ExampleDatasetInstallation)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/GetExampleDatasetInstallation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) CreateExampleDatasetInstallation(ctx context.Context, in *ExampleDatasetInstallation, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error) {
	out := new(ExampleDatasetInstallation)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/CreateExampleDatasetInstallation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) UpdateExampleDatasetInstallation(ctx context.Context, in *ExampleDatasetInstallation, opts ...grpc.CallOption) (*ExampleDatasetInstallation, error) {
	out := new(ExampleDatasetInstallation)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/UpdateExampleDatasetInstallation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *exampleDatasetServiceClient) DeleteExampleDatasetInstallation(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.example.v1.ExampleDatasetService/DeleteExampleDatasetInstallation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExampleDatasetServiceServer is the server API for ExampleDatasetService service.
type ExampleDatasetServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all example datasets.
	// Required permissions:
	// - None: Caller must be authenticated.
	ListExampleDatasets(context.Context, *ListExampleDatasetsRequest) (*ExampleDatasetList, error)
	// Fetch an example dataset identified by the given ID.
	// Required permissions:
	// - None: Caller must be authenticated.
	GetExampleDataset(context.Context, *v1.IDOptions) (*ExampleDataset, error)
	// Fetch all installations for a specific deployment.
	// Required permissions:
	// - example.exampledatasetinstallation.list on the deployment that owns the installation and is identified by the given ID.
	ListExampleDatasetInstallations(context.Context, *ListExampleDatasetInstallationsRequest) (*ExampleDatasetInstallationList, error)
	// Fetch an installations identified by the given ID.
	// Required permissions:
	// - example.exampledatasetinstallation.get on the installation identified by the given ID.
	GetExampleDatasetInstallation(context.Context, *v1.IDOptions) (*ExampleDatasetInstallation, error)
	// Create a new example installation. This represents a request made by the user to create an installation
	// for a deployment given a specified example dataset.
	// Required permissions:
	// -  example.exampledatasetinstallation.create on the deployment that the installation is for and is identified by the given ID.
	CreateExampleDatasetInstallation(context.Context, *ExampleDatasetInstallation) (*ExampleDatasetInstallation, error)
	// Update an installation.
	// Required permissions:
	// -  example.exampledatasetinstallation.update on the installation identified by the given ID.
	UpdateExampleDatasetInstallation(context.Context, *ExampleDatasetInstallation) (*ExampleDatasetInstallation, error)
	// Delete an installation identified by the given ID.
	// Required permissions:
	// -  example.exampledatasetinstallation.delete on the installation identified by the given ID.
	DeleteExampleDatasetInstallation(context.Context, *v1.IDOptions) (*v1.Empty, error)
}

// UnimplementedExampleDatasetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedExampleDatasetServiceServer struct {
}

func (*UnimplementedExampleDatasetServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) ListExampleDatasets(ctx context.Context, req *ListExampleDatasetsRequest) (*ExampleDatasetList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExampleDatasets not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) GetExampleDataset(ctx context.Context, req *v1.IDOptions) (*ExampleDataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExampleDataset not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) ListExampleDatasetInstallations(ctx context.Context, req *ListExampleDatasetInstallationsRequest) (*ExampleDatasetInstallationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListExampleDatasetInstallations not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) GetExampleDatasetInstallation(ctx context.Context, req *v1.IDOptions) (*ExampleDatasetInstallation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetExampleDatasetInstallation not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) CreateExampleDatasetInstallation(ctx context.Context, req *ExampleDatasetInstallation) (*ExampleDatasetInstallation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateExampleDatasetInstallation not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) UpdateExampleDatasetInstallation(ctx context.Context, req *ExampleDatasetInstallation) (*ExampleDatasetInstallation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateExampleDatasetInstallation not implemented")
}
func (*UnimplementedExampleDatasetServiceServer) DeleteExampleDatasetInstallation(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteExampleDatasetInstallation not implemented")
}

func RegisterExampleDatasetServiceServer(s *grpc.Server, srv ExampleDatasetServiceServer) {
	s.RegisterService(&_ExampleDatasetService_serviceDesc, srv)
}

func _ExampleDatasetService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_ListExampleDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExampleDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).ListExampleDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/ListExampleDatasets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).ListExampleDatasets(ctx, req.(*ListExampleDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_GetExampleDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).GetExampleDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/GetExampleDataset",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).GetExampleDataset(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_ListExampleDatasetInstallations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExampleDatasetInstallationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).ListExampleDatasetInstallations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/ListExampleDatasetInstallations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).ListExampleDatasetInstallations(ctx, req.(*ListExampleDatasetInstallationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_GetExampleDatasetInstallation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).GetExampleDatasetInstallation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/GetExampleDatasetInstallation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).GetExampleDatasetInstallation(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_CreateExampleDatasetInstallation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExampleDatasetInstallation)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).CreateExampleDatasetInstallation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/CreateExampleDatasetInstallation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).CreateExampleDatasetInstallation(ctx, req.(*ExampleDatasetInstallation))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_UpdateExampleDatasetInstallation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExampleDatasetInstallation)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).UpdateExampleDatasetInstallation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/UpdateExampleDatasetInstallation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).UpdateExampleDatasetInstallation(ctx, req.(*ExampleDatasetInstallation))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExampleDatasetService_DeleteExampleDatasetInstallation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExampleDatasetServiceServer).DeleteExampleDatasetInstallation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.example.v1.ExampleDatasetService/DeleteExampleDatasetInstallation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExampleDatasetServiceServer).DeleteExampleDatasetInstallation(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _ExampleDatasetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.example.v1.ExampleDatasetService",
	HandlerType: (*ExampleDatasetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _ExampleDatasetService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListExampleDatasets",
			Handler:    _ExampleDatasetService_ListExampleDatasets_Handler,
		},
		{
			MethodName: "GetExampleDataset",
			Handler:    _ExampleDatasetService_GetExampleDataset_Handler,
		},
		{
			MethodName: "ListExampleDatasetInstallations",
			Handler:    _ExampleDatasetService_ListExampleDatasetInstallations_Handler,
		},
		{
			MethodName: "GetExampleDatasetInstallation",
			Handler:    _ExampleDatasetService_GetExampleDatasetInstallation_Handler,
		},
		{
			MethodName: "CreateExampleDatasetInstallation",
			Handler:    _ExampleDatasetService_CreateExampleDatasetInstallation_Handler,
		},
		{
			MethodName: "UpdateExampleDatasetInstallation",
			Handler:    _ExampleDatasetService_UpdateExampleDatasetInstallation_Handler,
		},
		{
			MethodName: "DeleteExampleDatasetInstallation",
			Handler:    _ExampleDatasetService_DeleteExampleDatasetInstallation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "example.proto",
}

func (m *ExampleDataset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDataset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDataset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Guide) > 0 {
		i -= len(m.Guide)
		copy(dAtA[i:], m.Guide)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Guide)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExampleDatasetInstallation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDatasetInstallation) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDatasetInstallation) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Status != nil {
		{
			size, err := m.Status.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ExampledatasetId) > 0 {
		i -= len(m.ExampledatasetId)
		copy(dAtA[i:], m.ExampledatasetId)
		i = encodeVarintExample(dAtA, i, uint64(len(m.ExampledatasetId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintExample(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintExample(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExampleDatasetInstallation_Status) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDatasetInstallation_Status) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDatasetInstallation_Status) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsAvailable {
		i--
		if m.IsAvailable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.IsFailed {
		i--
		if m.IsFailed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.State) > 0 {
		i -= len(m.State)
		copy(dAtA[i:], m.State)
		i = encodeVarintExample(dAtA, i, uint64(len(m.State)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DatabaseName) > 0 {
		i -= len(m.DatabaseName)
		copy(dAtA[i:], m.DatabaseName)
		i = encodeVarintExample(dAtA, i, uint64(len(m.DatabaseName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ListExampleDatasetsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListExampleDatasetsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListExampleDatasetsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintExample(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ExampleDatasetList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDatasetList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDatasetList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintExample(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ExampleDatasetInstallationList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExampleDatasetInstallationList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ExampleDatasetInstallationList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintExample(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListExampleDatasetInstallationsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListExampleDatasetInstallationsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListExampleDatasetInstallationsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintExample(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintExample(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintExample(dAtA []byte, offset int, v uint64) int {
	offset -= sovExample(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *ExampleDataset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Guide)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExampleDatasetInstallation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.ExampledatasetId)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 2 + l + sovExample(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExampleDatasetInstallation_Status) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DatabaseName)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.State)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.IsFailed {
		n += 2
	}
	if m.IsAvailable {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListExampleDatasetsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExampleDatasetList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovExample(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ExampleDatasetInstallationList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovExample(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListExampleDatasetInstallationsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovExample(uint64(l))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovExample(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovExample(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozExample(x uint64) (n int) {
	return sovExample(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ExampleDataset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExampleDataset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExampleDataset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Guide", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Guide = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExampleDatasetInstallation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExampleDatasetInstallation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExampleDatasetInstallation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExampledatasetId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExampledatasetId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &ExampleDatasetInstallation_Status{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExampleDatasetInstallation_Status) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Status: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Status: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DatabaseName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DatabaseName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsFailed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsFailed = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsAvailable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsAvailable = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListExampleDatasetsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListExampleDatasetsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListExampleDatasetsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExampleDatasetList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExampleDatasetList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExampleDatasetList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &ExampleDataset{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExampleDatasetInstallationList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExampleDatasetInstallationList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExampleDatasetInstallationList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &ExampleDatasetInstallation{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListExampleDatasetInstallationsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowExample
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListExampleDatasetInstallationsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListExampleDatasetInstallationsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowExample
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthExample
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthExample
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipExample(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthExample
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipExample(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowExample
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExample
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowExample
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthExample
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthExample
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowExample
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipExample(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthExample
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthExample = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowExample   = fmt.Errorf("proto: integer overflow")
)
