// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: platform.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Provider represents a specific cloud provider such as AWS or GCP.
type Provider struct {
	// System identifier of the provider.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the provider
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// If set, this provider has not be released as generally available.
	Prerelease           bool     `protobuf:"varint,3,opt,name=prerelease,proto3" json:"prerelease,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Provider) Reset()         { *m = Provider{} }
func (m *Provider) String() string { return proto.CompactTextString(m) }
func (*Provider) ProtoMessage()    {}
func (*Provider) Descriptor() ([]byte, []int) {
	return fileDescriptor_918f3d50bfb447e4, []int{0}
}
func (m *Provider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Provider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Provider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Provider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Provider.Merge(m, src)
}
func (m *Provider) XXX_Size() int {
	return m.Size()
}
func (m *Provider) XXX_DiscardUnknown() {
	xxx_messageInfo_Provider.DiscardUnknown(m)
}

var xxx_messageInfo_Provider proto.InternalMessageInfo

func (m *Provider) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Provider) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Provider) GetPrerelease() bool {
	if m != nil {
		return m.Prerelease
	}
	return false
}

// List of providers.
type ProviderList struct {
	Items                []*Provider `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ProviderList) Reset()         { *m = ProviderList{} }
func (m *ProviderList) String() string { return proto.CompactTextString(m) }
func (*ProviderList) ProtoMessage()    {}
func (*ProviderList) Descriptor() ([]byte, []int) {
	return fileDescriptor_918f3d50bfb447e4, []int{1}
}
func (m *ProviderList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProviderList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProviderList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProviderList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProviderList.Merge(m, src)
}
func (m *ProviderList) XXX_Size() int {
	return m.Size()
}
func (m *ProviderList) XXX_DiscardUnknown() {
	xxx_messageInfo_ProviderList.DiscardUnknown(m)
}

var xxx_messageInfo_ProviderList proto.InternalMessageInfo

func (m *ProviderList) GetItems() []*Provider {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListProviders
type ListProvidersRequest struct {
	// Common list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, the result includes all providers for that are available for the
	// organization identified by this ID.
	// If not set, only providers are returned that are available to all organizations.
	OrganizationId       string   `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListProvidersRequest) Reset()         { *m = ListProvidersRequest{} }
func (m *ListProvidersRequest) String() string { return proto.CompactTextString(m) }
func (*ListProvidersRequest) ProtoMessage()    {}
func (*ListProvidersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_918f3d50bfb447e4, []int{2}
}
func (m *ListProvidersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListProvidersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListProvidersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListProvidersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListProvidersRequest.Merge(m, src)
}
func (m *ListProvidersRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListProvidersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListProvidersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListProvidersRequest proto.InternalMessageInfo

func (m *ListProvidersRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListProvidersRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

// Region represents a geographical region in which deployments are run.
type Region struct {
	// System identifier of the region.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the provider that hosts this region.
	ProviderId string `protobuf:"bytes,2,opt,name=provider_id,json=providerId,proto3" json:"provider_id,omitempty"`
	// Location of the region
	Location string `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// Is this region available for creating new deployments?
	Available bool `protobuf:"varint,4,opt,name=available,proto3" json:"available,omitempty"`
	// If set, this region is low on stock.
	// Creating a deployment may not be possible.
	LowStock bool `protobuf:"varint,5,opt,name=low_stock,json=lowStock,proto3" json:"low_stock,omitempty"`
	// If set, this region is out of stock.
	// Creating a deployment is currently not possible.
	OutOfStock bool `protobuf:"varint,6,opt,name=out_of_stock,json=outOfStock,proto3" json:"out_of_stock,omitempty"`
	// If set, this region has not be released as generally available.
	Prerelease           bool     `protobuf:"varint,7,opt,name=prerelease,proto3" json:"prerelease,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Region) Reset()         { *m = Region{} }
func (m *Region) String() string { return proto.CompactTextString(m) }
func (*Region) ProtoMessage()    {}
func (*Region) Descriptor() ([]byte, []int) {
	return fileDescriptor_918f3d50bfb447e4, []int{3}
}
func (m *Region) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Region) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Region.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Region) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Region.Merge(m, src)
}
func (m *Region) XXX_Size() int {
	return m.Size()
}
func (m *Region) XXX_DiscardUnknown() {
	xxx_messageInfo_Region.DiscardUnknown(m)
}

var xxx_messageInfo_Region proto.InternalMessageInfo

func (m *Region) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Region) GetProviderId() string {
	if m != nil {
		return m.ProviderId
	}
	return ""
}

func (m *Region) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *Region) GetAvailable() bool {
	if m != nil {
		return m.Available
	}
	return false
}

func (m *Region) GetLowStock() bool {
	if m != nil {
		return m.LowStock
	}
	return false
}

func (m *Region) GetOutOfStock() bool {
	if m != nil {
		return m.OutOfStock
	}
	return false
}

func (m *Region) GetPrerelease() bool {
	if m != nil {
		return m.Prerelease
	}
	return false
}

// List of regions.
type RegionList struct {
	Items                []*Region `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *RegionList) Reset()         { *m = RegionList{} }
func (m *RegionList) String() string { return proto.CompactTextString(m) }
func (*RegionList) ProtoMessage()    {}
func (*RegionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_918f3d50bfb447e4, []int{4}
}
func (m *RegionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RegionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RegionList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RegionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RegionList.Merge(m, src)
}
func (m *RegionList) XXX_Size() int {
	return m.Size()
}
func (m *RegionList) XXX_DiscardUnknown() {
	xxx_messageInfo_RegionList.DiscardUnknown(m)
}

var xxx_messageInfo_RegionList proto.InternalMessageInfo

func (m *RegionList) GetItems() []*Region {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListRegions
type ListRegionsRequest struct {
	// Common list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// Required identifier of the provider to list regions for.
	ProviderId string `protobuf:"bytes,2,opt,name=provider_id,json=providerId,proto3" json:"provider_id,omitempty"`
	// If set, the result includes all regions for that are available for the
	// organization identified by this ID.
	// If not set, only regions are returned that are available to all organizations.
	OrganizationId       string   `protobuf:"bytes,3,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListRegionsRequest) Reset()         { *m = ListRegionsRequest{} }
func (m *ListRegionsRequest) String() string { return proto.CompactTextString(m) }
func (*ListRegionsRequest) ProtoMessage()    {}
func (*ListRegionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_918f3d50bfb447e4, []int{5}
}
func (m *ListRegionsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListRegionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListRegionsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListRegionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListRegionsRequest.Merge(m, src)
}
func (m *ListRegionsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListRegionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListRegionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListRegionsRequest proto.InternalMessageInfo

func (m *ListRegionsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListRegionsRequest) GetProviderId() string {
	if m != nil {
		return m.ProviderId
	}
	return ""
}

func (m *ListRegionsRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func init() {
	proto.RegisterType((*Provider)(nil), "arangodb.cloud.platform.v1.Provider")
	proto.RegisterType((*ProviderList)(nil), "arangodb.cloud.platform.v1.ProviderList")
	proto.RegisterType((*ListProvidersRequest)(nil), "arangodb.cloud.platform.v1.ListProvidersRequest")
	proto.RegisterType((*Region)(nil), "arangodb.cloud.platform.v1.Region")
	proto.RegisterType((*RegionList)(nil), "arangodb.cloud.platform.v1.RegionList")
	proto.RegisterType((*ListRegionsRequest)(nil), "arangodb.cloud.platform.v1.ListRegionsRequest")
}

func init() { proto.RegisterFile("platform.proto", fileDescriptor_918f3d50bfb447e4) }

var fileDescriptor_918f3d50bfb447e4 = []byte{
	// 647 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x54, 0xcd, 0x6e, 0xd3, 0x4c,
	0x14, 0xfd, 0x26, 0xfd, 0x4b, 0x6e, 0xfa, 0x23, 0x8d, 0x3e, 0x21, 0xcb, 0x04, 0x27, 0x35, 0x2d,
	0xcd, 0x82, 0xda, 0x6d, 0xd8, 0x54, 0x2c, 0x40, 0x20, 0xa0, 0x0a, 0x42, 0xb4, 0x72, 0x25, 0x16,
	0x6c, 0xaa, 0x49, 0x3c, 0x35, 0x23, 0x6c, 0x8f, 0xb1, 0x27, 0xae, 0x4a, 0x55, 0x09, 0x78, 0x01,
	0x16, 0x6c, 0xd8, 0xf5, 0x59, 0xd8, 0xb1, 0x44, 0xf0, 0x02, 0x28, 0xf0, 0x20, 0xc8, 0x63, 0x3b,
	0x4d, 0xc8, 0xef, 0x82, 0x9d, 0xe7, 0xce, 0xdc, 0x7b, 0xce, 0x3d, 0xe7, 0x5e, 0xc3, 0x6a, 0xe0,
	0x12, 0x71, 0xc2, 0x43, 0xcf, 0x08, 0x42, 0x2e, 0x38, 0x56, 0x49, 0x48, 0x7c, 0x87, 0xdb, 0x2d,
	0xa3, 0xed, 0xf2, 0x8e, 0x6d, 0xf4, 0xae, 0xe3, 0x5d, 0xf5, 0x5a, 0x9b, 0x7b, 0x1e, 0xf7, 0xcd,
	0x78, 0xd7, 0x4c, 0xbf, 0xd2, 0x1c, 0xb5, 0xe2, 0x70, 0xee, 0xb8, 0xd4, 0x24, 0x01, 0x33, 0x89,
	0xef, 0x73, 0x41, 0x04, 0xe3, 0x7e, 0x94, 0xde, 0xea, 0xcf, 0xa1, 0x78, 0x18, 0xf2, 0x98, 0xd9,
	0x34, 0xc4, 0xab, 0x50, 0x60, 0xb6, 0x82, 0x6a, 0xa8, 0x5e, 0xb2, 0x0a, 0xcc, 0xc6, 0x18, 0xe6,
	0x7d, 0xe2, 0x51, 0xa5, 0x20, 0x23, 0xf2, 0x1b, 0x6b, 0x00, 0x41, 0x48, 0x43, 0xea, 0x52, 0x12,
	0x51, 0x65, 0xae, 0x86, 0xea, 0x45, 0xab, 0x2f, 0xa2, 0x3f, 0x85, 0xe5, 0xbc, 0xde, 0x33, 0x16,
	0x09, 0x7c, 0x17, 0x16, 0x98, 0xa0, 0x5e, 0xa4, 0xa0, 0xda, 0x5c, 0xbd, 0xdc, 0xd8, 0x30, 0xc6,
	0x77, 0x60, 0xe4, 0x89, 0x56, 0x9a, 0xa2, 0xbf, 0x43, 0xf0, 0x7f, 0x52, 0x24, 0x8f, 0x47, 0x16,
	0x7d, 0xd3, 0xa1, 0x91, 0xc0, 0xf7, 0x61, 0x89, 0x07, 0xb2, 0x0b, 0xc9, 0xb6, 0xdc, 0xd8, 0xfc,
	0xbb, 0x6c, 0xa6, 0x40, 0xbc, 0x6b, 0x24, 0x05, 0x0e, 0xd2, 0xc7, 0x56, 0x9e, 0x85, 0xb7, 0x60,
	0x8d, 0x87, 0x0e, 0xf1, 0xd9, 0x5b, 0x29, 0xc6, 0x31, 0xb3, 0xb3, 0x26, 0x57, 0xfb, 0xc3, 0x4d,
	0x5b, 0xff, 0x8e, 0x60, 0xd1, 0xa2, 0x0e, 0xe3, 0xfe, 0x90, 0x3a, 0x55, 0x28, 0x07, 0x19, 0xb1,
	0xab, 0x7c, 0xc8, 0x43, 0x4d, 0x1b, 0xab, 0x50, 0x74, 0x79, 0x5b, 0x56, 0x92, 0x42, 0x95, 0xac,
	0xde, 0x19, 0x57, 0xa0, 0x44, 0x62, 0xc2, 0x5c, 0xd2, 0x72, 0xa9, 0x32, 0x2f, 0x55, 0xbc, 0x0a,
	0xe0, 0xeb, 0x50, 0x72, 0xf9, 0xe9, 0x71, 0x24, 0x78, 0xfb, 0xb5, 0xb2, 0x20, 0x6f, 0x8b, 0x2e,
	0x3f, 0x3d, 0x4a, 0xce, 0xb8, 0x06, 0xcb, 0xbc, 0x23, 0x8e, 0xf9, 0x49, 0x76, 0xbf, 0x98, 0x7a,
	0xc0, 0x3b, 0xe2, 0xe0, 0x24, 0x7d, 0x31, 0xe8, 0xd1, 0xd2, 0x90, 0x47, 0x4f, 0x00, 0xd2, 0x9e,
	0xa4, 0x43, 0x7b, 0x83, 0x0e, 0xe9, 0x93, 0x1c, 0x4a, 0xd3, 0x72, 0x7f, 0x2e, 0x11, 0xe0, 0xa4,
	0x44, 0x1a, 0xfd, 0x77, 0xee, 0x4c, 0x55, 0x76, 0x84, 0x7d, 0x73, 0xa3, 0xec, 0x6b, 0x7c, 0x59,
	0x80, 0xb5, 0xc3, 0x8c, 0xff, 0x11, 0x0d, 0x63, 0xd6, 0xa6, 0xf8, 0x0c, 0x56, 0xf6, 0xa9, 0x78,
	0x70, 0xd8, 0x7c, 0x41, 0xc3, 0x28, 0xf1, 0xa2, 0x3a, 0x9e, 0xde, 0x63, 0x2f, 0x10, 0x67, 0xea,
	0xfa, 0xf8, 0x07, 0x59, 0x0d, 0x7d, 0xe3, 0xc3, 0x8f, 0xdf, 0x9f, 0x0a, 0x1a, 0xae, 0xc8, 0x35,
	0xcb, 0x25, 0x4b, 0x76, 0x91, 0x04, 0x6c, 0x3b, 0xce, 0x90, 0x3e, 0x22, 0x58, 0x19, 0x18, 0x68,
	0xbc, 0x33, 0x49, 0xed, 0x51, 0xb3, 0xaf, 0xd6, 0x67, 0xd9, 0xa0, 0x24, 0x53, 0xd7, 0x25, 0xa7,
	0x0a, 0x56, 0x87, 0x38, 0x05, 0x3d, 0xfc, 0xf7, 0x08, 0xca, 0xfb, 0xb4, 0x87, 0x82, 0x6f, 0x8e,
	0x6f, 0xb5, 0xf9, 0x28, 0x33, 0x4a, 0x9d, 0x69, 0x89, 0xf5, 0x2d, 0x09, 0xbf, 0x8e, 0xab, 0xe3,
	0xe1, 0xcd, 0x73, 0x66, 0x5f, 0xe0, 0x4b, 0x04, 0xe5, 0xbe, 0x31, 0xc2, 0xc6, 0x34, 0x4d, 0x06,
	0xe7, 0x4d, 0xbd, 0x35, 0x7d, 0x62, 0xa5, 0x1e, 0x7b, 0x92, 0x50, 0x03, 0xef, 0x4c, 0x22, 0xd4,
	0x37, 0x78, 0x17, 0x66, 0x98, 0x31, 0x3a, 0x87, 0xd2, 0x3e, 0xcd, 0x60, 0x67, 0x93, 0x68, 0x86,
	0x2d, 0xd2, 0x37, 0x25, 0x9f, 0x2a, 0xbe, 0x31, 0xc4, 0x27, 0xc3, 0x95, 0xf2, 0x3c, 0xbc, 0xf7,
	0xb5, 0xab, 0xa1, 0x6f, 0x5d, 0x0d, 0xfd, 0xec, 0x6a, 0xe8, 0xf3, 0x2f, 0xed, 0xbf, 0x97, 0xb7,
	0x1d, 0x26, 0x5e, 0x75, 0x5a, 0x09, 0xb0, 0x99, 0xc3, 0x6c, 0x7b, 0xc4, 0x27, 0x0e, 0xb5, 0x93,
	0x5a, 0x51, 0x7f, 0xb1, 0xd6, 0xa2, 0xfc, 0xd1, 0xdf, 0xf9, 0x13, 0x00, 0x00, 0xff, 0xff, 0x25,
	0x7b, 0x10, 0x4f, 0x4c, 0x06, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// PlatformServiceClient is the client API for PlatformService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PlatformServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all providers that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListProviders(ctx context.Context, in *ListProvidersRequest, opts ...grpc.CallOption) (*ProviderList, error)
	// Fetch a provider by its id.
	// Required permissions:
	// - None
	GetProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Provider, error)
	// Fetch all regions provided by the provided identified by the given context ID.
	// If the given context identifier contains a valid organization ID,
	// the result includes all regions for that organization.
	// Otherwise only regions are returned that are available to all organizations.
	// Required permissions:
	// - None
	ListRegions(ctx context.Context, in *ListRegionsRequest, opts ...grpc.CallOption) (*RegionList, error)
	// Fetch a region by its id.
	// Required permissions:
	// - None
	GetRegion(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Region, error)
}

type platformServiceClient struct {
	cc *grpc.ClientConn
}

func NewPlatformServiceClient(cc *grpc.ClientConn) PlatformServiceClient {
	return &platformServiceClient{cc}
}

func (c *platformServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.platform.v1.PlatformService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *platformServiceClient) ListProviders(ctx context.Context, in *ListProvidersRequest, opts ...grpc.CallOption) (*ProviderList, error) {
	out := new(ProviderList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.platform.v1.PlatformService/ListProviders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *platformServiceClient) GetProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Provider, error) {
	out := new(Provider)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.platform.v1.PlatformService/GetProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *platformServiceClient) ListRegions(ctx context.Context, in *ListRegionsRequest, opts ...grpc.CallOption) (*RegionList, error) {
	out := new(RegionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.platform.v1.PlatformService/ListRegions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *platformServiceClient) GetRegion(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Region, error) {
	out := new(Region)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.platform.v1.PlatformService/GetRegion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PlatformServiceServer is the server API for PlatformService service.
type PlatformServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all providers that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListProviders(context.Context, *ListProvidersRequest) (*ProviderList, error)
	// Fetch a provider by its id.
	// Required permissions:
	// - None
	GetProvider(context.Context, *v1.IDOptions) (*Provider, error)
	// Fetch all regions provided by the provided identified by the given context ID.
	// If the given context identifier contains a valid organization ID,
	// the result includes all regions for that organization.
	// Otherwise only regions are returned that are available to all organizations.
	// Required permissions:
	// - None
	ListRegions(context.Context, *ListRegionsRequest) (*RegionList, error)
	// Fetch a region by its id.
	// Required permissions:
	// - None
	GetRegion(context.Context, *v1.IDOptions) (*Region, error)
}

// UnimplementedPlatformServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPlatformServiceServer struct {
}

func (*UnimplementedPlatformServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedPlatformServiceServer) ListProviders(ctx context.Context, req *ListProvidersRequest) (*ProviderList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProviders not implemented")
}
func (*UnimplementedPlatformServiceServer) GetProvider(ctx context.Context, req *v1.IDOptions) (*Provider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProvider not implemented")
}
func (*UnimplementedPlatformServiceServer) ListRegions(ctx context.Context, req *ListRegionsRequest) (*RegionList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRegions not implemented")
}
func (*UnimplementedPlatformServiceServer) GetRegion(ctx context.Context, req *v1.IDOptions) (*Region, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRegion not implemented")
}

func RegisterPlatformServiceServer(s *grpc.Server, srv PlatformServiceServer) {
	s.RegisterService(&_PlatformService_serviceDesc, srv)
}

func _PlatformService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlatformServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.platform.v1.PlatformService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlatformServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlatformService_ListProviders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProvidersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlatformServiceServer).ListProviders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.platform.v1.PlatformService/ListProviders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlatformServiceServer).ListProviders(ctx, req.(*ListProvidersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlatformService_GetProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlatformServiceServer).GetProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.platform.v1.PlatformService/GetProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlatformServiceServer).GetProvider(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlatformService_ListRegions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRegionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlatformServiceServer).ListRegions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.platform.v1.PlatformService/ListRegions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlatformServiceServer).ListRegions(ctx, req.(*ListRegionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PlatformService_GetRegion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PlatformServiceServer).GetRegion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.platform.v1.PlatformService/GetRegion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PlatformServiceServer).GetRegion(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _PlatformService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.platform.v1.PlatformService",
	HandlerType: (*PlatformServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _PlatformService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListProviders",
			Handler:    _PlatformService_ListProviders_Handler,
		},
		{
			MethodName: "GetProvider",
			Handler:    _PlatformService_GetProvider_Handler,
		},
		{
			MethodName: "ListRegions",
			Handler:    _PlatformService_ListRegions_Handler,
		},
		{
			MethodName: "GetRegion",
			Handler:    _PlatformService_GetRegion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "platform.proto",
}

func (m *Provider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Provider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Provider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Prerelease {
		i--
		if m.Prerelease {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintPlatform(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintPlatform(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ProviderList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProviderList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProviderList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlatform(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListProvidersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListProvidersRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListProvidersRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintPlatform(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlatform(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Region) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Region) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Region) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Prerelease {
		i--
		if m.Prerelease {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.OutOfStock {
		i--
		if m.OutOfStock {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.LowStock {
		i--
		if m.LowStock {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.Available {
		i--
		if m.Available {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.Location) > 0 {
		i -= len(m.Location)
		copy(dAtA[i:], m.Location)
		i = encodeVarintPlatform(dAtA, i, uint64(len(m.Location)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ProviderId) > 0 {
		i -= len(m.ProviderId)
		copy(dAtA[i:], m.ProviderId)
		i = encodeVarintPlatform(dAtA, i, uint64(len(m.ProviderId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintPlatform(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RegionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RegionList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RegionList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintPlatform(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListRegionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListRegionsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListRegionsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintPlatform(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ProviderId) > 0 {
		i -= len(m.ProviderId)
		copy(dAtA[i:], m.ProviderId)
		i = encodeVarintPlatform(dAtA, i, uint64(len(m.ProviderId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintPlatform(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintPlatform(dAtA []byte, offset int, v uint64) int {
	offset -= sovPlatform(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Provider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovPlatform(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPlatform(uint64(l))
	}
	if m.Prerelease {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProviderList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovPlatform(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListProvidersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovPlatform(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovPlatform(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Region) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovPlatform(uint64(l))
	}
	l = len(m.ProviderId)
	if l > 0 {
		n += 1 + l + sovPlatform(uint64(l))
	}
	l = len(m.Location)
	if l > 0 {
		n += 1 + l + sovPlatform(uint64(l))
	}
	if m.Available {
		n += 2
	}
	if m.LowStock {
		n += 2
	}
	if m.OutOfStock {
		n += 2
	}
	if m.Prerelease {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RegionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovPlatform(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListRegionsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovPlatform(uint64(l))
	}
	l = len(m.ProviderId)
	if l > 0 {
		n += 1 + l + sovPlatform(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovPlatform(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovPlatform(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozPlatform(x uint64) (n int) {
	return sovPlatform(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Provider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlatform
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Provider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Provider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prerelease", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Prerelease = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlatform(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProviderList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlatform
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProviderList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProviderList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Provider{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlatform(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListProvidersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlatform
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListProvidersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListProvidersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlatform(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Region) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlatform
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Region: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Region: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Location", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Location = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Available = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LowStock", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LowStock = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutOfStock", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OutOfStock = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prerelease", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Prerelease = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipPlatform(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RegionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlatform
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RegionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RegionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Region{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlatform(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListRegionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPlatform
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListRegionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListRegionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProviderId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProviderId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPlatform
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPlatform
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPlatform(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPlatform
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPlatform(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPlatform
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPlatform
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPlatform
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthPlatform
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPlatform
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPlatform(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthPlatform
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPlatform = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPlatform   = fmt.Errorf("proto: integer overflow")
)
