//
// This file is AUTO-GENERATED by protoc-gen-ts.
// Do not modify it manually.
///
import api from '../../api'
import * as googleTypes from '../../googleTypes'
import { Empty as arangodb_cloud_common_v1_Empty } from '../../common/v1/common'
import { IDOptions as arangodb_cloud_common_v1_IDOptions } from '../../common/v1/common'
import { ListOptions as arangodb_cloud_common_v1_ListOptions } from '../../common/v1/common'
import { Version as arangodb_cloud_common_v1_Version } from '../../common/v1/common'

// File: crypto/v1/crypto.proto
// Package: arangodb.cloud.crypto.v1

// A CACertificate is represents a self-signed certificate authority used to sign
// TLS certificates for deployments & client authentication.
export interface CACertificate {
  // System identifier of the CA certificate.
  // This is a read-only value.
  // string
  id?: string;
  
  // URL of this resource
  // This is a read-only value.
  // string
  url?: string;
  
  // Name of the CA certificate
  // string
  name?: string;
  
  // Description of the CA certificate
  // string
  description?: string;
  
  // Identifier of the project that owns this CA certificate.
  // This value cannot be changed after creation.
  // string
  project_id?: string;
  
  // Time from creation of the CA certificate to expiration.
  // This value cannot be changed after creation.
  // googleTypes.Duration
  lifetime?: googleTypes.Duration;
  
  // The creation timestamp of the CA certificate
  // This is a read-only value.
  // googleTypes.Timestamp
  created_at?: googleTypes.Timestamp;
  
  // The deletion timestamp of the CA certificate
  // This is a read-only value.
  // googleTypes.Timestamp
  deleted_at?: googleTypes.Timestamp;
  
  // The expiration timestamp of the CA certificate
  // This is a read-only value.
  // googleTypes.Timestamp
  expires_at?: googleTypes.Timestamp;
  
  // A PEM encoded representation of the public key of the CA certificate.
  // This is a read-only value.
  // string
  certificate_pem?: string;
  
  // Set when this CA certificate is deleted.
  // This is a read-only value.
  // boolean
  is_deleted?: boolean;
  
  // Set when this CA certificate has expired.
  // This is a read-only value.
  // boolean
  is_expired?: boolean;
  
  // Set when this CA certificate will expire in the next month.
  // This is a read-only value.
  // boolean
  will_expire_soon?: boolean;
  
  // Set when this certificate is the default in its project.
  // This is a read-only value.
  // boolean
  is_default?: boolean;
  
  // When enabled, deployments using this certificate use a well known TLS certificate on the 8529 port.
  // The self-signed certificates is always hosted on port 18529.
  // boolean
  use_well_known_certificate?: boolean;
  
  // If set, this certificate cannot be deleted.
  // To delete, first update the with locked set to false.
  // boolean
  locked?: boolean;
  
  // Set when this CA certificate will expire in the next 48 hours.
  // This is a read-only value.
  // boolean
  rotation_needed?: boolean;
  
  // If set, contains the ID of a CA certificate from which this certificate was cloned.
  // This is a read-only value.
  // string
  cloned_from_id?: string;
}

// Instructions for installing & uninstalling CA certificates
export interface CACertificateInstructions {
  // Per platform instructions for install/uninstall of the CA certificate
  // CACertificateInstructions_PlatformInstructions
  platforms?: CACertificateInstructions_PlatformInstructions[];
}

// Instructions for a specific platform
export interface CACertificateInstructions_PlatformInstructions {
  // Human readable description of platform.
  // E.g. "MacOS"
  // string
  platform?: string;
  
  // Steps needed to install
  // string
  install_steps?: string[];
  
  // Steps needed to uninstall
  // string
  uninstall_steps?: string[];
}

// List of CACertificates.
export interface CACertificateList {
  // CACertificate
  items?: CACertificate[];
}

// Request arguments for ListCACertificatesWithFilter.
export interface ListCACertificatesRequest {
  // Common list options.
  // Context_id is ignored.
  // arangodb.cloud.common.v1.ListOptions
  options?: arangodb_cloud_common_v1_ListOptions;
  
  // Required ID of project to list certificates for.
  // string
  project_id?: string;
  
  // If set, include only certificates that were cloned from the certificate
  // with this ID.
  // string
  cloned_from_id?: string;
}

// CryptoService is the API used to configure various crypto objects.
export interface ICryptoService {
  // Get the current API version of this service.
  // Required permissions:
  // - None
  GetAPIVersion: (req?: arangodb_cloud_common_v1_Empty) => Promise<arangodb_cloud_common_v1_Version>;
  
  // Fetch all CA certificates in the project identified by the given context ID.
  // Required permissions:
  // - crypto.cacertificate.list on the project identified by the given context ID
  ListCACertificates: (req: arangodb_cloud_common_v1_ListOptions) => Promise<CACertificateList>;
  
  // Fetch all CA certificates in the project identified by the given project ID
  // that match the given filter.
  // Required permissions:
  // - crypto.cacertificate.list on the project identified by the given context ID
  ListCACertificatesWithFilter: (req: ListCACertificatesRequest) => Promise<CACertificateList>;
  
  // Fetch a CA certificate by its id.
  // Required permissions:
  // - crypto.cacertificate.get on the CA certificate identified by the given ID
  GetCACertificate: (req: arangodb_cloud_common_v1_IDOptions) => Promise<CACertificate>;
  
  // Fetch instructions for installing & unistalling a CA certificate identified by its id
  // on various platforms.
  // Required permissions:
  // - crypto.cacertificate.get on the CA certificate identified by the given ID
  GetCACertificateInstructions: (req: arangodb_cloud_common_v1_IDOptions) => Promise<CACertificateInstructions>;
  
  // Create a new CA certificate
  // Required permissions:
  // - crypto.cacertificate.create on the project that owns the CA certificate
  CreateCACertificate: (req: CACertificate) => Promise<CACertificate>;
  
  // Clone a CA certificate identified by given id.
  // Required permissions:
  // - crypto.cacertificate.clone on the project that owns the CA certificate identified by the given ID
  CloneCACertificate: (req: arangodb_cloud_common_v1_IDOptions) => Promise<CACertificate>;
  
  // Update a CA certificate
  // Required permissions:
  // - crypto.cacertificate.update on the CA certificate
  UpdateCACertificate: (req: CACertificate) => Promise<CACertificate>;
  
  // Delete a CA certificate
  // Note that CA certificate are initially only marked for deleted.
  // Once all the resources that depend on it are removed the CA certificate itself is deleted
  // and cannot be restored.
  // Required permissions:
  // - crypto.cacertificate.delete on the CA certificate
  DeleteCACertificate: (req: arangodb_cloud_common_v1_IDOptions) => Promise<void>;
  
  // Mark the given CA certificate as default for its containing project.
  // Required permissions:
  // - crypto.cacertificate.set-default on the project that owns the certificate.
  SetDefaultCACertificate: (req: CACertificate) => Promise<void>;
}

// CryptoService is the API used to configure various crypto objects.
export class CryptoService implements ICryptoService {
  // Get the current API version of this service.
  // Required permissions:
  // - None
  async GetAPIVersion(req?: arangodb_cloud_common_v1_Empty): Promise<arangodb_cloud_common_v1_Version> {
    const path = `/api/crypto/v1/api-version`;
    const url = path + api.queryString(req, []);
    return api.get(url, undefined);
  }
  
  // Fetch all CA certificates in the project identified by the given context ID.
  // Required permissions:
  // - crypto.cacertificate.list on the project identified by the given context ID
  async ListCACertificates(req: arangodb_cloud_common_v1_ListOptions): Promise<CACertificateList> {
    const path = `/api/crypto/v1/projects/${encodeURIComponent(req.context_id || '')}/cacertificates`;
    const url = path + api.queryString(req, [`context_id`]);
    return api.get(url, undefined);
  }
  
  // Fetch all CA certificates in the project identified by the given project ID
  // that match the given filter.
  // Required permissions:
  // - crypto.cacertificate.list on the project identified by the given context ID
  async ListCACertificatesWithFilter(req: ListCACertificatesRequest): Promise<CACertificateList> {
    const url = `/api/crypto/v1/projects/${encodeURIComponent(req.project_id || '')}/cacertificates`;
    return api.post(url, req);
  }
  
  // Fetch a CA certificate by its id.
  // Required permissions:
  // - crypto.cacertificate.get on the CA certificate identified by the given ID
  async GetCACertificate(req: arangodb_cloud_common_v1_IDOptions): Promise<CACertificate> {
    const path = `/api/crypto/v1/cacertificates/${encodeURIComponent(req.id || '')}`;
    const url = path + api.queryString(req, [`id`]);
    return api.get(url, undefined);
  }
  
  // Fetch instructions for installing & unistalling a CA certificate identified by its id
  // on various platforms.
  // Required permissions:
  // - crypto.cacertificate.get on the CA certificate identified by the given ID
  async GetCACertificateInstructions(req: arangodb_cloud_common_v1_IDOptions): Promise<CACertificateInstructions> {
    const path = `/api/crypto/v1/cacertificates/${encodeURIComponent(req.id || '')}/instructions`;
    const url = path + api.queryString(req, [`id`]);
    return api.get(url, undefined);
  }
  
  // Create a new CA certificate
  // Required permissions:
  // - crypto.cacertificate.create on the project that owns the CA certificate
  async CreateCACertificate(req: CACertificate): Promise<CACertificate> {
    const url = `/api/crypto/v1/projects/${encodeURIComponent(req.project_id || '')}/cacertificates`;
    return api.post(url, req);
  }
  
  // Clone a CA certificate identified by given id.
  // Required permissions:
  // - crypto.cacertificate.clone on the project that owns the CA certificate identified by the given ID
  async CloneCACertificate(req: arangodb_cloud_common_v1_IDOptions): Promise<CACertificate> {
    const path = `/api/crypto/v1/cacertificates/${encodeURIComponent(req.id || '')}/clone`;
    const url = path + api.queryString(req, [`id`]);
    return api.post(url, undefined);
  }
  
  // Update a CA certificate
  // Required permissions:
  // - crypto.cacertificate.update on the CA certificate
  async UpdateCACertificate(req: CACertificate): Promise<CACertificate> {
    const url = `/api/crypto/v1/cacertificates/${encodeURIComponent(req.id || '')}`;
    return api.patch(url, req);
  }
  
  // Delete a CA certificate
  // Note that CA certificate are initially only marked for deleted.
  // Once all the resources that depend on it are removed the CA certificate itself is deleted
  // and cannot be restored.
  // Required permissions:
  // - crypto.cacertificate.delete on the CA certificate
  async DeleteCACertificate(req: arangodb_cloud_common_v1_IDOptions): Promise<void> {
    const path = `/api/crypto/v1/cacertificates/${encodeURIComponent(req.id || '')}`;
    const url = path + api.queryString(req, [`id`]);
    return api.delete(url, undefined);
  }
  
  // Mark the given CA certificate as default for its containing project.
  // Required permissions:
  // - crypto.cacertificate.set-default on the project that owns the certificate.
  async SetDefaultCACertificate(req: CACertificate): Promise<void> {
    const url = `/api/crypto/v1/projects/${encodeURIComponent(req.project_id || '')}/cacertificates/default`;
    return api.post(url, req);
  }
}
