//
// DISCLAIMER
//
// Copyright 2020 ArangoDB GmbH, Cologne, Germany
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Copyright holder is ArangoDB GmbH, Cologne, Germany
//
// Author Ewout Prangsma
//

package v1

import "sort"

// GetAllEmails returns all email addresses of the given user.
func (u *User) GetAllEmails() []string {
	if u == nil {
		return nil
	}
	result := u.GetAdditionalEmails()
	if email := u.GetEmail(); email != "" {
		result = append(result, email)
	}
	// Remove duplicates
	sort.Strings(result)
	for i, v := range result {
		if (i > 0) && v == result[i-1] {
			// Remove element at i
			result = append(result[:i], result[i+1:]...)
		}
	}
	return result
}
