// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: audit.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// AuditLog holds a specification destinations that audit events should be
// sent to and it acts as a grouping of audit log archives.
type AuditLog struct {
	// The ID of this resource.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the audit log
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the audit log
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The creation timestamp of the resource
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the resource
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,6,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this resource is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,7,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the user who created this resource.
	// This is a read-only value.
	CreatedById string `protobuf:"bytes,8,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// Identifier of the organization that owns this audit log.
	// After creation, this value cannot be changed.
	OrganizationId string `protobuf:"bytes,9,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, this AuditLog is the default for the organization.
	// This is a read-only value.
	// The default AuditLog for an organization is used to capture audit events
	// from the Oasis platform. If there is no default AuditLog, audit events
	// from the Oasis platform are not captured.
	// The default AuditLog is also attached to new projects in the organization.
	IsDefault bool `protobuf:"varint,10,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// Destinations that events of this AuditLog should be sent to.
	// Note that there can only be 1 destination of type "cloud".
	Destinations         []*AuditLog_Destination `protobuf:"bytes,100,rep,name=destinations,proto3" json:"destinations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *AuditLog) Reset()         { *m = AuditLog{} }
func (m *AuditLog) String() string { return proto.CompactTextString(m) }
func (*AuditLog) ProtoMessage()    {}
func (*AuditLog) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0}
}
func (m *AuditLog) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog.Merge(m, src)
}
func (m *AuditLog) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog proto.InternalMessageInfo

func (m *AuditLog) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AuditLog) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *AuditLog) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AuditLog) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *AuditLog) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *AuditLog) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *AuditLog) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *AuditLog) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *AuditLog) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *AuditLog) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *AuditLog) GetDestinations() []*AuditLog_Destination {
	if m != nil {
		return m.Destinations
	}
	return nil
}

// Settings for a destination of type "https-post"
type AuditLog_HttpsPostSettings struct {
	// URL of the server to POST to.
	// The scheme of the URL must be "https".
	// The used URLs within a single audit log should be unique.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// PEM encoded public key of the CA used to sign
	// the server TLS certificate.
	// This public key will be used to verify the
	// TLS connection provided by the server.
	// If this field is empty, a well known CA is expected.
	TrustedServerCaPem string `protobuf:"bytes,2,opt,name=trusted_server_ca_pem,json=trustedServerCaPem,proto3" json:"trusted_server_ca_pem,omitempty"`
	// PEM encoded public key of the client certificate
	// used to make the request.
	ClientCertificatePem string `protobuf:"bytes,3,opt,name=client_certificate_pem,json=clientCertificatePem,proto3" json:"client_certificate_pem,omitempty"`
	// PEM encoded private key of the client certificate
	// used to make the request.
	// This is a write-only value.
	ClientKeyPem string `protobuf:"bytes,4,opt,name=client_key_pem,json=clientKeyPem,proto3" json:"client_key_pem,omitempty"`
	// HTTP headers to add to the request.
	// It is allowed to pass multiple headers with the same key.
	Headers []*AuditLog_Header `protobuf:"bytes,5,rep,name=headers,proto3" json:"headers,omitempty"`
	// The period this https-post destination will retry to deliver audit events.
	// Not specifying this value will default to 4 hours, the maximum allowed value is 24 hours.
	// When this time is exceeded for an event this event will be discarded, however newer events will still be delivered.
	RetryPeriod          *types.Duration `protobuf:"bytes,200,opt,name=retry_period,json=retryPeriod,proto3" json:"retry_period,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *AuditLog_HttpsPostSettings) Reset()         { *m = AuditLog_HttpsPostSettings{} }
func (m *AuditLog_HttpsPostSettings) String() string { return proto.CompactTextString(m) }
func (*AuditLog_HttpsPostSettings) ProtoMessage()    {}
func (*AuditLog_HttpsPostSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0, 0}
}
func (m *AuditLog_HttpsPostSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog_HttpsPostSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog_HttpsPostSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog_HttpsPostSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog_HttpsPostSettings.Merge(m, src)
}
func (m *AuditLog_HttpsPostSettings) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog_HttpsPostSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog_HttpsPostSettings.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog_HttpsPostSettings proto.InternalMessageInfo

func (m *AuditLog_HttpsPostSettings) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *AuditLog_HttpsPostSettings) GetTrustedServerCaPem() string {
	if m != nil {
		return m.TrustedServerCaPem
	}
	return ""
}

func (m *AuditLog_HttpsPostSettings) GetClientCertificatePem() string {
	if m != nil {
		return m.ClientCertificatePem
	}
	return ""
}

func (m *AuditLog_HttpsPostSettings) GetClientKeyPem() string {
	if m != nil {
		return m.ClientKeyPem
	}
	return ""
}

func (m *AuditLog_HttpsPostSettings) GetHeaders() []*AuditLog_Header {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *AuditLog_HttpsPostSettings) GetRetryPeriod() *types.Duration {
	if m != nil {
		return m.RetryPeriod
	}
	return nil
}

// HTTP header pair
type AuditLog_Header struct {
	// Key of the header
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Value of the header
	// This is a write-only value.
	// On read requests, the value is mangled to something like "abc..."
	Value                string   `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLog_Header) Reset()         { *m = AuditLog_Header{} }
func (m *AuditLog_Header) String() string { return proto.CompactTextString(m) }
func (*AuditLog_Header) ProtoMessage()    {}
func (*AuditLog_Header) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0, 1}
}
func (m *AuditLog_Header) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog_Header) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog_Header.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog_Header) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog_Header.Merge(m, src)
}
func (m *AuditLog_Header) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog_Header) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog_Header.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog_Header proto.InternalMessageInfo

func (m *AuditLog_Header) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *AuditLog_Header) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

// The status of a destination for audit events (for a deployment).
// All fields in this message are read-only values.
type AuditLog_DestinationStatus struct {
	// ID of the deployment that the status applied to (if applicable)
	// The deployment ID of the status is optional, inside the list at most
	// one destination status is allowed to be empty, meaning the Oasis status,
	// all others will be bound to a specific deployment as indicated by this ID.
	DeploymentId string `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Set if this destination (for the provided deployment) has errors.
	HasErrors bool `protobuf:"varint,2,opt,name=has_errors,json=hasErrors,proto3" json:"has_errors,omitempty"`
	// Human readable error message (if any).
	ErrorDetails string `protobuf:"bytes,3,opt,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
	// The counters of a destination for audit events (for the provided deployment) for today since midnight.
	// The fields inside this message will be reset at midnight UTC.
	// The updated_at timestamp will be used as baseline for the time.
	CountersSinceMidnight *AuditLog_DestinationCounters `protobuf:"bytes,10,opt,name=counters_since_midnight,json=countersSinceMidnight,proto3" json:"counters_since_midnight,omitempty"`
	// The counters of a destination for audit events (for the provided deployment) for yesterday.
	// The updated_at timestamp will be used as baseline for the time.
	CountersYesterday *AuditLog_DestinationCounters `protobuf:"bytes,11,opt,name=counters_yesterday,json=countersYesterday,proto3" json:"counters_yesterday,omitempty"`
	// Timestamp when this status has been last updated.
	// This is used as baseline for the counters_since_midnight and counters_yesterday fields.
	UpdatedAt *types.Timestamp `protobuf:"bytes,100,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Last known name of the deployment identified by deployment_id (if any).
	// This is a read-only value.
	DeploymentName       string   `protobuf:"bytes,101,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLog_DestinationStatus) Reset()         { *m = AuditLog_DestinationStatus{} }
func (m *AuditLog_DestinationStatus) String() string { return proto.CompactTextString(m) }
func (*AuditLog_DestinationStatus) ProtoMessage()    {}
func (*AuditLog_DestinationStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0, 2}
}
func (m *AuditLog_DestinationStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog_DestinationStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog_DestinationStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog_DestinationStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog_DestinationStatus.Merge(m, src)
}
func (m *AuditLog_DestinationStatus) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog_DestinationStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog_DestinationStatus.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog_DestinationStatus proto.InternalMessageInfo

func (m *AuditLog_DestinationStatus) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *AuditLog_DestinationStatus) GetHasErrors() bool {
	if m != nil {
		return m.HasErrors
	}
	return false
}

func (m *AuditLog_DestinationStatus) GetErrorDetails() string {
	if m != nil {
		return m.ErrorDetails
	}
	return ""
}

func (m *AuditLog_DestinationStatus) GetCountersSinceMidnight() *AuditLog_DestinationCounters {
	if m != nil {
		return m.CountersSinceMidnight
	}
	return nil
}

func (m *AuditLog_DestinationStatus) GetCountersYesterday() *AuditLog_DestinationCounters {
	if m != nil {
		return m.CountersYesterday
	}
	return nil
}

func (m *AuditLog_DestinationStatus) GetUpdatedAt() *types.Timestamp {
	if m != nil {
		return m.UpdatedAt
	}
	return nil
}

func (m *AuditLog_DestinationStatus) GetDeploymentName() string {
	if m != nil {
		return m.DeploymentName
	}
	return ""
}

// The counters of a destination for audit events (for the provided deployment).
// All fields in this message are read-only values.
type AuditLog_DestinationCounters struct {
	// The number of audit log events this destination has been processed.
	// This number will not include the excluded events, so contain events which are relevant after filtering only.
	Events int64 `protobuf:"varint,1,opt,name=events,proto3" json:"events,omitempty"`
	// The number of audit log events this destination has been excluded based on the provided 'excluded_topics' filter.
	EventsExcluded int64 `protobuf:"varint,2,opt,name=events_excluded,json=eventsExcluded,proto3" json:"events_excluded,omitempty"`
	// The number of undeliverable audit log events for this destination.
	// Undeliverable means that they are removed without being successfully processed, retries are not taken into account here.
	EventsUndeliverable int64 `protobuf:"varint,3,opt,name=events_undeliverable,json=eventsUndeliverable,proto3" json:"events_undeliverable,omitempty"`
	// The bytes of successfull audit log events this destination has been processed.
	BytesSucceeded int64 `protobuf:"varint,10,opt,name=bytes_succeeded,json=bytesSucceeded,proto3" json:"bytes_succeeded,omitempty"`
	// The bytes of unsuccessfull audit log events this destination has been trying to process.
	// This include retries, however not any filtered events or undeliverable events which are discarded based on retry_period period without being ever sent.
	BytesFailed int64 `protobuf:"varint,11,opt,name=bytes_failed,json=bytesFailed,proto3" json:"bytes_failed,omitempty"`
	// The number of successfull HTTPS posts this destination has been sent.
	// An HTTPS POST request is considered successful when a status code between 200 and 299 is returned.
	// This field is used when the destination type is "https-post" only.
	HttpsPostsSucceeded int64 `protobuf:"varint,20,opt,name=https_posts_succeeded,json=httpsPostsSucceeded,proto3" json:"https_posts_succeeded,omitempty"`
	// The number of unsuccessfull HTTPS posts this destination has been trying to sent.
	// This field is used when the destination type is "https-post" only.
	HttpsPostsFailed     int64    `protobuf:"varint,21,opt,name=https_posts_failed,json=httpsPostsFailed,proto3" json:"https_posts_failed,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLog_DestinationCounters) Reset()         { *m = AuditLog_DestinationCounters{} }
func (m *AuditLog_DestinationCounters) String() string { return proto.CompactTextString(m) }
func (*AuditLog_DestinationCounters) ProtoMessage()    {}
func (*AuditLog_DestinationCounters) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0, 3}
}
func (m *AuditLog_DestinationCounters) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog_DestinationCounters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog_DestinationCounters.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog_DestinationCounters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog_DestinationCounters.Merge(m, src)
}
func (m *AuditLog_DestinationCounters) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog_DestinationCounters) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog_DestinationCounters.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog_DestinationCounters proto.InternalMessageInfo

func (m *AuditLog_DestinationCounters) GetEvents() int64 {
	if m != nil {
		return m.Events
	}
	return 0
}

func (m *AuditLog_DestinationCounters) GetEventsExcluded() int64 {
	if m != nil {
		return m.EventsExcluded
	}
	return 0
}

func (m *AuditLog_DestinationCounters) GetEventsUndeliverable() int64 {
	if m != nil {
		return m.EventsUndeliverable
	}
	return 0
}

func (m *AuditLog_DestinationCounters) GetBytesSucceeded() int64 {
	if m != nil {
		return m.BytesSucceeded
	}
	return 0
}

func (m *AuditLog_DestinationCounters) GetBytesFailed() int64 {
	if m != nil {
		return m.BytesFailed
	}
	return 0
}

func (m *AuditLog_DestinationCounters) GetHttpsPostsSucceeded() int64 {
	if m != nil {
		return m.HttpsPostsSucceeded
	}
	return 0
}

func (m *AuditLog_DestinationCounters) GetHttpsPostsFailed() int64 {
	if m != nil {
		return m.HttpsPostsFailed
	}
	return 0
}

// Specification of a destination for audit events.
type AuditLog_Destination struct {
	// Type of destination.
	// Possible values are: "cloud", "https-post"
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Do not send audit events with these topics to this destination.
	ExcludedTopics []string `protobuf:"bytes,2,rep,name=excluded_topics,json=excludedTopics,proto3" json:"excluded_topics,omitempty"`
	// Settings for destinations of type "https-post"
	HttpPost *AuditLog_HttpsPostSettings `protobuf:"bytes,10,opt,name=http_post,json=httpPost,proto3" json:"http_post,omitempty"`
	// Status of this destination (per deployment)
	// This is a read-only value.
	Statuses []*AuditLog_DestinationStatus `protobuf:"bytes,100,rep,name=Statuses,proto3" json:"Statuses,omitempty"`
	// Identifier of this destination.
	// This is a read-only value. To ensure matching updates of destinations,
	// include this field in calls to UpdateAuditLog and TestAuditLogHttpsPostDestination.
	Id                   string   `protobuf:"bytes,101,opt,name=id,proto3" json:"id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLog_Destination) Reset()         { *m = AuditLog_Destination{} }
func (m *AuditLog_Destination) String() string { return proto.CompactTextString(m) }
func (*AuditLog_Destination) ProtoMessage()    {}
func (*AuditLog_Destination) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{0, 4}
}
func (m *AuditLog_Destination) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLog_Destination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLog_Destination.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLog_Destination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLog_Destination.Merge(m, src)
}
func (m *AuditLog_Destination) XXX_Size() int {
	return m.Size()
}
func (m *AuditLog_Destination) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLog_Destination.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLog_Destination proto.InternalMessageInfo

func (m *AuditLog_Destination) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *AuditLog_Destination) GetExcludedTopics() []string {
	if m != nil {
		return m.ExcludedTopics
	}
	return nil
}

func (m *AuditLog_Destination) GetHttpPost() *AuditLog_HttpsPostSettings {
	if m != nil {
		return m.HttpPost
	}
	return nil
}

func (m *AuditLog_Destination) GetStatuses() []*AuditLog_DestinationStatus {
	if m != nil {
		return m.Statuses
	}
	return nil
}

func (m *AuditLog_Destination) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

// List of AuditLog's.
type AuditLogList struct {
	Items                []*AuditLog `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AuditLogList) Reset()         { *m = AuditLogList{} }
func (m *AuditLogList) String() string { return proto.CompactTextString(m) }
func (*AuditLogList) ProtoMessage()    {}
func (*AuditLogList) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{1}
}
func (m *AuditLogList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogList.Merge(m, src)
}
func (m *AuditLogList) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogList) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogList.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogList proto.InternalMessageInfo

func (m *AuditLogList) GetItems() []*AuditLog {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListAuditLogs
type ListAuditLogsRequest struct {
	// Identifier of the organization to request the audit logs for.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, the result includes all audit logs, including those who set to deleted,
	// however are not removed from the system currently.
	// If not set, only audit logs not indicated as deleted are returned.
	IncludeDeleted bool `protobuf:"varint,2,opt,name=include_deleted,json=includeDeleted,proto3" json:"include_deleted,omitempty"`
	// Optional common list options, the context_id is ignored
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListAuditLogsRequest) Reset()         { *m = ListAuditLogsRequest{} }
func (m *ListAuditLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAuditLogsRequest) ProtoMessage()    {}
func (*ListAuditLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{2}
}
func (m *ListAuditLogsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAuditLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAuditLogsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAuditLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAuditLogsRequest.Merge(m, src)
}
func (m *ListAuditLogsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListAuditLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAuditLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAuditLogsRequest proto.InternalMessageInfo

func (m *ListAuditLogsRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListAuditLogsRequest) GetIncludeDeleted() bool {
	if m != nil {
		return m.IncludeDeleted
	}
	return false
}

func (m *ListAuditLogsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// AuditLogArchive collects files of audit events in a specific region,
// usually for a specific deployment.
type AuditLogArchive struct {
	// The ID of this resource.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// The creation timestamp of the resource
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,3,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the resource
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,4,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this resource is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,5,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the auditlog that owns this audit log archive.
	// This is a read-only value.
	AuditlogId string `protobuf:"bytes,6,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	// If set, this archive is collecting audit events for a deployment with this ID.
	// Note that the deployment may have already been deleted.
	DeploymentId string `protobuf:"bytes,7,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Last known size of this archive in bytes.
	// Note that this field is only update periodically.
	// This is a read-only value.
	SizeInBytes uint64 `protobuf:"varint,8,opt,name=size_in_bytes,json=sizeInBytes,proto3" json:"size_in_bytes,omitempty"`
	// The timestamp of the last modification of size_in_bytes.
	// This is a read-only value.
	SizeInBytesChangedAt *types.Timestamp `protobuf:"bytes,9,opt,name=size_in_bytes_changed_at,json=sizeInBytesChangedAt,proto3" json:"size_in_bytes_changed_at,omitempty"`
	// If set, this archive is collecting audit events for a deployment in the project with this ID.
	// This is a read-only value.
	ProjectId string `protobuf:"bytes,10,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Last known name of the deployment identified by deployment_id.
	// This is a read-only value.
	DeploymentName string `protobuf:"bytes,11,opt,name=deployment_name,json=deploymentName,proto3" json:"deployment_name,omitempty"`
	// Last known name of the project identified by project_id.
	// This is a read-only value.
	ProjectName string `protobuf:"bytes,12,opt,name=project_name,json=projectName,proto3" json:"project_name,omitempty"`
	// If set, it is safe to delete this archive.
	// It does not mean that the caller has permission to delete the archive.
	// This is a read-only value.
	CanDelete            bool     `protobuf:"varint,13,opt,name=can_delete,json=canDelete,proto3" json:"can_delete,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLogArchive) Reset()         { *m = AuditLogArchive{} }
func (m *AuditLogArchive) String() string { return proto.CompactTextString(m) }
func (*AuditLogArchive) ProtoMessage()    {}
func (*AuditLogArchive) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{3}
}
func (m *AuditLogArchive) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogArchive) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogArchive.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogArchive) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogArchive.Merge(m, src)
}
func (m *AuditLogArchive) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogArchive) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogArchive.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogArchive proto.InternalMessageInfo

func (m *AuditLogArchive) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AuditLogArchive) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *AuditLogArchive) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *AuditLogArchive) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *AuditLogArchive) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *AuditLogArchive) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func (m *AuditLogArchive) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *AuditLogArchive) GetSizeInBytes() uint64 {
	if m != nil {
		return m.SizeInBytes
	}
	return 0
}

func (m *AuditLogArchive) GetSizeInBytesChangedAt() *types.Timestamp {
	if m != nil {
		return m.SizeInBytesChangedAt
	}
	return nil
}

func (m *AuditLogArchive) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *AuditLogArchive) GetDeploymentName() string {
	if m != nil {
		return m.DeploymentName
	}
	return ""
}

func (m *AuditLogArchive) GetProjectName() string {
	if m != nil {
		return m.ProjectName
	}
	return ""
}

func (m *AuditLogArchive) GetCanDelete() bool {
	if m != nil {
		return m.CanDelete
	}
	return false
}

// List of AuditLogArchive's.
type AuditLogArchiveList struct {
	Items                []*AuditLogArchive `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *AuditLogArchiveList) Reset()         { *m = AuditLogArchiveList{} }
func (m *AuditLogArchiveList) String() string { return proto.CompactTextString(m) }
func (*AuditLogArchiveList) ProtoMessage()    {}
func (*AuditLogArchiveList) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{4}
}
func (m *AuditLogArchiveList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogArchiveList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogArchiveList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogArchiveList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogArchiveList.Merge(m, src)
}
func (m *AuditLogArchiveList) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogArchiveList) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogArchiveList.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogArchiveList proto.InternalMessageInfo

func (m *AuditLogArchiveList) GetItems() []*AuditLogArchive {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListAuditLogArchives
type ListAuditLogArchivesRequest struct {
	// Identifier of the audit log to request the audit log archives for.
	AuditlogId string `protobuf:"bytes,1,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	// If set, the result includes all audit log archives, including those who set to deleted,
	// however are not removed from the system currently.
	// If not set, only audit log archives not indicated as deleted are returned.
	IncludeDeleted bool `protobuf:"varint,2,opt,name=include_deleted,json=includeDeleted,proto3" json:"include_deleted,omitempty"`
	// If set, the results will only include archive items which belong to the
	// deployment identified by this ID.
	DeploymentId string `protobuf:"bytes,3,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// If set, the results will only include archive items which belong to no deployment.
	// Setting this field and specifying a deployment_id will result in an empty list.
	WithoutDeployments bool `protobuf:"varint,4,opt,name=without_deployments,json=withoutDeployments,proto3" json:"without_deployments,omitempty"`
	// If set, the results will only include archive items which belong to the
	// project identified by this ID.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Optional common list options, the context_id is ignored
	Options              *v1.ListOptions `protobuf:"bytes,10,opt,name=options,proto3" json:"options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *ListAuditLogArchivesRequest) Reset()         { *m = ListAuditLogArchivesRequest{} }
func (m *ListAuditLogArchivesRequest) String() string { return proto.CompactTextString(m) }
func (*ListAuditLogArchivesRequest) ProtoMessage()    {}
func (*ListAuditLogArchivesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{5}
}
func (m *ListAuditLogArchivesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAuditLogArchivesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAuditLogArchivesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAuditLogArchivesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAuditLogArchivesRequest.Merge(m, src)
}
func (m *ListAuditLogArchivesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListAuditLogArchivesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAuditLogArchivesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAuditLogArchivesRequest proto.InternalMessageInfo

func (m *ListAuditLogArchivesRequest) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func (m *ListAuditLogArchivesRequest) GetIncludeDeleted() bool {
	if m != nil {
		return m.IncludeDeleted
	}
	return false
}

func (m *ListAuditLogArchivesRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ListAuditLogArchivesRequest) GetWithoutDeployments() bool {
	if m != nil {
		return m.WithoutDeployments
	}
	return false
}

func (m *ListAuditLogArchivesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListAuditLogArchivesRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

// Single audit log event
type AuditLogEvent struct {
	// When did the event happen
	Timestamp *types.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Topic of the event
	Topic string `protobuf:"bytes,2,opt,name=topic,proto3" json:"topic,omitempty"`
	// ID of the project that the event happened in (if applicable)
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the deployment that the event happened in (if applicable)
	DeploymentId string `protobuf:"bytes,4,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// ID of the server that the event happened in (if applicable)
	ServerId string `protobuf:"bytes,5,opt,name=server_id,json=serverId,proto3" json:"server_id,omitempty"`
	// Instance ID of the server that the event happened in (if applicable)
	InstanceId string `protobuf:"bytes,6,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Sequence number. Must be even increasing for (deployment_id, server_id, instance_id) pairs.
	Sequence uint64 `protobuf:"varint,7,opt,name=sequence,proto3" json:"sequence,omitempty"`
	// ID of the user that caused the event
	UserId string `protobuf:"bytes,8,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Name of database the operation is in (if applicable)
	Database string `protobuf:"bytes,9,opt,name=database,proto3" json:"database,omitempty"`
	// IP address of source of operation (if available)
	ClientIp string `protobuf:"bytes,10,opt,name=client_ip,json=clientIp,proto3" json:"client_ip,omitempty"`
	// Authentication details
	Authentication string `protobuf:"bytes,11,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// Free format text describing the event
	Message string `protobuf:"bytes,12,opt,name=message,proto3" json:"message,omitempty"`
	// ID of the AuditLogArchive that contains this event (if applicable)
	AuditlogarchiveId string `protobuf:"bytes,13,opt,name=auditlogarchive_id,json=auditlogarchiveId,proto3" json:"auditlogarchive_id,omitempty"`
	// Verb of the event (if applicable)
	Verb                 string   `protobuf:"bytes,14,opt,name=verb,proto3" json:"verb,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLogEvent) Reset()         { *m = AuditLogEvent{} }
func (m *AuditLogEvent) String() string { return proto.CompactTextString(m) }
func (*AuditLogEvent) ProtoMessage()    {}
func (*AuditLogEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{6}
}
func (m *AuditLogEvent) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogEvent.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogEvent.Merge(m, src)
}
func (m *AuditLogEvent) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogEvent.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogEvent proto.InternalMessageInfo

func (m *AuditLogEvent) GetTimestamp() *types.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *AuditLogEvent) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *AuditLogEvent) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *AuditLogEvent) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *AuditLogEvent) GetServerId() string {
	if m != nil {
		return m.ServerId
	}
	return ""
}

func (m *AuditLogEvent) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *AuditLogEvent) GetSequence() uint64 {
	if m != nil {
		return m.Sequence
	}
	return 0
}

func (m *AuditLogEvent) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *AuditLogEvent) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *AuditLogEvent) GetClientIp() string {
	if m != nil {
		return m.ClientIp
	}
	return ""
}

func (m *AuditLogEvent) GetAuthentication() string {
	if m != nil {
		return m.Authentication
	}
	return ""
}

func (m *AuditLogEvent) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *AuditLogEvent) GetAuditlogarchiveId() string {
	if m != nil {
		return m.AuditlogarchiveId
	}
	return ""
}

func (m *AuditLogEvent) GetVerb() string {
	if m != nil {
		return m.Verb
	}
	return ""
}

// List of AuditLogEvent's.
type AuditLogEventList struct {
	// The audit log event items.
	Items []*AuditLogEvent `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	// A cursor is opaq information to be provided by a next call to GetAuditLogEvents, to continue from this point on
	// (meaning after the last item in the provided items).
	// If the string has a non empty value there is (potentially) more data, if the string is empty (""), no more data is available.
	Cursor               string   `protobuf:"bytes,2,opt,name=cursor,proto3" json:"cursor,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLogEventList) Reset()         { *m = AuditLogEventList{} }
func (m *AuditLogEventList) String() string { return proto.CompactTextString(m) }
func (*AuditLogEventList) ProtoMessage()    {}
func (*AuditLogEventList) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{7}
}
func (m *AuditLogEventList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogEventList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogEventList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogEventList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogEventList.Merge(m, src)
}
func (m *AuditLogEventList) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogEventList) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogEventList.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogEventList proto.InternalMessageInfo

func (m *AuditLogEventList) GetItems() []*AuditLogEvent {
	if m != nil {
		return m.Items
	}
	return nil
}

func (m *AuditLogEventList) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

// Request arguments for GetAuditLogEvents.
type GetAuditLogEventsRequest struct {
	// Identifier of the audit log to request events for.
	// This field is optional when an auditlogarchive_id is specified, however if specified, it should match.
	AuditlogId string `protobuf:"bytes,1,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	// If set, include only events from this AuditLogArchive.
	// If this identifier is provided the auditlog_id is optional.
	AuditlogarchiveId string `protobuf:"bytes,2,opt,name=auditlogarchive_id,json=auditlogarchiveId,proto3" json:"auditlogarchive_id,omitempty"`
	// Request events created at or after this timestamp.
	// This is an optional field.
	From *types.Timestamp `protobuf:"bytes,3,opt,name=from,proto3" json:"from,omitempty"`
	// Request events created before this timestamp.
	// This is an optional field.
	To *types.Timestamp `protobuf:"bytes,4,opt,name=to,proto3" json:"to,omitempty"`
	// If non-empty, only request events with one of these topics.
	IncludedTopics []string `protobuf:"bytes,5,rep,name=included_topics,json=includedTopics,proto3" json:"included_topics,omitempty"`
	// If non-empty, leave out events with one of these topics.
	// If a topic is specified in included_topics as well as excluded_topics,
	// events of that topic will not be included in the results.
	ExcludedTopics []string `protobuf:"bytes,6,rep,name=excluded_topics,json=excludedTopics,proto3" json:"excluded_topics,omitempty"`
	// Limit the number of audit log events. Defaults to 0, meaning no limit.
	Limit int32 `protobuf:"varint,10,opt,name=limit,proto3" json:"limit,omitempty"`
	// A cursor is opaq information provided by a previous call to GetAuditLogEvents, to continue from that point on.
	Cursor               string   `protobuf:"bytes,11,opt,name=cursor,proto3" json:"cursor,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAuditLogEventsRequest) Reset()         { *m = GetAuditLogEventsRequest{} }
func (m *GetAuditLogEventsRequest) String() string { return proto.CompactTextString(m) }
func (*GetAuditLogEventsRequest) ProtoMessage()    {}
func (*GetAuditLogEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{8}
}
func (m *GetAuditLogEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetAuditLogEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetAuditLogEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetAuditLogEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAuditLogEventsRequest.Merge(m, src)
}
func (m *GetAuditLogEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetAuditLogEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAuditLogEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAuditLogEventsRequest proto.InternalMessageInfo

func (m *GetAuditLogEventsRequest) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func (m *GetAuditLogEventsRequest) GetAuditlogarchiveId() string {
	if m != nil {
		return m.AuditlogarchiveId
	}
	return ""
}

func (m *GetAuditLogEventsRequest) GetFrom() *types.Timestamp {
	if m != nil {
		return m.From
	}
	return nil
}

func (m *GetAuditLogEventsRequest) GetTo() *types.Timestamp {
	if m != nil {
		return m.To
	}
	return nil
}

func (m *GetAuditLogEventsRequest) GetIncludedTopics() []string {
	if m != nil {
		return m.IncludedTopics
	}
	return nil
}

func (m *GetAuditLogEventsRequest) GetExcludedTopics() []string {
	if m != nil {
		return m.ExcludedTopics
	}
	return nil
}

func (m *GetAuditLogEventsRequest) GetLimit() int32 {
	if m != nil {
		return m.Limit
	}
	return 0
}

func (m *GetAuditLogEventsRequest) GetCursor() string {
	if m != nil {
		return m.Cursor
	}
	return ""
}

// Request arguments for DeleteAuditLogArchiveEvents.
type DeleteAuditLogArchiveEventsRequest struct {
	// Identifier of the audit log archive to delete events from.
	AuditlogarchiveId string `protobuf:"bytes,1,opt,name=auditlogarchive_id,json=auditlogarchiveId,proto3" json:"auditlogarchive_id,omitempty"`
	// Remove events created before this timestamp.
	// Note that this timestamp will be rounded down to the nearest hour.
	To                   *types.Timestamp `protobuf:"bytes,2,opt,name=to,proto3" json:"to,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *DeleteAuditLogArchiveEventsRequest) Reset()         { *m = DeleteAuditLogArchiveEventsRequest{} }
func (m *DeleteAuditLogArchiveEventsRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAuditLogArchiveEventsRequest) ProtoMessage()    {}
func (*DeleteAuditLogArchiveEventsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{9}
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeleteAuditLogArchiveEventsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAuditLogArchiveEventsRequest.Merge(m, src)
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeleteAuditLogArchiveEventsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAuditLogArchiveEventsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAuditLogArchiveEventsRequest proto.InternalMessageInfo

func (m *DeleteAuditLogArchiveEventsRequest) GetAuditlogarchiveId() string {
	if m != nil {
		return m.AuditlogarchiveId
	}
	return ""
}

func (m *DeleteAuditLogArchiveEventsRequest) GetTo() *types.Timestamp {
	if m != nil {
		return m.To
	}
	return nil
}

// Request arguments for AttachProjectToAuditLog.
type AttachProjectToAuditLogRequest struct {
	// ID of project to attach the AuditLog to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// ID of the AuditLog to attach.
	AuditlogId           string   `protobuf:"bytes,2,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttachProjectToAuditLogRequest) Reset()         { *m = AttachProjectToAuditLogRequest{} }
func (m *AttachProjectToAuditLogRequest) String() string { return proto.CompactTextString(m) }
func (*AttachProjectToAuditLogRequest) ProtoMessage()    {}
func (*AttachProjectToAuditLogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{10}
}
func (m *AttachProjectToAuditLogRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AttachProjectToAuditLogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AttachProjectToAuditLogRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AttachProjectToAuditLogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttachProjectToAuditLogRequest.Merge(m, src)
}
func (m *AttachProjectToAuditLogRequest) XXX_Size() int {
	return m.Size()
}
func (m *AttachProjectToAuditLogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AttachProjectToAuditLogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AttachProjectToAuditLogRequest proto.InternalMessageInfo

func (m *AttachProjectToAuditLogRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *AttachProjectToAuditLogRequest) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

// Request arguments for TestAuditLogHttpsPostDestination.
type TestAuditLogHttpsPostDestinationRequest struct {
	// Identifier of the organization.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// The HTTPS post settings to test.
	Settings *AuditLog_HttpsPostSettings `protobuf:"bytes,2,opt,name=settings,proto3" json:"settings,omitempty"`
	// Identifier of the audit log.
	// This field is optional, if specified this auditlog is used to revert the redacted content (if any).
	AuditlogId string `protobuf:"bytes,100,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	// Identifier of the destination.
	// This field is optional, if specified this identifier is used, inside the provided audit log to revert the redacted content (if any).
	DestinationId        string   `protobuf:"bytes,101,opt,name=destination_id,json=destinationId,proto3" json:"destination_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestAuditLogHttpsPostDestinationRequest) Reset() {
	*m = TestAuditLogHttpsPostDestinationRequest{}
}
func (m *TestAuditLogHttpsPostDestinationRequest) String() string { return proto.CompactTextString(m) }
func (*TestAuditLogHttpsPostDestinationRequest) ProtoMessage()    {}
func (*TestAuditLogHttpsPostDestinationRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{11}
}
func (m *TestAuditLogHttpsPostDestinationRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TestAuditLogHttpsPostDestinationRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TestAuditLogHttpsPostDestinationRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TestAuditLogHttpsPostDestinationRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestAuditLogHttpsPostDestinationRequest.Merge(m, src)
}
func (m *TestAuditLogHttpsPostDestinationRequest) XXX_Size() int {
	return m.Size()
}
func (m *TestAuditLogHttpsPostDestinationRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_TestAuditLogHttpsPostDestinationRequest.DiscardUnknown(m)
}

var xxx_messageInfo_TestAuditLogHttpsPostDestinationRequest proto.InternalMessageInfo

func (m *TestAuditLogHttpsPostDestinationRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *TestAuditLogHttpsPostDestinationRequest) GetSettings() *AuditLog_HttpsPostSettings {
	if m != nil {
		return m.Settings
	}
	return nil
}

func (m *TestAuditLogHttpsPostDestinationRequest) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func (m *TestAuditLogHttpsPostDestinationRequest) GetDestinationId() string {
	if m != nil {
		return m.DestinationId
	}
	return ""
}

// Result arguments for TestAuditLogHttpsPostDestination.
type TestAuditLogHttpsPostDestinationResult struct {
	// Set if this destination has errors.
	HasErrors bool `protobuf:"varint,1,opt,name=has_errors,json=hasErrors,proto3" json:"has_errors,omitempty"`
	// Human readable error message (if any).
	ErrorDetails         string   `protobuf:"bytes,2,opt,name=error_details,json=errorDetails,proto3" json:"error_details,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TestAuditLogHttpsPostDestinationResult) Reset() {
	*m = TestAuditLogHttpsPostDestinationResult{}
}
func (m *TestAuditLogHttpsPostDestinationResult) String() string { return proto.CompactTextString(m) }
func (*TestAuditLogHttpsPostDestinationResult) ProtoMessage()    {}
func (*TestAuditLogHttpsPostDestinationResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{12}
}
func (m *TestAuditLogHttpsPostDestinationResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TestAuditLogHttpsPostDestinationResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TestAuditLogHttpsPostDestinationResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TestAuditLogHttpsPostDestinationResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TestAuditLogHttpsPostDestinationResult.Merge(m, src)
}
func (m *TestAuditLogHttpsPostDestinationResult) XXX_Size() int {
	return m.Size()
}
func (m *TestAuditLogHttpsPostDestinationResult) XXX_DiscardUnknown() {
	xxx_messageInfo_TestAuditLogHttpsPostDestinationResult.DiscardUnknown(m)
}

var xxx_messageInfo_TestAuditLogHttpsPostDestinationResult proto.InternalMessageInfo

func (m *TestAuditLogHttpsPostDestinationResult) GetHasErrors() bool {
	if m != nil {
		return m.HasErrors
	}
	return false
}

func (m *TestAuditLogHttpsPostDestinationResult) GetErrorDetails() string {
	if m != nil {
		return m.ErrorDetails
	}
	return ""
}

// Information about a possible topic of an audit log event.
type AuditLogTopic struct {
	// Identifier of the topic
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// If set, this topic is used in audit log events of deployments.
	ForDeployment bool `protobuf:"varint,2,opt,name=for_deployment,json=forDeployment,proto3" json:"for_deployment,omitempty"`
	// If set, this topic is used in audit log events of the Oasis platform.
	ForPlatform          bool     `protobuf:"varint,3,opt,name=for_platform,json=forPlatform,proto3" json:"for_platform,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AuditLogTopic) Reset()         { *m = AuditLogTopic{} }
func (m *AuditLogTopic) String() string { return proto.CompactTextString(m) }
func (*AuditLogTopic) ProtoMessage()    {}
func (*AuditLogTopic) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{13}
}
func (m *AuditLogTopic) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogTopic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogTopic.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogTopic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogTopic.Merge(m, src)
}
func (m *AuditLogTopic) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogTopic) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogTopic.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogTopic proto.InternalMessageInfo

func (m *AuditLogTopic) GetTopic() string {
	if m != nil {
		return m.Topic
	}
	return ""
}

func (m *AuditLogTopic) GetForDeployment() bool {
	if m != nil {
		return m.ForDeployment
	}
	return false
}

func (m *AuditLogTopic) GetForPlatform() bool {
	if m != nil {
		return m.ForPlatform
	}
	return false
}

// List of AuditLogTopic's
type AuditLogTopicList struct {
	Items                []*AuditLogTopic `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *AuditLogTopicList) Reset()         { *m = AuditLogTopicList{} }
func (m *AuditLogTopicList) String() string { return proto.CompactTextString(m) }
func (*AuditLogTopicList) ProtoMessage()    {}
func (*AuditLogTopicList) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{14}
}
func (m *AuditLogTopicList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AuditLogTopicList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AuditLogTopicList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AuditLogTopicList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AuditLogTopicList.Merge(m, src)
}
func (m *AuditLogTopicList) XXX_Size() int {
	return m.Size()
}
func (m *AuditLogTopicList) XXX_DiscardUnknown() {
	xxx_messageInfo_AuditLogTopicList.DiscardUnknown(m)
}

var xxx_messageInfo_AuditLogTopicList proto.InternalMessageInfo

func (m *AuditLogTopicList) GetItems() []*AuditLogTopic {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListAuditLogTopics.
type ListAuditLogTopicsRequest struct {
	// Optional common list options, the context_id is ignored
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, only topics used in audit log events of deployments are returned.
	ForDeploymentOnly bool `protobuf:"varint,2,opt,name=for_deployment_only,json=forDeploymentOnly,proto3" json:"for_deployment_only,omitempty"`
	// If set, only topics used in audit log events of the Oasis platform are returned.
	ForPlatformOnly      bool     `protobuf:"varint,3,opt,name=for_platform_only,json=forPlatformOnly,proto3" json:"for_platform_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAuditLogTopicsRequest) Reset()         { *m = ListAuditLogTopicsRequest{} }
func (m *ListAuditLogTopicsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAuditLogTopicsRequest) ProtoMessage()    {}
func (*ListAuditLogTopicsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{15}
}
func (m *ListAuditLogTopicsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListAuditLogTopicsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListAuditLogTopicsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListAuditLogTopicsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAuditLogTopicsRequest.Merge(m, src)
}
func (m *ListAuditLogTopicsRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListAuditLogTopicsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAuditLogTopicsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAuditLogTopicsRequest proto.InternalMessageInfo

func (m *ListAuditLogTopicsRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListAuditLogTopicsRequest) GetForDeploymentOnly() bool {
	if m != nil {
		return m.ForDeploymentOnly
	}
	return false
}

func (m *ListAuditLogTopicsRequest) GetForPlatformOnly() bool {
	if m != nil {
		return m.ForPlatformOnly
	}
	return false
}

// Request arguments for SetDefaultAuditLog.
type SetDefaultAuditLogRequest struct {
	// Identifier of the organization to set the default for.
	OrganizationId string `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Identifier of the new default auditlog.
	// If empty, there will be no default auditlog for the organization.
	AuditlogId           string   `protobuf:"bytes,2,opt,name=auditlog_id,json=auditlogId,proto3" json:"auditlog_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SetDefaultAuditLogRequest) Reset()         { *m = SetDefaultAuditLogRequest{} }
func (m *SetDefaultAuditLogRequest) String() string { return proto.CompactTextString(m) }
func (*SetDefaultAuditLogRequest) ProtoMessage()    {}
func (*SetDefaultAuditLogRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5594839dd8e38a1b, []int{16}
}
func (m *SetDefaultAuditLogRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SetDefaultAuditLogRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SetDefaultAuditLogRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SetDefaultAuditLogRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetDefaultAuditLogRequest.Merge(m, src)
}
func (m *SetDefaultAuditLogRequest) XXX_Size() int {
	return m.Size()
}
func (m *SetDefaultAuditLogRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetDefaultAuditLogRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetDefaultAuditLogRequest proto.InternalMessageInfo

func (m *SetDefaultAuditLogRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *SetDefaultAuditLogRequest) GetAuditlogId() string {
	if m != nil {
		return m.AuditlogId
	}
	return ""
}

func init() {
	proto.RegisterType((*AuditLog)(nil), "arangodb.cloud.audit.v1.AuditLog")
	proto.RegisterType((*AuditLog_HttpsPostSettings)(nil), "arangodb.cloud.audit.v1.AuditLog.HttpsPostSettings")
	proto.RegisterType((*AuditLog_Header)(nil), "arangodb.cloud.audit.v1.AuditLog.Header")
	proto.RegisterType((*AuditLog_DestinationStatus)(nil), "arangodb.cloud.audit.v1.AuditLog.DestinationStatus")
	proto.RegisterType((*AuditLog_DestinationCounters)(nil), "arangodb.cloud.audit.v1.AuditLog.DestinationCounters")
	proto.RegisterType((*AuditLog_Destination)(nil), "arangodb.cloud.audit.v1.AuditLog.Destination")
	proto.RegisterType((*AuditLogList)(nil), "arangodb.cloud.audit.v1.AuditLogList")
	proto.RegisterType((*ListAuditLogsRequest)(nil), "arangodb.cloud.audit.v1.ListAuditLogsRequest")
	proto.RegisterType((*AuditLogArchive)(nil), "arangodb.cloud.audit.v1.AuditLogArchive")
	proto.RegisterType((*AuditLogArchiveList)(nil), "arangodb.cloud.audit.v1.AuditLogArchiveList")
	proto.RegisterType((*ListAuditLogArchivesRequest)(nil), "arangodb.cloud.audit.v1.ListAuditLogArchivesRequest")
	proto.RegisterType((*AuditLogEvent)(nil), "arangodb.cloud.audit.v1.AuditLogEvent")
	proto.RegisterType((*AuditLogEventList)(nil), "arangodb.cloud.audit.v1.AuditLogEventList")
	proto.RegisterType((*GetAuditLogEventsRequest)(nil), "arangodb.cloud.audit.v1.GetAuditLogEventsRequest")
	proto.RegisterType((*DeleteAuditLogArchiveEventsRequest)(nil), "arangodb.cloud.audit.v1.DeleteAuditLogArchiveEventsRequest")
	proto.RegisterType((*AttachProjectToAuditLogRequest)(nil), "arangodb.cloud.audit.v1.AttachProjectToAuditLogRequest")
	proto.RegisterType((*TestAuditLogHttpsPostDestinationRequest)(nil), "arangodb.cloud.audit.v1.TestAuditLogHttpsPostDestinationRequest")
	proto.RegisterType((*TestAuditLogHttpsPostDestinationResult)(nil), "arangodb.cloud.audit.v1.TestAuditLogHttpsPostDestinationResult")
	proto.RegisterType((*AuditLogTopic)(nil), "arangodb.cloud.audit.v1.AuditLogTopic")
	proto.RegisterType((*AuditLogTopicList)(nil), "arangodb.cloud.audit.v1.AuditLogTopicList")
	proto.RegisterType((*ListAuditLogTopicsRequest)(nil), "arangodb.cloud.audit.v1.ListAuditLogTopicsRequest")
	proto.RegisterType((*SetDefaultAuditLogRequest)(nil), "arangodb.cloud.audit.v1.SetDefaultAuditLogRequest")
}

func init() { proto.RegisterFile("audit.proto", fileDescriptor_5594839dd8e38a1b) }

var fileDescriptor_5594839dd8e38a1b = []byte{
	// 2339 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x59, 0xcd, 0x8f, 0x1b, 0x49,
	0x15, 0xa7, 0xed, 0xf9, 0xf0, 0x3c, 0x8f, 0x9d, 0x9d, 0xca, 0x4c, 0xe2, 0x38, 0xd9, 0xd9, 0x49,
	0x27, 0x93, 0x84, 0x21, 0x63, 0x67, 0x26, 0x0b, 0xd9, 0x24, 0xbb, 0x1b, 0x66, 0x32, 0xd9, 0xac,
	0xc5, 0x2e, 0x99, 0xed, 0x49, 0x90, 0xe0, 0x62, 0x6a, 0xba, 0x6b, 0xec, 0x26, 0x76, 0xb7, 0xe9,
	0xaa, 0x36, 0x78, 0x43, 0xb4, 0x12, 0x47, 0x4e, 0x11, 0xec, 0x01, 0x21, 0x71, 0x43, 0x48, 0x1c,
	0xe0, 0x86, 0x40, 0x1c, 0x39, 0xa0, 0x3d, 0x22, 0xc1, 0x1f, 0x80, 0x02, 0xe2, 0xc2, 0xdf, 0x80,
	0xb4, 0xaa, 0xaf, 0x76, 0xbb, 0x6d, 0xa7, 0x3b, 0x93, 0xdc, 0x5c, 0xaf, 0xea, 0xbd, 0xfa, 0xd5,
	0xfb, 0x7e, 0x6d, 0x28, 0xe2, 0xd0, 0x71, 0x59, 0xad, 0x17, 0xf8, 0xcc, 0x47, 0xa7, 0x71, 0x80,
	0xbd, 0x96, 0xef, 0x1c, 0xd6, 0xec, 0x8e, 0x1f, 0x3a, 0x35, 0xb9, 0xd7, 0xdf, 0xaa, 0x9e, 0xb2,
	0xfd, 0x6e, 0xd7, 0xf7, 0xea, 0xfd, 0xad, 0xba, 0xfc, 0x25, 0x19, 0xaa, 0xb7, 0x5b, 0x2e, 0x6b,
	0x87, 0x87, 0x35, 0xdb, 0xef, 0xd6, 0x5b, 0x7e, 0x07, 0x7b, 0xad, 0xba, 0xd8, 0x38, 0x0c, 0x8f,
	0xea, 0x3d, 0x36, 0xe8, 0x11, 0x5a, 0x67, 0x6e, 0x97, 0x50, 0x86, 0xbb, 0xbd, 0xe1, 0x2f, 0xc5,
	0x7c, 0x33, 0x9d, 0xd9, 0x09, 0x03, 0xcc, 0x5c, 0xdf, 0x8b, 0x7e, 0x28, 0xd6, 0x73, 0x2d, 0xdf,
	0x6f, 0x75, 0x48, 0x1d, 0xf7, 0xdc, 0x3a, 0xf6, 0x3c, 0x9f, 0x89, 0x4d, 0x2a, 0x77, 0xcd, 0xcf,
	0xcb, 0x50, 0xd8, 0xe1, 0xd0, 0x3f, 0xf2, 0x5b, 0xa8, 0x0c, 0x39, 0xd7, 0xa9, 0x18, 0x6b, 0xc6,
	0x95, 0x05, 0x2b, 0xe7, 0x3a, 0xe8, 0x0d, 0xc8, 0x87, 0x41, 0xa7, 0x92, 0x13, 0x04, 0xfe, 0x13,
	0x21, 0x98, 0xf1, 0x70, 0x97, 0x54, 0xf2, 0x82, 0x24, 0x7e, 0xa3, 0x35, 0x28, 0x3a, 0x84, 0xda,
	0x81, 0xdb, 0xe3, 0x82, 0x2b, 0x33, 0x62, 0x2b, 0x4e, 0x42, 0x37, 0x01, 0xec, 0x80, 0x60, 0x46,
	0x9c, 0x26, 0x66, 0x95, 0xd9, 0x35, 0xe3, 0x4a, 0x71, 0xbb, 0x5a, 0x93, 0xb8, 0x6a, 0xfa, 0x1d,
	0xb5, 0x87, 0xfa, 0xcd, 0xd6, 0x82, 0x3a, 0xbd, 0xc3, 0x38, 0xab, 0x43, 0x3a, 0x44, 0xb1, 0xce,
	0xa5, 0xb3, 0xaa, 0xd3, 0x3b, 0x0c, 0xbd, 0x09, 0xe0, 0xd2, 0xa6, 0x5a, 0x57, 0xe6, 0xd7, 0x8c,
	0x2b, 0x05, 0x6b, 0xc1, 0xa5, 0x7b, 0x92, 0x80, 0x4c, 0x28, 0x69, 0x50, 0x87, 0x83, 0xa6, 0xeb,
	0x54, 0x0a, 0x12, 0xb8, 0x22, 0xee, 0x0e, 0x1a, 0x0e, 0xba, 0x0c, 0x27, 0xfc, 0xa0, 0x85, 0x3d,
	0xf7, 0x53, 0xa1, 0x34, 0x7e, 0x6a, 0x41, 0x9c, 0x2a, 0xc7, 0xc9, 0x0d, 0x27, 0xba, 0xeb, 0x08,
	0x87, 0x1d, 0x56, 0x81, 0xe1, 0x5d, 0x82, 0x80, 0x3e, 0x81, 0x45, 0x87, 0x50, 0xe6, 0x7a, 0x52,
	0xf7, 0x15, 0x67, 0x2d, 0x7f, 0xa5, 0xb8, 0xbd, 0x59, 0x9b, 0xe2, 0x43, 0x35, 0x6d, 0x91, 0xda,
	0xde, 0x90, 0xcb, 0x1a, 0x11, 0x51, 0xfd, 0x53, 0x0e, 0x96, 0x3e, 0x64, 0xac, 0x47, 0xf7, 0x7d,
	0xca, 0x0e, 0x08, 0x63, 0xae, 0xd7, 0xa2, 0xda, 0x62, 0xc6, 0xd0, 0x62, 0x5b, 0xb0, 0xc2, 0x82,
	0x90, 0xf2, 0x67, 0x52, 0x12, 0xf4, 0x49, 0xd0, 0xb4, 0x71, 0xb3, 0x47, 0xba, 0xca, 0xaa, 0x48,
	0x6d, 0x1e, 0x88, 0xbd, 0xbb, 0x78, 0x9f, 0x74, 0xd1, 0xdb, 0x70, 0xca, 0xee, 0xb8, 0xc4, 0x63,
	0x4d, 0x9b, 0x04, 0xcc, 0x3d, 0x72, 0x6d, 0xcc, 0x88, 0xe0, 0x91, 0x66, 0x5f, 0x96, 0xbb, 0x77,
	0x87, 0x9b, 0x9c, 0xeb, 0x22, 0x94, 0x15, 0xd7, 0x63, 0x32, 0x10, 0xa7, 0xa5, 0x27, 0x2c, 0x4a,
	0xea, 0xb7, 0xc8, 0x80, 0x9f, 0xda, 0x85, 0xf9, 0x36, 0xc1, 0x0e, 0x09, 0x68, 0x65, 0x56, 0x28,
	0xe1, 0x4a, 0xba, 0x12, 0x3e, 0x14, 0x0c, 0x96, 0x66, 0x44, 0xef, 0xc1, 0x62, 0x40, 0x58, 0xc0,
	0x2f, 0x09, 0x5c, 0xdf, 0xa9, 0x7c, 0x61, 0x08, 0xb7, 0x38, 0x33, 0xe6, 0x16, 0x7b, 0x2a, 0x12,
	0xac, 0xa2, 0x38, 0xbf, 0x2f, 0x8e, 0x57, 0xaf, 0xc1, 0x9c, 0x94, 0xc8, 0xb5, 0xf5, 0x98, 0x0c,
	0xb4, 0xb6, 0x1e, 0x93, 0x01, 0x5a, 0x86, 0xd9, 0x3e, 0xee, 0x84, 0x44, 0x69, 0x47, 0x2e, 0xaa,
	0x7f, 0xcc, 0xc3, 0x52, 0xcc, 0x12, 0x07, 0x0c, 0xb3, 0x90, 0xa2, 0x0b, 0x50, 0x72, 0x48, 0xaf,
	0xe3, 0x0f, 0xba, 0xfc, 0xd1, 0x51, 0xe0, 0x2c, 0x0e, 0x89, 0xd2, 0x31, 0xda, 0x98, 0x36, 0x49,
	0x10, 0xf8, 0x01, 0x15, 0x52, 0x0b, 0xd6, 0x42, 0x1b, 0xd3, 0x7b, 0x82, 0xc0, 0x65, 0x88, 0xad,
	0xa6, 0x43, 0x18, 0x76, 0x3b, 0x54, 0x69, 0x78, 0x51, 0x10, 0xf7, 0x24, 0x0d, 0x75, 0xe1, 0xb4,
	0xed, 0x87, 0x1e, 0x23, 0x01, 0x6d, 0x52, 0xd7, 0xb3, 0x49, 0xb3, 0xeb, 0x3a, 0x9e, 0xdb, 0x6a,
	0x4b, 0x4f, 0x2b, 0x6e, 0x7f, 0xfd, 0xa5, 0x1c, 0xe9, 0xae, 0x92, 0x65, 0xad, 0x68, 0xa9, 0x07,
	0x5c, 0xe8, 0xc7, 0x4a, 0x26, 0x72, 0x00, 0x45, 0xd7, 0x0d, 0x08, 0x65, 0x24, 0x70, 0xf0, 0xa0,
	0x52, 0x7c, 0x95, 0x9b, 0x96, 0xb4, 0xc0, 0xef, 0x6a, 0x79, 0x3c, 0xb0, 0xc3, 0x9e, 0xa3, 0x73,
	0x82, 0x93, 0x1e, 0xd8, 0xea, 0xf4, 0x0e, 0xe3, 0x51, 0x19, 0x53, 0xbc, 0xc8, 0x47, 0x44, 0x46,
	0xe5, 0x90, 0xfc, 0x6d, 0xdc, 0x25, 0x3c, 0x46, 0x4e, 0x4e, 0x80, 0x83, 0x4e, 0xc1, 0x1c, 0xe9,
	0x13, 0x8f, 0x51, 0x61, 0xb2, 0xbc, 0xa5, 0x56, 0x5c, 0xb0, 0xfc, 0xd5, 0x24, 0x3f, 0xb6, 0x3b,
	0xa1, 0x43, 0x1c, 0x61, 0xb1, 0xbc, 0x55, 0x96, 0xe4, 0x7b, 0x8a, 0x8a, 0xb6, 0x60, 0x59, 0x1d,
	0x0c, 0x3d, 0x87, 0x74, 0xdc, 0x3e, 0x09, 0xf0, 0x61, 0x47, 0xa6, 0xc5, 0xbc, 0x75, 0x52, 0xee,
	0x3d, 0x8a, 0x6f, 0x71, 0xd9, 0x87, 0x03, 0x46, 0x68, 0x93, 0x86, 0xb6, 0x4d, 0x08, 0x97, 0x0d,
	0x52, 0xb6, 0x20, 0x1f, 0x68, 0x2a, 0x3a, 0x0f, 0x8b, 0xf2, 0xe0, 0x11, 0x76, 0x3b, 0xc4, 0x11,
	0x8a, 0xcf, 0x5b, 0x45, 0x41, 0xfb, 0x40, 0x90, 0xd0, 0x36, 0xac, 0xb4, 0x79, 0xe8, 0x37, 0x7b,
	0x3e, 0x65, 0x71, 0x89, 0xcb, 0xf2, 0xfe, 0xb6, 0xce, 0x0b, 0x31, 0xb1, 0x57, 0x01, 0xc5, 0x79,
	0x94, 0xf0, 0x15, 0xc1, 0xf0, 0xc6, 0x90, 0x41, 0xde, 0x50, 0xfd, 0xbf, 0x01, 0xc5, 0x98, 0xe6,
	0x78, 0xde, 0xe7, 0x55, 0x46, 0xb9, 0xb8, 0xf8, 0x2d, 0xb4, 0xa5, 0x14, 0xd2, 0x64, 0x7e, 0xcf,
	0xb5, 0xb9, 0x7f, 0xe7, 0xb9, 0x19, 0x34, 0xf9, 0xa1, 0xa0, 0xa2, 0x7d, 0x58, 0xe0, 0x17, 0x88,
	0x9b, 0x95, 0xc7, 0x5e, 0xcf, 0x10, 0xf5, 0xc9, 0xe4, 0x66, 0x15, 0xb8, 0x14, 0x4e, 0x41, 0x0f,
	0xa0, 0x20, 0x83, 0x90, 0xe8, 0x5c, 0x7a, 0xfd, 0xa5, 0x1c, 0x53, 0x32, 0x5b, 0x91, 0x10, 0x55,
	0xf9, 0x88, 0xae, 0x7c, 0xe6, 0x7d, 0x58, 0xd4, 0x7c, 0x1f, 0xb9, 0x94, 0xa1, 0x1b, 0x30, 0xeb,
	0x32, 0xd2, 0xe5, 0x0e, 0xc3, 0x6f, 0x3b, 0x9f, 0x7a, 0x9b, 0x25, 0xcf, 0x9b, 0xbf, 0x33, 0x60,
	0x99, 0x4b, 0xd0, 0x74, 0x6a, 0x91, 0x1f, 0x86, 0x84, 0xb2, 0x49, 0xa5, 0xc5, 0x98, 0x58, 0x5a,
	0x2e, 0xc3, 0x09, 0xd7, 0x13, 0xfa, 0x8c, 0x6a, 0x99, 0x4c, 0x23, 0x65, 0x45, 0xd6, 0x05, 0xed,
	0x0e, 0xcc, 0xfb, 0x3d, 0x59, 0x5f, 0xa4, 0x92, 0xd7, 0x93, 0x28, 0x55, 0x3f, 0xd2, 0xdf, 0xaa,
	0x71, 0x48, 0x0f, 0xe4, 0x61, 0x4b, 0x73, 0x99, 0xcf, 0x66, 0xe0, 0x84, 0xc6, 0xb9, 0x13, 0xd8,
	0x6d, 0xb7, 0x4f, 0x32, 0xb4, 0x04, 0xa3, 0xc5, 0x3d, 0x7f, 0xfc, 0xe2, 0x3e, 0x73, 0xfc, 0xe2,
	0x3e, 0x9b, 0x2c, 0xee, 0x6f, 0xa9, 0x66, 0xad, 0xe3, 0xb7, 0xb8, 0x66, 0xe7, 0x04, 0x5c, 0xd0,
	0xa4, 0x86, 0x33, 0x9e, 0xbc, 0xe7, 0x27, 0x24, 0x6f, 0x13, 0x4a, 0xd4, 0xfd, 0x94, 0x34, 0x5d,
	0xaf, 0x29, 0xc2, 0x4f, 0xb4, 0x08, 0x33, 0x56, 0x91, 0x13, 0x1b, 0xde, 0x2e, 0x27, 0x21, 0x0b,
	0x2a, 0x23, 0x67, 0x9a, 0x76, 0x1b, 0x7b, 0x2d, 0xf9, 0xa2, 0x85, 0xd4, 0x17, 0x2d, 0xc7, 0x44,
	0xdd, 0x95, 0x8c, 0xf2, 0x71, 0xbd, 0xc0, 0xff, 0x01, 0xb1, 0x05, 0x32, 0x10, 0xc8, 0x16, 0x14,
	0x45, 0x7a, 0x44, 0x32, 0xff, 0x15, 0x27, 0xe5, 0x3f, 0x9e, 0x4a, 0xb4, 0x1c, 0x71, 0x6a, 0x51,
	0x76, 0x38, 0x8a, 0x26, 0x8e, 0xbc, 0x09, 0x60, 0x63, 0x4f, 0x29, 0xb2, 0x52, 0x92, 0x7a, 0xb4,
	0xb1, 0x27, 0x15, 0x69, 0x3e, 0x82, 0x93, 0x09, 0x8f, 0x10, 0xe1, 0xf0, 0xfe, 0x68, 0x38, 0xa4,
	0xd7, 0x70, 0xc5, 0xac, 0xa3, 0xe2, 0xd7, 0x39, 0x38, 0x1b, 0x8f, 0x0a, 0xb5, 0x1d, 0x05, 0x47,
	0xc2, 0x7c, 0xc6, 0x98, 0xf9, 0x32, 0x07, 0xc5, 0x98, 0x9d, 0xf3, 0x13, 0xec, 0x5c, 0x87, 0x93,
	0x3f, 0x72, 0x59, 0xdb, 0x0f, 0x59, 0x73, 0x48, 0xa7, 0xc2, 0x21, 0x0b, 0x16, 0x52, 0x5b, 0x7b,
	0xc3, 0x9d, 0x84, 0x81, 0x66, 0x93, 0x06, 0x7a, 0xe5, 0x48, 0xfc, 0x67, 0x1e, 0x4a, 0x5a, 0x37,
	0xf7, 0x78, 0x31, 0x41, 0xef, 0xc0, 0x42, 0x34, 0x13, 0x54, 0x8c, 0xf4, 0x48, 0x89, 0x0e, 0xf3,
	0x96, 0x46, 0x64, 0x67, 0xdd, 0xd2, 0x88, 0x45, 0xe2, 0x05, 0xf9, 0xe4, 0x0b, 0xc6, 0xd4, 0x36,
	0x33, 0x41, 0x6d, 0x67, 0x61, 0x41, 0xb5, 0x94, 0x91, 0x12, 0x0a, 0x92, 0xd0, 0x10, 0x11, 0xe8,
	0x7a, 0x94, 0x61, 0xde, 0xae, 0x0c, 0x23, 0x50, 0x93, 0x1a, 0x0e, 0xaa, 0x42, 0x81, 0x72, 0x73,
	0x7b, 0x36, 0x11, 0xc1, 0x37, 0x63, 0x45, 0x6b, 0x74, 0x1a, 0xe6, 0x43, 0x2a, 0xe5, 0xca, 0xae,
	0x7c, 0x8e, 0x2f, 0x25, 0x93, 0x83, 0x19, 0x3e, 0xc4, 0x94, 0xa8, 0x4e, 0x3c, 0x5a, 0x73, 0x38,
	0xaa, 0x01, 0x75, 0x7b, 0x2a, 0x68, 0x0a, 0x92, 0xd0, 0xe8, 0xa1, 0x4b, 0x50, 0xc6, 0x21, 0x6b,
	0x13, 0x8f, 0xf1, 0x86, 0x95, 0xcf, 0x29, 0x2a, 0x64, 0x46, 0xa9, 0xa8, 0x02, 0xf3, 0x5d, 0x42,
	0x29, 0x6e, 0xe9, 0x68, 0xd1, 0x4b, 0xb4, 0x09, 0x48, 0x3b, 0x20, 0x96, 0xee, 0xca, 0xe1, 0x95,
	0xc4, 0xa1, 0xa5, 0xc4, 0x4e, 0xc3, 0xe1, 0x15, 0xb3, 0x4f, 0x82, 0xc3, 0x4a, 0x59, 0x56, 0x4c,
	0xfe, 0xdb, 0x74, 0x61, 0x69, 0xc4, 0xaa, 0x22, 0x96, 0xde, 0x1d, 0x8d, 0xa5, 0x4b, 0xa9, 0xb1,
	0x24, 0x58, 0x55, 0x24, 0xf1, 0x56, 0xc6, 0x0e, 0x03, 0xea, 0x07, 0xca, 0xbc, 0x6a, 0x65, 0xfe,
	0x2d, 0x07, 0x95, 0xfb, 0x84, 0x8d, 0xf0, 0x64, 0x0f, 0xaf, 0xc9, 0x6f, 0xcd, 0x4d, 0x7b, 0x6b,
	0x0d, 0x66, 0x8e, 0x02, 0xbf, 0x9b, 0x21, 0xf9, 0x8b, 0x73, 0x68, 0x03, 0x72, 0xcc, 0xcf, 0x90,
	0xef, 0x73, 0xcc, 0x8f, 0x45, 0x7a, 0xd4, 0x65, 0xcc, 0xca, 0x2e, 0x43, 0x93, 0x55, 0x97, 0x31,
	0xa1, 0x1d, 0x99, 0x9b, 0xd8, 0x8e, 0x2c, 0xc3, 0x6c, 0xc7, 0xed, 0xba, 0xb2, 0x15, 0x99, 0xb5,
	0xe4, 0x22, 0xa6, 0xc8, 0xe2, 0x88, 0x22, 0x3f, 0x03, 0x53, 0xe6, 0x92, 0x44, 0xae, 0x1a, 0xd5,
	0xe8, 0x64, 0x85, 0x19, 0xd3, 0x14, 0x26, 0x15, 0x90, 0xcb, 0xa2, 0x00, 0xf3, 0xfb, 0xb0, 0xba,
	0xc3, 0x18, 0xb6, 0xdb, 0xfb, 0x32, 0x3a, 0x1f, 0xfa, 0x51, 0x8f, 0xa1, 0x2e, 0x1f, 0x8d, 0x65,
	0x23, 0x19, 0xcb, 0x09, 0x6b, 0xe7, 0x92, 0xd6, 0x36, 0xff, 0x67, 0xc0, 0xe5, 0x87, 0x64, 0x98,
	0x8d, 0xa3, 0xce, 0x2b, 0x3e, 0x7d, 0xbe, 0x6c, 0xdb, 0xf2, 0x80, 0x87, 0xb7, 0x6c, 0xdc, 0xd4,
	0x43, 0x8f, 0xd7, 0xf3, 0x69, 0x21, 0xc9, 0x67, 0x38, 0x63, 0x4e, 0xbb, 0x0e, 0xe5, 0xd8, 0x84,
	0xdc, 0x8c, 0xfa, 0xb9, 0x52, 0x8c, 0xda, 0x70, 0xcc, 0x0e, 0x5c, 0x4a, 0x7f, 0x2c, 0xe5, 0x53,
	0xfb, 0xe8, 0xec, 0x66, 0xa4, 0xce, 0x6e, 0xb9, 0xf1, 0xd9, 0xcd, 0xf4, 0x87, 0x89, 0x5c, 0xb8,
	0xdf, 0x30, 0x1d, 0x1b, 0xf1, 0x74, 0xbc, 0x0e, 0xe5, 0x23, 0x21, 0x49, 0xa7, 0x57, 0x55, 0xce,
	0x4a, 0x47, 0x5c, 0x94, 0x26, 0xf2, 0x82, 0xce, 0x8f, 0xf5, 0x3a, 0x98, 0x1d, 0xf9, 0x81, 0x0c,
	0xb8, 0x82, 0x55, 0x3c, 0xf2, 0x83, 0x7d, 0x45, 0x32, 0x3f, 0x19, 0xe6, 0x18, 0x71, 0xe1, 0xf1,
	0x72, 0x8c, 0x60, 0xd5, 0xd5, 0xfa, 0xcf, 0x06, 0x9c, 0x89, 0x57, 0x6b, 0x19, 0x47, 0xda, 0x23,
	0x62, 0xc5, 0xce, 0x38, 0x4e, 0xb1, 0x43, 0x35, 0x38, 0x39, 0xfa, 0xf6, 0xa6, 0xef, 0x75, 0x06,
	0x4a, 0x01, 0x4b, 0x23, 0x0a, 0x78, 0xe0, 0x75, 0x06, 0x68, 0x03, 0x96, 0xe2, 0x4a, 0x90, 0xa7,
	0xa5, 0x26, 0x4e, 0xc4, 0x34, 0xc1, 0xcf, 0x9a, 0x04, 0xce, 0x1c, 0x10, 0xa6, 0x3e, 0xc3, 0x24,
	0xe3, 0x26, 0xb3, 0x2f, 0xa7, 0x45, 0xd0, 0xf6, 0x1f, 0x56, 0xd4, 0xbc, 0x70, 0x40, 0x82, 0xbe,
	0x6b, 0x13, 0xd4, 0x87, 0x12, 0xcf, 0xbe, 0xfb, 0x8d, 0xef, 0x90, 0x80, 0xf2, 0xba, 0xf2, 0xd6,
	0x74, 0xa5, 0xdc, 0xeb, 0xf6, 0xd8, 0xa0, 0x7a, 0x7e, 0xfa, 0x01, 0x25, 0xc3, 0x3c, 0xff, 0xd3,
	0x7f, 0xfc, 0xe7, 0x17, 0xb9, 0xb3, 0xe8, 0x8c, 0xfc, 0x96, 0xc7, 0xef, 0xab, 0xf7, 0xb7, 0xf8,
	0x62, 0xb3, 0xaf, 0xae, 0xf9, 0xb9, 0x01, 0x68, 0xdc, 0x54, 0x68, 0x7b, 0xaa, 0xc1, 0xa7, 0xda,
	0xb5, 0xba, 0x91, 0xcd, 0x49, 0xb8, 0x00, 0xf3, 0x9c, 0x40, 0x76, 0x0a, 0x2d, 0x8f, 0x22, 0x93,
	0x69, 0x18, 0xfd, 0xd6, 0x80, 0xd2, 0xc8, 0x0c, 0x84, 0x36, 0x33, 0xe1, 0x89, 0xa0, 0xac, 0xa7,
	0x42, 0x11, 0x28, 0xee, 0x08, 0x14, 0x37, 0xd1, 0x8d, 0x51, 0x14, 0x71, 0x63, 0xd2, 0xfa, 0x93,
	0x84, 0xc9, 0x9f, 0xd6, 0xb5, 0x1d, 0x29, 0x7a, 0x02, 0xc5, 0x58, 0xcd, 0x44, 0x17, 0xa6, 0x9b,
	0xa4, 0xb1, 0xa7, 0xdc, 0xb8, 0x9a, 0x3e, 0x0a, 0x9a, 0x17, 0x05, 0xae, 0x55, 0x74, 0x2e, 0x61,
	0x37, 0x7d, 0x6f, 0xfd, 0x89, 0xeb, 0x3c, 0x45, 0xbf, 0x32, 0xa0, 0x7c, 0x57, 0x8c, 0x46, 0x11,
	0x80, 0x74, 0xd9, 0x59, 0xae, 0xdf, 0x15, 0xd7, 0xbf, 0x6b, 0x1e, 0x57, 0x2d, 0xb7, 0x8c, 0x0d,
	0xf4, 0x19, 0x94, 0x1f, 0x89, 0xef, 0x2f, 0xaf, 0x19, 0xdb, 0x65, 0x81, 0xed, 0xfc, 0xf6, 0x0b,
	0x55, 0xc3, 0x01, 0xfc, 0x04, 0xca, 0xa3, 0x65, 0x38, 0x9b, 0x75, 0xd2, 0xc2, 0x4e, 0xdb, 0x66,
	0xe3, 0xc5, 0xb6, 0xf9, 0x8d, 0x01, 0x68, 0x3c, 0x8f, 0xbc, 0x20, 0xac, 0xa6, 0x26, 0x9d, 0x74,
	0x44, 0x37, 0x05, 0xa2, 0xeb, 0xd5, 0xad, 0xa9, 0x88, 0xc6, 0x4c, 0xa5, 0xbe, 0x3b, 0xa3, 0xff,
	0x1a, 0xb0, 0x96, 0x56, 0xdb, 0xd0, 0x37, 0xa7, 0x82, 0xce, 0xd8, 0x03, 0x54, 0xef, 0xbc, 0x82,
	0x04, 0x5e, 0x58, 0xcd, 0xf7, 0xc4, 0x13, 0x6f, 0x98, 0xdb, 0x93, 0x9f, 0x58, 0x67, 0x84, 0xb2,
	0x4d, 0xf1, 0x4d, 0x6a, 0xb3, 0xe7, 0x53, 0xb6, 0x19, 0x2b, 0xe0, 0xb7, 0x8c, 0x8d, 0x6b, 0x06,
	0xfa, 0x4b, 0xe2, 0xab, 0x8a, 0x9e, 0x1f, 0xd1, 0xdb, 0x99, 0x12, 0x4b, 0x62, 0xdc, 0xac, 0x5e,
	0xcd, 0x3a, 0xbf, 0x8a, 0x34, 0xf3, 0xbe, 0x40, 0xff, 0x0e, 0xfa, 0xc6, 0x54, 0x03, 0xc5, 0x8a,
	0xc5, 0x30, 0x8e, 0xb0, 0xc6, 0xf8, 0xcc, 0x00, 0x14, 0x4b, 0x33, 0xfa, 0x4b, 0x4b, 0x26, 0x7f,
	0xce, 0x3c, 0x69, 0x9b, 0x5f, 0x13, 0x28, 0xd7, 0xd1, 0x85, 0xc9, 0x28, 0x35, 0x1a, 0xe9, 0xdf,
	0x3f, 0x33, 0x60, 0x65, 0x62, 0x97, 0xfb, 0x9a, 0xa2, 0x4c, 0x81, 0xd9, 0xc8, 0x04, 0xe6, 0xaf,
	0x06, 0x9c, 0x7d, 0x41, 0xcb, 0x8d, 0x6e, 0x4f, 0xd5, 0x41, 0x7a, 0xa3, 0x9e, 0x0e, 0xf5, 0x9e,
	0x80, 0x7a, 0x67, 0xe3, 0x56, 0x1a, 0xd4, 0xf1, 0x7e, 0xff, 0x69, 0x5d, 0x7e, 0xf8, 0xe5, 0xf9,
	0xea, 0xf7, 0x06, 0x2c, 0x8d, 0xcd, 0x5f, 0x68, 0x6b, 0x2a, 0xf4, 0x69, 0xb3, 0x5a, 0x86, 0x32,
	0x1c, 0x8d, 0x92, 0xe6, 0x0d, 0x81, 0x7d, 0xcb, 0xbc, 0x9a, 0xcd, 0x33, 0x23, 0xb4, 0xd7, 0x0c,
	0xf4, 0xb9, 0x01, 0xe7, 0xe2, 0x4e, 0x29, 0x26, 0x0e, 0x3e, 0x32, 0xa9, 0xa9, 0xe3, 0xb5, 0x15,
	0xc3, 0xab, 0x02, 0xe3, 0x25, 0x74, 0x71, 0x14, 0xa3, 0x1a, 0x57, 0xa4, 0x0b, 0x44, 0x88, 0xb9,
	0x2f, 0x9c, 0x9e, 0x32, 0xfd, 0xa0, 0x1b, 0xd3, 0x2f, 0x7b, 0xe1, 0xbc, 0x94, 0xee, 0x03, 0x1f,
	0x0b, 0x8c, 0xf7, 0xcd, 0xdd, 0x69, 0x18, 0x87, 0xe3, 0xd6, 0xd3, 0xe9, 0x71, 0x2f, 0x40, 0x70,
	0x5f, 0x78, 0x66, 0xc0, 0x19, 0x3e, 0x0f, 0x44, 0x90, 0x3e, 0x08, 0xfc, 0xee, 0x6b, 0xae, 0x63,
	0x9b, 0x02, 0xf2, 0xe5, 0x8d, 0xf5, 0x2c, 0x6a, 0xa5, 0xbb, 0xb7, 0xbf, 0x78, 0xbe, 0x6a, 0xfc,
	0xfd, 0xf9, 0xaa, 0xf1, 0xaf, 0xe7, 0xab, 0xc6, 0x2f, 0xff, 0xbd, 0xfa, 0x95, 0xef, 0x7d, 0x35,
	0xf6, 0x0f, 0xb3, 0xbe, 0x6b, 0xb3, 0x8b, 0x3d, 0xdc, 0x22, 0x0e, 0x97, 0x49, 0x23, 0xa1, 0x87,
	0x73, 0x62, 0x52, 0xbd, 0xfe, 0x65, 0x00, 0x00, 0x00, 0xff, 0xff, 0x74, 0xe6, 0x6e, 0x76, 0x10,
	0x1f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// AuditServiceClient is the client API for AuditService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AuditServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all topics that can be found in an audit log event.
	// Required permissions:
	// - None
	ListAuditLogTopics(ctx context.Context, in *ListAuditLogTopicsRequest, opts ...grpc.CallOption) (*AuditLogTopicList, error)
	// Fetch all audit logs in the organization identified by the given ID.
	// Required permissions:
	// - audit.auditlog.list on the organization identified by the given ID.
	ListAuditLogs(ctx context.Context, in *ListAuditLogsRequest, opts ...grpc.CallOption) (*AuditLogList, error)
	// Fetch a specific AuditLog identified by the given ID.
	// Required permissions:
	// - audit.auditlog.get on the audit log identified by the given ID.
	GetAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLog, error)
	// Create a new audit log.
	// Required permissions:
	// - audit.auditlog.create on the organization identified by the given ID.
	CreateAuditLog(ctx context.Context, in *AuditLog, opts ...grpc.CallOption) (*AuditLog, error)
	// Update an audit log.
	// Required permissions:
	// - audit.auditlog.update on the audit log identified by the given ID.
	UpdateAuditLog(ctx context.Context, in *AuditLog, opts ...grpc.CallOption) (*AuditLog, error)
	// Delete an audit log.
	// Note that audit logs are initially only marked for deleted.
	// Once all their resources are removed the audit log itself is deleted
	// and cannot be restored.
	// Note that deleting an AuditLog will detach it from all Projects that
	// it was attached to.
	// Required permissions:
	// - audit.auditlog.delete on the audit log.
	DeleteAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Change the default audit log of an organization.
	// The default AuditLog for an organization is used to capture audit events
	// from the Oasis platform. If there is no default AuditLog, audit events
	// from the Oasis platform are not captured.
	// The default AuditLog is also attached to new projects in the organization.
	// Required permissions:
	// - audit.auditlog.set-default on the organization.
	SetDefaultAuditLog(ctx context.Context, in *SetDefaultAuditLogRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Test an audit log destination of type HTTPS Post.
	// Note that only 1 item is returned, but this can take a while.
	// To recognize test events: The Topic will be "test-topic" and the Sequence 0
	// Required permissions:
	// - audit.auditlog.test-https-post-destination on the organization identified by the given ID.
	TestAuditLogHttpsPostDestination(ctx context.Context, in *TestAuditLogHttpsPostDestinationRequest, opts ...grpc.CallOption) (AuditService_TestAuditLogHttpsPostDestinationClient, error)
	// Fetch all audit log archives in the audit log identified by the given ID.
	// Required permissions:
	// - audit.auditlogarchive.list on the audit log identified by the given ID.
	ListAuditLogArchives(ctx context.Context, in *ListAuditLogArchivesRequest, opts ...grpc.CallOption) (*AuditLogArchiveList, error)
	// Fetch a specific AuditLogArchive identified by the given ID.
	// Required permissions:
	// - audit.auditlogarchive.get on the audit log archive identified by the given ID.
	GetAuditLogArchive(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLogArchive, error)
	// Delete an audit log archive.
	// Note that this method will return a precondition-failed error
	// if there is a non-deleted deployment using this archive.
	// Note that audit log archives are initially only marked for deleted.
	// Once all their resources are removed the audit log archive itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - audit.auditlogarchive.delete on the audit log archive.
	DeleteAuditLogArchive(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Remove all audit events that match the given filter from the AuditLogArchive
	// identified by the given ID.
	// Note that this method will return a precondition-failed error
	// if there is no destination of type "cloud" in the AuditLog.
	// Required permissions:
	// - audit.auditlogevent.delete on the audit log archive identified by the given ID.
	DeleteAuditLogArchiveEvents(ctx context.Context, in *DeleteAuditLogArchiveEventsRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch all audit events that match the given filter.
	// Note that this method will return a precondition-failed error
	// if there is no destination of type "cloud" in the AuditLog.
	// Required permissions:
	// - audit.auditlogevents.get on the audit log identified by the given ID.
	GetAuditLogEvents(ctx context.Context, in *GetAuditLogEventsRequest, opts ...grpc.CallOption) (AuditService_GetAuditLogEventsClient, error)
	// Fetch the AuditLog that is attached to the project identified by the given ID.
	// If no AuditLog is attached to the project, a not-found error is returned.
	// Required permissions:
	// - audit.auditlogattachment.get on the project identified by the given ID.
	GetAuditLogAttachedToProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLog, error)
	// Attach the AuditLog identified by given ID to the project identified with given ID.
	// This replaces any existing AuditLog attachment for the project.
	// Required permissions:
	// - audit.auditlogattachment.create on the project identified by the given ID.
	AttachProjectToAuditLog(ctx context.Context, in *AttachProjectToAuditLogRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Detach the current AuditLog from the project identified with given ID.
	// After a detachment, no audit events in the context of the project will be sent
	// to an AuditLog.
	// Required permissions:
	// - audit.auditlogattachment.delete on the project identified by the given ID.
	DetachProjectFromAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
}

type auditServiceClient struct {
	cc *grpc.ClientConn
}

func NewAuditServiceClient(cc *grpc.ClientConn) AuditServiceClient {
	return &auditServiceClient{cc}
}

func (c *auditServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) ListAuditLogTopics(ctx context.Context, in *ListAuditLogTopicsRequest, opts ...grpc.CallOption) (*AuditLogTopicList, error) {
	out := new(AuditLogTopicList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/ListAuditLogTopics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) ListAuditLogs(ctx context.Context, in *ListAuditLogsRequest, opts ...grpc.CallOption) (*AuditLogList, error) {
	out := new(AuditLogList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/ListAuditLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) GetAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLog, error) {
	out := new(AuditLog)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/GetAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) CreateAuditLog(ctx context.Context, in *AuditLog, opts ...grpc.CallOption) (*AuditLog, error) {
	out := new(AuditLog)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/CreateAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) UpdateAuditLog(ctx context.Context, in *AuditLog, opts ...grpc.CallOption) (*AuditLog, error) {
	out := new(AuditLog)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/UpdateAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) DeleteAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) SetDefaultAuditLog(ctx context.Context, in *SetDefaultAuditLogRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/SetDefaultAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) TestAuditLogHttpsPostDestination(ctx context.Context, in *TestAuditLogHttpsPostDestinationRequest, opts ...grpc.CallOption) (AuditService_TestAuditLogHttpsPostDestinationClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AuditService_serviceDesc.Streams[0], "/arangodb.cloud.audit.v1.AuditService/TestAuditLogHttpsPostDestination", opts...)
	if err != nil {
		return nil, err
	}
	x := &auditServiceTestAuditLogHttpsPostDestinationClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AuditService_TestAuditLogHttpsPostDestinationClient interface {
	Recv() (*TestAuditLogHttpsPostDestinationResult, error)
	grpc.ClientStream
}

type auditServiceTestAuditLogHttpsPostDestinationClient struct {
	grpc.ClientStream
}

func (x *auditServiceTestAuditLogHttpsPostDestinationClient) Recv() (*TestAuditLogHttpsPostDestinationResult, error) {
	m := new(TestAuditLogHttpsPostDestinationResult)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *auditServiceClient) ListAuditLogArchives(ctx context.Context, in *ListAuditLogArchivesRequest, opts ...grpc.CallOption) (*AuditLogArchiveList, error) {
	out := new(AuditLogArchiveList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/ListAuditLogArchives", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) GetAuditLogArchive(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLogArchive, error) {
	out := new(AuditLogArchive)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/GetAuditLogArchive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) DeleteAuditLogArchive(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLogArchive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) DeleteAuditLogArchiveEvents(ctx context.Context, in *DeleteAuditLogArchiveEventsRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLogArchiveEvents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) GetAuditLogEvents(ctx context.Context, in *GetAuditLogEventsRequest, opts ...grpc.CallOption) (AuditService_GetAuditLogEventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AuditService_serviceDesc.Streams[1], "/arangodb.cloud.audit.v1.AuditService/GetAuditLogEvents", opts...)
	if err != nil {
		return nil, err
	}
	x := &auditServiceGetAuditLogEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AuditService_GetAuditLogEventsClient interface {
	Recv() (*AuditLogEventList, error)
	grpc.ClientStream
}

type auditServiceGetAuditLogEventsClient struct {
	grpc.ClientStream
}

func (x *auditServiceGetAuditLogEventsClient) Recv() (*AuditLogEventList, error) {
	m := new(AuditLogEventList)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *auditServiceClient) GetAuditLogAttachedToProject(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*AuditLog, error) {
	out := new(AuditLog)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/GetAuditLogAttachedToProject", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) AttachProjectToAuditLog(ctx context.Context, in *AttachProjectToAuditLogRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/AttachProjectToAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *auditServiceClient) DetachProjectFromAuditLog(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.audit.v1.AuditService/DetachProjectFromAuditLog", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AuditServiceServer is the server API for AuditService service.
type AuditServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all topics that can be found in an audit log event.
	// Required permissions:
	// - None
	ListAuditLogTopics(context.Context, *ListAuditLogTopicsRequest) (*AuditLogTopicList, error)
	// Fetch all audit logs in the organization identified by the given ID.
	// Required permissions:
	// - audit.auditlog.list on the organization identified by the given ID.
	ListAuditLogs(context.Context, *ListAuditLogsRequest) (*AuditLogList, error)
	// Fetch a specific AuditLog identified by the given ID.
	// Required permissions:
	// - audit.auditlog.get on the audit log identified by the given ID.
	GetAuditLog(context.Context, *v1.IDOptions) (*AuditLog, error)
	// Create a new audit log.
	// Required permissions:
	// - audit.auditlog.create on the organization identified by the given ID.
	CreateAuditLog(context.Context, *AuditLog) (*AuditLog, error)
	// Update an audit log.
	// Required permissions:
	// - audit.auditlog.update on the audit log identified by the given ID.
	UpdateAuditLog(context.Context, *AuditLog) (*AuditLog, error)
	// Delete an audit log.
	// Note that audit logs are initially only marked for deleted.
	// Once all their resources are removed the audit log itself is deleted
	// and cannot be restored.
	// Note that deleting an AuditLog will detach it from all Projects that
	// it was attached to.
	// Required permissions:
	// - audit.auditlog.delete on the audit log.
	DeleteAuditLog(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Change the default audit log of an organization.
	// The default AuditLog for an organization is used to capture audit events
	// from the Oasis platform. If there is no default AuditLog, audit events
	// from the Oasis platform are not captured.
	// The default AuditLog is also attached to new projects in the organization.
	// Required permissions:
	// - audit.auditlog.set-default on the organization.
	SetDefaultAuditLog(context.Context, *SetDefaultAuditLogRequest) (*v1.Empty, error)
	// Test an audit log destination of type HTTPS Post.
	// Note that only 1 item is returned, but this can take a while.
	// To recognize test events: The Topic will be "test-topic" and the Sequence 0
	// Required permissions:
	// - audit.auditlog.test-https-post-destination on the organization identified by the given ID.
	TestAuditLogHttpsPostDestination(*TestAuditLogHttpsPostDestinationRequest, AuditService_TestAuditLogHttpsPostDestinationServer) error
	// Fetch all audit log archives in the audit log identified by the given ID.
	// Required permissions:
	// - audit.auditlogarchive.list on the audit log identified by the given ID.
	ListAuditLogArchives(context.Context, *ListAuditLogArchivesRequest) (*AuditLogArchiveList, error)
	// Fetch a specific AuditLogArchive identified by the given ID.
	// Required permissions:
	// - audit.auditlogarchive.get on the audit log archive identified by the given ID.
	GetAuditLogArchive(context.Context, *v1.IDOptions) (*AuditLogArchive, error)
	// Delete an audit log archive.
	// Note that this method will return a precondition-failed error
	// if there is a non-deleted deployment using this archive.
	// Note that audit log archives are initially only marked for deleted.
	// Once all their resources are removed the audit log archive itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - audit.auditlogarchive.delete on the audit log archive.
	DeleteAuditLogArchive(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Remove all audit events that match the given filter from the AuditLogArchive
	// identified by the given ID.
	// Note that this method will return a precondition-failed error
	// if there is no destination of type "cloud" in the AuditLog.
	// Required permissions:
	// - audit.auditlogevent.delete on the audit log archive identified by the given ID.
	DeleteAuditLogArchiveEvents(context.Context, *DeleteAuditLogArchiveEventsRequest) (*v1.Empty, error)
	// Fetch all audit events that match the given filter.
	// Note that this method will return a precondition-failed error
	// if there is no destination of type "cloud" in the AuditLog.
	// Required permissions:
	// - audit.auditlogevents.get on the audit log identified by the given ID.
	GetAuditLogEvents(*GetAuditLogEventsRequest, AuditService_GetAuditLogEventsServer) error
	// Fetch the AuditLog that is attached to the project identified by the given ID.
	// If no AuditLog is attached to the project, a not-found error is returned.
	// Required permissions:
	// - audit.auditlogattachment.get on the project identified by the given ID.
	GetAuditLogAttachedToProject(context.Context, *v1.IDOptions) (*AuditLog, error)
	// Attach the AuditLog identified by given ID to the project identified with given ID.
	// This replaces any existing AuditLog attachment for the project.
	// Required permissions:
	// - audit.auditlogattachment.create on the project identified by the given ID.
	AttachProjectToAuditLog(context.Context, *AttachProjectToAuditLogRequest) (*v1.Empty, error)
	// Detach the current AuditLog from the project identified with given ID.
	// After a detachment, no audit events in the context of the project will be sent
	// to an AuditLog.
	// Required permissions:
	// - audit.auditlogattachment.delete on the project identified by the given ID.
	DetachProjectFromAuditLog(context.Context, *v1.IDOptions) (*v1.Empty, error)
}

// UnimplementedAuditServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAuditServiceServer struct {
}

func (*UnimplementedAuditServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedAuditServiceServer) ListAuditLogTopics(ctx context.Context, req *ListAuditLogTopicsRequest) (*AuditLogTopicList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuditLogTopics not implemented")
}
func (*UnimplementedAuditServiceServer) ListAuditLogs(ctx context.Context, req *ListAuditLogsRequest) (*AuditLogList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuditLogs not implemented")
}
func (*UnimplementedAuditServiceServer) GetAuditLog(ctx context.Context, req *v1.IDOptions) (*AuditLog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) CreateAuditLog(ctx context.Context, req *AuditLog) (*AuditLog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) UpdateAuditLog(ctx context.Context, req *AuditLog) (*AuditLog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) DeleteAuditLog(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) SetDefaultAuditLog(ctx context.Context, req *SetDefaultAuditLogRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) TestAuditLogHttpsPostDestination(req *TestAuditLogHttpsPostDestinationRequest, srv AuditService_TestAuditLogHttpsPostDestinationServer) error {
	return status.Errorf(codes.Unimplemented, "method TestAuditLogHttpsPostDestination not implemented")
}
func (*UnimplementedAuditServiceServer) ListAuditLogArchives(ctx context.Context, req *ListAuditLogArchivesRequest) (*AuditLogArchiveList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAuditLogArchives not implemented")
}
func (*UnimplementedAuditServiceServer) GetAuditLogArchive(ctx context.Context, req *v1.IDOptions) (*AuditLogArchive, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuditLogArchive not implemented")
}
func (*UnimplementedAuditServiceServer) DeleteAuditLogArchive(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuditLogArchive not implemented")
}
func (*UnimplementedAuditServiceServer) DeleteAuditLogArchiveEvents(ctx context.Context, req *DeleteAuditLogArchiveEventsRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAuditLogArchiveEvents not implemented")
}
func (*UnimplementedAuditServiceServer) GetAuditLogEvents(req *GetAuditLogEventsRequest, srv AuditService_GetAuditLogEventsServer) error {
	return status.Errorf(codes.Unimplemented, "method GetAuditLogEvents not implemented")
}
func (*UnimplementedAuditServiceServer) GetAuditLogAttachedToProject(ctx context.Context, req *v1.IDOptions) (*AuditLog, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAuditLogAttachedToProject not implemented")
}
func (*UnimplementedAuditServiceServer) AttachProjectToAuditLog(ctx context.Context, req *AttachProjectToAuditLogRequest) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachProjectToAuditLog not implemented")
}
func (*UnimplementedAuditServiceServer) DetachProjectFromAuditLog(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachProjectFromAuditLog not implemented")
}

func RegisterAuditServiceServer(s *grpc.Server, srv AuditServiceServer) {
	s.RegisterService(&_AuditService_serviceDesc, srv)
}

func _AuditService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_ListAuditLogTopics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuditLogTopicsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).ListAuditLogTopics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/ListAuditLogTopics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).ListAuditLogTopics(ctx, req.(*ListAuditLogTopicsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_ListAuditLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuditLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).ListAuditLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/ListAuditLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).ListAuditLogs(ctx, req.(*ListAuditLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_GetAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).GetAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/GetAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).GetAuditLog(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_CreateAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuditLog)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).CreateAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/CreateAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).CreateAuditLog(ctx, req.(*AuditLog))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_UpdateAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AuditLog)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).UpdateAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/UpdateAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).UpdateAuditLog(ctx, req.(*AuditLog))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_DeleteAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).DeleteAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).DeleteAuditLog(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_SetDefaultAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDefaultAuditLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).SetDefaultAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/SetDefaultAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).SetDefaultAuditLog(ctx, req.(*SetDefaultAuditLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_TestAuditLogHttpsPostDestination_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TestAuditLogHttpsPostDestinationRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AuditServiceServer).TestAuditLogHttpsPostDestination(m, &auditServiceTestAuditLogHttpsPostDestinationServer{stream})
}

type AuditService_TestAuditLogHttpsPostDestinationServer interface {
	Send(*TestAuditLogHttpsPostDestinationResult) error
	grpc.ServerStream
}

type auditServiceTestAuditLogHttpsPostDestinationServer struct {
	grpc.ServerStream
}

func (x *auditServiceTestAuditLogHttpsPostDestinationServer) Send(m *TestAuditLogHttpsPostDestinationResult) error {
	return x.ServerStream.SendMsg(m)
}

func _AuditService_ListAuditLogArchives_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAuditLogArchivesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).ListAuditLogArchives(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/ListAuditLogArchives",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).ListAuditLogArchives(ctx, req.(*ListAuditLogArchivesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_GetAuditLogArchive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).GetAuditLogArchive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/GetAuditLogArchive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).GetAuditLogArchive(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_DeleteAuditLogArchive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).DeleteAuditLogArchive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLogArchive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).DeleteAuditLogArchive(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_DeleteAuditLogArchiveEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAuditLogArchiveEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).DeleteAuditLogArchiveEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/DeleteAuditLogArchiveEvents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).DeleteAuditLogArchiveEvents(ctx, req.(*DeleteAuditLogArchiveEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_GetAuditLogEvents_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetAuditLogEventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AuditServiceServer).GetAuditLogEvents(m, &auditServiceGetAuditLogEventsServer{stream})
}

type AuditService_GetAuditLogEventsServer interface {
	Send(*AuditLogEventList) error
	grpc.ServerStream
}

type auditServiceGetAuditLogEventsServer struct {
	grpc.ServerStream
}

func (x *auditServiceGetAuditLogEventsServer) Send(m *AuditLogEventList) error {
	return x.ServerStream.SendMsg(m)
}

func _AuditService_GetAuditLogAttachedToProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).GetAuditLogAttachedToProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/GetAuditLogAttachedToProject",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).GetAuditLogAttachedToProject(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_AttachProjectToAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachProjectToAuditLogRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).AttachProjectToAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/AttachProjectToAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).AttachProjectToAuditLog(ctx, req.(*AttachProjectToAuditLogRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AuditService_DetachProjectFromAuditLog_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AuditServiceServer).DetachProjectFromAuditLog(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.audit.v1.AuditService/DetachProjectFromAuditLog",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AuditServiceServer).DetachProjectFromAuditLog(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

var _AuditService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.audit.v1.AuditService",
	HandlerType: (*AuditServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _AuditService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListAuditLogTopics",
			Handler:    _AuditService_ListAuditLogTopics_Handler,
		},
		{
			MethodName: "ListAuditLogs",
			Handler:    _AuditService_ListAuditLogs_Handler,
		},
		{
			MethodName: "GetAuditLog",
			Handler:    _AuditService_GetAuditLog_Handler,
		},
		{
			MethodName: "CreateAuditLog",
			Handler:    _AuditService_CreateAuditLog_Handler,
		},
		{
			MethodName: "UpdateAuditLog",
			Handler:    _AuditService_UpdateAuditLog_Handler,
		},
		{
			MethodName: "DeleteAuditLog",
			Handler:    _AuditService_DeleteAuditLog_Handler,
		},
		{
			MethodName: "SetDefaultAuditLog",
			Handler:    _AuditService_SetDefaultAuditLog_Handler,
		},
		{
			MethodName: "ListAuditLogArchives",
			Handler:    _AuditService_ListAuditLogArchives_Handler,
		},
		{
			MethodName: "GetAuditLogArchive",
			Handler:    _AuditService_GetAuditLogArchive_Handler,
		},
		{
			MethodName: "DeleteAuditLogArchive",
			Handler:    _AuditService_DeleteAuditLogArchive_Handler,
		},
		{
			MethodName: "DeleteAuditLogArchiveEvents",
			Handler:    _AuditService_DeleteAuditLogArchiveEvents_Handler,
		},
		{
			MethodName: "GetAuditLogAttachedToProject",
			Handler:    _AuditService_GetAuditLogAttachedToProject_Handler,
		},
		{
			MethodName: "AttachProjectToAuditLog",
			Handler:    _AuditService_AttachProjectToAuditLog_Handler,
		},
		{
			MethodName: "DetachProjectFromAuditLog",
			Handler:    _AuditService_DetachProjectFromAuditLog_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "TestAuditLogHttpsPostDestination",
			Handler:       _AuditService_TestAuditLogHttpsPostDestination_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetAuditLogEvents",
			Handler:       _AuditService_GetAuditLogEvents_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "audit.proto",
}

func (m *AuditLog) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Destinations) > 0 {
		for iNdEx := len(m.Destinations) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Destinations[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xa2
		}
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x42
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLog_HttpsPostSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog_HttpsPostSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog_HttpsPostSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.RetryPeriod != nil {
		{
			size, err := m.RetryPeriod.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xc2
	}
	if len(m.Headers) > 0 {
		for iNdEx := len(m.Headers) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Headers[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.ClientKeyPem) > 0 {
		i -= len(m.ClientKeyPem)
		copy(dAtA[i:], m.ClientKeyPem)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ClientKeyPem)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ClientCertificatePem) > 0 {
		i -= len(m.ClientCertificatePem)
		copy(dAtA[i:], m.ClientCertificatePem)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ClientCertificatePem)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.TrustedServerCaPem) > 0 {
		i -= len(m.TrustedServerCaPem)
		copy(dAtA[i:], m.TrustedServerCaPem)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.TrustedServerCaPem)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLog_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog_Header) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog_Header) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLog_DestinationStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog_DestinationStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog_DestinationStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentName) > 0 {
		i -= len(m.DeploymentName)
		copy(dAtA[i:], m.DeploymentName)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DeploymentName)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if m.UpdatedAt != nil {
		{
			size, err := m.UpdatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if m.CountersYesterday != nil {
		{
			size, err := m.CountersYesterday.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.CountersSinceMidnight != nil {
		{
			size, err := m.CountersSinceMidnight.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.ErrorDetails) > 0 {
		i -= len(m.ErrorDetails)
		copy(dAtA[i:], m.ErrorDetails)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ErrorDetails)))
		i--
		dAtA[i] = 0x1a
	}
	if m.HasErrors {
		i--
		if m.HasErrors {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLog_DestinationCounters) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog_DestinationCounters) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog_DestinationCounters) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.HttpsPostsFailed != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.HttpsPostsFailed))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.HttpsPostsSucceeded != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.HttpsPostsSucceeded))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if m.BytesFailed != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.BytesFailed))
		i--
		dAtA[i] = 0x58
	}
	if m.BytesSucceeded != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.BytesSucceeded))
		i--
		dAtA[i] = 0x50
	}
	if m.EventsUndeliverable != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.EventsUndeliverable))
		i--
		dAtA[i] = 0x18
	}
	if m.EventsExcluded != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.EventsExcluded))
		i--
		dAtA[i] = 0x10
	}
	if m.Events != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.Events))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AuditLog_Destination) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLog_Destination) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLog_Destination) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.Statuses) > 0 {
		for iNdEx := len(m.Statuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Statuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x6
			i--
			dAtA[i] = 0xa2
		}
	}
	if m.HttpPost != nil {
		{
			size, err := m.HttpPost.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.ExcludedTopics) > 0 {
		for iNdEx := len(m.ExcludedTopics) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExcludedTopics[iNdEx])
			copy(dAtA[i:], m.ExcludedTopics[iNdEx])
			i = encodeVarintAudit(dAtA, i, uint64(len(m.ExcludedTopics[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListAuditLogsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAuditLogsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAuditLogsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if m.IncludeDeleted {
		i--
		if m.IncludeDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogArchive) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogArchive) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogArchive) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.CanDelete {
		i--
		if m.CanDelete {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x68
	}
	if len(m.ProjectName) > 0 {
		i -= len(m.ProjectName)
		copy(dAtA[i:], m.ProjectName)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ProjectName)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.DeploymentName) > 0 {
		i -= len(m.DeploymentName)
		copy(dAtA[i:], m.DeploymentName)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DeploymentName)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x52
	}
	if m.SizeInBytesChangedAt != nil {
		{
			size, err := m.SizeInBytesChangedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.SizeInBytes != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.SizeInBytes))
		i--
		dAtA[i] = 0x40
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0x32
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogArchiveList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogArchiveList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogArchiveList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListAuditLogArchivesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAuditLogArchivesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAuditLogArchivesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x2a
	}
	if m.WithoutDeployments {
		i--
		if m.WithoutDeployments {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x1a
	}
	if m.IncludeDeleted {
		i--
		if m.IncludeDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogEvent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogEvent) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogEvent) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Verb) > 0 {
		i -= len(m.Verb)
		copy(dAtA[i:], m.Verb)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Verb)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.AuditlogarchiveId) > 0 {
		i -= len(m.AuditlogarchiveId)
		copy(dAtA[i:], m.AuditlogarchiveId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogarchiveId)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.Authentication) > 0 {
		i -= len(m.Authentication)
		copy(dAtA[i:], m.Authentication)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Authentication)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ClientIp) > 0 {
		i -= len(m.ClientIp)
		copy(dAtA[i:], m.ClientIp)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ClientIp)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Database) > 0 {
		i -= len(m.Database)
		copy(dAtA[i:], m.Database)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Database)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.UserId) > 0 {
		i -= len(m.UserId)
		copy(dAtA[i:], m.UserId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.UserId)))
		i--
		dAtA[i] = 0x42
	}
	if m.Sequence != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.Sequence))
		i--
		dAtA[i] = 0x38
	}
	if len(m.InstanceId) > 0 {
		i -= len(m.InstanceId)
		copy(dAtA[i:], m.InstanceId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.InstanceId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ServerId) > 0 {
		i -= len(m.ServerId)
		copy(dAtA[i:], m.ServerId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ServerId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0x12
	}
	if m.Timestamp != nil {
		{
			size, err := m.Timestamp.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogEventList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogEventList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogEventList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Cursor) > 0 {
		i -= len(m.Cursor)
		copy(dAtA[i:], m.Cursor)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Cursor)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GetAuditLogEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetAuditLogEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetAuditLogEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Cursor) > 0 {
		i -= len(m.Cursor)
		copy(dAtA[i:], m.Cursor)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Cursor)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Limit != 0 {
		i = encodeVarintAudit(dAtA, i, uint64(m.Limit))
		i--
		dAtA[i] = 0x50
	}
	if len(m.ExcludedTopics) > 0 {
		for iNdEx := len(m.ExcludedTopics) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ExcludedTopics[iNdEx])
			copy(dAtA[i:], m.ExcludedTopics[iNdEx])
			i = encodeVarintAudit(dAtA, i, uint64(len(m.ExcludedTopics[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.IncludedTopics) > 0 {
		for iNdEx := len(m.IncludedTopics) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.IncludedTopics[iNdEx])
			copy(dAtA[i:], m.IncludedTopics[iNdEx])
			i = encodeVarintAudit(dAtA, i, uint64(len(m.IncludedTopics[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.To != nil {
		{
			size, err := m.To.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.From != nil {
		{
			size, err := m.From.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.AuditlogarchiveId) > 0 {
		i -= len(m.AuditlogarchiveId)
		copy(dAtA[i:], m.AuditlogarchiveId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogarchiveId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DeleteAuditLogArchiveEventsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteAuditLogArchiveEventsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeleteAuditLogArchiveEventsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.To != nil {
		{
			size, err := m.To.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.AuditlogarchiveId) > 0 {
		i -= len(m.AuditlogarchiveId)
		copy(dAtA[i:], m.AuditlogarchiveId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogarchiveId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AttachProjectToAuditLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AttachProjectToAuditLogRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AttachProjectToAuditLogRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TestAuditLogHttpsPostDestinationRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TestAuditLogHttpsPostDestinationRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TestAuditLogHttpsPostDestinationRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DestinationId) > 0 {
		i -= len(m.DestinationId)
		copy(dAtA[i:], m.DestinationId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.DestinationId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if m.Settings != nil {
		{
			size, err := m.Settings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TestAuditLogHttpsPostDestinationResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TestAuditLogHttpsPostDestinationResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TestAuditLogHttpsPostDestinationResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ErrorDetails) > 0 {
		i -= len(m.ErrorDetails)
		copy(dAtA[i:], m.ErrorDetails)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.ErrorDetails)))
		i--
		dAtA[i] = 0x12
	}
	if m.HasErrors {
		i--
		if m.HasErrors {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogTopic) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogTopic) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogTopic) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ForPlatform {
		i--
		if m.ForPlatform {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.ForDeployment {
		i--
		if m.ForDeployment {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.Topic) > 0 {
		i -= len(m.Topic)
		copy(dAtA[i:], m.Topic)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.Topic)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AuditLogTopicList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AuditLogTopicList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AuditLogTopicList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAudit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListAuditLogTopicsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListAuditLogTopicsRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListAuditLogTopicsRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ForPlatformOnly {
		i--
		if m.ForPlatformOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.ForDeploymentOnly {
		i--
		if m.ForDeploymentOnly {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintAudit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SetDefaultAuditLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetDefaultAuditLogRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SetDefaultAuditLogRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.AuditlogId) > 0 {
		i -= len(m.AuditlogId)
		copy(dAtA[i:], m.AuditlogId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.AuditlogId)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintAudit(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintAudit(dAtA []byte, offset int, v uint64) int {
	offset -= sovAudit(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *AuditLog) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IsDefault {
		n += 2
	}
	if len(m.Destinations) > 0 {
		for _, e := range m.Destinations {
			l = e.Size()
			n += 2 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLog_HttpsPostSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.TrustedServerCaPem)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ClientCertificatePem)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ClientKeyPem)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if len(m.Headers) > 0 {
		for _, e := range m.Headers {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.RetryPeriod != nil {
		l = m.RetryPeriod.Size()
		n += 2 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLog_Header) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLog_DestinationStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.HasErrors {
		n += 2
	}
	l = len(m.ErrorDetails)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.CountersSinceMidnight != nil {
		l = m.CountersSinceMidnight.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.CountersYesterday != nil {
		l = m.CountersYesterday.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.UpdatedAt != nil {
		l = m.UpdatedAt.Size()
		n += 2 + l + sovAudit(uint64(l))
	}
	l = len(m.DeploymentName)
	if l > 0 {
		n += 2 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLog_DestinationCounters) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Events != 0 {
		n += 1 + sovAudit(uint64(m.Events))
	}
	if m.EventsExcluded != 0 {
		n += 1 + sovAudit(uint64(m.EventsExcluded))
	}
	if m.EventsUndeliverable != 0 {
		n += 1 + sovAudit(uint64(m.EventsUndeliverable))
	}
	if m.BytesSucceeded != 0 {
		n += 1 + sovAudit(uint64(m.BytesSucceeded))
	}
	if m.BytesFailed != 0 {
		n += 1 + sovAudit(uint64(m.BytesFailed))
	}
	if m.HttpsPostsSucceeded != 0 {
		n += 2 + sovAudit(uint64(m.HttpsPostsSucceeded))
	}
	if m.HttpsPostsFailed != 0 {
		n += 2 + sovAudit(uint64(m.HttpsPostsFailed))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLog_Destination) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if len(m.ExcludedTopics) > 0 {
		for _, s := range m.ExcludedTopics {
			l = len(s)
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.HttpPost != nil {
		l = m.HttpPost.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if len(m.Statuses) > 0 {
		for _, e := range m.Statuses {
			l = e.Size()
			n += 2 + l + sovAudit(uint64(l))
		}
	}
	l = len(m.Id)
	if l > 0 {
		n += 2 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAuditLogsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IncludeDeleted {
		n += 2
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogArchive) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.SizeInBytes != 0 {
		n += 1 + sovAudit(uint64(m.SizeInBytes))
	}
	if m.SizeInBytesChangedAt != nil {
		l = m.SizeInBytesChangedAt.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.DeploymentName)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ProjectName)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.CanDelete {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogArchiveList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAuditLogArchivesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.IncludeDeleted {
		n += 2
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.WithoutDeployments {
		n += 2
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogEvent) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Topic)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ServerId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.InstanceId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.Sequence != 0 {
		n += 1 + sovAudit(uint64(m.Sequence))
	}
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.ClientIp)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Authentication)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.AuditlogarchiveId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.Verb)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogEventList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	l = len(m.Cursor)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetAuditLogEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.AuditlogarchiveId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.From != nil {
		l = m.From.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.To != nil {
		l = m.To.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if len(m.IncludedTopics) > 0 {
		for _, s := range m.IncludedTopics {
			l = len(s)
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if len(m.ExcludedTopics) > 0 {
		for _, s := range m.ExcludedTopics {
			l = len(s)
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.Limit != 0 {
		n += 1 + sovAudit(uint64(m.Limit))
	}
	l = len(m.Cursor)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *DeleteAuditLogArchiveEventsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.AuditlogarchiveId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.To != nil {
		l = m.To.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AttachProjectToAuditLogRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TestAuditLogHttpsPostDestinationRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.Settings != nil {
		l = m.Settings.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.AuditlogId)
	if l > 0 {
		n += 2 + l + sovAudit(uint64(l))
	}
	l = len(m.DestinationId)
	if l > 0 {
		n += 2 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TestAuditLogHttpsPostDestinationResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.HasErrors {
		n += 2
	}
	l = len(m.ErrorDetails)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogTopic) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Topic)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.ForDeployment {
		n += 2
	}
	if m.ForPlatform {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AuditLogTopicList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovAudit(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListAuditLogTopicsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.ForDeploymentOnly {
		n += 2
	}
	if m.ForPlatformOnly {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *SetDefaultAuditLogRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	l = len(m.AuditlogId)
	if l > 0 {
		n += 1 + l + sovAudit(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAudit(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAudit(x uint64) (n int) {
	return sovAudit(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *AuditLog) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLog: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLog: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destinations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Destinations = append(m.Destinations, &AuditLog_Destination{})
			if err := m.Destinations[len(m.Destinations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLog_HttpsPostSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HttpsPostSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HttpsPostSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TrustedServerCaPem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TrustedServerCaPem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientCertificatePem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientCertificatePem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientKeyPem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientKeyPem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Headers = append(m.Headers, &AuditLog_Header{})
			if err := m.Headers[len(m.Headers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 200:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RetryPeriod", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RetryPeriod == nil {
				m.RetryPeriod = &types.Duration{}
			}
			if err := m.RetryPeriod.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLog_Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLog_DestinationStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DestinationStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DestinationStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasErrors", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasErrors = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorDetails", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorDetails = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CountersSinceMidnight", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CountersSinceMidnight == nil {
				m.CountersSinceMidnight = &AuditLog_DestinationCounters{}
			}
			if err := m.CountersSinceMidnight.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CountersYesterday", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CountersYesterday == nil {
				m.CountersYesterday = &AuditLog_DestinationCounters{}
			}
			if err := m.CountersYesterday.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpdatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UpdatedAt == nil {
				m.UpdatedAt = &types.Timestamp{}
			}
			if err := m.UpdatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLog_DestinationCounters) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DestinationCounters: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DestinationCounters: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			m.Events = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Events |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventsExcluded", wireType)
			}
			m.EventsExcluded = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventsExcluded |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EventsUndeliverable", wireType)
			}
			m.EventsUndeliverable = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EventsUndeliverable |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesSucceeded", wireType)
			}
			m.BytesSucceeded = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesSucceeded |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesFailed", wireType)
			}
			m.BytesFailed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesFailed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpsPostsSucceeded", wireType)
			}
			m.HttpsPostsSucceeded = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HttpsPostsSucceeded |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpsPostsFailed", wireType)
			}
			m.HttpsPostsFailed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HttpsPostsFailed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLog_Destination) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Destination: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Destination: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludedTopics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExcludedTopics = append(m.ExcludedTopics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpPost", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpPost == nil {
				m.HttpPost = &AuditLog_HttpsPostSettings{}
			}
			if err := m.HttpPost.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Statuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Statuses = append(m.Statuses, &AuditLog_DestinationStatus{})
			if err := m.Statuses[len(m.Statuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &AuditLog{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAuditLogsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAuditLogsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAuditLogsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogArchive) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogArchive: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogArchive: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeInBytes", wireType)
			}
			m.SizeInBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SizeInBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SizeInBytesChangedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SizeInBytesChangedAt == nil {
				m.SizeInBytesChangedAt = &types.Timestamp{}
			}
			if err := m.SizeInBytesChangedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CanDelete", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.CanDelete = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogArchiveList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogArchiveList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogArchiveList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &AuditLogArchive{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAuditLogArchivesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAuditLogArchivesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAuditLogArchivesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeDeleted = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithoutDeployments", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WithoutDeployments = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogEvent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogEvent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogEvent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &types.Timestamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Topic = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServerId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServerId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstanceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstanceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Authentication", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Authentication = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogarchiveId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogarchiveId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Verb", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Verb = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogEventList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogEventList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogEventList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &AuditLogEvent{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cursor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cursor = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetAuditLogEventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetAuditLogEventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetAuditLogEventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogarchiveId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogarchiveId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field From", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.From == nil {
				m.From = &types.Timestamp{}
			}
			if err := m.From.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = &types.Timestamp{}
			}
			if err := m.To.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludedTopics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncludedTopics = append(m.IncludedTopics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludedTopics", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExcludedTopics = append(m.ExcludedTopics, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cursor", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cursor = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteAuditLogArchiveEventsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteAuditLogArchiveEventsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteAuditLogArchiveEventsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogarchiveId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogarchiveId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field To", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.To == nil {
				m.To = &types.Timestamp{}
			}
			if err := m.To.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AttachProjectToAuditLogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttachProjectToAuditLogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttachProjectToAuditLogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TestAuditLogHttpsPostDestinationRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TestAuditLogHttpsPostDestinationRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TestAuditLogHttpsPostDestinationRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Settings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Settings == nil {
				m.Settings = &AuditLog_HttpsPostSettings{}
			}
			if err := m.Settings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TestAuditLogHttpsPostDestinationResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TestAuditLogHttpsPostDestinationResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TestAuditLogHttpsPostDestinationResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HasErrors", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.HasErrors = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorDetails", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorDetails = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogTopic) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogTopic: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogTopic: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Topic", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Topic = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForDeployment", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForDeployment = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForPlatform", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForPlatform = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AuditLogTopicList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AuditLogTopicList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AuditLogTopicList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &AuditLogTopic{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListAuditLogTopicsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListAuditLogTopicsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListAuditLogTopicsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForDeploymentOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForDeploymentOnly = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForPlatformOnly", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ForPlatformOnly = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SetDefaultAuditLogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetDefaultAuditLogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetDefaultAuditLogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AuditlogId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAudit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAudit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AuditlogId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAudit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAudit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAudit(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAudit
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAudit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAudit
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthAudit
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAudit
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAudit(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthAudit
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAudit = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAudit   = fmt.Errorf("proto: integer overflow")
)
