// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: crypto.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A CACertificate is represents a self-signed certificate authority used to sign
// TLS certificates for deployments & client authentication.
type CACertificate struct {
	// System identifier of the CA certificate.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the CA certificate
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the CA certificate
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that owns this CA certificate.
	// This value cannot be changed after creation.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Time from creation of the CA certificate to expiration.
	// This value cannot be changed after creation.
	Lifetime *types.Duration `protobuf:"bytes,6,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// The creation timestamp of the CA certificate
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the CA certificate
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// The expiration timestamp of the CA certificate
	// This is a read-only value.
	ExpiresAt *types.Timestamp `protobuf:"bytes,9,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// A PEM encoded representation of the public key of the CA certificate.
	// This is a read-only value.
	CertificatePem string `protobuf:"bytes,10,opt,name=certificate_pem,json=certificatePem,proto3" json:"certificate_pem,omitempty"`
	// Set when this CA certificate is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,11,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Set when this CA certificate has expired.
	// This is a read-only value.
	IsExpired bool `protobuf:"varint,12,opt,name=is_expired,json=isExpired,proto3" json:"is_expired,omitempty"`
	// Set when this CA certificate will expire in the next month.
	// This is a read-only value.
	WillExpireSoon bool `protobuf:"varint,13,opt,name=will_expire_soon,json=willExpireSoon,proto3" json:"will_expire_soon,omitempty"`
	// Set when this certificate is the default in its project.
	// This is a read-only value.
	IsDefault bool `protobuf:"varint,14,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// When enabled, deployments using this certificate use a well known TLS certificate on the 8529 port.
	// The self-signed certificates is always hosted on port 18529.
	UseWellKnownCertificate bool `protobuf:"varint,15,opt,name=use_well_known_certificate,json=useWellKnownCertificate,proto3" json:"use_well_known_certificate,omitempty"`
	// If set, this certificate cannot be deleted.
	// To delete, first update the with locked set to false.
	Locked bool `protobuf:"varint,16,opt,name=locked,proto3" json:"locked,omitempty"`
	// Set when this CA certificate will expire in the next 48 hours.
	// This is a read-only value.
	RotationNeeded bool `protobuf:"varint,17,opt,name=rotation_needed,json=rotationNeeded,proto3" json:"rotation_needed,omitempty"`
	// If set, contains the ID of a CA certificate from which this certificate was cloned.
	// This is a read-only value.
	ClonedFromId         string   `protobuf:"bytes,18,opt,name=cloned_from_id,json=clonedFromId,proto3" json:"cloned_from_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CACertificate) Reset()         { *m = CACertificate{} }
func (m *CACertificate) String() string { return proto.CompactTextString(m) }
func (*CACertificate) ProtoMessage()    {}
func (*CACertificate) Descriptor() ([]byte, []int) {
	return fileDescriptor_527278fb02d03321, []int{0}
}
func (m *CACertificate) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CACertificate) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CACertificate.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CACertificate) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CACertificate.Merge(m, src)
}
func (m *CACertificate) XXX_Size() int {
	return m.Size()
}
func (m *CACertificate) XXX_DiscardUnknown() {
	xxx_messageInfo_CACertificate.DiscardUnknown(m)
}

var xxx_messageInfo_CACertificate proto.InternalMessageInfo

func (m *CACertificate) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CACertificate) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *CACertificate) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CACertificate) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *CACertificate) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CACertificate) GetLifetime() *types.Duration {
	if m != nil {
		return m.Lifetime
	}
	return nil
}

func (m *CACertificate) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *CACertificate) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *CACertificate) GetExpiresAt() *types.Timestamp {
	if m != nil {
		return m.ExpiresAt
	}
	return nil
}

func (m *CACertificate) GetCertificatePem() string {
	if m != nil {
		return m.CertificatePem
	}
	return ""
}

func (m *CACertificate) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *CACertificate) GetIsExpired() bool {
	if m != nil {
		return m.IsExpired
	}
	return false
}

func (m *CACertificate) GetWillExpireSoon() bool {
	if m != nil {
		return m.WillExpireSoon
	}
	return false
}

func (m *CACertificate) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *CACertificate) GetUseWellKnownCertificate() bool {
	if m != nil {
		return m.UseWellKnownCertificate
	}
	return false
}

func (m *CACertificate) GetLocked() bool {
	if m != nil {
		return m.Locked
	}
	return false
}

func (m *CACertificate) GetRotationNeeded() bool {
	if m != nil {
		return m.RotationNeeded
	}
	return false
}

func (m *CACertificate) GetClonedFromId() string {
	if m != nil {
		return m.ClonedFromId
	}
	return ""
}

// List of CACertificates.
type CACertificateList struct {
	Items                []*CACertificate `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *CACertificateList) Reset()         { *m = CACertificateList{} }
func (m *CACertificateList) String() string { return proto.CompactTextString(m) }
func (*CACertificateList) ProtoMessage()    {}
func (*CACertificateList) Descriptor() ([]byte, []int) {
	return fileDescriptor_527278fb02d03321, []int{1}
}
func (m *CACertificateList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CACertificateList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CACertificateList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CACertificateList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CACertificateList.Merge(m, src)
}
func (m *CACertificateList) XXX_Size() int {
	return m.Size()
}
func (m *CACertificateList) XXX_DiscardUnknown() {
	xxx_messageInfo_CACertificateList.DiscardUnknown(m)
}

var xxx_messageInfo_CACertificateList proto.InternalMessageInfo

func (m *CACertificateList) GetItems() []*CACertificate {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListCACertificatesWithFilter.
type ListCACertificatesRequest struct {
	// Common list options.
	// Context_id is ignored.
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// Required ID of project to list certificates for.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If set, include only certificates that were cloned from the certificate
	// with this ID.
	ClonedFromId         string   `protobuf:"bytes,10,opt,name=cloned_from_id,json=clonedFromId,proto3" json:"cloned_from_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListCACertificatesRequest) Reset()         { *m = ListCACertificatesRequest{} }
func (m *ListCACertificatesRequest) String() string { return proto.CompactTextString(m) }
func (*ListCACertificatesRequest) ProtoMessage()    {}
func (*ListCACertificatesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_527278fb02d03321, []int{2}
}
func (m *ListCACertificatesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListCACertificatesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListCACertificatesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListCACertificatesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListCACertificatesRequest.Merge(m, src)
}
func (m *ListCACertificatesRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListCACertificatesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListCACertificatesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListCACertificatesRequest proto.InternalMessageInfo

func (m *ListCACertificatesRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListCACertificatesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListCACertificatesRequest) GetClonedFromId() string {
	if m != nil {
		return m.ClonedFromId
	}
	return ""
}

// Instructions for installing & uninstalling CA certificates
type CACertificateInstructions struct {
	// Per platform instructions for install/uninstall of the CA certificate
	Platforms            []*CACertificateInstructions_PlatformInstructions `protobuf:"bytes,1,rep,name=platforms,proto3" json:"platforms,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *CACertificateInstructions) Reset()         { *m = CACertificateInstructions{} }
func (m *CACertificateInstructions) String() string { return proto.CompactTextString(m) }
func (*CACertificateInstructions) ProtoMessage()    {}
func (*CACertificateInstructions) Descriptor() ([]byte, []int) {
	return fileDescriptor_527278fb02d03321, []int{3}
}
func (m *CACertificateInstructions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CACertificateInstructions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CACertificateInstructions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CACertificateInstructions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CACertificateInstructions.Merge(m, src)
}
func (m *CACertificateInstructions) XXX_Size() int {
	return m.Size()
}
func (m *CACertificateInstructions) XXX_DiscardUnknown() {
	xxx_messageInfo_CACertificateInstructions.DiscardUnknown(m)
}

var xxx_messageInfo_CACertificateInstructions proto.InternalMessageInfo

func (m *CACertificateInstructions) GetPlatforms() []*CACertificateInstructions_PlatformInstructions {
	if m != nil {
		return m.Platforms
	}
	return nil
}

// Instructions for a specific platform
type CACertificateInstructions_PlatformInstructions struct {
	// Human readable description of platform.
	// E.g. "MacOS"
	Platform string `protobuf:"bytes,1,opt,name=platform,proto3" json:"platform,omitempty"`
	// Steps needed to install
	InstallSteps []string `protobuf:"bytes,2,rep,name=install_steps,json=installSteps,proto3" json:"install_steps,omitempty"`
	// Steps needed to uninstall
	UninstallSteps       []string `protobuf:"bytes,3,rep,name=uninstall_steps,json=uninstallSteps,proto3" json:"uninstall_steps,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CACertificateInstructions_PlatformInstructions) Reset() {
	*m = CACertificateInstructions_PlatformInstructions{}
}
func (m *CACertificateInstructions_PlatformInstructions) String() string {
	return proto.CompactTextString(m)
}
func (*CACertificateInstructions_PlatformInstructions) ProtoMessage() {}
func (*CACertificateInstructions_PlatformInstructions) Descriptor() ([]byte, []int) {
	return fileDescriptor_527278fb02d03321, []int{3, 0}
}
func (m *CACertificateInstructions_PlatformInstructions) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CACertificateInstructions_PlatformInstructions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CACertificateInstructions_PlatformInstructions.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CACertificateInstructions_PlatformInstructions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CACertificateInstructions_PlatformInstructions.Merge(m, src)
}
func (m *CACertificateInstructions_PlatformInstructions) XXX_Size() int {
	return m.Size()
}
func (m *CACertificateInstructions_PlatformInstructions) XXX_DiscardUnknown() {
	xxx_messageInfo_CACertificateInstructions_PlatformInstructions.DiscardUnknown(m)
}

var xxx_messageInfo_CACertificateInstructions_PlatformInstructions proto.InternalMessageInfo

func (m *CACertificateInstructions_PlatformInstructions) GetPlatform() string {
	if m != nil {
		return m.Platform
	}
	return ""
}

func (m *CACertificateInstructions_PlatformInstructions) GetInstallSteps() []string {
	if m != nil {
		return m.InstallSteps
	}
	return nil
}

func (m *CACertificateInstructions_PlatformInstructions) GetUninstallSteps() []string {
	if m != nil {
		return m.UninstallSteps
	}
	return nil
}

func init() {
	proto.RegisterType((*CACertificate)(nil), "arangodb.cloud.crypto.v1.CACertificate")
	proto.RegisterType((*CACertificateList)(nil), "arangodb.cloud.crypto.v1.CACertificateList")
	proto.RegisterType((*ListCACertificatesRequest)(nil), "arangodb.cloud.crypto.v1.ListCACertificatesRequest")
	proto.RegisterType((*CACertificateInstructions)(nil), "arangodb.cloud.crypto.v1.CACertificateInstructions")
	proto.RegisterType((*CACertificateInstructions_PlatformInstructions)(nil), "arangodb.cloud.crypto.v1.CACertificateInstructions.PlatformInstructions")
}

func init() { proto.RegisterFile("crypto.proto", fileDescriptor_527278fb02d03321) }

var fileDescriptor_527278fb02d03321 = []byte{
	// 1064 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xcf, 0x6f, 0x1b, 0x45,
	0x14, 0x66, 0x9c, 0x26, 0x8d, 0x27, 0xb1, 0x9b, 0x4e, 0x50, 0xbb, 0xb1, 0x42, 0x30, 0xdb, 0xa2,
	0x58, 0x46, 0xd9, 0x25, 0xb6, 0x2a, 0xda, 0x86, 0x02, 0xc1, 0x69, 0x8a, 0x05, 0x82, 0xc8, 0x01,
	0x2a, 0x71, 0x59, 0x6d, 0x76, 0xc7, 0xee, 0xd0, 0xd9, 0x9d, 0x65, 0x67, 0xd6, 0x69, 0x54, 0x55,
	0x42, 0x1c, 0xe0, 0xc2, 0x0d, 0x84, 0xb8, 0x72, 0x40, 0x1c, 0x38, 0xf1, 0x2f, 0x20, 0x21, 0x71,
	0x41, 0x42, 0xe2, 0x1f, 0x40, 0x81, 0x3f, 0x04, 0xcd, 0xec, 0xf8, 0x77, 0x2d, 0x2f, 0x96, 0xe0,
	0xb6, 0x7e, 0xf3, 0x7d, 0x6f, 0xbe, 0xf9, 0xe6, 0xbd, 0xe7, 0x81, 0xab, 0x5e, 0x7c, 0x16, 0x09,
	0x66, 0x45, 0x31, 0x13, 0x0c, 0x19, 0x6e, 0xec, 0x86, 0x1d, 0xe6, 0x9f, 0x58, 0x1e, 0x65, 0x89,
	0x6f, 0xe9, 0xc5, 0xee, 0x6e, 0xe9, 0x8a, 0xc7, 0x82, 0x80, 0x85, 0x76, 0x77, 0xd7, 0x4e, 0xbf,
	0x52, 0x46, 0xe9, 0x56, 0x87, 0x88, 0x07, 0xc9, 0x89, 0xe5, 0xb1, 0xc0, 0xee, 0x30, 0xea, 0x86,
	0x1d, 0x5b, 0x2d, 0x9c, 0x24, 0x6d, 0x3b, 0x12, 0x67, 0x11, 0xe6, 0xb6, 0x9f, 0xc4, 0xae, 0x20,
	0x2c, 0xec, 0x7f, 0x68, 0xea, 0xde, 0x6c, 0xaa, 0x20, 0x01, 0xe6, 0xc2, 0x0d, 0xa2, 0xc1, 0x97,
	0x26, 0x6f, 0x76, 0x18, 0xeb, 0x50, 0x6c, 0xbb, 0x11, 0xb1, 0xdd, 0x30, 0x64, 0x42, 0x65, 0xe6,
	0xe9, 0xaa, 0xf9, 0xf3, 0x22, 0x2c, 0x34, 0xf6, 0x1b, 0x38, 0x16, 0xa4, 0x4d, 0x3c, 0x57, 0x60,
	0x54, 0x84, 0x39, 0xe2, 0x1b, 0xa0, 0x0c, 0x2a, 0xf9, 0x56, 0x8e, 0xf8, 0x68, 0x0d, 0x2e, 0x24,
	0x31, 0x35, 0x72, 0x2a, 0x20, 0x3f, 0x11, 0x82, 0x17, 0x42, 0x37, 0xc0, 0xc6, 0x82, 0x0a, 0xa9,
	0x6f, 0x54, 0x86, 0x2b, 0x3e, 0xe6, 0x5e, 0x4c, 0x22, 0x99, 0xdd, 0xb8, 0xa0, 0x96, 0x86, 0x43,
	0xe8, 0x39, 0x08, 0xa3, 0x98, 0x7d, 0x8c, 0x3d, 0xe1, 0x10, 0xdf, 0x58, 0x54, 0x80, 0xbc, 0x8e,
	0x34, 0x7d, 0x74, 0x03, 0x2e, 0x53, 0xd2, 0xc6, 0x52, 0xbd, 0xb1, 0x54, 0x06, 0x95, 0x95, 0xda,
	0x86, 0x95, 0x2a, 0xb7, 0x7a, 0x67, 0xb5, 0x0e, 0xb4, 0x2d, 0xad, 0x3e, 0x14, 0xdd, 0x82, 0xd0,
	0x8b, 0xb1, 0x2b, 0xb0, 0xef, 0xb8, 0xc2, 0xb8, 0xa8, 0x88, 0xa5, 0x09, 0xe2, 0xfb, 0x3d, 0x4f,
	0x5a, 0x79, 0x8d, 0xde, 0x17, 0x92, 0xea, 0x63, 0x8a, 0x35, 0x75, 0x79, 0x36, 0x55, 0xa3, 0x53,
	0x2a, 0x7e, 0x14, 0x91, 0x18, 0x73, 0x49, 0xcd, 0xcf, 0xa6, 0x6a, 0xf4, 0xbe, 0x40, 0xdb, 0xf0,
	0x92, 0x37, 0x70, 0xdb, 0x89, 0x70, 0x60, 0x40, 0xe5, 0x45, 0x71, 0x28, 0x7c, 0x84, 0x03, 0xe9,
	0x17, 0xe1, 0x8e, 0xde, 0xd3, 0x58, 0x29, 0x83, 0xca, 0x72, 0x2b, 0x4f, 0xf8, 0x41, 0x1a, 0xd0,
	0xcb, 0x69, 0x5e, 0xdf, 0x58, 0xed, 0x2d, 0xdf, 0x4d, 0x03, 0xa8, 0x02, 0xd7, 0x4e, 0x09, 0xa5,
	0x1a, 0xe0, 0x70, 0xc6, 0x42, 0xa3, 0xa0, 0x40, 0x45, 0x19, 0x4f, 0x61, 0xc7, 0x2c, 0xbd, 0x17,
	0xb5, 0x4f, 0xdb, 0x4d, 0xa8, 0x30, 0x8a, 0x83, 0x7d, 0x54, 0x00, 0xed, 0xc1, 0x52, 0xc2, 0xb1,
	0x73, 0x8a, 0x29, 0x75, 0x1e, 0x86, 0xec, 0x34, 0x74, 0x86, 0x74, 0x1a, 0x97, 0x14, 0xfc, 0x6a,
	0xc2, 0xf1, 0x7d, 0x4c, 0xe9, 0xdb, 0x72, 0x7d, 0xb8, 0x96, 0xae, 0xc0, 0x25, 0xca, 0xbc, 0x87,
	0xd8, 0x37, 0xd6, 0x14, 0x50, 0xff, 0x92, 0x26, 0xc4, 0xba, 0x10, 0x9d, 0x10, 0x63, 0x1f, 0xfb,
	0xc6, 0xe5, 0x54, 0x5c, 0x2f, 0xfc, 0xae, 0x8a, 0xa2, 0xeb, 0xb0, 0xe8, 0x51, 0x16, 0x62, 0xdf,
	0x69, 0xc7, 0x2c, 0x90, 0x85, 0x83, 0x94, 0x59, 0xab, 0x69, 0xf4, 0x30, 0x66, 0x41, 0xd3, 0x37,
	0x5b, 0xf0, 0xf2, 0x48, 0x0d, 0xbf, 0x43, 0xb8, 0x40, 0x77, 0xe0, 0x22, 0x11, 0x38, 0xe0, 0x06,
	0x28, 0x2f, 0x54, 0x56, 0x6a, 0xdb, 0xd6, 0xb4, 0x8e, 0xb5, 0x46, 0xb8, 0xad, 0x94, 0x65, 0x7e,
	0x07, 0xe0, 0x86, 0xcc, 0x33, 0xb2, 0xc8, 0x5b, 0xf8, 0x93, 0x04, 0x73, 0x81, 0x5e, 0x87, 0x17,
	0x99, 0x2a, 0x6b, 0xae, 0x3a, 0x65, 0xa5, 0xf6, 0xe2, 0x44, 0xfa, 0xb4, 0xf7, 0xbb, 0xbb, 0x96,
	0xcc, 0xf2, 0x5e, 0x0a, 0x6e, 0xf5, 0x58, 0x63, 0xdd, 0x90, 0x1b, 0xef, 0x86, 0xc9, 0x73, 0xc3,
	0xa7, 0x9c, 0xfb, 0xf3, 0x1c, 0xdc, 0x18, 0xd1, 0xd7, 0x0c, 0xb9, 0x88, 0x13, 0x2f, 0xdd, 0xa2,
	0x0d, 0xf3, 0x11, 0x75, 0x45, 0x9b, 0xc5, 0x7d, 0x13, 0xde, 0xca, 0x68, 0xc2, 0x70, 0x1e, 0xeb,
	0x48, 0x27, 0x19, 0x0e, 0xb6, 0x06, 0xa9, 0x4b, 0x9f, 0x02, 0xf8, 0xec, 0xd3, 0x30, 0xa8, 0x04,
	0x97, 0x7b, 0x28, 0x3d, 0x4f, 0xfa, 0xbf, 0xd1, 0x35, 0x58, 0x20, 0x21, 0x17, 0x2e, 0xa5, 0x0e,
	0x17, 0x38, 0xe2, 0x46, 0xae, 0xbc, 0x20, 0xcf, 0xa7, 0x83, 0xc7, 0x32, 0x26, 0xcb, 0x24, 0x09,
	0x47, 0x61, 0x0b, 0x0a, 0x56, 0xec, 0x87, 0x15, 0xb0, 0xf6, 0xdb, 0x2a, 0x2c, 0x34, 0xd4, 0x51,
	0x8e, 0x71, 0xdc, 0x25, 0x1e, 0x46, 0xa7, 0xb0, 0x70, 0x0f, 0x8b, 0xfd, 0xa3, 0xe6, 0x87, 0x38,
	0xe6, 0x72, 0xfc, 0x3c, 0x3f, 0xfd, 0x82, 0xee, 0x06, 0x91, 0x38, 0x2b, 0xbd, 0x30, 0x1d, 0xa0,
	0x73, 0x98, 0xe6, 0x67, 0x7f, 0xfc, 0xfd, 0x55, 0x6e, 0x13, 0x95, 0xd4, 0x30, 0x4d, 0xbd, 0x93,
	0x73, 0xde, 0x8d, 0xc8, 0x4e, 0x57, 0xef, 0xf3, 0x3d, 0x80, 0x68, 0xb2, 0x6e, 0x50, 0xb6, 0xfa,
	0x28, 0xbd, 0x94, 0xf1, 0x82, 0x24, 0xc7, 0xdc, 0x53, 0x72, 0x6e, 0xa0, 0xfa, 0x98, 0x1c, 0x5d,
	0x46, 0xdc, 0x7e, 0xec, 0xb1, 0x50, 0xe0, 0x47, 0xb2, 0xc4, 0x9e, 0xd8, 0x9e, 0xeb, 0x0d, 0x0b,
	0xfa, 0x05, 0xc0, 0xcd, 0x49, 0x9d, 0xf7, 0x89, 0x78, 0x70, 0x48, 0xa8, 0xc0, 0x31, 0xaa, 0x4f,
	0x97, 0x32, 0xb5, 0x2f, 0xfe, 0x9d, 0xfe, 0x86, 0xd2, 0x7f, 0xc7, 0xbc, 0x39, 0x55, 0xff, 0xa0,
	0x45, 0xc6, 0xf5, 0xdb, 0x94, 0x70, 0x71, 0x1b, 0x54, 0xd1, 0x97, 0x00, 0xae, 0xdd, 0xc3, 0xa3,
	0x72, 0xd0, 0xb5, 0xe9, 0x6e, 0x37, 0x0f, 0x7a, 0x5e, 0x67, 0x9d, 0x08, 0x66, 0x55, 0xe9, 0xbc,
	0x8e, 0xcc, 0x31, 0x9d, 0x63, 0x8a, 0x1e, 0x13, 0xff, 0x09, 0xfa, 0x09, 0xc0, 0xcd, 0x71, 0x39,
	0x23, 0x4d, 0x91, 0x49, 0x5a, 0x7d, 0x8e, 0x3e, 0x35, 0x5f, 0x51, 0x32, 0x77, 0x91, 0x3d, 0x5b,
	0xa6, 0x4d, 0x86, 0x25, 0xfd, 0x00, 0xe0, 0x7a, 0x43, 0xfd, 0x2d, 0x8e, 0xba, 0x98, 0xd5, 0xa0,
	0xec, 0x4e, 0xbe, 0xa6, 0x24, 0xde, 0x34, 0xeb, 0x73, 0xdc, 0xb8, 0xbc, 0xec, 0xaf, 0x01, 0x44,
	0x0d, 0x39, 0x01, 0xff, 0xcb, 0xeb, 0x7e, 0x59, 0x89, 0xac, 0x9a, 0x95, 0x0c, 0x3e, 0xaa, 0x71,
	0x8c, 0xbe, 0x01, 0x70, 0xfd, 0x83, 0xc8, 0xff, 0x1f, 0x0c, 0xdc, 0x51, 0xda, 0xb6, 0x6b, 0x19,
	0x4a, 0x51, 0xfa, 0xf5, 0x05, 0x80, 0xeb, 0xe9, 0x83, 0x61, 0x0e, 0xc3, 0x66, 0x4d, 0xcc, 0x5e,
	0x5f, 0x54, 0xb3, 0xf4, 0xc5, 0x8f, 0x00, 0x5e, 0x3d, 0xc6, 0x42, 0xbf, 0x2a, 0xe6, 0xb4, 0x69,
	0xa6, 0xa2, 0x43, 0xa5, 0xe8, 0x0d, 0x73, 0x6f, 0x9e, 0x89, 0xa2, 0x9f, 0x40, 0xb7, 0x41, 0xf5,
	0xcd, 0x57, 0x7f, 0x3d, 0xdf, 0x02, 0xbf, 0x9f, 0x6f, 0x81, 0x3f, 0xcf, 0xb7, 0xc0, 0xb7, 0x7f,
	0x6d, 0x3d, 0xf3, 0x51, 0x75, 0xe8, 0x09, 0xde, 0x13, 0xb1, 0x13, 0xb8, 0xa1, 0xdb, 0xc1, 0xbe,
	0xdc, 0x8c, 0x0f, 0x76, 0x3b, 0x59, 0x52, 0x2f, 0xc0, 0xfa, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff,
	0xa4, 0x6d, 0x74, 0x02, 0x32, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// CryptoServiceClient is the client API for CryptoService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CryptoServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all CA certificates in the project identified by the given context ID.
	// Required permissions:
	// - crypto.cacertificate.list on the project identified by the given context ID
	ListCACertificates(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*CACertificateList, error)
	// Fetch all CA certificates in the project identified by the given project ID
	// that match the given filter.
	// Required permissions:
	// - crypto.cacertificate.list on the project identified by the given context ID
	ListCACertificatesWithFilter(ctx context.Context, in *ListCACertificatesRequest, opts ...grpc.CallOption) (*CACertificateList, error)
	// Fetch a CA certificate by its id.
	// Required permissions:
	// - crypto.cacertificate.get on the CA certificate identified by the given ID
	GetCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*CACertificate, error)
	// Fetch instructions for installing & unistalling a CA certificate identified by its id
	// on various platforms.
	// Required permissions:
	// - crypto.cacertificate.get on the CA certificate identified by the given ID
	GetCACertificateInstructions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*CACertificateInstructions, error)
	// Create a new CA certificate
	// Required permissions:
	// - crypto.cacertificate.create on the project that owns the CA certificate
	CreateCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*CACertificate, error)
	// Clone a CA certificate identified by given id.
	// Required permissions:
	// - crypto.cacertificate.clone on the project that owns the CA certificate identified by the given ID
	CloneCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*CACertificate, error)
	// Update a CA certificate
	// Required permissions:
	// - crypto.cacertificate.update on the CA certificate
	UpdateCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*CACertificate, error)
	// Delete a CA certificate
	// Note that CA certificate are initially only marked for deleted.
	// Once all the resources that depend on it are removed the CA certificate itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - crypto.cacertificate.delete on the CA certificate
	DeleteCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Mark the given CA certificate as default for its containing project.
	// Required permissions:
	// - crypto.cacertificate.set-default on the project that owns the certificate.
	SetDefaultCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*v1.Empty, error)
}

type cryptoServiceClient struct {
	cc *grpc.ClientConn
}

func NewCryptoServiceClient(cc *grpc.ClientConn) CryptoServiceClient {
	return &cryptoServiceClient{cc}
}

func (c *cryptoServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) ListCACertificates(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*CACertificateList, error) {
	out := new(CACertificateList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/ListCACertificates", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) ListCACertificatesWithFilter(ctx context.Context, in *ListCACertificatesRequest, opts ...grpc.CallOption) (*CACertificateList, error) {
	out := new(CACertificateList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/ListCACertificatesWithFilter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) GetCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*CACertificate, error) {
	out := new(CACertificate)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/GetCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) GetCACertificateInstructions(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*CACertificateInstructions, error) {
	out := new(CACertificateInstructions)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/GetCACertificateInstructions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) CreateCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*CACertificate, error) {
	out := new(CACertificate)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/CreateCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) CloneCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*CACertificate, error) {
	out := new(CACertificate)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/CloneCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) UpdateCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*CACertificate, error) {
	out := new(CACertificate)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/UpdateCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) DeleteCACertificate(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/DeleteCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cryptoServiceClient) SetDefaultCACertificate(ctx context.Context, in *CACertificate, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.crypto.v1.CryptoService/SetDefaultCACertificate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CryptoServiceServer is the server API for CryptoService service.
type CryptoServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all CA certificates in the project identified by the given context ID.
	// Required permissions:
	// - crypto.cacertificate.list on the project identified by the given context ID
	ListCACertificates(context.Context, *v1.ListOptions) (*CACertificateList, error)
	// Fetch all CA certificates in the project identified by the given project ID
	// that match the given filter.
	// Required permissions:
	// - crypto.cacertificate.list on the project identified by the given context ID
	ListCACertificatesWithFilter(context.Context, *ListCACertificatesRequest) (*CACertificateList, error)
	// Fetch a CA certificate by its id.
	// Required permissions:
	// - crypto.cacertificate.get on the CA certificate identified by the given ID
	GetCACertificate(context.Context, *v1.IDOptions) (*CACertificate, error)
	// Fetch instructions for installing & unistalling a CA certificate identified by its id
	// on various platforms.
	// Required permissions:
	// - crypto.cacertificate.get on the CA certificate identified by the given ID
	GetCACertificateInstructions(context.Context, *v1.IDOptions) (*CACertificateInstructions, error)
	// Create a new CA certificate
	// Required permissions:
	// - crypto.cacertificate.create on the project that owns the CA certificate
	CreateCACertificate(context.Context, *CACertificate) (*CACertificate, error)
	// Clone a CA certificate identified by given id.
	// Required permissions:
	// - crypto.cacertificate.clone on the project that owns the CA certificate identified by the given ID
	CloneCACertificate(context.Context, *v1.IDOptions) (*CACertificate, error)
	// Update a CA certificate
	// Required permissions:
	// - crypto.cacertificate.update on the CA certificate
	UpdateCACertificate(context.Context, *CACertificate) (*CACertificate, error)
	// Delete a CA certificate
	// Note that CA certificate are initially only marked for deleted.
	// Once all the resources that depend on it are removed the CA certificate itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - crypto.cacertificate.delete on the CA certificate
	DeleteCACertificate(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Mark the given CA certificate as default for its containing project.
	// Required permissions:
	// - crypto.cacertificate.set-default on the project that owns the certificate.
	SetDefaultCACertificate(context.Context, *CACertificate) (*v1.Empty, error)
}

// UnimplementedCryptoServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCryptoServiceServer struct {
}

func (*UnimplementedCryptoServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedCryptoServiceServer) ListCACertificates(ctx context.Context, req *v1.ListOptions) (*CACertificateList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCACertificates not implemented")
}
func (*UnimplementedCryptoServiceServer) ListCACertificatesWithFilter(ctx context.Context, req *ListCACertificatesRequest) (*CACertificateList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCACertificatesWithFilter not implemented")
}
func (*UnimplementedCryptoServiceServer) GetCACertificate(ctx context.Context, req *v1.IDOptions) (*CACertificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCACertificate not implemented")
}
func (*UnimplementedCryptoServiceServer) GetCACertificateInstructions(ctx context.Context, req *v1.IDOptions) (*CACertificateInstructions, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCACertificateInstructions not implemented")
}
func (*UnimplementedCryptoServiceServer) CreateCACertificate(ctx context.Context, req *CACertificate) (*CACertificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCACertificate not implemented")
}
func (*UnimplementedCryptoServiceServer) CloneCACertificate(ctx context.Context, req *v1.IDOptions) (*CACertificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloneCACertificate not implemented")
}
func (*UnimplementedCryptoServiceServer) UpdateCACertificate(ctx context.Context, req *CACertificate) (*CACertificate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCACertificate not implemented")
}
func (*UnimplementedCryptoServiceServer) DeleteCACertificate(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCACertificate not implemented")
}
func (*UnimplementedCryptoServiceServer) SetDefaultCACertificate(ctx context.Context, req *CACertificate) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultCACertificate not implemented")
}

func RegisterCryptoServiceServer(s *grpc.Server, srv CryptoServiceServer) {
	s.RegisterService(&_CryptoService_serviceDesc, srv)
}

func _CryptoService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_ListCACertificates_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).ListCACertificates(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/ListCACertificates",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).ListCACertificates(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_ListCACertificatesWithFilter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCACertificatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).ListCACertificatesWithFilter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/ListCACertificatesWithFilter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).ListCACertificatesWithFilter(ctx, req.(*ListCACertificatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_GetCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).GetCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/GetCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).GetCACertificate(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_GetCACertificateInstructions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).GetCACertificateInstructions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/GetCACertificateInstructions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).GetCACertificateInstructions(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_CreateCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CACertificate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).CreateCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/CreateCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).CreateCACertificate(ctx, req.(*CACertificate))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_CloneCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).CloneCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/CloneCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).CloneCACertificate(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_UpdateCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CACertificate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).UpdateCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/UpdateCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).UpdateCACertificate(ctx, req.(*CACertificate))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_DeleteCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).DeleteCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/DeleteCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).DeleteCACertificate(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _CryptoService_SetDefaultCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CACertificate)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CryptoServiceServer).SetDefaultCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.crypto.v1.CryptoService/SetDefaultCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CryptoServiceServer).SetDefaultCACertificate(ctx, req.(*CACertificate))
	}
	return interceptor(ctx, in, info, handler)
}

var _CryptoService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.crypto.v1.CryptoService",
	HandlerType: (*CryptoServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _CryptoService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListCACertificates",
			Handler:    _CryptoService_ListCACertificates_Handler,
		},
		{
			MethodName: "ListCACertificatesWithFilter",
			Handler:    _CryptoService_ListCACertificatesWithFilter_Handler,
		},
		{
			MethodName: "GetCACertificate",
			Handler:    _CryptoService_GetCACertificate_Handler,
		},
		{
			MethodName: "GetCACertificateInstructions",
			Handler:    _CryptoService_GetCACertificateInstructions_Handler,
		},
		{
			MethodName: "CreateCACertificate",
			Handler:    _CryptoService_CreateCACertificate_Handler,
		},
		{
			MethodName: "CloneCACertificate",
			Handler:    _CryptoService_CloneCACertificate_Handler,
		},
		{
			MethodName: "UpdateCACertificate",
			Handler:    _CryptoService_UpdateCACertificate_Handler,
		},
		{
			MethodName: "DeleteCACertificate",
			Handler:    _CryptoService_DeleteCACertificate_Handler,
		},
		{
			MethodName: "SetDefaultCACertificate",
			Handler:    _CryptoService_SetDefaultCACertificate_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "crypto.proto",
}

func (m *CACertificate) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CACertificate) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CACertificate) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ClonedFromId) > 0 {
		i -= len(m.ClonedFromId)
		copy(dAtA[i:], m.ClonedFromId)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.ClonedFromId)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x92
	}
	if m.RotationNeeded {
		i--
		if m.RotationNeeded {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.Locked {
		i--
		if m.Locked {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.UseWellKnownCertificate {
		i--
		if m.UseWellKnownCertificate {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x78
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.WillExpireSoon {
		i--
		if m.WillExpireSoon {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x68
	}
	if m.IsExpired {
		i--
		if m.IsExpired {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.CertificatePem) > 0 {
		i -= len(m.CertificatePem)
		copy(dAtA[i:], m.CertificatePem)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.CertificatePem)))
		i--
		dAtA[i] = 0x52
	}
	if m.ExpiresAt != nil {
		{
			size, err := m.ExpiresAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCrypto(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCrypto(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCrypto(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Lifetime != nil {
		{
			size, err := m.Lifetime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCrypto(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CACertificateList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CACertificateList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CACertificateList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCrypto(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListCACertificatesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListCACertificatesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListCACertificatesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ClonedFromId) > 0 {
		i -= len(m.ClonedFromId)
		copy(dAtA[i:], m.ClonedFromId)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.ClonedFromId)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCrypto(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CACertificateInstructions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CACertificateInstructions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CACertificateInstructions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Platforms) > 0 {
		for iNdEx := len(m.Platforms) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Platforms[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCrypto(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CACertificateInstructions_PlatformInstructions) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CACertificateInstructions_PlatformInstructions) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CACertificateInstructions_PlatformInstructions) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.UninstallSteps) > 0 {
		for iNdEx := len(m.UninstallSteps) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.UninstallSteps[iNdEx])
			copy(dAtA[i:], m.UninstallSteps[iNdEx])
			i = encodeVarintCrypto(dAtA, i, uint64(len(m.UninstallSteps[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.InstallSteps) > 0 {
		for iNdEx := len(m.InstallSteps) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.InstallSteps[iNdEx])
			copy(dAtA[i:], m.InstallSteps[iNdEx])
			i = encodeVarintCrypto(dAtA, i, uint64(len(m.InstallSteps[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Platform) > 0 {
		i -= len(m.Platform)
		copy(dAtA[i:], m.Platform)
		i = encodeVarintCrypto(dAtA, i, uint64(len(m.Platform)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintCrypto(dAtA []byte, offset int, v uint64) int {
	offset -= sovCrypto(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CACertificate) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.Lifetime != nil {
		l = m.Lifetime.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.ExpiresAt != nil {
		l = m.ExpiresAt.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.CertificatePem)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.IsExpired {
		n += 2
	}
	if m.WillExpireSoon {
		n += 2
	}
	if m.IsDefault {
		n += 2
	}
	if m.UseWellKnownCertificate {
		n += 2
	}
	if m.Locked {
		n += 3
	}
	if m.RotationNeeded {
		n += 3
	}
	l = len(m.ClonedFromId)
	if l > 0 {
		n += 2 + l + sovCrypto(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CACertificateList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovCrypto(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListCACertificatesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	l = len(m.ClonedFromId)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CACertificateInstructions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Platforms) > 0 {
		for _, e := range m.Platforms {
			l = e.Size()
			n += 1 + l + sovCrypto(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CACertificateInstructions_PlatformInstructions) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Platform)
	if l > 0 {
		n += 1 + l + sovCrypto(uint64(l))
	}
	if len(m.InstallSteps) > 0 {
		for _, s := range m.InstallSteps {
			l = len(s)
			n += 1 + l + sovCrypto(uint64(l))
		}
	}
	if len(m.UninstallSteps) > 0 {
		for _, s := range m.UninstallSteps {
			l = len(s)
			n += 1 + l + sovCrypto(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCrypto(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCrypto(x uint64) (n int) {
	return sovCrypto(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CACertificate) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CACertificate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CACertificate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lifetime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lifetime == nil {
				m.Lifetime = &types.Duration{}
			}
			if err := m.Lifetime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiresAt == nil {
				m.ExpiresAt = &types.Timestamp{}
			}
			if err := m.ExpiresAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CertificatePem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CertificatePem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsExpired", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsExpired = bool(v != 0)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WillExpireSoon", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WillExpireSoon = bool(v != 0)
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UseWellKnownCertificate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UseWellKnownCertificate = bool(v != 0)
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Locked = bool(v != 0)
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RotationNeeded", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RotationNeeded = bool(v != 0)
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClonedFromId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClonedFromId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCrypto(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CACertificateList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CACertificateList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CACertificateList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &CACertificate{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCrypto(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListCACertificatesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListCACertificatesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListCACertificatesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClonedFromId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClonedFromId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCrypto(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CACertificateInstructions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CACertificateInstructions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CACertificateInstructions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platforms", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platforms = append(m.Platforms, &CACertificateInstructions_PlatformInstructions{})
			if err := m.Platforms[len(m.Platforms)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCrypto(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CACertificateInstructions_PlatformInstructions) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlatformInstructions: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlatformInstructions: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platform", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platform = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstallSteps", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InstallSteps = append(m.InstallSteps, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UninstallSteps", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCrypto
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCrypto
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UninstallSteps = append(m.UninstallSteps, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCrypto(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCrypto
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCrypto(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCrypto
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCrypto
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCrypto
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthCrypto
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCrypto
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCrypto(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthCrypto
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCrypto = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCrypto   = fmt.Errorf("proto: integer overflow")
)
