// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: metrics.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A Token is represents an access token used to authenticate requests for metrics.
type Token struct {
	// System identifier of the token.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of this resource
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the token
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the token
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the deployment that owns this token.
	// This value cannot be changed after creation.
	DeploymentId string `protobuf:"bytes,5,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Time from creation of the token to expiration.
	// This value cannot be changed after creation.
	// If no value is set, a default value of 90 days is used.
	Lifetime *types.Duration `protobuf:"bytes,6,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// The creation timestamp of the token.
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the token.
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// The expiration timestamp of the token.
	// This is a read-only value.
	ExpiresAt *types.Timestamp `protobuf:"bytes,9,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
	// The bearer token used for authentication.
	// This is a read-only value that is only given directly after
	// creation of the token. In all other calls, this field
	// will be empty.
	Token string `protobuf:"bytes,10,opt,name=token,proto3" json:"token,omitempty"`
	// Set when this token is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,11,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Set when this token has expired.
	// This is a read-only value.
	IsExpired bool `protobuf:"varint,12,opt,name=is_expired,json=isExpired,proto3" json:"is_expired,omitempty"`
	// Set when this token will expire in the next month.
	// This is a read-only value.
	WillExpireSoon bool `protobuf:"varint,13,opt,name=will_expire_soon,json=willExpireSoon,proto3" json:"will_expire_soon,omitempty"`
	// Set when this token is revoked.
	// This is a read-only value.
	IsRevoked            bool     `protobuf:"varint,14,opt,name=is_revoked,json=isRevoked,proto3" json:"is_revoked,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Token) Reset()         { *m = Token{} }
func (m *Token) String() string { return proto.CompactTextString(m) }
func (*Token) ProtoMessage()    {}
func (*Token) Descriptor() ([]byte, []int) {
	return fileDescriptor_6039342a2ba47b72, []int{0}
}
func (m *Token) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Token) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Token.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Token) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Token.Merge(m, src)
}
func (m *Token) XXX_Size() int {
	return m.Size()
}
func (m *Token) XXX_DiscardUnknown() {
	xxx_messageInfo_Token.DiscardUnknown(m)
}

var xxx_messageInfo_Token proto.InternalMessageInfo

func (m *Token) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Token) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Token) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Token) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Token) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *Token) GetLifetime() *types.Duration {
	if m != nil {
		return m.Lifetime
	}
	return nil
}

func (m *Token) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Token) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Token) GetExpiresAt() *types.Timestamp {
	if m != nil {
		return m.ExpiresAt
	}
	return nil
}

func (m *Token) GetToken() string {
	if m != nil {
		return m.Token
	}
	return ""
}

func (m *Token) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Token) GetIsExpired() bool {
	if m != nil {
		return m.IsExpired
	}
	return false
}

func (m *Token) GetWillExpireSoon() bool {
	if m != nil {
		return m.WillExpireSoon
	}
	return false
}

func (m *Token) GetIsRevoked() bool {
	if m != nil {
		return m.IsRevoked
	}
	return false
}

// List of Tokens.
type TokenList struct {
	Items                []*Token `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TokenList) Reset()         { *m = TokenList{} }
func (m *TokenList) String() string { return proto.CompactTextString(m) }
func (*TokenList) ProtoMessage()    {}
func (*TokenList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6039342a2ba47b72, []int{1}
}
func (m *TokenList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TokenList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TokenList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TokenList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TokenList.Merge(m, src)
}
func (m *TokenList) XXX_Size() int {
	return m.Size()
}
func (m *TokenList) XXX_DiscardUnknown() {
	xxx_messageInfo_TokenList.DiscardUnknown(m)
}

var xxx_messageInfo_TokenList proto.InternalMessageInfo

func (m *TokenList) GetItems() []*Token {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for ListTokens.
type ListTokensRequest struct {
	// Common list options.
	// Context_id is ignored.
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// Required ID of deployment to list tokens for.
	DeploymentId string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// If set, do not return revoked tokens.
	ExcludeRevoked bool `protobuf:"varint,3,opt,name=exclude_revoked,json=excludeRevoked,proto3" json:"exclude_revoked,omitempty"`
	// If set, do not return expired tokens.
	ExcludeExpired bool `protobuf:"varint,4,opt,name=exclude_expired,json=excludeExpired,proto3" json:"exclude_expired,omitempty"`
	// If set, do not return deleted (marked for deletion) tokens.
	ExcludeDeleted       bool     `protobuf:"varint,5,opt,name=exclude_deleted,json=excludeDeleted,proto3" json:"exclude_deleted,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTokensRequest) Reset()         { *m = ListTokensRequest{} }
func (m *ListTokensRequest) String() string { return proto.CompactTextString(m) }
func (*ListTokensRequest) ProtoMessage()    {}
func (*ListTokensRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6039342a2ba47b72, []int{2}
}
func (m *ListTokensRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListTokensRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListTokensRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListTokensRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTokensRequest.Merge(m, src)
}
func (m *ListTokensRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListTokensRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTokensRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTokensRequest proto.InternalMessageInfo

func (m *ListTokensRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListTokensRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *ListTokensRequest) GetExcludeRevoked() bool {
	if m != nil {
		return m.ExcludeRevoked
	}
	return false
}

func (m *ListTokensRequest) GetExcludeExpired() bool {
	if m != nil {
		return m.ExcludeExpired
	}
	return false
}

func (m *ListTokensRequest) GetExcludeDeleted() bool {
	if m != nil {
		return m.ExcludeDeleted
	}
	return false
}

// Request arguments for GetMetricsEndpoint
type GetMetricsEndpointRequest struct {
	// ID of the deployment to get the endpoint for.
	DeploymentId         string   `protobuf:"bytes,1,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMetricsEndpointRequest) Reset()         { *m = GetMetricsEndpointRequest{} }
func (m *GetMetricsEndpointRequest) String() string { return proto.CompactTextString(m) }
func (*GetMetricsEndpointRequest) ProtoMessage()    {}
func (*GetMetricsEndpointRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6039342a2ba47b72, []int{3}
}
func (m *GetMetricsEndpointRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetMetricsEndpointRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetMetricsEndpointRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetMetricsEndpointRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMetricsEndpointRequest.Merge(m, src)
}
func (m *GetMetricsEndpointRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetMetricsEndpointRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMetricsEndpointRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMetricsEndpointRequest proto.InternalMessageInfo

func (m *GetMetricsEndpointRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

// Response for GetMetricsEndpoint
type MetricsEndpoint struct {
	// Endpoint (url) to get metrics from.
	// If no valid metrics tokens are configured this field is empty.
	Endpoint             string   `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetricsEndpoint) Reset()         { *m = MetricsEndpoint{} }
func (m *MetricsEndpoint) String() string { return proto.CompactTextString(m) }
func (*MetricsEndpoint) ProtoMessage()    {}
func (*MetricsEndpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_6039342a2ba47b72, []int{4}
}
func (m *MetricsEndpoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MetricsEndpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MetricsEndpoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MetricsEndpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetricsEndpoint.Merge(m, src)
}
func (m *MetricsEndpoint) XXX_Size() int {
	return m.Size()
}
func (m *MetricsEndpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_MetricsEndpoint.DiscardUnknown(m)
}

var xxx_messageInfo_MetricsEndpoint proto.InternalMessageInfo

func (m *MetricsEndpoint) GetEndpoint() string {
	if m != nil {
		return m.Endpoint
	}
	return ""
}

func init() {
	proto.RegisterType((*Token)(nil), "arangodb.cloud.metrics.v1.Token")
	proto.RegisterType((*TokenList)(nil), "arangodb.cloud.metrics.v1.TokenList")
	proto.RegisterType((*ListTokensRequest)(nil), "arangodb.cloud.metrics.v1.ListTokensRequest")
	proto.RegisterType((*GetMetricsEndpointRequest)(nil), "arangodb.cloud.metrics.v1.GetMetricsEndpointRequest")
	proto.RegisterType((*MetricsEndpoint)(nil), "arangodb.cloud.metrics.v1.MetricsEndpoint")
}

func init() { proto.RegisterFile("metrics.proto", fileDescriptor_6039342a2ba47b72) }

var fileDescriptor_6039342a2ba47b72 = []byte{
	// 860 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x4f, 0x8f, 0xdb, 0x44,
	0x14, 0xc7, 0xf9, 0xd3, 0x26, 0xcf, 0x4d, 0x5a, 0x46, 0x08, 0x79, 0x0d, 0x0d, 0xc1, 0x5b, 0x20,
	0xa4, 0xac, 0xad, 0x84, 0x02, 0x6a, 0x51, 0x05, 0x4b, 0x77, 0xb5, 0x5a, 0x09, 0x04, 0x72, 0x0b,
	0x07, 0x2e, 0x91, 0xe3, 0x99, 0x86, 0x51, 0x6d, 0x8f, 0xf1, 0x4c, 0x42, 0xa2, 0x6a, 0x85, 0xc4,
	0x8d, 0x1b, 0x12, 0x17, 0x0e, 0x7c, 0x01, 0xbe, 0x09, 0x47, 0x24, 0x24, 0xce, 0x68, 0xe1, 0x23,
	0xf0, 0x01, 0x90, 0x67, 0xc6, 0x49, 0x36, 0x21, 0x09, 0xa0, 0xbd, 0x8d, 0xdf, 0xfc, 0x7e, 0xef,
	0xbd, 0xf9, 0xcd, 0x6f, 0x5e, 0x02, 0x8d, 0x98, 0x88, 0x8c, 0x86, 0xdc, 0x4d, 0x33, 0x26, 0x18,
	0xda, 0x0b, 0xb2, 0x20, 0x19, 0x31, 0x3c, 0x74, 0xc3, 0x88, 0x8d, 0xb1, 0x5b, 0xec, 0x4e, 0x7a,
	0xf6, 0xf3, 0x21, 0x8b, 0x63, 0x96, 0x78, 0x93, 0x9e, 0xa7, 0x56, 0x8a, 0x62, 0xdf, 0x1d, 0x51,
	0xf1, 0xc5, 0x78, 0xe8, 0x86, 0x2c, 0xf6, 0x46, 0x2c, 0x0a, 0x92, 0x91, 0x27, 0x37, 0x86, 0xe3,
	0xc7, 0x5e, 0x2a, 0x66, 0x29, 0xe1, 0x1e, 0x1e, 0x67, 0x81, 0xa0, 0x2c, 0x99, 0x2f, 0x34, 0xf5,
	0xdd, 0xdd, 0x54, 0x41, 0x63, 0xc2, 0x45, 0x10, 0xa7, 0x8b, 0x95, 0x26, 0xbf, 0x38, 0x62, 0x6c,
	0x14, 0x11, 0x2f, 0x48, 0xa9, 0x17, 0x24, 0x09, 0x13, 0x32, 0xb3, 0x3e, 0x88, 0xf3, 0x6d, 0x05,
	0xaa, 0x8f, 0xd8, 0x13, 0x92, 0xa0, 0x26, 0x94, 0x28, 0xb6, 0x8c, 0xb6, 0xd1, 0xa9, 0xfb, 0x25,
	0x8a, 0xd1, 0x0d, 0x28, 0x8f, 0xb3, 0xc8, 0x2a, 0xc9, 0x40, 0xbe, 0x44, 0x08, 0x2a, 0x49, 0x10,
	0x13, 0xab, 0x2c, 0x43, 0x72, 0x8d, 0xda, 0x60, 0x62, 0xc2, 0xc3, 0x8c, 0xa6, 0x79, 0x56, 0xab,
	0x22, 0xb7, 0x96, 0x43, 0x68, 0x1f, 0x1a, 0x98, 0xa4, 0x11, 0x9b, 0xc5, 0x24, 0x11, 0x03, 0x8a,
	0xad, 0xaa, 0xc4, 0x5c, 0x5b, 0x04, 0x4f, 0x31, 0x7a, 0x0b, 0x6a, 0x11, 0x7d, 0x4c, 0xf2, 0xde,
	0xad, 0x2b, 0x6d, 0xa3, 0x63, 0xf6, 0xf7, 0x5c, 0xd5, 0xb7, 0x5b, 0x9c, 0xd4, 0x3d, 0xd2, 0xa2,
	0xf8, 0x73, 0x28, 0xba, 0x0b, 0x10, 0x66, 0x24, 0x10, 0x04, 0x0f, 0x02, 0x61, 0x5d, 0x95, 0x44,
	0x7b, 0x8d, 0xf8, 0xa8, 0x50, 0xc4, 0xaf, 0x6b, 0xf4, 0xa1, 0xc8, 0xa9, 0x98, 0x44, 0x44, 0x53,
	0x6b, 0xbb, 0xa9, 0x1a, 0xad, 0xa8, 0x64, 0x9a, 0xd2, 0x8c, 0xf0, 0x9c, 0x5a, 0xdf, 0x4d, 0xd5,
	0xe8, 0x43, 0x81, 0x9e, 0x83, 0xaa, 0xc8, 0xd5, 0xb6, 0x40, 0x8a, 0xa0, 0x3e, 0xd0, 0x4d, 0x00,
	0xca, 0x07, 0xba, 0x80, 0x65, 0xb6, 0x8d, 0x4e, 0xcd, 0xaf, 0x53, 0x7e, 0xa4, 0x02, 0x7a, 0x5b,
	0x25, 0xc1, 0xd6, 0xb5, 0x62, 0xfb, 0x58, 0x05, 0x50, 0x07, 0x6e, 0x7c, 0x45, 0xa3, 0x48, 0x03,
	0x06, 0x9c, 0xb1, 0xc4, 0x6a, 0x48, 0x50, 0x33, 0x8f, 0x2b, 0xd8, 0x43, 0xc6, 0x8a, 0x3a, 0x19,
	0x99, 0xb0, 0x27, 0x04, 0x5b, 0xcd, 0x22, 0x91, 0xaf, 0x02, 0xce, 0x03, 0xa8, 0x4b, 0x2b, 0x7c,
	0x48, 0xb9, 0x40, 0x6f, 0x43, 0x95, 0x0a, 0x12, 0x73, 0xcb, 0x68, 0x97, 0x3b, 0x66, 0xbf, 0xed,
	0x6e, 0x74, 0xbc, 0x2b, 0x49, 0xbe, 0x82, 0x3b, 0x7f, 0x19, 0xf0, 0x6c, 0x9e, 0x40, 0x06, 0xb9,
	0x4f, 0xbe, 0x1c, 0x13, 0x2e, 0xd0, 0x7b, 0x70, 0x95, 0x49, 0x3b, 0x70, 0xe9, 0x30, 0xb3, 0xff,
	0xca, 0x6a, 0x3e, 0xfd, 0x56, 0x26, 0x3d, 0x37, 0x67, 0x7f, 0xac, 0xc0, 0x7e, 0xc1, 0x5a, 0x77,
	0x51, 0xe9, 0x1f, 0x5c, 0xf4, 0x1a, 0x5c, 0x27, 0xd3, 0x30, 0x1a, 0x63, 0x32, 0x3f, 0x64, 0x59,
	0x09, 0xa1, 0xc3, 0xfa, 0xa4, 0xcb, 0xc0, 0x42, 0xd6, 0xca, 0x05, 0x60, 0xa1, 0xed, 0x12, 0xb0,
	0xb8, 0x9e, 0xea, 0x05, 0xa0, 0xbe, 0x23, 0xe7, 0x7d, 0xd8, 0x3b, 0x21, 0xe2, 0x23, 0x25, 0xca,
	0x71, 0x82, 0x53, 0x46, 0x13, 0x51, 0x9c, 0x7e, 0xad, 0x79, 0x63, 0xbd, 0x79, 0xe7, 0x00, 0xae,
	0xaf, 0xd0, 0x91, 0x0d, 0x35, 0xa2, 0xd7, 0x9a, 0x32, 0xff, 0xee, 0xff, 0x56, 0x83, 0xa6, 0xc6,
	0x3f, 0x24, 0xd9, 0x84, 0x86, 0x04, 0x4d, 0xa1, 0x71, 0x42, 0xc4, 0xe1, 0x27, 0xa7, 0x9f, 0x91,
	0x8c, 0xe7, 0x4f, 0xef, 0xa5, 0xcd, 0x22, 0x1f, 0xc7, 0xa9, 0x98, 0xd9, 0x2f, 0x6f, 0x06, 0xe8,
	0x1c, 0xce, 0xfe, 0x37, 0xbf, 0xfe, 0xf9, 0x7d, 0xe9, 0x26, 0x7a, 0x41, 0x0e, 0x10, 0x7d, 0xeb,
	0xf9, 0x70, 0x0b, 0x52, 0x7a, 0x30, 0xd1, 0x85, 0x7e, 0x34, 0x00, 0x16, 0x97, 0x8e, 0xde, 0xd8,
	0x62, 0x96, 0x35, 0x6f, 0xd8, 0xb7, 0x76, 0x59, 0x2b, 0xa7, 0x38, 0xf7, 0x64, 0x1f, 0x77, 0x50,
	0x7f, 0xb5, 0x8f, 0x85, 0x88, 0xdc, 0x7b, 0x7a, 0x41, 0xe6, 0x33, 0x4f, 0xa8, 0x7e, 0x26, 0x50,
	0x3b, 0x21, 0xaa, 0x2a, 0xda, 0xdf, 0x7c, 0xe4, 0xd3, 0x23, 0x6d, 0x3b, 0x7b, 0xa7, 0xdb, 0x37,
	0xcb, 0xa2, 0x4a, 0x7a, 0x4f, 0x29, 0x3e, 0x43, 0xdf, 0x19, 0x60, 0x3e, 0x90, 0x13, 0x47, 0xd5,
	0xde, 0x99, 0xf6, 0x5f, 0x14, 0xbe, 0x2f, 0x0b, 0xbf, 0xe3, 0xfc, 0x0f, 0x1d, 0xee, 0x19, 0x5d,
	0x34, 0x03, 0xf3, 0xd3, 0x14, 0x5f, 0x6a, 0x47, 0xaf, 0xca, 0x8e, 0xda, 0xfd, 0x6d, 0x52, 0xe4,
	0xa5, 0xbf, 0x06, 0x53, 0xbd, 0xbf, 0xff, 0x70, 0x11, 0xbb, 0x1c, 0xec, 0x74, 0x65, 0xf1, 0x5b,
	0x8e, 0xb3, 0xa5, 0xb8, 0xa7, 0x86, 0x01, 0x9a, 0x82, 0xa9, 0x9e, 0xeb, 0x65, 0x36, 0xa0, 0x8d,
	0xd0, 0xdd, 0x6a, 0x84, 0x9f, 0x0c, 0x40, 0xeb, 0xe3, 0x01, 0xdd, 0xd9, 0xa2, 0xed, 0xc6, 0x69,
	0x62, 0x77, 0xb7, 0xb0, 0x56, 0x28, 0x4e, 0x4f, 0x76, 0x77, 0x1b, 0xbd, 0xbe, 0xda, 0x5d, 0x31,
	0x47, 0xd6, 0xbc, 0xf2, 0xc1, 0xfd, 0x9f, 0xcf, 0x5b, 0xc6, 0x2f, 0xe7, 0x2d, 0xe3, 0xf7, 0xf3,
	0x96, 0xf1, 0xc3, 0x1f, 0xad, 0x67, 0x3e, 0xbf, 0xbd, 0xf4, 0xf7, 0xa3, 0x28, 0x7d, 0x10, 0x07,
	0x49, 0x30, 0x22, 0x38, 0xcf, 0xcb, 0x97, 0x12, 0x0f, 0xaf, 0xc8, 0x1f, 0xc0, 0x37, 0xff, 0x0e,
	0x00, 0x00, 0xff, 0xff, 0xbc, 0xff, 0x91, 0x02, 0x31, 0x09, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MetricsServiceClient is the client API for MetricsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MetricsServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all metrics token in the deployment identified by the given deployment ID.
	// Required permissions:
	// - metrics.token.list on the deployment identified by the given deployment ID
	ListTokens(ctx context.Context, in *ListTokensRequest, opts ...grpc.CallOption) (*TokenList, error)
	// Fetch a metrics token by its id.
	// Required permissions:
	// - metrics.token.get on the token identified by the given ID
	GetToken(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Token, error)
	// Create a new metrics token.
	// Required permissions:
	// - metrics.token.create on the deployment that owns the token
	CreateToken(ctx context.Context, in *Token, opts ...grpc.CallOption) (*Token, error)
	// Update a metrics token.
	// Note that you can only change the metadata (name & description) of the
	// token.
	// Required permissions:
	// - metrics.token.update on the token
	UpdateToken(ctx context.Context, in *Token, opts ...grpc.CallOption) (*Token, error)
	// Revoke a metrics token.
	// Once a token is revoked, it can no longer be used for authentication.
	// Required permissions:
	// - metrics.token.revoke on the token
	RevokeToken(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Delete a metrics token.
	// Note that token are initially only marked for deleted.
	// Once all the resources that depend on it are removed the token itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - metrics.token.delete on the token
	DeleteToken(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch the endpoint to use for getting metrics for a deployment with given id.
	// Required permissions:
	// - metrics.endpoint.get on the deployment identified by the given ID
	GetMetricsEndpoint(ctx context.Context, in *GetMetricsEndpointRequest, opts ...grpc.CallOption) (*MetricsEndpoint, error)
}

type metricsServiceClient struct {
	cc *grpc.ClientConn
}

func NewMetricsServiceClient(cc *grpc.ClientConn) MetricsServiceClient {
	return &metricsServiceClient{cc}
}

func (c *metricsServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.metrics.v1.MetricsService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceClient) ListTokens(ctx context.Context, in *ListTokensRequest, opts ...grpc.CallOption) (*TokenList, error) {
	out := new(TokenList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.metrics.v1.MetricsService/ListTokens", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceClient) GetToken(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Token, error) {
	out := new(Token)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.metrics.v1.MetricsService/GetToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceClient) CreateToken(ctx context.Context, in *Token, opts ...grpc.CallOption) (*Token, error) {
	out := new(Token)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.metrics.v1.MetricsService/CreateToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceClient) UpdateToken(ctx context.Context, in *Token, opts ...grpc.CallOption) (*Token, error) {
	out := new(Token)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.metrics.v1.MetricsService/UpdateToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceClient) RevokeToken(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.metrics.v1.MetricsService/RevokeToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceClient) DeleteToken(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.metrics.v1.MetricsService/DeleteToken", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsServiceClient) GetMetricsEndpoint(ctx context.Context, in *GetMetricsEndpointRequest, opts ...grpc.CallOption) (*MetricsEndpoint, error) {
	out := new(MetricsEndpoint)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.metrics.v1.MetricsService/GetMetricsEndpoint", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetricsServiceServer is the server API for MetricsService service.
type MetricsServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all metrics token in the deployment identified by the given deployment ID.
	// Required permissions:
	// - metrics.token.list on the deployment identified by the given deployment ID
	ListTokens(context.Context, *ListTokensRequest) (*TokenList, error)
	// Fetch a metrics token by its id.
	// Required permissions:
	// - metrics.token.get on the token identified by the given ID
	GetToken(context.Context, *v1.IDOptions) (*Token, error)
	// Create a new metrics token.
	// Required permissions:
	// - metrics.token.create on the deployment that owns the token
	CreateToken(context.Context, *Token) (*Token, error)
	// Update a metrics token.
	// Note that you can only change the metadata (name & description) of the
	// token.
	// Required permissions:
	// - metrics.token.update on the token
	UpdateToken(context.Context, *Token) (*Token, error)
	// Revoke a metrics token.
	// Once a token is revoked, it can no longer be used for authentication.
	// Required permissions:
	// - metrics.token.revoke on the token
	RevokeToken(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Delete a metrics token.
	// Note that token are initially only marked for deleted.
	// Once all the resources that depend on it are removed the token itself is deleted
	// and cannot be restored.
	// Required permissions:
	// - metrics.token.delete on the token
	DeleteToken(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch the endpoint to use for getting metrics for a deployment with given id.
	// Required permissions:
	// - metrics.endpoint.get on the deployment identified by the given ID
	GetMetricsEndpoint(context.Context, *GetMetricsEndpointRequest) (*MetricsEndpoint, error)
}

// UnimplementedMetricsServiceServer can be embedded to have forward compatible implementations.
type UnimplementedMetricsServiceServer struct {
}

func (*UnimplementedMetricsServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedMetricsServiceServer) ListTokens(ctx context.Context, req *ListTokensRequest) (*TokenList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTokens not implemented")
}
func (*UnimplementedMetricsServiceServer) GetToken(ctx context.Context, req *v1.IDOptions) (*Token, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetToken not implemented")
}
func (*UnimplementedMetricsServiceServer) CreateToken(ctx context.Context, req *Token) (*Token, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateToken not implemented")
}
func (*UnimplementedMetricsServiceServer) UpdateToken(ctx context.Context, req *Token) (*Token, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateToken not implemented")
}
func (*UnimplementedMetricsServiceServer) RevokeToken(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevokeToken not implemented")
}
func (*UnimplementedMetricsServiceServer) DeleteToken(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteToken not implemented")
}
func (*UnimplementedMetricsServiceServer) GetMetricsEndpoint(ctx context.Context, req *GetMetricsEndpointRequest) (*MetricsEndpoint, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMetricsEndpoint not implemented")
}

func RegisterMetricsServiceServer(s *grpc.Server, srv MetricsServiceServer) {
	s.RegisterService(&_MetricsService_serviceDesc, srv)
}

func _MetricsService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.metrics.v1.MetricsService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsService_ListTokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTokensRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).ListTokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.metrics.v1.MetricsService/ListTokens",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).ListTokens(ctx, req.(*ListTokensRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsService_GetToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).GetToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.metrics.v1.MetricsService/GetToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).GetToken(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsService_CreateToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Token)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).CreateToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.metrics.v1.MetricsService/CreateToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).CreateToken(ctx, req.(*Token))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsService_UpdateToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Token)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).UpdateToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.metrics.v1.MetricsService/UpdateToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).UpdateToken(ctx, req.(*Token))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsService_RevokeToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).RevokeToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.metrics.v1.MetricsService/RevokeToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).RevokeToken(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsService_DeleteToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).DeleteToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.metrics.v1.MetricsService/DeleteToken",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).DeleteToken(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsService_GetMetricsEndpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMetricsEndpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsServiceServer).GetMetricsEndpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.metrics.v1.MetricsService/GetMetricsEndpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsServiceServer).GetMetricsEndpoint(ctx, req.(*GetMetricsEndpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MetricsService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.metrics.v1.MetricsService",
	HandlerType: (*MetricsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _MetricsService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListTokens",
			Handler:    _MetricsService_ListTokens_Handler,
		},
		{
			MethodName: "GetToken",
			Handler:    _MetricsService_GetToken_Handler,
		},
		{
			MethodName: "CreateToken",
			Handler:    _MetricsService_CreateToken_Handler,
		},
		{
			MethodName: "UpdateToken",
			Handler:    _MetricsService_UpdateToken_Handler,
		},
		{
			MethodName: "RevokeToken",
			Handler:    _MetricsService_RevokeToken_Handler,
		},
		{
			MethodName: "DeleteToken",
			Handler:    _MetricsService_DeleteToken_Handler,
		},
		{
			MethodName: "GetMetricsEndpoint",
			Handler:    _MetricsService_GetMetricsEndpoint_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "metrics.proto",
}

func (m *Token) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Token) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Token) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.IsRevoked {
		i--
		if m.IsRevoked {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x70
	}
	if m.WillExpireSoon {
		i--
		if m.WillExpireSoon {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x68
	}
	if m.IsExpired {
		i--
		if m.IsExpired {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.Token) > 0 {
		i -= len(m.Token)
		copy(dAtA[i:], m.Token)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Token)))
		i--
		dAtA[i] = 0x52
	}
	if m.ExpiresAt != nil {
		{
			size, err := m.ExpiresAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if m.Lifetime != nil {
		{
			size, err := m.Lifetime.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TokenList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TokenList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TokenList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetrics(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListTokensRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListTokensRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListTokensRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.ExcludeDeleted {
		i--
		if m.ExcludeDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if m.ExcludeExpired {
		i--
		if m.ExcludeExpired {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x20
	}
	if m.ExcludeRevoked {
		i--
		if m.ExcludeRevoked {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetrics(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetMetricsEndpointRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetMetricsEndpointRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetMetricsEndpointRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *MetricsEndpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricsEndpoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *MetricsEndpoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Endpoint) > 0 {
		i -= len(m.Endpoint)
		copy(dAtA[i:], m.Endpoint)
		i = encodeVarintMetrics(dAtA, i, uint64(len(m.Endpoint)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintMetrics(dAtA []byte, offset int, v uint64) int {
	offset -= sovMetrics(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *Token) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.Lifetime != nil {
		l = m.Lifetime.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.ExpiresAt != nil {
		l = m.ExpiresAt.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	if m.IsExpired {
		n += 2
	}
	if m.WillExpireSoon {
		n += 2
	}
	if m.IsRevoked {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TokenList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovMetrics(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListTokensRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovMetrics(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.ExcludeRevoked {
		n += 2
	}
	if m.ExcludeExpired {
		n += 2
	}
	if m.ExcludeDeleted {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GetMetricsEndpointRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *MetricsEndpoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Endpoint)
	if l > 0 {
		n += 1 + l + sovMetrics(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovMetrics(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMetrics(x uint64) (n int) {
	return sovMetrics(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Token) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Token: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Token: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lifetime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lifetime == nil {
				m.Lifetime = &types.Duration{}
			}
			if err := m.Lifetime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpiresAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpiresAt == nil {
				m.ExpiresAt = &types.Timestamp{}
			}
			if err := m.ExpiresAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsExpired", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsExpired = bool(v != 0)
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WillExpireSoon", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WillExpireSoon = bool(v != 0)
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsRevoked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsRevoked = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TokenList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TokenList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TokenList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Token{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListTokensRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListTokensRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListTokensRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludeRevoked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExcludeRevoked = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludeExpired", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExcludeExpired = bool(v != 0)
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludeDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ExcludeDeleted = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetMetricsEndpointRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetMetricsEndpointRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetMetricsEndpointRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricsEndpoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricsEndpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricsEndpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoint", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetrics
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMetrics
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoint = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetrics(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetrics
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetrics(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetrics
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetrics
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMetrics
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthMetrics
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMetrics
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMetrics(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthMetrics
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMetrics = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetrics   = fmt.Errorf("proto: integer overflow")
)
