// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: security.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// IPAllowlist represents a list of CIDR ranges from which a deployment is accessible.
type IPAllowlist struct {
	// System identifier of the allowlist.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of the allowlist.
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the allowlist.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the allowlist.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that contains this allowlist.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// List of CIDR ranges.
	// Values must follow format as defined in RFC 4632 and RFC 4291.
	CidrRanges []string `protobuf:"bytes,6,rep,name=cidr_ranges,json=cidrRanges,proto3" json:"cidr_ranges,omitempty"`
	// The creation timestamp of this allowlist.
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the allowlist
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this allowlist is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the user who created this allowlist.
	// This is a read-only value.
	CreatedById string `protobuf:"bytes,10,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// If set, this allow list cannot be deleted.
	// To delete, first update the with locked set to false.
	Locked bool `protobuf:"varint,11,opt,name=locked,proto3" json:"locked,omitempty"`
	// The list of warnings which are related to the IP allow list.
	// This is a read-only value.
	Warnings             []string `protobuf:"bytes,12,rep,name=warnings,proto3" json:"warnings,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IPAllowlist) Reset()         { *m = IPAllowlist{} }
func (m *IPAllowlist) String() string { return proto.CompactTextString(m) }
func (*IPAllowlist) ProtoMessage()    {}
func (*IPAllowlist) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{0}
}
func (m *IPAllowlist) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPAllowlist) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPAllowlist.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPAllowlist) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPAllowlist.Merge(m, src)
}
func (m *IPAllowlist) XXX_Size() int {
	return m.Size()
}
func (m *IPAllowlist) XXX_DiscardUnknown() {
	xxx_messageInfo_IPAllowlist.DiscardUnknown(m)
}

var xxx_messageInfo_IPAllowlist proto.InternalMessageInfo

func (m *IPAllowlist) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *IPAllowlist) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *IPAllowlist) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IPAllowlist) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *IPAllowlist) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *IPAllowlist) GetCidrRanges() []string {
	if m != nil {
		return m.CidrRanges
	}
	return nil
}

func (m *IPAllowlist) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *IPAllowlist) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *IPAllowlist) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *IPAllowlist) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *IPAllowlist) GetLocked() bool {
	if m != nil {
		return m.Locked
	}
	return false
}

func (m *IPAllowlist) GetWarnings() []string {
	if m != nil {
		return m.Warnings
	}
	return nil
}

// List of IP allowlists.
type IPAllowlistList struct {
	Items                []*IPAllowlist `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *IPAllowlistList) Reset()         { *m = IPAllowlistList{} }
func (m *IPAllowlistList) String() string { return proto.CompactTextString(m) }
func (*IPAllowlistList) ProtoMessage()    {}
func (*IPAllowlistList) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{1}
}
func (m *IPAllowlistList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IPAllowlistList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IPAllowlistList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IPAllowlistList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IPAllowlistList.Merge(m, src)
}
func (m *IPAllowlistList) XXX_Size() int {
	return m.Size()
}
func (m *IPAllowlistList) XXX_DiscardUnknown() {
	xxx_messageInfo_IPAllowlistList.DiscardUnknown(m)
}

var xxx_messageInfo_IPAllowlistList proto.InternalMessageInfo

func (m *IPAllowlistList) GetItems() []*IPAllowlist {
	if m != nil {
		return m.Items
	}
	return nil
}

// IAMProvider provides configuration for a custom Identity & Access management provider
// for deployments.
type IAMProvider struct {
	// System identifier of the provider.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// URL of the provider.
	// This is a read-only value.
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Name of the provider.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the provider.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Identifier of the project that contains this provider.
	ProjectId string `protobuf:"bytes,5,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Type of provider
	Type string `protobuf:"bytes,6,opt,name=type,proto3" json:"type,omitempty"`
	// The creation timestamp of this provider.
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the provider
	// This is a read-only value.
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this provider is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// Identifier of the user who created this provider.
	// This is a read-only value.
	CreatedById string `protobuf:"bytes,10,opt,name=created_by_id,json=createdById,proto3" json:"created_by_id,omitempty"`
	// Set when this provider is the default in its project.
	// This is a read-only value.
	IsDefault bool `protobuf:"varint,11,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// If set, this IAM provider cannot be deleted.
	// To delete, first update the with locked set to false.
	Locked               bool                      `protobuf:"varint,12,opt,name=locked,proto3" json:"locked,omitempty"`
	LdapSettings         *IAMProvider_LDAPSettings `protobuf:"bytes,101,opt,name=ldap_settings,json=ldapSettings,proto3" json:"ldap_settings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *IAMProvider) Reset()         { *m = IAMProvider{} }
func (m *IAMProvider) String() string { return proto.CompactTextString(m) }
func (*IAMProvider) ProtoMessage()    {}
func (*IAMProvider) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{2}
}
func (m *IAMProvider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IAMProvider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IAMProvider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IAMProvider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IAMProvider.Merge(m, src)
}
func (m *IAMProvider) XXX_Size() int {
	return m.Size()
}
func (m *IAMProvider) XXX_DiscardUnknown() {
	xxx_messageInfo_IAMProvider.DiscardUnknown(m)
}

var xxx_messageInfo_IAMProvider proto.InternalMessageInfo

func (m *IAMProvider) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *IAMProvider) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *IAMProvider) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *IAMProvider) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *IAMProvider) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *IAMProvider) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *IAMProvider) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *IAMProvider) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *IAMProvider) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *IAMProvider) GetCreatedById() string {
	if m != nil {
		return m.CreatedById
	}
	return ""
}

func (m *IAMProvider) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *IAMProvider) GetLocked() bool {
	if m != nil {
		return m.Locked
	}
	return false
}

func (m *IAMProvider) GetLdapSettings() *IAMProvider_LDAPSettings {
	if m != nil {
		return m.LdapSettings
	}
	return nil
}

// LDAP provider specific settings
type IAMProvider_LDAPSettings struct {
	// Hostname or IP address of the server
	Server string `protobuf:"bytes,1,opt,name=server,proto3" json:"server,omitempty"`
	// Port number of the server (defaults to 389)
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Base distinguished name under which the search takes place
	BaseDistinguishedName string `protobuf:"bytes,3,opt,name=base_distinguished_name,json=baseDistinguishedName,proto3" json:"base_distinguished_name,omitempty"`
	// distinguished name for a read-only LDAP user to which ArangoDB can bind to search the LDAP server
	BindDistinguishedName string `protobuf:"bytes,4,opt,name=bind_distinguished_name,json=bindDistinguishedName,proto3" json:"bind_distinguished_name,omitempty"`
	// Password name for a read-only LDAP user to which ArangoDB can bind to search the LDAP server.
	// This is a set-only field. During get/list requests, this field will be empty.
	BindPassword string `protobuf:"bytes,5,opt,name=bind_password,json=bindPassword,proto3" json:"bind_password,omitempty"`
	// Refresh rate in seconds (defaults to 300)
	RefreshRate int32 `protobuf:"varint,6,opt,name=refresh_rate,json=refreshRate,proto3" json:"refresh_rate,omitempty"`
	// PEM encoded version of the CA certificate used by the LDAP server.
	TlsCaCertificatePem string `protobuf:"bytes,10,opt,name=tls_ca_certificate_pem,json=tlsCaCertificatePem,proto3" json:"tls_ca_certificate_pem,omitempty"`
	// If set, calls into the underlying LDAP library are serialized.
	// This option can be used to work around thread-unsafe LDAP library functionality.
	Serialized bool `protobuf:"varint,20,opt,name=serialized,proto3" json:"serialized,omitempty"`
	// Timeout (in seconds) used when waiting to enter the LDAP library call serialization lock.
	// This is only meaningful when serialized has been set to true.
	SerializeTimeoutSec int32 `protobuf:"varint,21,opt,name=serialize_timeout_sec,json=serializeTimeoutSec,proto3" json:"serialize_timeout_sec,omitempty"`
	// Number of retries to attempt a connection to the LDAP server.
	// Setting this to values greater than zero will make ArangoDB retry to contact the
	// LDAP server in case no connection can be made initially.
	Retries int32 `protobuf:"varint,22,opt,name=retries,proto3" json:"retries,omitempty"`
	// If set, the LDAP library will implicitly restart connections.
	Restart bool `protobuf:"varint,23,opt,name=restart,proto3" json:"restart,omitempty"`
	// If set, the LDAP library will implicitly chase referrals.
	Referrals bool `protobuf:"varint,24,opt,name=referrals,proto3" json:"referrals,omitempty"`
	// Timeout value (in seconds) for synchronous LDAP API calls (a value of 0 means default timeout).
	TimeoutSec int32 `protobuf:"varint,25,opt,name=timeout_sec,json=timeoutSec,proto3" json:"timeout_sec,omitempty"`
	// Timeout value (in seconds) after which network operations following the initial
	// connection return in case of no activity (a value of 0 means default timeout).
	NetworkTimeoutSec int32 `protobuf:"varint,26,opt,name=network_timeout_sec,json=networkTimeoutSec,proto3" json:"network_timeout_sec,omitempty"`
	// If set, the LDAP library will connect asynchronously.
	AsyncConnect bool `protobuf:"varint,27,opt,name=async_connect,json=asyncConnect,proto3" json:"async_connect,omitempty"`
	// Prefix for simple authentication
	Prefix string `protobuf:"bytes,100,opt,name=prefix,proto3" json:"prefix,omitempty"`
	// Suffix for simple authentication
	Suffix string `protobuf:"bytes,101,opt,name=suffix,proto3" json:"suffix,omitempty"`
	// LDAP search scope with possible values "base" (just search the base distinguished name),
	// "sub" (recursive search under the base distinguished name) or
	// "one" (search the base’s immediate children) (default: "sub").
	SearchScope string `protobuf:"bytes,200,opt,name=search_scope,json=searchScope,proto3" json:"search_scope,omitempty"`
	// LDAP filter expression which limits the set of LDAP users being considered
	// (default: "objectClass=*"" which means all objects).
	SearchFilter string `protobuf:"bytes,201,opt,name=search_filter,json=searchFilter,proto3" json:"search_filter,omitempty"`
	// Specifies the attribute in the user objects which is used to match the ArangoDB user name (default: "uid").
	SearchAttribute string `protobuf:"bytes,202,opt,name=search_attribute,json=searchAttribute,proto3" json:"search_attribute,omitempty"`
	// If set, this field specifies the name of the attribute used to fetch the roles of a user.
	RolesAttributeName string `protobuf:"bytes,300,opt,name=roles_attribute_name,json=rolesAttributeName,proto3" json:"roles_attribute_name,omitempty"`
	// If set, then the string {USER} in the value of this field is replaced with the distinguished
	// name of the authenticated LDAP user and the resulting search expression is used to
	// match distinguished names of LDAP objects representing roles of that user.
	RolesSearch string `protobuf:"bytes,301,opt,name=roles_search,json=rolesSearch,proto3" json:"roles_search,omitempty"`
	// Regular expression that is used to filter roles.
	// Only roles that match the regular expression are used.
	RolesInclude string `protobuf:"bytes,400,opt,name=roles_include,json=rolesInclude,proto3" json:"roles_include,omitempty"`
	// Regular expression that is used to filter roles.
	// Only roles that do not match the regular expression are used.
	RolesExclude string `protobuf:"bytes,401,opt,name=roles_exclude,json=rolesExclude,proto3" json:"roles_exclude,omitempty"`
	// A regular expression in the format of a replacement text (/re/text/).
	// This regular expression is applied to the role name found.
	// This is especially useful in the roles-search variant to extract the real role name out of the dn value.
	RolesTransformation string `protobuf:"bytes,402,opt,name=roles_transformation,json=rolesTransformation,proto3" json:"roles_transformation,omitempty"`
	// Name of role associated with the superuser.
	// Any user belonging to this role gains superuser status.
	// This role is checked after applying the roles_transformation expression.
	SuperUserRole        string   `protobuf:"bytes,403,opt,name=super_user_role,json=superUserRole,proto3" json:"super_user_role,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IAMProvider_LDAPSettings) Reset()         { *m = IAMProvider_LDAPSettings{} }
func (m *IAMProvider_LDAPSettings) String() string { return proto.CompactTextString(m) }
func (*IAMProvider_LDAPSettings) ProtoMessage()    {}
func (*IAMProvider_LDAPSettings) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{2, 0}
}
func (m *IAMProvider_LDAPSettings) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IAMProvider_LDAPSettings) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IAMProvider_LDAPSettings.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IAMProvider_LDAPSettings) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IAMProvider_LDAPSettings.Merge(m, src)
}
func (m *IAMProvider_LDAPSettings) XXX_Size() int {
	return m.Size()
}
func (m *IAMProvider_LDAPSettings) XXX_DiscardUnknown() {
	xxx_messageInfo_IAMProvider_LDAPSettings.DiscardUnknown(m)
}

var xxx_messageInfo_IAMProvider_LDAPSettings proto.InternalMessageInfo

func (m *IAMProvider_LDAPSettings) GetServer() string {
	if m != nil {
		return m.Server
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetBaseDistinguishedName() string {
	if m != nil {
		return m.BaseDistinguishedName
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetBindDistinguishedName() string {
	if m != nil {
		return m.BindDistinguishedName
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetBindPassword() string {
	if m != nil {
		return m.BindPassword
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRefreshRate() int32 {
	if m != nil {
		return m.RefreshRate
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetTlsCaCertificatePem() string {
	if m != nil {
		return m.TlsCaCertificatePem
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSerialized() bool {
	if m != nil {
		return m.Serialized
	}
	return false
}

func (m *IAMProvider_LDAPSettings) GetSerializeTimeoutSec() int32 {
	if m != nil {
		return m.SerializeTimeoutSec
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetRetries() int32 {
	if m != nil {
		return m.Retries
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetRestart() bool {
	if m != nil {
		return m.Restart
	}
	return false
}

func (m *IAMProvider_LDAPSettings) GetReferrals() bool {
	if m != nil {
		return m.Referrals
	}
	return false
}

func (m *IAMProvider_LDAPSettings) GetTimeoutSec() int32 {
	if m != nil {
		return m.TimeoutSec
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetNetworkTimeoutSec() int32 {
	if m != nil {
		return m.NetworkTimeoutSec
	}
	return 0
}

func (m *IAMProvider_LDAPSettings) GetAsyncConnect() bool {
	if m != nil {
		return m.AsyncConnect
	}
	return false
}

func (m *IAMProvider_LDAPSettings) GetPrefix() string {
	if m != nil {
		return m.Prefix
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSuffix() string {
	if m != nil {
		return m.Suffix
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSearchScope() string {
	if m != nil {
		return m.SearchScope
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSearchFilter() string {
	if m != nil {
		return m.SearchFilter
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSearchAttribute() string {
	if m != nil {
		return m.SearchAttribute
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesAttributeName() string {
	if m != nil {
		return m.RolesAttributeName
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesSearch() string {
	if m != nil {
		return m.RolesSearch
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesInclude() string {
	if m != nil {
		return m.RolesInclude
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesExclude() string {
	if m != nil {
		return m.RolesExclude
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetRolesTransformation() string {
	if m != nil {
		return m.RolesTransformation
	}
	return ""
}

func (m *IAMProvider_LDAPSettings) GetSuperUserRole() string {
	if m != nil {
		return m.SuperUserRole
	}
	return ""
}

// List of IAM providers.
type IAMProviderList struct {
	Items                []*IAMProvider `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *IAMProviderList) Reset()         { *m = IAMProviderList{} }
func (m *IAMProviderList) String() string { return proto.CompactTextString(m) }
func (*IAMProviderList) ProtoMessage()    {}
func (*IAMProviderList) Descriptor() ([]byte, []int) {
	return fileDescriptor_55a487c716a8b59c, []int{3}
}
func (m *IAMProviderList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IAMProviderList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IAMProviderList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IAMProviderList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IAMProviderList.Merge(m, src)
}
func (m *IAMProviderList) XXX_Size() int {
	return m.Size()
}
func (m *IAMProviderList) XXX_DiscardUnknown() {
	xxx_messageInfo_IAMProviderList.DiscardUnknown(m)
}

var xxx_messageInfo_IAMProviderList proto.InternalMessageInfo

func (m *IAMProviderList) GetItems() []*IAMProvider {
	if m != nil {
		return m.Items
	}
	return nil
}

func init() {
	proto.RegisterType((*IPAllowlist)(nil), "arangodb.cloud.security.v1.IPAllowlist")
	proto.RegisterType((*IPAllowlistList)(nil), "arangodb.cloud.security.v1.IPAllowlistList")
	proto.RegisterType((*IAMProvider)(nil), "arangodb.cloud.security.v1.IAMProvider")
	proto.RegisterType((*IAMProvider_LDAPSettings)(nil), "arangodb.cloud.security.v1.IAMProvider.LDAPSettings")
	proto.RegisterType((*IAMProviderList)(nil), "arangodb.cloud.security.v1.IAMProviderList")
}

func init() { proto.RegisterFile("security.proto", fileDescriptor_55a487c716a8b59c) }

var fileDescriptor_55a487c716a8b59c = []byte{
	// 1335 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x57, 0x4d, 0x6f, 0x1b, 0x45,
	0x18, 0x66, 0xf3, 0xd5, 0x7a, 0x6c, 0x27, 0xcd, 0xa4, 0x49, 0x07, 0x53, 0xd2, 0xd4, 0x2d, 0x6a,
	0x14, 0xa8, 0xad, 0xb8, 0x7c, 0x88, 0x56, 0x45, 0xb8, 0x49, 0x5b, 0x59, 0x2a, 0x60, 0xd9, 0x2d,
	0x12, 0x5c, 0x56, 0xe3, 0xdd, 0xd7, 0xce, 0xd0, 0xf5, 0xee, 0x6a, 0x66, 0xec, 0xd4, 0x54, 0xbd,
	0x20, 0x71, 0xe1, 0x04, 0x2d, 0x07, 0xee, 0x70, 0x01, 0xc1, 0xff, 0x28, 0x5c, 0x40, 0xe2, 0x0f,
	0xa0, 0xc2, 0x85, 0x7f, 0x81, 0xe6, 0x63, 0xed, 0x4d, 0x42, 0x12, 0x07, 0x5a, 0x21, 0x6e, 0x33,
	0xcf, 0xfb, 0xbc, 0x33, 0xcf, 0xcc, 0xfb, 0x78, 0xdf, 0x31, 0x9a, 0x15, 0xe0, 0xf5, 0x38, 0x93,
	0x83, 0x52, 0xcc, 0x23, 0x19, 0xe1, 0x02, 0xe5, 0x34, 0xec, 0x44, 0x7e, 0xab, 0xe4, 0x05, 0x51,
	0xcf, 0x2f, 0x0d, 0xc3, 0xfd, 0xf5, 0xc2, 0x92, 0x17, 0x75, 0xbb, 0x51, 0x58, 0xee, 0xaf, 0x97,
	0xcd, 0xc8, 0xe4, 0x14, 0xae, 0x74, 0x98, 0xdc, 0xea, 0xb5, 0x4a, 0x5e, 0xd4, 0x2d, 0x77, 0xa2,
	0x80, 0x86, 0x9d, 0xb2, 0x0e, 0xb4, 0x7a, 0xed, 0x72, 0x2c, 0x07, 0x31, 0x88, 0xb2, 0x64, 0x5d,
	0x10, 0x92, 0x76, 0xe3, 0xd1, 0xc8, 0x26, 0x9f, 0xee, 0x44, 0x51, 0x27, 0x80, 0x32, 0x8d, 0x59,
	0x99, 0x86, 0x61, 0x24, 0xa9, 0x64, 0x51, 0x28, 0x4c, 0xb4, 0xf8, 0x70, 0x12, 0x65, 0x6b, 0xf5,
	0x6a, 0x10, 0x44, 0xdb, 0x01, 0x13, 0x12, 0xcf, 0xa2, 0x09, 0xe6, 0x13, 0x67, 0xc5, 0x59, 0xcd,
	0x34, 0x26, 0x98, 0x8f, 0x4f, 0xa0, 0xc9, 0x1e, 0x0f, 0xc8, 0x84, 0x06, 0xd4, 0x10, 0x63, 0x34,
	0x15, 0xd2, 0x2e, 0x90, 0x49, 0x0d, 0xe9, 0x31, 0x5e, 0x41, 0x59, 0x1f, 0x84, 0xc7, 0x59, 0xac,
	0xd6, 0x26, 0x53, 0x3a, 0x94, 0x86, 0xf0, 0x8b, 0x08, 0xc5, 0x3c, 0xfa, 0x08, 0x3c, 0xe9, 0x32,
	0x9f, 0x4c, 0x6b, 0x42, 0xc6, 0x22, 0x35, 0x1f, 0x9f, 0x41, 0x59, 0x8f, 0xf9, 0xdc, 0x55, 0x77,
	0x03, 0x82, 0xcc, 0xac, 0x4c, 0xae, 0x66, 0x1a, 0x48, 0x41, 0x0d, 0x8d, 0xe0, 0x37, 0x11, 0xf2,
	0x38, 0x50, 0x09, 0xbe, 0x4b, 0x25, 0x39, 0xb6, 0xe2, 0xac, 0x66, 0x2b, 0x85, 0x92, 0x39, 0x5a,
	0x29, 0xb9, 0x8c, 0xd2, 0xed, 0xe4, 0xec, 0x8d, 0x8c, 0x65, 0x57, 0xa5, 0x4a, 0xf5, 0x21, 0x00,
	0x9b, 0x7a, 0xfc, 0xf0, 0x54, 0xcb, 0xae, 0x4a, 0xa5, 0x9a, 0x09, 0xd7, 0xce, 0x49, 0x66, 0xc5,
	0x59, 0x3d, 0xde, 0xc8, 0x30, 0xb1, 0x69, 0x00, 0x5c, 0x44, 0xf9, 0x44, 0x54, 0x6b, 0xa0, 0xce,
	0x85, 0xcc, 0xc1, 0x2d, 0x78, 0x6d, 0x50, 0xf3, 0xf1, 0x12, 0x9a, 0x09, 0x22, 0xef, 0x2e, 0xf8,
	0x24, 0xab, 0xd3, 0xed, 0x0c, 0x17, 0xd0, 0xf1, 0x6d, 0xca, 0x43, 0x16, 0x76, 0x04, 0xc9, 0xe9,
	0xe3, 0x0e, 0xe7, 0xc5, 0x3a, 0x9a, 0x4b, 0xd5, 0xe4, 0x96, 0xaa, 0xcb, 0x55, 0x34, 0xcd, 0x24,
	0x74, 0x05, 0x71, 0x56, 0x26, 0x57, 0xb3, 0x95, 0x0b, 0xa5, 0xfd, 0x6d, 0x54, 0x4a, 0xe5, 0x36,
	0x4c, 0x56, 0xf1, 0xe7, 0x2c, 0xca, 0xd6, 0xaa, 0xef, 0xd4, 0x79, 0xd4, 0x67, 0x3e, 0xf0, 0xff,
	0xaa, 0xcc, 0x18, 0x4d, 0x29, 0xbb, 0x92, 0x19, 0xb3, 0xa8, 0x1a, 0xff, 0x7f, 0x2b, 0x9b, 0x2c,
	0xd1, 0xa6, 0xbd, 0x40, 0xda, 0xea, 0xea, 0x25, 0x34, 0x90, 0x2a, 0x7c, 0x6e, 0x47, 0xe1, 0x3f,
	0x40, 0xf9, 0xc0, 0xa7, 0xb1, 0x2b, 0x40, 0x4a, 0x5d, 0x7d, 0xd0, 0xba, 0x5f, 0x3d, 0xb0, 0xa2,
	0xa3, 0xd2, 0x95, 0x6e, 0x6d, 0x56, 0xeb, 0x4d, 0x9b, 0xdb, 0xc8, 0xa9, 0xa5, 0x92, 0x59, 0xe1,
	0xcf, 0x63, 0x28, 0x97, 0x0e, 0x2b, 0x0d, 0x02, 0x78, 0x1f, 0xb8, 0x2d, 0xb5, 0x9d, 0xa9, 0x3a,
	0xc4, 0x11, 0x97, 0xba, 0xde, 0xd3, 0x0d, 0x3d, 0xc6, 0xaf, 0xa3, 0x53, 0x2d, 0x2a, 0xc0, 0xf5,
	0x99, 0x50, 0xc9, 0x3d, 0x26, 0xb6, 0xc0, 0x77, 0x53, 0x1e, 0x58, 0x54, 0xe1, 0xcd, 0x74, 0xf4,
	0x5d, 0x65, 0x0a, 0x95, 0xc7, 0x42, 0xff, 0xef, 0xf2, 0xa6, 0x6c, 0x1e, 0x0b, 0xfd, 0xbd, 0x79,
	0xe7, 0x50, 0x5e, 0xe7, 0xc5, 0x54, 0x88, 0xed, 0x88, 0x27, 0x6e, 0xc9, 0x29, 0xb0, 0x6e, 0x31,
	0x7c, 0x16, 0xe5, 0x38, 0xb4, 0x39, 0x88, 0x2d, 0x97, 0x53, 0x69, 0x8c, 0x33, 0xdd, 0xc8, 0x5a,
	0xac, 0x41, 0x25, 0xe0, 0x4b, 0x68, 0x49, 0x06, 0xc2, 0xf5, 0xa8, 0xeb, 0x01, 0x97, 0xac, 0xcd,
	0x3c, 0x2a, 0xc1, 0x8d, 0xa1, 0x6b, 0x6b, 0xb6, 0x20, 0x03, 0xb1, 0x41, 0x37, 0x46, 0xb1, 0x3a,
	0x74, 0xf1, 0x32, 0x42, 0x02, 0x38, 0xa3, 0x01, 0xfb, 0x18, 0x7c, 0x72, 0x52, 0x17, 0x28, 0x85,
	0xe0, 0x0a, 0x5a, 0x1c, 0xce, 0x5c, 0xf5, 0x45, 0x8d, 0x7a, 0xd2, 0x15, 0xe0, 0x91, 0x45, 0x2d,
	0x60, 0x61, 0x18, 0xbc, 0x6d, 0x62, 0x4d, 0xf0, 0x30, 0x41, 0xc7, 0x38, 0x48, 0xce, 0x40, 0x90,
	0x25, 0xcd, 0x4a, 0xa6, 0x26, 0x22, 0x24, 0xe5, 0x92, 0x9c, 0xd2, 0x5b, 0x25, 0x53, 0x7c, 0x1a,
	0x65, 0x38, 0xb4, 0x81, 0x73, 0x1a, 0x08, 0x42, 0x8c, 0x85, 0x86, 0x80, 0xfa, 0x2a, 0xa6, 0xf7,
	0x7e, 0x5e, 0xaf, 0x8a, 0xe4, 0x68, 0xcb, 0x12, 0x5a, 0x08, 0x41, 0x6e, 0x47, 0xfc, 0xee, 0x0e,
	0x91, 0x05, 0x4d, 0x9c, 0xb7, 0xa1, 0x94, 0xc4, 0x73, 0x28, 0x4f, 0xc5, 0x20, 0xf4, 0x5c, 0x2f,
	0x0a, 0x43, 0xf0, 0x24, 0x79, 0x41, 0x6f, 0x99, 0xd3, 0xe0, 0x86, 0xc1, 0x94, 0x69, 0x62, 0x0e,
	0x6d, 0x76, 0x8f, 0xf8, 0xc6, 0x34, 0x66, 0xa6, 0xcd, 0xd4, 0x6b, 0x2b, 0x1c, 0xac, 0x99, 0xf4,
	0x0c, 0x17, 0x51, 0x4e, 0x00, 0xe5, 0xde, 0x96, 0x2b, 0xbc, 0x28, 0x06, 0xf2, 0xd8, 0x78, 0x2d,
	0x6b, 0xc0, 0xa6, 0xc2, 0xf0, 0x79, 0x94, 0xb7, 0x9c, 0x36, 0x0b, 0x24, 0x70, 0xf2, 0xa3, 0x21,
	0xd9, 0xcc, 0x1b, 0x1a, 0xc4, 0x6b, 0xe8, 0x84, 0x65, 0x51, 0x29, 0x39, 0x6b, 0xf5, 0x24, 0x90,
	0x9f, 0x0c, 0x71, 0xce, 0x04, 0xaa, 0x09, 0x8e, 0xd7, 0xd1, 0x49, 0x1e, 0x05, 0x20, 0x46, 0x54,
	0xe3, 0xb9, 0xef, 0xcd, 0x37, 0x0c, 0xeb, 0xe0, 0x90, 0xae, 0x1d, 0x57, 0x44, 0x39, 0x93, 0x62,
	0xd6, 0x22, 0x3f, 0x18, 0x6a, 0x56, 0x83, 0x4d, 0x8d, 0x29, 0xa1, 0x86, 0xc3, 0x42, 0x2f, 0xe8,
	0xf9, 0x40, 0x3e, 0x37, 0xe6, 0x37, 0x99, 0x35, 0x03, 0x8e, 0x58, 0x70, 0xcf, 0xb0, 0xbe, 0x48,
	0xb3, 0xae, 0x1b, 0x10, 0x57, 0x12, 0x89, 0x92, 0xd3, 0x50, 0xb4, 0x23, 0xde, 0xd5, 0xad, 0x97,
	0x3c, 0x34, 0xe4, 0x05, 0x1d, 0xbc, 0xbd, 0x23, 0x86, 0x2f, 0xa0, 0x39, 0xd1, 0x8b, 0x81, 0xbb,
	0x3d, 0x01, 0xdc, 0x55, 0x0c, 0xf2, 0xc8, 0xd0, 0xf3, 0x1a, 0xbf, 0x23, 0x80, 0x37, 0xa2, 0x00,
	0x74, 0x8f, 0x18, 0x7d, 0x15, 0x8e, 0xde, 0x23, 0x46, 0xb9, 0xb6, 0x47, 0x54, 0xbe, 0x9b, 0x45,
	0x73, 0x4d, 0x4b, 0x69, 0x02, 0xef, 0x33, 0x0f, 0xf0, 0x00, 0xe5, 0x6f, 0x82, 0xac, 0xd6, 0x6b,
	0xef, 0x03, 0x17, 0x4a, 0xdf, 0x99, 0xdd, 0x8b, 0xda, 0x87, 0x4a, 0x7f, 0xbd, 0x74, 0xbd, 0x1b,
	0xcb, 0x41, 0xe1, 0xec, 0xfe, 0x04, 0xbb, 0x46, 0xf1, 0xfc, 0x27, 0xbf, 0xfe, 0xf1, 0x68, 0x62,
	0x19, 0x9f, 0xd6, 0x6f, 0x92, 0x44, 0x95, 0x7a, 0xf5, 0xd0, 0x98, 0x5d, 0xec, 0xdb, 0x9d, 0xbe,
	0x76, 0xd0, 0x09, 0x75, 0xac, 0x54, 0x37, 0x13, 0xf8, 0xa5, 0xfd, 0x57, 0x57, 0xdc, 0xf7, 0x74,
	0x17, 0x12, 0x85, 0x97, 0xc7, 0x6c, 0x8f, 0x2a, 0xa7, 0x78, 0x45, 0xcb, 0x79, 0x0d, 0x5f, 0xda,
	0x23, 0xc7, 0x36, 0x2e, 0x51, 0xbe, 0xef, 0x45, 0xa1, 0x84, 0x7b, 0xaa, 0xa9, 0x3d, 0x28, 0xb3,
	0x98, 0x8e, 0x04, 0x7d, 0xe6, 0xa0, 0xd9, 0x9b, 0x90, 0x16, 0x89, 0xcf, 0xed, 0xaf, 0xb1, 0xb6,
	0x99, 0x28, 0x1c, 0xb7, 0x81, 0x17, 0xd7, 0xb4, 0xba, 0xf3, 0xb8, 0xb8, 0x47, 0x5d, 0x5a, 0x47,
	0xf9, 0x3e, 0xf3, 0x1f, 0xe0, 0x6f, 0x1c, 0x34, 0xbf, 0xa1, 0x3b, 0x54, 0x5a, 0xcf, 0xb8, 0x5b,
	0x8d, 0xaf, 0xe9, 0xaa, 0xd6, 0xf4, 0x46, 0xb1, 0xb2, 0xdf, 0x8d, 0x95, 0xef, 0x8f, 0x5e, 0x01,
	0x3b, 0x2f, 0xec, 0xb2, 0xb3, 0x86, 0xbf, 0x74, 0xd0, 0xfc, 0x9d, 0xd8, 0x7f, 0xe6, 0x32, 0x2f,
	0x6a, 0x99, 0x17, 0x2a, 0x63, 0x5c, 0x9d, 0x92, 0xf5, 0xa9, 0x83, 0xe6, 0x4d, 0xff, 0x3f, 0x72,
	0x35, 0x0f, 0xfb, 0x55, 0x24, 0x55, 0x5c, 0x1b, 0xa7, 0x8a, 0x43, 0xe3, 0x8f, 0x7e, 0xa2, 0x4f,
	0xc9, 0xf8, 0x3b, 0xbf, 0x17, 0x47, 0x37, 0x3e, 0xed, 0xc6, 0x43, 0x41, 0x89, 0xf1, 0x53, 0x8f,
	0xca, 0xa7, 0x60, 0xfc, 0xd1, 0x6a, 0x07, 0x19, 0x3f, 0xa5, 0x63, 0x8f, 0xf1, 0x53, 0x7a, 0xc6,
	0xdd, 0x6a, 0x7c, 0x4d, 0x47, 0x35, 0x7e, 0x4a, 0xe8, 0x2e, 0xe3, 0x3f, 0x53, 0x99, 0x07, 0x18,
	0x7f, 0xf7, 0xd5, 0xed, 0x32, 0xfe, 0x51, 0xab, 0xf9, 0x6f, 0x8c, 0xbf, 0xa7, 0x8a, 0xdf, 0x3a,
	0x68, 0xb1, 0x09, 0xd2, 0x3e, 0xa0, 0xff, 0xd1, 0x15, 0x1d, 0xaa, 0xe7, 0x86, 0xd6, 0xf3, 0x76,
	0xf1, 0xca, 0x01, 0x9e, 0xdf, 0xaf, 0x84, 0x65, 0xfb, 0xd6, 0xbf, 0xec, 0xac, 0x5d, 0x7b, 0xeb,
	0xf1, 0x93, 0x65, 0xe7, 0x97, 0x27, 0xcb, 0xce, 0x6f, 0x4f, 0x96, 0x9d, 0xaf, 0x7e, 0x5f, 0x7e,
	0xee, 0xc3, 0x57, 0x52, 0x7f, 0xd2, 0x13, 0x11, 0x17, 0xbb, 0x34, 0xa4, 0x1d, 0xf0, 0xd5, 0x66,
	0x22, 0xbd, 0x5b, 0x6b, 0x46, 0xff, 0x3d, 0xb9, 0xf4, 0x57, 0x00, 0x00, 0x00, 0xff, 0xff, 0x63,
	0x52, 0xea, 0xa8, 0x1f, 0x10, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SecurityServiceClient is the client API for SecurityService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all IP allowlists that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.ipallowlist.list on the project identified by the given context ID.
	ListIPAllowlists(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IPAllowlistList, error)
	// Fetch an IP allowlist by its id.
	// Required permissions:
	// - security.ipallowlist.get on the IP allowlist
	GetIPAllowlist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IPAllowlist, error)
	// Create a new IP allowlist
	// Required permissions:
	// - security.ipallowlist.create on the project that owns the IP allowlist.
	CreateIPAllowlist(ctx context.Context, in *IPAllowlist, opts ...grpc.CallOption) (*IPAllowlist, error)
	// Update an IP allowlist
	// Required permissions:
	// - security.ipallowlist.update on the IP allowlist
	UpdateIPAllowlist(ctx context.Context, in *IPAllowlist, opts ...grpc.CallOption) (*IPAllowlist, error)
	// Delete an IP allowlist.
	// Note that IP allowlists are initially only marked for deletion.
	// Once all their dependent deployments are removed, the allowlist is removed.
	// Required permissions:
	// - security.ipallowlist.delete on the IP allowlist
	DeleteIPAllowlist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch all IAM providers that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.iamprovider.list on the project identified by the given context ID.
	ListIAMProviders(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IAMProviderList, error)
	// Fetch an IAM provider by its id.
	// Required permissions:
	// - security.iamprovider.get on the IAM provider
	GetIAMProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IAMProvider, error)
	// Create a new IAM provider
	// Required permissions:
	// - security.iamprovider.create on the project that owns the IAM provider.
	CreateIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*IAMProvider, error)
	// Update an IAM provider
	// Required permissions:
	// - security.iamprovider.update on the IAM provider
	UpdateIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*IAMProvider, error)
	// Delete an IAM provider.
	// Note that IAM providers are initially only marked for deletion.
	// Once all their dependent deployments are removed, the provider is removed.
	// Required permissions:
	// - security.iamprovider.delete on the IP whitelist
	DeleteIAMProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Mark the given IAM provider as default for its containing project.
	// Required permissions:
	// - security.iamprovider.set-default on the project that owns the provider.
	SetDefaultIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*v1.Empty, error)
}

type securityServiceClient struct {
	cc *grpc.ClientConn
}

func NewSecurityServiceClient(cc *grpc.ClientConn) SecurityServiceClient {
	return &securityServiceClient{cc}
}

func (c *securityServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) ListIPAllowlists(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IPAllowlistList, error) {
	out := new(IPAllowlistList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/ListIPAllowlists", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) GetIPAllowlist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IPAllowlist, error) {
	out := new(IPAllowlist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/GetIPAllowlist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) CreateIPAllowlist(ctx context.Context, in *IPAllowlist, opts ...grpc.CallOption) (*IPAllowlist, error) {
	out := new(IPAllowlist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/CreateIPAllowlist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) UpdateIPAllowlist(ctx context.Context, in *IPAllowlist, opts ...grpc.CallOption) (*IPAllowlist, error) {
	out := new(IPAllowlist)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/UpdateIPAllowlist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) DeleteIPAllowlist(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/DeleteIPAllowlist", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) ListIAMProviders(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*IAMProviderList, error) {
	out := new(IAMProviderList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/ListIAMProviders", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) GetIAMProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*IAMProvider, error) {
	out := new(IAMProvider)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/GetIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) CreateIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*IAMProvider, error) {
	out := new(IAMProvider)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/CreateIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) UpdateIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*IAMProvider, error) {
	out := new(IAMProvider)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/UpdateIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) DeleteIAMProvider(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/DeleteIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityServiceClient) SetDefaultIAMProvider(ctx context.Context, in *IAMProvider, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.security.v1.SecurityService/SetDefaultIAMProvider", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityServiceServer is the server API for SecurityService service.
type SecurityServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all IP allowlists that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.ipallowlist.list on the project identified by the given context ID.
	ListIPAllowlists(context.Context, *v1.ListOptions) (*IPAllowlistList, error)
	// Fetch an IP allowlist by its id.
	// Required permissions:
	// - security.ipallowlist.get on the IP allowlist
	GetIPAllowlist(context.Context, *v1.IDOptions) (*IPAllowlist, error)
	// Create a new IP allowlist
	// Required permissions:
	// - security.ipallowlist.create on the project that owns the IP allowlist.
	CreateIPAllowlist(context.Context, *IPAllowlist) (*IPAllowlist, error)
	// Update an IP allowlist
	// Required permissions:
	// - security.ipallowlist.update on the IP allowlist
	UpdateIPAllowlist(context.Context, *IPAllowlist) (*IPAllowlist, error)
	// Delete an IP allowlist.
	// Note that IP allowlists are initially only marked for deletion.
	// Once all their dependent deployments are removed, the allowlist is removed.
	// Required permissions:
	// - security.ipallowlist.delete on the IP allowlist
	DeleteIPAllowlist(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Fetch all IAM providers that belong to the project identified by the given
	// context ID.
	// Required permissions:
	// - security.iamprovider.list on the project identified by the given context ID.
	ListIAMProviders(context.Context, *v1.ListOptions) (*IAMProviderList, error)
	// Fetch an IAM provider by its id.
	// Required permissions:
	// - security.iamprovider.get on the IAM provider
	GetIAMProvider(context.Context, *v1.IDOptions) (*IAMProvider, error)
	// Create a new IAM provider
	// Required permissions:
	// - security.iamprovider.create on the project that owns the IAM provider.
	CreateIAMProvider(context.Context, *IAMProvider) (*IAMProvider, error)
	// Update an IAM provider
	// Required permissions:
	// - security.iamprovider.update on the IAM provider
	UpdateIAMProvider(context.Context, *IAMProvider) (*IAMProvider, error)
	// Delete an IAM provider.
	// Note that IAM providers are initially only marked for deletion.
	// Once all their dependent deployments are removed, the provider is removed.
	// Required permissions:
	// - security.iamprovider.delete on the IP whitelist
	DeleteIAMProvider(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Mark the given IAM provider as default for its containing project.
	// Required permissions:
	// - security.iamprovider.set-default on the project that owns the provider.
	SetDefaultIAMProvider(context.Context, *IAMProvider) (*v1.Empty, error)
}

// UnimplementedSecurityServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSecurityServiceServer struct {
}

func (*UnimplementedSecurityServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedSecurityServiceServer) ListIPAllowlists(ctx context.Context, req *v1.ListOptions) (*IPAllowlistList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIPAllowlists not implemented")
}
func (*UnimplementedSecurityServiceServer) GetIPAllowlist(ctx context.Context, req *v1.IDOptions) (*IPAllowlist, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIPAllowlist not implemented")
}
func (*UnimplementedSecurityServiceServer) CreateIPAllowlist(ctx context.Context, req *IPAllowlist) (*IPAllowlist, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIPAllowlist not implemented")
}
func (*UnimplementedSecurityServiceServer) UpdateIPAllowlist(ctx context.Context, req *IPAllowlist) (*IPAllowlist, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIPAllowlist not implemented")
}
func (*UnimplementedSecurityServiceServer) DeleteIPAllowlist(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIPAllowlist not implemented")
}
func (*UnimplementedSecurityServiceServer) ListIAMProviders(ctx context.Context, req *v1.ListOptions) (*IAMProviderList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIAMProviders not implemented")
}
func (*UnimplementedSecurityServiceServer) GetIAMProvider(ctx context.Context, req *v1.IDOptions) (*IAMProvider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIAMProvider not implemented")
}
func (*UnimplementedSecurityServiceServer) CreateIAMProvider(ctx context.Context, req *IAMProvider) (*IAMProvider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIAMProvider not implemented")
}
func (*UnimplementedSecurityServiceServer) UpdateIAMProvider(ctx context.Context, req *IAMProvider) (*IAMProvider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIAMProvider not implemented")
}
func (*UnimplementedSecurityServiceServer) DeleteIAMProvider(ctx context.Context, req *v1.IDOptions) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIAMProvider not implemented")
}
func (*UnimplementedSecurityServiceServer) SetDefaultIAMProvider(ctx context.Context, req *IAMProvider) (*v1.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDefaultIAMProvider not implemented")
}

func RegisterSecurityServiceServer(s *grpc.Server, srv SecurityServiceServer) {
	s.RegisterService(&_SecurityService_serviceDesc, srv)
}

func _SecurityService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_ListIPAllowlists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).ListIPAllowlists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/ListIPAllowlists",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).ListIPAllowlists(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_GetIPAllowlist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).GetIPAllowlist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/GetIPAllowlist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).GetIPAllowlist(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_CreateIPAllowlist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IPAllowlist)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).CreateIPAllowlist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/CreateIPAllowlist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).CreateIPAllowlist(ctx, req.(*IPAllowlist))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_UpdateIPAllowlist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IPAllowlist)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).UpdateIPAllowlist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/UpdateIPAllowlist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).UpdateIPAllowlist(ctx, req.(*IPAllowlist))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_DeleteIPAllowlist_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).DeleteIPAllowlist(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/DeleteIPAllowlist",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).DeleteIPAllowlist(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_ListIAMProviders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).ListIAMProviders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/ListIAMProviders",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).ListIAMProviders(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_GetIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).GetIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/GetIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).GetIAMProvider(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_CreateIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IAMProvider)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).CreateIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/CreateIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).CreateIAMProvider(ctx, req.(*IAMProvider))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_UpdateIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IAMProvider)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).UpdateIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/UpdateIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).UpdateIAMProvider(ctx, req.(*IAMProvider))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_DeleteIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).DeleteIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/DeleteIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).DeleteIAMProvider(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityService_SetDefaultIAMProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IAMProvider)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityServiceServer).SetDefaultIAMProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.security.v1.SecurityService/SetDefaultIAMProvider",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityServiceServer).SetDefaultIAMProvider(ctx, req.(*IAMProvider))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.security.v1.SecurityService",
	HandlerType: (*SecurityServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _SecurityService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListIPAllowlists",
			Handler:    _SecurityService_ListIPAllowlists_Handler,
		},
		{
			MethodName: "GetIPAllowlist",
			Handler:    _SecurityService_GetIPAllowlist_Handler,
		},
		{
			MethodName: "CreateIPAllowlist",
			Handler:    _SecurityService_CreateIPAllowlist_Handler,
		},
		{
			MethodName: "UpdateIPAllowlist",
			Handler:    _SecurityService_UpdateIPAllowlist_Handler,
		},
		{
			MethodName: "DeleteIPAllowlist",
			Handler:    _SecurityService_DeleteIPAllowlist_Handler,
		},
		{
			MethodName: "ListIAMProviders",
			Handler:    _SecurityService_ListIAMProviders_Handler,
		},
		{
			MethodName: "GetIAMProvider",
			Handler:    _SecurityService_GetIAMProvider_Handler,
		},
		{
			MethodName: "CreateIAMProvider",
			Handler:    _SecurityService_CreateIAMProvider_Handler,
		},
		{
			MethodName: "UpdateIAMProvider",
			Handler:    _SecurityService_UpdateIAMProvider_Handler,
		},
		{
			MethodName: "DeleteIAMProvider",
			Handler:    _SecurityService_DeleteIAMProvider_Handler,
		},
		{
			MethodName: "SetDefaultIAMProvider",
			Handler:    _SecurityService_SetDefaultIAMProvider_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "security.proto",
}

func (m *IPAllowlist) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPAllowlist) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPAllowlist) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Warnings) > 0 {
		for iNdEx := len(m.Warnings) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Warnings[iNdEx])
			copy(dAtA[i:], m.Warnings[iNdEx])
			i = encodeVarintSecurity(dAtA, i, uint64(len(m.Warnings[iNdEx])))
			i--
			dAtA[i] = 0x62
		}
	}
	if m.Locked {
		i--
		if m.Locked {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x52
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.CidrRanges) > 0 {
		for iNdEx := len(m.CidrRanges) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.CidrRanges[iNdEx])
			copy(dAtA[i:], m.CidrRanges[iNdEx])
			i = encodeVarintSecurity(dAtA, i, uint64(len(m.CidrRanges[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IPAllowlistList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IPAllowlistList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IPAllowlistList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSecurity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *IAMProvider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IAMProvider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IAMProvider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LdapSettings != nil {
		{
			size, err := m.LdapSettings.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if m.Locked {
		i--
		if m.Locked {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x60
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x58
	}
	if len(m.CreatedById) > 0 {
		i -= len(m.CreatedById)
		copy(dAtA[i:], m.CreatedById)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.CreatedById)))
		i--
		dAtA[i] = 0x52
	}
	if m.IsDeleted {
		i--
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.DeletedAt != nil {
		{
			size, err := m.DeletedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.CreatedAt != nil {
		{
			size, err := m.CreatedAt.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurity(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.Type) > 0 {
		i -= len(m.Type)
		copy(dAtA[i:], m.Type)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Type)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Url) > 0 {
		i -= len(m.Url)
		copy(dAtA[i:], m.Url)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Url)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IAMProvider_LDAPSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IAMProvider_LDAPSettings) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IAMProvider_LDAPSettings) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SuperUserRole) > 0 {
		i -= len(m.SuperUserRole)
		copy(dAtA[i:], m.SuperUserRole)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.SuperUserRole)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x9a
	}
	if len(m.RolesTransformation) > 0 {
		i -= len(m.RolesTransformation)
		copy(dAtA[i:], m.RolesTransformation)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesTransformation)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x92
	}
	if len(m.RolesExclude) > 0 {
		i -= len(m.RolesExclude)
		copy(dAtA[i:], m.RolesExclude)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesExclude)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x8a
	}
	if len(m.RolesInclude) > 0 {
		i -= len(m.RolesInclude)
		copy(dAtA[i:], m.RolesInclude)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesInclude)))
		i--
		dAtA[i] = 0x19
		i--
		dAtA[i] = 0x82
	}
	if len(m.RolesSearch) > 0 {
		i -= len(m.RolesSearch)
		copy(dAtA[i:], m.RolesSearch)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesSearch)))
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xea
	}
	if len(m.RolesAttributeName) > 0 {
		i -= len(m.RolesAttributeName)
		copy(dAtA[i:], m.RolesAttributeName)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.RolesAttributeName)))
		i--
		dAtA[i] = 0x12
		i--
		dAtA[i] = 0xe2
	}
	if len(m.SearchAttribute) > 0 {
		i -= len(m.SearchAttribute)
		copy(dAtA[i:], m.SearchAttribute)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.SearchAttribute)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xd2
	}
	if len(m.SearchFilter) > 0 {
		i -= len(m.SearchFilter)
		copy(dAtA[i:], m.SearchFilter)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.SearchFilter)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xca
	}
	if len(m.SearchScope) > 0 {
		i -= len(m.SearchScope)
		copy(dAtA[i:], m.SearchScope)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.SearchScope)))
		i--
		dAtA[i] = 0xc
		i--
		dAtA[i] = 0xc2
	}
	if len(m.Suffix) > 0 {
		i -= len(m.Suffix)
		copy(dAtA[i:], m.Suffix)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Suffix)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xaa
	}
	if len(m.Prefix) > 0 {
		i -= len(m.Prefix)
		copy(dAtA[i:], m.Prefix)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Prefix)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa2
	}
	if m.AsyncConnect {
		i--
		if m.AsyncConnect {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd8
	}
	if m.NetworkTimeoutSec != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.NetworkTimeoutSec))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd0
	}
	if m.TimeoutSec != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.TimeoutSec))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc8
	}
	if m.Referrals {
		i--
		if m.Referrals {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc0
	}
	if m.Restart {
		i--
		if m.Restart {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.Retries != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.Retries))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb0
	}
	if m.SerializeTimeoutSec != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.SerializeTimeoutSec))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.Serialized {
		i--
		if m.Serialized {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if len(m.TlsCaCertificatePem) > 0 {
		i -= len(m.TlsCaCertificatePem)
		copy(dAtA[i:], m.TlsCaCertificatePem)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.TlsCaCertificatePem)))
		i--
		dAtA[i] = 0x52
	}
	if m.RefreshRate != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.RefreshRate))
		i--
		dAtA[i] = 0x30
	}
	if len(m.BindPassword) > 0 {
		i -= len(m.BindPassword)
		copy(dAtA[i:], m.BindPassword)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.BindPassword)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.BindDistinguishedName) > 0 {
		i -= len(m.BindDistinguishedName)
		copy(dAtA[i:], m.BindDistinguishedName)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.BindDistinguishedName)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.BaseDistinguishedName) > 0 {
		i -= len(m.BaseDistinguishedName)
		copy(dAtA[i:], m.BaseDistinguishedName)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.BaseDistinguishedName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Port != 0 {
		i = encodeVarintSecurity(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Server) > 0 {
		i -= len(m.Server)
		copy(dAtA[i:], m.Server)
		i = encodeVarintSecurity(dAtA, i, uint64(len(m.Server)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *IAMProviderList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IAMProviderList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *IAMProviderList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSecurity(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintSecurity(dAtA []byte, offset int, v uint64) int {
	offset -= sovSecurity(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *IPAllowlist) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if len(m.CidrRanges) > 0 {
		for _, s := range m.CidrRanges {
			l = len(s)
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.Locked {
		n += 2
	}
	if len(m.Warnings) > 0 {
		for _, s := range m.Warnings {
			l = len(s)
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IPAllowlistList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IAMProvider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.Type)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.CreatedById)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.IsDefault {
		n += 2
	}
	if m.Locked {
		n += 2
	}
	if m.LdapSettings != nil {
		l = m.LdapSettings.Size()
		n += 2 + l + sovSecurity(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IAMProvider_LDAPSettings) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Server)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovSecurity(uint64(m.Port))
	}
	l = len(m.BaseDistinguishedName)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.BindDistinguishedName)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	l = len(m.BindPassword)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.RefreshRate != 0 {
		n += 1 + sovSecurity(uint64(m.RefreshRate))
	}
	l = len(m.TlsCaCertificatePem)
	if l > 0 {
		n += 1 + l + sovSecurity(uint64(l))
	}
	if m.Serialized {
		n += 3
	}
	if m.SerializeTimeoutSec != 0 {
		n += 2 + sovSecurity(uint64(m.SerializeTimeoutSec))
	}
	if m.Retries != 0 {
		n += 2 + sovSecurity(uint64(m.Retries))
	}
	if m.Restart {
		n += 3
	}
	if m.Referrals {
		n += 3
	}
	if m.TimeoutSec != 0 {
		n += 2 + sovSecurity(uint64(m.TimeoutSec))
	}
	if m.NetworkTimeoutSec != 0 {
		n += 2 + sovSecurity(uint64(m.NetworkTimeoutSec))
	}
	if m.AsyncConnect {
		n += 3
	}
	l = len(m.Prefix)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.Suffix)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.SearchScope)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.SearchFilter)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.SearchAttribute)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesAttributeName)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesSearch)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesInclude)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesExclude)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.RolesTransformation)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	l = len(m.SuperUserRole)
	if l > 0 {
		n += 2 + l + sovSecurity(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IAMProviderList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSecurity(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSecurity(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSecurity(x uint64) (n int) {
	return sovSecurity(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *IPAllowlist) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAllowlist: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAllowlist: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CidrRanges", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CidrRanges = append(m.CidrRanges, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Locked = bool(v != 0)
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warnings", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Warnings = append(m.Warnings, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IPAllowlistList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IPAllowlistList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IPAllowlistList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &IPAllowlist{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IAMProvider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IAMProvider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IAMProvider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Type = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedById", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CreatedById = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locked", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Locked = bool(v != 0)
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LdapSettings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LdapSettings == nil {
				m.LdapSettings = &IAMProvider_LDAPSettings{}
			}
			if err := m.LdapSettings.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IAMProvider_LDAPSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LDAPSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LDAPSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Server", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Server = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseDistinguishedName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BaseDistinguishedName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BindDistinguishedName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BindDistinguishedName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BindPassword", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BindPassword = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshRate", wireType)
			}
			m.RefreshRate = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RefreshRate |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TlsCaCertificatePem", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TlsCaCertificatePem = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Serialized", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Serialized = bool(v != 0)
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SerializeTimeoutSec", wireType)
			}
			m.SerializeTimeoutSec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SerializeTimeoutSec |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 22:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Retries", wireType)
			}
			m.Retries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Retries |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Restart", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Restart = bool(v != 0)
		case 24:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Referrals", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Referrals = bool(v != 0)
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeoutSec", wireType)
			}
			m.TimeoutSec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TimeoutSec |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 26:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkTimeoutSec", wireType)
			}
			m.NetworkTimeoutSec = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NetworkTimeoutSec |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsyncConnect", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AsyncConnect = bool(v != 0)
		case 100:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 101:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suffix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Suffix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 200:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchScope", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchScope = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 201:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchFilter", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchFilter = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 202:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchAttribute", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchAttribute = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 300:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesAttributeName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesAttributeName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 301:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesSearch", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesSearch = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 400:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesInclude", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesInclude = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 401:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesExclude", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesExclude = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 402:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RolesTransformation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RolesTransformation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 403:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuperUserRole", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SuperUserRole = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IAMProviderList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IAMProviderList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IAMProviderList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurity
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurity
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &IAMProvider{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurity(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSecurity
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSecurity(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSecurity
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecurity
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSecurity
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthSecurity
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSecurity
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSecurity(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthSecurity
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSecurity = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSecurity   = fmt.Errorf("proto: integer overflow")
)
