// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: support.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// SupportRequest contains information about the request
type SupportRequest struct {
	// ID of the request
	// This is a read-only field
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the user who submitted the support request
	// This is a required field
	UserName string `protobuf:"bytes,2,opt,name=user_name,json=userName,proto3" json:"user_name,omitempty"`
	// User ID is only provided if the user submitting the request has authenticated
	// This is an optional field
	UserId string `protobuf:"bytes,3,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Email address of the user if applicable submitting the request
	EmailAddress string `protobuf:"bytes,4,opt,name=email_address,json=emailAddress,proto3" json:"email_address,omitempty"`
	// Optional identifier of the organization that is the subject of the support request
	OrganizationId string `protobuf:"bytes,5,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Optional identifier of the project that is the subject of the support request
	ProjectId string `protobuf:"bytes,6,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Optional identifier of the deployment that is the subject of the support request
	DeploymentId string `protobuf:"bytes,7,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Desciption which will contain the details provided by the submitter
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
	// Severity of the request. Can be one of the following: (low|normal|high|critical)
	Severity             string   `protobuf:"bytes,9,opt,name=severity,proto3" json:"severity,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SupportRequest) Reset()         { *m = SupportRequest{} }
func (m *SupportRequest) String() string { return proto.CompactTextString(m) }
func (*SupportRequest) ProtoMessage()    {}
func (*SupportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{0}
}
func (m *SupportRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SupportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SupportRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SupportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SupportRequest.Merge(m, src)
}
func (m *SupportRequest) XXX_Size() int {
	return m.Size()
}
func (m *SupportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SupportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SupportRequest proto.InternalMessageInfo

func (m *SupportRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SupportRequest) GetUserName() string {
	if m != nil {
		return m.UserName
	}
	return ""
}

func (m *SupportRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *SupportRequest) GetEmailAddress() string {
	if m != nil {
		return m.EmailAddress
	}
	return ""
}

func (m *SupportRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *SupportRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SupportRequest) GetDeploymentId() string {
	if m != nil {
		return m.DeploymentId
	}
	return ""
}

func (m *SupportRequest) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *SupportRequest) GetSeverity() string {
	if m != nil {
		return m.Severity
	}
	return ""
}

// Plan represents a specific support plan such as Bronze, Silver or Gold.
type Plan struct {
	// System identifier of the plan.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the plan.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// If set, this plan is the default support plan.
	IsDefault bool `protobuf:"varint,3,opt,name=is_default,json=isDefault,proto3" json:"is_default,omitempty"`
	// Human readable description of the plan
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// If set, this plan is shown, but not selectable.
	IsUnavailable bool `protobuf:"varint,5,opt,name=is_unavailable,json=isUnavailable,proto3" json:"is_unavailable,omitempty"`
	// SLA times to first response for various situations.
	// When this plan is unavailable, this field is optional.
	FirstResponseTimes *ResponseTimes `protobuf:"bytes,6,opt,name=first_response_times,json=firstResponseTimes,proto3" json:"first_response_times,omitempty"`
	// Support hours applicable to the SLA.
	// Possible values are "business" and "24x7".
	SupportHours         string   `protobuf:"bytes,7,opt,name=support_hours,json=supportHours,proto3" json:"support_hours,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Plan) Reset()         { *m = Plan{} }
func (m *Plan) String() string { return proto.CompactTextString(m) }
func (*Plan) ProtoMessage()    {}
func (*Plan) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{1}
}
func (m *Plan) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Plan) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Plan.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Plan) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Plan.Merge(m, src)
}
func (m *Plan) XXX_Size() int {
	return m.Size()
}
func (m *Plan) XXX_DiscardUnknown() {
	xxx_messageInfo_Plan.DiscardUnknown(m)
}

var xxx_messageInfo_Plan proto.InternalMessageInfo

func (m *Plan) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Plan) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Plan) GetIsDefault() bool {
	if m != nil {
		return m.IsDefault
	}
	return false
}

func (m *Plan) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Plan) GetIsUnavailable() bool {
	if m != nil {
		return m.IsUnavailable
	}
	return false
}

func (m *Plan) GetFirstResponseTimes() *ResponseTimes {
	if m != nil {
		return m.FirstResponseTimes
	}
	return nil
}

func (m *Plan) GetSupportHours() string {
	if m != nil {
		return m.SupportHours
	}
	return ""
}

// Response for various categories on situations.
// All values are in minutes.
// A value of 0 means "best effort".
type ResponseTimes struct {
	// Response time for operation-impeding Error in a production environment.
	Critical int32 `protobuf:"varint,1,opt,name=critical,proto3" json:"critical,omitempty"`
	// Response time for operation-limiting error.
	High int32 `protobuf:"varint,2,opt,name=high,proto3" json:"high,omitempty"`
	// Response time for minor error.
	Normal int32 `protobuf:"varint,3,opt,name=normal,proto3" json:"normal,omitempty"`
	// Response time for usage question.
	Low                  int32    `protobuf:"varint,4,opt,name=low,proto3" json:"low,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResponseTimes) Reset()         { *m = ResponseTimes{} }
func (m *ResponseTimes) String() string { return proto.CompactTextString(m) }
func (*ResponseTimes) ProtoMessage()    {}
func (*ResponseTimes) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{2}
}
func (m *ResponseTimes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ResponseTimes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ResponseTimes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ResponseTimes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseTimes.Merge(m, src)
}
func (m *ResponseTimes) XXX_Size() int {
	return m.Size()
}
func (m *ResponseTimes) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseTimes.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseTimes proto.InternalMessageInfo

func (m *ResponseTimes) GetCritical() int32 {
	if m != nil {
		return m.Critical
	}
	return 0
}

func (m *ResponseTimes) GetHigh() int32 {
	if m != nil {
		return m.High
	}
	return 0
}

func (m *ResponseTimes) GetNormal() int32 {
	if m != nil {
		return m.Normal
	}
	return 0
}

func (m *ResponseTimes) GetLow() int32 {
	if m != nil {
		return m.Low
	}
	return 0
}

// List of plans.
type PlanList struct {
	Items                []*Plan  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PlanList) Reset()         { *m = PlanList{} }
func (m *PlanList) String() string { return proto.CompactTextString(m) }
func (*PlanList) ProtoMessage()    {}
func (*PlanList) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{3}
}
func (m *PlanList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PlanList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PlanList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PlanList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PlanList.Merge(m, src)
}
func (m *PlanList) XXX_Size() int {
	return m.Size()
}
func (m *PlanList) XXX_DiscardUnknown() {
	xxx_messageInfo_PlanList.DiscardUnknown(m)
}

var xxx_messageInfo_PlanList proto.InternalMessageInfo

func (m *PlanList) GetItems() []*Plan {
	if m != nil {
		return m.Items
	}
	return nil
}

// Arguments for a ListPlans request
type ListPlansRequest struct {
	// Common list options
	Options *v1.ListOptions `protobuf:"bytes,1,opt,name=options,proto3" json:"options,omitempty"`
	// If set, list plans as they are available for the organization identified by this ID.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// If set, list plans as they are available for the deployment model identified by this field.
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListPlansRequest) Reset()         { *m = ListPlansRequest{} }
func (m *ListPlansRequest) String() string { return proto.CompactTextString(m) }
func (*ListPlansRequest) ProtoMessage()    {}
func (*ListPlansRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{4}
}
func (m *ListPlansRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ListPlansRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ListPlansRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ListPlansRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListPlansRequest.Merge(m, src)
}
func (m *ListPlansRequest) XXX_Size() int {
	return m.Size()
}
func (m *ListPlansRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListPlansRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListPlansRequest proto.InternalMessageInfo

func (m *ListPlansRequest) GetOptions() *v1.ListOptions {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *ListPlansRequest) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *ListPlansRequest) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// FaqGroup contains groups of faq entries
type FaqGroup struct {
	// ID of the FAQ Group
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Name of the FAQ Group
	Name                 string   `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaqGroup) Reset()         { *m = FaqGroup{} }
func (m *FaqGroup) String() string { return proto.CompactTextString(m) }
func (*FaqGroup) ProtoMessage()    {}
func (*FaqGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{5}
}
func (m *FaqGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FaqGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FaqGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FaqGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaqGroup.Merge(m, src)
}
func (m *FaqGroup) XXX_Size() int {
	return m.Size()
}
func (m *FaqGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_FaqGroup.DiscardUnknown(m)
}

var xxx_messageInfo_FaqGroup proto.InternalMessageInfo

func (m *FaqGroup) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *FaqGroup) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// List of faq groups.
type FaqGroupList struct {
	Items                []*FaqGroup `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *FaqGroupList) Reset()         { *m = FaqGroupList{} }
func (m *FaqGroupList) String() string { return proto.CompactTextString(m) }
func (*FaqGroupList) ProtoMessage()    {}
func (*FaqGroupList) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{6}
}
func (m *FaqGroupList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FaqGroupList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FaqGroupList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FaqGroupList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaqGroupList.Merge(m, src)
}
func (m *FaqGroupList) XXX_Size() int {
	return m.Size()
}
func (m *FaqGroupList) XXX_DiscardUnknown() {
	xxx_messageInfo_FaqGroupList.DiscardUnknown(m)
}

var xxx_messageInfo_FaqGroupList proto.InternalMessageInfo

func (m *FaqGroupList) GetItems() []*FaqGroup {
	if m != nil {
		return m.Items
	}
	return nil
}

// FaqGroupEntry contains entries for a group
type FaqGroupEntry struct {
	// The question of this entry
	Question string `protobuf:"bytes,1,opt,name=question,proto3" json:"question,omitempty"`
	// The answer to the question in this entry
	Answer               string   `protobuf:"bytes,2,opt,name=answer,proto3" json:"answer,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaqGroupEntry) Reset()         { *m = FaqGroupEntry{} }
func (m *FaqGroupEntry) String() string { return proto.CompactTextString(m) }
func (*FaqGroupEntry) ProtoMessage()    {}
func (*FaqGroupEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{7}
}
func (m *FaqGroupEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FaqGroupEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FaqGroupEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FaqGroupEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaqGroupEntry.Merge(m, src)
}
func (m *FaqGroupEntry) XXX_Size() int {
	return m.Size()
}
func (m *FaqGroupEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_FaqGroupEntry.DiscardUnknown(m)
}

var xxx_messageInfo_FaqGroupEntry proto.InternalMessageInfo

func (m *FaqGroupEntry) GetQuestion() string {
	if m != nil {
		return m.Question
	}
	return ""
}

func (m *FaqGroupEntry) GetAnswer() string {
	if m != nil {
		return m.Answer
	}
	return ""
}

// List of faq group entries.
type FaqGroupEntryList struct {
	Items                []*FaqGroupEntry `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *FaqGroupEntryList) Reset()         { *m = FaqGroupEntryList{} }
func (m *FaqGroupEntryList) String() string { return proto.CompactTextString(m) }
func (*FaqGroupEntryList) ProtoMessage()    {}
func (*FaqGroupEntryList) Descriptor() ([]byte, []int) {
	return fileDescriptor_61fc54fa3a6fab31, []int{8}
}
func (m *FaqGroupEntryList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *FaqGroupEntryList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_FaqGroupEntryList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *FaqGroupEntryList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaqGroupEntryList.Merge(m, src)
}
func (m *FaqGroupEntryList) XXX_Size() int {
	return m.Size()
}
func (m *FaqGroupEntryList) XXX_DiscardUnknown() {
	xxx_messageInfo_FaqGroupEntryList.DiscardUnknown(m)
}

var xxx_messageInfo_FaqGroupEntryList proto.InternalMessageInfo

func (m *FaqGroupEntryList) GetItems() []*FaqGroupEntry {
	if m != nil {
		return m.Items
	}
	return nil
}

func init() {
	proto.RegisterType((*SupportRequest)(nil), "arangodb.cloud.support.v1.SupportRequest")
	proto.RegisterType((*Plan)(nil), "arangodb.cloud.support.v1.Plan")
	proto.RegisterType((*ResponseTimes)(nil), "arangodb.cloud.support.v1.ResponseTimes")
	proto.RegisterType((*PlanList)(nil), "arangodb.cloud.support.v1.PlanList")
	proto.RegisterType((*ListPlansRequest)(nil), "arangodb.cloud.support.v1.ListPlansRequest")
	proto.RegisterType((*FaqGroup)(nil), "arangodb.cloud.support.v1.FaqGroup")
	proto.RegisterType((*FaqGroupList)(nil), "arangodb.cloud.support.v1.FaqGroupList")
	proto.RegisterType((*FaqGroupEntry)(nil), "arangodb.cloud.support.v1.FaqGroupEntry")
	proto.RegisterType((*FaqGroupEntryList)(nil), "arangodb.cloud.support.v1.FaqGroupEntryList")
}

func init() { proto.RegisterFile("support.proto", fileDescriptor_61fc54fa3a6fab31) }

var fileDescriptor_61fc54fa3a6fab31 = []byte{
	// 907 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0x67, 0x9d, 0xd8, 0xb1, 0x5f, 0xea, 0x50, 0x86, 0xd0, 0xba, 0x9b, 0xe6, 0x4f, 0xd7, 0x54,
	0x0d, 0x2d, 0xb5, 0x49, 0x10, 0x48, 0x20, 0x01, 0x0a, 0x6d, 0x09, 0x96, 0x10, 0x54, 0x1b, 0xe0,
	0xd0, 0x8b, 0x35, 0xf1, 0xbe, 0x6c, 0x06, 0xed, 0xee, 0x6c, 0x66, 0x66, 0xdd, 0x86, 0xd2, 0x4b,
	0x3f, 0x02, 0xbd, 0xf4, 0xcc, 0x81, 0x0f, 0xc2, 0x89, 0x23, 0x12, 0x5f, 0x00, 0x05, 0x3e, 0x08,
	0x9a, 0xb7, 0xbb, 0xa9, 0xed, 0xc6, 0x89, 0x6f, 0xf3, 0x7e, 0xf3, 0x7b, 0xef, 0xfd, 0xe6, 0x37,
	0x6f, 0xd6, 0x86, 0xa6, 0xce, 0xd2, 0x54, 0x2a, 0xd3, 0x49, 0x95, 0x34, 0x92, 0x5d, 0xe3, 0x8a,
	0x27, 0xa1, 0x0c, 0xf6, 0x3b, 0x83, 0x48, 0x66, 0x41, 0xa7, 0xdc, 0x1d, 0x6e, 0xb9, 0x57, 0x06,
	0x32, 0x8e, 0x65, 0xd2, 0x1d, 0x6e, 0x75, 0xf3, 0x55, 0x9e, 0xe2, 0x5e, 0x0f, 0xa5, 0x0c, 0x23,
	0xec, 0xf2, 0x54, 0x74, 0x79, 0x92, 0x48, 0xc3, 0x8d, 0x90, 0x89, 0xce, 0x77, 0xbd, 0xdf, 0x2b,
	0xb0, 0xb4, 0x97, 0x17, 0xf1, 0xf1, 0x28, 0x43, 0x6d, 0xd8, 0x12, 0x54, 0x44, 0xd0, 0x72, 0x36,
	0x9c, 0xcd, 0x86, 0x5f, 0x11, 0x01, 0x5b, 0x81, 0x46, 0xa6, 0x51, 0xf5, 0x13, 0x1e, 0x63, 0xab,
	0x42, 0x70, 0xdd, 0x02, 0xdf, 0xf2, 0x18, 0xd9, 0x55, 0x58, 0xa0, 0x4d, 0x11, 0xb4, 0xe6, 0x68,
	0xab, 0x66, 0xc3, 0x5e, 0xc0, 0xda, 0xd0, 0xc4, 0x98, 0x8b, 0xa8, 0xcf, 0x83, 0x40, 0xa1, 0xd6,
	0xad, 0x79, 0xda, 0xbe, 0x44, 0xe0, 0x4e, 0x8e, 0xb1, 0x5b, 0xf0, 0xa6, 0x54, 0x21, 0x4f, 0xc4,
	0xcf, 0x24, 0xca, 0x56, 0xa9, 0x12, 0x6d, 0x69, 0x14, 0xee, 0x05, 0x6c, 0x15, 0x20, 0x55, 0xf2,
	0x27, 0x1c, 0x18, 0xcb, 0xa9, 0x11, 0xa7, 0x51, 0x20, 0x79, 0xb3, 0x00, 0xd3, 0x48, 0x1e, 0xc7,
	0x98, 0x10, 0x63, 0x21, 0x6f, 0xf6, 0x0a, 0xec, 0x05, 0x6c, 0x03, 0x16, 0x03, 0xd4, 0x03, 0x25,
	0x52, 0x5b, 0xb4, 0x55, 0x27, 0xca, 0x28, 0xc4, 0x5c, 0xa8, 0x6b, 0x1c, 0xa2, 0x12, 0xe6, 0xb8,
	0xd5, 0xc8, 0x0f, 0x5a, 0xc6, 0xde, 0x8b, 0x0a, 0xcc, 0x3f, 0x8c, 0x78, 0xf2, 0x9a, 0x3d, 0x0c,
	0xe6, 0x47, 0x9c, 0xa1, 0xb5, 0x95, 0x2b, 0x74, 0x3f, 0xc0, 0x03, 0x9e, 0x45, 0x86, 0x8c, 0xa9,
	0xfb, 0x0d, 0xa1, 0xef, 0xe7, 0xc0, 0xa4, 0x92, 0xf9, 0xd7, 0x95, 0xdc, 0x84, 0x25, 0xa1, 0xfb,
	0x59, 0xc2, 0x87, 0x5c, 0x44, 0x7c, 0x3f, 0x42, 0xf2, 0xa5, 0xee, 0x37, 0x85, 0xfe, 0xe1, 0x15,
	0xc8, 0x1e, 0xc1, 0xf2, 0x81, 0x50, 0xda, 0xf4, 0x15, 0xea, 0x54, 0x26, 0x1a, 0xfb, 0x46, 0xc4,
	0xa8, 0xc9, 0xa0, 0xc5, 0xed, 0xcd, 0xce, 0xd4, 0x69, 0xe9, 0xf8, 0x45, 0xc2, 0xf7, 0x96, 0xef,
	0x33, 0xaa, 0x32, 0x86, 0x59, 0x4f, 0x0b, 0x7e, 0xff, 0x50, 0x66, 0x4a, 0x97, 0x9e, 0x16, 0xe0,
	0xd7, 0x16, 0xf3, 0x04, 0x34, 0xc7, 0xb3, 0x5c, 0xa8, 0x0f, 0x94, 0x30, 0x62, 0xc0, 0x23, 0xf2,
	0xa8, 0xea, 0x9f, 0xc6, 0xd6, 0xa9, 0x43, 0x11, 0x1e, 0x92, 0x53, 0x55, 0x9f, 0xd6, 0xec, 0x0a,
	0xd4, 0x12, 0xa9, 0x62, 0x1e, 0x91, 0x4b, 0x55, 0xbf, 0x88, 0xd8, 0x65, 0x98, 0x8b, 0xe4, 0x63,
	0xb2, 0xa6, 0xea, 0xdb, 0xa5, 0xb7, 0x03, 0x75, 0xeb, 0xff, 0x37, 0x42, 0x1b, 0xf6, 0x11, 0x54,
	0x85, 0xc1, 0x58, 0xb7, 0x9c, 0x8d, 0xb9, 0xcd, 0xc5, 0xed, 0xf5, 0x73, 0x0e, 0x6a, 0x73, 0xfc,
	0x9c, 0xed, 0xfd, 0xea, 0xc0, 0x65, 0x9b, 0x6f, 0x31, 0x5d, 0x8e, 0xfb, 0x17, 0xb0, 0x20, 0xc9,
	0x74, 0x4d, 0x82, 0x17, 0xb7, 0x6f, 0x4e, 0x56, 0x2b, 0x9e, 0xd3, 0x70, 0xab, 0x63, 0x93, 0xbf,
	0xcb, 0xc9, 0x7e, 0x99, 0x75, 0xd6, 0x10, 0x57, 0xce, 0x1c, 0xe2, 0x65, 0xa8, 0xc6, 0x32, 0xc0,
	0xa8, 0x78, 0x29, 0x79, 0xe0, 0x75, 0xa0, 0xfe, 0x15, 0x3f, 0xda, 0x55, 0x32, 0x4b, 0x67, 0x99,
	0x2d, 0xaf, 0x07, 0x97, 0x4a, 0x3e, 0x79, 0xf1, 0xc9, 0xb8, 0x17, 0xed, 0x73, 0xbc, 0x28, 0xf3,
	0x4a, 0x3f, 0xee, 0x41, 0xb3, 0x84, 0x1e, 0x24, 0x46, 0x1d, 0xdb, 0xdb, 0x23, 0x53, 0xec, 0x54,
	0xe6, 0x2a, 0x4e, 0x63, 0x7b, 0x53, 0x3c, 0xd1, 0x8f, 0x51, 0x15, 0x6a, 0x8a, 0xc8, 0xdb, 0x83,
	0xb7, 0xc6, 0x8a, 0x90, 0xa8, 0xcf, 0xc7, 0x45, 0x6d, 0xce, 0x20, 0x8a, 0x92, 0x0b, 0x65, 0xdb,
	0x7f, 0xd4, 0x4e, 0x3f, 0x4b, 0x7b, 0xa8, 0x86, 0x62, 0x80, 0xec, 0x09, 0x34, 0x77, 0xd1, 0xec,
	0x3c, 0xec, 0xfd, 0x88, 0x4a, 0x5b, 0x41, 0xeb, 0xd3, 0xef, 0xe9, 0x41, 0x9c, 0x9a, 0x63, 0xf7,
	0xc6, 0x74, 0x42, 0x51, 0xc3, 0x6b, 0x3f, 0xff, 0xfb, 0xbf, 0x17, 0x95, 0x55, 0xb6, 0x42, 0x9f,
	0xc7, 0x42, 0x95, 0xfd, 0x84, 0xf2, 0x54, 0xdc, 0x1d, 0x16, 0x8d, 0x7e, 0x81, 0xc6, 0xe9, 0xd4,
	0xb0, 0x3b, 0xe7, 0x1c, 0x65, 0x72, 0xb6, 0xdc, 0xf6, 0x05, 0x83, 0x69, 0x13, 0xbc, 0x55, 0xd2,
	0x70, 0x95, 0xbd, 0x33, 0xa9, 0x21, 0xa5, 0x86, 0x1a, 0x16, 0x76, 0x91, 0xca, 0xb2, 0xf6, 0xf4,
	0x03, 0xf5, 0xee, 0x17, 0x73, 0xe9, 0x5e, 0xf4, 0x18, 0x3c, 0x8f, 0xfa, 0x5d, 0x67, 0xee, 0x99,
	0xfd, 0xba, 0x4f, 0x45, 0xf0, 0x8c, 0x3d, 0x77, 0xa0, 0x69, 0xc5, 0x95, 0x97, 0xa3, 0xd9, 0x6c,
	0xaf, 0xc2, 0xbd, 0x35, 0xc3, 0x4d, 0xd3, 0xa9, 0x6f, 0x90, 0x8a, 0x15, 0x76, 0x6d, 0x52, 0xc5,
	0x01, 0x3f, 0x0a, 0xf3, 0x96, 0xbf, 0x39, 0xf0, 0xf6, 0xa8, 0x08, 0x3b, 0x21, 0x02, 0x67, 0x96,
	0xf2, 0xfe, 0xac, 0x43, 0x47, 0x7a, 0x3e, 0x26, 0x3d, 0x1f, 0xb0, 0xce, 0x54, 0x3d, 0xdd, 0xa7,
	0x03, 0x99, 0x18, 0x7c, 0x62, 0x7f, 0x60, 0x9e, 0x75, 0xb1, 0x10, 0xf3, 0xd2, 0x81, 0xe5, 0x7b,
	0x0a, 0xb9, 0xc1, 0x89, 0x9f, 0xd1, 0xf7, 0xce, 0x69, 0x3f, 0x4e, 0x75, 0x67, 0xa7, 0x7a, 0xb7,
	0x49, 0xe6, 0xbb, 0xde, 0xfa, 0xa4, 0xcc, 0x62, 0xa9, 0x72, 0x9e, 0xfe, 0xd4, 0xb9, 0xfd, 0xe5,
	0x67, 0x7f, 0x9e, 0xac, 0x39, 0x7f, 0x9d, 0xac, 0x39, 0xff, 0x9c, 0xac, 0x39, 0x2f, 0xff, 0x5d,
	0x7b, 0xe3, 0xd1, 0x9d, 0x50, 0x98, 0xc3, 0x6c, 0xdf, 0x1a, 0xd6, 0x2d, 0x5b, 0xde, 0x8d, 0x79,
	0xc2, 0x43, 0x0c, 0x6c, 0x41, 0x3d, 0x52, 0x71, 0xbf, 0x46, 0xff, 0x10, 0x3e, 0xfc, 0x3f, 0x00,
	0x00, 0xff, 0xff, 0x28, 0x22, 0xe4, 0x72, 0x83, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SupportServiceClient is the client API for SupportService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SupportServiceClient interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error)
	// Fetch all support plans that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListPlans(ctx context.Context, in *ListPlansRequest, opts ...grpc.CallOption) (*PlanList, error)
	// Fetch a support plan by its id.
	// Required permissions:
	// - None
	GetPlan(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Plan, error)
	// Fetch all FAQ groups.
	// Required permissions:
	// - None
	ListFaqGroups(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*FaqGroupList, error)
	// Fetch all FAQ group entries of the FAQ group identified by the given context ID.
	// Required permissions:
	// - None
	ListFaqGroupEntries(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*FaqGroupEntryList, error)
	// Submit a support request.
	// Required permissions:
	// - resourcemanager.organization.get (if organization id is set)
	// - resourcemanager.project.get (if project id is set)
	// - data.deployment.get (if deployment id is set)
	// - None (if no ids are set)
	CreateSupportRequest(ctx context.Context, in *SupportRequest, opts ...grpc.CallOption) (*SupportRequest, error)
}

type supportServiceClient struct {
	cc *grpc.ClientConn
}

func NewSupportServiceClient(cc *grpc.ClientConn) SupportServiceClient {
	return &supportServiceClient{cc}
}

func (c *supportServiceClient) GetAPIVersion(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Version, error) {
	out := new(v1.Version)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.support.v1.SupportService/GetAPIVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *supportServiceClient) ListPlans(ctx context.Context, in *ListPlansRequest, opts ...grpc.CallOption) (*PlanList, error) {
	out := new(PlanList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.support.v1.SupportService/ListPlans", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *supportServiceClient) GetPlan(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Plan, error) {
	out := new(Plan)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.support.v1.SupportService/GetPlan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *supportServiceClient) ListFaqGroups(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*FaqGroupList, error) {
	out := new(FaqGroupList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.support.v1.SupportService/ListFaqGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *supportServiceClient) ListFaqGroupEntries(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*FaqGroupEntryList, error) {
	out := new(FaqGroupEntryList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.support.v1.SupportService/ListFaqGroupEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *supportServiceClient) CreateSupportRequest(ctx context.Context, in *SupportRequest, opts ...grpc.CallOption) (*SupportRequest, error) {
	out := new(SupportRequest)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.support.v1.SupportService/CreateSupportRequest", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SupportServiceServer is the server API for SupportService service.
type SupportServiceServer interface {
	// Get the current API version of this service.
	// Required permissions:
	// - None
	GetAPIVersion(context.Context, *v1.Empty) (*v1.Version, error)
	// Fetch all support plans that are supported by the ArangoDB cloud.
	// Required permissions:
	// - None
	ListPlans(context.Context, *ListPlansRequest) (*PlanList, error)
	// Fetch a support plan by its id.
	// Required permissions:
	// - None
	GetPlan(context.Context, *v1.IDOptions) (*Plan, error)
	// Fetch all FAQ groups.
	// Required permissions:
	// - None
	ListFaqGroups(context.Context, *v1.ListOptions) (*FaqGroupList, error)
	// Fetch all FAQ group entries of the FAQ group identified by the given context ID.
	// Required permissions:
	// - None
	ListFaqGroupEntries(context.Context, *v1.ListOptions) (*FaqGroupEntryList, error)
	// Submit a support request.
	// Required permissions:
	// - resourcemanager.organization.get (if organization id is set)
	// - resourcemanager.project.get (if project id is set)
	// - data.deployment.get (if deployment id is set)
	// - None (if no ids are set)
	CreateSupportRequest(context.Context, *SupportRequest) (*SupportRequest, error)
}

// UnimplementedSupportServiceServer can be embedded to have forward compatible implementations.
type UnimplementedSupportServiceServer struct {
}

func (*UnimplementedSupportServiceServer) GetAPIVersion(ctx context.Context, req *v1.Empty) (*v1.Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAPIVersion not implemented")
}
func (*UnimplementedSupportServiceServer) ListPlans(ctx context.Context, req *ListPlansRequest) (*PlanList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPlans not implemented")
}
func (*UnimplementedSupportServiceServer) GetPlan(ctx context.Context, req *v1.IDOptions) (*Plan, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlan not implemented")
}
func (*UnimplementedSupportServiceServer) ListFaqGroups(ctx context.Context, req *v1.ListOptions) (*FaqGroupList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFaqGroups not implemented")
}
func (*UnimplementedSupportServiceServer) ListFaqGroupEntries(ctx context.Context, req *v1.ListOptions) (*FaqGroupEntryList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFaqGroupEntries not implemented")
}
func (*UnimplementedSupportServiceServer) CreateSupportRequest(ctx context.Context, req *SupportRequest) (*SupportRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSupportRequest not implemented")
}

func RegisterSupportServiceServer(s *grpc.Server, srv SupportServiceServer) {
	s.RegisterService(&_SupportService_serviceDesc, srv)
}

func _SupportService_GetAPIVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SupportServiceServer).GetAPIVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.support.v1.SupportService/GetAPIVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SupportServiceServer).GetAPIVersion(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SupportService_ListPlans_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPlansRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SupportServiceServer).ListPlans(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.support.v1.SupportService/ListPlans",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SupportServiceServer).ListPlans(ctx, req.(*ListPlansRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SupportService_GetPlan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SupportServiceServer).GetPlan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.support.v1.SupportService/GetPlan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SupportServiceServer).GetPlan(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SupportService_ListFaqGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SupportServiceServer).ListFaqGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.support.v1.SupportService/ListFaqGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SupportServiceServer).ListFaqGroups(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SupportService_ListFaqGroupEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SupportServiceServer).ListFaqGroupEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.support.v1.SupportService/ListFaqGroupEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SupportServiceServer).ListFaqGroupEntries(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _SupportService_CreateSupportRequest_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SupportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SupportServiceServer).CreateSupportRequest(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.support.v1.SupportService/CreateSupportRequest",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SupportServiceServer).CreateSupportRequest(ctx, req.(*SupportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SupportService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.support.v1.SupportService",
	HandlerType: (*SupportServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAPIVersion",
			Handler:    _SupportService_GetAPIVersion_Handler,
		},
		{
			MethodName: "ListPlans",
			Handler:    _SupportService_ListPlans_Handler,
		},
		{
			MethodName: "GetPlan",
			Handler:    _SupportService_GetPlan_Handler,
		},
		{
			MethodName: "ListFaqGroups",
			Handler:    _SupportService_ListFaqGroups_Handler,
		},
		{
			MethodName: "ListFaqGroupEntries",
			Handler:    _SupportService_ListFaqGroupEntries_Handler,
		},
		{
			MethodName: "CreateSupportRequest",
			Handler:    _SupportService_CreateSupportRequest_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "support.proto",
}

func (m *SupportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SupportRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SupportRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Severity) > 0 {
		i -= len(m.Severity)
		copy(dAtA[i:], m.Severity)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Severity)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.DeploymentId) > 0 {
		i -= len(m.DeploymentId)
		copy(dAtA[i:], m.DeploymentId)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.DeploymentId)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.ProjectId) > 0 {
		i -= len(m.ProjectId)
		copy(dAtA[i:], m.ProjectId)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.ProjectId)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.EmailAddress) > 0 {
		i -= len(m.EmailAddress)
		copy(dAtA[i:], m.EmailAddress)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.EmailAddress)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.UserId) > 0 {
		i -= len(m.UserId)
		copy(dAtA[i:], m.UserId)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.UserId)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.UserName) > 0 {
		i -= len(m.UserName)
		copy(dAtA[i:], m.UserName)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.UserName)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Plan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Plan) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Plan) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.SupportHours) > 0 {
		i -= len(m.SupportHours)
		copy(dAtA[i:], m.SupportHours)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.SupportHours)))
		i--
		dAtA[i] = 0x3a
	}
	if m.FirstResponseTimes != nil {
		{
			size, err := m.FirstResponseTimes.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSupport(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	if m.IsUnavailable {
		i--
		if m.IsUnavailable {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x28
	}
	if len(m.Description) > 0 {
		i -= len(m.Description)
		copy(dAtA[i:], m.Description)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Description)))
		i--
		dAtA[i] = 0x22
	}
	if m.IsDefault {
		i--
		if m.IsDefault {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ResponseTimes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseTimes) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ResponseTimes) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Low != 0 {
		i = encodeVarintSupport(dAtA, i, uint64(m.Low))
		i--
		dAtA[i] = 0x20
	}
	if m.Normal != 0 {
		i = encodeVarintSupport(dAtA, i, uint64(m.Normal))
		i--
		dAtA[i] = 0x18
	}
	if m.High != 0 {
		i = encodeVarintSupport(dAtA, i, uint64(m.High))
		i--
		dAtA[i] = 0x10
	}
	if m.Critical != 0 {
		i = encodeVarintSupport(dAtA, i, uint64(m.Critical))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PlanList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PlanList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PlanList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSupport(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ListPlansRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ListPlansRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ListPlansRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Model) > 0 {
		i -= len(m.Model)
		copy(dAtA[i:], m.Model)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Model)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.OrganizationId) > 0 {
		i -= len(m.OrganizationId)
		copy(dAtA[i:], m.OrganizationId)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.OrganizationId)))
		i--
		dAtA[i] = 0x12
	}
	if m.Options != nil {
		{
			size, err := m.Options.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSupport(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FaqGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FaqGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FaqGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FaqGroupList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FaqGroupList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FaqGroupList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSupport(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *FaqGroupEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FaqGroupEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FaqGroupEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Answer) > 0 {
		i -= len(m.Answer)
		copy(dAtA[i:], m.Answer)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Answer)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Question) > 0 {
		i -= len(m.Question)
		copy(dAtA[i:], m.Question)
		i = encodeVarintSupport(dAtA, i, uint64(len(m.Question)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *FaqGroupEntryList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FaqGroupEntryList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *FaqGroupEntryList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintSupport(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintSupport(dAtA []byte, offset int, v uint64) int {
	offset -= sovSupport(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *SupportRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.UserName)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.EmailAddress)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.ProjectId)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.DeploymentId)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.Severity)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Plan) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.IsDefault {
		n += 2
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.IsUnavailable {
		n += 2
	}
	if m.FirstResponseTimes != nil {
		l = m.FirstResponseTimes.Size()
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.SupportHours)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ResponseTimes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Critical != 0 {
		n += 1 + sovSupport(uint64(m.Critical))
	}
	if m.High != 0 {
		n += 1 + sovSupport(uint64(m.High))
	}
	if m.Normal != 0 {
		n += 1 + sovSupport(uint64(m.Normal))
	}
	if m.Low != 0 {
		n += 1 + sovSupport(uint64(m.Low))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PlanList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSupport(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ListPlansRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Options != nil {
		l = m.Options.Size()
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.Model)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FaqGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FaqGroupList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSupport(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FaqGroupEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Question)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	l = len(m.Answer)
	if l > 0 {
		n += 1 + l + sovSupport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *FaqGroupEntryList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovSupport(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovSupport(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSupport(x uint64) (n int) {
	return sovSupport(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *SupportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SupportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SupportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EmailAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EmailAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProjectId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProjectId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeploymentId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeploymentId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Severity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Plan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Plan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Plan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDefault", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDefault = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsUnavailable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsUnavailable = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstResponseTimes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.FirstResponseTimes == nil {
				m.FirstResponseTimes = &ResponseTimes{}
			}
			if err := m.FirstResponseTimes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SupportHours", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SupportHours = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseTimes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseTimes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseTimes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Critical", wireType)
			}
			m.Critical = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Critical |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field High", wireType)
			}
			m.High = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.High |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Normal", wireType)
			}
			m.Normal = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Normal |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Low", wireType)
			}
			m.Low = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Low |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PlanList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PlanList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PlanList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Plan{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ListPlansRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ListPlansRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ListPlansRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Options", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Options == nil {
				m.Options = &v1.ListOptions{}
			}
			if err := m.Options.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Model", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Model = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FaqGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FaqGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FaqGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FaqGroupList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FaqGroupList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FaqGroupList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &FaqGroup{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FaqGroupEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FaqGroupEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FaqGroupEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Question", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Question = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Answer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Answer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FaqGroupEntryList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FaqGroupEntryList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FaqGroupEntryList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSupport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSupport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &FaqGroupEntry{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSupport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthSupport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSupport(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSupport
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSupport
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSupport
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthSupport
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowSupport
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipSupport(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthSupport
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthSupport = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSupport   = fmt.Errorf("proto: integer overflow")
)
