// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: iam.proto

package v1

import (
	context "context"
	fmt "fmt"
	v1 "github.com/arangodb-managed/apis/common/v1"
	types "github.com/gogo/protobuf/types"
	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// User represents an actual person.
type User struct {
	// Identifier of the user.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Primary email address of the user.
	// All emails send to this user will use this address.
	// This is a read-only value.
	Email string `protobuf:"bytes,2,opt,name=email,proto3" json:"email,omitempty"`
	// Name of the user.
	// This may be empty if not filled out by the user.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Given name of the user.
	// This may be empty if not filled out by the user.
	GivenName string `protobuf:"bytes,4,opt,name=given_name,json=givenName,proto3" json:"given_name,omitempty"`
	// Family name of the user.
	// This may be empty if not filled out by the user.
	FamilyName string `protobuf:"bytes,5,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// The creation timestamp of the user.
	// This is a read-only value.
	CreatedAt *types.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Additional email addresses of the user.
	// This will be filled in when the authentication provided
	// knows multiple email addresses for the user.
	// This is a read-only value.
	AdditionalEmails []string `protobuf:"bytes,7,rep,name=additional_emails,json=additionalEmails,proto3" json:"additional_emails,omitempty"`
	// Mobile phone number of the user.
	// This value must be unique globally.
	//
	// This field will not be filled, unless:
	// - The currently authenticated user is this user
	// - The currently authenticated user has `iam.user.get-personal-data` permission
	//   on the organization that user is a member of.
	//
	// This value can only be changed to a non-empty value.
	// If changed, the new number has to be verified again.
	MobilePhone string `protobuf:"bytes,8,opt,name=mobile_phone,json=mobilePhone,proto3" json:"mobile_phone,omitempty"`
	// Set when the mobile phone number has been successfully verified.
	// This is a read-only value.
	MobilePhoneVerified bool `protobuf:"varint,9,opt,name=mobile_phone_verified,json=mobilePhoneVerified,proto3" json:"mobile_phone_verified,omitempty"`
	// Company name of the user
	// This may be empty if not filled out by the user.
	CompanyName          string   `protobuf:"bytes,10,opt,name=company_name,json=companyName,proto3" json:"company_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *User) Reset()         { *m = User{} }
func (m *User) String() string { return proto.CompactTextString(m) }
func (*User) ProtoMessage()    {}
func (*User) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{0}
}
func (m *User) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *User) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_User.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *User) XXX_Merge(src proto.Message) {
	xxx_messageInfo_User.Merge(m, src)
}
func (m *User) XXX_Size() int {
	return m.Size()
}
func (m *User) XXX_DiscardUnknown() {
	xxx_messageInfo_User.DiscardUnknown(m)
}

var xxx_messageInfo_User proto.InternalMessageInfo

func (m *User) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *User) GetEmail() string {
	if m != nil {
		return m.Email
	}
	return ""
}

func (m *User) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *User) GetGivenName() string {
	if m != nil {
		return m.GivenName
	}
	return ""
}

func (m *User) GetFamilyName() string {
	if m != nil {
		return m.FamilyName
	}
	return ""
}

func (m *User) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *User) GetAdditionalEmails() []string {
	if m != nil {
		return m.AdditionalEmails
	}
	return nil
}

func (m *User) GetMobilePhone() string {
	if m != nil {
		return m.MobilePhone
	}
	return ""
}

func (m *User) GetMobilePhoneVerified() bool {
	if m != nil {
		return m.MobilePhoneVerified
	}
	return false
}

func (m *User) GetCompanyName() string {
	if m != nil {
		return m.CompanyName
	}
	return ""
}

// Request arguments for VerifyUserMobilePhone
type VerifyUserMobilePhoneRequest struct {
	// Code that was send to the mobile phone number.
	Code                 string   `protobuf:"bytes,1,opt,name=code,proto3" json:"code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *VerifyUserMobilePhoneRequest) Reset()         { *m = VerifyUserMobilePhoneRequest{} }
func (m *VerifyUserMobilePhoneRequest) String() string { return proto.CompactTextString(m) }
func (*VerifyUserMobilePhoneRequest) ProtoMessage()    {}
func (*VerifyUserMobilePhoneRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{1}
}
func (m *VerifyUserMobilePhoneRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *VerifyUserMobilePhoneRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_VerifyUserMobilePhoneRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *VerifyUserMobilePhoneRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VerifyUserMobilePhoneRequest.Merge(m, src)
}
func (m *VerifyUserMobilePhoneRequest) XXX_Size() int {
	return m.Size()
}
func (m *VerifyUserMobilePhoneRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_VerifyUserMobilePhoneRequest.DiscardUnknown(m)
}

var xxx_messageInfo_VerifyUserMobilePhoneRequest proto.InternalMessageInfo

func (m *VerifyUserMobilePhoneRequest) GetCode() string {
	if m != nil {
		return m.Code
	}
	return ""
}

// Group of user accounts.
type Group struct {
	// System identifier of the group.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the organization that owns this group.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the group
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the group
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The creation timestamp of the group
	CreatedAt *types.Timestamp `protobuf:"bytes,5,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the group
	DeletedAt *types.Timestamp `protobuf:"bytes,6,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this organization is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,7,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url string `protobuf:"bytes,8,opt,name=url,proto3" json:"url,omitempty"`
	// Set if this group is virtual and managed by the system.
	// This is a read-only value.
	IsVirtual            bool     `protobuf:"varint,9,opt,name=is_virtual,json=isVirtual,proto3" json:"is_virtual,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Group) Reset()         { *m = Group{} }
func (m *Group) String() string { return proto.CompactTextString(m) }
func (*Group) ProtoMessage()    {}
func (*Group) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{2}
}
func (m *Group) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Group) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Group.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Group) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Group.Merge(m, src)
}
func (m *Group) XXX_Size() int {
	return m.Size()
}
func (m *Group) XXX_DiscardUnknown() {
	xxx_messageInfo_Group.DiscardUnknown(m)
}

var xxx_messageInfo_Group proto.InternalMessageInfo

func (m *Group) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Group) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Group) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Group) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Group) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Group) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Group) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Group) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *Group) GetIsVirtual() bool {
	if m != nil {
		return m.IsVirtual
	}
	return false
}

// List of groups.
type GroupList struct {
	Items                []*Group `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupList) Reset()         { *m = GroupList{} }
func (m *GroupList) String() string { return proto.CompactTextString(m) }
func (*GroupList) ProtoMessage()    {}
func (*GroupList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{3}
}
func (m *GroupList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupList.Merge(m, src)
}
func (m *GroupList) XXX_Size() int {
	return m.Size()
}
func (m *GroupList) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupList.DiscardUnknown(m)
}

var xxx_messageInfo_GroupList proto.InternalMessageInfo

func (m *GroupList) GetItems() []*Group {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for IsMemberOfGroup.
type IsMemberOfGroupRequest struct {
	// Identifier of the user
	UserId string `protobuf:"bytes,1,opt,name=user_id,json=userId,proto3" json:"user_id,omitempty"`
	// Identifier of the group
	GroupId              string   `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsMemberOfGroupRequest) Reset()         { *m = IsMemberOfGroupRequest{} }
func (m *IsMemberOfGroupRequest) String() string { return proto.CompactTextString(m) }
func (*IsMemberOfGroupRequest) ProtoMessage()    {}
func (*IsMemberOfGroupRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{4}
}
func (m *IsMemberOfGroupRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *IsMemberOfGroupRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_IsMemberOfGroupRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *IsMemberOfGroupRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsMemberOfGroupRequest.Merge(m, src)
}
func (m *IsMemberOfGroupRequest) XXX_Size() int {
	return m.Size()
}
func (m *IsMemberOfGroupRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsMemberOfGroupRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsMemberOfGroupRequest proto.InternalMessageInfo

func (m *IsMemberOfGroupRequest) GetUserId() string {
	if m != nil {
		return m.UserId
	}
	return ""
}

func (m *IsMemberOfGroupRequest) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

// List of group members (user ID's)
type GroupMemberList struct {
	// List of ID's of users that are member of the group.
	Items                []string `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMemberList) Reset()         { *m = GroupMemberList{} }
func (m *GroupMemberList) String() string { return proto.CompactTextString(m) }
func (*GroupMemberList) ProtoMessage()    {}
func (*GroupMemberList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{5}
}
func (m *GroupMemberList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupMemberList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMemberList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupMemberList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMemberList.Merge(m, src)
}
func (m *GroupMemberList) XXX_Size() int {
	return m.Size()
}
func (m *GroupMemberList) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMemberList.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMemberList proto.InternalMessageInfo

func (m *GroupMemberList) GetItems() []string {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for Add/DeleteGroupMembers.
type GroupMembersRequest struct {
	// ID of the group to add/remove members to/from.
	GroupId string `protobuf:"bytes,1,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// ID's of users to add/remove to/from the group.
	UserIds              []string `protobuf:"bytes,2,rep,name=user_ids,json=userIds,proto3" json:"user_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupMembersRequest) Reset()         { *m = GroupMembersRequest{} }
func (m *GroupMembersRequest) String() string { return proto.CompactTextString(m) }
func (*GroupMembersRequest) ProtoMessage()    {}
func (*GroupMembersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{6}
}
func (m *GroupMembersRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GroupMembersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GroupMembersRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GroupMembersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupMembersRequest.Merge(m, src)
}
func (m *GroupMembersRequest) XXX_Size() int {
	return m.Size()
}
func (m *GroupMembersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupMembersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupMembersRequest proto.InternalMessageInfo

func (m *GroupMembersRequest) GetGroupId() string {
	if m != nil {
		return m.GroupId
	}
	return ""
}

func (m *GroupMembersRequest) GetUserIds() []string {
	if m != nil {
		return m.UserIds
	}
	return nil
}

// List of permissions.
type PermissionList struct {
	Items                []string `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PermissionList) Reset()         { *m = PermissionList{} }
func (m *PermissionList) String() string { return proto.CompactTextString(m) }
func (*PermissionList) ProtoMessage()    {}
func (*PermissionList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{7}
}
func (m *PermissionList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PermissionList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PermissionList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PermissionList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PermissionList.Merge(m, src)
}
func (m *PermissionList) XXX_Size() int {
	return m.Size()
}
func (m *PermissionList) XXX_DiscardUnknown() {
	xxx_messageInfo_PermissionList.DiscardUnknown(m)
}

var xxx_messageInfo_PermissionList proto.InternalMessageInfo

func (m *PermissionList) GetItems() []string {
	if m != nil {
		return m.Items
	}
	return nil
}

// Request arguments for HasPermissionsRequest.
type HasPermissionsRequest struct {
	// URL of the resource to query permissions for.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The list of permissions that are required.
	Permissions          []string `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HasPermissionsRequest) Reset()         { *m = HasPermissionsRequest{} }
func (m *HasPermissionsRequest) String() string { return proto.CompactTextString(m) }
func (*HasPermissionsRequest) ProtoMessage()    {}
func (*HasPermissionsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{8}
}
func (m *HasPermissionsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HasPermissionsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HasPermissionsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HasPermissionsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HasPermissionsRequest.Merge(m, src)
}
func (m *HasPermissionsRequest) XXX_Size() int {
	return m.Size()
}
func (m *HasPermissionsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HasPermissionsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HasPermissionsRequest proto.InternalMessageInfo

func (m *HasPermissionsRequest) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *HasPermissionsRequest) GetPermissions() []string {
	if m != nil {
		return m.Permissions
	}
	return nil
}

// A role is a list of permissions.
// Roles can be bound to resources for members.
type Role struct {
	// System identifier of the role.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the organization that owns this role.
	// This value is undefined for predefined roles.
	OrganizationId string `protobuf:"bytes,2,opt,name=organization_id,json=organizationId,proto3" json:"organization_id,omitempty"`
	// Name of the role
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the role
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Permissions to grant when this role is bound.
	Permissions []string `protobuf:"bytes,5,rep,name=permissions,proto3" json:"permissions,omitempty"`
	// Set if this role is predefined.
	// This is a read-only value.
	IsPredefined bool `protobuf:"varint,6,opt,name=is_predefined,json=isPredefined,proto3" json:"is_predefined,omitempty"`
	// The creation timestamp of the role
	CreatedAt *types.Timestamp `protobuf:"bytes,7,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// The deletion timestamp of the role
	DeletedAt *types.Timestamp `protobuf:"bytes,8,opt,name=deleted_at,json=deletedAt,proto3" json:"deleted_at,omitempty"`
	// Set when this organization is deleted.
	// This is a read-only value.
	IsDeleted bool `protobuf:"varint,9,opt,name=is_deleted,json=isDeleted,proto3" json:"is_deleted,omitempty"`
	// URL of this resource
	// This is a read-only value and cannot be initialized.
	Url                  string   `protobuf:"bytes,10,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Role) Reset()         { *m = Role{} }
func (m *Role) String() string { return proto.CompactTextString(m) }
func (*Role) ProtoMessage()    {}
func (*Role) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{9}
}
func (m *Role) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Role) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Role.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Role) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Role.Merge(m, src)
}
func (m *Role) XXX_Size() int {
	return m.Size()
}
func (m *Role) XXX_DiscardUnknown() {
	xxx_messageInfo_Role.DiscardUnknown(m)
}

var xxx_messageInfo_Role proto.InternalMessageInfo

func (m *Role) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Role) GetOrganizationId() string {
	if m != nil {
		return m.OrganizationId
	}
	return ""
}

func (m *Role) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Role) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Role) GetPermissions() []string {
	if m != nil {
		return m.Permissions
	}
	return nil
}

func (m *Role) GetIsPredefined() bool {
	if m != nil {
		return m.IsPredefined
	}
	return false
}

func (m *Role) GetCreatedAt() *types.Timestamp {
	if m != nil {
		return m.CreatedAt
	}
	return nil
}

func (m *Role) GetDeletedAt() *types.Timestamp {
	if m != nil {
		return m.DeletedAt
	}
	return nil
}

func (m *Role) GetIsDeleted() bool {
	if m != nil {
		return m.IsDeleted
	}
	return false
}

func (m *Role) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// List of roles.
type RoleList struct {
	Items                []*Role  `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleList) Reset()         { *m = RoleList{} }
func (m *RoleList) String() string { return proto.CompactTextString(m) }
func (*RoleList) ProtoMessage()    {}
func (*RoleList) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{10}
}
func (m *RoleList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleList.Merge(m, src)
}
func (m *RoleList) XXX_Size() int {
	return m.Size()
}
func (m *RoleList) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleList.DiscardUnknown(m)
}

var xxx_messageInfo_RoleList proto.InternalMessageInfo

func (m *RoleList) GetItems() []*Role {
	if m != nil {
		return m.Items
	}
	return nil
}

// RoleBinding binds a Role to a member.
type RoleBinding struct {
	// System identifier of the role-binding.
	// This is a read-only value.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Identifier of the member to bind a role to.
	// Member ID is formatted as:
	// - user:<user_id>
	// - group:<group_id>
	MemberId string `protobuf:"bytes,2,opt,name=member_id,json=memberId,proto3" json:"member_id,omitempty"`
	// Identifier of the Role to grant to member
	RoleId               string   `protobuf:"bytes,3,opt,name=role_id,json=roleId,proto3" json:"role_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RoleBinding) Reset()         { *m = RoleBinding{} }
func (m *RoleBinding) String() string { return proto.CompactTextString(m) }
func (*RoleBinding) ProtoMessage()    {}
func (*RoleBinding) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{11}
}
func (m *RoleBinding) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleBinding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleBinding.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleBinding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleBinding.Merge(m, src)
}
func (m *RoleBinding) XXX_Size() int {
	return m.Size()
}
func (m *RoleBinding) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleBinding.DiscardUnknown(m)
}

var xxx_messageInfo_RoleBinding proto.InternalMessageInfo

func (m *RoleBinding) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *RoleBinding) GetMemberId() string {
	if m != nil {
		return m.MemberId
	}
	return ""
}

func (m *RoleBinding) GetRoleId() string {
	if m != nil {
		return m.RoleId
	}
	return ""
}

// Policy bindings members to roles for access to a resource.
type Policy struct {
	// URL of the resource to which this policy applies.
	ResourceUrl string `protobuf:"bytes,1,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// Role bindings to apply to the resource.
	Bindings             []*RoleBinding `protobuf:"bytes,2,rep,name=bindings,proto3" json:"bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Policy) Reset()         { *m = Policy{} }
func (m *Policy) String() string { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()    {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{12}
}
func (m *Policy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return m.Size()
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

func (m *Policy) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *Policy) GetBindings() []*RoleBinding {
	if m != nil {
		return m.Bindings
	}
	return nil
}

// Request arguments for Add/DeleteRoleBindings.
type RoleBindingsRequest struct {
	// URL of the resource to add/remove policy binding to/from.
	ResourceUrl string `protobuf:"bytes,1,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// Role bindings to add/remove to the policy.
	Bindings             []*RoleBinding `protobuf:"bytes,2,rep,name=bindings,proto3" json:"bindings,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *RoleBindingsRequest) Reset()         { *m = RoleBindingsRequest{} }
func (m *RoleBindingsRequest) String() string { return proto.CompactTextString(m) }
func (*RoleBindingsRequest) ProtoMessage()    {}
func (*RoleBindingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0a2c201915207782, []int{13}
}
func (m *RoleBindingsRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RoleBindingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RoleBindingsRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RoleBindingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RoleBindingsRequest.Merge(m, src)
}
func (m *RoleBindingsRequest) XXX_Size() int {
	return m.Size()
}
func (m *RoleBindingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RoleBindingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RoleBindingsRequest proto.InternalMessageInfo

func (m *RoleBindingsRequest) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *RoleBindingsRequest) GetBindings() []*RoleBinding {
	if m != nil {
		return m.Bindings
	}
	return nil
}

func init() {
	proto.RegisterType((*User)(nil), "arangodb.cloud.iam.v1.User")
	proto.RegisterType((*VerifyUserMobilePhoneRequest)(nil), "arangodb.cloud.iam.v1.VerifyUserMobilePhoneRequest")
	proto.RegisterType((*Group)(nil), "arangodb.cloud.iam.v1.Group")
	proto.RegisterType((*GroupList)(nil), "arangodb.cloud.iam.v1.GroupList")
	proto.RegisterType((*IsMemberOfGroupRequest)(nil), "arangodb.cloud.iam.v1.IsMemberOfGroupRequest")
	proto.RegisterType((*GroupMemberList)(nil), "arangodb.cloud.iam.v1.GroupMemberList")
	proto.RegisterType((*GroupMembersRequest)(nil), "arangodb.cloud.iam.v1.GroupMembersRequest")
	proto.RegisterType((*PermissionList)(nil), "arangodb.cloud.iam.v1.PermissionList")
	proto.RegisterType((*HasPermissionsRequest)(nil), "arangodb.cloud.iam.v1.HasPermissionsRequest")
	proto.RegisterType((*Role)(nil), "arangodb.cloud.iam.v1.Role")
	proto.RegisterType((*RoleList)(nil), "arangodb.cloud.iam.v1.RoleList")
	proto.RegisterType((*RoleBinding)(nil), "arangodb.cloud.iam.v1.RoleBinding")
	proto.RegisterType((*Policy)(nil), "arangodb.cloud.iam.v1.Policy")
	proto.RegisterType((*RoleBindingsRequest)(nil), "arangodb.cloud.iam.v1.RoleBindingsRequest")
}

func init() { proto.RegisterFile("iam.proto", fileDescriptor_0a2c201915207782) }

var fileDescriptor_0a2c201915207782 = []byte{
	// 1524 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x58, 0x5d, 0x6f, 0x1b, 0x55,
	0x13, 0x7e, 0xd7, 0xf9, 0xf2, 0x8e, 0xfb, 0x26, 0x7d, 0x4f, 0x9b, 0xc4, 0x4d, 0xf3, 0xe1, 0x6c,
	0x3f, 0x92, 0xd7, 0x34, 0x5e, 0xe2, 0x02, 0x55, 0x81, 0x82, 0x52, 0x5a, 0x05, 0x8b, 0x7e, 0x44,
	0x6e, 0x53, 0x09, 0x6e, 0xac, 0x8d, 0xf7, 0xd8, 0x3d, 0x74, 0xbf, 0xd8, 0xb3, 0xb6, 0x9a, 0x56,
	0xbd, 0x41, 0x08, 0x51, 0xc1, 0x05, 0xa2, 0x12, 0x42, 0x08, 0xf1, 0x4b, 0xf8, 0x01, 0x5c, 0x22,
	0xf1, 0x07, 0x20, 0xe5, 0x87, 0xa0, 0x33, 0x67, 0xd7, 0xde, 0xb8, 0xbb, 0x6b, 0xb7, 0xa5, 0xdc,
	0x79, 0x67, 0x66, 0xe7, 0x79, 0xce, 0xcc, 0x9c, 0x99, 0x59, 0x83, 0xca, 0x0c, 0xbb, 0xe2, 0xf9,
	0x6e, 0xe0, 0x92, 0x59, 0xc3, 0x37, 0x9c, 0xb6, 0x6b, 0xee, 0x55, 0x9a, 0x96, 0xdb, 0x31, 0x2b,
	0x42, 0xd3, 0xdd, 0x5c, 0x98, 0x6b, 0xba, 0xb6, 0xed, 0x3a, 0x7a, 0x77, 0x53, 0x97, 0xbf, 0xa4,
	0xf9, 0xc2, 0x3b, 0x6d, 0x16, 0xdc, 0xed, 0xec, 0x55, 0x9a, 0xae, 0xad, 0xb7, 0x5d, 0xcb, 0x70,
	0xda, 0x3a, 0x2a, 0xf6, 0x3a, 0x2d, 0xdd, 0x0b, 0xf6, 0x3d, 0xca, 0xf5, 0x80, 0xd9, 0x94, 0x07,
	0x86, 0xed, 0xf5, 0x7f, 0x85, 0x2f, 0x2f, 0xb6, 0x5d, 0xb7, 0x6d, 0x51, 0xdd, 0xf0, 0x98, 0x6e,
	0x38, 0x8e, 0x1b, 0x18, 0x01, 0x73, 0x1d, 0x2e, 0xb5, 0xda, 0x41, 0x0e, 0xc6, 0x77, 0x39, 0xf5,
	0xc9, 0x34, 0xe4, 0x98, 0x59, 0x54, 0x4a, 0xca, 0xba, 0x5a, 0xcf, 0x31, 0x93, 0x1c, 0x87, 0x09,
	0x6a, 0x1b, 0xcc, 0x2a, 0xe6, 0x50, 0x24, 0x1f, 0x08, 0x81, 0x71, 0xc7, 0xb0, 0x69, 0x71, 0x0c,
	0x85, 0xf8, 0x9b, 0x2c, 0x01, 0xb4, 0x59, 0x97, 0x3a, 0x0d, 0xd4, 0x8c, 0xa3, 0x46, 0x45, 0xc9,
	0x0d, 0xa1, 0x5e, 0x81, 0x42, 0xcb, 0xb0, 0x99, 0xb5, 0x2f, 0xf5, 0x13, 0xa8, 0x07, 0x29, 0x42,
	0x83, 0x8b, 0x00, 0x4d, 0x9f, 0x1a, 0x01, 0x35, 0x1b, 0x46, 0x50, 0x9c, 0x2c, 0x29, 0xeb, 0x85,
	0xea, 0x42, 0x45, 0xb2, 0xae, 0x44, 0xe7, 0xac, 0xdc, 0x8e, 0x8e, 0x55, 0x57, 0x43, 0xeb, 0xad,
	0x80, 0xbc, 0x06, 0xff, 0x33, 0x4c, 0x93, 0x89, 0x03, 0x19, 0x56, 0x03, 0x29, 0xf2, 0xe2, 0x54,
	0x69, 0x6c, 0x5d, 0xad, 0x1f, 0xed, 0x2b, 0xae, 0xa2, 0x9c, 0xac, 0xc2, 0x11, 0xdb, 0xdd, 0x63,
	0x16, 0x6d, 0x78, 0x77, 0x5d, 0x87, 0x16, 0xf3, 0xc8, 0xa4, 0x20, 0x65, 0x3b, 0x42, 0x44, 0xaa,
	0x30, 0x1b, 0x37, 0x69, 0x74, 0xa9, 0xcf, 0x5a, 0x8c, 0x9a, 0x45, 0xb5, 0xa4, 0xac, 0xe7, 0xeb,
	0xc7, 0x62, 0xb6, 0x77, 0x42, 0x95, 0x70, 0xdb, 0x74, 0x6d, 0xcf, 0x70, 0xc2, 0x03, 0x82, 0x74,
	0x1b, 0xca, 0xc4, 0x09, 0xb5, 0x2a, 0x2c, 0xa2, 0xf9, 0xbe, 0x88, 0xf4, 0xf5, 0xbe, 0x8f, 0x3a,
	0xfd, 0xac, 0x43, 0x79, 0x20, 0xa2, 0xda, 0x74, 0x4d, 0x1a, 0x46, 0x1f, 0x7f, 0x6b, 0xbf, 0xe4,
	0x60, 0x62, 0xdb, 0x77, 0x3b, 0xde, 0x33, 0x99, 0x59, 0x83, 0x19, 0xd7, 0x6f, 0x1b, 0x0e, 0x7b,
	0x80, 0x99, 0x6c, 0x30, 0x33, 0xcc, 0xd1, 0x74, 0x5c, 0x5c, 0x33, 0x13, 0x93, 0x55, 0x82, 0x82,
	0x49, 0x79, 0xd3, 0x67, 0x9e, 0x30, 0x0a, 0xb3, 0x15, 0x17, 0x0d, 0xa4, 0x63, 0xe2, 0x79, 0xd2,
	0x71, 0x11, 0xc0, 0xa4, 0x16, 0x1d, 0x3d, 0x93, 0xa1, 0xf5, 0x56, 0x20, 0x8a, 0x88, 0xf1, 0x46,
	0xf8, 0x5c, 0x9c, 0xc2, 0x70, 0xab, 0x8c, 0x5f, 0x91, 0x02, 0x72, 0x14, 0xc6, 0x3a, 0xbe, 0x15,
	0xa6, 0x4c, 0xfc, 0x0c, 0x5f, 0xe8, 0x32, 0x3f, 0xe8, 0x18, 0x56, 0x98, 0x1f, 0x95, 0xf1, 0x3b,
	0x52, 0xa0, 0xbd, 0x0f, 0x2a, 0x46, 0xef, 0x1a, 0xe3, 0x01, 0xa9, 0xc2, 0x04, 0x0b, 0xa8, 0xcd,
	0x8b, 0x4a, 0x69, 0x6c, 0xbd, 0x50, 0x5d, 0xac, 0x24, 0x5e, 0xbf, 0x0a, 0xbe, 0x50, 0x97, 0xa6,
	0xda, 0x35, 0x98, 0xab, 0xf1, 0xeb, 0xd4, 0xde, 0xa3, 0xfe, 0xcd, 0x96, 0xd4, 0x84, 0xd9, 0x9a,
	0x87, 0xa9, 0x0e, 0xa7, 0x7e, 0xa3, 0x97, 0x94, 0x49, 0xf1, 0x58, 0x33, 0xc9, 0x09, 0xc8, 0xb7,
	0x85, 0x61, 0x3f, 0x23, 0x53, 0xf8, 0x5c, 0x33, 0xb5, 0x35, 0x98, 0x41, 0x1f, 0xd2, 0x21, 0x92,
	0x3a, 0x1e, 0x27, 0xa5, 0x46, 0xb0, 0x1f, 0xc1, 0xb1, 0x98, 0x21, 0x8f, 0x30, 0xe3, 0xae, 0x95,
	0x43, 0xae, 0x85, 0x2a, 0xa4, 0xc3, 0x8b, 0x39, 0x74, 0x35, 0x25, 0xf9, 0x70, 0xed, 0x2c, 0x4c,
	0xef, 0x50, 0xdf, 0x66, 0x9c, 0x33, 0xd7, 0xc9, 0x04, 0x9d, 0xfd, 0xd0, 0xe0, 0x7d, 0xd3, 0x1e,
	0x6c, 0x18, 0x76, 0xa5, 0x1f, 0xf6, 0x12, 0x14, 0xbc, 0xbe, 0x5d, 0x08, 0x18, 0x17, 0x69, 0x4f,
	0x73, 0x30, 0x5e, 0x77, 0x2d, 0xfa, 0x6f, 0xd7, 0xed, 0x00, 0xb3, 0x89, 0x67, 0x98, 0x91, 0x53,
	0xf0, 0x5f, 0xc6, 0x1b, 0x9e, 0x4f, 0x4d, 0xda, 0x62, 0x0e, 0x35, 0xb1, 0x42, 0xf3, 0xf5, 0x23,
	0x8c, 0xef, 0xf4, 0x64, 0x03, 0xe5, 0x3f, 0xf5, 0xe2, 0xe5, 0x9f, 0x7f, 0xf1, 0xf2, 0x57, 0x53,
	0xca, 0x1f, 0x7a, 0x79, 0xd0, 0x2e, 0x41, 0x5e, 0x04, 0x19, 0x93, 0xba, 0x79, 0xb8, 0xbc, 0x4f,
	0xa6, 0x94, 0xb7, 0xb0, 0x8f, 0x32, 0x7e, 0x0b, 0x0a, 0xe2, 0xf1, 0x32, 0x73, 0x4c, 0xe6, 0xb4,
	0x9f, 0x49, 0xd5, 0x49, 0x50, 0x6d, 0x2c, 0xc0, 0x7e, 0x92, 0xf2, 0x52, 0x50, 0x33, 0x45, 0xfd,
	0xfb, 0xae, 0x45, 0x85, 0x4a, 0x66, 0x68, 0x52, 0x3c, 0xd6, 0x4c, 0xed, 0x1e, 0x4c, 0xee, 0xb8,
	0x16, 0x6b, 0xee, 0x8b, 0x9e, 0xe8, 0x53, 0xee, 0x76, 0xfc, 0x26, 0x6d, 0xf4, 0x0b, 0xa8, 0x10,
	0xc9, 0x76, 0x7d, 0x8b, 0xbc, 0x07, 0xf9, 0x3d, 0x89, 0x2e, 0xab, 0xa8, 0x50, 0xd5, 0x32, 0x78,
	0x87, 0x44, 0xeb, 0xbd, 0x77, 0xb4, 0xfb, 0x70, 0x2c, 0xa6, 0xe8, 0x55, 0xec, 0xab, 0x47, 0xae,
	0xfe, 0x79, 0x02, 0xa0, 0xb6, 0x75, 0xfd, 0x16, 0xf5, 0xbb, 0xac, 0x49, 0xc9, 0xa7, 0x50, 0xd8,
	0xa6, 0xc1, 0xed, 0xbb, 0x8c, 0xe3, 0x1c, 0x5d, 0x19, 0xf4, 0x15, 0x4e, 0xf2, 0xee, 0x66, 0xe5,
	0xaa, 0xed, 0x05, 0xfb, 0x0b, 0x69, 0xe9, 0x11, 0x6f, 0x6b, 0x4b, 0x9f, 0xff, 0xfe, 0xd7, 0x93,
	0xdc, 0x3c, 0x99, 0xc5, 0x71, 0xcd, 0x0c, 0x5b, 0xec, 0x02, 0x9c, 0x5a, 0x2d, 0x5d, 0xdc, 0x69,
	0x72, 0x0f, 0xa6, 0xb6, 0x69, 0x80, 0x38, 0xa7, 0xd2, 0x71, 0x6a, 0x57, 0x6e, 0xe2, 0x95, 0xe0,
	0xd9, 0x58, 0xcb, 0x88, 0x55, 0x24, 0x73, 0x71, 0x2c, 0x01, 0xc3, 0xf5, 0x87, 0xcc, 0x7c, 0x44,
	0x18, 0xc0, 0xae, 0x67, 0x1a, 0x01, 0x45, 0xbc, 0x2c, 0x57, 0xd9, 0x38, 0xab, 0x88, 0x73, 0xb2,
	0x9a, 0x82, 0xf3, 0xb6, 0x52, 0x26, 0x3f, 0x2b, 0x30, 0x9b, 0x38, 0x21, 0xc9, 0xf9, 0x14, 0xcf,
	0x59, 0xf3, 0x74, 0x61, 0x58, 0x0e, 0x34, 0x1d, 0x29, 0xfd, 0x5f, 0x3b, 0x3d, 0x48, 0x69, 0x43,
	0x4e, 0xf8, 0x0d, 0x1c, 0xff, 0x3a, 0x8e, 0xff, 0x7d, 0x41, 0xf0, 0x7b, 0x05, 0x56, 0xeb, 0x94,
	0x53, 0xc7, 0x1c, 0x80, 0x94, 0x6b, 0x40, 0x13, 0x5b, 0xd7, 0xf0, 0xdc, 0xff, 0x53, 0xc4, 0x7c,
	0xa4, 0x22, 0x88, 0x7d, 0xa3, 0x00, 0x88, 0x26, 0x80, 0x43, 0x83, 0x93, 0x33, 0xe9, 0x00, 0xc2,
	0x2a, 0xaa, 0x8b, 0x52, 0xd6, 0x04, 0x14, 0x86, 0xda, 0x9b, 0x48, 0x44, 0x27, 0x1b, 0x71, 0x22,
	0xf1, 0x3e, 0xcd, 0xf5, 0x87, 0x4d, 0xd7, 0x09, 0xe8, 0xfd, 0xa0, 0xc1, 0xcc, 0x47, 0x7a, 0x5b,
	0xe2, 0x3b, 0x90, 0xdf, 0xa6, 0x92, 0xcc, 0x68, 0x15, 0x9a, 0x39, 0x8b, 0xb5, 0x15, 0x64, 0x71,
	0x82, 0xcc, 0xc7, 0x59, 0x48, 0x28, 0x59, 0xa3, 0x5f, 0x29, 0x50, 0xf8, 0x00, 0x1b, 0xb0, 0xc4,
	0xcc, 0x74, 0x37, 0x04, 0xec, 0x12, 0x82, 0x5d, 0xd0, 0xaa, 0x19, 0x47, 0x1e, 0x18, 0x60, 0xd1,
	0xb9, 0x45, 0x26, 0x6c, 0x28, 0xc8, 0xeb, 0xf2, 0xf2, 0x4c, 0x34, 0x64, 0xb2, 0x58, 0x4d, 0x3b,
	0xb6, 0x80, 0x0b, 0xa0, 0x20, 0xa7, 0xc3, 0x73, 0x04, 0x7b, 0x68, 0xf9, 0x85, 0xf1, 0x2e, 0xa7,
	0xc6, 0xfb, 0x3b, 0x05, 0x8e, 0xf6, 0xca, 0x2d, 0xdc, 0x51, 0x46, 0x2d, 0xba, 0xb3, 0x59, 0x67,
	0xee, 0x2f, 0x46, 0xd1, 0x1d, 0x20, 0x6b, 0x49, 0x24, 0xe2, 0x35, 0x67, 0x87, 0xf8, 0xdf, 0x2a,
	0x30, 0xb3, 0x65, 0x9a, 0x87, 0x38, 0x95, 0x87, 0x83, 0xf1, 0x91, 0xdb, 0xc5, 0xeb, 0xc8, 0xa8,
	0xac, 0x9d, 0x49, 0x62, 0x14, 0xed, 0x65, 0x3d, 0x3e, 0x22, 0x3b, 0x4f, 0x14, 0x20, 0xb1, 0xf4,
	0xbc, 0x4a, 0x56, 0xe5, 0xd1, 0x59, 0xfd, 0xa4, 0xc0, 0xcc, 0xc0, 0x52, 0x4b, 0x36, 0x52, 0x28,
	0x25, 0x2f, 0xbf, 0x0b, 0xab, 0xe9, 0xac, 0x3e, 0xa6, 0xfc, 0xa6, 0x7f, 0xc3, 0xd5, 0x2e, 0x20,
	0xaf, 0x4d, 0xa2, 0x8f, 0xc4, 0x4b, 0x7f, 0x18, 0x6e, 0xaf, 0x8f, 0xc8, 0x63, 0x05, 0x54, 0x51,
	0x01, 0x62, 0xec, 0x8e, 0x5c, 0x55, 0x2b, 0x19, 0xb3, 0x1b, 0xcb, 0xe9, 0x0d, 0xa4, 0x53, 0x21,
	0xe7, 0x46, 0xec, 0x64, 0x3e, 0xa2, 0xcb, 0x49, 0x8b, 0x7b, 0xec, 0x4b, 0x4d, 0x5a, 0xe1, 0x21,
	0x79, 0xd2, 0x22, 0x8e, 0xbc, 0x55, 0x5f, 0x28, 0x00, 0xb2, 0x8b, 0x21, 0x60, 0x96, 0xaf, 0x6c,
	0xa0, 0x77, 0x11, 0xe8, 0x2d, 0x6d, 0xf3, 0x79, 0x5a, 0x18, 0x12, 0x11, 0xe5, 0xd1, 0x1b, 0xf8,
	0x2f, 0xc9, 0x22, 0x71, 0xe0, 0xf7, 0x8f, 0x2b, 0xa0, 0x7c, 0x00, 0x79, 0x3d, 0x46, 0x8f, 0xf0,
	0xd0, 0xfb, 0x10, 0x46, 0xb9, 0x9c, 0x16, 0x65, 0x07, 0xd4, 0x6d, 0x1a, 0x84, 0x1b, 0xea, 0xe9,
	0x74, 0x6f, 0xbb, 0xf5, 0x6b, 0x11, 0xe6, 0x52, 0xca, 0x31, 0xa5, 0x13, 0x6d, 0x11, 0x11, 0xe7,
	0xc8, 0xf1, 0x38, 0xa2, 0x27, 0x74, 0x8c, 0x72, 0xf2, 0xa5, 0x6c, 0x4b, 0xf1, 0x2d, 0x35, 0xb5,
	0x01, 0x24, 0xac, 0xb2, 0xc3, 0xc0, 0xd7, 0x11, 0x5c, 0xd3, 0x96, 0x92, 0xc0, 0xf5, 0x68, 0x5b,
	0x15, 0xc1, 0x7e, 0xdc, 0x6b, 0x46, 0xaf, 0x98, 0x4b, 0x79, 0x38, 0x97, 0x1f, 0x15, 0x98, 0xdf,
	0xa6, 0xc1, 0xd5, 0x56, 0x8b, 0x36, 0x03, 0xd6, 0xa5, 0xb1, 0x8f, 0xce, 0x11, 0x73, 0x72, 0x26,
	0x8d, 0xca, 0xa1, 0x2f, 0x5d, 0xad, 0x8a, 0x94, 0xce, 0x91, 0x72, 0x22, 0x25, 0x1a, 0xe1, 0x6f,
	0xc4, 0x3f, 0x10, 0xbf, 0x56, 0x60, 0xfa, 0xf0, 0x87, 0x30, 0x39, 0x97, 0x82, 0x96, 0xf8, 0xbd,
	0x3c, 0x4a, 0x77, 0x0c, 0x43, 0x45, 0x4a, 0x89, 0xbc, 0xe2, 0x6c, 0x1e, 0xc0, 0x8c, 0x38, 0x49,
	0x9c, 0xcd, 0xd0, 0x05, 0x73, 0xc4, 0xe0, 0x24, 0xee, 0x55, 0x31, 0xec, 0xcb, 0x17, 0x7f, 0x3d,
	0x58, 0x56, 0x7e, 0x3b, 0x58, 0x56, 0xfe, 0x38, 0x58, 0x56, 0x7e, 0x78, 0xba, 0xfc, 0x9f, 0x4f,
	0xd6, 0x62, 0xff, 0x41, 0x46, 0x18, 0x1b, 0xb6, 0xe1, 0x18, 0x6d, 0x6a, 0x0a, 0x2f, 0x3c, 0x74,
	0xb3, 0x37, 0x89, 0x5f, 0xba, 0xe7, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff, 0xbc, 0x0e, 0xa2, 0xaf,
	0xef, 0x14, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// IAMServiceClient is the client API for IAMService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IAMServiceClient interface {
	// Fetch all available information of the currently authenticated user.
	// Required permissions:
	// - None
	GetThisUser(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*User, error)
	// Fetch all available information of the user identified by the given ID.
	// Required permissions:
	// - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of
	GetUser(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*User, error)
	// Update a user
	// Required permissions:
	// - None if the given user is the authenticated user.
	// or
	// - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of and
	// - iam.user.update on organization on one of the organizations that the requested user and authenticated user are both a member of
	UpdateUser(ctx context.Context, in *User, opts ...grpc.CallOption) (*User, error)
	// Verify the mobile phone number of a user, by provided the unique
	// code that was send to the number.
	// If the code is valid an empty result is returned, otherwise an InvalidArgument error is returned.
	// The authenticated user is always the subject of this request.
	// Required permissions:
	// - None (since the subject is always the authenticated user).
	VerifyUserMobilePhone(ctx context.Context, in *VerifyUserMobilePhoneRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Resend a verification code to the mobile phone number listed for the
	// authenticated user.
	// Required permissions:
	// - None (since the subject is always the authenticated user).
	ResendUserMobilePhoneVerification(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Empty, error)
	// Fetch all groups of the organization identified by the given context ID.
	// Required permissions:
	// - iam.group.list on organization identified by given context ID.
	ListGroups(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupList, error)
	// Fetch a group by its id.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	GetGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Group, error)
	// Create a group
	// Required permissions:
	// - iam.group.create on organization that owns the group
	CreateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error)
	// Update a group
	// Required permissions:
	// - iam.group.update on organization that owns the group
	UpdateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error)
	// Delete a group
	// Required permissions:
	// - iam.group.delete on organization that owns the group
	DeleteGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// List of members of the group identified by the given context ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	ListGroupMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupMemberList, error)
	// Add one or more members to the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	AddGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Remove one or more members from the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	DeleteGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error)
	// Is the user identified by the given user ID a member of the group identified by the given group ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group, unless the requested user is identical to the authenticated user.
	// Note that if the identified group does not exist, no is returned.
	IsMemberOfGroup(ctx context.Context, in *IsMemberOfGroupRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error)
	// Fetch all roles in the organization identified by the given context ID.
	// Required permissions:
	// - iam.role.list on organization identified by given context ID.
	ListRoles(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*RoleList, error)
	// Fetch a role by its id.
	// Required permissions:
	// - iam.role.get on organization that owns the role
	GetRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Role, error)
	// Create a custom role
	// Required permissions:
	// - iam.role.create on organization that owns the role
	CreateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error)
	// Update a custom role
	// Required permissions:
	// - iam.role.update on organization that owns the role
	UpdateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error)
	// Delete a custom role
	// Required permissions:
	// - iam.role.delete on organization that owns the role
	DeleteRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error)
	// Get the policy for a resource identified by given URL.
	// Required permissions:
	// - iam.policy.get on resource identified by the url
	GetPolicy(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*Policy, error)
	// Add one or more RoleBindings to the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	AddRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error)
	// Remove one or more RoleBindings from the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	DeleteRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error)
	// Return the list of permissions that are available to the currently authenticated
	// used for actions on the resource identified by the given URL.
	// Required permissions:
	// - None
	GetEffectivePermissions(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*PermissionList, error)
	// Does the authenticated user have all of the requested permissions for the resource
	// identified by the given URL?
	// Required permissions:
	// - None
	HasPermissions(ctx context.Context, in *HasPermissionsRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error)
	// List all known permissions.
	// Required permissions:
	// - None
	ListPermissions(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*PermissionList, error)
}

type iAMServiceClient struct {
	cc *grpc.ClientConn
}

func NewIAMServiceClient(cc *grpc.ClientConn) IAMServiceClient {
	return &iAMServiceClient{cc}
}

func (c *iAMServiceClient) GetThisUser(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetThisUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetUser(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) UpdateUser(ctx context.Context, in *User, opts ...grpc.CallOption) (*User, error) {
	out := new(User)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/UpdateUser", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) VerifyUserMobilePhone(ctx context.Context, in *VerifyUserMobilePhoneRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/VerifyUserMobilePhone", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ResendUserMobilePhoneVerification(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ResendUserMobilePhoneVerification", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListGroups(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupList, error) {
	out := new(GroupList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListGroups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) CreateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/CreateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) UpdateGroup(ctx context.Context, in *Group, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/UpdateGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteGroup(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListGroupMembers(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*GroupMemberList, error) {
	out := new(GroupMemberList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) AddGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/AddGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteGroupMembers(ctx context.Context, in *GroupMembersRequest, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteGroupMembers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) IsMemberOfGroup(ctx context.Context, in *IsMemberOfGroupRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error) {
	out := new(v1.YesOrNo)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/IsMemberOfGroup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListRoles(ctx context.Context, in *v1.ListOptions, opts ...grpc.CallOption) (*RoleList, error) {
	out := new(RoleList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListRoles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) CreateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/CreateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) UpdateRole(ctx context.Context, in *Role, opts ...grpc.CallOption) (*Role, error) {
	out := new(Role)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/UpdateRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteRole(ctx context.Context, in *v1.IDOptions, opts ...grpc.CallOption) (*v1.Empty, error) {
	out := new(v1.Empty)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteRole", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetPolicy(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) AddRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/AddRoleBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) DeleteRoleBindings(ctx context.Context, in *RoleBindingsRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/DeleteRoleBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) GetEffectivePermissions(ctx context.Context, in *v1.URLOptions, opts ...grpc.CallOption) (*PermissionList, error) {
	out := new(PermissionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/GetEffectivePermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) HasPermissions(ctx context.Context, in *HasPermissionsRequest, opts ...grpc.CallOption) (*v1.YesOrNo, error) {
	out := new(v1.YesOrNo)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/HasPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *iAMServiceClient) ListPermissions(ctx context.Context, in *v1.Empty, opts ...grpc.CallOption) (*PermissionList, error) {
	out := new(PermissionList)
	err := c.cc.Invoke(ctx, "/arangodb.cloud.iam.v1.IAMService/ListPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IAMServiceServer is the server API for IAMService service.
type IAMServiceServer interface {
	// Fetch all available information of the currently authenticated user.
	// Required permissions:
	// - None
	GetThisUser(context.Context, *v1.Empty) (*User, error)
	// Fetch all available information of the user identified by the given ID.
	// Required permissions:
	// - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of
	GetUser(context.Context, *v1.IDOptions) (*User, error)
	// Update a user
	// Required permissions:
	// - None if the given user is the authenticated user.
	// or
	// - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of and
	// - iam.user.update on organization on one of the organizations that the requested user and authenticated user are both a member of
	UpdateUser(context.Context, *User) (*User, error)
	// Verify the mobile phone number of a user, by provided the unique
	// code that was send to the number.
	// If the code is valid an empty result is returned, otherwise an InvalidArgument error is returned.
	// The authenticated user is always the subject of this request.
	// Required permissions:
	// - None (since the subject is always the authenticated user).
	VerifyUserMobilePhone(context.Context, *VerifyUserMobilePhoneRequest) (*v1.Empty, error)
	// Resend a verification code to the mobile phone number listed for the
	// authenticated user.
	// Required permissions:
	// - None (since the subject is always the authenticated user).
	ResendUserMobilePhoneVerification(context.Context, *v1.Empty) (*v1.Empty, error)
	// Fetch all groups of the organization identified by the given context ID.
	// Required permissions:
	// - iam.group.list on organization identified by given context ID.
	ListGroups(context.Context, *v1.ListOptions) (*GroupList, error)
	// Fetch a group by its id.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	GetGroup(context.Context, *v1.IDOptions) (*Group, error)
	// Create a group
	// Required permissions:
	// - iam.group.create on organization that owns the group
	CreateGroup(context.Context, *Group) (*Group, error)
	// Update a group
	// Required permissions:
	// - iam.group.update on organization that owns the group
	UpdateGroup(context.Context, *Group) (*Group, error)
	// Delete a group
	// Required permissions:
	// - iam.group.delete on organization that owns the group
	DeleteGroup(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// List of members of the group identified by the given context ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group
	ListGroupMembers(context.Context, *v1.ListOptions) (*GroupMemberList, error)
	// Add one or more members to the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	AddGroupMembers(context.Context, *GroupMembersRequest) (*v1.Empty, error)
	// Remove one or more members from the group identified by given ID.
	// Required permissions:
	// - iam.group.update on organization that owns the group
	DeleteGroupMembers(context.Context, *GroupMembersRequest) (*v1.Empty, error)
	// Is the user identified by the given user ID a member of the group identified by the given group ID.
	// Required permissions:
	// - iam.group.get on organization that owns the group, unless the requested user is identical to the authenticated user.
	// Note that if the identified group does not exist, no is returned.
	IsMemberOfGroup(context.Context, *IsMemberOfGroupRequest) (*v1.YesOrNo, error)
	// Fetch all roles in the organization identified by the given context ID.
	// Required permissions:
	// - iam.role.list on organization identified by given context ID.
	ListRoles(context.Context, *v1.ListOptions) (*RoleList, error)
	// Fetch a role by its id.
	// Required permissions:
	// - iam.role.get on organization that owns the role
	GetRole(context.Context, *v1.IDOptions) (*Role, error)
	// Create a custom role
	// Required permissions:
	// - iam.role.create on organization that owns the role
	CreateRole(context.Context, *Role) (*Role, error)
	// Update a custom role
	// Required permissions:
	// - iam.role.update on organization that owns the role
	UpdateRole(context.Context, *Role) (*Role, error)
	// Delete a custom role
	// Required permissions:
	// - iam.role.delete on organization that owns the role
	DeleteRole(context.Context, *v1.IDOptions) (*v1.Empty, error)
	// Get the policy for a resource identified by given URL.
	// Required permissions:
	// - iam.policy.get on resource identified by the url
	GetPolicy(context.Context, *v1.URLOptions) (*Policy, error)
	// Add one or more RoleBindings to the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	AddRoleBindings(context.Context, *RoleBindingsRequest) (*Policy, error)
	// Remove one or more RoleBindings from the policy of a resource identified by given URL.
	// Required permissions:
	// - iam.policy.update on resource identified by the url
	DeleteRoleBindings(context.Context, *RoleBindingsRequest) (*Policy, error)
	// Return the list of permissions that are available to the currently authenticated
	// used for actions on the resource identified by the given URL.
	// Required permissions:
	// - None
	GetEffectivePermissions(context.Context, *v1.URLOptions) (*PermissionList, error)
	// Does the authenticated user have all of the requested permissions for the resource
	// identified by the given URL?
	// Required permissions:
	// - None
	HasPermissions(context.Context, *HasPermissionsRequest) (*v1.YesOrNo, error)
	// List all known permissions.
	// Required permissions:
	// - None
	ListPermissions(context.Context, *v1.Empty) (*PermissionList, error)
}

func RegisterIAMServiceServer(s *grpc.Server, srv IAMServiceServer) {
	s.RegisterService(&_IAMService_serviceDesc, srv)
}

func _IAMService_GetThisUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetThisUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetThisUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetThisUser(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetUser(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_UpdateUser_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(User)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).UpdateUser(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/UpdateUser",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).UpdateUser(ctx, req.(*User))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_VerifyUserMobilePhone_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyUserMobilePhoneRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).VerifyUserMobilePhone(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/VerifyUserMobilePhone",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).VerifyUserMobilePhone(ctx, req.(*VerifyUserMobilePhoneRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ResendUserMobilePhoneVerification_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ResendUserMobilePhoneVerification(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ResendUserMobilePhoneVerification",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ResendUserMobilePhoneVerification(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListGroups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListGroups(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetGroup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/CreateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).CreateGroup(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Group)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/UpdateGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).UpdateGroup(ctx, req.(*Group))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteGroup(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListGroupMembers(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_AddGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).AddGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/AddGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).AddGroupMembers(ctx, req.(*GroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteGroupMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupMembersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteGroupMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteGroupMembers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteGroupMembers(ctx, req.(*GroupMembersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_IsMemberOfGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsMemberOfGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).IsMemberOfGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/IsMemberOfGroup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).IsMemberOfGroup(ctx, req.(*IsMemberOfGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListRoles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.ListOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListRoles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListRoles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListRoles(ctx, req.(*v1.ListOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetRole(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_CreateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Role)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).CreateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/CreateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).CreateRole(ctx, req.(*Role))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_UpdateRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Role)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).UpdateRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/UpdateRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).UpdateRole(ctx, req.(*Role))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteRole_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.IDOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteRole(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteRole",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteRole(ctx, req.(*v1.IDOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.URLOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetPolicy(ctx, req.(*v1.URLOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_AddRoleBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RoleBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).AddRoleBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/AddRoleBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).AddRoleBindings(ctx, req.(*RoleBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_DeleteRoleBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RoleBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).DeleteRoleBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/DeleteRoleBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).DeleteRoleBindings(ctx, req.(*RoleBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_GetEffectivePermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.URLOptions)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).GetEffectivePermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/GetEffectivePermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).GetEffectivePermissions(ctx, req.(*v1.URLOptions))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_HasPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HasPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).HasPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/HasPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).HasPermissions(ctx, req.(*HasPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _IAMService_ListPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IAMServiceServer).ListPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/arangodb.cloud.iam.v1.IAMService/ListPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IAMServiceServer).ListPermissions(ctx, req.(*v1.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

var _IAMService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "arangodb.cloud.iam.v1.IAMService",
	HandlerType: (*IAMServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetThisUser",
			Handler:    _IAMService_GetThisUser_Handler,
		},
		{
			MethodName: "GetUser",
			Handler:    _IAMService_GetUser_Handler,
		},
		{
			MethodName: "UpdateUser",
			Handler:    _IAMService_UpdateUser_Handler,
		},
		{
			MethodName: "VerifyUserMobilePhone",
			Handler:    _IAMService_VerifyUserMobilePhone_Handler,
		},
		{
			MethodName: "ResendUserMobilePhoneVerification",
			Handler:    _IAMService_ResendUserMobilePhoneVerification_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _IAMService_ListGroups_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _IAMService_GetGroup_Handler,
		},
		{
			MethodName: "CreateGroup",
			Handler:    _IAMService_CreateGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _IAMService_UpdateGroup_Handler,
		},
		{
			MethodName: "DeleteGroup",
			Handler:    _IAMService_DeleteGroup_Handler,
		},
		{
			MethodName: "ListGroupMembers",
			Handler:    _IAMService_ListGroupMembers_Handler,
		},
		{
			MethodName: "AddGroupMembers",
			Handler:    _IAMService_AddGroupMembers_Handler,
		},
		{
			MethodName: "DeleteGroupMembers",
			Handler:    _IAMService_DeleteGroupMembers_Handler,
		},
		{
			MethodName: "IsMemberOfGroup",
			Handler:    _IAMService_IsMemberOfGroup_Handler,
		},
		{
			MethodName: "ListRoles",
			Handler:    _IAMService_ListRoles_Handler,
		},
		{
			MethodName: "GetRole",
			Handler:    _IAMService_GetRole_Handler,
		},
		{
			MethodName: "CreateRole",
			Handler:    _IAMService_CreateRole_Handler,
		},
		{
			MethodName: "UpdateRole",
			Handler:    _IAMService_UpdateRole_Handler,
		},
		{
			MethodName: "DeleteRole",
			Handler:    _IAMService_DeleteRole_Handler,
		},
		{
			MethodName: "GetPolicy",
			Handler:    _IAMService_GetPolicy_Handler,
		},
		{
			MethodName: "AddRoleBindings",
			Handler:    _IAMService_AddRoleBindings_Handler,
		},
		{
			MethodName: "DeleteRoleBindings",
			Handler:    _IAMService_DeleteRoleBindings_Handler,
		},
		{
			MethodName: "GetEffectivePermissions",
			Handler:    _IAMService_GetEffectivePermissions_Handler,
		},
		{
			MethodName: "HasPermissions",
			Handler:    _IAMService_HasPermissions_Handler,
		},
		{
			MethodName: "ListPermissions",
			Handler:    _IAMService_ListPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "iam.proto",
}

func (m *User) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *User) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.Email) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Email)))
		i += copy(dAtA[i:], m.Email)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.GivenName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.GivenName)))
		i += copy(dAtA[i:], m.GivenName)
	}
	if len(m.FamilyName) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.FamilyName)))
		i += copy(dAtA[i:], m.FamilyName)
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintIam(dAtA, i, uint64(m.CreatedAt.Size()))
		n1, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.AdditionalEmails) > 0 {
		for _, s := range m.AdditionalEmails {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.MobilePhone) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.MobilePhone)))
		i += copy(dAtA[i:], m.MobilePhone)
	}
	if m.MobilePhoneVerified {
		dAtA[i] = 0x48
		i++
		if m.MobilePhoneVerified {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.CompanyName) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.CompanyName)))
		i += copy(dAtA[i:], m.CompanyName)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *VerifyUserMobilePhoneRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *VerifyUserMobilePhoneRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Code) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Code)))
		i += copy(dAtA[i:], m.Code)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Group) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Group) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintIam(dAtA, i, uint64(m.CreatedAt.Size()))
		n2, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintIam(dAtA, i, uint64(m.DeletedAt.Size()))
		n3, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.IsDeleted {
		dAtA[i] = 0x38
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if m.IsVirtual {
		dAtA[i] = 0x48
		i++
		if m.IsVirtual {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GroupList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintIam(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *IsMemberOfGroupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IsMemberOfGroupRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UserId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.UserId)))
		i += copy(dAtA[i:], m.UserId)
	}
	if len(m.GroupId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.GroupId)))
		i += copy(dAtA[i:], m.GroupId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GroupMemberList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMemberList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *GroupMembersRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GroupMembersRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.GroupId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.GroupId)))
		i += copy(dAtA[i:], m.GroupId)
	}
	if len(m.UserIds) > 0 {
		for _, s := range m.UserIds {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PermissionList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PermissionList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *HasPermissionsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HasPermissionsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Url) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Role) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Role) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.OrganizationId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.OrganizationId)))
		i += copy(dAtA[i:], m.OrganizationId)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Description) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Description)))
		i += copy(dAtA[i:], m.Description)
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.IsPredefined {
		dAtA[i] = 0x30
		i++
		if m.IsPredefined {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.CreatedAt != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintIam(dAtA, i, uint64(m.CreatedAt.Size()))
		n4, err := m.CreatedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.DeletedAt != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintIam(dAtA, i, uint64(m.DeletedAt.Size()))
		n5, err := m.DeletedAt.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if m.IsDeleted {
		dAtA[i] = 0x48
		i++
		if m.IsDeleted {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Url) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Url)))
		i += copy(dAtA[i:], m.Url)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleList) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, msg := range m.Items {
			dAtA[i] = 0xa
			i++
			i = encodeVarintIam(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleBinding) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleBinding) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Id) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.Id)))
		i += copy(dAtA[i:], m.Id)
	}
	if len(m.MemberId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.MemberId)))
		i += copy(dAtA[i:], m.MemberId)
	}
	if len(m.RoleId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.RoleId)))
		i += copy(dAtA[i:], m.RoleId)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResourceUrl) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.ResourceUrl)))
		i += copy(dAtA[i:], m.ResourceUrl)
	}
	if len(m.Bindings) > 0 {
		for _, msg := range m.Bindings {
			dAtA[i] = 0x12
			i++
			i = encodeVarintIam(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *RoleBindingsRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RoleBindingsRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ResourceUrl) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintIam(dAtA, i, uint64(len(m.ResourceUrl)))
		i += copy(dAtA[i:], m.ResourceUrl)
	}
	if len(m.Bindings) > 0 {
		for _, msg := range m.Bindings {
			dAtA[i] = 0x12
			i++
			i = encodeVarintIam(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeVarintIam(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *User) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Email)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.GivenName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.FamilyName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.AdditionalEmails) > 0 {
		for _, s := range m.AdditionalEmails {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	l = len(m.MobilePhone)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.MobilePhoneVerified {
		n += 2
	}
	l = len(m.CompanyName)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *VerifyUserMobilePhoneRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Code)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Group) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsVirtual {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *IsMemberOfGroupRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.UserId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.GroupId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMemberList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GroupMembersRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.GroupId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.UserIds) > 0 {
		for _, s := range m.UserIds {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PermissionList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, s := range m.Items {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *HasPermissionsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Role) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.OrganizationId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.Description)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Permissions) > 0 {
		for _, s := range m.Permissions {
			l = len(s)
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.IsPredefined {
		n += 2
	}
	if m.CreatedAt != nil {
		l = m.CreatedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.DeletedAt != nil {
		l = m.DeletedAt.Size()
		n += 1 + l + sovIam(uint64(l))
	}
	if m.IsDeleted {
		n += 2
	}
	l = len(m.Url)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleBinding) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.MemberId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	l = len(m.RoleId)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Policy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResourceUrl)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Bindings) > 0 {
		for _, e := range m.Bindings {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *RoleBindingsRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ResourceUrl)
	if l > 0 {
		n += 1 + l + sovIam(uint64(l))
	}
	if len(m.Bindings) > 0 {
		for _, e := range m.Bindings {
			l = e.Size()
			n += 1 + l + sovIam(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovIam(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozIam(x uint64) (n int) {
	return sovIam(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *User) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: User: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: User: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Email", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Email = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GivenName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GivenName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FamilyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FamilyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdditionalEmails", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AdditionalEmails = append(m.AdditionalEmails, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MobilePhone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MobilePhone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MobilePhoneVerified", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.MobilePhoneVerified = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompanyName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CompanyName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *VerifyUserMobilePhoneRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: VerifyUserMobilePhoneRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: VerifyUserMobilePhoneRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Code = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Group) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Group: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Group: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsVirtual", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsVirtual = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Group{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IsMemberOfGroupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IsMemberOfGroupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IsMemberOfGroupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupMemberList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMemberList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMemberList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GroupMembersRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GroupMembersRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GroupMembersRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GroupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserIds", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UserIds = append(m.UserIds, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PermissionList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PermissionList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PermissionList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HasPermissionsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HasPermissionsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HasPermissionsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = append(m.Permissions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Role) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Role: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Role: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrganizationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OrganizationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Description = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Permissions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Permissions = append(m.Permissions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsPredefined", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsPredefined = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreatedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CreatedAt == nil {
				m.CreatedAt = &types.Timestamp{}
			}
			if err := m.CreatedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeletedAt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeletedAt == nil {
				m.DeletedAt = &types.Timestamp{}
			}
			if err := m.DeletedAt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsDeleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsDeleted = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Url", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Url = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, &Role{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleBinding) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleBinding: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleBinding: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemberId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MemberId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoleId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RoleId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bindings = append(m.Bindings, &RoleBinding{})
			if err := m.Bindings[len(m.Bindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RoleBindingsRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowIam
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RoleBindingsRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RoleBindingsRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResourceUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bindings", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowIam
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthIam
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthIam
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bindings = append(m.Bindings, &RoleBinding{})
			if err := m.Bindings[len(m.Bindings)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipIam(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthIam
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipIam(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowIam
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIam
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowIam
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthIam
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthIam
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowIam
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipIam(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthIam
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthIam = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowIam   = fmt.Errorf("proto: integer overflow")
)
