//
// This file is AUTO-GENERATED by protoc-gen-ts.
// Do not modify it manually.
///
import api from '../../api'
import * as googleTypes from '../../googleTypes'
import { Empty as arangodb_cloud_common_v1_Empty } from '../../common/v1/common'
import { IDOptions as arangodb_cloud_common_v1_IDOptions } from '../../common/v1/common'
import { ListOptions as arangodb_cloud_common_v1_ListOptions } from '../../common/v1/common'
import { URLOptions as arangodb_cloud_common_v1_URLOptions } from '../../common/v1/common'
import { YesOrNo as arangodb_cloud_common_v1_YesOrNo } from '../../common/v1/common'

// File: iam/v1/iam.proto
// Package: arangodb.cloud.iam.v1

// Group of user accounts.
export interface Group {
  // System identifier of the group.
  // This is a read-only value.
  // string
  id?: string;
  
  // Identifier of the organization that owns this group.
  // string
  organization_id?: string;
  
  // Name of the group
  // string
  name?: string;
  
  // Description of the group
  // string
  description?: string;
  
  // The creation timestamp of the group
  // googleTypes.Timestamp
  created_at?: googleTypes.Timestamp;
  
  // The deletion timestamp of the group
  // googleTypes.Timestamp
  deleted_at?: googleTypes.Timestamp;
  
  // Set when this organization is deleted.
  // This is a read-only value.
  // boolean
  is_deleted?: boolean;
  
  // URL of this resource
  // This is a read-only value and cannot be initialized.
  // string
  url?: string;
  
  // Set if this group is virtual and managed by the system.
  // This is a read-only value.
  // boolean
  is_virtual?: boolean;
}

// List of groups.
export interface GroupList {
  // Group
  items?: Group[];
}

// List of group members (user ID's)
export interface GroupMemberList {
  // List of ID's of users that are member of the group.
  // string
  items?: string[];
}

// Request arguments for Add/DeleteGroupMembers.
export interface GroupMembersRequest {
  // ID of the group to add/remove members to/from.
  // string
  group_id?: string;
  
  // ID's of users to add/remove to/from the group.
  // string
  user_ids?: string[];
}

// Request arguments for HasPermissionsRequest.
export interface HasPermissionsRequest {
  // URL of the resource to query permissions for.
  // string
  url?: string;
  
  // The list of permissions that are required.
  // string
  permissions?: string[];
}

// Request arguments for IsMemberOfGroup.
export interface IsMemberOfGroupRequest {
  // Identifier of the user
  // string
  user_id?: string;
  
  // Identifier of the group
  // string
  group_id?: string;
}

// List of permissions.
export interface PermissionList {
  // string
  items?: string[];
}

// Policy bindings members to roles for access to a resource.
export interface Policy {
  // URL of the resource to which this policy applies.
  // string
  resource_url?: string;
  
  // Role bindings to apply to the resource.
  // RoleBinding
  bindings?: RoleBinding[];
}

// A role is a list of permissions.
// Roles can be bound to resources for members.
export interface Role {
  // System identifier of the role.
  // This is a read-only value.
  // string
  id?: string;
  
  // Identifier of the organization that owns this role.
  // This value is undefined for predefined roles.
  // string
  organization_id?: string;
  
  // Name of the role
  // string
  name?: string;
  
  // Description of the role
  // string
  description?: string;
  
  // Permissions to grant when this role is bound.
  // string
  permissions?: string[];
  
  // Set if this role is predefined.
  // This is a read-only value.
  // boolean
  is_predefined?: boolean;
  
  // The creation timestamp of the role
  // googleTypes.Timestamp
  created_at?: googleTypes.Timestamp;
  
  // The deletion timestamp of the role
  // googleTypes.Timestamp
  deleted_at?: googleTypes.Timestamp;
  
  // Set when this organization is deleted.
  // This is a read-only value.
  // boolean
  is_deleted?: boolean;
  
  // URL of this resource
  // This is a read-only value and cannot be initialized.
  // string
  url?: string;
}

// RoleBinding binds a Role to a member.
export interface RoleBinding {
  // System identifier of the role-binding.
  // This is a read-only value.
  // string
  id?: string;
  
  // Identifier of the member to bind a role to.
  // Member ID is formatted as:
  // - user:<user_id>
  // - group:<group_id>
  // string
  member_id?: string;
  
  // Identifier of the Role to grant to member
  // string
  role_id?: string;
}

// Request arguments for Add/DeleteRoleBindings.
export interface RoleBindingsRequest {
  // URL of the resource to add/remove policy binding to/from.
  // string
  resource_url?: string;
  
  // Role bindings to add/remove to the policy.
  // RoleBinding
  bindings?: RoleBinding[];
}

// List of roles.
export interface RoleList {
  // Role
  items?: Role[];
}

// User represents an actual person.
export interface User {
  // Identifier of the user.
  // This is a read-only value.
  // string
  id?: string;
  
  // Primary email address of the user.
  // All emails send to this user will use this address.
  // This is a read-only value.
  // string
  email?: string;
  
  // Name of the user.
  // This may be empty if not filled out by the user.
  // string
  name?: string;
  
  // Given name of the user.
  // This may be empty if not filled out by the user.
  // string
  given_name?: string;
  
  // Family name of the user.
  // This may be empty if not filled out by the user.
  // string
  family_name?: string;
  
  // The creation timestamp of the user.
  // This is a read-only value.
  // googleTypes.Timestamp
  created_at?: googleTypes.Timestamp;
  
  // Additional email addresses of the user.
  // This will be filled in when the authentication provided
  // knows multiple email addresses for the user.
  // This is a read-only value.
  // string
  additional_emails?: string[];
  
  // Mobile phone number of the user.
  // This value must be unique globally.
  // This field will not be filled, unless:
  // - The currently authenticated user is this user
  // - The currently authenticated user has `iam.user.get-personal-data` permission
  // on the organization that user is a member of.
  // This value can only be changed to a non-empty value.
  // If changed, the new number has to be verified again.
  // string
  mobile_phone?: string;
  
  // Set when the mobile phone number has been successfully verified.
  // This is a read-only value.
  // boolean
  mobile_phone_verified?: boolean;
  
  // Company name of the user
  // This may be empty if not filled out by the user.
  // string
  company_name?: string;
}

// Request arguments for VerifyUserMobilePhone
export interface VerifyUserMobilePhoneRequest {
  // Code that was send to the mobile phone number.
  // string
  code?: string;
}

// IAMService is the API used to configure IAM objects.
export class IAMService {
  // Fetch all available information of the currently authenticated user.
  // Required permissions:
  // - None
  async GetThisUser(req?: arangodb_cloud_common_v1_Empty): Promise<User> {
    const path = `/api/iam/v1/self/user`;
    const url = path + api.queryString(req, []);
    return api.get(url, undefined);
  }
  
  // Fetch all available information of the user identified by the given ID.
  // Required permissions:
  // - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of
  async GetUser(req: arangodb_cloud_common_v1_IDOptions): Promise<User> {
    const path = `/api/iam/v1/users/${encodeURIComponent(req.id || '')}`;
    const url = path + api.queryString(req, [`id`]);
    return api.get(url, undefined);
  }
  
  // Update a user
  // Required permissions:
  // - None if the given user is the authenticated user.
  // or
  // - resourcemanager.organization.get on one of the organizations that the requested user and authenticated user are both a member of and
  // - iam.user.update on organization on one of the organizations that the requested user and authenticated user are both a member of
  async UpdateUser(req: User): Promise<User> {
    const url = `/api/iam/v1/users/${encodeURIComponent(req.id || '')}`;
    return api.patch(url, req);
  }
  
  // Verify the mobile phone number of a user, by provided the unique
  // code that was send to the number.
  // If the code is valid an empty result is returned, otherwise an InvalidArgument error is returned.
  // The authenticated user is always the subject of this request.
  // Required permissions:
  // - None (since the subject is always the authenticated user).
  async VerifyUserMobilePhone(req: VerifyUserMobilePhoneRequest): Promise<void> {
    const url = `/api/iam/v1/user-mobile-phone/verify`;
    return api.post(url, req);
  }
  
  // Resend a verification code to the mobile phone number listed for the
  // authenticated user.
  // Required permissions:
  // - None (since the subject is always the authenticated user).
  async ResendUserMobilePhoneVerification(req?: arangodb_cloud_common_v1_Empty): Promise<void> {
    const url = `/api/iam/v1/user-mobile-phone/resend`;
    return api.post(url, req);
  }
  
  // Fetch all groups of the organization identified by the given context ID.
  // Required permissions:
  // - iam.group.list on organization identified by given context ID.
  async ListGroups(req: arangodb_cloud_common_v1_ListOptions): Promise<GroupList> {
    const path = `/api/iam/v1/organizations/${encodeURIComponent(req.context_id || '')}/groups`;
    const url = path + api.queryString(req, [`context_id`]);
    return api.get(url, undefined);
  }
  
  // Fetch a group by its id.
  // Required permissions:
  // - iam.group.get on organization that owns the group
  async GetGroup(req: arangodb_cloud_common_v1_IDOptions): Promise<Group> {
    const path = `/api/iam/v1/groups/${encodeURIComponent(req.id || '')}`;
    const url = path + api.queryString(req, [`id`]);
    return api.get(url, undefined);
  }
  
  // Create a group
  // Required permissions:
  // - iam.group.create on organization that owns the group
  async CreateGroup(req: Group): Promise<Group> {
    const url = `/api/iam/v1/organizations/${encodeURIComponent(req.organization_id || '')}/groups`;
    return api.post(url, req);
  }
  
  // Update a group
  // Required permissions:
  // - iam.group.update on organization that owns the group
  async UpdateGroup(req: Group): Promise<Group> {
    const url = `/api/iam/v1/groups/${encodeURIComponent(req.id || '')}`;
    return api.patch(url, req);
  }
  
  // Delete a group
  // Required permissions:
  // - iam.group.delete on organization that owns the group
  async DeleteGroup(req: arangodb_cloud_common_v1_IDOptions): Promise<void> {
    const path = `/api/iam/v1/groups/${encodeURIComponent(req.id || '')}`;
    const url = path + api.queryString(req, [`id`]);
    return api.delete(url, undefined);
  }
  
  // List of members of the group identified by the given context ID.
  // Required permissions:
  // - iam.group.get on organization that owns the group
  async ListGroupMembers(req: arangodb_cloud_common_v1_ListOptions): Promise<GroupMemberList> {
    const path = `/api/iam/v1/groups/${encodeURIComponent(req.context_id || '')}/members`;
    const url = path + api.queryString(req, [`context_id`]);
    return api.get(url, undefined);
  }
  
  // Add one or more members to the group identified by given ID.
  // Required permissions:
  // - iam.group.update on organization that owns the group
  async AddGroupMembers(req: GroupMembersRequest): Promise<void> {
    const url = `/api/iam/v1/groups/${encodeURIComponent(req.group_id || '')}/members`;
    return api.post(url, req);
  }
  
  // Remove one or more members from the group identified by given ID.
  // Required permissions:
  // - iam.group.update on organization that owns the group
  async DeleteGroupMembers(req: GroupMembersRequest): Promise<void> {
    const url = `/api/iam/v1/groups/${encodeURIComponent(req.group_id || '')}/members`;
    return api.delete(url, req);
  }
  
  // Is the user identified by the given user ID a member of the group identified by the given group ID.
  // Required permissions:
  // - iam.group.get on organization that owns the group, unless the requested user is identical to the authenticated user.
  // Note that if the identified group does not exist, no is returned.
  async IsMemberOfGroup(req: IsMemberOfGroupRequest): Promise<arangodb_cloud_common_v1_YesOrNo> {
    const path = `/api/iam/v1/groups/${encodeURIComponent(req.group_id || '')}/members/${encodeURIComponent(req.user_id || '')}`;
    const url = path + api.queryString(req, [`group_id`, `user_id`]);
    return api.get(url, undefined);
  }
  
  // Fetch all roles in the organization identified by the given context ID.
  // Required permissions:
  // - iam.role.list on organization identified by given context ID.
  async ListRoles(req: arangodb_cloud_common_v1_ListOptions): Promise<RoleList> {
    const path = `/api/iam/v1/organizations/${encodeURIComponent(req.context_id || '')}/roles`;
    const url = path + api.queryString(req, [`context_id`]);
    return api.get(url, undefined);
  }
  
  // Fetch a role by its id.
  // Required permissions:
  // - iam.role.get on organization that owns the role
  async GetRole(req: arangodb_cloud_common_v1_IDOptions): Promise<Role> {
    const path = `/api/iam/v1/roles/${encodeURIComponent(req.id || '')}`;
    const url = path + api.queryString(req, [`id`]);
    return api.get(url, undefined);
  }
  
  // Create a custom role
  // Required permissions:
  // - iam.role.create on organization that owns the role
  async CreateRole(req: Role): Promise<Role> {
    const url = `/api/iam/v1/organizations/${encodeURIComponent(req.organization_id || '')}/roles`;
    return api.post(url, req);
  }
  
  // Update a custom role
  // Required permissions:
  // - iam.role.update on organization that owns the role
  async UpdateRole(req: Role): Promise<Role> {
    const url = `/api/iam/v1/roles/${encodeURIComponent(req.id || '')}`;
    return api.patch(url, req);
  }
  
  // Delete a custom role
  // Required permissions:
  // - iam.role.delete on organization that owns the role
  async DeleteRole(req: arangodb_cloud_common_v1_IDOptions): Promise<void> {
    const path = `/api/iam/v1/roles/${encodeURIComponent(req.id || '')}`;
    const url = path + api.queryString(req, [`id`]);
    return api.delete(url, undefined);
  }
  
  // Get the policy for a resource identified by given URL.
  // Required permissions:
  // - iam.policy.get on resource identified by the url
  async GetPolicy(req: arangodb_cloud_common_v1_URLOptions): Promise<Policy> {
    const path = `/api/iam/v1/policies`;
    const url = path + api.queryString(req, []);
    return api.get(url, undefined);
  }
  
  // Add one or more RoleBindings to the policy of a resource identified by given URL.
  // Required permissions:
  // - iam.policy.update on resource identified by the url
  async AddRoleBindings(req: RoleBindingsRequest): Promise<Policy> {
    const url = `/api/iam/v1/policies/bindings`;
    return api.post(url, req);
  }
  
  // Remove one or more RoleBindings from the policy of a resource identified by given URL.
  // Required permissions:
  // - iam.policy.update on resource identified by the url
  async DeleteRoleBindings(req: RoleBindingsRequest): Promise<Policy> {
    const url = `/api/iam/v1/policies/bindings`;
    return api.delete(url, req);
  }
  
  // Return the list of permissions that are available to the currently authenticated
  // used for actions on the resource identified by the given URL.
  // Required permissions:
  // - None
  async GetEffectivePermissions(req: arangodb_cloud_common_v1_URLOptions): Promise<PermissionList> {
    const path = `/api/iam/v1/policies/effective-permissions`;
    const url = path + api.queryString(req, []);
    return api.get(url, undefined);
  }
  
  // Does the authenticated user have all of the requested permissions for the resource
  // identified by the given URL?
  // Required permissions:
  // - None
  async HasPermissions(req: HasPermissionsRequest): Promise<arangodb_cloud_common_v1_YesOrNo> {
    const path = `/api/iam/v1/policies/permissions`;
    const url = path + api.queryString(req, []);
    return api.get(url, undefined);
  }
  
  // List all known permissions.
  // Required permissions:
  // - None
  async ListPermissions(req?: arangodb_cloud_common_v1_Empty): Promise<PermissionList> {
    const path = `/api/iam/v1/permissions`;
    const url = path + api.queryString(req, []);
    return api.get(url, undefined);
  }
}
