// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: atomix/database/database.proto

package database

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Database identifier
type DatabaseId struct {
	// name is the name of the database
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// namespace is the namespace to which the database belongs
	Namespace string `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (m *DatabaseId) Reset()         { *m = DatabaseId{} }
func (m *DatabaseId) String() string { return proto.CompactTextString(m) }
func (*DatabaseId) ProtoMessage()    {}
func (*DatabaseId) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{0}
}
func (m *DatabaseId) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DatabaseId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DatabaseId.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DatabaseId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatabaseId.Merge(m, src)
}
func (m *DatabaseId) XXX_Size() int {
	return m.Size()
}
func (m *DatabaseId) XXX_DiscardUnknown() {
	xxx_messageInfo_DatabaseId.DiscardUnknown(m)
}

var xxx_messageInfo_DatabaseId proto.InternalMessageInfo

func (m *DatabaseId) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DatabaseId) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// Database configuration
type Database struct {
	// id is the database identifier
	ID DatabaseId `protobuf:"bytes,1,opt,name=id,proto3" json:"id"`
	// partitions is a list of partitions in the cluster
	Partitions []Partition `protobuf:"bytes,2,rep,name=partitions,proto3" json:"partitions"`
}

func (m *Database) Reset()         { *m = Database{} }
func (m *Database) String() string { return proto.CompactTextString(m) }
func (*Database) ProtoMessage()    {}
func (*Database) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{1}
}
func (m *Database) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Database) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Database.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Database) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Database.Merge(m, src)
}
func (m *Database) XXX_Size() int {
	return m.Size()
}
func (m *Database) XXX_DiscardUnknown() {
	xxx_messageInfo_Database.DiscardUnknown(m)
}

var xxx_messageInfo_Database proto.InternalMessageInfo

func (m *Database) GetID() DatabaseId {
	if m != nil {
		return m.ID
	}
	return DatabaseId{}
}

func (m *Database) GetPartitions() []Partition {
	if m != nil {
		return m.Partitions
	}
	return nil
}

// Database configuration
type DatabaseConfig struct {
	// nodes is a list of database replicas
	Replicas []ReplicaConfig `protobuf:"bytes,1,rep,name=replicas,proto3" json:"replicas"`
	// partitions is a list of partitions owned by the replicas
	Partitions []PartitionId `protobuf:"bytes,2,rep,name=partitions,proto3" json:"partitions"`
}

func (m *DatabaseConfig) Reset()         { *m = DatabaseConfig{} }
func (m *DatabaseConfig) String() string { return proto.CompactTextString(m) }
func (*DatabaseConfig) ProtoMessage()    {}
func (*DatabaseConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{2}
}
func (m *DatabaseConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DatabaseConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DatabaseConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DatabaseConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatabaseConfig.Merge(m, src)
}
func (m *DatabaseConfig) XXX_Size() int {
	return m.Size()
}
func (m *DatabaseConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DatabaseConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DatabaseConfig proto.InternalMessageInfo

func (m *DatabaseConfig) GetReplicas() []ReplicaConfig {
	if m != nil {
		return m.Replicas
	}
	return nil
}

func (m *DatabaseConfig) GetPartitions() []PartitionId {
	if m != nil {
		return m.Partitions
	}
	return nil
}

// Replica configuration
type ReplicaConfig struct {
	// id is the unique member identifier
	ID string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// host is the member host
	Host string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	// api_port is the port to use for the client API
	APIPort int32 `protobuf:"varint,3,opt,name=api_port,json=apiPort,proto3" json:"apiPort"`
	// protocol_port is the port to use for intra-cluster communication
	ProtocolPort int32 `protobuf:"varint,4,opt,name=protocol_port,json=protocolPort,proto3" json:"protocolPort"`
}

func (m *ReplicaConfig) Reset()         { *m = ReplicaConfig{} }
func (m *ReplicaConfig) String() string { return proto.CompactTextString(m) }
func (*ReplicaConfig) ProtoMessage()    {}
func (*ReplicaConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{3}
}
func (m *ReplicaConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReplicaConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReplicaConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReplicaConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReplicaConfig.Merge(m, src)
}
func (m *ReplicaConfig) XXX_Size() int {
	return m.Size()
}
func (m *ReplicaConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ReplicaConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ReplicaConfig proto.InternalMessageInfo

func (m *ReplicaConfig) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *ReplicaConfig) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *ReplicaConfig) GetAPIPort() int32 {
	if m != nil {
		return m.APIPort
	}
	return 0
}

func (m *ReplicaConfig) GetProtocolPort() int32 {
	if m != nil {
		return m.ProtocolPort
	}
	return 0
}

// Partition identifier
type PartitionId struct {
	Partition int32 `protobuf:"varint,1,opt,name=partition,proto3" json:"partition,omitempty"`
}

func (m *PartitionId) Reset()         { *m = PartitionId{} }
func (m *PartitionId) String() string { return proto.CompactTextString(m) }
func (*PartitionId) ProtoMessage()    {}
func (*PartitionId) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{4}
}
func (m *PartitionId) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PartitionId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PartitionId.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PartitionId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionId.Merge(m, src)
}
func (m *PartitionId) XXX_Size() int {
	return m.Size()
}
func (m *PartitionId) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionId.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionId proto.InternalMessageInfo

func (m *PartitionId) GetPartition() int32 {
	if m != nil {
		return m.Partition
	}
	return 0
}

// Partition info
type Partition struct {
	PartitionID PartitionId         `protobuf:"bytes,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id"`
	Endpoints   []PartitionEndpoint `protobuf:"bytes,2,rep,name=endpoints,proto3" json:"endpoints"`
}

func (m *Partition) Reset()         { *m = Partition{} }
func (m *Partition) String() string { return proto.CompactTextString(m) }
func (*Partition) ProtoMessage()    {}
func (*Partition) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{5}
}
func (m *Partition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Partition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Partition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Partition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Partition.Merge(m, src)
}
func (m *Partition) XXX_Size() int {
	return m.Size()
}
func (m *Partition) XXX_DiscardUnknown() {
	xxx_messageInfo_Partition.DiscardUnknown(m)
}

var xxx_messageInfo_Partition proto.InternalMessageInfo

func (m *Partition) GetPartitionID() PartitionId {
	if m != nil {
		return m.PartitionID
	}
	return PartitionId{}
}

func (m *Partition) GetEndpoints() []PartitionEndpoint {
	if m != nil {
		return m.Endpoints
	}
	return nil
}

// Partition endpoint
type PartitionEndpoint struct {
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	Port int32  `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (m *PartitionEndpoint) Reset()         { *m = PartitionEndpoint{} }
func (m *PartitionEndpoint) String() string { return proto.CompactTextString(m) }
func (*PartitionEndpoint) ProtoMessage()    {}
func (*PartitionEndpoint) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{6}
}
func (m *PartitionEndpoint) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PartitionEndpoint) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PartitionEndpoint.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PartitionEndpoint) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionEndpoint.Merge(m, src)
}
func (m *PartitionEndpoint) XXX_Size() int {
	return m.Size()
}
func (m *PartitionEndpoint) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionEndpoint.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionEndpoint proto.InternalMessageInfo

func (m *PartitionEndpoint) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *PartitionEndpoint) GetPort() int32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Gets a database in a namespace
type GetDatabaseRequest struct {
	ID DatabaseId `protobuf:"bytes,1,opt,name=id,proto3" json:"id"`
}

func (m *GetDatabaseRequest) Reset()         { *m = GetDatabaseRequest{} }
func (m *GetDatabaseRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatabaseRequest) ProtoMessage()    {}
func (*GetDatabaseRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{7}
}
func (m *GetDatabaseRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDatabaseRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDatabaseRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDatabaseRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatabaseRequest.Merge(m, src)
}
func (m *GetDatabaseRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDatabaseRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatabaseRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatabaseRequest proto.InternalMessageInfo

func (m *GetDatabaseRequest) GetID() DatabaseId {
	if m != nil {
		return m.ID
	}
	return DatabaseId{}
}

// Returns a database in a namespace
type GetDatabaseResponse struct {
	Database *Database `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
}

func (m *GetDatabaseResponse) Reset()         { *m = GetDatabaseResponse{} }
func (m *GetDatabaseResponse) String() string { return proto.CompactTextString(m) }
func (*GetDatabaseResponse) ProtoMessage()    {}
func (*GetDatabaseResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{8}
}
func (m *GetDatabaseResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDatabaseResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDatabaseResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDatabaseResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatabaseResponse.Merge(m, src)
}
func (m *GetDatabaseResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDatabaseResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatabaseResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatabaseResponse proto.InternalMessageInfo

func (m *GetDatabaseResponse) GetDatabase() *Database {
	if m != nil {
		return m.Database
	}
	return nil
}

// Gets a list of databases in a namespace
type GetDatabasesRequest struct {
	Namespace string `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
}

func (m *GetDatabasesRequest) Reset()         { *m = GetDatabasesRequest{} }
func (m *GetDatabasesRequest) String() string { return proto.CompactTextString(m) }
func (*GetDatabasesRequest) ProtoMessage()    {}
func (*GetDatabasesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{9}
}
func (m *GetDatabasesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDatabasesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDatabasesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDatabasesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatabasesRequest.Merge(m, src)
}
func (m *GetDatabasesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetDatabasesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatabasesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatabasesRequest proto.InternalMessageInfo

func (m *GetDatabasesRequest) GetNamespace() string {
	if m != nil {
		return m.Namespace
	}
	return ""
}

// Returns a list of databases in a namespace
type GetDatabasesResponse struct {
	Databases []Database `protobuf:"bytes,1,rep,name=databases,proto3" json:"databases"`
}

func (m *GetDatabasesResponse) Reset()         { *m = GetDatabasesResponse{} }
func (m *GetDatabasesResponse) String() string { return proto.CompactTextString(m) }
func (*GetDatabasesResponse) ProtoMessage()    {}
func (*GetDatabasesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_ed185fa3c5fe0f10, []int{10}
}
func (m *GetDatabasesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetDatabasesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetDatabasesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetDatabasesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDatabasesResponse.Merge(m, src)
}
func (m *GetDatabasesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetDatabasesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDatabasesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetDatabasesResponse proto.InternalMessageInfo

func (m *GetDatabasesResponse) GetDatabases() []Database {
	if m != nil {
		return m.Databases
	}
	return nil
}

func init() {
	proto.RegisterType((*DatabaseId)(nil), "atomix.database.DatabaseId")
	proto.RegisterType((*Database)(nil), "atomix.database.Database")
	proto.RegisterType((*DatabaseConfig)(nil), "atomix.database.DatabaseConfig")
	proto.RegisterType((*ReplicaConfig)(nil), "atomix.database.ReplicaConfig")
	proto.RegisterType((*PartitionId)(nil), "atomix.database.PartitionId")
	proto.RegisterType((*Partition)(nil), "atomix.database.Partition")
	proto.RegisterType((*PartitionEndpoint)(nil), "atomix.database.PartitionEndpoint")
	proto.RegisterType((*GetDatabaseRequest)(nil), "atomix.database.GetDatabaseRequest")
	proto.RegisterType((*GetDatabaseResponse)(nil), "atomix.database.GetDatabaseResponse")
	proto.RegisterType((*GetDatabasesRequest)(nil), "atomix.database.GetDatabasesRequest")
	proto.RegisterType((*GetDatabasesResponse)(nil), "atomix.database.GetDatabasesResponse")
}

func init() { proto.RegisterFile("atomix/database/database.proto", fileDescriptor_ed185fa3c5fe0f10) }

var fileDescriptor_ed185fa3c5fe0f10 = []byte{
	// 570 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x53, 0x41, 0x6b, 0x13, 0x41,
	0x18, 0xcd, 0x6c, 0xd3, 0x36, 0xfb, 0xa5, 0xb5, 0x3a, 0x2d, 0x65, 0x8d, 0x65, 0x13, 0x56, 0x85,
	0x80, 0x90, 0x62, 0x4a, 0xf1, 0x20, 0x4a, 0x5d, 0xa3, 0x12, 0x50, 0x08, 0xab, 0x82, 0xe0, 0xa1,
	0x4c, 0xb3, 0x63, 0x1c, 0x68, 0x77, 0xc6, 0xdd, 0x51, 0xfc, 0x03, 0xde, 0x3d, 0xf9, 0x0f, 0x3c,
	0xf8, 0x4f, 0x72, 0xec, 0xd1, 0x53, 0x90, 0xe4, 0xd6, 0x5f, 0x21, 0x99, 0xdd, 0x99, 0xec, 0x36,
	0x4d, 0x04, 0x4f, 0xfb, 0xed, 0x7c, 0xef, 0xbd, 0xef, 0xcd, 0x9b, 0x19, 0x70, 0x89, 0xe4, 0x67,
	0xec, 0xeb, 0x7e, 0x48, 0x24, 0x39, 0x21, 0x09, 0x35, 0x45, 0x4b, 0xc4, 0x5c, 0x72, 0xbc, 0x95,
	0xf6, 0x5b, 0x7a, 0xb9, 0xb6, 0x33, 0xe0, 0x03, 0xae, 0x7a, 0xfb, 0xd3, 0x2a, 0x85, 0x79, 0x8f,
	0x01, 0x3a, 0x19, 0xa2, 0x1b, 0x62, 0x0c, 0xe5, 0x88, 0x9c, 0x51, 0x07, 0x35, 0x50, 0xd3, 0x0e,
	0x54, 0x8d, 0xf7, 0xc0, 0x9e, 0x7e, 0x13, 0x41, 0xfa, 0xd4, 0xb1, 0x54, 0x63, 0xb6, 0xe0, 0x7d,
	0x43, 0x50, 0xd1, 0x02, 0xf8, 0x01, 0x58, 0x2c, 0x54, 0xe4, 0x6a, 0xfb, 0x56, 0xeb, 0x92, 0x81,
	0xd6, 0x6c, 0x8e, 0x0f, 0xc3, 0x51, 0xbd, 0x34, 0x1e, 0xd5, 0xad, 0x6e, 0x27, 0xb0, 0x58, 0x88,
	0x8f, 0x00, 0x04, 0x89, 0x25, 0x93, 0x8c, 0x47, 0x89, 0x63, 0x35, 0x56, 0x9a, 0xd5, 0x76, 0x6d,
	0x4e, 0xa0, 0xa7, 0x21, 0x7e, 0x79, 0xca, 0x0f, 0x72, 0x1c, 0xef, 0x07, 0x82, 0x6b, 0x7a, 0xc0,
	0x53, 0x1e, 0x7d, 0x60, 0x03, 0x7c, 0x04, 0x95, 0x98, 0x8a, 0x53, 0xd6, 0x27, 0x89, 0x83, 0x94,
	0xa4, 0x3b, 0x27, 0x19, 0xa4, 0x80, 0x94, 0x91, 0xc9, 0x1a, 0x16, 0xf6, 0xaf, 0xb0, 0xb5, 0xb7,
	0xd8, 0x56, 0x37, 0xbc, 0xc2, 0xd8, 0x4f, 0x04, 0x9b, 0x85, 0x29, 0x78, 0xd7, 0xa4, 0x64, 0xfb,
	0x6b, 0xb9, 0x10, 0x30, 0x94, 0x3f, 0xf2, 0x44, 0x66, 0x19, 0xab, 0x1a, 0xdf, 0x87, 0x0a, 0x11,
	0xec, 0x58, 0xf0, 0x58, 0x3a, 0x2b, 0x0d, 0xd4, 0x5c, 0xf5, 0x77, 0xc7, 0xa3, 0xfa, 0xfa, 0x93,
	0x5e, 0xb7, 0xc7, 0x63, 0x79, 0x31, 0xaa, 0xaf, 0x13, 0xc1, 0xa6, 0x65, 0xa0, 0x0b, 0x7c, 0x08,
	0x9b, 0xea, 0x68, 0xfb, 0xfc, 0x34, 0xe5, 0x95, 0x15, 0xef, 0xfa, 0xc5, 0xa8, 0xbe, 0xa1, 0x1b,
	0x8a, 0x51, 0xf8, 0xf3, 0xee, 0x41, 0x35, 0xb7, 0x91, 0xe9, 0xa9, 0x9b, 0x4d, 0x28, 0xaf, 0xab,
	0xc1, 0x6c, 0xc1, 0xfb, 0x85, 0xc0, 0x36, 0x68, 0xfc, 0x06, 0x36, 0x4c, 0xeb, 0xd8, 0x5c, 0x80,
	0xe5, 0x41, 0x6d, 0x67, 0x37, 0x20, 0x37, 0xb4, 0x13, 0x54, 0x45, 0xce, 0xc1, 0x73, 0xb0, 0x69,
	0x14, 0x0a, 0xce, 0x22, 0xa9, 0xb3, 0xf7, 0x16, 0x4b, 0x3e, 0xcb, 0xa0, 0xd9, 0x09, 0xcc, 0xa8,
	0xde, 0x43, 0xb8, 0x31, 0x87, 0x32, 0x59, 0xa3, 0x5c, 0xd6, 0x18, 0xca, 0x2a, 0x2f, 0x4b, 0xed,
	0x56, 0xd5, 0xde, 0x2b, 0xc0, 0x2f, 0xa8, 0xd4, 0x17, 0x2b, 0xa0, 0x9f, 0x3e, 0xd3, 0x44, 0xfe,
	0xf7, 0x3d, 0xf7, 0x5e, 0xc2, 0x76, 0x41, 0x2e, 0x11, 0x3c, 0x4a, 0x28, 0x3e, 0x84, 0x8a, 0x66,
	0x67, 0xaa, 0x37, 0x17, 0xaa, 0x06, 0x06, 0xea, 0x1d, 0x14, 0xd4, 0x12, 0xed, 0xae, 0xf0, 0x60,
	0xd1, 0xe5, 0x07, 0xfb, 0x16, 0x76, 0x8a, 0xa4, 0xcc, 0xc3, 0x23, 0xb0, 0xb5, 0xb0, 0x7e, 0x2e,
	0x8b, 0x4d, 0xe8, 0x94, 0x0d, 0xa3, 0x3d, 0x44, 0xb0, 0xa5, 0xbb, 0xaf, 0x69, 0xfc, 0x85, 0xf5,
	0x29, 0x7e, 0x07, 0xd5, 0xdc, 0x28, 0x7c, 0x7b, 0x4e, 0x6e, 0x3e, 0xda, 0xda, 0x9d, 0xe5, 0xa0,
	0xcc, 0xec, 0x7b, 0xd8, 0xc8, 0x6f, 0x02, 0x2f, 0x65, 0xe9, 0x60, 0x6a, 0x77, 0xff, 0x81, 0x4a,
	0xc5, 0x7d, 0x67, 0x38, 0x76, 0xd1, 0xf9, 0xd8, 0x45, 0x7f, 0xc6, 0x2e, 0xfa, 0x3e, 0x71, 0x4b,
	0xe7, 0x13, 0xb7, 0xf4, 0x7b, 0xe2, 0x96, 0x4e, 0xd6, 0xd4, 0x8b, 0x39, 0xf8, 0x1b, 0x00, 0x00,
	0xff, 0xff, 0x51, 0x34, 0xbb, 0x6f, 0x7c, 0x05, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DatabaseServiceClient is the client API for DatabaseService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatabaseServiceClient interface {
	// GetDatabase gets a database controlled by the controller
	GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*GetDatabaseResponse, error)
	// GetDatabases gets a list of databases controlled by the controller
	GetDatabases(ctx context.Context, in *GetDatabasesRequest, opts ...grpc.CallOption) (*GetDatabasesResponse, error)
}

type databaseServiceClient struct {
	cc *grpc.ClientConn
}

func NewDatabaseServiceClient(cc *grpc.ClientConn) DatabaseServiceClient {
	return &databaseServiceClient{cc}
}

func (c *databaseServiceClient) GetDatabase(ctx context.Context, in *GetDatabaseRequest, opts ...grpc.CallOption) (*GetDatabaseResponse, error) {
	out := new(GetDatabaseResponse)
	err := c.cc.Invoke(ctx, "/atomix.database.DatabaseService/GetDatabase", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *databaseServiceClient) GetDatabases(ctx context.Context, in *GetDatabasesRequest, opts ...grpc.CallOption) (*GetDatabasesResponse, error) {
	out := new(GetDatabasesResponse)
	err := c.cc.Invoke(ctx, "/atomix.database.DatabaseService/GetDatabases", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatabaseServiceServer is the server API for DatabaseService service.
type DatabaseServiceServer interface {
	// GetDatabase gets a database controlled by the controller
	GetDatabase(context.Context, *GetDatabaseRequest) (*GetDatabaseResponse, error)
	// GetDatabases gets a list of databases controlled by the controller
	GetDatabases(context.Context, *GetDatabasesRequest) (*GetDatabasesResponse, error)
}

// UnimplementedDatabaseServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDatabaseServiceServer struct {
}

func (*UnimplementedDatabaseServiceServer) GetDatabase(ctx context.Context, req *GetDatabaseRequest) (*GetDatabaseResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatabase not implemented")
}
func (*UnimplementedDatabaseServiceServer) GetDatabases(ctx context.Context, req *GetDatabasesRequest) (*GetDatabasesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatabases not implemented")
}

func RegisterDatabaseServiceServer(s *grpc.Server, srv DatabaseServiceServer) {
	s.RegisterService(&_DatabaseService_serviceDesc, srv)
}

func _DatabaseService_GetDatabase_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabaseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseServiceServer).GetDatabase(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/atomix.database.DatabaseService/GetDatabase",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseServiceServer).GetDatabase(ctx, req.(*GetDatabaseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatabaseService_GetDatabases_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatabasesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatabaseServiceServer).GetDatabases(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/atomix.database.DatabaseService/GetDatabases",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatabaseServiceServer).GetDatabases(ctx, req.(*GetDatabasesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DatabaseService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "atomix.database.DatabaseService",
	HandlerType: (*DatabaseServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDatabase",
			Handler:    _DatabaseService_GetDatabase_Handler,
		},
		{
			MethodName: "GetDatabases",
			Handler:    _DatabaseService_GetDatabases_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "atomix/database/database.proto",
}

func (m *DatabaseId) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DatabaseId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Database) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Database) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Database) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Partitions) > 0 {
		for iNdEx := len(m.Partitions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Partitions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDatabase(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ID.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintDatabase(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *DatabaseConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DatabaseConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Partitions) > 0 {
		for iNdEx := len(m.Partitions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Partitions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDatabase(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Replicas) > 0 {
		for iNdEx := len(m.Replicas) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Replicas[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDatabase(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ReplicaConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ReplicaConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ProtocolPort != 0 {
		i = encodeVarintDatabase(dAtA, i, uint64(m.ProtocolPort))
		i--
		dAtA[i] = 0x20
	}
	if m.APIPort != 0 {
		i = encodeVarintDatabase(dAtA, i, uint64(m.APIPort))
		i--
		dAtA[i] = 0x18
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *PartitionId) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PartitionId) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PartitionId) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Partition != 0 {
		i = encodeVarintDatabase(dAtA, i, uint64(m.Partition))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *Partition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Partition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Partition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Endpoints) > 0 {
		for iNdEx := len(m.Endpoints) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Endpoints[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDatabase(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.PartitionID.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintDatabase(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *PartitionEndpoint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PartitionEndpoint) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PartitionEndpoint) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Port != 0 {
		i = encodeVarintDatabase(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDatabaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDatabaseRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDatabaseRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.ID.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintDatabase(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GetDatabaseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDatabaseResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDatabaseResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Database != nil {
		{
			size, err := m.Database.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDatabase(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDatabasesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDatabasesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDatabasesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Namespace) > 0 {
		i -= len(m.Namespace)
		copy(dAtA[i:], m.Namespace)
		i = encodeVarintDatabase(dAtA, i, uint64(len(m.Namespace)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetDatabasesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetDatabasesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetDatabasesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Databases) > 0 {
		for iNdEx := len(m.Databases) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Databases[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDatabase(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func encodeVarintDatabase(dAtA []byte, offset int, v uint64) int {
	offset -= sovDatabase(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *DatabaseId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	return n
}

func (m *Database) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ID.Size()
	n += 1 + l + sovDatabase(uint64(l))
	if len(m.Partitions) > 0 {
		for _, e := range m.Partitions {
			l = e.Size()
			n += 1 + l + sovDatabase(uint64(l))
		}
	}
	return n
}

func (m *DatabaseConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Replicas) > 0 {
		for _, e := range m.Replicas {
			l = e.Size()
			n += 1 + l + sovDatabase(uint64(l))
		}
	}
	if len(m.Partitions) > 0 {
		for _, e := range m.Partitions {
			l = e.Size()
			n += 1 + l + sovDatabase(uint64(l))
		}
	}
	return n
}

func (m *ReplicaConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	if m.APIPort != 0 {
		n += 1 + sovDatabase(uint64(m.APIPort))
	}
	if m.ProtocolPort != 0 {
		n += 1 + sovDatabase(uint64(m.ProtocolPort))
	}
	return n
}

func (m *PartitionId) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Partition != 0 {
		n += 1 + sovDatabase(uint64(m.Partition))
	}
	return n
}

func (m *Partition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.PartitionID.Size()
	n += 1 + l + sovDatabase(uint64(l))
	if len(m.Endpoints) > 0 {
		for _, e := range m.Endpoints {
			l = e.Size()
			n += 1 + l + sovDatabase(uint64(l))
		}
	}
	return n
}

func (m *PartitionEndpoint) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	if m.Port != 0 {
		n += 1 + sovDatabase(uint64(m.Port))
	}
	return n
}

func (m *GetDatabaseRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ID.Size()
	n += 1 + l + sovDatabase(uint64(l))
	return n
}

func (m *GetDatabaseResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Database != nil {
		l = m.Database.Size()
		n += 1 + l + sovDatabase(uint64(l))
	}
	return n
}

func (m *GetDatabasesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Namespace)
	if l > 0 {
		n += 1 + l + sovDatabase(uint64(l))
	}
	return n
}

func (m *GetDatabasesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Databases) > 0 {
		for _, e := range m.Databases {
			l = e.Size()
			n += 1 + l + sovDatabase(uint64(l))
		}
	}
	return n
}

func sovDatabase(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozDatabase(x uint64) (n int) {
	return sovDatabase(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DatabaseId) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseId: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseId: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Database) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Database: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Database: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partitions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Partitions = append(m.Partitions, Partition{})
			if err := m.Partitions[len(m.Partitions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Replicas = append(m.Replicas, ReplicaConfig{})
			if err := m.Replicas[len(m.Replicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partitions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Partitions = append(m.Partitions, PartitionId{})
			if err := m.Partitions[len(m.Partitions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field APIPort", wireType)
			}
			m.APIPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.APIPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProtocolPort", wireType)
			}
			m.ProtocolPort = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ProtocolPort |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PartitionId) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PartitionId: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PartitionId: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Partition", wireType)
			}
			m.Partition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Partition |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Partition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Partition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Partition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PartitionID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Endpoints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Endpoints = append(m.Endpoints, PartitionEndpoint{})
			if err := m.Endpoints[len(m.Endpoints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PartitionEndpoint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PartitionEndpoint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PartitionEndpoint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDatabaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDatabaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDatabaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDatabaseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDatabaseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDatabaseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Database == nil {
				m.Database = &Database{}
			}
			if err := m.Database.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDatabasesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDatabasesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDatabasesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Namespace", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Namespace = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetDatabasesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetDatabasesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetDatabasesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Databases", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDatabase
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDatabase
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Databases = append(m.Databases, Database{})
			if err := m.Databases[len(m.Databases)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDatabase(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthDatabase
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDatabase(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDatabase
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDatabase
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthDatabase
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupDatabase
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthDatabase
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthDatabase        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDatabase          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupDatabase = fmt.Errorf("proto: unexpected end of group")
)
