// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: atomix/primitive/metadata.proto

package primitive

import (
	context "context"
	fmt "fmt"
	database "github.com/atomix/api/proto/atomix/database"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// CreatePrimitiveRequest is a request to create a primitive
type CreatePrimitiveRequest struct {
	Database  database.DatabaseId `protobuf:"bytes,1,opt,name=database,proto3" json:"database"`
	Primitive PrimitiveId         `protobuf:"bytes,2,opt,name=primitive,proto3" json:"primitive"`
	Type      PrimitiveType       `protobuf:"varint,3,opt,name=type,proto3,enum=atomix.primitive.PrimitiveType" json:"type,omitempty"`
}

func (m *CreatePrimitiveRequest) Reset()         { *m = CreatePrimitiveRequest{} }
func (m *CreatePrimitiveRequest) String() string { return proto.CompactTextString(m) }
func (*CreatePrimitiveRequest) ProtoMessage()    {}
func (*CreatePrimitiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{0}
}
func (m *CreatePrimitiveRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreatePrimitiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreatePrimitiveRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreatePrimitiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreatePrimitiveRequest.Merge(m, src)
}
func (m *CreatePrimitiveRequest) XXX_Size() int {
	return m.Size()
}
func (m *CreatePrimitiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreatePrimitiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreatePrimitiveRequest proto.InternalMessageInfo

func (m *CreatePrimitiveRequest) GetDatabase() database.DatabaseId {
	if m != nil {
		return m.Database
	}
	return database.DatabaseId{}
}

func (m *CreatePrimitiveRequest) GetPrimitive() PrimitiveId {
	if m != nil {
		return m.Primitive
	}
	return PrimitiveId{}
}

func (m *CreatePrimitiveRequest) GetType() PrimitiveType {
	if m != nil {
		return m.Type
	}
	return PrimitiveType_UNKNOWN
}

// CreatePrimitiveResponse is a response for creating a primitive
type CreatePrimitiveResponse struct {
	Primitive PrimitiveMetadata `protobuf:"bytes,1,opt,name=primitive,proto3" json:"primitive"`
}

func (m *CreatePrimitiveResponse) Reset()         { *m = CreatePrimitiveResponse{} }
func (m *CreatePrimitiveResponse) String() string { return proto.CompactTextString(m) }
func (*CreatePrimitiveResponse) ProtoMessage()    {}
func (*CreatePrimitiveResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{1}
}
func (m *CreatePrimitiveResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CreatePrimitiveResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CreatePrimitiveResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CreatePrimitiveResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreatePrimitiveResponse.Merge(m, src)
}
func (m *CreatePrimitiveResponse) XXX_Size() int {
	return m.Size()
}
func (m *CreatePrimitiveResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CreatePrimitiveResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CreatePrimitiveResponse proto.InternalMessageInfo

func (m *CreatePrimitiveResponse) GetPrimitive() PrimitiveMetadata {
	if m != nil {
		return m.Primitive
	}
	return PrimitiveMetadata{}
}

// GetPrimitiveRequest is a request for primitive metadata
type GetPrimitiveRequest struct {
	Database  database.DatabaseId `protobuf:"bytes,1,opt,name=database,proto3" json:"database"`
	Primitive PrimitiveId         `protobuf:"bytes,2,opt,name=primitive,proto3" json:"primitive"`
}

func (m *GetPrimitiveRequest) Reset()         { *m = GetPrimitiveRequest{} }
func (m *GetPrimitiveRequest) String() string { return proto.CompactTextString(m) }
func (*GetPrimitiveRequest) ProtoMessage()    {}
func (*GetPrimitiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{2}
}
func (m *GetPrimitiveRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetPrimitiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetPrimitiveRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetPrimitiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPrimitiveRequest.Merge(m, src)
}
func (m *GetPrimitiveRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetPrimitiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPrimitiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPrimitiveRequest proto.InternalMessageInfo

func (m *GetPrimitiveRequest) GetDatabase() database.DatabaseId {
	if m != nil {
		return m.Database
	}
	return database.DatabaseId{}
}

func (m *GetPrimitiveRequest) GetPrimitive() PrimitiveId {
	if m != nil {
		return m.Primitive
	}
	return PrimitiveId{}
}

// GetPrimitiveResponse is a response containing primitive metadata
type GetPrimitiveResponse struct {
	Primitive PrimitiveMetadata `protobuf:"bytes,1,opt,name=primitive,proto3" json:"primitive"`
}

func (m *GetPrimitiveResponse) Reset()         { *m = GetPrimitiveResponse{} }
func (m *GetPrimitiveResponse) String() string { return proto.CompactTextString(m) }
func (*GetPrimitiveResponse) ProtoMessage()    {}
func (*GetPrimitiveResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{3}
}
func (m *GetPrimitiveResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetPrimitiveResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetPrimitiveResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetPrimitiveResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPrimitiveResponse.Merge(m, src)
}
func (m *GetPrimitiveResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetPrimitiveResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPrimitiveResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetPrimitiveResponse proto.InternalMessageInfo

func (m *GetPrimitiveResponse) GetPrimitive() PrimitiveMetadata {
	if m != nil {
		return m.Primitive
	}
	return PrimitiveMetadata{}
}

// GetPrimitivesRequest is a request for primitive metadata
type GetPrimitivesRequest struct {
	Database  *database.DatabaseId `protobuf:"bytes,1,opt,name=database,proto3" json:"database,omitempty"`
	Primitive *PrimitiveId         `protobuf:"bytes,2,opt,name=primitive,proto3" json:"primitive,omitempty"`
	Type      PrimitiveType        `protobuf:"varint,3,opt,name=type,proto3,enum=atomix.primitive.PrimitiveType" json:"type,omitempty"`
}

func (m *GetPrimitivesRequest) Reset()         { *m = GetPrimitivesRequest{} }
func (m *GetPrimitivesRequest) String() string { return proto.CompactTextString(m) }
func (*GetPrimitivesRequest) ProtoMessage()    {}
func (*GetPrimitivesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{4}
}
func (m *GetPrimitivesRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetPrimitivesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetPrimitivesRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetPrimitivesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPrimitivesRequest.Merge(m, src)
}
func (m *GetPrimitivesRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetPrimitivesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPrimitivesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetPrimitivesRequest proto.InternalMessageInfo

func (m *GetPrimitivesRequest) GetDatabase() *database.DatabaseId {
	if m != nil {
		return m.Database
	}
	return nil
}

func (m *GetPrimitivesRequest) GetPrimitive() *PrimitiveId {
	if m != nil {
		return m.Primitive
	}
	return nil
}

func (m *GetPrimitivesRequest) GetType() PrimitiveType {
	if m != nil {
		return m.Type
	}
	return PrimitiveType_UNKNOWN
}

// GetPrimitivesResponse is a response containing primitive metadata
type GetPrimitivesResponse struct {
	Primitives []PrimitiveMetadata `protobuf:"bytes,1,rep,name=primitives,proto3" json:"primitives"`
}

func (m *GetPrimitivesResponse) Reset()         { *m = GetPrimitivesResponse{} }
func (m *GetPrimitivesResponse) String() string { return proto.CompactTextString(m) }
func (*GetPrimitivesResponse) ProtoMessage()    {}
func (*GetPrimitivesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{5}
}
func (m *GetPrimitivesResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetPrimitivesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetPrimitivesResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetPrimitivesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetPrimitivesResponse.Merge(m, src)
}
func (m *GetPrimitivesResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetPrimitivesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetPrimitivesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetPrimitivesResponse proto.InternalMessageInfo

func (m *GetPrimitivesResponse) GetPrimitives() []PrimitiveMetadata {
	if m != nil {
		return m.Primitives
	}
	return nil
}

// PrimitiveMetadata indicates the type and name of a primitive
type PrimitiveMetadata struct {
	Database  database.DatabaseId `protobuf:"bytes,1,opt,name=database,proto3" json:"database"`
	Primitive PrimitiveId         `protobuf:"bytes,2,opt,name=primitive,proto3" json:"primitive"`
	Type      PrimitiveType       `protobuf:"varint,3,opt,name=type,proto3,enum=atomix.primitive.PrimitiveType" json:"type,omitempty"`
}

func (m *PrimitiveMetadata) Reset()         { *m = PrimitiveMetadata{} }
func (m *PrimitiveMetadata) String() string { return proto.CompactTextString(m) }
func (*PrimitiveMetadata) ProtoMessage()    {}
func (*PrimitiveMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{6}
}
func (m *PrimitiveMetadata) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PrimitiveMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PrimitiveMetadata.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PrimitiveMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrimitiveMetadata.Merge(m, src)
}
func (m *PrimitiveMetadata) XXX_Size() int {
	return m.Size()
}
func (m *PrimitiveMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_PrimitiveMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_PrimitiveMetadata proto.InternalMessageInfo

func (m *PrimitiveMetadata) GetDatabase() database.DatabaseId {
	if m != nil {
		return m.Database
	}
	return database.DatabaseId{}
}

func (m *PrimitiveMetadata) GetPrimitive() PrimitiveId {
	if m != nil {
		return m.Primitive
	}
	return PrimitiveId{}
}

func (m *PrimitiveMetadata) GetType() PrimitiveType {
	if m != nil {
		return m.Type
	}
	return PrimitiveType_UNKNOWN
}

// DeletePrimitiveRequest is a request to delete a primitive
type DeletePrimitiveRequest struct {
	Database  database.DatabaseId `protobuf:"bytes,1,opt,name=database,proto3" json:"database"`
	Primitive PrimitiveId         `protobuf:"bytes,2,opt,name=primitive,proto3" json:"primitive"`
}

func (m *DeletePrimitiveRequest) Reset()         { *m = DeletePrimitiveRequest{} }
func (m *DeletePrimitiveRequest) String() string { return proto.CompactTextString(m) }
func (*DeletePrimitiveRequest) ProtoMessage()    {}
func (*DeletePrimitiveRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{7}
}
func (m *DeletePrimitiveRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeletePrimitiveRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeletePrimitiveRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeletePrimitiveRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePrimitiveRequest.Merge(m, src)
}
func (m *DeletePrimitiveRequest) XXX_Size() int {
	return m.Size()
}
func (m *DeletePrimitiveRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePrimitiveRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePrimitiveRequest proto.InternalMessageInfo

func (m *DeletePrimitiveRequest) GetDatabase() database.DatabaseId {
	if m != nil {
		return m.Database
	}
	return database.DatabaseId{}
}

func (m *DeletePrimitiveRequest) GetPrimitive() PrimitiveId {
	if m != nil {
		return m.Primitive
	}
	return PrimitiveId{}
}

// DeletePrimitiveResponse is a response for deleting a primitive
type DeletePrimitiveResponse struct {
	Primitive PrimitiveMetadata `protobuf:"bytes,1,opt,name=primitive,proto3" json:"primitive"`
}

func (m *DeletePrimitiveResponse) Reset()         { *m = DeletePrimitiveResponse{} }
func (m *DeletePrimitiveResponse) String() string { return proto.CompactTextString(m) }
func (*DeletePrimitiveResponse) ProtoMessage()    {}
func (*DeletePrimitiveResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_17e942e8bf58937d, []int{8}
}
func (m *DeletePrimitiveResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DeletePrimitiveResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DeletePrimitiveResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DeletePrimitiveResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeletePrimitiveResponse.Merge(m, src)
}
func (m *DeletePrimitiveResponse) XXX_Size() int {
	return m.Size()
}
func (m *DeletePrimitiveResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DeletePrimitiveResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DeletePrimitiveResponse proto.InternalMessageInfo

func (m *DeletePrimitiveResponse) GetPrimitive() PrimitiveMetadata {
	if m != nil {
		return m.Primitive
	}
	return PrimitiveMetadata{}
}

func init() {
	proto.RegisterType((*CreatePrimitiveRequest)(nil), "atomix.primitive.CreatePrimitiveRequest")
	proto.RegisterType((*CreatePrimitiveResponse)(nil), "atomix.primitive.CreatePrimitiveResponse")
	proto.RegisterType((*GetPrimitiveRequest)(nil), "atomix.primitive.GetPrimitiveRequest")
	proto.RegisterType((*GetPrimitiveResponse)(nil), "atomix.primitive.GetPrimitiveResponse")
	proto.RegisterType((*GetPrimitivesRequest)(nil), "atomix.primitive.GetPrimitivesRequest")
	proto.RegisterType((*GetPrimitivesResponse)(nil), "atomix.primitive.GetPrimitivesResponse")
	proto.RegisterType((*PrimitiveMetadata)(nil), "atomix.primitive.PrimitiveMetadata")
	proto.RegisterType((*DeletePrimitiveRequest)(nil), "atomix.primitive.DeletePrimitiveRequest")
	proto.RegisterType((*DeletePrimitiveResponse)(nil), "atomix.primitive.DeletePrimitiveResponse")
}

func init() { proto.RegisterFile("atomix/primitive/metadata.proto", fileDescriptor_17e942e8bf58937d) }

var fileDescriptor_17e942e8bf58937d = []byte{
	// 448 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x92, 0x4f, 0x2c, 0xc9, 0xcf,
	0xcd, 0xac, 0xd0, 0x2f, 0x28, 0xca, 0xcc, 0xcd, 0x2c, 0xc9, 0x2c, 0x4b, 0xd5, 0xcf, 0x4d, 0x2d,
	0x49, 0x4c, 0x49, 0x2c, 0x49, 0xd4, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0x12, 0x80, 0x28, 0xd0,
	0x83, 0x2b, 0x90, 0x92, 0x83, 0x6a, 0x01, 0x29, 0x4a, 0x4a, 0x2c, 0x4e, 0x85, 0x33, 0x20, 0x3a,
	0xa4, 0x14, 0x30, 0x8c, 0x84, 0xb3, 0xa0, 0x2a, 0x44, 0xd2, 0xf3, 0xd3, 0xf3, 0xc1, 0x4c, 0x7d,
	0x10, 0x0b, 0x22, 0xaa, 0x74, 0x9e, 0x91, 0x4b, 0xcc, 0xb9, 0x28, 0x35, 0xb1, 0x24, 0x35, 0x00,
	0xa6, 0x3e, 0x28, 0xb5, 0xb0, 0x34, 0xb5, 0xb8, 0x44, 0xc8, 0x96, 0x8b, 0x03, 0x66, 0x89, 0x04,
	0xa3, 0x02, 0xa3, 0x06, 0xb7, 0x91, 0xb4, 0x1e, 0xd4, 0x5d, 0x70, 0xcb, 0x5d, 0xa0, 0x0c, 0xcf,
	0x14, 0x27, 0x96, 0x13, 0xf7, 0xe4, 0x19, 0x82, 0xe0, 0x5a, 0x84, 0x1c, 0xb9, 0x38, 0xe1, 0x4e,
	0x90, 0x60, 0x02, 0xeb, 0x97, 0xd5, 0x43, 0xf7, 0x97, 0x1e, 0xdc, 0x56, 0xb8, 0x09, 0x08, 0x5d,
	0x42, 0xc6, 0x5c, 0x2c, 0x25, 0x95, 0x05, 0xa9, 0x12, 0xcc, 0x0a, 0x8c, 0x1a, 0x7c, 0x46, 0xf2,
	0x78, 0x74, 0x87, 0x54, 0x16, 0xa4, 0x06, 0x81, 0x15, 0x2b, 0x25, 0x71, 0x89, 0x63, 0x78, 0xa8,
	0xb8, 0x20, 0x3f, 0xaf, 0x38, 0x55, 0xc8, 0x1d, 0xd9, 0x49, 0x10, 0x2f, 0x29, 0xe3, 0x31, 0xd4,
	0x17, 0x1a, 0x29, 0x18, 0x0e, 0x53, 0x9a, 0xce, 0xc8, 0x25, 0xec, 0x9e, 0x5a, 0x32, 0xf8, 0x82,
	0x4c, 0x29, 0x9e, 0x4b, 0x04, 0xd5, 0x61, 0xd4, 0xf6, 0xfa, 0x71, 0x46, 0x54, 0x1b, 0x8a, 0x61,
	0x7e, 0x37, 0x27, 0xc9, 0xef, 0x48, 0xbe, 0xb6, 0x26, 0xd5, 0xd7, 0xc8, 0x49, 0xc4, 0x92, 0xa4,
	0x24, 0x02, 0xf6, 0x0e, 0x23, 0x3c, 0xa1, 0x88, 0xa2, 0x79, 0x04, 0x1a, 0x56, 0x9e, 0x5c, 0x5c,
	0x70, 0xfd, 0xc5, 0x12, 0x8c, 0x0a, 0xcc, 0xa4, 0x05, 0x16, 0x92, 0x66, 0xa5, 0x53, 0x8c, 0x5c,
	0x82, 0x18, 0xea, 0x86, 0x6a, 0xce, 0x9a, 0xc5, 0xc8, 0x25, 0xe6, 0x92, 0x9a, 0x93, 0x3a, 0x18,
	0xcb, 0x0a, 0x50, 0xb6, 0xc7, 0x70, 0x1b, 0x95, 0xd3, 0xbe, 0xd1, 0x62, 0x66, 0x2e, 0x01, 0xb8,
	0xb2, 0xe0, 0xd4, 0xa2, 0xb2, 0xcc, 0xe4, 0x54, 0xa1, 0x34, 0x2e, 0x7e, 0xb4, 0xf2, 0x46, 0x48,
	0x03, 0xd3, 0x74, 0xec, 0x65, 0xac, 0x94, 0x26, 0x11, 0x2a, 0xa1, 0xbe, 0x88, 0xe5, 0xe2, 0x41,
	0x4e, 0xae, 0x42, 0xaa, 0x98, 0x5a, 0xb1, 0x14, 0x49, 0x52, 0x6a, 0x84, 0x94, 0x41, 0x8d, 0x4f,
	0xe0, 0xe2, 0x45, 0xc9, 0x0d, 0x42, 0x04, 0x34, 0xc2, 0xf2, 0xbd, 0x94, 0x3a, 0x41, 0x75, 0x50,
	0x1b, 0xd2, 0xb8, 0xf8, 0xd1, 0x62, 0x08, 0x5b, 0x40, 0x61, 0x4f, 0x60, 0xd8, 0x02, 0x0a, 0x47,
	0x74, 0x3b, 0x49, 0x9c, 0x78, 0x24, 0xc7, 0x78, 0xe1, 0x91, 0x1c, 0xe3, 0x83, 0x47, 0x72, 0x8c,
	0x13, 0x1e, 0xcb, 0x31, 0x5c, 0x78, 0x2c, 0xc7, 0x70, 0xe3, 0xb1, 0x1c, 0x43, 0x12, 0x1b, 0xb8,
	0xce, 0x33, 0x06, 0x04, 0x00, 0x00, 0xff, 0xff, 0x27, 0x40, 0xc0, 0x73, 0x80, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// PrimitiveServiceClient is the client API for PrimitiveService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PrimitiveServiceClient interface {
	// CreatePrimitive creates a new primitive
	CreatePrimitive(ctx context.Context, in *CreatePrimitiveRequest, opts ...grpc.CallOption) (*CreatePrimitiveResponse, error)
	// GetPrimitive returns a primitive in the system
	GetPrimitive(ctx context.Context, in *GetPrimitiveRequest, opts ...grpc.CallOption) (*GetPrimitiveResponse, error)
	// GetPrimitives returns a list of primitives in the system
	GetPrimitives(ctx context.Context, in *GetPrimitivesRequest, opts ...grpc.CallOption) (*GetPrimitivesResponse, error)
	// DeletePrimitive deletes a primitive
	DeletePrimitive(ctx context.Context, in *DeletePrimitiveRequest, opts ...grpc.CallOption) (*DeletePrimitiveResponse, error)
}

type primitiveServiceClient struct {
	cc *grpc.ClientConn
}

func NewPrimitiveServiceClient(cc *grpc.ClientConn) PrimitiveServiceClient {
	return &primitiveServiceClient{cc}
}

func (c *primitiveServiceClient) CreatePrimitive(ctx context.Context, in *CreatePrimitiveRequest, opts ...grpc.CallOption) (*CreatePrimitiveResponse, error) {
	out := new(CreatePrimitiveResponse)
	err := c.cc.Invoke(ctx, "/atomix.primitive.PrimitiveService/CreatePrimitive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *primitiveServiceClient) GetPrimitive(ctx context.Context, in *GetPrimitiveRequest, opts ...grpc.CallOption) (*GetPrimitiveResponse, error) {
	out := new(GetPrimitiveResponse)
	err := c.cc.Invoke(ctx, "/atomix.primitive.PrimitiveService/GetPrimitive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *primitiveServiceClient) GetPrimitives(ctx context.Context, in *GetPrimitivesRequest, opts ...grpc.CallOption) (*GetPrimitivesResponse, error) {
	out := new(GetPrimitivesResponse)
	err := c.cc.Invoke(ctx, "/atomix.primitive.PrimitiveService/GetPrimitives", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *primitiveServiceClient) DeletePrimitive(ctx context.Context, in *DeletePrimitiveRequest, opts ...grpc.CallOption) (*DeletePrimitiveResponse, error) {
	out := new(DeletePrimitiveResponse)
	err := c.cc.Invoke(ctx, "/atomix.primitive.PrimitiveService/DeletePrimitive", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PrimitiveServiceServer is the server API for PrimitiveService service.
type PrimitiveServiceServer interface {
	// CreatePrimitive creates a new primitive
	CreatePrimitive(context.Context, *CreatePrimitiveRequest) (*CreatePrimitiveResponse, error)
	// GetPrimitive returns a primitive in the system
	GetPrimitive(context.Context, *GetPrimitiveRequest) (*GetPrimitiveResponse, error)
	// GetPrimitives returns a list of primitives in the system
	GetPrimitives(context.Context, *GetPrimitivesRequest) (*GetPrimitivesResponse, error)
	// DeletePrimitive deletes a primitive
	DeletePrimitive(context.Context, *DeletePrimitiveRequest) (*DeletePrimitiveResponse, error)
}

// UnimplementedPrimitiveServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPrimitiveServiceServer struct {
}

func (*UnimplementedPrimitiveServiceServer) CreatePrimitive(ctx context.Context, req *CreatePrimitiveRequest) (*CreatePrimitiveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrimitive not implemented")
}
func (*UnimplementedPrimitiveServiceServer) GetPrimitive(ctx context.Context, req *GetPrimitiveRequest) (*GetPrimitiveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrimitive not implemented")
}
func (*UnimplementedPrimitiveServiceServer) GetPrimitives(ctx context.Context, req *GetPrimitivesRequest) (*GetPrimitivesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrimitives not implemented")
}
func (*UnimplementedPrimitiveServiceServer) DeletePrimitive(ctx context.Context, req *DeletePrimitiveRequest) (*DeletePrimitiveResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrimitive not implemented")
}

func RegisterPrimitiveServiceServer(s *grpc.Server, srv PrimitiveServiceServer) {
	s.RegisterService(&_PrimitiveService_serviceDesc, srv)
}

func _PrimitiveService_CreatePrimitive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrimitiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrimitiveServiceServer).CreatePrimitive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/atomix.primitive.PrimitiveService/CreatePrimitive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrimitiveServiceServer).CreatePrimitive(ctx, req.(*CreatePrimitiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrimitiveService_GetPrimitive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrimitiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrimitiveServiceServer).GetPrimitive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/atomix.primitive.PrimitiveService/GetPrimitive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrimitiveServiceServer).GetPrimitive(ctx, req.(*GetPrimitiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrimitiveService_GetPrimitives_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrimitivesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrimitiveServiceServer).GetPrimitives(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/atomix.primitive.PrimitiveService/GetPrimitives",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrimitiveServiceServer).GetPrimitives(ctx, req.(*GetPrimitivesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrimitiveService_DeletePrimitive_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrimitiveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrimitiveServiceServer).DeletePrimitive(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/atomix.primitive.PrimitiveService/DeletePrimitive",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrimitiveServiceServer).DeletePrimitive(ctx, req.(*DeletePrimitiveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PrimitiveService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "atomix.primitive.PrimitiveService",
	HandlerType: (*PrimitiveServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePrimitive",
			Handler:    _PrimitiveService_CreatePrimitive_Handler,
		},
		{
			MethodName: "GetPrimitive",
			Handler:    _PrimitiveService_GetPrimitive_Handler,
		},
		{
			MethodName: "GetPrimitives",
			Handler:    _PrimitiveService_GetPrimitives_Handler,
		},
		{
			MethodName: "DeletePrimitive",
			Handler:    _PrimitiveService_DeletePrimitive_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "atomix/primitive/metadata.proto",
}

func (m *CreatePrimitiveRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreatePrimitiveRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreatePrimitiveRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		i = encodeVarintMetadata(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x18
	}
	{
		size, err := m.Primitive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Database.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *CreatePrimitiveResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CreatePrimitiveResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CreatePrimitiveResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Primitive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GetPrimitiveRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetPrimitiveRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetPrimitiveRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Primitive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Database.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GetPrimitiveResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetPrimitiveResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetPrimitiveResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Primitive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *GetPrimitivesRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetPrimitivesRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetPrimitivesRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		i = encodeVarintMetadata(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x18
	}
	if m.Primitive != nil {
		{
			size, err := m.Primitive.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetadata(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Database != nil {
		{
			size, err := m.Database.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintMetadata(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetPrimitivesResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetPrimitivesResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetPrimitivesResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Primitives) > 0 {
		for iNdEx := len(m.Primitives) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Primitives[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintMetadata(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *PrimitiveMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PrimitiveMetadata) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PrimitiveMetadata) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Type != 0 {
		i = encodeVarintMetadata(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x18
	}
	{
		size, err := m.Primitive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Database.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *DeletePrimitiveRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeletePrimitiveRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeletePrimitiveRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Primitive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x12
	{
		size, err := m.Database.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *DeletePrimitiveResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeletePrimitiveResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DeletePrimitiveResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	{
		size, err := m.Primitive.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintMetadata(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintMetadata(dAtA []byte, offset int, v uint64) int {
	offset -= sovMetadata(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CreatePrimitiveRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Database.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Primitive.Size()
	n += 1 + l + sovMetadata(uint64(l))
	if m.Type != 0 {
		n += 1 + sovMetadata(uint64(m.Type))
	}
	return n
}

func (m *CreatePrimitiveResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Primitive.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *GetPrimitiveRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Database.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Primitive.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *GetPrimitiveResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Primitive.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *GetPrimitivesRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Database != nil {
		l = m.Database.Size()
		n += 1 + l + sovMetadata(uint64(l))
	}
	if m.Primitive != nil {
		l = m.Primitive.Size()
		n += 1 + l + sovMetadata(uint64(l))
	}
	if m.Type != 0 {
		n += 1 + sovMetadata(uint64(m.Type))
	}
	return n
}

func (m *GetPrimitivesResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Primitives) > 0 {
		for _, e := range m.Primitives {
			l = e.Size()
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	return n
}

func (m *PrimitiveMetadata) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Database.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Primitive.Size()
	n += 1 + l + sovMetadata(uint64(l))
	if m.Type != 0 {
		n += 1 + sovMetadata(uint64(m.Type))
	}
	return n
}

func (m *DeletePrimitiveRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Database.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Primitive.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *DeletePrimitiveResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Primitive.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func sovMetadata(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozMetadata(x uint64) (n int) {
	return sovMetadata(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CreatePrimitiveRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreatePrimitiveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreatePrimitiveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Database.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Primitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= PrimitiveType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CreatePrimitiveResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CreatePrimitiveResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CreatePrimitiveResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Primitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetPrimitiveRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetPrimitiveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetPrimitiveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Database.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Primitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetPrimitiveResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetPrimitiveResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetPrimitiveResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Primitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetPrimitivesRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetPrimitivesRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetPrimitivesRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Database == nil {
				m.Database = &database.DatabaseId{}
			}
			if err := m.Database.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Primitive == nil {
				m.Primitive = &PrimitiveId{}
			}
			if err := m.Primitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= PrimitiveType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetPrimitivesResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetPrimitivesResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetPrimitivesResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitives", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Primitives = append(m.Primitives, PrimitiveMetadata{})
			if err := m.Primitives[len(m.Primitives)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PrimitiveMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PrimitiveMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PrimitiveMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Database.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Primitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= PrimitiveType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeletePrimitiveRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeletePrimitiveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeletePrimitiveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Database.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Primitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeletePrimitiveResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeletePrimitiveResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeletePrimitiveResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Primitive", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMetadata
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Primitive.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetadata(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMetadata
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupMetadata
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthMetadata
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthMetadata        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetadata          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupMetadata = fmt.Errorf("proto: unexpected end of group")
)
