/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta3

import (
	"github.com/atomix/kubernetes-controller/pkg/apis/cloud/v1beta3"
	"github.com/atomix/kubernetes-controller/pkg/clientset/versioned/scheme"
	"k8s.io/client-go/rest"
)

type CloudV1beta3Interface interface {
	RESTClient() rest.Interface
	DatabasesGetter
	PartitionsGetter
	StorageControllersGetter
}

// CloudV1beta3Client is used to interact with features provided by the cloud.atomix.io group.
type CloudV1beta3Client struct {
	restClient rest.Interface
}

func (c *CloudV1beta3Client) Databases(namespace string) DatabaseInterface {
	return newDatabases(c, namespace)
}

func (c *CloudV1beta3Client) Partitions(namespace string) PartitionInterface {
	return newPartitions(c, namespace)
}

func (c *CloudV1beta3Client) StorageControllers(namespace string) StorageControllerInterface {
	return newStorageControllers(c, namespace)
}

// NewForConfig creates a new CloudV1beta3Client for the given config.
func NewForConfig(c *rest.Config) (*CloudV1beta3Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &CloudV1beta3Client{client}, nil
}

// NewForConfigOrDie creates a new CloudV1beta3Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *CloudV1beta3Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new CloudV1beta3Client for the given RESTClient.
func New(c rest.Interface) *CloudV1beta3Client {
	return &CloudV1beta3Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1beta3.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *CloudV1beta3Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
