/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta3 "github.com/atomix/kubernetes-controller/pkg/apis/cloud/v1beta3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakePartitions implements PartitionInterface
type FakePartitions struct {
	Fake *FakeCloudV1beta3
	ns   string
}

var partitionsResource = schema.GroupVersionResource{Group: "cloud.atomix.io", Version: "v1beta3", Resource: "partitions"}

var partitionsKind = schema.GroupVersionKind{Group: "cloud.atomix.io", Version: "v1beta3", Kind: "Partition"}

// Get takes name of the partition, and returns the corresponding partition object, and an error if there is any.
func (c *FakePartitions) Get(name string, options v1.GetOptions) (result *v1beta3.Partition, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(partitionsResource, c.ns, name), &v1beta3.Partition{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.Partition), err
}

// List takes label and field selectors, and returns the list of Partitions that match those selectors.
func (c *FakePartitions) List(opts v1.ListOptions) (result *v1beta3.PartitionList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(partitionsResource, partitionsKind, c.ns, opts), &v1beta3.PartitionList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta3.PartitionList{ListMeta: obj.(*v1beta3.PartitionList).ListMeta}
	for _, item := range obj.(*v1beta3.PartitionList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested partitions.
func (c *FakePartitions) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(partitionsResource, c.ns, opts))

}

// Create takes the representation of a partition and creates it.  Returns the server's representation of the partition, and an error, if there is any.
func (c *FakePartitions) Create(partition *v1beta3.Partition) (result *v1beta3.Partition, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(partitionsResource, c.ns, partition), &v1beta3.Partition{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.Partition), err
}

// Update takes the representation of a partition and updates it. Returns the server's representation of the partition, and an error, if there is any.
func (c *FakePartitions) Update(partition *v1beta3.Partition) (result *v1beta3.Partition, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(partitionsResource, c.ns, partition), &v1beta3.Partition{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.Partition), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakePartitions) UpdateStatus(partition *v1beta3.Partition) (*v1beta3.Partition, error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceAction(partitionsResource, "status", c.ns, partition), &v1beta3.Partition{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.Partition), err
}

// Delete takes name of the partition and deletes it. Returns an error if one occurs.
func (c *FakePartitions) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(partitionsResource, c.ns, name), &v1beta3.Partition{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePartitions) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(partitionsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta3.PartitionList{})
	return err
}

// Patch applies the patch and returns the patched partition.
func (c *FakePartitions) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta3.Partition, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(partitionsResource, c.ns, name, pt, data, subresources...), &v1beta3.Partition{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.Partition), err
}
