/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta3 "github.com/atomix/kubernetes-controller/pkg/apis/cloud/v1beta3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeStorageControllers implements StorageControllerInterface
type FakeStorageControllers struct {
	Fake *FakeCloudV1beta3
	ns   string
}

var storagecontrollersResource = schema.GroupVersionResource{Group: "cloud.atomix.io", Version: "v1beta3", Resource: "storagecontrollers"}

var storagecontrollersKind = schema.GroupVersionKind{Group: "cloud.atomix.io", Version: "v1beta3", Kind: "StorageController"}

// Get takes name of the storageController, and returns the corresponding storageController object, and an error if there is any.
func (c *FakeStorageControllers) Get(name string, options v1.GetOptions) (result *v1beta3.StorageController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(storagecontrollersResource, c.ns, name), &v1beta3.StorageController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.StorageController), err
}

// List takes label and field selectors, and returns the list of StorageControllers that match those selectors.
func (c *FakeStorageControllers) List(opts v1.ListOptions) (result *v1beta3.StorageControllerList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(storagecontrollersResource, storagecontrollersKind, c.ns, opts), &v1beta3.StorageControllerList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta3.StorageControllerList{ListMeta: obj.(*v1beta3.StorageControllerList).ListMeta}
	for _, item := range obj.(*v1beta3.StorageControllerList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested storageControllers.
func (c *FakeStorageControllers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(storagecontrollersResource, c.ns, opts))

}

// Create takes the representation of a storageController and creates it.  Returns the server's representation of the storageController, and an error, if there is any.
func (c *FakeStorageControllers) Create(storageController *v1beta3.StorageController) (result *v1beta3.StorageController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(storagecontrollersResource, c.ns, storageController), &v1beta3.StorageController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.StorageController), err
}

// Update takes the representation of a storageController and updates it. Returns the server's representation of the storageController, and an error, if there is any.
func (c *FakeStorageControllers) Update(storageController *v1beta3.StorageController) (result *v1beta3.StorageController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(storagecontrollersResource, c.ns, storageController), &v1beta3.StorageController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.StorageController), err
}

// Delete takes name of the storageController and deletes it. Returns an error if one occurs.
func (c *FakeStorageControllers) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(storagecontrollersResource, c.ns, name), &v1beta3.StorageController{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeStorageControllers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(storagecontrollersResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta3.StorageControllerList{})
	return err
}

// Patch applies the patch and returns the patched storageController.
func (c *FakeStorageControllers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta3.StorageController, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(storagecontrollersResource, c.ns, name, pt, data, subresources...), &v1beta3.StorageController{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta3.StorageController), err
}
