/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta3

import (
	"time"

	scheme "github.com/atomix/kubernetes-controller/pkg/clientset/versioned/scheme"
	v1beta3 "github.com/atomix/kubernetes-controller/pkg/apis/cloud/v1beta3"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// StorageControllersGetter has a method to return a StorageControllerInterface.
// A group's client should implement this interface.
type StorageControllersGetter interface {
	StorageControllers(namespace string) StorageControllerInterface
}

// StorageControllerInterface has methods to work with StorageController resources.
type StorageControllerInterface interface {
	Create(*v1beta3.StorageController) (*v1beta3.StorageController, error)
	Update(*v1beta3.StorageController) (*v1beta3.StorageController, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1beta3.StorageController, error)
	List(opts v1.ListOptions) (*v1beta3.StorageControllerList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta3.StorageController, err error)
	StorageControllerExpansion
}

// storageControllers implements StorageControllerInterface
type storageControllers struct {
	client rest.Interface
	ns     string
}

// newStorageControllers returns a StorageControllers
func newStorageControllers(c *CloudV1beta3Client, namespace string) *storageControllers {
	return &storageControllers{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the storageController, and returns the corresponding storageController object, and an error if there is any.
func (c *storageControllers) Get(name string, options v1.GetOptions) (result *v1beta3.StorageController, err error) {
	result = &v1beta3.StorageController{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("storagecontrollers").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of StorageControllers that match those selectors.
func (c *storageControllers) List(opts v1.ListOptions) (result *v1beta3.StorageControllerList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta3.StorageControllerList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("storagecontrollers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested storageControllers.
func (c *storageControllers) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("storagecontrollers").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a storageController and creates it.  Returns the server's representation of the storageController, and an error, if there is any.
func (c *storageControllers) Create(storageController *v1beta3.StorageController) (result *v1beta3.StorageController, err error) {
	result = &v1beta3.StorageController{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("storagecontrollers").
		Body(storageController).
		Do().
		Into(result)
	return
}

// Update takes the representation of a storageController and updates it. Returns the server's representation of the storageController, and an error, if there is any.
func (c *storageControllers) Update(storageController *v1beta3.StorageController) (result *v1beta3.StorageController, err error) {
	result = &v1beta3.StorageController{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("storagecontrollers").
		Name(storageController.Name).
		Body(storageController).
		Do().
		Into(result)
	return
}

// Delete takes name of the storageController and deletes it. Returns an error if one occurs.
func (c *storageControllers) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("storagecontrollers").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *storageControllers) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("storagecontrollers").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched storageController.
func (c *storageControllers) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta3.StorageController, err error) {
	result = &v1beta3.StorageController{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("storagecontrollers").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
