# Project governance

This document lays out the guidelines under which the AWS Controllers for Kubernetes (ACK) project will be governed. 
The goal is to make sure that the roles and responsibilities are well defined and clarify on how decisions are made.

## Roles

In the context of ACK, we consider the following roles:

* __Users__ ... everyone using ACK, typically willing to provide feedback on ACK by proposing features and/or filing issues.
* __Contributors__ ... everyone contributing code, documentation, examples, testing infra, and participating in feature proposals as well as design discussions. Code contributions will require a Developer Certificate of Origin (DCO).
*	__Maintainers__ ... are responsible for engaging with and assisting contributors to iterate on the contributions until it reaches acceptable quality. Maintainers can decide whether the contributions can be accepted into the project or rejected. Any active contributor meeting the project quality can be made a Maintainer by the Advisory Board.
*	__Advisory Board__ ... is responsible for defining the guidelines and processes that the project operates under. 

The initial members of the Advisory Board are `@jaypipes` and `@mhausenblas`.


## Communication

The primary mechanism for communication will be via the `#provider-aws` channel on the Kubernetes Slack community. 
All features and bug fixes will be tracked as issues in GitHub. All decisions will be documented in GitHub issues.

In the future, we may consider using a public mailing list, which can be better archived. 

## Roadmap Planning

Maintainers will share roadmap and release versions as milestones in GitHub. 

## Release Management

The Advisory Board will propose a release management proposal via a GitHub issue and resolve it there.

## Other relevant governance resources

* The ACK [Contributing Guidelines](CONTRIBUTING.md)
* Our [Code of Conduct](CODE_OF_CONDUCT.md)
