package olm

import opsv1alpha1 "github.com/operator-framework/api/pkg/operators/v1alpha1"

var (
	capabilityBasicInstall     = "basic install"
	capabilitySeamlessUpgrades = "seamless upgrades"
	capabilityFullLifecucle    = "full lifecycle"
	capabilityDeepInsights     = "deep insights"
	capabilityAutoPilot        = "auto pilot"

	mediatypeGIF = "image/gif"
	mediatypeJPG = "image/jpeg"
	mediatypePNG = "image/png"
	mediatypeSVG = "image/svg+xml"
)

// ServiceConfig represents a service controller's OLM configuration
// input.
type ServiceConfig struct {
	Annotations Annotations `json:"annotations"`
	Samples     []Sample    `json:"samples"`
	opsv1alpha1.ClusterServiceVersionSpec
}

// CommonMetadata represents common metadata for all service controllers
// generated by this project.
type CommonMetadata struct {
	Links    []opsv1alpha1.AppLink `json:"links"`
	Keywords []string              `json:"keywords"`
}

// CommonLinks are links that are likely to be common across service
// controllers.
var CommonLinks = []opsv1alpha1.AppLink{
	{
		Name: "AWS Controllers for Kubernetes",
		URL:  "https://github.com/aws-controllers-k8s/community",
	},
	{
		Name: "Documentation",
		URL:  "https://aws-controllers-k8s.github.io/community/",
	},
}

// CommonKeywords are keywords that are likely to be common across
// service controllers.
var CommonKeywords = []string{
	"aws",
	"amazon",
	"ack",
}

// Annotations represent metadata that is added to the ClusterServiceVersion
// yaml. These keys inform the OLM graphical user interface.
type Annotations struct {
	CapabilityLevel    string `json:"capabilityLevel"`
	SuggestedNamespace string `json:"suggestedNamespace"`
	Repository         string `json:"repository"`
	ContainerImage     string `json:"containerImage"`
	ShortDescription   string `json:"shortDescription"`
	Support            string `json:"support"`
	IsCertified        bool   `json:"isCertified"`
}

// Sample is a basic representation of an instance of custom resource
// managed by a given service controller.
type Sample struct {
	Kind        string `json:"kind"`
	Spec        string `json:"spec"`
	DisplayName string `json:"displayName"`
	Description string `json:"description"`
}
