// Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//	http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta1 "github.com/aws/aws-app-mesh-controller-for-k8s/pkg/apis/appmesh/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeMeshes implements MeshInterface
type FakeMeshes struct {
	Fake *FakeAppmeshV1beta1
}

var meshesResource = schema.GroupVersionResource{Group: "appmesh.k8s.aws", Version: "v1beta1", Resource: "meshes"}

var meshesKind = schema.GroupVersionKind{Group: "appmesh.k8s.aws", Version: "v1beta1", Kind: "Mesh"}

// Get takes name of the mesh, and returns the corresponding mesh object, and an error if there is any.
func (c *FakeMeshes) Get(name string, options v1.GetOptions) (result *v1beta1.Mesh, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(meshesResource, name), &v1beta1.Mesh{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Mesh), err
}

// List takes label and field selectors, and returns the list of Meshes that match those selectors.
func (c *FakeMeshes) List(opts v1.ListOptions) (result *v1beta1.MeshList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(meshesResource, meshesKind, opts), &v1beta1.MeshList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.MeshList{ListMeta: obj.(*v1beta1.MeshList).ListMeta}
	for _, item := range obj.(*v1beta1.MeshList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested meshes.
func (c *FakeMeshes) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(meshesResource, opts))
}

// Create takes the representation of a mesh and creates it.  Returns the server's representation of the mesh, and an error, if there is any.
func (c *FakeMeshes) Create(mesh *v1beta1.Mesh) (result *v1beta1.Mesh, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(meshesResource, mesh), &v1beta1.Mesh{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Mesh), err
}

// Update takes the representation of a mesh and updates it. Returns the server's representation of the mesh, and an error, if there is any.
func (c *FakeMeshes) Update(mesh *v1beta1.Mesh) (result *v1beta1.Mesh, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(meshesResource, mesh), &v1beta1.Mesh{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Mesh), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeMeshes) UpdateStatus(mesh *v1beta1.Mesh) (*v1beta1.Mesh, error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceAction(meshesResource, "status", mesh), &v1beta1.Mesh{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Mesh), err
}

// Delete takes name of the mesh and deletes it. Returns an error if one occurs.
func (c *FakeMeshes) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteAction(meshesResource, name), &v1beta1.Mesh{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeMeshes) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(meshesResource, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta1.MeshList{})
	return err
}

// Patch applies the patch and returns the patched mesh.
func (c *FakeMeshes) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta1.Mesh, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(meshesResource, name, pt, data, subresources...), &v1beta1.Mesh{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.Mesh), err
}
