// Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
//	http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.
// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "github.com/aws/aws-app-mesh-controller-for-k8s/pkg/apis/appmesh/v1beta1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// MeshLister helps list Meshes.
type MeshLister interface {
	// List lists all Meshes in the indexer.
	List(selector labels.Selector) (ret []*v1beta1.Mesh, err error)
	// Get retrieves the Mesh from the index for a given name.
	Get(name string) (*v1beta1.Mesh, error)
	MeshListerExpansion
}

// meshLister implements the MeshLister interface.
type meshLister struct {
	indexer cache.Indexer
}

// NewMeshLister returns a new MeshLister.
func NewMeshLister(indexer cache.Indexer) MeshLister {
	return &meshLister{indexer: indexer}
}

// List lists all Meshes in the indexer.
func (s *meshLister) List(selector labels.Selector) (ret []*v1beta1.Mesh, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta1.Mesh))
	})
	return ret, err
}

// Get retrieves the Mesh from the index for a given name.
func (s *meshLister) Get(name string) (*v1beta1.Mesh, error) {
	obj, exists, err := s.indexer.GetByKey(name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta1.Resource("mesh"), name)
	}
	return obj.(*v1beta1.Mesh), nil
}
