// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Confirms a job worker has received the specified job. Used for partner actions
// only.
func (c *Client) AcknowledgeThirdPartyJob(ctx context.Context, params *AcknowledgeThirdPartyJobInput, optFns ...func(*Options)) (*AcknowledgeThirdPartyJobOutput, error) {
	if params == nil {
		params = &AcknowledgeThirdPartyJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AcknowledgeThirdPartyJob", params, optFns, addOperationAcknowledgeThirdPartyJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AcknowledgeThirdPartyJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of an AcknowledgeThirdPartyJob action.
type AcknowledgeThirdPartyJobInput struct {

	// The clientToken portion of the clientId and clientToken pair used to verify that
	// the calling entity is allowed access to the job and its details.
	//
	// This member is required.
	ClientToken *string

	// The unique system-generated ID of the job.
	//
	// This member is required.
	JobId *string

	// A system-generated random number that AWS CodePipeline uses to ensure that the
	// job is being worked on by only one job worker. Get this number from the response
	// to a GetThirdPartyJobDetails request.
	//
	// This member is required.
	Nonce *string
}

// Represents the output of an AcknowledgeThirdPartyJob action.
type AcknowledgeThirdPartyJobOutput struct {

	// The status information for the third party job, if any.
	Status types.JobStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationAcknowledgeThirdPartyJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpAcknowledgeThirdPartyJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpAcknowledgeThirdPartyJob{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	addOpAcknowledgeThirdPartyJobValidationMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opAcknowledgeThirdPartyJob(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opAcknowledgeThirdPartyJob(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "AcknowledgeThirdPartyJob",
	}
}
