// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Removes the connection between the webhook that was created by CodePipeline and
// the external tool with events to be detected. Currently supported only for
// webhooks that target an action type of GitHub.
func (c *Client) DeregisterWebhookWithThirdParty(ctx context.Context, params *DeregisterWebhookWithThirdPartyInput, optFns ...func(*Options)) (*DeregisterWebhookWithThirdPartyOutput, error) {
	if params == nil {
		params = &DeregisterWebhookWithThirdPartyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeregisterWebhookWithThirdParty", params, optFns, addOperationDeregisterWebhookWithThirdPartyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeregisterWebhookWithThirdPartyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeregisterWebhookWithThirdPartyInput struct {

	// The name of the webhook you want to deregister.
	WebhookName *string
}

type DeregisterWebhookWithThirdPartyOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationDeregisterWebhookWithThirdPartyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDeregisterWebhookWithThirdParty{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDeregisterWebhookWithThirdParty{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opDeregisterWebhookWithThirdParty(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opDeregisterWebhookWithThirdParty(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "DeregisterWebhookWithThirdParty",
	}
}
