// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Prevents artifacts in a pipeline from transitioning to the next stage in the
// pipeline.
func (c *Client) DisableStageTransition(ctx context.Context, params *DisableStageTransitionInput, optFns ...func(*Options)) (*DisableStageTransitionOutput, error) {
	if params == nil {
		params = &DisableStageTransitionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisableStageTransition", params, optFns, addOperationDisableStageTransitionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisableStageTransitionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a DisableStageTransition action.
type DisableStageTransitionInput struct {

	// The name of the pipeline in which you want to disable the flow of artifacts from
	// one stage to another.
	//
	// This member is required.
	PipelineName *string

	// The reason given to the user that a stage is disabled, such as waiting for
	// manual approval or manual tests. This message is displayed in the pipeline
	// console UI.
	//
	// This member is required.
	Reason *string

	// The name of the stage where you want to disable the inbound or outbound
	// transition of artifacts.
	//
	// This member is required.
	StageName *string

	// Specifies whether artifacts are prevented from transitioning into the stage and
	// being processed by the actions in that stage (inbound), or prevented from
	// transitioning from the stage after they have been processed by the actions in
	// that stage (outbound).
	//
	// This member is required.
	TransitionType types.StageTransitionType
}

type DisableStageTransitionOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationDisableStageTransitionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDisableStageTransition{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDisableStageTransition{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	addOpDisableStageTransitionValidationMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opDisableStageTransition(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opDisableStageTransition(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "DisableStageTransition",
	}
}
