// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Returns information about an execution of a pipeline, including details about
// artifacts, the pipeline execution ID, and the name, version, and status of the
// pipeline.
func (c *Client) GetPipelineExecution(ctx context.Context, params *GetPipelineExecutionInput, optFns ...func(*Options)) (*GetPipelineExecutionOutput, error) {
	if params == nil {
		params = &GetPipelineExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPipelineExecution", params, optFns, addOperationGetPipelineExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPipelineExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a GetPipelineExecution action.
type GetPipelineExecutionInput struct {

	// The ID of the pipeline execution about which you want to get execution details.
	//
	// This member is required.
	PipelineExecutionId *string

	// The name of the pipeline about which you want to get execution details.
	//
	// This member is required.
	PipelineName *string
}

// Represents the output of a GetPipelineExecution action.
type GetPipelineExecutionOutput struct {

	// Represents information about the execution of a pipeline.
	PipelineExecution *types.PipelineExecution

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationGetPipelineExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetPipelineExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetPipelineExecution{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	addOpGetPipelineExecutionValidationMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opGetPipelineExecution(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opGetPipelineExecution(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "GetPipelineExecution",
	}
}
