// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Requests the details of a job for a third party action. Used for partner actions
// only. When this API is called, AWS CodePipeline returns temporary credentials
// for the S3 bucket used to store artifacts for the pipeline, if the action
// requires access to that S3 bucket for input or output artifacts. This API also
// returns any secret values defined for the action.
func (c *Client) GetThirdPartyJobDetails(ctx context.Context, params *GetThirdPartyJobDetailsInput, optFns ...func(*Options)) (*GetThirdPartyJobDetailsOutput, error) {
	if params == nil {
		params = &GetThirdPartyJobDetailsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetThirdPartyJobDetails", params, optFns, addOperationGetThirdPartyJobDetailsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetThirdPartyJobDetailsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a GetThirdPartyJobDetails action.
type GetThirdPartyJobDetailsInput struct {

	// The clientToken portion of the clientId and clientToken pair used to verify that
	// the calling entity is allowed access to the job and its details.
	//
	// This member is required.
	ClientToken *string

	// The unique system-generated ID used for identifying the job.
	//
	// This member is required.
	JobId *string
}

// Represents the output of a GetThirdPartyJobDetails action.
type GetThirdPartyJobDetailsOutput struct {

	// The details of the job, including any protected values defined for the job.
	JobDetails *types.ThirdPartyJobDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationGetThirdPartyJobDetailsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetThirdPartyJobDetails{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetThirdPartyJobDetails{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	addOpGetThirdPartyJobDetailsValidationMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opGetThirdPartyJobDetails(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opGetThirdPartyJobDetails(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "GetThirdPartyJobDetails",
	}
}
