// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Gets a summary of all AWS CodePipeline action types associated with your
// account.
func (c *Client) ListActionTypes(ctx context.Context, params *ListActionTypesInput, optFns ...func(*Options)) (*ListActionTypesOutput, error) {
	if params == nil {
		params = &ListActionTypesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListActionTypes", params, optFns, addOperationListActionTypesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListActionTypesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a ListActionTypes action.
type ListActionTypesInput struct {

	// Filters the list of action types to those created by a specified entity.
	ActionOwnerFilter types.ActionOwner

	// An identifier that was returned from the previous list action types call, which
	// can be used to return the next set of action types in the list.
	NextToken *string
}

// Represents the output of a ListActionTypes action.
type ListActionTypesOutput struct {

	// Provides details of the action types.
	//
	// This member is required.
	ActionTypes []*types.ActionType

	// If the amount of returned information is significantly large, an identifier is
	// also returned. It can be used in a subsequent list action types call to return
	// the next set of action types in the list.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationListActionTypesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListActionTypes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListActionTypes{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opListActionTypes(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opListActionTypes(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "ListActionTypes",
	}
}
