// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Gets a summary of the most recent executions for a pipeline.
func (c *Client) ListPipelineExecutions(ctx context.Context, params *ListPipelineExecutionsInput, optFns ...func(*Options)) (*ListPipelineExecutionsOutput, error) {
	if params == nil {
		params = &ListPipelineExecutionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPipelineExecutions", params, optFns, addOperationListPipelineExecutionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPipelineExecutionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a ListPipelineExecutions action.
type ListPipelineExecutionsInput struct {

	// The name of the pipeline for which you want to get execution summary
	// information.
	//
	// This member is required.
	PipelineName *string

	// The maximum number of results to return in a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value. Pipeline
	// history is limited to the most recent 12 months, based on pipeline execution
	// start times. Default value is 100.
	MaxResults *int32

	// The token that was returned from the previous ListPipelineExecutions call, which
	// can be used to return the next set of pipeline executions in the list.
	NextToken *string
}

// Represents the output of a ListPipelineExecutions action.
type ListPipelineExecutionsOutput struct {

	// A token that can be used in the next ListPipelineExecutions call. To view all
	// items in the list, continue to call this operation with each subsequent token
	// until no more nextToken values are returned.
	NextToken *string

	// A list of executions in the history of a pipeline.
	PipelineExecutionSummaries []*types.PipelineExecutionSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationListPipelineExecutionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListPipelineExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListPipelineExecutions{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	addOpListPipelineExecutionsValidationMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opListPipelineExecutions(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opListPipelineExecutions(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "ListPipelineExecutions",
	}
}
