// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Returns information about any jobs for AWS CodePipeline to act on. PollForJobs
// is valid only for action types with "Custom" in the owner field. If the action
// type contains "AWS" or "ThirdParty" in the owner field, the PollForJobs action
// returns an error. When this API is called, AWS CodePipeline returns temporary
// credentials for the S3 bucket used to store artifacts for the pipeline, if the
// action requires access to that S3 bucket for input or output artifacts. This API
// also returns any secret values defined for the action.
func (c *Client) PollForJobs(ctx context.Context, params *PollForJobsInput, optFns ...func(*Options)) (*PollForJobsOutput, error) {
	if params == nil {
		params = &PollForJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PollForJobs", params, optFns, addOperationPollForJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PollForJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a PollForJobs action.
type PollForJobsInput struct {

	// Represents information about an action type.
	//
	// This member is required.
	ActionTypeId *types.ActionTypeId

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int32

	// A map of property names and values. For an action type with no queryable
	// properties, this value must be null or an empty map. For an action type with a
	// queryable property, you must supply that property as a key in the map. Only jobs
	// whose action configuration matches the mapped value are returned.
	QueryParam map[string]*string
}

// Represents the output of a PollForJobs action.
type PollForJobsOutput struct {

	// Information about the jobs to take action on.
	Jobs []*types.Job

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationPollForJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPollForJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPollForJobs{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	addOpPollForJobsValidationMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opPollForJobs(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opPollForJobs(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "PollForJobs",
	}
}
