// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
)

// Determines whether there are any third party jobs for a job worker to act on.
// Used for partner actions only. When this API is called, AWS CodePipeline returns
// temporary credentials for the S3 bucket used to store artifacts for the
// pipeline, if the action requires access to that S3 bucket for input or output
// artifacts.
func (c *Client) PollForThirdPartyJobs(ctx context.Context, params *PollForThirdPartyJobsInput, optFns ...func(*Options)) (*PollForThirdPartyJobsOutput, error) {
	if params == nil {
		params = &PollForThirdPartyJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PollForThirdPartyJobs", params, optFns, addOperationPollForThirdPartyJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PollForThirdPartyJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a PollForThirdPartyJobs action.
type PollForThirdPartyJobsInput struct {

	// Represents information about an action type.
	//
	// This member is required.
	ActionTypeId *types.ActionTypeId

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int32
}

// Represents the output of a PollForThirdPartyJobs action.
type PollForThirdPartyJobsOutput struct {

	// Information about the jobs to take action on.
	Jobs []*types.ThirdPartyJob

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationPollForThirdPartyJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPollForThirdPartyJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPollForThirdPartyJobs{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	addOpPollForThirdPartyJobsValidationMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opPollForThirdPartyJobs(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opPollForThirdPartyJobs(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "PollForThirdPartyJobs",
	}
}
