// Code generated by smithy-go-codegen DO NOT EDIT.

package codepipeline

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/codepipeline/types"
	"github.com/awslabs/smithy-go/middleware"
	smithyhttp "github.com/awslabs/smithy-go/transport/http"
	"time"
)

// Provides the response to a manual approval request to AWS CodePipeline. Valid
// responses include Approved and Rejected.
func (c *Client) PutApprovalResult(ctx context.Context, params *PutApprovalResultInput, optFns ...func(*Options)) (*PutApprovalResultOutput, error) {
	if params == nil {
		params = &PutApprovalResultInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutApprovalResult", params, optFns, addOperationPutApprovalResultMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutApprovalResultOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input of a PutApprovalResult action.
type PutApprovalResultInput struct {

	// The name of the action for which approval is requested.
	//
	// This member is required.
	ActionName *string

	// The name of the pipeline that contains the action.
	//
	// This member is required.
	PipelineName *string

	// Represents information about the result of the approval request.
	//
	// This member is required.
	Result *types.ApprovalResult

	// The name of the stage that contains the action.
	//
	// This member is required.
	StageName *string

	// The system-generated token used to identify a unique approval request. The token
	// for each open approval request can be obtained using the GetPipelineState
	// action. It is used to validate that the approval request corresponding to this
	// token is still valid.
	//
	// This member is required.
	Token *string
}

// Represents the output of a PutApprovalResult action.
type PutApprovalResultOutput struct {

	// The timestamp showing when the approval or rejection was submitted.
	ApprovedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata
}

func addOperationPutApprovalResultMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpPutApprovalResult{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpPutApprovalResult{}, middleware.After)
	if err != nil {
		return err
	}
	awsmiddleware.AddRequestInvocationIDMiddleware(stack)
	smithyhttp.AddContentLengthMiddleware(stack)
	addResolveEndpointMiddleware(stack, options)
	v4.AddComputePayloadSHA256Middleware(stack)
	addRetryMiddlewares(stack, options)
	addHTTPSignerV4Middleware(stack, options)
	awsmiddleware.AddAttemptClockSkewMiddleware(stack)
	addClientUserAgent(stack)
	smithyhttp.AddErrorCloseResponseBodyMiddleware(stack)
	smithyhttp.AddCloseResponseBodyMiddleware(stack)
	addOpPutApprovalResultValidationMiddleware(stack)
	stack.Initialize.Add(newServiceMetadataMiddleware_opPutApprovalResult(options.Region), middleware.Before)
	addRequestIDRetrieverMiddleware(stack)
	addResponseErrorMiddleware(stack)
	return nil
}

func newServiceMetadataMiddleware_opPutApprovalResult(region string) awsmiddleware.RegisterServiceMetadata {
	return awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "codepipeline",
		OperationName: "PutApprovalResult",
	}
}
