/**
 * Copyright 2012 Microsoft Corporation
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.microsoft.windowsazure.services.table.implementation;

import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DefaultXMLStreamFactory implements XMLStreamFactory {
    private final XMLOutputFactory xmlOutputFactory;
    private final XMLInputFactory xmlInputFactory;

    public DefaultXMLStreamFactory() {
        this.xmlOutputFactory = XMLOutputFactory.newInstance();
        this.xmlInputFactory = XMLInputFactory.newInstance();
    }

    @Override
    public XMLStreamWriter getWriter(OutputStream stream) {
        try {
            return xmlOutputFactory.createXMLStreamWriter(stream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public XMLStreamReader getReader(InputStream stream) {
        try {
            return xmlInputFactory.createXMLStreamReader(stream);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }
}
