/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.models.ApiError;
import com.microsoft.azure.management.compute.models.ApiErrorBase;
import com.microsoft.azure.management.compute.models.ComputeLongRunningOperationResponse;
import com.microsoft.azure.management.compute.models.ComputeOperationStatus;
import com.microsoft.azure.management.compute.models.DeleteOperationResponse;
import com.microsoft.azure.management.compute.models.InnerError;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceClient;
import com.microsoft.windowsazure.credentials.SubscriptionCloudCredentials;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
* The Compute Management Client.
*/
public class ComputeManagementClientImpl extends ServiceClient<ComputeManagementClient> implements ComputeManagementClient {
    private String apiVersion;
    
    /**
    * Gets the API version.
    * @return The ApiVersion value.
    */
    public String getApiVersion() {
        return this.apiVersion;
    }
    
    private URI baseUri;
    
    /**
    * Gets the URI used as the base for all cloud service requests.
    * @return The BaseUri value.
    */
    public URI getBaseUri() {
        return this.baseUri;
    }
    
    private SubscriptionCloudCredentials credentials;
    
    /**
    * Gets subscription credentials which uniquely identify Microsoft Azure
    * subscription. The subscription ID forms part of the URI for every
    * service call.
    * @return The Credentials value.
    */
    public SubscriptionCloudCredentials getCredentials() {
        return this.credentials;
    }
    
    private int longRunningOperationInitialTimeout;
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @return The LongRunningOperationInitialTimeout value.
    */
    public int getLongRunningOperationInitialTimeout() {
        return this.longRunningOperationInitialTimeout;
    }
    
    /**
    * Gets or sets the initial timeout for Long Running Operations.
    * @param longRunningOperationInitialTimeoutValue The
    * LongRunningOperationInitialTimeout value.
    */
    public void setLongRunningOperationInitialTimeout(final int longRunningOperationInitialTimeoutValue) {
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeoutValue;
    }
    
    private int longRunningOperationRetryTimeout;
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @return The LongRunningOperationRetryTimeout value.
    */
    public int getLongRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }
    
    /**
    * Gets or sets the retry timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeoutValue The
    * LongRunningOperationRetryTimeout value.
    */
    public void setLongRunningOperationRetryTimeout(final int longRunningOperationRetryTimeoutValue) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeoutValue;
    }
    
    private AvailabilitySetOperations availabilitySets;
    
    /**
    * Operations for managing the availability sets in compute management.
    * @return The AvailabilitySetsOperations value.
    */
    public AvailabilitySetOperations getAvailabilitySetsOperations() {
        return this.availabilitySets;
    }
    
    private UsageOperations usage;
    
    /**
    * Operations for listing usage.
    * @return The UsageOperations value.
    */
    public UsageOperations getUsageOperations() {
        return this.usage;
    }
    
    private VirtualMachineExtensionImageOperations virtualMachineExtensionImages;
    
    /**
    * Operations for managing the virtual machine extension images in compute
    * management.
    * @return The VirtualMachineExtensionImagesOperations value.
    */
    public VirtualMachineExtensionImageOperations getVirtualMachineExtensionImagesOperations() {
        return this.virtualMachineExtensionImages;
    }
    
    private VirtualMachineExtensionOperations virtualMachineExtensions;
    
    /**
    * Operations for managing the virtual machine extensions in compute
    * management.
    * @return The VirtualMachineExtensionsOperations value.
    */
    public VirtualMachineExtensionOperations getVirtualMachineExtensionsOperations() {
        return this.virtualMachineExtensions;
    }
    
    private VirtualMachineImageOperations virtualMachineImages;
    
    /**
    * Operations for managing the virtual machine images in compute management.
    * @return The VirtualMachineImagesOperations value.
    */
    public VirtualMachineImageOperations getVirtualMachineImagesOperations() {
        return this.virtualMachineImages;
    }
    
    private VirtualMachineOperations virtualMachines;
    
    /**
    * Operations for managing the virtual machines in compute management.
    * @return The VirtualMachinesOperations value.
    */
    public VirtualMachineOperations getVirtualMachinesOperations() {
        return this.virtualMachines;
    }
    
    private VirtualMachineSizeOperations virtualMachineSizes;
    
    /**
    * Operations for listing virtual machine sizes available in a region.
    * @return The VirtualMachineSizesOperations value.
    */
    public VirtualMachineSizeOperations getVirtualMachineSizesOperations() {
        return this.virtualMachineSizes;
    }
    
    /**
    * Initializes a new instance of the ComputeManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    */
    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        super(httpBuilder, executorService);
        this.availabilitySets = new AvailabilitySetOperationsImpl(this);
        this.usage = new UsageOperationsImpl(this);
        this.virtualMachineExtensionImages = new VirtualMachineExtensionImageOperationsImpl(this);
        this.virtualMachineExtensions = new VirtualMachineExtensionOperationsImpl(this);
        this.virtualMachineImages = new VirtualMachineImageOperationsImpl(this);
        this.virtualMachines = new VirtualMachineOperationsImpl(this);
        this.virtualMachineSizes = new VirtualMachineSizeOperationsImpl(this);
        this.apiVersion = "2015-06-15";
        this.longRunningOperationInitialTimeout = -1;
        this.longRunningOperationRetryTimeout = -1;
    }
    
    /**
    * Initializes a new instance of the ComputeManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @param baseUri Optional. Gets the URI used as the base for all cloud
    * service requests.
    */
    @Inject
    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, @Named(ManagementConfiguration.SUBSCRIPTION_CLOUD_CREDENTIALS) SubscriptionCloudCredentials credentials, @Named(ManagementConfiguration.URI) URI baseUri) {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        } else {
            this.credentials = credentials;
        }
        if (baseUri == null) {
            try {
                this.baseUri = new URI("https://management.azure.com");
            }
            catch (URISyntaxException ex) {
            }
        } else {
            this.baseUri = baseUri;
        }
    }
    
    /**
    * Initializes a new instance of the ComputeManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    */
    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials) throws URISyntaxException {
        this(httpBuilder, executorService);
        if (credentials == null) {
            throw new NullPointerException("credentials");
        }
        this.credentials = credentials;
        this.baseUri = new URI("https://management.azure.com");
    }
    
    /**
    * Initializes a new instance of the ComputeManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    * @param credentials Required. Gets subscription credentials which uniquely
    * identify Microsoft Azure subscription. The subscription ID forms part of
    * the URI for every service call.
    * @param baseUri Optional. Gets the URI used as the base for all cloud
    * service requests.
    * @param apiVersion Optional. Gets the API version.
    * @param longRunningOperationInitialTimeout Required. Gets or sets the
    * initial timeout for Long Running Operations.
    * @param longRunningOperationRetryTimeout Required. Gets or sets the retry
    * timeout for Long Running Operations.
    */
    public ComputeManagementClientImpl(HttpClientBuilder httpBuilder, ExecutorService executorService, SubscriptionCloudCredentials credentials, URI baseUri, String apiVersion, int longRunningOperationInitialTimeout, int longRunningOperationRetryTimeout) {
        this(httpBuilder, executorService);
        this.credentials = credentials;
        this.baseUri = baseUri;
        this.apiVersion = apiVersion;
        this.longRunningOperationInitialTimeout = longRunningOperationInitialTimeout;
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
    }
    
    /**
    * Initializes a new instance of the ComputeManagementClientImpl class.
    *
    * @param httpBuilder The HTTP client builder.
    * @param executorService The executor service.
    */
    protected ComputeManagementClientImpl newInstance(HttpClientBuilder httpBuilder, ExecutorService executorService) {
        return new ComputeManagementClientImpl(httpBuilder, executorService, this.getCredentials(), this.getBaseUri(), this.getApiVersion(), this.getLongRunningOperationInitialTimeout(), this.getLongRunningOperationRetryTimeout());
    }
    
    /**
    * The Get Delete Operation Status operation returns the status of the
    * specified operation. After calling an asynchronous operation, you can
    * call GetDeleteOperationStatus to determine whether the operation has
    * succeeded, failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return The compute long running operation response.
    */
    @Override
    public Future<DeleteOperationResponse> getDeleteOperationStatusAsync(final String operationStatusLink) {
        return this.getExecutorService().submit(new Callable<DeleteOperationResponse>() { 
            @Override
            public DeleteOperationResponse call() throws Exception {
                return getDeleteOperationStatus(operationStatusLink);
            }
         });
    }
    
    /**
    * The Get Delete Operation Status operation returns the status of the
    * specified operation. After calling an asynchronous operation, you can
    * call GetDeleteOperationStatus to determine whether the operation has
    * succeeded, failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    @Override
    public DeleteOperationResponse getDeleteOperationStatus(String operationStatusLink) throws IOException, ServiceException {
        // Validate
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter(invocationId, this, "getDeleteOperationStatusAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeleteOperationResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_ACCEPTED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new DeleteOperationResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode operationIdValue = responseDoc.get("operationId");
                    if (operationIdValue != null && operationIdValue instanceof NullNode == false) {
                        String operationIdInstance;
                        operationIdInstance = operationIdValue.getTextValue();
                        result.setTrackingOperationId(operationIdInstance);
                    }
                    
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && statusValue instanceof NullNode == false) {
                        OperationStatus statusInstance;
                        statusInstance = Enum.valueOf(OperationStatus.class, statusValue.getTextValue());
                        result.setStatus(statusInstance);
                    }
                    
                    JsonNode startTimeValue = responseDoc.get("startTime");
                    if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                        Calendar startTimeInstance;
                        startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                        result.setStartTime(startTimeInstance);
                    }
                    
                    JsonNode endTimeValue = responseDoc.get("endTime");
                    if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                        Calendar endTimeInstance;
                        endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                        result.setEndTime(endTimeInstance);
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        ApiError errorInstance = new ApiError();
                        result.setError(errorInstance);
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ApiErrorBase apiErrorBaseInstance = new ApiErrorBase();
                                errorInstance.getDetails().add(apiErrorBaseInstance);
                                
                                JsonNode codeValue = detailsValue.get("code");
                                if (codeValue != null && codeValue instanceof NullNode == false) {
                                    String codeInstance;
                                    codeInstance = codeValue.getTextValue();
                                    apiErrorBaseInstance.setCode(codeInstance);
                                }
                                
                                JsonNode targetValue = detailsValue.get("target");
                                if (targetValue != null && targetValue instanceof NullNode == false) {
                                    String targetInstance;
                                    targetInstance = targetValue.getTextValue();
                                    apiErrorBaseInstance.setTarget(targetInstance);
                                }
                                
                                JsonNode messageValue = detailsValue.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    apiErrorBaseInstance.setMessage(messageInstance);
                                }
                            }
                        }
                        
                        JsonNode innererrorValue = errorValue.get("innererror");
                        if (innererrorValue != null && innererrorValue instanceof NullNode == false) {
                            InnerError innererrorInstance = new InnerError();
                            errorInstance.setInnerError(innererrorInstance);
                            
                            JsonNode exceptiontypeValue = innererrorValue.get("exceptiontype");
                            if (exceptiontypeValue != null && exceptiontypeValue instanceof NullNode == false) {
                                String exceptiontypeInstance;
                                exceptiontypeInstance = exceptiontypeValue.getTextValue();
                                innererrorInstance.setExceptionType(exceptiontypeInstance);
                            }
                            
                            JsonNode errordetailValue = innererrorValue.get("errordetail");
                            if (errordetailValue != null && errordetailValue instanceof NullNode == false) {
                                String errordetailInstance;
                                errordetailInstance = errordetailValue.getTextValue();
                                innererrorInstance.setErrorDetail(errordetailInstance);
                            }
                        }
                        
                        JsonNode codeValue2 = errorValue.get("code");
                        if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                            String codeInstance2;
                            codeInstance2 = codeValue2.getTextValue();
                            errorInstance.setCode(codeInstance2);
                        }
                        
                        JsonNode targetValue2 = errorValue.get("target");
                        if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                            String targetInstance2;
                            targetInstance2 = targetValue2.getTextValue();
                            errorInstance.setTarget(targetInstance2);
                        }
                        
                        JsonNode messageValue2 = errorValue.get("message");
                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                            String messageInstance2;
                            messageInstance2 = messageValue2.getTextValue();
                            errorInstance.setMessage(messageInstance2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call
    * GetLongRunningOperationStatus to determine whether the operation has
    * succeeded, failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public Future<ComputeLongRunningOperationResponse> getLongRunningOperationStatusAsync(final String operationStatusLink) {
        return this.getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>() { 
            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return getLongRunningOperationStatus(operationStatusLink);
            }
         });
    }
    
    /**
    * The Get Operation Status operation returns the status of the specified
    * operation. After calling an asynchronous operation, you can call
    * GetLongRunningOperationStatus to determine whether the operation has
    * succeeded, failed, or is still in progress.
    *
    * @param operationStatusLink Required. Location value returned by the Begin
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public ComputeLongRunningOperationResponse getLongRunningOperationStatus(String operationStatusLink) throws IOException, ServiceException {
        // Validate
        if (operationStatusLink == null) {
            throw new NullPointerException("operationStatusLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("operationStatusLink", operationStatusLink);
            CloudTracing.enter(invocationId, this, "getLongRunningOperationStatusAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + operationStatusLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ComputeLongRunningOperationResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_ACCEPTED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new ComputeLongRunningOperationResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode operationIdValue = responseDoc.get("operationId");
                    if (operationIdValue != null && operationIdValue instanceof NullNode == false) {
                        String operationIdInstance;
                        operationIdInstance = operationIdValue.getTextValue();
                        result.setTrackingOperationId(operationIdInstance);
                    }
                    
                    JsonNode statusValue = responseDoc.get("status");
                    if (statusValue != null && statusValue instanceof NullNode == false) {
                        ComputeOperationStatus statusInstance;
                        statusInstance = Enum.valueOf(ComputeOperationStatus.class, statusValue.getTextValue());
                        result.setStatus(statusInstance);
                    }
                    
                    JsonNode startTimeValue = responseDoc.get("startTime");
                    if (startTimeValue != null && startTimeValue instanceof NullNode == false) {
                        Calendar startTimeInstance;
                        startTimeInstance = DatatypeConverter.parseDateTime(startTimeValue.getTextValue());
                        result.setStartTime(startTimeInstance);
                    }
                    
                    JsonNode endTimeValue = responseDoc.get("endTime");
                    if (endTimeValue != null && endTimeValue instanceof NullNode == false) {
                        Calendar endTimeInstance;
                        endTimeInstance = DatatypeConverter.parseDateTime(endTimeValue.getTextValue());
                        result.setEndTime(endTimeInstance);
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode outputValue = propertiesValue.get("output");
                        if (outputValue != null && outputValue instanceof NullNode == false) {
                            String outputInstance;
                            outputInstance = outputValue.getTextValue();
                            result.setOutput(outputInstance);
                        }
                    }
                    
                    JsonNode errorValue = responseDoc.get("error");
                    if (errorValue != null && errorValue instanceof NullNode == false) {
                        ApiError errorInstance = new ApiError();
                        result.setError(errorInstance);
                        
                        JsonNode detailsArray = errorValue.get("details");
                        if (detailsArray != null && detailsArray instanceof NullNode == false) {
                            for (JsonNode detailsValue : ((ArrayNode) detailsArray)) {
                                ApiErrorBase apiErrorBaseInstance = new ApiErrorBase();
                                errorInstance.getDetails().add(apiErrorBaseInstance);
                                
                                JsonNode codeValue = detailsValue.get("code");
                                if (codeValue != null && codeValue instanceof NullNode == false) {
                                    String codeInstance;
                                    codeInstance = codeValue.getTextValue();
                                    apiErrorBaseInstance.setCode(codeInstance);
                                }
                                
                                JsonNode targetValue = detailsValue.get("target");
                                if (targetValue != null && targetValue instanceof NullNode == false) {
                                    String targetInstance;
                                    targetInstance = targetValue.getTextValue();
                                    apiErrorBaseInstance.setTarget(targetInstance);
                                }
                                
                                JsonNode messageValue = detailsValue.get("message");
                                if (messageValue != null && messageValue instanceof NullNode == false) {
                                    String messageInstance;
                                    messageInstance = messageValue.getTextValue();
                                    apiErrorBaseInstance.setMessage(messageInstance);
                                }
                            }
                        }
                        
                        JsonNode innererrorValue = errorValue.get("innererror");
                        if (innererrorValue != null && innererrorValue instanceof NullNode == false) {
                            InnerError innererrorInstance = new InnerError();
                            errorInstance.setInnerError(innererrorInstance);
                            
                            JsonNode exceptiontypeValue = innererrorValue.get("exceptiontype");
                            if (exceptiontypeValue != null && exceptiontypeValue instanceof NullNode == false) {
                                String exceptiontypeInstance;
                                exceptiontypeInstance = exceptiontypeValue.getTextValue();
                                innererrorInstance.setExceptionType(exceptiontypeInstance);
                            }
                            
                            JsonNode errordetailValue = innererrorValue.get("errordetail");
                            if (errordetailValue != null && errordetailValue instanceof NullNode == false) {
                                String errordetailInstance;
                                errordetailInstance = errordetailValue.getTextValue();
                                innererrorInstance.setErrorDetail(errordetailInstance);
                            }
                        }
                        
                        JsonNode codeValue2 = errorValue.get("code");
                        if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                            String codeInstance2;
                            codeInstance2 = codeValue2.getTextValue();
                            errorInstance.setCode(codeInstance2);
                        }
                        
                        JsonNode targetValue2 = errorValue.get("target");
                        if (targetValue2 != null && targetValue2 instanceof NullNode == false) {
                            String targetInstance2;
                            targetInstance2 = targetValue2.getTextValue();
                            errorInstance.setTarget(targetInstance2);
                        }
                        
                        JsonNode messageValue2 = errorValue.get("message");
                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                            String messageInstance2;
                            messageInstance2 = messageValue2.getTextValue();
                            errorInstance.setMessage(messageInstance2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
