/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.models.DataDiskImage;
import com.microsoft.azure.management.compute.models.OSDiskImage;
import com.microsoft.azure.management.compute.models.PurchasePlan;
import com.microsoft.azure.management.compute.models.VirtualMachineImage;
import com.microsoft.azure.management.compute.models.VirtualMachineImageGetParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageGetResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListOffersParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListPublishersParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListSkusParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResource;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResourceList;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing the virtual machine images in compute management.
*/
public class VirtualMachineImageOperationsImpl implements ServiceOperations<ComputeManagementClientImpl>, VirtualMachineImageOperations {
    /**
    * Initializes a new instance of the VirtualMachineImageOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    VirtualMachineImageOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }
    
    private ComputeManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.compute.ComputeManagementClientImpl.
    * @return The Client value.
    */
    public ComputeManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Gets a virtual machine image.
    *
    * @param parameters Optional.
    * @return The get vm image operation response.
    */
    @Override
    public Future<VirtualMachineImageGetResponse> getAsync(final VirtualMachineImageGetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageGetResponse>() { 
            @Override
            public VirtualMachineImageGetResponse call() throws Exception {
                return get(parameters);
            }
         });
    }
    
    /**
    * Gets a virtual machine image.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The get vm image operation response.
    */
    @Override
    public VirtualMachineImageGetResponse get(VirtualMachineImageGetParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getOffer() == null) {
                throw new NullPointerException("parameters.Offer");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
            if (parameters.getSkus() == null) {
                throw new NullPointerException("parameters.Skus");
            }
            if (parameters.getVersion() == null) {
                throw new NullPointerException("parameters.Version");
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmimage/offers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getOffer(), "UTF-8");
        }
        url = url + "/skus/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getSkus(), "UTF-8");
        }
        url = url + "/versions/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getVersion(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineImageGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualMachineImage virtualMachineImageInstance = new VirtualMachineImage();
                    result.setVirtualMachineImage(virtualMachineImageInstance);
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode planValue = propertiesValue.get("plan");
                        if (planValue != null && planValue instanceof NullNode == false) {
                            PurchasePlan planInstance = new PurchasePlan();
                            virtualMachineImageInstance.setPurchasePlan(planInstance);
                            
                            JsonNode publisherValue = planValue.get("publisher");
                            if (publisherValue != null && publisherValue instanceof NullNode == false) {
                                String publisherInstance;
                                publisherInstance = publisherValue.getTextValue();
                                planInstance.setPublisher(publisherInstance);
                            }
                            
                            JsonNode nameValue = planValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                planInstance.setName(nameInstance);
                            }
                            
                            JsonNode productValue = planValue.get("product");
                            if (productValue != null && productValue instanceof NullNode == false) {
                                String productInstance;
                                productInstance = productValue.getTextValue();
                                planInstance.setProduct(productInstance);
                            }
                        }
                        
                        JsonNode osDiskImageValue = propertiesValue.get("osDiskImage");
                        if (osDiskImageValue != null && osDiskImageValue instanceof NullNode == false) {
                            OSDiskImage osDiskImageInstance = new OSDiskImage();
                            virtualMachineImageInstance.setOSDiskImage(osDiskImageInstance);
                            
                            JsonNode operatingSystemValue = osDiskImageValue.get("operatingSystem");
                            if (operatingSystemValue != null && operatingSystemValue instanceof NullNode == false) {
                                String operatingSystemInstance;
                                operatingSystemInstance = operatingSystemValue.getTextValue();
                                osDiskImageInstance.setOperatingSystem(operatingSystemInstance);
                            }
                        }
                        
                        JsonNode dataDiskImagesArray = propertiesValue.get("dataDiskImages");
                        if (dataDiskImagesArray != null && dataDiskImagesArray instanceof NullNode == false) {
                            for (JsonNode dataDiskImagesValue : ((ArrayNode) dataDiskImagesArray)) {
                                DataDiskImage dataDiskImageInstance = new DataDiskImage();
                                virtualMachineImageInstance.getDataDiskImages().add(dataDiskImageInstance);
                                
                                JsonNode lunValue = dataDiskImagesValue.get("lun");
                                if (lunValue != null && lunValue instanceof NullNode == false) {
                                    int lunInstance;
                                    lunInstance = lunValue.getIntValue();
                                    dataDiskImageInstance.setLun(lunInstance);
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue = responseDoc.get("id");
                    if (idValue != null && idValue instanceof NullNode == false) {
                        String idInstance;
                        idInstance = idValue.getTextValue();
                        virtualMachineImageInstance.setId(idInstance);
                    }
                    
                    JsonNode nameValue2 = responseDoc.get("name");
                    if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                        String nameInstance2;
                        nameInstance2 = nameValue2.getTextValue();
                        virtualMachineImageInstance.setName(nameInstance2);
                    }
                    
                    JsonNode locationValue = responseDoc.get("location");
                    if (locationValue != null && locationValue instanceof NullNode == false) {
                        String locationInstance;
                        locationInstance = locationValue.getTextValue();
                        virtualMachineImageInstance.setLocation(locationInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a list of virtual machine images.
    *
    * @param parameters Optional.
    * @return A list of virtual machine image resource information.
    */
    @Override
    public Future<VirtualMachineImageResourceList> listAsync(final VirtualMachineImageListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>() { 
            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return list(parameters);
            }
         });
    }
    
    /**
    * Gets a list of virtual machine images.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A list of virtual machine image resource information.
    */
    @Override
    public VirtualMachineImageResourceList list(VirtualMachineImageListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getOffer() == null) {
                throw new NullPointerException("parameters.Offer");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
            if (parameters.getSkus() == null) {
                throw new NullPointerException("parameters.Skus");
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmimage/offers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getOffer(), "UTF-8");
        }
        url = url + "/skus/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getSkus(), "UTF-8");
        }
        url = url + "/versions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (parameters != null && parameters.getFilterExpression() != null) {
            queryParameters.add(parameters.getFilterExpression());
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineImageResourceList result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode resourcesArray = responseDoc;
                    if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                        for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                            VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                            result.getResources().add(virtualMachineImageResourceInstance);
                            
                            JsonNode idValue = resourcesValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                virtualMachineImageResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = resourcesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                virtualMachineImageResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode locationValue = resourcesValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualMachineImageResourceInstance.setLocation(locationInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a list of virtual machine image offers.
    *
    * @param parameters Optional.
    * @return A list of virtual machine image resource information.
    */
    @Override
    public Future<VirtualMachineImageResourceList> listOffersAsync(final VirtualMachineImageListOffersParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>() { 
            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return listOffers(parameters);
            }
         });
    }
    
    /**
    * Gets a list of virtual machine image offers.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A list of virtual machine image resource information.
    */
    @Override
    public VirtualMachineImageResourceList listOffers(VirtualMachineImageListOffersParameters parameters) throws IOException, ServiceException {
        // Validate
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listOffersAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmimage/offers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineImageResourceList result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode resourcesArray = responseDoc;
                    if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                        for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                            VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                            result.getResources().add(virtualMachineImageResourceInstance);
                            
                            JsonNode idValue = resourcesValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                virtualMachineImageResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = resourcesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                virtualMachineImageResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode locationValue = resourcesValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualMachineImageResourceInstance.setLocation(locationInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a list of virtual machine image publishers.
    *
    * @param parameters Optional.
    * @return A list of virtual machine image resource information.
    */
    @Override
    public Future<VirtualMachineImageResourceList> listPublishersAsync(final VirtualMachineImageListPublishersParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>() { 
            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return listPublishers(parameters);
            }
         });
    }
    
    /**
    * Gets a list of virtual machine image publishers.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A list of virtual machine image resource information.
    */
    @Override
    public VirtualMachineImageResourceList listPublishers(VirtualMachineImageListPublishersParameters parameters) throws IOException, ServiceException {
        // Validate
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listPublishersAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineImageResourceList result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode resourcesArray = responseDoc;
                    if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                        for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                            VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                            result.getResources().add(virtualMachineImageResourceInstance);
                            
                            JsonNode idValue = resourcesValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                virtualMachineImageResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = resourcesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                virtualMachineImageResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode locationValue = resourcesValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualMachineImageResourceInstance.setLocation(locationInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a list of virtual machine image skus.
    *
    * @param parameters Optional.
    * @return A list of virtual machine image resource information.
    */
    @Override
    public Future<VirtualMachineImageResourceList> listSkusAsync(final VirtualMachineImageListSkusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>() { 
            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return listSkus(parameters);
            }
         });
    }
    
    /**
    * Gets a list of virtual machine image skus.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A list of virtual machine image resource information.
    */
    @Override
    public VirtualMachineImageResourceList listSkus(VirtualMachineImageListSkusParameters parameters) throws IOException, ServiceException {
        // Validate
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getOffer() == null) {
                throw new NullPointerException("parameters.Offer");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listSkusAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmimage/offers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getOffer(), "UTF-8");
        }
        url = url + "/skus";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineImageResourceList result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode resourcesArray = responseDoc;
                    if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                        for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                            VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                            result.getResources().add(virtualMachineImageResourceInstance);
                            
                            JsonNode idValue = resourcesValue.get("id");
                            if (idValue != null && idValue instanceof NullNode == false) {
                                String idInstance;
                                idInstance = idValue.getTextValue();
                                virtualMachineImageResourceInstance.setId(idInstance);
                            }
                            
                            JsonNode nameValue = resourcesValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                virtualMachineImageResourceInstance.setName(nameInstance);
                            }
                            
                            JsonNode locationValue = resourcesValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualMachineImageResourceInstance.setLocation(locationInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
