/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.models.AdditionalUnattendContent;
import com.microsoft.azure.management.compute.models.AvailabilitySetReference;
import com.microsoft.azure.management.compute.models.BootDiagnostics;
import com.microsoft.azure.management.compute.models.BootDiagnosticsInstanceView;
import com.microsoft.azure.management.compute.models.ComputeLongRunningOperationResponse;
import com.microsoft.azure.management.compute.models.ComputeOperationResponse;
import com.microsoft.azure.management.compute.models.DataDisk;
import com.microsoft.azure.management.compute.models.DeleteOperationResponse;
import com.microsoft.azure.management.compute.models.DiagnosticsProfile;
import com.microsoft.azure.management.compute.models.DiskInstanceView;
import com.microsoft.azure.management.compute.models.HardwareProfile;
import com.microsoft.azure.management.compute.models.ImageReference;
import com.microsoft.azure.management.compute.models.InstanceViewStatus;
import com.microsoft.azure.management.compute.models.LinuxConfiguration;
import com.microsoft.azure.management.compute.models.ListParameters;
import com.microsoft.azure.management.compute.models.NetworkInterfaceReference;
import com.microsoft.azure.management.compute.models.NetworkProfile;
import com.microsoft.azure.management.compute.models.OSDisk;
import com.microsoft.azure.management.compute.models.OSProfile;
import com.microsoft.azure.management.compute.models.Plan;
import com.microsoft.azure.management.compute.models.SourceVaultReference;
import com.microsoft.azure.management.compute.models.SshConfiguration;
import com.microsoft.azure.management.compute.models.SshPublicKey;
import com.microsoft.azure.management.compute.models.StorageProfile;
import com.microsoft.azure.management.compute.models.VaultCertificate;
import com.microsoft.azure.management.compute.models.VaultSecretGroup;
import com.microsoft.azure.management.compute.models.VirtualHardDisk;
import com.microsoft.azure.management.compute.models.VirtualMachine;
import com.microsoft.azure.management.compute.models.VirtualMachineAgentInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineCaptureParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineCreateOrUpdateResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtension;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionHandlerInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineGetResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineListResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineSize;
import com.microsoft.azure.management.compute.models.VirtualMachineSizeListResponse;
import com.microsoft.azure.management.compute.models.WinRMConfiguration;
import com.microsoft.azure.management.compute.models.WinRMListener;
import com.microsoft.azure.management.compute.models.WindowsConfiguration;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import javax.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/**
* Operations for managing the virtual machines in compute management.
*/
public class VirtualMachineOperationsImpl implements ServiceOperations<ComputeManagementClientImpl>, VirtualMachineOperations {
    /**
    * Initializes a new instance of the VirtualMachineOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    VirtualMachineOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }
    
    private ComputeManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.compute.ComputeManagementClientImpl.
    * @return The Client value.
    */
    public ComputeManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Captures the VM by copying VirtualHardDisks of the VM and outputs a
    * template that can be used to create similar VMs.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @return The compute long running operation response.
    */
    @Override
    public Future<ComputeOperationResponse> beginCapturingAsync(final String resourceGroupName, final String vmName, final VirtualMachineCaptureParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>() { 
            @Override
            public ComputeOperationResponse call() throws Exception {
                return beginCapturing(resourceGroupName, vmName, parameters);
            }
         });
    }
    
    /**
    * Captures the VM by copying VirtualHardDisks of the VM and outputs a
    * template that can be used to create similar VMs.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    @Override
    public ComputeOperationResponse beginCapturing(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDestinationContainerName() == null) {
            throw new NullPointerException("parameters.DestinationContainerName");
        }
        if (parameters.getVirtualHardDiskNamePrefix() == null) {
            throw new NullPointerException("parameters.VirtualHardDiskNamePrefix");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCapturingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/capture";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode virtualMachineCaptureParametersValue = objectMapper.createObjectNode();
        requestDoc = virtualMachineCaptureParametersValue;
        
        ((ObjectNode) virtualMachineCaptureParametersValue).put("vhdPrefix", parameters.getVirtualHardDiskNamePrefix());
        
        ((ObjectNode) virtualMachineCaptureParametersValue).put("destinationContainerName", parameters.getDestinationContainerName());
        
        ((ObjectNode) virtualMachineCaptureParametersValue).put("overwriteVhds", parameters.isOverwrite());
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ComputeOperationResponse result = null;
            // Deserialize Response
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to create or update a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine operation.
    * @return The Create Virtual Machine operation response.
    */
    @Override
    public Future<VirtualMachineCreateOrUpdateResponse> beginCreatingOrUpdatingAsync(final String resourceGroupName, final VirtualMachine parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineCreateOrUpdateResponse>() { 
            @Override
            public VirtualMachineCreateOrUpdateResponse call() throws Exception {
                return beginCreatingOrUpdating(resourceGroupName, parameters);
            }
         });
    }
    
    /**
    * The operation to create or update a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The Create Virtual Machine operation response.
    */
    @Override
    public VirtualMachineCreateOrUpdateResponse beginCreatingOrUpdating(String resourceGroupName, VirtualMachine parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getExtensions() != null) {
            for (VirtualMachineExtension extensionsParameterItem : parameters.getExtensions()) {
                if (extensionsParameterItem.getLocation() == null) {
                    throw new NullPointerException("parameters.Extensions.Location");
                }
            }
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getStorageProfile() != null) {
            if (parameters.getStorageProfile().getDataDisks() != null) {
                for (DataDisk dataDisksParameterItem : parameters.getStorageProfile().getDataDisks()) {
                    if (dataDisksParameterItem.getCreateOption() == null) {
                        throw new NullPointerException("parameters.StorageProfile.DataDisks.CreateOption");
                    }
                    if (dataDisksParameterItem.getName() == null) {
                        throw new NullPointerException("parameters.StorageProfile.DataDisks.Name");
                    }
                    if (dataDisksParameterItem.getVirtualHardDisk() == null) {
                        throw new NullPointerException("parameters.StorageProfile.DataDisks.VirtualHardDisk");
                    }
                }
            }
            if (parameters.getStorageProfile().getOSDisk() != null) {
                if (parameters.getStorageProfile().getOSDisk().getCreateOption() == null) {
                    throw new NullPointerException("parameters.StorageProfile.OSDisk.CreateOption");
                }
                if (parameters.getStorageProfile().getOSDisk().getName() == null) {
                    throw new NullPointerException("parameters.StorageProfile.OSDisk.Name");
                }
                if (parameters.getStorageProfile().getOSDisk().getVirtualHardDisk() == null) {
                    throw new NullPointerException("parameters.StorageProfile.OSDisk.VirtualHardDisk");
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreatingOrUpdatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        if (parameters.getName() != null) {
            url = url + URLEncoder.encode(parameters.getName(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode virtualMachineJsonValue = objectMapper.createObjectNode();
        requestDoc = virtualMachineJsonValue;
        
        if (parameters.getPlan() != null) {
            ObjectNode planValue = objectMapper.createObjectNode();
            ((ObjectNode) virtualMachineJsonValue).put("plan", planValue);
            
            if (parameters.getPlan().getName() != null) {
                ((ObjectNode) planValue).put("name", parameters.getPlan().getName());
            }
            
            if (parameters.getPlan().getPublisher() != null) {
                ((ObjectNode) planValue).put("publisher", parameters.getPlan().getPublisher());
            }
            
            if (parameters.getPlan().getProduct() != null) {
                ((ObjectNode) planValue).put("product", parameters.getPlan().getProduct());
            }
            
            if (parameters.getPlan().getPromotionCode() != null) {
                ((ObjectNode) planValue).put("promotionCode", parameters.getPlan().getPromotionCode());
            }
        }
        
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        ((ObjectNode) virtualMachineJsonValue).put("properties", propertiesValue);
        
        if (parameters.getHardwareProfile() != null) {
            ObjectNode hardwareProfileValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("hardwareProfile", hardwareProfileValue);
            
            if (parameters.getHardwareProfile().getVirtualMachineSize() != null) {
                ((ObjectNode) hardwareProfileValue).put("vmSize", parameters.getHardwareProfile().getVirtualMachineSize());
            }
        }
        
        if (parameters.getStorageProfile() != null) {
            ObjectNode storageProfileValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("storageProfile", storageProfileValue);
            
            if (parameters.getStorageProfile().getImageReference() != null) {
                ObjectNode imageReferenceValue = objectMapper.createObjectNode();
                ((ObjectNode) storageProfileValue).put("imageReference", imageReferenceValue);
                
                if (parameters.getStorageProfile().getImageReference().getPublisher() != null) {
                    ((ObjectNode) imageReferenceValue).put("publisher", parameters.getStorageProfile().getImageReference().getPublisher());
                }
                
                if (parameters.getStorageProfile().getImageReference().getOffer() != null) {
                    ((ObjectNode) imageReferenceValue).put("offer", parameters.getStorageProfile().getImageReference().getOffer());
                }
                
                if (parameters.getStorageProfile().getImageReference().getSku() != null) {
                    ((ObjectNode) imageReferenceValue).put("sku", parameters.getStorageProfile().getImageReference().getSku());
                }
                
                if (parameters.getStorageProfile().getImageReference().getVersion() != null) {
                    ((ObjectNode) imageReferenceValue).put("version", parameters.getStorageProfile().getImageReference().getVersion());
                }
            }
            
            if (parameters.getStorageProfile().getOSDisk() != null) {
                ObjectNode osDiskValue = objectMapper.createObjectNode();
                ((ObjectNode) storageProfileValue).put("osDisk", osDiskValue);
                
                if (parameters.getStorageProfile().getOSDisk().getOperatingSystemType() != null) {
                    ((ObjectNode) osDiskValue).put("osType", parameters.getStorageProfile().getOSDisk().getOperatingSystemType());
                }
                
                ((ObjectNode) osDiskValue).put("name", parameters.getStorageProfile().getOSDisk().getName());
                
                ObjectNode vhdValue = objectMapper.createObjectNode();
                ((ObjectNode) osDiskValue).put("vhd", vhdValue);
                
                if (parameters.getStorageProfile().getOSDisk().getVirtualHardDisk().getUri() != null) {
                    ((ObjectNode) vhdValue).put("uri", parameters.getStorageProfile().getOSDisk().getVirtualHardDisk().getUri());
                }
                
                if (parameters.getStorageProfile().getOSDisk().getSourceImage() != null) {
                    ObjectNode imageValue = objectMapper.createObjectNode();
                    ((ObjectNode) osDiskValue).put("image", imageValue);
                    
                    if (parameters.getStorageProfile().getOSDisk().getSourceImage().getUri() != null) {
                        ((ObjectNode) imageValue).put("uri", parameters.getStorageProfile().getOSDisk().getSourceImage().getUri());
                    }
                }
                
                if (parameters.getStorageProfile().getOSDisk().getCaching() != null) {
                    ((ObjectNode) osDiskValue).put("caching", parameters.getStorageProfile().getOSDisk().getCaching());
                }
                
                ((ObjectNode) osDiskValue).put("createOption", parameters.getStorageProfile().getOSDisk().getCreateOption());
                
                if (parameters.getStorageProfile().getOSDisk().getDiskSizeGB() != null) {
                    ((ObjectNode) osDiskValue).put("diskSizeGB", parameters.getStorageProfile().getOSDisk().getDiskSizeGB());
                }
            }
            
            if (parameters.getStorageProfile().getDataDisks() != null) {
                if (parameters.getStorageProfile().getDataDisks() instanceof LazyCollection == false || ((LazyCollection) parameters.getStorageProfile().getDataDisks()).isInitialized()) {
                    ArrayNode dataDisksArray = objectMapper.createArrayNode();
                    for (DataDisk dataDisksItem : parameters.getStorageProfile().getDataDisks()) {
                        ObjectNode dataDiskValue = objectMapper.createObjectNode();
                        dataDisksArray.add(dataDiskValue);
                        
                        ((ObjectNode) dataDiskValue).put("lun", dataDisksItem.getLun());
                        
                        ((ObjectNode) dataDiskValue).put("name", dataDisksItem.getName());
                        
                        ObjectNode vhdValue2 = objectMapper.createObjectNode();
                        ((ObjectNode) dataDiskValue).put("vhd", vhdValue2);
                        
                        if (dataDisksItem.getVirtualHardDisk().getUri() != null) {
                            ((ObjectNode) vhdValue2).put("uri", dataDisksItem.getVirtualHardDisk().getUri());
                        }
                        
                        if (dataDisksItem.getSourceImage() != null) {
                            ObjectNode imageValue2 = objectMapper.createObjectNode();
                            ((ObjectNode) dataDiskValue).put("image", imageValue2);
                            
                            if (dataDisksItem.getSourceImage().getUri() != null) {
                                ((ObjectNode) imageValue2).put("uri", dataDisksItem.getSourceImage().getUri());
                            }
                        }
                        
                        if (dataDisksItem.getCaching() != null) {
                            ((ObjectNode) dataDiskValue).put("caching", dataDisksItem.getCaching());
                        }
                        
                        ((ObjectNode) dataDiskValue).put("createOption", dataDisksItem.getCreateOption());
                        
                        if (dataDisksItem.getDiskSizeGB() != null) {
                            ((ObjectNode) dataDiskValue).put("diskSizeGB", dataDisksItem.getDiskSizeGB());
                        }
                    }
                    ((ObjectNode) storageProfileValue).put("dataDisks", dataDisksArray);
                }
            }
        }
        
        if (parameters.getOSProfile() != null) {
            ObjectNode osProfileValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("osProfile", osProfileValue);
            
            if (parameters.getOSProfile().getComputerName() != null) {
                ((ObjectNode) osProfileValue).put("computerName", parameters.getOSProfile().getComputerName());
            }
            
            if (parameters.getOSProfile().getAdminUsername() != null) {
                ((ObjectNode) osProfileValue).put("adminUsername", parameters.getOSProfile().getAdminUsername());
            }
            
            if (parameters.getOSProfile().getAdminPassword() != null) {
                ((ObjectNode) osProfileValue).put("adminPassword", parameters.getOSProfile().getAdminPassword());
            }
            
            if (parameters.getOSProfile().getCustomData() != null) {
                ((ObjectNode) osProfileValue).put("customData", parameters.getOSProfile().getCustomData());
            }
            
            if (parameters.getOSProfile().getWindowsConfiguration() != null) {
                ObjectNode windowsConfigurationValue = objectMapper.createObjectNode();
                ((ObjectNode) osProfileValue).put("windowsConfiguration", windowsConfigurationValue);
                
                if (parameters.getOSProfile().getWindowsConfiguration().isProvisionVMAgent() != null) {
                    ((ObjectNode) windowsConfigurationValue).put("provisionVMAgent", parameters.getOSProfile().getWindowsConfiguration().isProvisionVMAgent());
                }
                
                if (parameters.getOSProfile().getWindowsConfiguration().isEnableAutomaticUpdates() != null) {
                    ((ObjectNode) windowsConfigurationValue).put("enableAutomaticUpdates", parameters.getOSProfile().getWindowsConfiguration().isEnableAutomaticUpdates());
                }
                
                if (parameters.getOSProfile().getWindowsConfiguration().getTimeZone() != null) {
                    ((ObjectNode) windowsConfigurationValue).put("timeZone", parameters.getOSProfile().getWindowsConfiguration().getTimeZone());
                }
                
                if (parameters.getOSProfile().getWindowsConfiguration().getAdditionalUnattendContents() != null) {
                    if (parameters.getOSProfile().getWindowsConfiguration().getAdditionalUnattendContents() instanceof LazyCollection == false || ((LazyCollection) parameters.getOSProfile().getWindowsConfiguration().getAdditionalUnattendContents()).isInitialized()) {
                        ArrayNode additionalUnattendContentArray = objectMapper.createArrayNode();
                        for (AdditionalUnattendContent additionalUnattendContentItem : parameters.getOSProfile().getWindowsConfiguration().getAdditionalUnattendContents()) {
                            ObjectNode additionalUnattendContentValue = objectMapper.createObjectNode();
                            additionalUnattendContentArray.add(additionalUnattendContentValue);
                            
                            if (additionalUnattendContentItem.getPassName() != null) {
                                ((ObjectNode) additionalUnattendContentValue).put("passName", additionalUnattendContentItem.getPassName());
                            }
                            
                            if (additionalUnattendContentItem.getComponentName() != null) {
                                ((ObjectNode) additionalUnattendContentValue).put("componentName", additionalUnattendContentItem.getComponentName());
                            }
                            
                            if (additionalUnattendContentItem.getSettingName() != null) {
                                ((ObjectNode) additionalUnattendContentValue).put("settingName", additionalUnattendContentItem.getSettingName());
                            }
                            
                            if (additionalUnattendContentItem.getContent() != null) {
                                ((ObjectNode) additionalUnattendContentValue).put("content", additionalUnattendContentItem.getContent());
                            }
                        }
                        ((ObjectNode) windowsConfigurationValue).put("additionalUnattendContent", additionalUnattendContentArray);
                    }
                }
                
                if (parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration() != null) {
                    ObjectNode winRMValue = objectMapper.createObjectNode();
                    ((ObjectNode) windowsConfigurationValue).put("winRM", winRMValue);
                    
                    if (parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration().getListeners() != null) {
                        if (parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration().getListeners() instanceof LazyCollection == false || ((LazyCollection) parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration().getListeners()).isInitialized()) {
                            ArrayNode listenersArray = objectMapper.createArrayNode();
                            for (WinRMListener listenersItem : parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration().getListeners()) {
                                ObjectNode winRMListenerValue = objectMapper.createObjectNode();
                                listenersArray.add(winRMListenerValue);
                                
                                if (listenersItem.getProtocol() != null) {
                                    ((ObjectNode) winRMListenerValue).put("protocol", listenersItem.getProtocol());
                                }
                                
                                if (listenersItem.getCertificateUrl() != null) {
                                    ((ObjectNode) winRMListenerValue).put("certificateUrl", listenersItem.getCertificateUrl().toString());
                                }
                            }
                            ((ObjectNode) winRMValue).put("listeners", listenersArray);
                        }
                    }
                }
            }
            
            if (parameters.getOSProfile().getLinuxConfiguration() != null) {
                ObjectNode linuxConfigurationValue = objectMapper.createObjectNode();
                ((ObjectNode) osProfileValue).put("linuxConfiguration", linuxConfigurationValue);
                
                if (parameters.getOSProfile().getLinuxConfiguration().isDisablePasswordAuthentication() != null) {
                    ((ObjectNode) linuxConfigurationValue).put("disablePasswordAuthentication", parameters.getOSProfile().getLinuxConfiguration().isDisablePasswordAuthentication());
                }
                
                if (parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration() != null) {
                    ObjectNode sshValue = objectMapper.createObjectNode();
                    ((ObjectNode) linuxConfigurationValue).put("ssh", sshValue);
                    
                    if (parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration().getPublicKeys() != null) {
                        if (parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration().getPublicKeys() instanceof LazyCollection == false || ((LazyCollection) parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration().getPublicKeys()).isInitialized()) {
                            ArrayNode publicKeysArray = objectMapper.createArrayNode();
                            for (SshPublicKey publicKeysItem : parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration().getPublicKeys()) {
                                ObjectNode sshPublicKeyValue = objectMapper.createObjectNode();
                                publicKeysArray.add(sshPublicKeyValue);
                                
                                if (publicKeysItem.getPath() != null) {
                                    ((ObjectNode) sshPublicKeyValue).put("path", publicKeysItem.getPath());
                                }
                                
                                if (publicKeysItem.getKeyData() != null) {
                                    ((ObjectNode) sshPublicKeyValue).put("keyData", publicKeysItem.getKeyData());
                                }
                            }
                            ((ObjectNode) sshValue).put("publicKeys", publicKeysArray);
                        }
                    }
                }
            }
            
            if (parameters.getOSProfile().getSecrets() != null) {
                ArrayNode secretsArray = objectMapper.createArrayNode();
                for (VaultSecretGroup secretsItem : parameters.getOSProfile().getSecrets()) {
                    ObjectNode vaultSecretGroupValue = objectMapper.createObjectNode();
                    secretsArray.add(vaultSecretGroupValue);
                    
                    if (secretsItem.getSourceVault() != null) {
                        ObjectNode sourceVaultValue = objectMapper.createObjectNode();
                        ((ObjectNode) vaultSecretGroupValue).put("sourceVault", sourceVaultValue);
                        
                        if (secretsItem.getSourceVault().getReferenceUri() != null) {
                            ((ObjectNode) sourceVaultValue).put("id", secretsItem.getSourceVault().getReferenceUri());
                        }
                    }
                    
                    if (secretsItem.getVaultCertificates() != null) {
                        if (secretsItem.getVaultCertificates() instanceof LazyCollection == false || ((LazyCollection) secretsItem.getVaultCertificates()).isInitialized()) {
                            ArrayNode vaultCertificatesArray = objectMapper.createArrayNode();
                            for (VaultCertificate vaultCertificatesItem : secretsItem.getVaultCertificates()) {
                                ObjectNode vaultCertificateValue = objectMapper.createObjectNode();
                                vaultCertificatesArray.add(vaultCertificateValue);
                                
                                if (vaultCertificatesItem.getCertificateUrl() != null) {
                                    ((ObjectNode) vaultCertificateValue).put("certificateUrl", vaultCertificatesItem.getCertificateUrl());
                                }
                                
                                if (vaultCertificatesItem.getCertificateStore() != null) {
                                    ((ObjectNode) vaultCertificateValue).put("certificateStore", vaultCertificatesItem.getCertificateStore());
                                }
                            }
                            ((ObjectNode) vaultSecretGroupValue).put("vaultCertificates", vaultCertificatesArray);
                        }
                    }
                }
                ((ObjectNode) osProfileValue).put("secrets", secretsArray);
            }
        }
        
        if (parameters.getNetworkProfile() != null) {
            ObjectNode networkProfileValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("networkProfile", networkProfileValue);
            
            if (parameters.getNetworkProfile().getNetworkInterfaces() != null) {
                if (parameters.getNetworkProfile().getNetworkInterfaces() instanceof LazyCollection == false || ((LazyCollection) parameters.getNetworkProfile().getNetworkInterfaces()).isInitialized()) {
                    ArrayNode networkInterfacesArray = objectMapper.createArrayNode();
                    for (NetworkInterfaceReference networkInterfacesItem : parameters.getNetworkProfile().getNetworkInterfaces()) {
                        ObjectNode networkInterfaceReferenceJsonValue = objectMapper.createObjectNode();
                        networkInterfacesArray.add(networkInterfaceReferenceJsonValue);
                        
                        ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                        ((ObjectNode) networkInterfaceReferenceJsonValue).put("properties", propertiesValue2);
                        
                        if (networkInterfacesItem.isPrimary() != null) {
                            ((ObjectNode) propertiesValue2).put("primary", networkInterfacesItem.isPrimary());
                        }
                        
                        if (networkInterfacesItem.getReferenceUri() != null) {
                            ((ObjectNode) networkInterfaceReferenceJsonValue).put("id", networkInterfacesItem.getReferenceUri());
                        }
                    }
                    ((ObjectNode) networkProfileValue).put("networkInterfaces", networkInterfacesArray);
                }
            }
        }
        
        if (parameters.getDiagnosticsProfile() != null) {
            ObjectNode diagnosticsProfileValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("diagnosticsProfile", diagnosticsProfileValue);
            
            if (parameters.getDiagnosticsProfile().getBootDiagnostics() != null) {
                ObjectNode bootDiagnosticsValue = objectMapper.createObjectNode();
                ((ObjectNode) diagnosticsProfileValue).put("bootDiagnostics", bootDiagnosticsValue);
                
                if (parameters.getDiagnosticsProfile().getBootDiagnostics().isEnabled() != null) {
                    ((ObjectNode) bootDiagnosticsValue).put("enabled", parameters.getDiagnosticsProfile().getBootDiagnostics().isEnabled());
                }
                
                if (parameters.getDiagnosticsProfile().getBootDiagnostics().getStorageUri() != null) {
                    ((ObjectNode) bootDiagnosticsValue).put("storageUri", parameters.getDiagnosticsProfile().getBootDiagnostics().getStorageUri().toString());
                }
            }
        }
        
        if (parameters.getAvailabilitySetReference() != null) {
            ObjectNode availabilitySetValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("availabilitySet", availabilitySetValue);
            
            if (parameters.getAvailabilitySetReference().getReferenceUri() != null) {
                ((ObjectNode) availabilitySetValue).put("id", parameters.getAvailabilitySetReference().getReferenceUri());
            }
        }
        
        if (parameters.getProvisioningState() != null) {
            ((ObjectNode) propertiesValue).put("provisioningState", parameters.getProvisioningState());
        }
        
        if (parameters.getInstanceView() != null) {
            ObjectNode instanceViewValue = objectMapper.createObjectNode();
            ((ObjectNode) propertiesValue).put("instanceView", instanceViewValue);
            
            if (parameters.getInstanceView().getPlatformUpdateDomain() != null) {
                ((ObjectNode) instanceViewValue).put("platformUpdateDomain", parameters.getInstanceView().getPlatformUpdateDomain());
            }
            
            if (parameters.getInstanceView().getPlatformFaultDomain() != null) {
                ((ObjectNode) instanceViewValue).put("platformFaultDomain", parameters.getInstanceView().getPlatformFaultDomain());
            }
            
            if (parameters.getInstanceView().getRemoteDesktopThumbprint() != null) {
                ((ObjectNode) instanceViewValue).put("rdpThumbPrint", parameters.getInstanceView().getRemoteDesktopThumbprint());
            }
            
            if (parameters.getInstanceView().getVMAgent() != null) {
                ObjectNode vmAgentValue = objectMapper.createObjectNode();
                ((ObjectNode) instanceViewValue).put("vmAgent", vmAgentValue);
                
                if (parameters.getInstanceView().getVMAgent().getVMAgentVersion() != null) {
                    ((ObjectNode) vmAgentValue).put("vmAgentVersion", parameters.getInstanceView().getVMAgent().getVMAgentVersion());
                }
                
                if (parameters.getInstanceView().getVMAgent().getExtensionHandlers() != null) {
                    if (parameters.getInstanceView().getVMAgent().getExtensionHandlers() instanceof LazyCollection == false || ((LazyCollection) parameters.getInstanceView().getVMAgent().getExtensionHandlers()).isInitialized()) {
                        ArrayNode extensionHandlersArray = objectMapper.createArrayNode();
                        for (VirtualMachineExtensionHandlerInstanceView extensionHandlersItem : parameters.getInstanceView().getVMAgent().getExtensionHandlers()) {
                            ObjectNode virtualMachineExtensionHandlerInstanceViewValue = objectMapper.createObjectNode();
                            extensionHandlersArray.add(virtualMachineExtensionHandlerInstanceViewValue);
                            
                            if (extensionHandlersItem.getType() != null) {
                                ((ObjectNode) virtualMachineExtensionHandlerInstanceViewValue).put("type", extensionHandlersItem.getType());
                            }
                            
                            if (extensionHandlersItem.getTypeHandlerVersion() != null) {
                                ((ObjectNode) virtualMachineExtensionHandlerInstanceViewValue).put("typeHandlerVersion", extensionHandlersItem.getTypeHandlerVersion());
                            }
                            
                            if (extensionHandlersItem.getStatus() != null) {
                                ObjectNode statusValue = objectMapper.createObjectNode();
                                ((ObjectNode) virtualMachineExtensionHandlerInstanceViewValue).put("status", statusValue);
                                
                                if (extensionHandlersItem.getStatus().getCode() != null) {
                                    ((ObjectNode) statusValue).put("code", extensionHandlersItem.getStatus().getCode());
                                }
                                
                                if (extensionHandlersItem.getStatus().getLevel() != null) {
                                    ((ObjectNode) statusValue).put("level", extensionHandlersItem.getStatus().getLevel());
                                }
                                
                                if (extensionHandlersItem.getStatus().getDisplayStatus() != null) {
                                    ((ObjectNode) statusValue).put("displayStatus", extensionHandlersItem.getStatus().getDisplayStatus());
                                }
                                
                                if (extensionHandlersItem.getStatus().getMessage() != null) {
                                    ((ObjectNode) statusValue).put("message", extensionHandlersItem.getStatus().getMessage());
                                }
                                
                                if (extensionHandlersItem.getStatus().getTime() != null) {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                                    simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                                    ((ObjectNode) statusValue).put("time", simpleDateFormat.format(extensionHandlersItem.getStatus().getTime().getTime()));
                                }
                            }
                        }
                        ((ObjectNode) vmAgentValue).put("extensionHandlers", extensionHandlersArray);
                    }
                }
                
                if (parameters.getInstanceView().getVMAgent().getStatuses() != null) {
                    ArrayNode statusesArray = objectMapper.createArrayNode();
                    for (InstanceViewStatus statusesItem : parameters.getInstanceView().getVMAgent().getStatuses()) {
                        ObjectNode instanceViewStatusValue = objectMapper.createObjectNode();
                        statusesArray.add(instanceViewStatusValue);
                        
                        if (statusesItem.getCode() != null) {
                            ((ObjectNode) instanceViewStatusValue).put("code", statusesItem.getCode());
                        }
                        
                        if (statusesItem.getLevel() != null) {
                            ((ObjectNode) instanceViewStatusValue).put("level", statusesItem.getLevel());
                        }
                        
                        if (statusesItem.getDisplayStatus() != null) {
                            ((ObjectNode) instanceViewStatusValue).put("displayStatus", statusesItem.getDisplayStatus());
                        }
                        
                        if (statusesItem.getMessage() != null) {
                            ((ObjectNode) instanceViewStatusValue).put("message", statusesItem.getMessage());
                        }
                        
                        if (statusesItem.getTime() != null) {
                            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                            simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                            ((ObjectNode) instanceViewStatusValue).put("time", simpleDateFormat2.format(statusesItem.getTime().getTime()));
                        }
                    }
                    ((ObjectNode) vmAgentValue).put("statuses", statusesArray);
                }
            }
            
            if (parameters.getInstanceView().getDisks() != null) {
                if (parameters.getInstanceView().getDisks() instanceof LazyCollection == false || ((LazyCollection) parameters.getInstanceView().getDisks()).isInitialized()) {
                    ArrayNode disksArray = objectMapper.createArrayNode();
                    for (DiskInstanceView disksItem : parameters.getInstanceView().getDisks()) {
                        ObjectNode diskInstanceViewValue = objectMapper.createObjectNode();
                        disksArray.add(diskInstanceViewValue);
                        
                        if (disksItem.getName() != null) {
                            ((ObjectNode) diskInstanceViewValue).put("name", disksItem.getName());
                        }
                        
                        if (disksItem.getStatuses() != null) {
                            ArrayNode statusesArray2 = objectMapper.createArrayNode();
                            for (InstanceViewStatus statusesItem2 : disksItem.getStatuses()) {
                                ObjectNode instanceViewStatusValue2 = objectMapper.createObjectNode();
                                statusesArray2.add(instanceViewStatusValue2);
                                
                                if (statusesItem2.getCode() != null) {
                                    ((ObjectNode) instanceViewStatusValue2).put("code", statusesItem2.getCode());
                                }
                                
                                if (statusesItem2.getLevel() != null) {
                                    ((ObjectNode) instanceViewStatusValue2).put("level", statusesItem2.getLevel());
                                }
                                
                                if (statusesItem2.getDisplayStatus() != null) {
                                    ((ObjectNode) instanceViewStatusValue2).put("displayStatus", statusesItem2.getDisplayStatus());
                                }
                                
                                if (statusesItem2.getMessage() != null) {
                                    ((ObjectNode) instanceViewStatusValue2).put("message", statusesItem2.getMessage());
                                }
                                
                                if (statusesItem2.getTime() != null) {
                                    SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                                    simpleDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
                                    ((ObjectNode) instanceViewStatusValue2).put("time", simpleDateFormat3.format(statusesItem2.getTime().getTime()));
                                }
                            }
                            ((ObjectNode) diskInstanceViewValue).put("statuses", statusesArray2);
                        }
                    }
                    ((ObjectNode) instanceViewValue).put("disks", disksArray);
                }
            }
            
            if (parameters.getInstanceView().getExtensions() != null) {
                if (parameters.getInstanceView().getExtensions() instanceof LazyCollection == false || ((LazyCollection) parameters.getInstanceView().getExtensions()).isInitialized()) {
                    ArrayNode extensionsArray = objectMapper.createArrayNode();
                    for (VirtualMachineExtensionInstanceView extensionsItem : parameters.getInstanceView().getExtensions()) {
                        ObjectNode virtualMachineExtensionInstanceViewValue = objectMapper.createObjectNode();
                        extensionsArray.add(virtualMachineExtensionInstanceViewValue);
                        
                        if (extensionsItem.getName() != null) {
                            ((ObjectNode) virtualMachineExtensionInstanceViewValue).put("name", extensionsItem.getName());
                        }
                        
                        if (extensionsItem.getExtensionType() != null) {
                            ((ObjectNode) virtualMachineExtensionInstanceViewValue).put("type", extensionsItem.getExtensionType());
                        }
                        
                        if (extensionsItem.getTypeHandlerVersion() != null) {
                            ((ObjectNode) virtualMachineExtensionInstanceViewValue).put("typeHandlerVersion", extensionsItem.getTypeHandlerVersion());
                        }
                        
                        if (extensionsItem.getSubStatuses() != null) {
                            if (extensionsItem.getSubStatuses() instanceof LazyCollection == false || ((LazyCollection) extensionsItem.getSubStatuses()).isInitialized()) {
                                ArrayNode substatusesArray = objectMapper.createArrayNode();
                                for (InstanceViewStatus substatusesItem : extensionsItem.getSubStatuses()) {
                                    ObjectNode instanceViewStatusValue3 = objectMapper.createObjectNode();
                                    substatusesArray.add(instanceViewStatusValue3);
                                    
                                    if (substatusesItem.getCode() != null) {
                                        ((ObjectNode) instanceViewStatusValue3).put("code", substatusesItem.getCode());
                                    }
                                    
                                    if (substatusesItem.getLevel() != null) {
                                        ((ObjectNode) instanceViewStatusValue3).put("level", substatusesItem.getLevel());
                                    }
                                    
                                    if (substatusesItem.getDisplayStatus() != null) {
                                        ((ObjectNode) instanceViewStatusValue3).put("displayStatus", substatusesItem.getDisplayStatus());
                                    }
                                    
                                    if (substatusesItem.getMessage() != null) {
                                        ((ObjectNode) instanceViewStatusValue3).put("message", substatusesItem.getMessage());
                                    }
                                    
                                    if (substatusesItem.getTime() != null) {
                                        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                                        simpleDateFormat4.setTimeZone(TimeZone.getTimeZone("UTC"));
                                        ((ObjectNode) instanceViewStatusValue3).put("time", simpleDateFormat4.format(substatusesItem.getTime().getTime()));
                                    }
                                }
                                ((ObjectNode) virtualMachineExtensionInstanceViewValue).put("substatuses", substatusesArray);
                            }
                        }
                        
                        if (extensionsItem.getStatuses() != null) {
                            ArrayNode statusesArray3 = objectMapper.createArrayNode();
                            for (InstanceViewStatus statusesItem3 : extensionsItem.getStatuses()) {
                                ObjectNode instanceViewStatusValue4 = objectMapper.createObjectNode();
                                statusesArray3.add(instanceViewStatusValue4);
                                
                                if (statusesItem3.getCode() != null) {
                                    ((ObjectNode) instanceViewStatusValue4).put("code", statusesItem3.getCode());
                                }
                                
                                if (statusesItem3.getLevel() != null) {
                                    ((ObjectNode) instanceViewStatusValue4).put("level", statusesItem3.getLevel());
                                }
                                
                                if (statusesItem3.getDisplayStatus() != null) {
                                    ((ObjectNode) instanceViewStatusValue4).put("displayStatus", statusesItem3.getDisplayStatus());
                                }
                                
                                if (statusesItem3.getMessage() != null) {
                                    ((ObjectNode) instanceViewStatusValue4).put("message", statusesItem3.getMessage());
                                }
                                
                                if (statusesItem3.getTime() != null) {
                                    SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                                    simpleDateFormat5.setTimeZone(TimeZone.getTimeZone("UTC"));
                                    ((ObjectNode) instanceViewStatusValue4).put("time", simpleDateFormat5.format(statusesItem3.getTime().getTime()));
                                }
                            }
                            ((ObjectNode) virtualMachineExtensionInstanceViewValue).put("statuses", statusesArray3);
                        }
                    }
                    ((ObjectNode) instanceViewValue).put("extensions", extensionsArray);
                }
            }
            
            if (parameters.getInstanceView().getBootDiagnostics() != null) {
                ObjectNode bootDiagnosticsValue2 = objectMapper.createObjectNode();
                ((ObjectNode) instanceViewValue).put("bootDiagnostics", bootDiagnosticsValue2);
                
                if (parameters.getInstanceView().getBootDiagnostics().getConsoleScreenshotBlobUri() != null) {
                    ((ObjectNode) bootDiagnosticsValue2).put("consoleScreenshotBlobUri", parameters.getInstanceView().getBootDiagnostics().getConsoleScreenshotBlobUri().toString());
                }
                
                if (parameters.getInstanceView().getBootDiagnostics().getSerialConsoleLogBlobUri() != null) {
                    ((ObjectNode) bootDiagnosticsValue2).put("serialConsoleLogBlobUri", parameters.getInstanceView().getBootDiagnostics().getSerialConsoleLogBlobUri().toString());
                }
            }
            
            if (parameters.getInstanceView().getStatuses() != null) {
                ArrayNode statusesArray4 = objectMapper.createArrayNode();
                for (InstanceViewStatus statusesItem4 : parameters.getInstanceView().getStatuses()) {
                    ObjectNode instanceViewStatusValue5 = objectMapper.createObjectNode();
                    statusesArray4.add(instanceViewStatusValue5);
                    
                    if (statusesItem4.getCode() != null) {
                        ((ObjectNode) instanceViewStatusValue5).put("code", statusesItem4.getCode());
                    }
                    
                    if (statusesItem4.getLevel() != null) {
                        ((ObjectNode) instanceViewStatusValue5).put("level", statusesItem4.getLevel());
                    }
                    
                    if (statusesItem4.getDisplayStatus() != null) {
                        ((ObjectNode) instanceViewStatusValue5).put("displayStatus", statusesItem4.getDisplayStatus());
                    }
                    
                    if (statusesItem4.getMessage() != null) {
                        ((ObjectNode) instanceViewStatusValue5).put("message", statusesItem4.getMessage());
                    }
                    
                    if (statusesItem4.getTime() != null) {
                        SimpleDateFormat simpleDateFormat6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat6.setTimeZone(TimeZone.getTimeZone("UTC"));
                        ((ObjectNode) instanceViewStatusValue5).put("time", simpleDateFormat6.format(statusesItem4.getTime().getTime()));
                    }
                }
                ((ObjectNode) instanceViewValue).put("statuses", statusesArray4);
            }
        }
        
        if (parameters.getExtensions() != null) {
            ArrayNode resourcesArray = objectMapper.createArrayNode();
            for (VirtualMachineExtension resourcesItem : parameters.getExtensions()) {
                ObjectNode virtualMachineExtensionJsonValue = objectMapper.createObjectNode();
                resourcesArray.add(virtualMachineExtensionJsonValue);
                
                ObjectNode propertiesValue3 = objectMapper.createObjectNode();
                ((ObjectNode) virtualMachineExtensionJsonValue).put("properties", propertiesValue3);
                
                if (resourcesItem.getPublisher() != null) {
                    ((ObjectNode) propertiesValue3).put("publisher", resourcesItem.getPublisher());
                }
                
                if (resourcesItem.getExtensionType() != null) {
                    ((ObjectNode) propertiesValue3).put("type", resourcesItem.getExtensionType());
                }
                
                if (resourcesItem.getTypeHandlerVersion() != null) {
                    ((ObjectNode) propertiesValue3).put("typeHandlerVersion", resourcesItem.getTypeHandlerVersion());
                }
                
                ((ObjectNode) propertiesValue3).put("autoUpgradeMinorVersion", resourcesItem.isAutoUpgradeMinorVersion());
                
                if (resourcesItem.getSettings() != null) {
                    ((ObjectNode) propertiesValue3).put("settings", objectMapper.readTree(resourcesItem.getSettings()));
                }
                
                if (resourcesItem.getProtectedSettings() != null) {
                    ((ObjectNode) propertiesValue3).put("protectedSettings", objectMapper.readTree(resourcesItem.getProtectedSettings()));
                }
                
                if (resourcesItem.getProvisioningState() != null) {
                    ((ObjectNode) propertiesValue3).put("provisioningState", resourcesItem.getProvisioningState());
                }
                
                if (resourcesItem.getInstanceView() != null) {
                    ObjectNode instanceViewValue2 = objectMapper.createObjectNode();
                    ((ObjectNode) propertiesValue3).put("instanceView", instanceViewValue2);
                    
                    if (resourcesItem.getInstanceView().getName() != null) {
                        ((ObjectNode) instanceViewValue2).put("name", resourcesItem.getInstanceView().getName());
                    }
                    
                    if (resourcesItem.getInstanceView().getExtensionType() != null) {
                        ((ObjectNode) instanceViewValue2).put("type", resourcesItem.getInstanceView().getExtensionType());
                    }
                    
                    if (resourcesItem.getInstanceView().getTypeHandlerVersion() != null) {
                        ((ObjectNode) instanceViewValue2).put("typeHandlerVersion", resourcesItem.getInstanceView().getTypeHandlerVersion());
                    }
                    
                    if (resourcesItem.getInstanceView().getSubStatuses() != null) {
                        if (resourcesItem.getInstanceView().getSubStatuses() instanceof LazyCollection == false || ((LazyCollection) resourcesItem.getInstanceView().getSubStatuses()).isInitialized()) {
                            ArrayNode substatusesArray2 = objectMapper.createArrayNode();
                            for (InstanceViewStatus substatusesItem2 : resourcesItem.getInstanceView().getSubStatuses()) {
                                ObjectNode instanceViewStatusValue6 = objectMapper.createObjectNode();
                                substatusesArray2.add(instanceViewStatusValue6);
                                
                                if (substatusesItem2.getCode() != null) {
                                    ((ObjectNode) instanceViewStatusValue6).put("code", substatusesItem2.getCode());
                                }
                                
                                if (substatusesItem2.getLevel() != null) {
                                    ((ObjectNode) instanceViewStatusValue6).put("level", substatusesItem2.getLevel());
                                }
                                
                                if (substatusesItem2.getDisplayStatus() != null) {
                                    ((ObjectNode) instanceViewStatusValue6).put("displayStatus", substatusesItem2.getDisplayStatus());
                                }
                                
                                if (substatusesItem2.getMessage() != null) {
                                    ((ObjectNode) instanceViewStatusValue6).put("message", substatusesItem2.getMessage());
                                }
                                
                                if (substatusesItem2.getTime() != null) {
                                    SimpleDateFormat simpleDateFormat7 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                                    simpleDateFormat7.setTimeZone(TimeZone.getTimeZone("UTC"));
                                    ((ObjectNode) instanceViewStatusValue6).put("time", simpleDateFormat7.format(substatusesItem2.getTime().getTime()));
                                }
                            }
                            ((ObjectNode) instanceViewValue2).put("substatuses", substatusesArray2);
                        }
                    }
                    
                    if (resourcesItem.getInstanceView().getStatuses() != null) {
                        ArrayNode statusesArray5 = objectMapper.createArrayNode();
                        for (InstanceViewStatus statusesItem5 : resourcesItem.getInstanceView().getStatuses()) {
                            ObjectNode instanceViewStatusValue7 = objectMapper.createObjectNode();
                            statusesArray5.add(instanceViewStatusValue7);
                            
                            if (statusesItem5.getCode() != null) {
                                ((ObjectNode) instanceViewStatusValue7).put("code", statusesItem5.getCode());
                            }
                            
                            if (statusesItem5.getLevel() != null) {
                                ((ObjectNode) instanceViewStatusValue7).put("level", statusesItem5.getLevel());
                            }
                            
                            if (statusesItem5.getDisplayStatus() != null) {
                                ((ObjectNode) instanceViewStatusValue7).put("displayStatus", statusesItem5.getDisplayStatus());
                            }
                            
                            if (statusesItem5.getMessage() != null) {
                                ((ObjectNode) instanceViewStatusValue7).put("message", statusesItem5.getMessage());
                            }
                            
                            if (statusesItem5.getTime() != null) {
                                SimpleDateFormat simpleDateFormat8 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                                simpleDateFormat8.setTimeZone(TimeZone.getTimeZone("UTC"));
                                ((ObjectNode) instanceViewStatusValue7).put("time", simpleDateFormat8.format(statusesItem5.getTime().getTime()));
                            }
                        }
                        ((ObjectNode) instanceViewValue2).put("statuses", statusesArray5);
                    }
                }
                
                if (resourcesItem.getId() != null) {
                    ((ObjectNode) virtualMachineExtensionJsonValue).put("id", resourcesItem.getId());
                }
                
                if (resourcesItem.getName() != null) {
                    ((ObjectNode) virtualMachineExtensionJsonValue).put("name", resourcesItem.getName());
                }
                
                if (resourcesItem.getType() != null) {
                    ((ObjectNode) virtualMachineExtensionJsonValue).put("type", resourcesItem.getType());
                }
                
                ((ObjectNode) virtualMachineExtensionJsonValue).put("location", resourcesItem.getLocation());
                
                if (resourcesItem.getTags() != null) {
                    ObjectNode tagsDictionary = objectMapper.createObjectNode();
                    for (Map.Entry<String, String> entry : resourcesItem.getTags().entrySet()) {
                        String tagsKey = entry.getKey();
                        String tagsValue = entry.getValue();
                        ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
                    }
                    ((ObjectNode) virtualMachineExtensionJsonValue).put("tags", tagsDictionary);
                }
            }
            ((ObjectNode) virtualMachineJsonValue).put("resources", resourcesArray);
        }
        
        if (parameters.getId() != null) {
            ((ObjectNode) virtualMachineJsonValue).put("id", parameters.getId());
        }
        
        if (parameters.getName() != null) {
            ((ObjectNode) virtualMachineJsonValue).put("name", parameters.getName());
        }
        
        if (parameters.getType() != null) {
            ((ObjectNode) virtualMachineJsonValue).put("type", parameters.getType());
        }
        
        ((ObjectNode) virtualMachineJsonValue).put("location", parameters.getLocation());
        
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary2 = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry2 : parameters.getTags().entrySet()) {
                String tagsKey2 = entry2.getKey();
                String tagsValue2 = entry2.getValue();
                ((ObjectNode) tagsDictionary2).put(tagsKey2, tagsValue2);
            }
            ((ObjectNode) virtualMachineJsonValue).put("tags", tagsDictionary2);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_CREATED) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineCreateOrUpdateResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualMachine virtualMachineInstance = new VirtualMachine();
                    result.setVirtualMachine(virtualMachineInstance);
                    
                    JsonNode planValue2 = responseDoc.get("plan");
                    if (planValue2 != null && planValue2 instanceof NullNode == false) {
                        Plan planInstance = new Plan();
                        virtualMachineInstance.setPlan(planInstance);
                        
                        JsonNode nameValue = planValue2.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        
                        JsonNode publisherValue = planValue2.get("publisher");
                        if (publisherValue != null && publisherValue instanceof NullNode == false) {
                            String publisherInstance;
                            publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        
                        JsonNode productValue = planValue2.get("product");
                        if (productValue != null && productValue instanceof NullNode == false) {
                            String productInstance;
                            productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        
                        JsonNode promotionCodeValue = planValue2.get("promotionCode");
                        if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                            String promotionCodeInstance;
                            promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    
                    JsonNode propertiesValue4 = responseDoc.get("properties");
                    if (propertiesValue4 != null && propertiesValue4 instanceof NullNode == false) {
                        JsonNode hardwareProfileValue2 = propertiesValue4.get("hardwareProfile");
                        if (hardwareProfileValue2 != null && hardwareProfileValue2 instanceof NullNode == false) {
                            HardwareProfile hardwareProfileInstance = new HardwareProfile();
                            virtualMachineInstance.setHardwareProfile(hardwareProfileInstance);
                            
                            JsonNode vmSizeValue = hardwareProfileValue2.get("vmSize");
                            if (vmSizeValue != null && vmSizeValue instanceof NullNode == false) {
                                String vmSizeInstance;
                                vmSizeInstance = vmSizeValue.getTextValue();
                                hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                            }
                        }
                        
                        JsonNode storageProfileValue2 = propertiesValue4.get("storageProfile");
                        if (storageProfileValue2 != null && storageProfileValue2 instanceof NullNode == false) {
                            StorageProfile storageProfileInstance = new StorageProfile();
                            virtualMachineInstance.setStorageProfile(storageProfileInstance);
                            
                            JsonNode imageReferenceValue2 = storageProfileValue2.get("imageReference");
                            if (imageReferenceValue2 != null && imageReferenceValue2 instanceof NullNode == false) {
                                ImageReference imageReferenceInstance = new ImageReference();
                                storageProfileInstance.setImageReference(imageReferenceInstance);
                                
                                JsonNode publisherValue2 = imageReferenceValue2.get("publisher");
                                if (publisherValue2 != null && publisherValue2 instanceof NullNode == false) {
                                    String publisherInstance2;
                                    publisherInstance2 = publisherValue2.getTextValue();
                                    imageReferenceInstance.setPublisher(publisherInstance2);
                                }
                                
                                JsonNode offerValue = imageReferenceValue2.get("offer");
                                if (offerValue != null && offerValue instanceof NullNode == false) {
                                    String offerInstance;
                                    offerInstance = offerValue.getTextValue();
                                    imageReferenceInstance.setOffer(offerInstance);
                                }
                                
                                JsonNode skuValue = imageReferenceValue2.get("sku");
                                if (skuValue != null && skuValue instanceof NullNode == false) {
                                    String skuInstance;
                                    skuInstance = skuValue.getTextValue();
                                    imageReferenceInstance.setSku(skuInstance);
                                }
                                
                                JsonNode versionValue = imageReferenceValue2.get("version");
                                if (versionValue != null && versionValue instanceof NullNode == false) {
                                    String versionInstance;
                                    versionInstance = versionValue.getTextValue();
                                    imageReferenceInstance.setVersion(versionInstance);
                                }
                            }
                            
                            JsonNode osDiskValue2 = storageProfileValue2.get("osDisk");
                            if (osDiskValue2 != null && osDiskValue2 instanceof NullNode == false) {
                                OSDisk osDiskInstance = new OSDisk();
                                storageProfileInstance.setOSDisk(osDiskInstance);
                                
                                JsonNode osTypeValue = osDiskValue2.get("osType");
                                if (osTypeValue != null && osTypeValue instanceof NullNode == false) {
                                    String osTypeInstance;
                                    osTypeInstance = osTypeValue.getTextValue();
                                    osDiskInstance.setOperatingSystemType(osTypeInstance);
                                }
                                
                                JsonNode nameValue2 = osDiskValue2.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    osDiskInstance.setName(nameInstance2);
                                }
                                
                                JsonNode vhdValue3 = osDiskValue2.get("vhd");
                                if (vhdValue3 != null && vhdValue3 instanceof NullNode == false) {
                                    VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                    osDiskInstance.setVirtualHardDisk(vhdInstance);
                                    
                                    JsonNode uriValue = vhdValue3.get("uri");
                                    if (uriValue != null && uriValue instanceof NullNode == false) {
                                        String uriInstance;
                                        uriInstance = uriValue.getTextValue();
                                        vhdInstance.setUri(uriInstance);
                                    }
                                }
                                
                                JsonNode imageValue3 = osDiskValue2.get("image");
                                if (imageValue3 != null && imageValue3 instanceof NullNode == false) {
                                    VirtualHardDisk imageInstance = new VirtualHardDisk();
                                    osDiskInstance.setSourceImage(imageInstance);
                                    
                                    JsonNode uriValue2 = imageValue3.get("uri");
                                    if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                        String uriInstance2;
                                        uriInstance2 = uriValue2.getTextValue();
                                        imageInstance.setUri(uriInstance2);
                                    }
                                }
                                
                                JsonNode cachingValue = osDiskValue2.get("caching");
                                if (cachingValue != null && cachingValue instanceof NullNode == false) {
                                    String cachingInstance;
                                    cachingInstance = cachingValue.getTextValue();
                                    osDiskInstance.setCaching(cachingInstance);
                                }
                                
                                JsonNode createOptionValue = osDiskValue2.get("createOption");
                                if (createOptionValue != null && createOptionValue instanceof NullNode == false) {
                                    String createOptionInstance;
                                    createOptionInstance = createOptionValue.getTextValue();
                                    osDiskInstance.setCreateOption(createOptionInstance);
                                }
                                
                                JsonNode diskSizeGBValue = osDiskValue2.get("diskSizeGB");
                                if (diskSizeGBValue != null && diskSizeGBValue instanceof NullNode == false) {
                                    int diskSizeGBInstance;
                                    diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                    osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                }
                            }
                            
                            JsonNode dataDisksArray2 = storageProfileValue2.get("dataDisks");
                            if (dataDisksArray2 != null && dataDisksArray2 instanceof NullNode == false) {
                                for (JsonNode dataDisksValue : ((ArrayNode) dataDisksArray2)) {
                                    DataDisk dataDiskInstance = new DataDisk();
                                    storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                    
                                    JsonNode lunValue = dataDisksValue.get("lun");
                                    if (lunValue != null && lunValue instanceof NullNode == false) {
                                        int lunInstance;
                                        lunInstance = lunValue.getIntValue();
                                        dataDiskInstance.setLun(lunInstance);
                                    }
                                    
                                    JsonNode nameValue3 = dataDisksValue.get("name");
                                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                        String nameInstance3;
                                        nameInstance3 = nameValue3.getTextValue();
                                        dataDiskInstance.setName(nameInstance3);
                                    }
                                    
                                    JsonNode vhdValue4 = dataDisksValue.get("vhd");
                                    if (vhdValue4 != null && vhdValue4 instanceof NullNode == false) {
                                        VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                        
                                        JsonNode uriValue3 = vhdValue4.get("uri");
                                        if (uriValue3 != null && uriValue3 instanceof NullNode == false) {
                                            String uriInstance3;
                                            uriInstance3 = uriValue3.getTextValue();
                                            vhdInstance2.setUri(uriInstance3);
                                        }
                                    }
                                    
                                    JsonNode imageValue4 = dataDisksValue.get("image");
                                    if (imageValue4 != null && imageValue4 instanceof NullNode == false) {
                                        VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setSourceImage(imageInstance2);
                                        
                                        JsonNode uriValue4 = imageValue4.get("uri");
                                        if (uriValue4 != null && uriValue4 instanceof NullNode == false) {
                                            String uriInstance4;
                                            uriInstance4 = uriValue4.getTextValue();
                                            imageInstance2.setUri(uriInstance4);
                                        }
                                    }
                                    
                                    JsonNode cachingValue2 = dataDisksValue.get("caching");
                                    if (cachingValue2 != null && cachingValue2 instanceof NullNode == false) {
                                        String cachingInstance2;
                                        cachingInstance2 = cachingValue2.getTextValue();
                                        dataDiskInstance.setCaching(cachingInstance2);
                                    }
                                    
                                    JsonNode createOptionValue2 = dataDisksValue.get("createOption");
                                    if (createOptionValue2 != null && createOptionValue2 instanceof NullNode == false) {
                                        String createOptionInstance2;
                                        createOptionInstance2 = createOptionValue2.getTextValue();
                                        dataDiskInstance.setCreateOption(createOptionInstance2);
                                    }
                                    
                                    JsonNode diskSizeGBValue2 = dataDisksValue.get("diskSizeGB");
                                    if (diskSizeGBValue2 != null && diskSizeGBValue2 instanceof NullNode == false) {
                                        int diskSizeGBInstance2;
                                        diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                        dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode osProfileValue2 = propertiesValue4.get("osProfile");
                        if (osProfileValue2 != null && osProfileValue2 instanceof NullNode == false) {
                            OSProfile osProfileInstance = new OSProfile();
                            virtualMachineInstance.setOSProfile(osProfileInstance);
                            
                            JsonNode computerNameValue = osProfileValue2.get("computerName");
                            if (computerNameValue != null && computerNameValue instanceof NullNode == false) {
                                String computerNameInstance;
                                computerNameInstance = computerNameValue.getTextValue();
                                osProfileInstance.setComputerName(computerNameInstance);
                            }
                            
                            JsonNode adminUsernameValue = osProfileValue2.get("adminUsername");
                            if (adminUsernameValue != null && adminUsernameValue instanceof NullNode == false) {
                                String adminUsernameInstance;
                                adminUsernameInstance = adminUsernameValue.getTextValue();
                                osProfileInstance.setAdminUsername(adminUsernameInstance);
                            }
                            
                            JsonNode adminPasswordValue = osProfileValue2.get("adminPassword");
                            if (adminPasswordValue != null && adminPasswordValue instanceof NullNode == false) {
                                String adminPasswordInstance;
                                adminPasswordInstance = adminPasswordValue.getTextValue();
                                osProfileInstance.setAdminPassword(adminPasswordInstance);
                            }
                            
                            JsonNode customDataValue = osProfileValue2.get("customData");
                            if (customDataValue != null && customDataValue instanceof NullNode == false) {
                                String customDataInstance;
                                customDataInstance = customDataValue.getTextValue();
                                osProfileInstance.setCustomData(customDataInstance);
                            }
                            
                            JsonNode windowsConfigurationValue2 = osProfileValue2.get("windowsConfiguration");
                            if (windowsConfigurationValue2 != null && windowsConfigurationValue2 instanceof NullNode == false) {
                                WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                
                                JsonNode provisionVMAgentValue = windowsConfigurationValue2.get("provisionVMAgent");
                                if (provisionVMAgentValue != null && provisionVMAgentValue instanceof NullNode == false) {
                                    boolean provisionVMAgentInstance;
                                    provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                    windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                }
                                
                                JsonNode enableAutomaticUpdatesValue = windowsConfigurationValue2.get("enableAutomaticUpdates");
                                if (enableAutomaticUpdatesValue != null && enableAutomaticUpdatesValue instanceof NullNode == false) {
                                    boolean enableAutomaticUpdatesInstance;
                                    enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                    windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                }
                                
                                JsonNode timeZoneValue = windowsConfigurationValue2.get("timeZone");
                                if (timeZoneValue != null && timeZoneValue instanceof NullNode == false) {
                                    String timeZoneInstance;
                                    timeZoneInstance = timeZoneValue.getTextValue();
                                    windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                }
                                
                                JsonNode additionalUnattendContentArray2 = windowsConfigurationValue2.get("additionalUnattendContent");
                                if (additionalUnattendContentArray2 != null && additionalUnattendContentArray2 instanceof NullNode == false) {
                                    for (JsonNode additionalUnattendContentValue2 : ((ArrayNode) additionalUnattendContentArray2)) {
                                        AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                        windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                        
                                        JsonNode passNameValue = additionalUnattendContentValue2.get("passName");
                                        if (passNameValue != null && passNameValue instanceof NullNode == false) {
                                            String passNameInstance;
                                            passNameInstance = passNameValue.getTextValue();
                                            additionalUnattendContentInstance.setPassName(passNameInstance);
                                        }
                                        
                                        JsonNode componentNameValue = additionalUnattendContentValue2.get("componentName");
                                        if (componentNameValue != null && componentNameValue instanceof NullNode == false) {
                                            String componentNameInstance;
                                            componentNameInstance = componentNameValue.getTextValue();
                                            additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                        }
                                        
                                        JsonNode settingNameValue = additionalUnattendContentValue2.get("settingName");
                                        if (settingNameValue != null && settingNameValue instanceof NullNode == false) {
                                            String settingNameInstance;
                                            settingNameInstance = settingNameValue.getTextValue();
                                            additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                        }
                                        
                                        JsonNode contentValue = additionalUnattendContentValue2.get("content");
                                        if (contentValue != null && contentValue instanceof NullNode == false) {
                                            String contentInstance;
                                            contentInstance = contentValue.getTextValue();
                                            additionalUnattendContentInstance.setContent(contentInstance);
                                        }
                                    }
                                }
                                
                                JsonNode winRMValue2 = windowsConfigurationValue2.get("winRM");
                                if (winRMValue2 != null && winRMValue2 instanceof NullNode == false) {
                                    WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                    windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                    
                                    JsonNode listenersArray2 = winRMValue2.get("listeners");
                                    if (listenersArray2 != null && listenersArray2 instanceof NullNode == false) {
                                        for (JsonNode listenersValue : ((ArrayNode) listenersArray2)) {
                                            WinRMListener winRMListenerInstance = new WinRMListener();
                                            winRMInstance.getListeners().add(winRMListenerInstance);
                                            
                                            JsonNode protocolValue = listenersValue.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                winRMListenerInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode certificateUrlValue = listenersValue.get("certificateUrl");
                                            if (certificateUrlValue != null && certificateUrlValue instanceof NullNode == false) {
                                                URI certificateUrlInstance;
                                                certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode linuxConfigurationValue2 = osProfileValue2.get("linuxConfiguration");
                            if (linuxConfigurationValue2 != null && linuxConfigurationValue2 instanceof NullNode == false) {
                                LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                
                                JsonNode disablePasswordAuthenticationValue = linuxConfigurationValue2.get("disablePasswordAuthentication");
                                if (disablePasswordAuthenticationValue != null && disablePasswordAuthenticationValue instanceof NullNode == false) {
                                    boolean disablePasswordAuthenticationInstance;
                                    disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                    linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                }
                                
                                JsonNode sshValue2 = linuxConfigurationValue2.get("ssh");
                                if (sshValue2 != null && sshValue2 instanceof NullNode == false) {
                                    SshConfiguration sshInstance = new SshConfiguration();
                                    linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                    
                                    JsonNode publicKeysArray2 = sshValue2.get("publicKeys");
                                    if (publicKeysArray2 != null && publicKeysArray2 instanceof NullNode == false) {
                                        for (JsonNode publicKeysValue : ((ArrayNode) publicKeysArray2)) {
                                            SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                            sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                            
                                            JsonNode pathValue = publicKeysValue.get("path");
                                            if (pathValue != null && pathValue instanceof NullNode == false) {
                                                String pathInstance;
                                                pathInstance = pathValue.getTextValue();
                                                sshPublicKeyInstance.setPath(pathInstance);
                                            }
                                            
                                            JsonNode keyDataValue = publicKeysValue.get("keyData");
                                            if (keyDataValue != null && keyDataValue instanceof NullNode == false) {
                                                String keyDataInstance;
                                                keyDataInstance = keyDataValue.getTextValue();
                                                sshPublicKeyInstance.setKeyData(keyDataInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode secretsArray2 = osProfileValue2.get("secrets");
                            if (secretsArray2 != null && secretsArray2 instanceof NullNode == false) {
                                for (JsonNode secretsValue : ((ArrayNode) secretsArray2)) {
                                    VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                    osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                    
                                    JsonNode sourceVaultValue2 = secretsValue.get("sourceVault");
                                    if (sourceVaultValue2 != null && sourceVaultValue2 instanceof NullNode == false) {
                                        SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                        vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                        
                                        JsonNode idValue = sourceVaultValue2.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            sourceVaultInstance.setReferenceUri(idInstance);
                                        }
                                    }
                                    
                                    JsonNode vaultCertificatesArray2 = secretsValue.get("vaultCertificates");
                                    if (vaultCertificatesArray2 != null && vaultCertificatesArray2 instanceof NullNode == false) {
                                        for (JsonNode vaultCertificatesValue : ((ArrayNode) vaultCertificatesArray2)) {
                                            VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                            vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                            
                                            JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                            if (certificateUrlValue2 != null && certificateUrlValue2 instanceof NullNode == false) {
                                                String certificateUrlInstance2;
                                                certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                            }
                                            
                                            JsonNode certificateStoreValue = vaultCertificatesValue.get("certificateStore");
                                            if (certificateStoreValue != null && certificateStoreValue instanceof NullNode == false) {
                                                String certificateStoreInstance;
                                                certificateStoreInstance = certificateStoreValue.getTextValue();
                                                vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                        JsonNode networkProfileValue2 = propertiesValue4.get("networkProfile");
                        if (networkProfileValue2 != null && networkProfileValue2 instanceof NullNode == false) {
                            NetworkProfile networkProfileInstance = new NetworkProfile();
                            virtualMachineInstance.setNetworkProfile(networkProfileInstance);
                            
                            JsonNode networkInterfacesArray2 = networkProfileValue2.get("networkInterfaces");
                            if (networkInterfacesArray2 != null && networkInterfacesArray2 instanceof NullNode == false) {
                                for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray2)) {
                                    NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                    networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                    
                                    JsonNode propertiesValue5 = networkInterfacesValue.get("properties");
                                    if (propertiesValue5 != null && propertiesValue5 instanceof NullNode == false) {
                                        JsonNode primaryValue = propertiesValue5.get("primary");
                                        if (primaryValue != null && primaryValue instanceof NullNode == false) {
                                            boolean primaryInstance;
                                            primaryInstance = primaryValue.getBooleanValue();
                                            networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                        }
                                    }
                                    
                                    JsonNode idValue2 = networkInterfacesValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode diagnosticsProfileValue2 = propertiesValue4.get("diagnosticsProfile");
                        if (diagnosticsProfileValue2 != null && diagnosticsProfileValue2 instanceof NullNode == false) {
                            DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                            virtualMachineInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                            
                            JsonNode bootDiagnosticsValue3 = diagnosticsProfileValue2.get("bootDiagnostics");
                            if (bootDiagnosticsValue3 != null && bootDiagnosticsValue3 instanceof NullNode == false) {
                                BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                
                                JsonNode enabledValue = bootDiagnosticsValue3.get("enabled");
                                if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                    boolean enabledInstance;
                                    enabledInstance = enabledValue.getBooleanValue();
                                    bootDiagnosticsInstance.setEnabled(enabledInstance);
                                }
                                
                                JsonNode storageUriValue = bootDiagnosticsValue3.get("storageUri");
                                if (storageUriValue != null && storageUriValue instanceof NullNode == false) {
                                    URI storageUriInstance;
                                    storageUriInstance = new URI(storageUriValue.getTextValue());
                                    bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                }
                            }
                        }
                        
                        JsonNode availabilitySetValue2 = propertiesValue4.get("availabilitySet");
                        if (availabilitySetValue2 != null && availabilitySetValue2 instanceof NullNode == false) {
                            AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                            virtualMachineInstance.setAvailabilitySetReference(availabilitySetInstance);
                            
                            JsonNode idValue3 = availabilitySetValue2.get("id");
                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                String idInstance3;
                                idInstance3 = idValue3.getTextValue();
                                availabilitySetInstance.setReferenceUri(idInstance3);
                            }
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue4.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode instanceViewValue3 = propertiesValue4.get("instanceView");
                        if (instanceViewValue3 != null && instanceViewValue3 instanceof NullNode == false) {
                            VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                            virtualMachineInstance.setInstanceView(instanceViewInstance);
                            
                            JsonNode platformUpdateDomainValue = instanceViewValue3.get("platformUpdateDomain");
                            if (platformUpdateDomainValue != null && platformUpdateDomainValue instanceof NullNode == false) {
                                int platformUpdateDomainInstance;
                                platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                            }
                            
                            JsonNode platformFaultDomainValue = instanceViewValue3.get("platformFaultDomain");
                            if (platformFaultDomainValue != null && platformFaultDomainValue instanceof NullNode == false) {
                                int platformFaultDomainInstance;
                                platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                            }
                            
                            JsonNode rdpThumbPrintValue = instanceViewValue3.get("rdpThumbPrint");
                            if (rdpThumbPrintValue != null && rdpThumbPrintValue instanceof NullNode == false) {
                                String rdpThumbPrintInstance;
                                rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                            }
                            
                            JsonNode vmAgentValue2 = instanceViewValue3.get("vmAgent");
                            if (vmAgentValue2 != null && vmAgentValue2 instanceof NullNode == false) {
                                VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                instanceViewInstance.setVMAgent(vmAgentInstance);
                                
                                JsonNode vmAgentVersionValue = vmAgentValue2.get("vmAgentVersion");
                                if (vmAgentVersionValue != null && vmAgentVersionValue instanceof NullNode == false) {
                                    String vmAgentVersionInstance;
                                    vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                    vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                }
                                
                                JsonNode extensionHandlersArray2 = vmAgentValue2.get("extensionHandlers");
                                if (extensionHandlersArray2 != null && extensionHandlersArray2 instanceof NullNode == false) {
                                    for (JsonNode extensionHandlersValue : ((ArrayNode) extensionHandlersArray2)) {
                                        VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                        vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                        
                                        JsonNode typeValue = extensionHandlersValue.get("type");
                                        if (typeValue != null && typeValue instanceof NullNode == false) {
                                            String typeInstance;
                                            typeInstance = typeValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                        }
                                        
                                        JsonNode typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion");
                                        if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                                            String typeHandlerVersionInstance;
                                            typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                        }
                                        
                                        JsonNode statusValue2 = extensionHandlersValue.get("status");
                                        if (statusValue2 != null && statusValue2 instanceof NullNode == false) {
                                            InstanceViewStatus statusInstance = new InstanceViewStatus();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                            
                                            JsonNode codeValue = statusValue2.get("code");
                                            if (codeValue != null && codeValue instanceof NullNode == false) {
                                                String codeInstance;
                                                codeInstance = codeValue.getTextValue();
                                                statusInstance.setCode(codeInstance);
                                            }
                                            
                                            JsonNode levelValue = statusValue2.get("level");
                                            if (levelValue != null && levelValue instanceof NullNode == false) {
                                                String levelInstance;
                                                levelInstance = levelValue.getTextValue();
                                                statusInstance.setLevel(levelInstance);
                                            }
                                            
                                            JsonNode displayStatusValue = statusValue2.get("displayStatus");
                                            if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                                String displayStatusInstance;
                                                displayStatusInstance = displayStatusValue.getTextValue();
                                                statusInstance.setDisplayStatus(displayStatusInstance);
                                            }
                                            
                                            JsonNode messageValue = statusValue2.get("message");
                                            if (messageValue != null && messageValue instanceof NullNode == false) {
                                                String messageInstance;
                                                messageInstance = messageValue.getTextValue();
                                                statusInstance.setMessage(messageInstance);
                                            }
                                            
                                            JsonNode timeValue = statusValue2.get("time");
                                            if (timeValue != null && timeValue instanceof NullNode == false) {
                                                Calendar timeInstance;
                                                timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                                statusInstance.setTime(timeInstance);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode statusesArray6 = vmAgentValue2.get("statuses");
                                if (statusesArray6 != null && statusesArray6 instanceof NullNode == false) {
                                    for (JsonNode statusesValue : ((ArrayNode) statusesArray6)) {
                                        InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                        vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                        
                                        JsonNode codeValue2 = statusesValue.get("code");
                                        if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                            String codeInstance2;
                                            codeInstance2 = codeValue2.getTextValue();
                                            instanceViewStatusInstance.setCode(codeInstance2);
                                        }
                                        
                                        JsonNode levelValue2 = statusesValue.get("level");
                                        if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                            String levelInstance2;
                                            levelInstance2 = levelValue2.getTextValue();
                                            instanceViewStatusInstance.setLevel(levelInstance2);
                                        }
                                        
                                        JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                        if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                            String displayStatusInstance2;
                                            displayStatusInstance2 = displayStatusValue2.getTextValue();
                                            instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                        }
                                        
                                        JsonNode messageValue2 = statusesValue.get("message");
                                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                            String messageInstance2;
                                            messageInstance2 = messageValue2.getTextValue();
                                            instanceViewStatusInstance.setMessage(messageInstance2);
                                        }
                                        
                                        JsonNode timeValue2 = statusesValue.get("time");
                                        if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                            Calendar timeInstance2;
                                            timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                            instanceViewStatusInstance.setTime(timeInstance2);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode disksArray2 = instanceViewValue3.get("disks");
                            if (disksArray2 != null && disksArray2 instanceof NullNode == false) {
                                for (JsonNode disksValue : ((ArrayNode) disksArray2)) {
                                    DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                    instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                    
                                    JsonNode nameValue4 = disksValue.get("name");
                                    if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                        String nameInstance4;
                                        nameInstance4 = nameValue4.getTextValue();
                                        diskInstanceViewInstance.setName(nameInstance4);
                                    }
                                    
                                    JsonNode statusesArray7 = disksValue.get("statuses");
                                    if (statusesArray7 != null && statusesArray7 instanceof NullNode == false) {
                                        for (JsonNode statusesValue2 : ((ArrayNode) statusesArray7)) {
                                            InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                            diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                            
                                            JsonNode codeValue3 = statusesValue2.get("code");
                                            if (codeValue3 != null && codeValue3 instanceof NullNode == false) {
                                                String codeInstance3;
                                                codeInstance3 = codeValue3.getTextValue();
                                                instanceViewStatusInstance2.setCode(codeInstance3);
                                            }
                                            
                                            JsonNode levelValue3 = statusesValue2.get("level");
                                            if (levelValue3 != null && levelValue3 instanceof NullNode == false) {
                                                String levelInstance3;
                                                levelInstance3 = levelValue3.getTextValue();
                                                instanceViewStatusInstance2.setLevel(levelInstance3);
                                            }
                                            
                                            JsonNode displayStatusValue3 = statusesValue2.get("displayStatus");
                                            if (displayStatusValue3 != null && displayStatusValue3 instanceof NullNode == false) {
                                                String displayStatusInstance3;
                                                displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                            }
                                            
                                            JsonNode messageValue3 = statusesValue2.get("message");
                                            if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                                String messageInstance3;
                                                messageInstance3 = messageValue3.getTextValue();
                                                instanceViewStatusInstance2.setMessage(messageInstance3);
                                            }
                                            
                                            JsonNode timeValue3 = statusesValue2.get("time");
                                            if (timeValue3 != null && timeValue3 instanceof NullNode == false) {
                                                Calendar timeInstance3;
                                                timeInstance3 = DatatypeConverter.parseDateTime(timeValue3.getTextValue());
                                                instanceViewStatusInstance2.setTime(timeInstance3);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode extensionsArray2 = instanceViewValue3.get("extensions");
                            if (extensionsArray2 != null && extensionsArray2 instanceof NullNode == false) {
                                for (JsonNode extensionsValue : ((ArrayNode) extensionsArray2)) {
                                    VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                    instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                    
                                    JsonNode nameValue5 = extensionsValue.get("name");
                                    if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                        String nameInstance5;
                                        nameInstance5 = nameValue5.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                    }
                                    
                                    JsonNode typeValue2 = extensionsValue.get("type");
                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                        String typeInstance2;
                                        typeInstance2 = typeValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                    }
                                    
                                    JsonNode typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion");
                                    if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                        String typeHandlerVersionInstance2;
                                        typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                    }
                                    
                                    JsonNode substatusesArray3 = extensionsValue.get("substatuses");
                                    if (substatusesArray3 != null && substatusesArray3 instanceof NullNode == false) {
                                        for (JsonNode substatusesValue : ((ArrayNode) substatusesArray3)) {
                                            InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                            
                                            JsonNode codeValue4 = substatusesValue.get("code");
                                            if (codeValue4 != null && codeValue4 instanceof NullNode == false) {
                                                String codeInstance4;
                                                codeInstance4 = codeValue4.getTextValue();
                                                instanceViewStatusInstance3.setCode(codeInstance4);
                                            }
                                            
                                            JsonNode levelValue4 = substatusesValue.get("level");
                                            if (levelValue4 != null && levelValue4 instanceof NullNode == false) {
                                                String levelInstance4;
                                                levelInstance4 = levelValue4.getTextValue();
                                                instanceViewStatusInstance3.setLevel(levelInstance4);
                                            }
                                            
                                            JsonNode displayStatusValue4 = substatusesValue.get("displayStatus");
                                            if (displayStatusValue4 != null && displayStatusValue4 instanceof NullNode == false) {
                                                String displayStatusInstance4;
                                                displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                            }
                                            
                                            JsonNode messageValue4 = substatusesValue.get("message");
                                            if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                                String messageInstance4;
                                                messageInstance4 = messageValue4.getTextValue();
                                                instanceViewStatusInstance3.setMessage(messageInstance4);
                                            }
                                            
                                            JsonNode timeValue4 = substatusesValue.get("time");
                                            if (timeValue4 != null && timeValue4 instanceof NullNode == false) {
                                                Calendar timeInstance4;
                                                timeInstance4 = DatatypeConverter.parseDateTime(timeValue4.getTextValue());
                                                instanceViewStatusInstance3.setTime(timeInstance4);
                                            }
                                        }
                                    }
                                    
                                    JsonNode statusesArray8 = extensionsValue.get("statuses");
                                    if (statusesArray8 != null && statusesArray8 instanceof NullNode == false) {
                                        for (JsonNode statusesValue3 : ((ArrayNode) statusesArray8)) {
                                            InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                            
                                            JsonNode codeValue5 = statusesValue3.get("code");
                                            if (codeValue5 != null && codeValue5 instanceof NullNode == false) {
                                                String codeInstance5;
                                                codeInstance5 = codeValue5.getTextValue();
                                                instanceViewStatusInstance4.setCode(codeInstance5);
                                            }
                                            
                                            JsonNode levelValue5 = statusesValue3.get("level");
                                            if (levelValue5 != null && levelValue5 instanceof NullNode == false) {
                                                String levelInstance5;
                                                levelInstance5 = levelValue5.getTextValue();
                                                instanceViewStatusInstance4.setLevel(levelInstance5);
                                            }
                                            
                                            JsonNode displayStatusValue5 = statusesValue3.get("displayStatus");
                                            if (displayStatusValue5 != null && displayStatusValue5 instanceof NullNode == false) {
                                                String displayStatusInstance5;
                                                displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                            }
                                            
                                            JsonNode messageValue5 = statusesValue3.get("message");
                                            if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                                String messageInstance5;
                                                messageInstance5 = messageValue5.getTextValue();
                                                instanceViewStatusInstance4.setMessage(messageInstance5);
                                            }
                                            
                                            JsonNode timeValue5 = statusesValue3.get("time");
                                            if (timeValue5 != null && timeValue5 instanceof NullNode == false) {
                                                Calendar timeInstance5;
                                                timeInstance5 = DatatypeConverter.parseDateTime(timeValue5.getTextValue());
                                                instanceViewStatusInstance4.setTime(timeInstance5);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode bootDiagnosticsValue4 = instanceViewValue3.get("bootDiagnostics");
                            if (bootDiagnosticsValue4 != null && bootDiagnosticsValue4 instanceof NullNode == false) {
                                BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                
                                JsonNode consoleScreenshotBlobUriValue = bootDiagnosticsValue4.get("consoleScreenshotBlobUri");
                                if (consoleScreenshotBlobUriValue != null && consoleScreenshotBlobUriValue instanceof NullNode == false) {
                                    URI consoleScreenshotBlobUriInstance;
                                    consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                }
                                
                                JsonNode serialConsoleLogBlobUriValue = bootDiagnosticsValue4.get("serialConsoleLogBlobUri");
                                if (serialConsoleLogBlobUriValue != null && serialConsoleLogBlobUriValue instanceof NullNode == false) {
                                    URI serialConsoleLogBlobUriInstance;
                                    serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                }
                            }
                            
                            JsonNode statusesArray9 = instanceViewValue3.get("statuses");
                            if (statusesArray9 != null && statusesArray9 instanceof NullNode == false) {
                                for (JsonNode statusesValue4 : ((ArrayNode) statusesArray9)) {
                                    InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                    
                                    JsonNode codeValue6 = statusesValue4.get("code");
                                    if (codeValue6 != null && codeValue6 instanceof NullNode == false) {
                                        String codeInstance6;
                                        codeInstance6 = codeValue6.getTextValue();
                                        instanceViewStatusInstance5.setCode(codeInstance6);
                                    }
                                    
                                    JsonNode levelValue6 = statusesValue4.get("level");
                                    if (levelValue6 != null && levelValue6 instanceof NullNode == false) {
                                        String levelInstance6;
                                        levelInstance6 = levelValue6.getTextValue();
                                        instanceViewStatusInstance5.setLevel(levelInstance6);
                                    }
                                    
                                    JsonNode displayStatusValue6 = statusesValue4.get("displayStatus");
                                    if (displayStatusValue6 != null && displayStatusValue6 instanceof NullNode == false) {
                                        String displayStatusInstance6;
                                        displayStatusInstance6 = displayStatusValue6.getTextValue();
                                        instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                    }
                                    
                                    JsonNode messageValue6 = statusesValue4.get("message");
                                    if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                        String messageInstance6;
                                        messageInstance6 = messageValue6.getTextValue();
                                        instanceViewStatusInstance5.setMessage(messageInstance6);
                                    }
                                    
                                    JsonNode timeValue6 = statusesValue4.get("time");
                                    if (timeValue6 != null && timeValue6 instanceof NullNode == false) {
                                        Calendar timeInstance6;
                                        timeInstance6 = DatatypeConverter.parseDateTime(timeValue6.getTextValue());
                                        instanceViewStatusInstance5.setTime(timeInstance6);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode resourcesArray2 = responseDoc.get("resources");
                    if (resourcesArray2 != null && resourcesArray2 instanceof NullNode == false) {
                        virtualMachineInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                        for (JsonNode resourcesValue : ((ArrayNode) resourcesArray2)) {
                            VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                            virtualMachineInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                            
                            JsonNode propertiesValue6 = resourcesValue.get("properties");
                            if (propertiesValue6 != null && propertiesValue6 instanceof NullNode == false) {
                                JsonNode publisherValue3 = propertiesValue6.get("publisher");
                                if (publisherValue3 != null && publisherValue3 instanceof NullNode == false) {
                                    String publisherInstance3;
                                    publisherInstance3 = publisherValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                }
                                
                                JsonNode typeValue3 = propertiesValue6.get("type");
                                if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                    String typeInstance3;
                                    typeInstance3 = typeValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                }
                                
                                JsonNode typeHandlerVersionValue3 = propertiesValue6.get("typeHandlerVersion");
                                if (typeHandlerVersionValue3 != null && typeHandlerVersionValue3 instanceof NullNode == false) {
                                    String typeHandlerVersionInstance3;
                                    typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                }
                                
                                JsonNode autoUpgradeMinorVersionValue = propertiesValue6.get("autoUpgradeMinorVersion");
                                if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                                    boolean autoUpgradeMinorVersionInstance;
                                    autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                    virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                }
                                
                                JsonNode settingsValue = propertiesValue6.get("settings");
                                if (settingsValue != null && settingsValue instanceof NullNode == false) {
                                    String settingsInstance;
                                    settingsInstance = settingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                }
                                
                                JsonNode protectedSettingsValue = propertiesValue6.get("protectedSettings");
                                if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                                    String protectedSettingsInstance;
                                    protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                }
                                
                                JsonNode provisioningStateValue2 = propertiesValue6.get("provisioningState");
                                if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                    String provisioningStateInstance2;
                                    provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                }
                                
                                JsonNode instanceViewValue4 = propertiesValue6.get("instanceView");
                                if (instanceViewValue4 != null && instanceViewValue4 instanceof NullNode == false) {
                                    VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                    virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                    
                                    JsonNode nameValue6 = instanceViewValue4.get("name");
                                    if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                        String nameInstance6;
                                        nameInstance6 = nameValue6.getTextValue();
                                        instanceViewInstance2.setName(nameInstance6);
                                    }
                                    
                                    JsonNode typeValue4 = instanceViewValue4.get("type");
                                    if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                        String typeInstance4;
                                        typeInstance4 = typeValue4.getTextValue();
                                        instanceViewInstance2.setExtensionType(typeInstance4);
                                    }
                                    
                                    JsonNode typeHandlerVersionValue4 = instanceViewValue4.get("typeHandlerVersion");
                                    if (typeHandlerVersionValue4 != null && typeHandlerVersionValue4 instanceof NullNode == false) {
                                        String typeHandlerVersionInstance4;
                                        typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                        instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                    }
                                    
                                    JsonNode substatusesArray4 = instanceViewValue4.get("substatuses");
                                    if (substatusesArray4 != null && substatusesArray4 instanceof NullNode == false) {
                                        for (JsonNode substatusesValue2 : ((ArrayNode) substatusesArray4)) {
                                            InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                            instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                            
                                            JsonNode codeValue7 = substatusesValue2.get("code");
                                            if (codeValue7 != null && codeValue7 instanceof NullNode == false) {
                                                String codeInstance7;
                                                codeInstance7 = codeValue7.getTextValue();
                                                instanceViewStatusInstance6.setCode(codeInstance7);
                                            }
                                            
                                            JsonNode levelValue7 = substatusesValue2.get("level");
                                            if (levelValue7 != null && levelValue7 instanceof NullNode == false) {
                                                String levelInstance7;
                                                levelInstance7 = levelValue7.getTextValue();
                                                instanceViewStatusInstance6.setLevel(levelInstance7);
                                            }
                                            
                                            JsonNode displayStatusValue7 = substatusesValue2.get("displayStatus");
                                            if (displayStatusValue7 != null && displayStatusValue7 instanceof NullNode == false) {
                                                String displayStatusInstance7;
                                                displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                            }
                                            
                                            JsonNode messageValue7 = substatusesValue2.get("message");
                                            if (messageValue7 != null && messageValue7 instanceof NullNode == false) {
                                                String messageInstance7;
                                                messageInstance7 = messageValue7.getTextValue();
                                                instanceViewStatusInstance6.setMessage(messageInstance7);
                                            }
                                            
                                            JsonNode timeValue7 = substatusesValue2.get("time");
                                            if (timeValue7 != null && timeValue7 instanceof NullNode == false) {
                                                Calendar timeInstance7;
                                                timeInstance7 = DatatypeConverter.parseDateTime(timeValue7.getTextValue());
                                                instanceViewStatusInstance6.setTime(timeInstance7);
                                            }
                                        }
                                    }
                                    
                                    JsonNode statusesArray10 = instanceViewValue4.get("statuses");
                                    if (statusesArray10 != null && statusesArray10 instanceof NullNode == false) {
                                        for (JsonNode statusesValue5 : ((ArrayNode) statusesArray10)) {
                                            InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                            instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                            
                                            JsonNode codeValue8 = statusesValue5.get("code");
                                            if (codeValue8 != null && codeValue8 instanceof NullNode == false) {
                                                String codeInstance8;
                                                codeInstance8 = codeValue8.getTextValue();
                                                instanceViewStatusInstance7.setCode(codeInstance8);
                                            }
                                            
                                            JsonNode levelValue8 = statusesValue5.get("level");
                                            if (levelValue8 != null && levelValue8 instanceof NullNode == false) {
                                                String levelInstance8;
                                                levelInstance8 = levelValue8.getTextValue();
                                                instanceViewStatusInstance7.setLevel(levelInstance8);
                                            }
                                            
                                            JsonNode displayStatusValue8 = statusesValue5.get("displayStatus");
                                            if (displayStatusValue8 != null && displayStatusValue8 instanceof NullNode == false) {
                                                String displayStatusInstance8;
                                                displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                            }
                                            
                                            JsonNode messageValue8 = statusesValue5.get("message");
                                            if (messageValue8 != null && messageValue8 instanceof NullNode == false) {
                                                String messageInstance8;
                                                messageInstance8 = messageValue8.getTextValue();
                                                instanceViewStatusInstance7.setMessage(messageInstance8);
                                            }
                                            
                                            JsonNode timeValue8 = statusesValue5.get("time");
                                            if (timeValue8 != null && timeValue8 instanceof NullNode == false) {
                                                Calendar timeInstance8;
                                                timeInstance8 = DatatypeConverter.parseDateTime(timeValue8.getTextValue());
                                                instanceViewStatusInstance7.setTime(timeInstance8);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue4 = resourcesValue.get("id");
                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                String idInstance4;
                                idInstance4 = idValue4.getTextValue();
                                virtualMachineExtensionJsonInstance.setId(idInstance4);
                            }
                            
                            JsonNode nameValue7 = resourcesValue.get("name");
                            if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                String nameInstance7;
                                nameInstance7 = nameValue7.getTextValue();
                                virtualMachineExtensionJsonInstance.setName(nameInstance7);
                            }
                            
                            JsonNode typeValue5 = resourcesValue.get("type");
                            if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                String typeInstance5;
                                typeInstance5 = typeValue5.getTextValue();
                                virtualMachineExtensionJsonInstance.setType(typeInstance5);
                            }
                            
                            JsonNode locationValue = resourcesValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) resourcesValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey3 = property.getKey();
                                    String tagsValue3 = property.getValue().getTextValue();
                                    virtualMachineExtensionJsonInstance.getTags().put(tagsKey3, tagsValue3);
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue5 = responseDoc.get("id");
                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                        String idInstance5;
                        idInstance5 = idValue5.getTextValue();
                        virtualMachineInstance.setId(idInstance5);
                    }
                    
                    JsonNode nameValue8 = responseDoc.get("name");
                    if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                        String nameInstance8;
                        nameInstance8 = nameValue8.getTextValue();
                        virtualMachineInstance.setName(nameInstance8);
                    }
                    
                    JsonNode typeValue6 = responseDoc.get("type");
                    if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                        String typeInstance6;
                        typeInstance6 = typeValue6.getTextValue();
                        virtualMachineInstance.setType(typeInstance6);
                    }
                    
                    JsonNode locationValue2 = responseDoc.get("location");
                    if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                        String locationInstance2;
                        locationInstance2 = locationValue2.getTextValue();
                        virtualMachineInstance.setLocation(locationInstance2);
                    }
                    
                    JsonNode tagsSequenceElement2 = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                        while (itr2.hasNext()) {
                            Map.Entry<String, JsonNode> property2 = itr2.next();
                            String tagsKey4 = property2.getKey();
                            String tagsValue4 = property2.getValue().getTextValue();
                            virtualMachineInstance.getTags().put(tagsKey4, tagsValue4);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Shuts down the Virtual Machine and releases the compute resources. You
    * are not billed for the compute resources that this Virtual Machine uses.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The compute long running operation response.
    */
    @Override
    public Future<ComputeOperationResponse> beginDeallocatingAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>() { 
            @Override
            public ComputeOperationResponse call() throws Exception {
                return beginDeallocating(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * Shuts down the Virtual Machine and releases the compute resources. You
    * are not billed for the compute resources that this Virtual Machine uses.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    @Override
    public ComputeOperationResponse beginDeallocating(String resourceGroupName, String vmName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "beginDeallocatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/deallocate";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ComputeOperationResponse result = null;
            // Deserialize Response
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to delete a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The compute long running operation response.
    */
    @Override
    public Future<DeleteOperationResponse> beginDeletingAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<DeleteOperationResponse>() { 
            @Override
            public DeleteOperationResponse call() throws Exception {
                return beginDeleting(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to delete a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    @Override
    public DeleteOperationResponse beginDeleting(String resourceGroupName, String vmName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "beginDeletingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK && statusCode != HttpStatus.SC_ACCEPTED && statusCode != HttpStatus.SC_NO_CONTENT) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeleteOperationResponse result = null;
            // Deserialize Response
            result = new DeleteOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == HttpStatus.SC_CONFLICT) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == HttpStatus.SC_OK) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (statusCode == HttpStatus.SC_NO_CONTENT) {
                result.setStatus(OperationStatus.Succeeded);
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to power off (stop) a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The compute long running operation response.
    */
    @Override
    public Future<ComputeOperationResponse> beginPoweringOffAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>() { 
            @Override
            public ComputeOperationResponse call() throws Exception {
                return beginPoweringOff(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to power off (stop) a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    @Override
    public ComputeOperationResponse beginPoweringOff(String resourceGroupName, String vmName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "beginPoweringOffAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/powerOff";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ComputeOperationResponse result = null;
            // Deserialize Response
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to restart a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The compute long running operation response.
    */
    @Override
    public Future<ComputeOperationResponse> beginRestartingAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>() { 
            @Override
            public ComputeOperationResponse call() throws Exception {
                return beginRestarting(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to restart a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    @Override
    public ComputeOperationResponse beginRestarting(String resourceGroupName, String vmName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "beginRestartingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/restart";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ComputeOperationResponse result = null;
            // Deserialize Response
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to start a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The compute long running operation response.
    */
    @Override
    public Future<ComputeOperationResponse> beginStartingAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>() { 
            @Override
            public ComputeOperationResponse call() throws Exception {
                return beginStarting(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to start a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The compute long running operation response.
    */
    @Override
    public ComputeOperationResponse beginStarting(String resourceGroupName, String vmName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "beginStartingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/start";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ComputeOperationResponse result = null;
            // Deserialize Response
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Captures the VM by copying VirtualHardDisks of the VM and outputs a
    * template that can be used to create similar VMs.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public Future<ComputeLongRunningOperationResponse> captureAsync(final String resourceGroupName, final String vmName, final VirtualMachineCaptureParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>() { 
            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return capture(resourceGroupName, vmName, parameters);
            }
         });
    }
    
    /**
    * Captures the VM by copying VirtualHardDisks of the VM and outputs a
    * template that can be used to create similar VMs.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @param parameters Required. Parameters supplied to the Capture Virtual
    * Machine operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public ComputeLongRunningOperationResponse capture(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "captureAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginCapturingAsync(resourceGroupName, vmName, parameters).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(com.microsoft.azure.management.compute.models.ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The operation to create or update a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine operation.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public Future<ComputeLongRunningOperationResponse> createOrUpdateAsync(final String resourceGroupName, final VirtualMachine parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>() { 
            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, parameters);
            }
         });
    }
    
    /**
    * The operation to create or update a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Required. Parameters supplied to the Create Virtual
    * Machine operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public ComputeLongRunningOperationResponse createOrUpdate(String resourceGroupName, VirtualMachine parameters) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            VirtualMachineCreateOrUpdateResponse response = client2.getVirtualMachinesOperations().beginCreatingOrUpdatingAsync(resourceGroupName, parameters).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(com.microsoft.azure.management.compute.models.ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Shuts down the Virtual Machine and releases the compute resources. You
    * are not billed for the compute resources that this Virtual Machine uses.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public Future<ComputeLongRunningOperationResponse> deallocateAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>() { 
            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return deallocate(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * Shuts down the Virtual Machine and releases the compute resources. You
    * are not billed for the compute resources that this Virtual Machine uses.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public ComputeLongRunningOperationResponse deallocate(String resourceGroupName, String vmName) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "deallocateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginDeallocatingAsync(resourceGroupName, vmName).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(com.microsoft.azure.management.compute.models.ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The operation to delete a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The compute long running operation response.
    */
    @Override
    public Future<DeleteOperationResponse> deleteAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<DeleteOperationResponse>() { 
            @Override
            public DeleteOperationResponse call() throws Exception {
                return delete(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to delete a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @return The compute long running operation response.
    */
    @Override
    public DeleteOperationResponse delete(String resourceGroupName, String vmName) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            DeleteOperationResponse response = client2.getVirtualMachinesOperations().beginDeletingAsync(resourceGroupName, vmName).get();
            if (response.getStatus() == OperationStatus.Succeeded) {
                return response;
            }
            DeleteOperationResponse result = client2.getDeleteOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getDeleteOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Sets the state of the VM as Generalized.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> generalizeAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return generalize(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * Sets the state of the VM as Generalized.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse generalize(String resourceGroupName, String vmName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "generalizeAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/generalize";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to get a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The GetVM operation response.
    */
    @Override
    public Future<VirtualMachineGetResponse> getAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineGetResponse>() { 
            @Override
            public VirtualMachineGetResponse call() throws Exception {
                return get(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to get a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The GetVM operation response.
    */
    @Override
    public VirtualMachineGetResponse get(String resourceGroupName, String vmName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualMachine virtualMachineInstance = new VirtualMachine();
                    result.setVirtualMachine(virtualMachineInstance);
                    
                    JsonNode planValue = responseDoc.get("plan");
                    if (planValue != null && planValue instanceof NullNode == false) {
                        Plan planInstance = new Plan();
                        virtualMachineInstance.setPlan(planInstance);
                        
                        JsonNode nameValue = planValue.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        
                        JsonNode publisherValue = planValue.get("publisher");
                        if (publisherValue != null && publisherValue instanceof NullNode == false) {
                            String publisherInstance;
                            publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        
                        JsonNode productValue = planValue.get("product");
                        if (productValue != null && productValue instanceof NullNode == false) {
                            String productInstance;
                            productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        
                        JsonNode promotionCodeValue = planValue.get("promotionCode");
                        if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                            String promotionCodeInstance;
                            promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                        if (hardwareProfileValue != null && hardwareProfileValue instanceof NullNode == false) {
                            HardwareProfile hardwareProfileInstance = new HardwareProfile();
                            virtualMachineInstance.setHardwareProfile(hardwareProfileInstance);
                            
                            JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                            if (vmSizeValue != null && vmSizeValue instanceof NullNode == false) {
                                String vmSizeInstance;
                                vmSizeInstance = vmSizeValue.getTextValue();
                                hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                            }
                        }
                        
                        JsonNode storageProfileValue = propertiesValue.get("storageProfile");
                        if (storageProfileValue != null && storageProfileValue instanceof NullNode == false) {
                            StorageProfile storageProfileInstance = new StorageProfile();
                            virtualMachineInstance.setStorageProfile(storageProfileInstance);
                            
                            JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                            if (imageReferenceValue != null && imageReferenceValue instanceof NullNode == false) {
                                ImageReference imageReferenceInstance = new ImageReference();
                                storageProfileInstance.setImageReference(imageReferenceInstance);
                                
                                JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                if (publisherValue2 != null && publisherValue2 instanceof NullNode == false) {
                                    String publisherInstance2;
                                    publisherInstance2 = publisherValue2.getTextValue();
                                    imageReferenceInstance.setPublisher(publisherInstance2);
                                }
                                
                                JsonNode offerValue = imageReferenceValue.get("offer");
                                if (offerValue != null && offerValue instanceof NullNode == false) {
                                    String offerInstance;
                                    offerInstance = offerValue.getTextValue();
                                    imageReferenceInstance.setOffer(offerInstance);
                                }
                                
                                JsonNode skuValue = imageReferenceValue.get("sku");
                                if (skuValue != null && skuValue instanceof NullNode == false) {
                                    String skuInstance;
                                    skuInstance = skuValue.getTextValue();
                                    imageReferenceInstance.setSku(skuInstance);
                                }
                                
                                JsonNode versionValue = imageReferenceValue.get("version");
                                if (versionValue != null && versionValue instanceof NullNode == false) {
                                    String versionInstance;
                                    versionInstance = versionValue.getTextValue();
                                    imageReferenceInstance.setVersion(versionInstance);
                                }
                            }
                            
                            JsonNode osDiskValue = storageProfileValue.get("osDisk");
                            if (osDiskValue != null && osDiskValue instanceof NullNode == false) {
                                OSDisk osDiskInstance = new OSDisk();
                                storageProfileInstance.setOSDisk(osDiskInstance);
                                
                                JsonNode osTypeValue = osDiskValue.get("osType");
                                if (osTypeValue != null && osTypeValue instanceof NullNode == false) {
                                    String osTypeInstance;
                                    osTypeInstance = osTypeValue.getTextValue();
                                    osDiskInstance.setOperatingSystemType(osTypeInstance);
                                }
                                
                                JsonNode nameValue2 = osDiskValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    osDiskInstance.setName(nameInstance2);
                                }
                                
                                JsonNode vhdValue = osDiskValue.get("vhd");
                                if (vhdValue != null && vhdValue instanceof NullNode == false) {
                                    VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                    osDiskInstance.setVirtualHardDisk(vhdInstance);
                                    
                                    JsonNode uriValue = vhdValue.get("uri");
                                    if (uriValue != null && uriValue instanceof NullNode == false) {
                                        String uriInstance;
                                        uriInstance = uriValue.getTextValue();
                                        vhdInstance.setUri(uriInstance);
                                    }
                                }
                                
                                JsonNode imageValue = osDiskValue.get("image");
                                if (imageValue != null && imageValue instanceof NullNode == false) {
                                    VirtualHardDisk imageInstance = new VirtualHardDisk();
                                    osDiskInstance.setSourceImage(imageInstance);
                                    
                                    JsonNode uriValue2 = imageValue.get("uri");
                                    if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                        String uriInstance2;
                                        uriInstance2 = uriValue2.getTextValue();
                                        imageInstance.setUri(uriInstance2);
                                    }
                                }
                                
                                JsonNode cachingValue = osDiskValue.get("caching");
                                if (cachingValue != null && cachingValue instanceof NullNode == false) {
                                    String cachingInstance;
                                    cachingInstance = cachingValue.getTextValue();
                                    osDiskInstance.setCaching(cachingInstance);
                                }
                                
                                JsonNode createOptionValue = osDiskValue.get("createOption");
                                if (createOptionValue != null && createOptionValue instanceof NullNode == false) {
                                    String createOptionInstance;
                                    createOptionInstance = createOptionValue.getTextValue();
                                    osDiskInstance.setCreateOption(createOptionInstance);
                                }
                                
                                JsonNode diskSizeGBValue = osDiskValue.get("diskSizeGB");
                                if (diskSizeGBValue != null && diskSizeGBValue instanceof NullNode == false) {
                                    int diskSizeGBInstance;
                                    diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                    osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                }
                            }
                            
                            JsonNode dataDisksArray = storageProfileValue.get("dataDisks");
                            if (dataDisksArray != null && dataDisksArray instanceof NullNode == false) {
                                for (JsonNode dataDisksValue : ((ArrayNode) dataDisksArray)) {
                                    DataDisk dataDiskInstance = new DataDisk();
                                    storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                    
                                    JsonNode lunValue = dataDisksValue.get("lun");
                                    if (lunValue != null && lunValue instanceof NullNode == false) {
                                        int lunInstance;
                                        lunInstance = lunValue.getIntValue();
                                        dataDiskInstance.setLun(lunInstance);
                                    }
                                    
                                    JsonNode nameValue3 = dataDisksValue.get("name");
                                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                        String nameInstance3;
                                        nameInstance3 = nameValue3.getTextValue();
                                        dataDiskInstance.setName(nameInstance3);
                                    }
                                    
                                    JsonNode vhdValue2 = dataDisksValue.get("vhd");
                                    if (vhdValue2 != null && vhdValue2 instanceof NullNode == false) {
                                        VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                        
                                        JsonNode uriValue3 = vhdValue2.get("uri");
                                        if (uriValue3 != null && uriValue3 instanceof NullNode == false) {
                                            String uriInstance3;
                                            uriInstance3 = uriValue3.getTextValue();
                                            vhdInstance2.setUri(uriInstance3);
                                        }
                                    }
                                    
                                    JsonNode imageValue2 = dataDisksValue.get("image");
                                    if (imageValue2 != null && imageValue2 instanceof NullNode == false) {
                                        VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setSourceImage(imageInstance2);
                                        
                                        JsonNode uriValue4 = imageValue2.get("uri");
                                        if (uriValue4 != null && uriValue4 instanceof NullNode == false) {
                                            String uriInstance4;
                                            uriInstance4 = uriValue4.getTextValue();
                                            imageInstance2.setUri(uriInstance4);
                                        }
                                    }
                                    
                                    JsonNode cachingValue2 = dataDisksValue.get("caching");
                                    if (cachingValue2 != null && cachingValue2 instanceof NullNode == false) {
                                        String cachingInstance2;
                                        cachingInstance2 = cachingValue2.getTextValue();
                                        dataDiskInstance.setCaching(cachingInstance2);
                                    }
                                    
                                    JsonNode createOptionValue2 = dataDisksValue.get("createOption");
                                    if (createOptionValue2 != null && createOptionValue2 instanceof NullNode == false) {
                                        String createOptionInstance2;
                                        createOptionInstance2 = createOptionValue2.getTextValue();
                                        dataDiskInstance.setCreateOption(createOptionInstance2);
                                    }
                                    
                                    JsonNode diskSizeGBValue2 = dataDisksValue.get("diskSizeGB");
                                    if (diskSizeGBValue2 != null && diskSizeGBValue2 instanceof NullNode == false) {
                                        int diskSizeGBInstance2;
                                        diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                        dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode osProfileValue = propertiesValue.get("osProfile");
                        if (osProfileValue != null && osProfileValue instanceof NullNode == false) {
                            OSProfile osProfileInstance = new OSProfile();
                            virtualMachineInstance.setOSProfile(osProfileInstance);
                            
                            JsonNode computerNameValue = osProfileValue.get("computerName");
                            if (computerNameValue != null && computerNameValue instanceof NullNode == false) {
                                String computerNameInstance;
                                computerNameInstance = computerNameValue.getTextValue();
                                osProfileInstance.setComputerName(computerNameInstance);
                            }
                            
                            JsonNode adminUsernameValue = osProfileValue.get("adminUsername");
                            if (adminUsernameValue != null && adminUsernameValue instanceof NullNode == false) {
                                String adminUsernameInstance;
                                adminUsernameInstance = adminUsernameValue.getTextValue();
                                osProfileInstance.setAdminUsername(adminUsernameInstance);
                            }
                            
                            JsonNode adminPasswordValue = osProfileValue.get("adminPassword");
                            if (adminPasswordValue != null && adminPasswordValue instanceof NullNode == false) {
                                String adminPasswordInstance;
                                adminPasswordInstance = adminPasswordValue.getTextValue();
                                osProfileInstance.setAdminPassword(adminPasswordInstance);
                            }
                            
                            JsonNode customDataValue = osProfileValue.get("customData");
                            if (customDataValue != null && customDataValue instanceof NullNode == false) {
                                String customDataInstance;
                                customDataInstance = customDataValue.getTextValue();
                                osProfileInstance.setCustomData(customDataInstance);
                            }
                            
                            JsonNode windowsConfigurationValue = osProfileValue.get("windowsConfiguration");
                            if (windowsConfigurationValue != null && windowsConfigurationValue instanceof NullNode == false) {
                                WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                
                                JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                if (provisionVMAgentValue != null && provisionVMAgentValue instanceof NullNode == false) {
                                    boolean provisionVMAgentInstance;
                                    provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                    windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                }
                                
                                JsonNode enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates");
                                if (enableAutomaticUpdatesValue != null && enableAutomaticUpdatesValue instanceof NullNode == false) {
                                    boolean enableAutomaticUpdatesInstance;
                                    enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                    windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                }
                                
                                JsonNode timeZoneValue = windowsConfigurationValue.get("timeZone");
                                if (timeZoneValue != null && timeZoneValue instanceof NullNode == false) {
                                    String timeZoneInstance;
                                    timeZoneInstance = timeZoneValue.getTextValue();
                                    windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                }
                                
                                JsonNode additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent");
                                if (additionalUnattendContentArray != null && additionalUnattendContentArray instanceof NullNode == false) {
                                    for (JsonNode additionalUnattendContentValue : ((ArrayNode) additionalUnattendContentArray)) {
                                        AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                        windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                        
                                        JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                        if (passNameValue != null && passNameValue instanceof NullNode == false) {
                                            String passNameInstance;
                                            passNameInstance = passNameValue.getTextValue();
                                            additionalUnattendContentInstance.setPassName(passNameInstance);
                                        }
                                        
                                        JsonNode componentNameValue = additionalUnattendContentValue.get("componentName");
                                        if (componentNameValue != null && componentNameValue instanceof NullNode == false) {
                                            String componentNameInstance;
                                            componentNameInstance = componentNameValue.getTextValue();
                                            additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                        }
                                        
                                        JsonNode settingNameValue = additionalUnattendContentValue.get("settingName");
                                        if (settingNameValue != null && settingNameValue instanceof NullNode == false) {
                                            String settingNameInstance;
                                            settingNameInstance = settingNameValue.getTextValue();
                                            additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                        }
                                        
                                        JsonNode contentValue = additionalUnattendContentValue.get("content");
                                        if (contentValue != null && contentValue instanceof NullNode == false) {
                                            String contentInstance;
                                            contentInstance = contentValue.getTextValue();
                                            additionalUnattendContentInstance.setContent(contentInstance);
                                        }
                                    }
                                }
                                
                                JsonNode winRMValue = windowsConfigurationValue.get("winRM");
                                if (winRMValue != null && winRMValue instanceof NullNode == false) {
                                    WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                    windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                    
                                    JsonNode listenersArray = winRMValue.get("listeners");
                                    if (listenersArray != null && listenersArray instanceof NullNode == false) {
                                        for (JsonNode listenersValue : ((ArrayNode) listenersArray)) {
                                            WinRMListener winRMListenerInstance = new WinRMListener();
                                            winRMInstance.getListeners().add(winRMListenerInstance);
                                            
                                            JsonNode protocolValue = listenersValue.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                winRMListenerInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode certificateUrlValue = listenersValue.get("certificateUrl");
                                            if (certificateUrlValue != null && certificateUrlValue instanceof NullNode == false) {
                                                URI certificateUrlInstance;
                                                certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode linuxConfigurationValue = osProfileValue.get("linuxConfiguration");
                            if (linuxConfigurationValue != null && linuxConfigurationValue instanceof NullNode == false) {
                                LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                
                                JsonNode disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                if (disablePasswordAuthenticationValue != null && disablePasswordAuthenticationValue instanceof NullNode == false) {
                                    boolean disablePasswordAuthenticationInstance;
                                    disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                    linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                }
                                
                                JsonNode sshValue = linuxConfigurationValue.get("ssh");
                                if (sshValue != null && sshValue instanceof NullNode == false) {
                                    SshConfiguration sshInstance = new SshConfiguration();
                                    linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                    
                                    JsonNode publicKeysArray = sshValue.get("publicKeys");
                                    if (publicKeysArray != null && publicKeysArray instanceof NullNode == false) {
                                        for (JsonNode publicKeysValue : ((ArrayNode) publicKeysArray)) {
                                            SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                            sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                            
                                            JsonNode pathValue = publicKeysValue.get("path");
                                            if (pathValue != null && pathValue instanceof NullNode == false) {
                                                String pathInstance;
                                                pathInstance = pathValue.getTextValue();
                                                sshPublicKeyInstance.setPath(pathInstance);
                                            }
                                            
                                            JsonNode keyDataValue = publicKeysValue.get("keyData");
                                            if (keyDataValue != null && keyDataValue instanceof NullNode == false) {
                                                String keyDataInstance;
                                                keyDataInstance = keyDataValue.getTextValue();
                                                sshPublicKeyInstance.setKeyData(keyDataInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode secretsArray = osProfileValue.get("secrets");
                            if (secretsArray != null && secretsArray instanceof NullNode == false) {
                                for (JsonNode secretsValue : ((ArrayNode) secretsArray)) {
                                    VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                    osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                    
                                    JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                    if (sourceVaultValue != null && sourceVaultValue instanceof NullNode == false) {
                                        SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                        vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                        
                                        JsonNode idValue = sourceVaultValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            sourceVaultInstance.setReferenceUri(idInstance);
                                        }
                                    }
                                    
                                    JsonNode vaultCertificatesArray = secretsValue.get("vaultCertificates");
                                    if (vaultCertificatesArray != null && vaultCertificatesArray instanceof NullNode == false) {
                                        for (JsonNode vaultCertificatesValue : ((ArrayNode) vaultCertificatesArray)) {
                                            VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                            vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                            
                                            JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                            if (certificateUrlValue2 != null && certificateUrlValue2 instanceof NullNode == false) {
                                                String certificateUrlInstance2;
                                                certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                            }
                                            
                                            JsonNode certificateStoreValue = vaultCertificatesValue.get("certificateStore");
                                            if (certificateStoreValue != null && certificateStoreValue instanceof NullNode == false) {
                                                String certificateStoreInstance;
                                                certificateStoreInstance = certificateStoreValue.getTextValue();
                                                vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                        JsonNode networkProfileValue = propertiesValue.get("networkProfile");
                        if (networkProfileValue != null && networkProfileValue instanceof NullNode == false) {
                            NetworkProfile networkProfileInstance = new NetworkProfile();
                            virtualMachineInstance.setNetworkProfile(networkProfileInstance);
                            
                            JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                            if (networkInterfacesArray != null && networkInterfacesArray instanceof NullNode == false) {
                                for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray)) {
                                    NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                    networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                    
                                    JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                        JsonNode primaryValue = propertiesValue2.get("primary");
                                        if (primaryValue != null && primaryValue instanceof NullNode == false) {
                                            boolean primaryInstance;
                                            primaryInstance = primaryValue.getBooleanValue();
                                            networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                        }
                                    }
                                    
                                    JsonNode idValue2 = networkInterfacesValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile");
                        if (diagnosticsProfileValue != null && diagnosticsProfileValue instanceof NullNode == false) {
                            DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                            virtualMachineInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                            
                            JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                            if (bootDiagnosticsValue != null && bootDiagnosticsValue instanceof NullNode == false) {
                                BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                
                                JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                    boolean enabledInstance;
                                    enabledInstance = enabledValue.getBooleanValue();
                                    bootDiagnosticsInstance.setEnabled(enabledInstance);
                                }
                                
                                JsonNode storageUriValue = bootDiagnosticsValue.get("storageUri");
                                if (storageUriValue != null && storageUriValue instanceof NullNode == false) {
                                    URI storageUriInstance;
                                    storageUriInstance = new URI(storageUriValue.getTextValue());
                                    bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                }
                            }
                        }
                        
                        JsonNode availabilitySetValue = propertiesValue.get("availabilitySet");
                        if (availabilitySetValue != null && availabilitySetValue instanceof NullNode == false) {
                            AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                            virtualMachineInstance.setAvailabilitySetReference(availabilitySetInstance);
                            
                            JsonNode idValue3 = availabilitySetValue.get("id");
                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                String idInstance3;
                                idInstance3 = idValue3.getTextValue();
                                availabilitySetInstance.setReferenceUri(idInstance3);
                            }
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode instanceViewValue = propertiesValue.get("instanceView");
                        if (instanceViewValue != null && instanceViewValue instanceof NullNode == false) {
                            VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                            virtualMachineInstance.setInstanceView(instanceViewInstance);
                            
                            JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                            if (platformUpdateDomainValue != null && platformUpdateDomainValue instanceof NullNode == false) {
                                int platformUpdateDomainInstance;
                                platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                            }
                            
                            JsonNode platformFaultDomainValue = instanceViewValue.get("platformFaultDomain");
                            if (platformFaultDomainValue != null && platformFaultDomainValue instanceof NullNode == false) {
                                int platformFaultDomainInstance;
                                platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                            }
                            
                            JsonNode rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint");
                            if (rdpThumbPrintValue != null && rdpThumbPrintValue instanceof NullNode == false) {
                                String rdpThumbPrintInstance;
                                rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                            }
                            
                            JsonNode vmAgentValue = instanceViewValue.get("vmAgent");
                            if (vmAgentValue != null && vmAgentValue instanceof NullNode == false) {
                                VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                instanceViewInstance.setVMAgent(vmAgentInstance);
                                
                                JsonNode vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                if (vmAgentVersionValue != null && vmAgentVersionValue instanceof NullNode == false) {
                                    String vmAgentVersionInstance;
                                    vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                    vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                }
                                
                                JsonNode extensionHandlersArray = vmAgentValue.get("extensionHandlers");
                                if (extensionHandlersArray != null && extensionHandlersArray instanceof NullNode == false) {
                                    for (JsonNode extensionHandlersValue : ((ArrayNode) extensionHandlersArray)) {
                                        VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                        vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                        
                                        JsonNode typeValue = extensionHandlersValue.get("type");
                                        if (typeValue != null && typeValue instanceof NullNode == false) {
                                            String typeInstance;
                                            typeInstance = typeValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                        }
                                        
                                        JsonNode typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion");
                                        if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                                            String typeHandlerVersionInstance;
                                            typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                        }
                                        
                                        JsonNode statusValue = extensionHandlersValue.get("status");
                                        if (statusValue != null && statusValue instanceof NullNode == false) {
                                            InstanceViewStatus statusInstance = new InstanceViewStatus();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                            
                                            JsonNode codeValue = statusValue.get("code");
                                            if (codeValue != null && codeValue instanceof NullNode == false) {
                                                String codeInstance;
                                                codeInstance = codeValue.getTextValue();
                                                statusInstance.setCode(codeInstance);
                                            }
                                            
                                            JsonNode levelValue = statusValue.get("level");
                                            if (levelValue != null && levelValue instanceof NullNode == false) {
                                                String levelInstance;
                                                levelInstance = levelValue.getTextValue();
                                                statusInstance.setLevel(levelInstance);
                                            }
                                            
                                            JsonNode displayStatusValue = statusValue.get("displayStatus");
                                            if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                                String displayStatusInstance;
                                                displayStatusInstance = displayStatusValue.getTextValue();
                                                statusInstance.setDisplayStatus(displayStatusInstance);
                                            }
                                            
                                            JsonNode messageValue = statusValue.get("message");
                                            if (messageValue != null && messageValue instanceof NullNode == false) {
                                                String messageInstance;
                                                messageInstance = messageValue.getTextValue();
                                                statusInstance.setMessage(messageInstance);
                                            }
                                            
                                            JsonNode timeValue = statusValue.get("time");
                                            if (timeValue != null && timeValue instanceof NullNode == false) {
                                                Calendar timeInstance;
                                                timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                                statusInstance.setTime(timeInstance);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode statusesArray = vmAgentValue.get("statuses");
                                if (statusesArray != null && statusesArray instanceof NullNode == false) {
                                    for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                        InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                        vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                        
                                        JsonNode codeValue2 = statusesValue.get("code");
                                        if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                            String codeInstance2;
                                            codeInstance2 = codeValue2.getTextValue();
                                            instanceViewStatusInstance.setCode(codeInstance2);
                                        }
                                        
                                        JsonNode levelValue2 = statusesValue.get("level");
                                        if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                            String levelInstance2;
                                            levelInstance2 = levelValue2.getTextValue();
                                            instanceViewStatusInstance.setLevel(levelInstance2);
                                        }
                                        
                                        JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                        if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                            String displayStatusInstance2;
                                            displayStatusInstance2 = displayStatusValue2.getTextValue();
                                            instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                        }
                                        
                                        JsonNode messageValue2 = statusesValue.get("message");
                                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                            String messageInstance2;
                                            messageInstance2 = messageValue2.getTextValue();
                                            instanceViewStatusInstance.setMessage(messageInstance2);
                                        }
                                        
                                        JsonNode timeValue2 = statusesValue.get("time");
                                        if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                            Calendar timeInstance2;
                                            timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                            instanceViewStatusInstance.setTime(timeInstance2);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode disksArray = instanceViewValue.get("disks");
                            if (disksArray != null && disksArray instanceof NullNode == false) {
                                for (JsonNode disksValue : ((ArrayNode) disksArray)) {
                                    DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                    instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                    
                                    JsonNode nameValue4 = disksValue.get("name");
                                    if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                        String nameInstance4;
                                        nameInstance4 = nameValue4.getTextValue();
                                        diskInstanceViewInstance.setName(nameInstance4);
                                    }
                                    
                                    JsonNode statusesArray2 = disksValue.get("statuses");
                                    if (statusesArray2 != null && statusesArray2 instanceof NullNode == false) {
                                        for (JsonNode statusesValue2 : ((ArrayNode) statusesArray2)) {
                                            InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                            diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                            
                                            JsonNode codeValue3 = statusesValue2.get("code");
                                            if (codeValue3 != null && codeValue3 instanceof NullNode == false) {
                                                String codeInstance3;
                                                codeInstance3 = codeValue3.getTextValue();
                                                instanceViewStatusInstance2.setCode(codeInstance3);
                                            }
                                            
                                            JsonNode levelValue3 = statusesValue2.get("level");
                                            if (levelValue3 != null && levelValue3 instanceof NullNode == false) {
                                                String levelInstance3;
                                                levelInstance3 = levelValue3.getTextValue();
                                                instanceViewStatusInstance2.setLevel(levelInstance3);
                                            }
                                            
                                            JsonNode displayStatusValue3 = statusesValue2.get("displayStatus");
                                            if (displayStatusValue3 != null && displayStatusValue3 instanceof NullNode == false) {
                                                String displayStatusInstance3;
                                                displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                            }
                                            
                                            JsonNode messageValue3 = statusesValue2.get("message");
                                            if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                                String messageInstance3;
                                                messageInstance3 = messageValue3.getTextValue();
                                                instanceViewStatusInstance2.setMessage(messageInstance3);
                                            }
                                            
                                            JsonNode timeValue3 = statusesValue2.get("time");
                                            if (timeValue3 != null && timeValue3 instanceof NullNode == false) {
                                                Calendar timeInstance3;
                                                timeInstance3 = DatatypeConverter.parseDateTime(timeValue3.getTextValue());
                                                instanceViewStatusInstance2.setTime(timeInstance3);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode extensionsArray = instanceViewValue.get("extensions");
                            if (extensionsArray != null && extensionsArray instanceof NullNode == false) {
                                for (JsonNode extensionsValue : ((ArrayNode) extensionsArray)) {
                                    VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                    instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                    
                                    JsonNode nameValue5 = extensionsValue.get("name");
                                    if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                        String nameInstance5;
                                        nameInstance5 = nameValue5.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                    }
                                    
                                    JsonNode typeValue2 = extensionsValue.get("type");
                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                        String typeInstance2;
                                        typeInstance2 = typeValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                    }
                                    
                                    JsonNode typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion");
                                    if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                        String typeHandlerVersionInstance2;
                                        typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                    }
                                    
                                    JsonNode substatusesArray = extensionsValue.get("substatuses");
                                    if (substatusesArray != null && substatusesArray instanceof NullNode == false) {
                                        for (JsonNode substatusesValue : ((ArrayNode) substatusesArray)) {
                                            InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                            
                                            JsonNode codeValue4 = substatusesValue.get("code");
                                            if (codeValue4 != null && codeValue4 instanceof NullNode == false) {
                                                String codeInstance4;
                                                codeInstance4 = codeValue4.getTextValue();
                                                instanceViewStatusInstance3.setCode(codeInstance4);
                                            }
                                            
                                            JsonNode levelValue4 = substatusesValue.get("level");
                                            if (levelValue4 != null && levelValue4 instanceof NullNode == false) {
                                                String levelInstance4;
                                                levelInstance4 = levelValue4.getTextValue();
                                                instanceViewStatusInstance3.setLevel(levelInstance4);
                                            }
                                            
                                            JsonNode displayStatusValue4 = substatusesValue.get("displayStatus");
                                            if (displayStatusValue4 != null && displayStatusValue4 instanceof NullNode == false) {
                                                String displayStatusInstance4;
                                                displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                            }
                                            
                                            JsonNode messageValue4 = substatusesValue.get("message");
                                            if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                                String messageInstance4;
                                                messageInstance4 = messageValue4.getTextValue();
                                                instanceViewStatusInstance3.setMessage(messageInstance4);
                                            }
                                            
                                            JsonNode timeValue4 = substatusesValue.get("time");
                                            if (timeValue4 != null && timeValue4 instanceof NullNode == false) {
                                                Calendar timeInstance4;
                                                timeInstance4 = DatatypeConverter.parseDateTime(timeValue4.getTextValue());
                                                instanceViewStatusInstance3.setTime(timeInstance4);
                                            }
                                        }
                                    }
                                    
                                    JsonNode statusesArray3 = extensionsValue.get("statuses");
                                    if (statusesArray3 != null && statusesArray3 instanceof NullNode == false) {
                                        for (JsonNode statusesValue3 : ((ArrayNode) statusesArray3)) {
                                            InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                            
                                            JsonNode codeValue5 = statusesValue3.get("code");
                                            if (codeValue5 != null && codeValue5 instanceof NullNode == false) {
                                                String codeInstance5;
                                                codeInstance5 = codeValue5.getTextValue();
                                                instanceViewStatusInstance4.setCode(codeInstance5);
                                            }
                                            
                                            JsonNode levelValue5 = statusesValue3.get("level");
                                            if (levelValue5 != null && levelValue5 instanceof NullNode == false) {
                                                String levelInstance5;
                                                levelInstance5 = levelValue5.getTextValue();
                                                instanceViewStatusInstance4.setLevel(levelInstance5);
                                            }
                                            
                                            JsonNode displayStatusValue5 = statusesValue3.get("displayStatus");
                                            if (displayStatusValue5 != null && displayStatusValue5 instanceof NullNode == false) {
                                                String displayStatusInstance5;
                                                displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                            }
                                            
                                            JsonNode messageValue5 = statusesValue3.get("message");
                                            if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                                String messageInstance5;
                                                messageInstance5 = messageValue5.getTextValue();
                                                instanceViewStatusInstance4.setMessage(messageInstance5);
                                            }
                                            
                                            JsonNode timeValue5 = statusesValue3.get("time");
                                            if (timeValue5 != null && timeValue5 instanceof NullNode == false) {
                                                Calendar timeInstance5;
                                                timeInstance5 = DatatypeConverter.parseDateTime(timeValue5.getTextValue());
                                                instanceViewStatusInstance4.setTime(timeInstance5);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics");
                            if (bootDiagnosticsValue2 != null && bootDiagnosticsValue2 instanceof NullNode == false) {
                                BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                
                                JsonNode consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                if (consoleScreenshotBlobUriValue != null && consoleScreenshotBlobUriValue instanceof NullNode == false) {
                                    URI consoleScreenshotBlobUriInstance;
                                    consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                }
                                
                                JsonNode serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri");
                                if (serialConsoleLogBlobUriValue != null && serialConsoleLogBlobUriValue instanceof NullNode == false) {
                                    URI serialConsoleLogBlobUriInstance;
                                    serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                }
                            }
                            
                            JsonNode statusesArray4 = instanceViewValue.get("statuses");
                            if (statusesArray4 != null && statusesArray4 instanceof NullNode == false) {
                                for (JsonNode statusesValue4 : ((ArrayNode) statusesArray4)) {
                                    InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                    
                                    JsonNode codeValue6 = statusesValue4.get("code");
                                    if (codeValue6 != null && codeValue6 instanceof NullNode == false) {
                                        String codeInstance6;
                                        codeInstance6 = codeValue6.getTextValue();
                                        instanceViewStatusInstance5.setCode(codeInstance6);
                                    }
                                    
                                    JsonNode levelValue6 = statusesValue4.get("level");
                                    if (levelValue6 != null && levelValue6 instanceof NullNode == false) {
                                        String levelInstance6;
                                        levelInstance6 = levelValue6.getTextValue();
                                        instanceViewStatusInstance5.setLevel(levelInstance6);
                                    }
                                    
                                    JsonNode displayStatusValue6 = statusesValue4.get("displayStatus");
                                    if (displayStatusValue6 != null && displayStatusValue6 instanceof NullNode == false) {
                                        String displayStatusInstance6;
                                        displayStatusInstance6 = displayStatusValue6.getTextValue();
                                        instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                    }
                                    
                                    JsonNode messageValue6 = statusesValue4.get("message");
                                    if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                        String messageInstance6;
                                        messageInstance6 = messageValue6.getTextValue();
                                        instanceViewStatusInstance5.setMessage(messageInstance6);
                                    }
                                    
                                    JsonNode timeValue6 = statusesValue4.get("time");
                                    if (timeValue6 != null && timeValue6 instanceof NullNode == false) {
                                        Calendar timeInstance6;
                                        timeInstance6 = DatatypeConverter.parseDateTime(timeValue6.getTextValue());
                                        instanceViewStatusInstance5.setTime(timeInstance6);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode resourcesArray = responseDoc.get("resources");
                    if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                        virtualMachineInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                        for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                            VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                            virtualMachineInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                            
                            JsonNode propertiesValue3 = resourcesValue.get("properties");
                            if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                if (publisherValue3 != null && publisherValue3 instanceof NullNode == false) {
                                    String publisherInstance3;
                                    publisherInstance3 = publisherValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                }
                                
                                JsonNode typeValue3 = propertiesValue3.get("type");
                                if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                    String typeInstance3;
                                    typeInstance3 = typeValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                }
                                
                                JsonNode typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion");
                                if (typeHandlerVersionValue3 != null && typeHandlerVersionValue3 instanceof NullNode == false) {
                                    String typeHandlerVersionInstance3;
                                    typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                }
                                
                                JsonNode autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion");
                                if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                                    boolean autoUpgradeMinorVersionInstance;
                                    autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                    virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                }
                                
                                JsonNode settingsValue = propertiesValue3.get("settings");
                                if (settingsValue != null && settingsValue instanceof NullNode == false) {
                                    String settingsInstance;
                                    settingsInstance = settingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                }
                                
                                JsonNode protectedSettingsValue = propertiesValue3.get("protectedSettings");
                                if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                                    String protectedSettingsInstance;
                                    protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                }
                                
                                JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                    String provisioningStateInstance2;
                                    provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                }
                                
                                JsonNode instanceViewValue2 = propertiesValue3.get("instanceView");
                                if (instanceViewValue2 != null && instanceViewValue2 instanceof NullNode == false) {
                                    VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                    virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                    
                                    JsonNode nameValue6 = instanceViewValue2.get("name");
                                    if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                        String nameInstance6;
                                        nameInstance6 = nameValue6.getTextValue();
                                        instanceViewInstance2.setName(nameInstance6);
                                    }
                                    
                                    JsonNode typeValue4 = instanceViewValue2.get("type");
                                    if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                        String typeInstance4;
                                        typeInstance4 = typeValue4.getTextValue();
                                        instanceViewInstance2.setExtensionType(typeInstance4);
                                    }
                                    
                                    JsonNode typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion");
                                    if (typeHandlerVersionValue4 != null && typeHandlerVersionValue4 instanceof NullNode == false) {
                                        String typeHandlerVersionInstance4;
                                        typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                        instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                    }
                                    
                                    JsonNode substatusesArray2 = instanceViewValue2.get("substatuses");
                                    if (substatusesArray2 != null && substatusesArray2 instanceof NullNode == false) {
                                        for (JsonNode substatusesValue2 : ((ArrayNode) substatusesArray2)) {
                                            InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                            instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                            
                                            JsonNode codeValue7 = substatusesValue2.get("code");
                                            if (codeValue7 != null && codeValue7 instanceof NullNode == false) {
                                                String codeInstance7;
                                                codeInstance7 = codeValue7.getTextValue();
                                                instanceViewStatusInstance6.setCode(codeInstance7);
                                            }
                                            
                                            JsonNode levelValue7 = substatusesValue2.get("level");
                                            if (levelValue7 != null && levelValue7 instanceof NullNode == false) {
                                                String levelInstance7;
                                                levelInstance7 = levelValue7.getTextValue();
                                                instanceViewStatusInstance6.setLevel(levelInstance7);
                                            }
                                            
                                            JsonNode displayStatusValue7 = substatusesValue2.get("displayStatus");
                                            if (displayStatusValue7 != null && displayStatusValue7 instanceof NullNode == false) {
                                                String displayStatusInstance7;
                                                displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                            }
                                            
                                            JsonNode messageValue7 = substatusesValue2.get("message");
                                            if (messageValue7 != null && messageValue7 instanceof NullNode == false) {
                                                String messageInstance7;
                                                messageInstance7 = messageValue7.getTextValue();
                                                instanceViewStatusInstance6.setMessage(messageInstance7);
                                            }
                                            
                                            JsonNode timeValue7 = substatusesValue2.get("time");
                                            if (timeValue7 != null && timeValue7 instanceof NullNode == false) {
                                                Calendar timeInstance7;
                                                timeInstance7 = DatatypeConverter.parseDateTime(timeValue7.getTextValue());
                                                instanceViewStatusInstance6.setTime(timeInstance7);
                                            }
                                        }
                                    }
                                    
                                    JsonNode statusesArray5 = instanceViewValue2.get("statuses");
                                    if (statusesArray5 != null && statusesArray5 instanceof NullNode == false) {
                                        for (JsonNode statusesValue5 : ((ArrayNode) statusesArray5)) {
                                            InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                            instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                            
                                            JsonNode codeValue8 = statusesValue5.get("code");
                                            if (codeValue8 != null && codeValue8 instanceof NullNode == false) {
                                                String codeInstance8;
                                                codeInstance8 = codeValue8.getTextValue();
                                                instanceViewStatusInstance7.setCode(codeInstance8);
                                            }
                                            
                                            JsonNode levelValue8 = statusesValue5.get("level");
                                            if (levelValue8 != null && levelValue8 instanceof NullNode == false) {
                                                String levelInstance8;
                                                levelInstance8 = levelValue8.getTextValue();
                                                instanceViewStatusInstance7.setLevel(levelInstance8);
                                            }
                                            
                                            JsonNode displayStatusValue8 = statusesValue5.get("displayStatus");
                                            if (displayStatusValue8 != null && displayStatusValue8 instanceof NullNode == false) {
                                                String displayStatusInstance8;
                                                displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                            }
                                            
                                            JsonNode messageValue8 = statusesValue5.get("message");
                                            if (messageValue8 != null && messageValue8 instanceof NullNode == false) {
                                                String messageInstance8;
                                                messageInstance8 = messageValue8.getTextValue();
                                                instanceViewStatusInstance7.setMessage(messageInstance8);
                                            }
                                            
                                            JsonNode timeValue8 = statusesValue5.get("time");
                                            if (timeValue8 != null && timeValue8 instanceof NullNode == false) {
                                                Calendar timeInstance8;
                                                timeInstance8 = DatatypeConverter.parseDateTime(timeValue8.getTextValue());
                                                instanceViewStatusInstance7.setTime(timeInstance8);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue4 = resourcesValue.get("id");
                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                String idInstance4;
                                idInstance4 = idValue4.getTextValue();
                                virtualMachineExtensionJsonInstance.setId(idInstance4);
                            }
                            
                            JsonNode nameValue7 = resourcesValue.get("name");
                            if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                String nameInstance7;
                                nameInstance7 = nameValue7.getTextValue();
                                virtualMachineExtensionJsonInstance.setName(nameInstance7);
                            }
                            
                            JsonNode typeValue5 = resourcesValue.get("type");
                            if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                String typeInstance5;
                                typeInstance5 = typeValue5.getTextValue();
                                virtualMachineExtensionJsonInstance.setType(typeInstance5);
                            }
                            
                            JsonNode locationValue = resourcesValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) resourcesValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue5 = responseDoc.get("id");
                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                        String idInstance5;
                        idInstance5 = idValue5.getTextValue();
                        virtualMachineInstance.setId(idInstance5);
                    }
                    
                    JsonNode nameValue8 = responseDoc.get("name");
                    if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                        String nameInstance8;
                        nameInstance8 = nameValue8.getTextValue();
                        virtualMachineInstance.setName(nameInstance8);
                    }
                    
                    JsonNode typeValue6 = responseDoc.get("type");
                    if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                        String typeInstance6;
                        typeInstance6 = typeValue6.getTextValue();
                        virtualMachineInstance.setType(typeInstance6);
                    }
                    
                    JsonNode locationValue2 = responseDoc.get("location");
                    if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                        String locationInstance2;
                        locationInstance2 = locationValue2.getTextValue();
                        virtualMachineInstance.setLocation(locationInstance2);
                    }
                    
                    JsonNode tagsSequenceElement2 = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                        while (itr2.hasNext()) {
                            Map.Entry<String, JsonNode> property2 = itr2.next();
                            String tagsKey2 = property2.getKey();
                            String tagsValue2 = property2.getValue().getTextValue();
                            virtualMachineInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to get a virtual machine along with its instance view.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The GetVM operation response.
    */
    @Override
    public Future<VirtualMachineGetResponse> getWithInstanceViewAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineGetResponse>() { 
            @Override
            public VirtualMachineGetResponse call() throws Exception {
                return getWithInstanceView(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to get a virtual machine along with its instance view.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The GetVM operation response.
    */
    @Override
    public VirtualMachineGetResponse getWithInstanceView(String resourceGroupName, String vmName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "getWithInstanceViewAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("$expand=instanceView");
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineGetResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    VirtualMachine virtualMachineInstance = new VirtualMachine();
                    result.setVirtualMachine(virtualMachineInstance);
                    
                    JsonNode planValue = responseDoc.get("plan");
                    if (planValue != null && planValue instanceof NullNode == false) {
                        Plan planInstance = new Plan();
                        virtualMachineInstance.setPlan(planInstance);
                        
                        JsonNode nameValue = planValue.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        
                        JsonNode publisherValue = planValue.get("publisher");
                        if (publisherValue != null && publisherValue instanceof NullNode == false) {
                            String publisherInstance;
                            publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        
                        JsonNode productValue = planValue.get("product");
                        if (productValue != null && productValue instanceof NullNode == false) {
                            String productInstance;
                            productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        
                        JsonNode promotionCodeValue = planValue.get("promotionCode");
                        if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                            String promotionCodeInstance;
                            promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                        JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                        if (hardwareProfileValue != null && hardwareProfileValue instanceof NullNode == false) {
                            HardwareProfile hardwareProfileInstance = new HardwareProfile();
                            virtualMachineInstance.setHardwareProfile(hardwareProfileInstance);
                            
                            JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                            if (vmSizeValue != null && vmSizeValue instanceof NullNode == false) {
                                String vmSizeInstance;
                                vmSizeInstance = vmSizeValue.getTextValue();
                                hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                            }
                        }
                        
                        JsonNode storageProfileValue = propertiesValue.get("storageProfile");
                        if (storageProfileValue != null && storageProfileValue instanceof NullNode == false) {
                            StorageProfile storageProfileInstance = new StorageProfile();
                            virtualMachineInstance.setStorageProfile(storageProfileInstance);
                            
                            JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                            if (imageReferenceValue != null && imageReferenceValue instanceof NullNode == false) {
                                ImageReference imageReferenceInstance = new ImageReference();
                                storageProfileInstance.setImageReference(imageReferenceInstance);
                                
                                JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                if (publisherValue2 != null && publisherValue2 instanceof NullNode == false) {
                                    String publisherInstance2;
                                    publisherInstance2 = publisherValue2.getTextValue();
                                    imageReferenceInstance.setPublisher(publisherInstance2);
                                }
                                
                                JsonNode offerValue = imageReferenceValue.get("offer");
                                if (offerValue != null && offerValue instanceof NullNode == false) {
                                    String offerInstance;
                                    offerInstance = offerValue.getTextValue();
                                    imageReferenceInstance.setOffer(offerInstance);
                                }
                                
                                JsonNode skuValue = imageReferenceValue.get("sku");
                                if (skuValue != null && skuValue instanceof NullNode == false) {
                                    String skuInstance;
                                    skuInstance = skuValue.getTextValue();
                                    imageReferenceInstance.setSku(skuInstance);
                                }
                                
                                JsonNode versionValue = imageReferenceValue.get("version");
                                if (versionValue != null && versionValue instanceof NullNode == false) {
                                    String versionInstance;
                                    versionInstance = versionValue.getTextValue();
                                    imageReferenceInstance.setVersion(versionInstance);
                                }
                            }
                            
                            JsonNode osDiskValue = storageProfileValue.get("osDisk");
                            if (osDiskValue != null && osDiskValue instanceof NullNode == false) {
                                OSDisk osDiskInstance = new OSDisk();
                                storageProfileInstance.setOSDisk(osDiskInstance);
                                
                                JsonNode osTypeValue = osDiskValue.get("osType");
                                if (osTypeValue != null && osTypeValue instanceof NullNode == false) {
                                    String osTypeInstance;
                                    osTypeInstance = osTypeValue.getTextValue();
                                    osDiskInstance.setOperatingSystemType(osTypeInstance);
                                }
                                
                                JsonNode nameValue2 = osDiskValue.get("name");
                                if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                    String nameInstance2;
                                    nameInstance2 = nameValue2.getTextValue();
                                    osDiskInstance.setName(nameInstance2);
                                }
                                
                                JsonNode vhdValue = osDiskValue.get("vhd");
                                if (vhdValue != null && vhdValue instanceof NullNode == false) {
                                    VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                    osDiskInstance.setVirtualHardDisk(vhdInstance);
                                    
                                    JsonNode uriValue = vhdValue.get("uri");
                                    if (uriValue != null && uriValue instanceof NullNode == false) {
                                        String uriInstance;
                                        uriInstance = uriValue.getTextValue();
                                        vhdInstance.setUri(uriInstance);
                                    }
                                }
                                
                                JsonNode imageValue = osDiskValue.get("image");
                                if (imageValue != null && imageValue instanceof NullNode == false) {
                                    VirtualHardDisk imageInstance = new VirtualHardDisk();
                                    osDiskInstance.setSourceImage(imageInstance);
                                    
                                    JsonNode uriValue2 = imageValue.get("uri");
                                    if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                        String uriInstance2;
                                        uriInstance2 = uriValue2.getTextValue();
                                        imageInstance.setUri(uriInstance2);
                                    }
                                }
                                
                                JsonNode cachingValue = osDiskValue.get("caching");
                                if (cachingValue != null && cachingValue instanceof NullNode == false) {
                                    String cachingInstance;
                                    cachingInstance = cachingValue.getTextValue();
                                    osDiskInstance.setCaching(cachingInstance);
                                }
                                
                                JsonNode createOptionValue = osDiskValue.get("createOption");
                                if (createOptionValue != null && createOptionValue instanceof NullNode == false) {
                                    String createOptionInstance;
                                    createOptionInstance = createOptionValue.getTextValue();
                                    osDiskInstance.setCreateOption(createOptionInstance);
                                }
                                
                                JsonNode diskSizeGBValue = osDiskValue.get("diskSizeGB");
                                if (diskSizeGBValue != null && diskSizeGBValue instanceof NullNode == false) {
                                    int diskSizeGBInstance;
                                    diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                    osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                }
                            }
                            
                            JsonNode dataDisksArray = storageProfileValue.get("dataDisks");
                            if (dataDisksArray != null && dataDisksArray instanceof NullNode == false) {
                                for (JsonNode dataDisksValue : ((ArrayNode) dataDisksArray)) {
                                    DataDisk dataDiskInstance = new DataDisk();
                                    storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                    
                                    JsonNode lunValue = dataDisksValue.get("lun");
                                    if (lunValue != null && lunValue instanceof NullNode == false) {
                                        int lunInstance;
                                        lunInstance = lunValue.getIntValue();
                                        dataDiskInstance.setLun(lunInstance);
                                    }
                                    
                                    JsonNode nameValue3 = dataDisksValue.get("name");
                                    if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                        String nameInstance3;
                                        nameInstance3 = nameValue3.getTextValue();
                                        dataDiskInstance.setName(nameInstance3);
                                    }
                                    
                                    JsonNode vhdValue2 = dataDisksValue.get("vhd");
                                    if (vhdValue2 != null && vhdValue2 instanceof NullNode == false) {
                                        VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                        
                                        JsonNode uriValue3 = vhdValue2.get("uri");
                                        if (uriValue3 != null && uriValue3 instanceof NullNode == false) {
                                            String uriInstance3;
                                            uriInstance3 = uriValue3.getTextValue();
                                            vhdInstance2.setUri(uriInstance3);
                                        }
                                    }
                                    
                                    JsonNode imageValue2 = dataDisksValue.get("image");
                                    if (imageValue2 != null && imageValue2 instanceof NullNode == false) {
                                        VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setSourceImage(imageInstance2);
                                        
                                        JsonNode uriValue4 = imageValue2.get("uri");
                                        if (uriValue4 != null && uriValue4 instanceof NullNode == false) {
                                            String uriInstance4;
                                            uriInstance4 = uriValue4.getTextValue();
                                            imageInstance2.setUri(uriInstance4);
                                        }
                                    }
                                    
                                    JsonNode cachingValue2 = dataDisksValue.get("caching");
                                    if (cachingValue2 != null && cachingValue2 instanceof NullNode == false) {
                                        String cachingInstance2;
                                        cachingInstance2 = cachingValue2.getTextValue();
                                        dataDiskInstance.setCaching(cachingInstance2);
                                    }
                                    
                                    JsonNode createOptionValue2 = dataDisksValue.get("createOption");
                                    if (createOptionValue2 != null && createOptionValue2 instanceof NullNode == false) {
                                        String createOptionInstance2;
                                        createOptionInstance2 = createOptionValue2.getTextValue();
                                        dataDiskInstance.setCreateOption(createOptionInstance2);
                                    }
                                    
                                    JsonNode diskSizeGBValue2 = dataDisksValue.get("diskSizeGB");
                                    if (diskSizeGBValue2 != null && diskSizeGBValue2 instanceof NullNode == false) {
                                        int diskSizeGBInstance2;
                                        diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                        dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode osProfileValue = propertiesValue.get("osProfile");
                        if (osProfileValue != null && osProfileValue instanceof NullNode == false) {
                            OSProfile osProfileInstance = new OSProfile();
                            virtualMachineInstance.setOSProfile(osProfileInstance);
                            
                            JsonNode computerNameValue = osProfileValue.get("computerName");
                            if (computerNameValue != null && computerNameValue instanceof NullNode == false) {
                                String computerNameInstance;
                                computerNameInstance = computerNameValue.getTextValue();
                                osProfileInstance.setComputerName(computerNameInstance);
                            }
                            
                            JsonNode adminUsernameValue = osProfileValue.get("adminUsername");
                            if (adminUsernameValue != null && adminUsernameValue instanceof NullNode == false) {
                                String adminUsernameInstance;
                                adminUsernameInstance = adminUsernameValue.getTextValue();
                                osProfileInstance.setAdminUsername(adminUsernameInstance);
                            }
                            
                            JsonNode adminPasswordValue = osProfileValue.get("adminPassword");
                            if (adminPasswordValue != null && adminPasswordValue instanceof NullNode == false) {
                                String adminPasswordInstance;
                                adminPasswordInstance = adminPasswordValue.getTextValue();
                                osProfileInstance.setAdminPassword(adminPasswordInstance);
                            }
                            
                            JsonNode customDataValue = osProfileValue.get("customData");
                            if (customDataValue != null && customDataValue instanceof NullNode == false) {
                                String customDataInstance;
                                customDataInstance = customDataValue.getTextValue();
                                osProfileInstance.setCustomData(customDataInstance);
                            }
                            
                            JsonNode windowsConfigurationValue = osProfileValue.get("windowsConfiguration");
                            if (windowsConfigurationValue != null && windowsConfigurationValue instanceof NullNode == false) {
                                WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                
                                JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                if (provisionVMAgentValue != null && provisionVMAgentValue instanceof NullNode == false) {
                                    boolean provisionVMAgentInstance;
                                    provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                    windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                }
                                
                                JsonNode enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates");
                                if (enableAutomaticUpdatesValue != null && enableAutomaticUpdatesValue instanceof NullNode == false) {
                                    boolean enableAutomaticUpdatesInstance;
                                    enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                    windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                }
                                
                                JsonNode timeZoneValue = windowsConfigurationValue.get("timeZone");
                                if (timeZoneValue != null && timeZoneValue instanceof NullNode == false) {
                                    String timeZoneInstance;
                                    timeZoneInstance = timeZoneValue.getTextValue();
                                    windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                }
                                
                                JsonNode additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent");
                                if (additionalUnattendContentArray != null && additionalUnattendContentArray instanceof NullNode == false) {
                                    for (JsonNode additionalUnattendContentValue : ((ArrayNode) additionalUnattendContentArray)) {
                                        AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                        windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                        
                                        JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                        if (passNameValue != null && passNameValue instanceof NullNode == false) {
                                            String passNameInstance;
                                            passNameInstance = passNameValue.getTextValue();
                                            additionalUnattendContentInstance.setPassName(passNameInstance);
                                        }
                                        
                                        JsonNode componentNameValue = additionalUnattendContentValue.get("componentName");
                                        if (componentNameValue != null && componentNameValue instanceof NullNode == false) {
                                            String componentNameInstance;
                                            componentNameInstance = componentNameValue.getTextValue();
                                            additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                        }
                                        
                                        JsonNode settingNameValue = additionalUnattendContentValue.get("settingName");
                                        if (settingNameValue != null && settingNameValue instanceof NullNode == false) {
                                            String settingNameInstance;
                                            settingNameInstance = settingNameValue.getTextValue();
                                            additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                        }
                                        
                                        JsonNode contentValue = additionalUnattendContentValue.get("content");
                                        if (contentValue != null && contentValue instanceof NullNode == false) {
                                            String contentInstance;
                                            contentInstance = contentValue.getTextValue();
                                            additionalUnattendContentInstance.setContent(contentInstance);
                                        }
                                    }
                                }
                                
                                JsonNode winRMValue = windowsConfigurationValue.get("winRM");
                                if (winRMValue != null && winRMValue instanceof NullNode == false) {
                                    WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                    windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                    
                                    JsonNode listenersArray = winRMValue.get("listeners");
                                    if (listenersArray != null && listenersArray instanceof NullNode == false) {
                                        for (JsonNode listenersValue : ((ArrayNode) listenersArray)) {
                                            WinRMListener winRMListenerInstance = new WinRMListener();
                                            winRMInstance.getListeners().add(winRMListenerInstance);
                                            
                                            JsonNode protocolValue = listenersValue.get("protocol");
                                            if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                String protocolInstance;
                                                protocolInstance = protocolValue.getTextValue();
                                                winRMListenerInstance.setProtocol(protocolInstance);
                                            }
                                            
                                            JsonNode certificateUrlValue = listenersValue.get("certificateUrl");
                                            if (certificateUrlValue != null && certificateUrlValue instanceof NullNode == false) {
                                                URI certificateUrlInstance;
                                                certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode linuxConfigurationValue = osProfileValue.get("linuxConfiguration");
                            if (linuxConfigurationValue != null && linuxConfigurationValue instanceof NullNode == false) {
                                LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                
                                JsonNode disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                if (disablePasswordAuthenticationValue != null && disablePasswordAuthenticationValue instanceof NullNode == false) {
                                    boolean disablePasswordAuthenticationInstance;
                                    disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                    linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                }
                                
                                JsonNode sshValue = linuxConfigurationValue.get("ssh");
                                if (sshValue != null && sshValue instanceof NullNode == false) {
                                    SshConfiguration sshInstance = new SshConfiguration();
                                    linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                    
                                    JsonNode publicKeysArray = sshValue.get("publicKeys");
                                    if (publicKeysArray != null && publicKeysArray instanceof NullNode == false) {
                                        for (JsonNode publicKeysValue : ((ArrayNode) publicKeysArray)) {
                                            SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                            sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                            
                                            JsonNode pathValue = publicKeysValue.get("path");
                                            if (pathValue != null && pathValue instanceof NullNode == false) {
                                                String pathInstance;
                                                pathInstance = pathValue.getTextValue();
                                                sshPublicKeyInstance.setPath(pathInstance);
                                            }
                                            
                                            JsonNode keyDataValue = publicKeysValue.get("keyData");
                                            if (keyDataValue != null && keyDataValue instanceof NullNode == false) {
                                                String keyDataInstance;
                                                keyDataInstance = keyDataValue.getTextValue();
                                                sshPublicKeyInstance.setKeyData(keyDataInstance);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode secretsArray = osProfileValue.get("secrets");
                            if (secretsArray != null && secretsArray instanceof NullNode == false) {
                                for (JsonNode secretsValue : ((ArrayNode) secretsArray)) {
                                    VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                    osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                    
                                    JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                    if (sourceVaultValue != null && sourceVaultValue instanceof NullNode == false) {
                                        SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                        vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                        
                                        JsonNode idValue = sourceVaultValue.get("id");
                                        if (idValue != null && idValue instanceof NullNode == false) {
                                            String idInstance;
                                            idInstance = idValue.getTextValue();
                                            sourceVaultInstance.setReferenceUri(idInstance);
                                        }
                                    }
                                    
                                    JsonNode vaultCertificatesArray = secretsValue.get("vaultCertificates");
                                    if (vaultCertificatesArray != null && vaultCertificatesArray instanceof NullNode == false) {
                                        for (JsonNode vaultCertificatesValue : ((ArrayNode) vaultCertificatesArray)) {
                                            VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                            vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                            
                                            JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                            if (certificateUrlValue2 != null && certificateUrlValue2 instanceof NullNode == false) {
                                                String certificateUrlInstance2;
                                                certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                            }
                                            
                                            JsonNode certificateStoreValue = vaultCertificatesValue.get("certificateStore");
                                            if (certificateStoreValue != null && certificateStoreValue instanceof NullNode == false) {
                                                String certificateStoreInstance;
                                                certificateStoreInstance = certificateStoreValue.getTextValue();
                                                vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                        JsonNode networkProfileValue = propertiesValue.get("networkProfile");
                        if (networkProfileValue != null && networkProfileValue instanceof NullNode == false) {
                            NetworkProfile networkProfileInstance = new NetworkProfile();
                            virtualMachineInstance.setNetworkProfile(networkProfileInstance);
                            
                            JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                            if (networkInterfacesArray != null && networkInterfacesArray instanceof NullNode == false) {
                                for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray)) {
                                    NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                    networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                    
                                    JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                    if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                        JsonNode primaryValue = propertiesValue2.get("primary");
                                        if (primaryValue != null && primaryValue instanceof NullNode == false) {
                                            boolean primaryInstance;
                                            primaryInstance = primaryValue.getBooleanValue();
                                            networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                        }
                                    }
                                    
                                    JsonNode idValue2 = networkInterfacesValue.get("id");
                                    if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                        String idInstance2;
                                        idInstance2 = idValue2.getTextValue();
                                        networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                    }
                                }
                            }
                        }
                        
                        JsonNode diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile");
                        if (diagnosticsProfileValue != null && diagnosticsProfileValue instanceof NullNode == false) {
                            DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                            virtualMachineInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                            
                            JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                            if (bootDiagnosticsValue != null && bootDiagnosticsValue instanceof NullNode == false) {
                                BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                
                                JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                    boolean enabledInstance;
                                    enabledInstance = enabledValue.getBooleanValue();
                                    bootDiagnosticsInstance.setEnabled(enabledInstance);
                                }
                                
                                JsonNode storageUriValue = bootDiagnosticsValue.get("storageUri");
                                if (storageUriValue != null && storageUriValue instanceof NullNode == false) {
                                    URI storageUriInstance;
                                    storageUriInstance = new URI(storageUriValue.getTextValue());
                                    bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                }
                            }
                        }
                        
                        JsonNode availabilitySetValue = propertiesValue.get("availabilitySet");
                        if (availabilitySetValue != null && availabilitySetValue instanceof NullNode == false) {
                            AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                            virtualMachineInstance.setAvailabilitySetReference(availabilitySetInstance);
                            
                            JsonNode idValue3 = availabilitySetValue.get("id");
                            if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                String idInstance3;
                                idInstance3 = idValue3.getTextValue();
                                availabilitySetInstance.setReferenceUri(idInstance3);
                            }
                        }
                        
                        JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                        if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                            String provisioningStateInstance;
                            provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineInstance.setProvisioningState(provisioningStateInstance);
                        }
                        
                        JsonNode instanceViewValue = propertiesValue.get("instanceView");
                        if (instanceViewValue != null && instanceViewValue instanceof NullNode == false) {
                            VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                            virtualMachineInstance.setInstanceView(instanceViewInstance);
                            
                            JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                            if (platformUpdateDomainValue != null && platformUpdateDomainValue instanceof NullNode == false) {
                                int platformUpdateDomainInstance;
                                platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                            }
                            
                            JsonNode platformFaultDomainValue = instanceViewValue.get("platformFaultDomain");
                            if (platformFaultDomainValue != null && platformFaultDomainValue instanceof NullNode == false) {
                                int platformFaultDomainInstance;
                                platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                            }
                            
                            JsonNode rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint");
                            if (rdpThumbPrintValue != null && rdpThumbPrintValue instanceof NullNode == false) {
                                String rdpThumbPrintInstance;
                                rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                            }
                            
                            JsonNode vmAgentValue = instanceViewValue.get("vmAgent");
                            if (vmAgentValue != null && vmAgentValue instanceof NullNode == false) {
                                VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                instanceViewInstance.setVMAgent(vmAgentInstance);
                                
                                JsonNode vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                if (vmAgentVersionValue != null && vmAgentVersionValue instanceof NullNode == false) {
                                    String vmAgentVersionInstance;
                                    vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                    vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                }
                                
                                JsonNode extensionHandlersArray = vmAgentValue.get("extensionHandlers");
                                if (extensionHandlersArray != null && extensionHandlersArray instanceof NullNode == false) {
                                    for (JsonNode extensionHandlersValue : ((ArrayNode) extensionHandlersArray)) {
                                        VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                        vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                        
                                        JsonNode typeValue = extensionHandlersValue.get("type");
                                        if (typeValue != null && typeValue instanceof NullNode == false) {
                                            String typeInstance;
                                            typeInstance = typeValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                        }
                                        
                                        JsonNode typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion");
                                        if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                                            String typeHandlerVersionInstance;
                                            typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                        }
                                        
                                        JsonNode statusValue = extensionHandlersValue.get("status");
                                        if (statusValue != null && statusValue instanceof NullNode == false) {
                                            InstanceViewStatus statusInstance = new InstanceViewStatus();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                            
                                            JsonNode codeValue = statusValue.get("code");
                                            if (codeValue != null && codeValue instanceof NullNode == false) {
                                                String codeInstance;
                                                codeInstance = codeValue.getTextValue();
                                                statusInstance.setCode(codeInstance);
                                            }
                                            
                                            JsonNode levelValue = statusValue.get("level");
                                            if (levelValue != null && levelValue instanceof NullNode == false) {
                                                String levelInstance;
                                                levelInstance = levelValue.getTextValue();
                                                statusInstance.setLevel(levelInstance);
                                            }
                                            
                                            JsonNode displayStatusValue = statusValue.get("displayStatus");
                                            if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                                String displayStatusInstance;
                                                displayStatusInstance = displayStatusValue.getTextValue();
                                                statusInstance.setDisplayStatus(displayStatusInstance);
                                            }
                                            
                                            JsonNode messageValue = statusValue.get("message");
                                            if (messageValue != null && messageValue instanceof NullNode == false) {
                                                String messageInstance;
                                                messageInstance = messageValue.getTextValue();
                                                statusInstance.setMessage(messageInstance);
                                            }
                                            
                                            JsonNode timeValue = statusValue.get("time");
                                            if (timeValue != null && timeValue instanceof NullNode == false) {
                                                Calendar timeInstance;
                                                timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                                statusInstance.setTime(timeInstance);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode statusesArray = vmAgentValue.get("statuses");
                                if (statusesArray != null && statusesArray instanceof NullNode == false) {
                                    for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                        InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                        vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                        
                                        JsonNode codeValue2 = statusesValue.get("code");
                                        if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                            String codeInstance2;
                                            codeInstance2 = codeValue2.getTextValue();
                                            instanceViewStatusInstance.setCode(codeInstance2);
                                        }
                                        
                                        JsonNode levelValue2 = statusesValue.get("level");
                                        if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                            String levelInstance2;
                                            levelInstance2 = levelValue2.getTextValue();
                                            instanceViewStatusInstance.setLevel(levelInstance2);
                                        }
                                        
                                        JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                        if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                            String displayStatusInstance2;
                                            displayStatusInstance2 = displayStatusValue2.getTextValue();
                                            instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                        }
                                        
                                        JsonNode messageValue2 = statusesValue.get("message");
                                        if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                            String messageInstance2;
                                            messageInstance2 = messageValue2.getTextValue();
                                            instanceViewStatusInstance.setMessage(messageInstance2);
                                        }
                                        
                                        JsonNode timeValue2 = statusesValue.get("time");
                                        if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                            Calendar timeInstance2;
                                            timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                            instanceViewStatusInstance.setTime(timeInstance2);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode disksArray = instanceViewValue.get("disks");
                            if (disksArray != null && disksArray instanceof NullNode == false) {
                                for (JsonNode disksValue : ((ArrayNode) disksArray)) {
                                    DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                    instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                    
                                    JsonNode nameValue4 = disksValue.get("name");
                                    if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                        String nameInstance4;
                                        nameInstance4 = nameValue4.getTextValue();
                                        diskInstanceViewInstance.setName(nameInstance4);
                                    }
                                    
                                    JsonNode statusesArray2 = disksValue.get("statuses");
                                    if (statusesArray2 != null && statusesArray2 instanceof NullNode == false) {
                                        for (JsonNode statusesValue2 : ((ArrayNode) statusesArray2)) {
                                            InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                            diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                            
                                            JsonNode codeValue3 = statusesValue2.get("code");
                                            if (codeValue3 != null && codeValue3 instanceof NullNode == false) {
                                                String codeInstance3;
                                                codeInstance3 = codeValue3.getTextValue();
                                                instanceViewStatusInstance2.setCode(codeInstance3);
                                            }
                                            
                                            JsonNode levelValue3 = statusesValue2.get("level");
                                            if (levelValue3 != null && levelValue3 instanceof NullNode == false) {
                                                String levelInstance3;
                                                levelInstance3 = levelValue3.getTextValue();
                                                instanceViewStatusInstance2.setLevel(levelInstance3);
                                            }
                                            
                                            JsonNode displayStatusValue3 = statusesValue2.get("displayStatus");
                                            if (displayStatusValue3 != null && displayStatusValue3 instanceof NullNode == false) {
                                                String displayStatusInstance3;
                                                displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                            }
                                            
                                            JsonNode messageValue3 = statusesValue2.get("message");
                                            if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                                String messageInstance3;
                                                messageInstance3 = messageValue3.getTextValue();
                                                instanceViewStatusInstance2.setMessage(messageInstance3);
                                            }
                                            
                                            JsonNode timeValue3 = statusesValue2.get("time");
                                            if (timeValue3 != null && timeValue3 instanceof NullNode == false) {
                                                Calendar timeInstance3;
                                                timeInstance3 = DatatypeConverter.parseDateTime(timeValue3.getTextValue());
                                                instanceViewStatusInstance2.setTime(timeInstance3);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode extensionsArray = instanceViewValue.get("extensions");
                            if (extensionsArray != null && extensionsArray instanceof NullNode == false) {
                                for (JsonNode extensionsValue : ((ArrayNode) extensionsArray)) {
                                    VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                    instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                    
                                    JsonNode nameValue5 = extensionsValue.get("name");
                                    if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                        String nameInstance5;
                                        nameInstance5 = nameValue5.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                    }
                                    
                                    JsonNode typeValue2 = extensionsValue.get("type");
                                    if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                        String typeInstance2;
                                        typeInstance2 = typeValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                    }
                                    
                                    JsonNode typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion");
                                    if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                        String typeHandlerVersionInstance2;
                                        typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                    }
                                    
                                    JsonNode substatusesArray = extensionsValue.get("substatuses");
                                    if (substatusesArray != null && substatusesArray instanceof NullNode == false) {
                                        for (JsonNode substatusesValue : ((ArrayNode) substatusesArray)) {
                                            InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                            
                                            JsonNode codeValue4 = substatusesValue.get("code");
                                            if (codeValue4 != null && codeValue4 instanceof NullNode == false) {
                                                String codeInstance4;
                                                codeInstance4 = codeValue4.getTextValue();
                                                instanceViewStatusInstance3.setCode(codeInstance4);
                                            }
                                            
                                            JsonNode levelValue4 = substatusesValue.get("level");
                                            if (levelValue4 != null && levelValue4 instanceof NullNode == false) {
                                                String levelInstance4;
                                                levelInstance4 = levelValue4.getTextValue();
                                                instanceViewStatusInstance3.setLevel(levelInstance4);
                                            }
                                            
                                            JsonNode displayStatusValue4 = substatusesValue.get("displayStatus");
                                            if (displayStatusValue4 != null && displayStatusValue4 instanceof NullNode == false) {
                                                String displayStatusInstance4;
                                                displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                            }
                                            
                                            JsonNode messageValue4 = substatusesValue.get("message");
                                            if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                                String messageInstance4;
                                                messageInstance4 = messageValue4.getTextValue();
                                                instanceViewStatusInstance3.setMessage(messageInstance4);
                                            }
                                            
                                            JsonNode timeValue4 = substatusesValue.get("time");
                                            if (timeValue4 != null && timeValue4 instanceof NullNode == false) {
                                                Calendar timeInstance4;
                                                timeInstance4 = DatatypeConverter.parseDateTime(timeValue4.getTextValue());
                                                instanceViewStatusInstance3.setTime(timeInstance4);
                                            }
                                        }
                                    }
                                    
                                    JsonNode statusesArray3 = extensionsValue.get("statuses");
                                    if (statusesArray3 != null && statusesArray3 instanceof NullNode == false) {
                                        for (JsonNode statusesValue3 : ((ArrayNode) statusesArray3)) {
                                            InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                            
                                            JsonNode codeValue5 = statusesValue3.get("code");
                                            if (codeValue5 != null && codeValue5 instanceof NullNode == false) {
                                                String codeInstance5;
                                                codeInstance5 = codeValue5.getTextValue();
                                                instanceViewStatusInstance4.setCode(codeInstance5);
                                            }
                                            
                                            JsonNode levelValue5 = statusesValue3.get("level");
                                            if (levelValue5 != null && levelValue5 instanceof NullNode == false) {
                                                String levelInstance5;
                                                levelInstance5 = levelValue5.getTextValue();
                                                instanceViewStatusInstance4.setLevel(levelInstance5);
                                            }
                                            
                                            JsonNode displayStatusValue5 = statusesValue3.get("displayStatus");
                                            if (displayStatusValue5 != null && displayStatusValue5 instanceof NullNode == false) {
                                                String displayStatusInstance5;
                                                displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                            }
                                            
                                            JsonNode messageValue5 = statusesValue3.get("message");
                                            if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                                String messageInstance5;
                                                messageInstance5 = messageValue5.getTextValue();
                                                instanceViewStatusInstance4.setMessage(messageInstance5);
                                            }
                                            
                                            JsonNode timeValue5 = statusesValue3.get("time");
                                            if (timeValue5 != null && timeValue5 instanceof NullNode == false) {
                                                Calendar timeInstance5;
                                                timeInstance5 = DatatypeConverter.parseDateTime(timeValue5.getTextValue());
                                                instanceViewStatusInstance4.setTime(timeInstance5);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics");
                            if (bootDiagnosticsValue2 != null && bootDiagnosticsValue2 instanceof NullNode == false) {
                                BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                
                                JsonNode consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                if (consoleScreenshotBlobUriValue != null && consoleScreenshotBlobUriValue instanceof NullNode == false) {
                                    URI consoleScreenshotBlobUriInstance;
                                    consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                }
                                
                                JsonNode serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri");
                                if (serialConsoleLogBlobUriValue != null && serialConsoleLogBlobUriValue instanceof NullNode == false) {
                                    URI serialConsoleLogBlobUriInstance;
                                    serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                }
                            }
                            
                            JsonNode statusesArray4 = instanceViewValue.get("statuses");
                            if (statusesArray4 != null && statusesArray4 instanceof NullNode == false) {
                                for (JsonNode statusesValue4 : ((ArrayNode) statusesArray4)) {
                                    InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                    
                                    JsonNode codeValue6 = statusesValue4.get("code");
                                    if (codeValue6 != null && codeValue6 instanceof NullNode == false) {
                                        String codeInstance6;
                                        codeInstance6 = codeValue6.getTextValue();
                                        instanceViewStatusInstance5.setCode(codeInstance6);
                                    }
                                    
                                    JsonNode levelValue6 = statusesValue4.get("level");
                                    if (levelValue6 != null && levelValue6 instanceof NullNode == false) {
                                        String levelInstance6;
                                        levelInstance6 = levelValue6.getTextValue();
                                        instanceViewStatusInstance5.setLevel(levelInstance6);
                                    }
                                    
                                    JsonNode displayStatusValue6 = statusesValue4.get("displayStatus");
                                    if (displayStatusValue6 != null && displayStatusValue6 instanceof NullNode == false) {
                                        String displayStatusInstance6;
                                        displayStatusInstance6 = displayStatusValue6.getTextValue();
                                        instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                    }
                                    
                                    JsonNode messageValue6 = statusesValue4.get("message");
                                    if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                        String messageInstance6;
                                        messageInstance6 = messageValue6.getTextValue();
                                        instanceViewStatusInstance5.setMessage(messageInstance6);
                                    }
                                    
                                    JsonNode timeValue6 = statusesValue4.get("time");
                                    if (timeValue6 != null && timeValue6 instanceof NullNode == false) {
                                        Calendar timeInstance6;
                                        timeInstance6 = DatatypeConverter.parseDateTime(timeValue6.getTextValue());
                                        instanceViewStatusInstance5.setTime(timeInstance6);
                                    }
                                }
                            }
                        }
                    }
                    
                    JsonNode resourcesArray = responseDoc.get("resources");
                    if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                        virtualMachineInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                        for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                            VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                            virtualMachineInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                            
                            JsonNode propertiesValue3 = resourcesValue.get("properties");
                            if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                if (publisherValue3 != null && publisherValue3 instanceof NullNode == false) {
                                    String publisherInstance3;
                                    publisherInstance3 = publisherValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                }
                                
                                JsonNode typeValue3 = propertiesValue3.get("type");
                                if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                    String typeInstance3;
                                    typeInstance3 = typeValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                }
                                
                                JsonNode typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion");
                                if (typeHandlerVersionValue3 != null && typeHandlerVersionValue3 instanceof NullNode == false) {
                                    String typeHandlerVersionInstance3;
                                    typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                }
                                
                                JsonNode autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion");
                                if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                                    boolean autoUpgradeMinorVersionInstance;
                                    autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                    virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                }
                                
                                JsonNode settingsValue = propertiesValue3.get("settings");
                                if (settingsValue != null && settingsValue instanceof NullNode == false) {
                                    String settingsInstance;
                                    settingsInstance = settingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                }
                                
                                JsonNode protectedSettingsValue = propertiesValue3.get("protectedSettings");
                                if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                                    String protectedSettingsInstance;
                                    protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                }
                                
                                JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                    String provisioningStateInstance2;
                                    provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                }
                                
                                JsonNode instanceViewValue2 = propertiesValue3.get("instanceView");
                                if (instanceViewValue2 != null && instanceViewValue2 instanceof NullNode == false) {
                                    VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                    virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                    
                                    JsonNode nameValue6 = instanceViewValue2.get("name");
                                    if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                        String nameInstance6;
                                        nameInstance6 = nameValue6.getTextValue();
                                        instanceViewInstance2.setName(nameInstance6);
                                    }
                                    
                                    JsonNode typeValue4 = instanceViewValue2.get("type");
                                    if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                        String typeInstance4;
                                        typeInstance4 = typeValue4.getTextValue();
                                        instanceViewInstance2.setExtensionType(typeInstance4);
                                    }
                                    
                                    JsonNode typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion");
                                    if (typeHandlerVersionValue4 != null && typeHandlerVersionValue4 instanceof NullNode == false) {
                                        String typeHandlerVersionInstance4;
                                        typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                        instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                    }
                                    
                                    JsonNode substatusesArray2 = instanceViewValue2.get("substatuses");
                                    if (substatusesArray2 != null && substatusesArray2 instanceof NullNode == false) {
                                        for (JsonNode substatusesValue2 : ((ArrayNode) substatusesArray2)) {
                                            InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                            instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                            
                                            JsonNode codeValue7 = substatusesValue2.get("code");
                                            if (codeValue7 != null && codeValue7 instanceof NullNode == false) {
                                                String codeInstance7;
                                                codeInstance7 = codeValue7.getTextValue();
                                                instanceViewStatusInstance6.setCode(codeInstance7);
                                            }
                                            
                                            JsonNode levelValue7 = substatusesValue2.get("level");
                                            if (levelValue7 != null && levelValue7 instanceof NullNode == false) {
                                                String levelInstance7;
                                                levelInstance7 = levelValue7.getTextValue();
                                                instanceViewStatusInstance6.setLevel(levelInstance7);
                                            }
                                            
                                            JsonNode displayStatusValue7 = substatusesValue2.get("displayStatus");
                                            if (displayStatusValue7 != null && displayStatusValue7 instanceof NullNode == false) {
                                                String displayStatusInstance7;
                                                displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                            }
                                            
                                            JsonNode messageValue7 = substatusesValue2.get("message");
                                            if (messageValue7 != null && messageValue7 instanceof NullNode == false) {
                                                String messageInstance7;
                                                messageInstance7 = messageValue7.getTextValue();
                                                instanceViewStatusInstance6.setMessage(messageInstance7);
                                            }
                                            
                                            JsonNode timeValue7 = substatusesValue2.get("time");
                                            if (timeValue7 != null && timeValue7 instanceof NullNode == false) {
                                                Calendar timeInstance7;
                                                timeInstance7 = DatatypeConverter.parseDateTime(timeValue7.getTextValue());
                                                instanceViewStatusInstance6.setTime(timeInstance7);
                                            }
                                        }
                                    }
                                    
                                    JsonNode statusesArray5 = instanceViewValue2.get("statuses");
                                    if (statusesArray5 != null && statusesArray5 instanceof NullNode == false) {
                                        for (JsonNode statusesValue5 : ((ArrayNode) statusesArray5)) {
                                            InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                            instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                            
                                            JsonNode codeValue8 = statusesValue5.get("code");
                                            if (codeValue8 != null && codeValue8 instanceof NullNode == false) {
                                                String codeInstance8;
                                                codeInstance8 = codeValue8.getTextValue();
                                                instanceViewStatusInstance7.setCode(codeInstance8);
                                            }
                                            
                                            JsonNode levelValue8 = statusesValue5.get("level");
                                            if (levelValue8 != null && levelValue8 instanceof NullNode == false) {
                                                String levelInstance8;
                                                levelInstance8 = levelValue8.getTextValue();
                                                instanceViewStatusInstance7.setLevel(levelInstance8);
                                            }
                                            
                                            JsonNode displayStatusValue8 = statusesValue5.get("displayStatus");
                                            if (displayStatusValue8 != null && displayStatusValue8 instanceof NullNode == false) {
                                                String displayStatusInstance8;
                                                displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                            }
                                            
                                            JsonNode messageValue8 = statusesValue5.get("message");
                                            if (messageValue8 != null && messageValue8 instanceof NullNode == false) {
                                                String messageInstance8;
                                                messageInstance8 = messageValue8.getTextValue();
                                                instanceViewStatusInstance7.setMessage(messageInstance8);
                                            }
                                            
                                            JsonNode timeValue8 = statusesValue5.get("time");
                                            if (timeValue8 != null && timeValue8 instanceof NullNode == false) {
                                                Calendar timeInstance8;
                                                timeInstance8 = DatatypeConverter.parseDateTime(timeValue8.getTextValue());
                                                instanceViewStatusInstance7.setTime(timeInstance8);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue4 = resourcesValue.get("id");
                            if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                String idInstance4;
                                idInstance4 = idValue4.getTextValue();
                                virtualMachineExtensionJsonInstance.setId(idInstance4);
                            }
                            
                            JsonNode nameValue7 = resourcesValue.get("name");
                            if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                String nameInstance7;
                                nameInstance7 = nameValue7.getTextValue();
                                virtualMachineExtensionJsonInstance.setName(nameInstance7);
                            }
                            
                            JsonNode typeValue5 = resourcesValue.get("type");
                            if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                String typeInstance5;
                                typeInstance5 = typeValue5.getTextValue();
                                virtualMachineExtensionJsonInstance.setType(typeInstance5);
                            }
                            
                            JsonNode locationValue = resourcesValue.get("location");
                            if (locationValue != null && locationValue instanceof NullNode == false) {
                                String locationInstance;
                                locationInstance = locationValue.getTextValue();
                                virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                            }
                            
                            JsonNode tagsSequenceElement = ((JsonNode) resourcesValue.get("tags"));
                            if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                while (itr.hasNext()) {
                                    Map.Entry<String, JsonNode> property = itr.next();
                                    String tagsKey = property.getKey();
                                    String tagsValue = property.getValue().getTextValue();
                                    virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                                }
                            }
                        }
                    }
                    
                    JsonNode idValue5 = responseDoc.get("id");
                    if (idValue5 != null && idValue5 instanceof NullNode == false) {
                        String idInstance5;
                        idInstance5 = idValue5.getTextValue();
                        virtualMachineInstance.setId(idInstance5);
                    }
                    
                    JsonNode nameValue8 = responseDoc.get("name");
                    if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                        String nameInstance8;
                        nameInstance8 = nameValue8.getTextValue();
                        virtualMachineInstance.setName(nameInstance8);
                    }
                    
                    JsonNode typeValue6 = responseDoc.get("type");
                    if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                        String typeInstance6;
                        typeInstance6 = typeValue6.getTextValue();
                        virtualMachineInstance.setType(typeInstance6);
                    }
                    
                    JsonNode locationValue2 = responseDoc.get("location");
                    if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                        String locationInstance2;
                        locationInstance2 = locationValue2.getTextValue();
                        virtualMachineInstance.setLocation(locationInstance2);
                    }
                    
                    JsonNode tagsSequenceElement2 = ((JsonNode) responseDoc.get("tags"));
                    if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                        Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                        while (itr2.hasNext()) {
                            Map.Entry<String, JsonNode> property2 = itr2.next();
                            String tagsKey2 = property2.getKey();
                            String tagsValue2 = property2.getValue().getTextValue();
                            virtualMachineInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to list virtual machines under a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public Future<VirtualMachineListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineListResponse>() { 
            @Override
            public VirtualMachineListResponse call() throws Exception {
                return list(resourceGroupName);
            }
         });
    }
    
    /**
    * The operation to list virtual machines under a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public VirtualMachineListResponse list(String resourceGroupName) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualMachine virtualMachineJsonInstance = new VirtualMachine();
                            result.getVirtualMachines().add(virtualMachineJsonInstance);
                            
                            JsonNode planValue = valueValue.get("plan");
                            if (planValue != null && planValue instanceof NullNode == false) {
                                Plan planInstance = new Plan();
                                virtualMachineJsonInstance.setPlan(planInstance);
                                
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                
                                JsonNode publisherValue = planValue.get("publisher");
                                if (publisherValue != null && publisherValue instanceof NullNode == false) {
                                    String publisherInstance;
                                    publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                
                                JsonNode productValue = planValue.get("product");
                                if (productValue != null && productValue instanceof NullNode == false) {
                                    String productInstance;
                                    productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                
                                JsonNode promotionCodeValue = planValue.get("promotionCode");
                                if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                                    String promotionCodeInstance;
                                    promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                                if (hardwareProfileValue != null && hardwareProfileValue instanceof NullNode == false) {
                                    HardwareProfile hardwareProfileInstance = new HardwareProfile();
                                    virtualMachineJsonInstance.setHardwareProfile(hardwareProfileInstance);
                                    
                                    JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                                    if (vmSizeValue != null && vmSizeValue instanceof NullNode == false) {
                                        String vmSizeInstance;
                                        vmSizeInstance = vmSizeValue.getTextValue();
                                        hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                                    }
                                }
                                
                                JsonNode storageProfileValue = propertiesValue.get("storageProfile");
                                if (storageProfileValue != null && storageProfileValue instanceof NullNode == false) {
                                    StorageProfile storageProfileInstance = new StorageProfile();
                                    virtualMachineJsonInstance.setStorageProfile(storageProfileInstance);
                                    
                                    JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                                    if (imageReferenceValue != null && imageReferenceValue instanceof NullNode == false) {
                                        ImageReference imageReferenceInstance = new ImageReference();
                                        storageProfileInstance.setImageReference(imageReferenceInstance);
                                        
                                        JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                        if (publisherValue2 != null && publisherValue2 instanceof NullNode == false) {
                                            String publisherInstance2;
                                            publisherInstance2 = publisherValue2.getTextValue();
                                            imageReferenceInstance.setPublisher(publisherInstance2);
                                        }
                                        
                                        JsonNode offerValue = imageReferenceValue.get("offer");
                                        if (offerValue != null && offerValue instanceof NullNode == false) {
                                            String offerInstance;
                                            offerInstance = offerValue.getTextValue();
                                            imageReferenceInstance.setOffer(offerInstance);
                                        }
                                        
                                        JsonNode skuValue = imageReferenceValue.get("sku");
                                        if (skuValue != null && skuValue instanceof NullNode == false) {
                                            String skuInstance;
                                            skuInstance = skuValue.getTextValue();
                                            imageReferenceInstance.setSku(skuInstance);
                                        }
                                        
                                        JsonNode versionValue = imageReferenceValue.get("version");
                                        if (versionValue != null && versionValue instanceof NullNode == false) {
                                            String versionInstance;
                                            versionInstance = versionValue.getTextValue();
                                            imageReferenceInstance.setVersion(versionInstance);
                                        }
                                    }
                                    
                                    JsonNode osDiskValue = storageProfileValue.get("osDisk");
                                    if (osDiskValue != null && osDiskValue instanceof NullNode == false) {
                                        OSDisk osDiskInstance = new OSDisk();
                                        storageProfileInstance.setOSDisk(osDiskInstance);
                                        
                                        JsonNode osTypeValue = osDiskValue.get("osType");
                                        if (osTypeValue != null && osTypeValue instanceof NullNode == false) {
                                            String osTypeInstance;
                                            osTypeInstance = osTypeValue.getTextValue();
                                            osDiskInstance.setOperatingSystemType(osTypeInstance);
                                        }
                                        
                                        JsonNode nameValue2 = osDiskValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            osDiskInstance.setName(nameInstance2);
                                        }
                                        
                                        JsonNode vhdValue = osDiskValue.get("vhd");
                                        if (vhdValue != null && vhdValue instanceof NullNode == false) {
                                            VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                            osDiskInstance.setVirtualHardDisk(vhdInstance);
                                            
                                            JsonNode uriValue = vhdValue.get("uri");
                                            if (uriValue != null && uriValue instanceof NullNode == false) {
                                                String uriInstance;
                                                uriInstance = uriValue.getTextValue();
                                                vhdInstance.setUri(uriInstance);
                                            }
                                        }
                                        
                                        JsonNode imageValue = osDiskValue.get("image");
                                        if (imageValue != null && imageValue instanceof NullNode == false) {
                                            VirtualHardDisk imageInstance = new VirtualHardDisk();
                                            osDiskInstance.setSourceImage(imageInstance);
                                            
                                            JsonNode uriValue2 = imageValue.get("uri");
                                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                                String uriInstance2;
                                                uriInstance2 = uriValue2.getTextValue();
                                                imageInstance.setUri(uriInstance2);
                                            }
                                        }
                                        
                                        JsonNode cachingValue = osDiskValue.get("caching");
                                        if (cachingValue != null && cachingValue instanceof NullNode == false) {
                                            String cachingInstance;
                                            cachingInstance = cachingValue.getTextValue();
                                            osDiskInstance.setCaching(cachingInstance);
                                        }
                                        
                                        JsonNode createOptionValue = osDiskValue.get("createOption");
                                        if (createOptionValue != null && createOptionValue instanceof NullNode == false) {
                                            String createOptionInstance;
                                            createOptionInstance = createOptionValue.getTextValue();
                                            osDiskInstance.setCreateOption(createOptionInstance);
                                        }
                                        
                                        JsonNode diskSizeGBValue = osDiskValue.get("diskSizeGB");
                                        if (diskSizeGBValue != null && diskSizeGBValue instanceof NullNode == false) {
                                            int diskSizeGBInstance;
                                            diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                            osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                        }
                                    }
                                    
                                    JsonNode dataDisksArray = storageProfileValue.get("dataDisks");
                                    if (dataDisksArray != null && dataDisksArray instanceof NullNode == false) {
                                        for (JsonNode dataDisksValue : ((ArrayNode) dataDisksArray)) {
                                            DataDisk dataDiskInstance = new DataDisk();
                                            storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                            
                                            JsonNode lunValue = dataDisksValue.get("lun");
                                            if (lunValue != null && lunValue instanceof NullNode == false) {
                                                int lunInstance;
                                                lunInstance = lunValue.getIntValue();
                                                dataDiskInstance.setLun(lunInstance);
                                            }
                                            
                                            JsonNode nameValue3 = dataDisksValue.get("name");
                                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                                String nameInstance3;
                                                nameInstance3 = nameValue3.getTextValue();
                                                dataDiskInstance.setName(nameInstance3);
                                            }
                                            
                                            JsonNode vhdValue2 = dataDisksValue.get("vhd");
                                            if (vhdValue2 != null && vhdValue2 instanceof NullNode == false) {
                                                VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                                
                                                JsonNode uriValue3 = vhdValue2.get("uri");
                                                if (uriValue3 != null && uriValue3 instanceof NullNode == false) {
                                                    String uriInstance3;
                                                    uriInstance3 = uriValue3.getTextValue();
                                                    vhdInstance2.setUri(uriInstance3);
                                                }
                                            }
                                            
                                            JsonNode imageValue2 = dataDisksValue.get("image");
                                            if (imageValue2 != null && imageValue2 instanceof NullNode == false) {
                                                VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setSourceImage(imageInstance2);
                                                
                                                JsonNode uriValue4 = imageValue2.get("uri");
                                                if (uriValue4 != null && uriValue4 instanceof NullNode == false) {
                                                    String uriInstance4;
                                                    uriInstance4 = uriValue4.getTextValue();
                                                    imageInstance2.setUri(uriInstance4);
                                                }
                                            }
                                            
                                            JsonNode cachingValue2 = dataDisksValue.get("caching");
                                            if (cachingValue2 != null && cachingValue2 instanceof NullNode == false) {
                                                String cachingInstance2;
                                                cachingInstance2 = cachingValue2.getTextValue();
                                                dataDiskInstance.setCaching(cachingInstance2);
                                            }
                                            
                                            JsonNode createOptionValue2 = dataDisksValue.get("createOption");
                                            if (createOptionValue2 != null && createOptionValue2 instanceof NullNode == false) {
                                                String createOptionInstance2;
                                                createOptionInstance2 = createOptionValue2.getTextValue();
                                                dataDiskInstance.setCreateOption(createOptionInstance2);
                                            }
                                            
                                            JsonNode diskSizeGBValue2 = dataDisksValue.get("diskSizeGB");
                                            if (diskSizeGBValue2 != null && diskSizeGBValue2 instanceof NullNode == false) {
                                                int diskSizeGBInstance2;
                                                diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                                dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode osProfileValue = propertiesValue.get("osProfile");
                                if (osProfileValue != null && osProfileValue instanceof NullNode == false) {
                                    OSProfile osProfileInstance = new OSProfile();
                                    virtualMachineJsonInstance.setOSProfile(osProfileInstance);
                                    
                                    JsonNode computerNameValue = osProfileValue.get("computerName");
                                    if (computerNameValue != null && computerNameValue instanceof NullNode == false) {
                                        String computerNameInstance;
                                        computerNameInstance = computerNameValue.getTextValue();
                                        osProfileInstance.setComputerName(computerNameInstance);
                                    }
                                    
                                    JsonNode adminUsernameValue = osProfileValue.get("adminUsername");
                                    if (adminUsernameValue != null && adminUsernameValue instanceof NullNode == false) {
                                        String adminUsernameInstance;
                                        adminUsernameInstance = adminUsernameValue.getTextValue();
                                        osProfileInstance.setAdminUsername(adminUsernameInstance);
                                    }
                                    
                                    JsonNode adminPasswordValue = osProfileValue.get("adminPassword");
                                    if (adminPasswordValue != null && adminPasswordValue instanceof NullNode == false) {
                                        String adminPasswordInstance;
                                        adminPasswordInstance = adminPasswordValue.getTextValue();
                                        osProfileInstance.setAdminPassword(adminPasswordInstance);
                                    }
                                    
                                    JsonNode customDataValue = osProfileValue.get("customData");
                                    if (customDataValue != null && customDataValue instanceof NullNode == false) {
                                        String customDataInstance;
                                        customDataInstance = customDataValue.getTextValue();
                                        osProfileInstance.setCustomData(customDataInstance);
                                    }
                                    
                                    JsonNode windowsConfigurationValue = osProfileValue.get("windowsConfiguration");
                                    if (windowsConfigurationValue != null && windowsConfigurationValue instanceof NullNode == false) {
                                        WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                        osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                        
                                        JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                        if (provisionVMAgentValue != null && provisionVMAgentValue instanceof NullNode == false) {
                                            boolean provisionVMAgentInstance;
                                            provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                            windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                        }
                                        
                                        JsonNode enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates");
                                        if (enableAutomaticUpdatesValue != null && enableAutomaticUpdatesValue instanceof NullNode == false) {
                                            boolean enableAutomaticUpdatesInstance;
                                            enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                            windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                        }
                                        
                                        JsonNode timeZoneValue = windowsConfigurationValue.get("timeZone");
                                        if (timeZoneValue != null && timeZoneValue instanceof NullNode == false) {
                                            String timeZoneInstance;
                                            timeZoneInstance = timeZoneValue.getTextValue();
                                            windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                        }
                                        
                                        JsonNode additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent");
                                        if (additionalUnattendContentArray != null && additionalUnattendContentArray instanceof NullNode == false) {
                                            for (JsonNode additionalUnattendContentValue : ((ArrayNode) additionalUnattendContentArray)) {
                                                AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                                windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                                
                                                JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                                if (passNameValue != null && passNameValue instanceof NullNode == false) {
                                                    String passNameInstance;
                                                    passNameInstance = passNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setPassName(passNameInstance);
                                                }
                                                
                                                JsonNode componentNameValue = additionalUnattendContentValue.get("componentName");
                                                if (componentNameValue != null && componentNameValue instanceof NullNode == false) {
                                                    String componentNameInstance;
                                                    componentNameInstance = componentNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                                }
                                                
                                                JsonNode settingNameValue = additionalUnattendContentValue.get("settingName");
                                                if (settingNameValue != null && settingNameValue instanceof NullNode == false) {
                                                    String settingNameInstance;
                                                    settingNameInstance = settingNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                                }
                                                
                                                JsonNode contentValue = additionalUnattendContentValue.get("content");
                                                if (contentValue != null && contentValue instanceof NullNode == false) {
                                                    String contentInstance;
                                                    contentInstance = contentValue.getTextValue();
                                                    additionalUnattendContentInstance.setContent(contentInstance);
                                                }
                                            }
                                        }
                                        
                                        JsonNode winRMValue = windowsConfigurationValue.get("winRM");
                                        if (winRMValue != null && winRMValue instanceof NullNode == false) {
                                            WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                            windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                            
                                            JsonNode listenersArray = winRMValue.get("listeners");
                                            if (listenersArray != null && listenersArray instanceof NullNode == false) {
                                                for (JsonNode listenersValue : ((ArrayNode) listenersArray)) {
                                                    WinRMListener winRMListenerInstance = new WinRMListener();
                                                    winRMInstance.getListeners().add(winRMListenerInstance);
                                                    
                                                    JsonNode protocolValue = listenersValue.get("protocol");
                                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                        String protocolInstance;
                                                        protocolInstance = protocolValue.getTextValue();
                                                        winRMListenerInstance.setProtocol(protocolInstance);
                                                    }
                                                    
                                                    JsonNode certificateUrlValue = listenersValue.get("certificateUrl");
                                                    if (certificateUrlValue != null && certificateUrlValue instanceof NullNode == false) {
                                                        URI certificateUrlInstance;
                                                        certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                        winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode linuxConfigurationValue = osProfileValue.get("linuxConfiguration");
                                    if (linuxConfigurationValue != null && linuxConfigurationValue instanceof NullNode == false) {
                                        LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                        osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                        
                                        JsonNode disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                        if (disablePasswordAuthenticationValue != null && disablePasswordAuthenticationValue instanceof NullNode == false) {
                                            boolean disablePasswordAuthenticationInstance;
                                            disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                            linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                        }
                                        
                                        JsonNode sshValue = linuxConfigurationValue.get("ssh");
                                        if (sshValue != null && sshValue instanceof NullNode == false) {
                                            SshConfiguration sshInstance = new SshConfiguration();
                                            linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                            
                                            JsonNode publicKeysArray = sshValue.get("publicKeys");
                                            if (publicKeysArray != null && publicKeysArray instanceof NullNode == false) {
                                                for (JsonNode publicKeysValue : ((ArrayNode) publicKeysArray)) {
                                                    SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                                    sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                                    
                                                    JsonNode pathValue = publicKeysValue.get("path");
                                                    if (pathValue != null && pathValue instanceof NullNode == false) {
                                                        String pathInstance;
                                                        pathInstance = pathValue.getTextValue();
                                                        sshPublicKeyInstance.setPath(pathInstance);
                                                    }
                                                    
                                                    JsonNode keyDataValue = publicKeysValue.get("keyData");
                                                    if (keyDataValue != null && keyDataValue instanceof NullNode == false) {
                                                        String keyDataInstance;
                                                        keyDataInstance = keyDataValue.getTextValue();
                                                        sshPublicKeyInstance.setKeyData(keyDataInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode secretsArray = osProfileValue.get("secrets");
                                    if (secretsArray != null && secretsArray instanceof NullNode == false) {
                                        for (JsonNode secretsValue : ((ArrayNode) secretsArray)) {
                                            VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                            osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                            
                                            JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                            if (sourceVaultValue != null && sourceVaultValue instanceof NullNode == false) {
                                                SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                                vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                                
                                                JsonNode idValue = sourceVaultValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    sourceVaultInstance.setReferenceUri(idInstance);
                                                }
                                            }
                                            
                                            JsonNode vaultCertificatesArray = secretsValue.get("vaultCertificates");
                                            if (vaultCertificatesArray != null && vaultCertificatesArray instanceof NullNode == false) {
                                                for (JsonNode vaultCertificatesValue : ((ArrayNode) vaultCertificatesArray)) {
                                                    VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                                    vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                                    
                                                    JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                                    if (certificateUrlValue2 != null && certificateUrlValue2 instanceof NullNode == false) {
                                                        String certificateUrlInstance2;
                                                        certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                        vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                                    }
                                                    
                                                    JsonNode certificateStoreValue = vaultCertificatesValue.get("certificateStore");
                                                    if (certificateStoreValue != null && certificateStoreValue instanceof NullNode == false) {
                                                        String certificateStoreInstance;
                                                        certificateStoreInstance = certificateStoreValue.getTextValue();
                                                        vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode networkProfileValue = propertiesValue.get("networkProfile");
                                if (networkProfileValue != null && networkProfileValue instanceof NullNode == false) {
                                    NetworkProfile networkProfileInstance = new NetworkProfile();
                                    virtualMachineJsonInstance.setNetworkProfile(networkProfileInstance);
                                    
                                    JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                                    if (networkInterfacesArray != null && networkInterfacesArray instanceof NullNode == false) {
                                        for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray)) {
                                            NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                            networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                            
                                            JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                                JsonNode primaryValue = propertiesValue2.get("primary");
                                                if (primaryValue != null && primaryValue instanceof NullNode == false) {
                                                    boolean primaryInstance;
                                                    primaryInstance = primaryValue.getBooleanValue();
                                                    networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                                }
                                            }
                                            
                                            JsonNode idValue2 = networkInterfacesValue.get("id");
                                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                String idInstance2;
                                                idInstance2 = idValue2.getTextValue();
                                                networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile");
                                if (diagnosticsProfileValue != null && diagnosticsProfileValue instanceof NullNode == false) {
                                    DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                                    virtualMachineJsonInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                                    
                                    JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue != null && bootDiagnosticsValue instanceof NullNode == false) {
                                        BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                        diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                        
                                        JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                            boolean enabledInstance;
                                            enabledInstance = enabledValue.getBooleanValue();
                                            bootDiagnosticsInstance.setEnabled(enabledInstance);
                                        }
                                        
                                        JsonNode storageUriValue = bootDiagnosticsValue.get("storageUri");
                                        if (storageUriValue != null && storageUriValue instanceof NullNode == false) {
                                            URI storageUriInstance;
                                            storageUriInstance = new URI(storageUriValue.getTextValue());
                                            bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                        }
                                    }
                                }
                                
                                JsonNode availabilitySetValue = propertiesValue.get("availabilitySet");
                                if (availabilitySetValue != null && availabilitySetValue instanceof NullNode == false) {
                                    AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                                    virtualMachineJsonInstance.setAvailabilitySetReference(availabilitySetInstance);
                                    
                                    JsonNode idValue3 = availabilitySetValue.get("id");
                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                        String idInstance3;
                                        idInstance3 = idValue3.getTextValue();
                                        availabilitySetInstance.setReferenceUri(idInstance3);
                                    }
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    virtualMachineJsonInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode instanceViewValue = propertiesValue.get("instanceView");
                                if (instanceViewValue != null && instanceViewValue instanceof NullNode == false) {
                                    VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                                    virtualMachineJsonInstance.setInstanceView(instanceViewInstance);
                                    
                                    JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                                    if (platformUpdateDomainValue != null && platformUpdateDomainValue instanceof NullNode == false) {
                                        int platformUpdateDomainInstance;
                                        platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                                    }
                                    
                                    JsonNode platformFaultDomainValue = instanceViewValue.get("platformFaultDomain");
                                    if (platformFaultDomainValue != null && platformFaultDomainValue instanceof NullNode == false) {
                                        int platformFaultDomainInstance;
                                        platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                                    }
                                    
                                    JsonNode rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint");
                                    if (rdpThumbPrintValue != null && rdpThumbPrintValue instanceof NullNode == false) {
                                        String rdpThumbPrintInstance;
                                        rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                        instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                                    }
                                    
                                    JsonNode vmAgentValue = instanceViewValue.get("vmAgent");
                                    if (vmAgentValue != null && vmAgentValue instanceof NullNode == false) {
                                        VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                        instanceViewInstance.setVMAgent(vmAgentInstance);
                                        
                                        JsonNode vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                        if (vmAgentVersionValue != null && vmAgentVersionValue instanceof NullNode == false) {
                                            String vmAgentVersionInstance;
                                            vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                            vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                        }
                                        
                                        JsonNode extensionHandlersArray = vmAgentValue.get("extensionHandlers");
                                        if (extensionHandlersArray != null && extensionHandlersArray instanceof NullNode == false) {
                                            for (JsonNode extensionHandlersValue : ((ArrayNode) extensionHandlersArray)) {
                                                VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                                vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                                
                                                JsonNode typeValue = extensionHandlersValue.get("type");
                                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                                    String typeInstance;
                                                    typeInstance = typeValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                                }
                                                
                                                JsonNode typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion");
                                                if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                                                    String typeHandlerVersionInstance;
                                                    typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                                }
                                                
                                                JsonNode statusValue = extensionHandlersValue.get("status");
                                                if (statusValue != null && statusValue instanceof NullNode == false) {
                                                    InstanceViewStatus statusInstance = new InstanceViewStatus();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                                    
                                                    JsonNode codeValue = statusValue.get("code");
                                                    if (codeValue != null && codeValue instanceof NullNode == false) {
                                                        String codeInstance;
                                                        codeInstance = codeValue.getTextValue();
                                                        statusInstance.setCode(codeInstance);
                                                    }
                                                    
                                                    JsonNode levelValue = statusValue.get("level");
                                                    if (levelValue != null && levelValue instanceof NullNode == false) {
                                                        String levelInstance;
                                                        levelInstance = levelValue.getTextValue();
                                                        statusInstance.setLevel(levelInstance);
                                                    }
                                                    
                                                    JsonNode displayStatusValue = statusValue.get("displayStatus");
                                                    if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                                        String displayStatusInstance;
                                                        displayStatusInstance = displayStatusValue.getTextValue();
                                                        statusInstance.setDisplayStatus(displayStatusInstance);
                                                    }
                                                    
                                                    JsonNode messageValue = statusValue.get("message");
                                                    if (messageValue != null && messageValue instanceof NullNode == false) {
                                                        String messageInstance;
                                                        messageInstance = messageValue.getTextValue();
                                                        statusInstance.setMessage(messageInstance);
                                                    }
                                                    
                                                    JsonNode timeValue = statusValue.get("time");
                                                    if (timeValue != null && timeValue instanceof NullNode == false) {
                                                        Calendar timeInstance;
                                                        timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                                        statusInstance.setTime(timeInstance);
                                                    }
                                                }
                                            }
                                        }
                                        
                                        JsonNode statusesArray = vmAgentValue.get("statuses");
                                        if (statusesArray != null && statusesArray instanceof NullNode == false) {
                                            for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                                vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                                
                                                JsonNode codeValue2 = statusesValue.get("code");
                                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                                    String codeInstance2;
                                                    codeInstance2 = codeValue2.getTextValue();
                                                    instanceViewStatusInstance.setCode(codeInstance2);
                                                }
                                                
                                                JsonNode levelValue2 = statusesValue.get("level");
                                                if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                                    String levelInstance2;
                                                    levelInstance2 = levelValue2.getTextValue();
                                                    instanceViewStatusInstance.setLevel(levelInstance2);
                                                }
                                                
                                                JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                                if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                                    String displayStatusInstance2;
                                                    displayStatusInstance2 = displayStatusValue2.getTextValue();
                                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                                }
                                                
                                                JsonNode messageValue2 = statusesValue.get("message");
                                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                                    String messageInstance2;
                                                    messageInstance2 = messageValue2.getTextValue();
                                                    instanceViewStatusInstance.setMessage(messageInstance2);
                                                }
                                                
                                                JsonNode timeValue2 = statusesValue.get("time");
                                                if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                                    Calendar timeInstance2;
                                                    timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                                    instanceViewStatusInstance.setTime(timeInstance2);
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode disksArray = instanceViewValue.get("disks");
                                    if (disksArray != null && disksArray instanceof NullNode == false) {
                                        for (JsonNode disksValue : ((ArrayNode) disksArray)) {
                                            DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                            instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                            
                                            JsonNode nameValue4 = disksValue.get("name");
                                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                String nameInstance4;
                                                nameInstance4 = nameValue4.getTextValue();
                                                diskInstanceViewInstance.setName(nameInstance4);
                                            }
                                            
                                            JsonNode statusesArray2 = disksValue.get("statuses");
                                            if (statusesArray2 != null && statusesArray2 instanceof NullNode == false) {
                                                for (JsonNode statusesValue2 : ((ArrayNode) statusesArray2)) {
                                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                                    diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                                    
                                                    JsonNode codeValue3 = statusesValue2.get("code");
                                                    if (codeValue3 != null && codeValue3 instanceof NullNode == false) {
                                                        String codeInstance3;
                                                        codeInstance3 = codeValue3.getTextValue();
                                                        instanceViewStatusInstance2.setCode(codeInstance3);
                                                    }
                                                    
                                                    JsonNode levelValue3 = statusesValue2.get("level");
                                                    if (levelValue3 != null && levelValue3 instanceof NullNode == false) {
                                                        String levelInstance3;
                                                        levelInstance3 = levelValue3.getTextValue();
                                                        instanceViewStatusInstance2.setLevel(levelInstance3);
                                                    }
                                                    
                                                    JsonNode displayStatusValue3 = statusesValue2.get("displayStatus");
                                                    if (displayStatusValue3 != null && displayStatusValue3 instanceof NullNode == false) {
                                                        String displayStatusInstance3;
                                                        displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                                    }
                                                    
                                                    JsonNode messageValue3 = statusesValue2.get("message");
                                                    if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                                        String messageInstance3;
                                                        messageInstance3 = messageValue3.getTextValue();
                                                        instanceViewStatusInstance2.setMessage(messageInstance3);
                                                    }
                                                    
                                                    JsonNode timeValue3 = statusesValue2.get("time");
                                                    if (timeValue3 != null && timeValue3 instanceof NullNode == false) {
                                                        Calendar timeInstance3;
                                                        timeInstance3 = DatatypeConverter.parseDateTime(timeValue3.getTextValue());
                                                        instanceViewStatusInstance2.setTime(timeInstance3);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode extensionsArray = instanceViewValue.get("extensions");
                                    if (extensionsArray != null && extensionsArray instanceof NullNode == false) {
                                        for (JsonNode extensionsValue : ((ArrayNode) extensionsArray)) {
                                            VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                            instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                            
                                            JsonNode nameValue5 = extensionsValue.get("name");
                                            if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                                String nameInstance5;
                                                nameInstance5 = nameValue5.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                            }
                                            
                                            JsonNode typeValue2 = extensionsValue.get("type");
                                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                                String typeInstance2;
                                                typeInstance2 = typeValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                            }
                                            
                                            JsonNode typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion");
                                            if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                                String typeHandlerVersionInstance2;
                                                typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                            }
                                            
                                            JsonNode substatusesArray = extensionsValue.get("substatuses");
                                            if (substatusesArray != null && substatusesArray instanceof NullNode == false) {
                                                for (JsonNode substatusesValue : ((ArrayNode) substatusesArray)) {
                                                    InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                                    
                                                    JsonNode codeValue4 = substatusesValue.get("code");
                                                    if (codeValue4 != null && codeValue4 instanceof NullNode == false) {
                                                        String codeInstance4;
                                                        codeInstance4 = codeValue4.getTextValue();
                                                        instanceViewStatusInstance3.setCode(codeInstance4);
                                                    }
                                                    
                                                    JsonNode levelValue4 = substatusesValue.get("level");
                                                    if (levelValue4 != null && levelValue4 instanceof NullNode == false) {
                                                        String levelInstance4;
                                                        levelInstance4 = levelValue4.getTextValue();
                                                        instanceViewStatusInstance3.setLevel(levelInstance4);
                                                    }
                                                    
                                                    JsonNode displayStatusValue4 = substatusesValue.get("displayStatus");
                                                    if (displayStatusValue4 != null && displayStatusValue4 instanceof NullNode == false) {
                                                        String displayStatusInstance4;
                                                        displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                        instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                                    }
                                                    
                                                    JsonNode messageValue4 = substatusesValue.get("message");
                                                    if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                                        String messageInstance4;
                                                        messageInstance4 = messageValue4.getTextValue();
                                                        instanceViewStatusInstance3.setMessage(messageInstance4);
                                                    }
                                                    
                                                    JsonNode timeValue4 = substatusesValue.get("time");
                                                    if (timeValue4 != null && timeValue4 instanceof NullNode == false) {
                                                        Calendar timeInstance4;
                                                        timeInstance4 = DatatypeConverter.parseDateTime(timeValue4.getTextValue());
                                                        instanceViewStatusInstance3.setTime(timeInstance4);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode statusesArray3 = extensionsValue.get("statuses");
                                            if (statusesArray3 != null && statusesArray3 instanceof NullNode == false) {
                                                for (JsonNode statusesValue3 : ((ArrayNode) statusesArray3)) {
                                                    InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                                    
                                                    JsonNode codeValue5 = statusesValue3.get("code");
                                                    if (codeValue5 != null && codeValue5 instanceof NullNode == false) {
                                                        String codeInstance5;
                                                        codeInstance5 = codeValue5.getTextValue();
                                                        instanceViewStatusInstance4.setCode(codeInstance5);
                                                    }
                                                    
                                                    JsonNode levelValue5 = statusesValue3.get("level");
                                                    if (levelValue5 != null && levelValue5 instanceof NullNode == false) {
                                                        String levelInstance5;
                                                        levelInstance5 = levelValue5.getTextValue();
                                                        instanceViewStatusInstance4.setLevel(levelInstance5);
                                                    }
                                                    
                                                    JsonNode displayStatusValue5 = statusesValue3.get("displayStatus");
                                                    if (displayStatusValue5 != null && displayStatusValue5 instanceof NullNode == false) {
                                                        String displayStatusInstance5;
                                                        displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                        instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                                    }
                                                    
                                                    JsonNode messageValue5 = statusesValue3.get("message");
                                                    if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                                        String messageInstance5;
                                                        messageInstance5 = messageValue5.getTextValue();
                                                        instanceViewStatusInstance4.setMessage(messageInstance5);
                                                    }
                                                    
                                                    JsonNode timeValue5 = statusesValue3.get("time");
                                                    if (timeValue5 != null && timeValue5 instanceof NullNode == false) {
                                                        Calendar timeInstance5;
                                                        timeInstance5 = DatatypeConverter.parseDateTime(timeValue5.getTextValue());
                                                        instanceViewStatusInstance4.setTime(timeInstance5);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue2 != null && bootDiagnosticsValue2 instanceof NullNode == false) {
                                        BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                        instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                        
                                        JsonNode consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                        if (consoleScreenshotBlobUriValue != null && consoleScreenshotBlobUriValue instanceof NullNode == false) {
                                            URI consoleScreenshotBlobUriInstance;
                                            consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                        }
                                        
                                        JsonNode serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri");
                                        if (serialConsoleLogBlobUriValue != null && serialConsoleLogBlobUriValue instanceof NullNode == false) {
                                            URI serialConsoleLogBlobUriInstance;
                                            serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                        }
                                    }
                                    
                                    JsonNode statusesArray4 = instanceViewValue.get("statuses");
                                    if (statusesArray4 != null && statusesArray4 instanceof NullNode == false) {
                                        for (JsonNode statusesValue4 : ((ArrayNode) statusesArray4)) {
                                            InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                            instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                            
                                            JsonNode codeValue6 = statusesValue4.get("code");
                                            if (codeValue6 != null && codeValue6 instanceof NullNode == false) {
                                                String codeInstance6;
                                                codeInstance6 = codeValue6.getTextValue();
                                                instanceViewStatusInstance5.setCode(codeInstance6);
                                            }
                                            
                                            JsonNode levelValue6 = statusesValue4.get("level");
                                            if (levelValue6 != null && levelValue6 instanceof NullNode == false) {
                                                String levelInstance6;
                                                levelInstance6 = levelValue6.getTextValue();
                                                instanceViewStatusInstance5.setLevel(levelInstance6);
                                            }
                                            
                                            JsonNode displayStatusValue6 = statusesValue4.get("displayStatus");
                                            if (displayStatusValue6 != null && displayStatusValue6 instanceof NullNode == false) {
                                                String displayStatusInstance6;
                                                displayStatusInstance6 = displayStatusValue6.getTextValue();
                                                instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                            }
                                            
                                            JsonNode messageValue6 = statusesValue4.get("message");
                                            if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                                String messageInstance6;
                                                messageInstance6 = messageValue6.getTextValue();
                                                instanceViewStatusInstance5.setMessage(messageInstance6);
                                            }
                                            
                                            JsonNode timeValue6 = statusesValue4.get("time");
                                            if (timeValue6 != null && timeValue6 instanceof NullNode == false) {
                                                Calendar timeInstance6;
                                                timeInstance6 = DatatypeConverter.parseDateTime(timeValue6.getTextValue());
                                                instanceViewStatusInstance5.setTime(timeInstance6);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode resourcesArray = valueValue.get("resources");
                            if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                                virtualMachineJsonInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                                for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                                    VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                                    virtualMachineJsonInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                                    
                                    JsonNode propertiesValue3 = resourcesValue.get("properties");
                                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                        JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                        if (publisherValue3 != null && publisherValue3 instanceof NullNode == false) {
                                            String publisherInstance3;
                                            publisherInstance3 = publisherValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                        }
                                        
                                        JsonNode typeValue3 = propertiesValue3.get("type");
                                        if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                            String typeInstance3;
                                            typeInstance3 = typeValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                        }
                                        
                                        JsonNode typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion");
                                        if (typeHandlerVersionValue3 != null && typeHandlerVersionValue3 instanceof NullNode == false) {
                                            String typeHandlerVersionInstance3;
                                            typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                        }
                                        
                                        JsonNode autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion");
                                        if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                                            boolean autoUpgradeMinorVersionInstance;
                                            autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                            virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                        }
                                        
                                        JsonNode settingsValue = propertiesValue3.get("settings");
                                        if (settingsValue != null && settingsValue instanceof NullNode == false) {
                                            String settingsInstance;
                                            settingsInstance = settingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                        }
                                        
                                        JsonNode protectedSettingsValue = propertiesValue3.get("protectedSettings");
                                        if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                                            String protectedSettingsInstance;
                                            protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                        }
                                        
                                        JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                            String provisioningStateInstance2;
                                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                        }
                                        
                                        JsonNode instanceViewValue2 = propertiesValue3.get("instanceView");
                                        if (instanceViewValue2 != null && instanceViewValue2 instanceof NullNode == false) {
                                            VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                            virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                            
                                            JsonNode nameValue6 = instanceViewValue2.get("name");
                                            if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                                String nameInstance6;
                                                nameInstance6 = nameValue6.getTextValue();
                                                instanceViewInstance2.setName(nameInstance6);
                                            }
                                            
                                            JsonNode typeValue4 = instanceViewValue2.get("type");
                                            if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                String typeInstance4;
                                                typeInstance4 = typeValue4.getTextValue();
                                                instanceViewInstance2.setExtensionType(typeInstance4);
                                            }
                                            
                                            JsonNode typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion");
                                            if (typeHandlerVersionValue4 != null && typeHandlerVersionValue4 instanceof NullNode == false) {
                                                String typeHandlerVersionInstance4;
                                                typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                                instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                            }
                                            
                                            JsonNode substatusesArray2 = instanceViewValue2.get("substatuses");
                                            if (substatusesArray2 != null && substatusesArray2 instanceof NullNode == false) {
                                                for (JsonNode substatusesValue2 : ((ArrayNode) substatusesArray2)) {
                                                    InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                                    instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                                    
                                                    JsonNode codeValue7 = substatusesValue2.get("code");
                                                    if (codeValue7 != null && codeValue7 instanceof NullNode == false) {
                                                        String codeInstance7;
                                                        codeInstance7 = codeValue7.getTextValue();
                                                        instanceViewStatusInstance6.setCode(codeInstance7);
                                                    }
                                                    
                                                    JsonNode levelValue7 = substatusesValue2.get("level");
                                                    if (levelValue7 != null && levelValue7 instanceof NullNode == false) {
                                                        String levelInstance7;
                                                        levelInstance7 = levelValue7.getTextValue();
                                                        instanceViewStatusInstance6.setLevel(levelInstance7);
                                                    }
                                                    
                                                    JsonNode displayStatusValue7 = substatusesValue2.get("displayStatus");
                                                    if (displayStatusValue7 != null && displayStatusValue7 instanceof NullNode == false) {
                                                        String displayStatusInstance7;
                                                        displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                        instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                                    }
                                                    
                                                    JsonNode messageValue7 = substatusesValue2.get("message");
                                                    if (messageValue7 != null && messageValue7 instanceof NullNode == false) {
                                                        String messageInstance7;
                                                        messageInstance7 = messageValue7.getTextValue();
                                                        instanceViewStatusInstance6.setMessage(messageInstance7);
                                                    }
                                                    
                                                    JsonNode timeValue7 = substatusesValue2.get("time");
                                                    if (timeValue7 != null && timeValue7 instanceof NullNode == false) {
                                                        Calendar timeInstance7;
                                                        timeInstance7 = DatatypeConverter.parseDateTime(timeValue7.getTextValue());
                                                        instanceViewStatusInstance6.setTime(timeInstance7);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode statusesArray5 = instanceViewValue2.get("statuses");
                                            if (statusesArray5 != null && statusesArray5 instanceof NullNode == false) {
                                                for (JsonNode statusesValue5 : ((ArrayNode) statusesArray5)) {
                                                    InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                                    instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                                    
                                                    JsonNode codeValue8 = statusesValue5.get("code");
                                                    if (codeValue8 != null && codeValue8 instanceof NullNode == false) {
                                                        String codeInstance8;
                                                        codeInstance8 = codeValue8.getTextValue();
                                                        instanceViewStatusInstance7.setCode(codeInstance8);
                                                    }
                                                    
                                                    JsonNode levelValue8 = statusesValue5.get("level");
                                                    if (levelValue8 != null && levelValue8 instanceof NullNode == false) {
                                                        String levelInstance8;
                                                        levelInstance8 = levelValue8.getTextValue();
                                                        instanceViewStatusInstance7.setLevel(levelInstance8);
                                                    }
                                                    
                                                    JsonNode displayStatusValue8 = statusesValue5.get("displayStatus");
                                                    if (displayStatusValue8 != null && displayStatusValue8 instanceof NullNode == false) {
                                                        String displayStatusInstance8;
                                                        displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                        instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                                    }
                                                    
                                                    JsonNode messageValue8 = statusesValue5.get("message");
                                                    if (messageValue8 != null && messageValue8 instanceof NullNode == false) {
                                                        String messageInstance8;
                                                        messageInstance8 = messageValue8.getTextValue();
                                                        instanceViewStatusInstance7.setMessage(messageInstance8);
                                                    }
                                                    
                                                    JsonNode timeValue8 = statusesValue5.get("time");
                                                    if (timeValue8 != null && timeValue8 instanceof NullNode == false) {
                                                        Calendar timeInstance8;
                                                        timeInstance8 = DatatypeConverter.parseDateTime(timeValue8.getTextValue());
                                                        instanceViewStatusInstance7.setTime(timeInstance8);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode idValue4 = resourcesValue.get("id");
                                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                        String idInstance4;
                                        idInstance4 = idValue4.getTextValue();
                                        virtualMachineExtensionJsonInstance.setId(idInstance4);
                                    }
                                    
                                    JsonNode nameValue7 = resourcesValue.get("name");
                                    if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                        String nameInstance7;
                                        nameInstance7 = nameValue7.getTextValue();
                                        virtualMachineExtensionJsonInstance.setName(nameInstance7);
                                    }
                                    
                                    JsonNode typeValue5 = resourcesValue.get("type");
                                    if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                        String typeInstance5;
                                        typeInstance5 = typeValue5.getTextValue();
                                        virtualMachineExtensionJsonInstance.setType(typeInstance5);
                                    }
                                    
                                    JsonNode locationValue = resourcesValue.get("location");
                                    if (locationValue != null && locationValue instanceof NullNode == false) {
                                        String locationInstance;
                                        locationInstance = locationValue.getTextValue();
                                        virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                                    }
                                    
                                    JsonNode tagsSequenceElement = ((JsonNode) resourcesValue.get("tags"));
                                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry<String, JsonNode> property = itr.next();
                                            String tagsKey = property.getKey();
                                            String tagsValue = property.getValue().getTextValue();
                                            virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue5 = valueValue.get("id");
                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                String idInstance5;
                                idInstance5 = idValue5.getTextValue();
                                virtualMachineJsonInstance.setId(idInstance5);
                            }
                            
                            JsonNode nameValue8 = valueValue.get("name");
                            if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                String nameInstance8;
                                nameInstance8 = nameValue8.getTextValue();
                                virtualMachineJsonInstance.setName(nameInstance8);
                            }
                            
                            JsonNode typeValue6 = valueValue.get("type");
                            if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                String typeInstance6;
                                typeInstance6 = typeValue6.getTextValue();
                                virtualMachineJsonInstance.setType(typeInstance6);
                            }
                            
                            JsonNode locationValue2 = valueValue.get("location");
                            if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                String locationInstance2;
                                locationInstance2 = locationValue2.getTextValue();
                                virtualMachineJsonInstance.setLocation(locationInstance2);
                            }
                            
                            JsonNode tagsSequenceElement2 = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                    String tagsKey2 = property2.getKey();
                                    String tagsValue2 = property2.getValue().getTextValue();
                                    virtualMachineJsonInstance.getTags().put(tagsKey2, tagsValue2);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets the list of Virtual Machines in the subscription. Use nextLink
    * property in the response to get the next page of Virtual Machines. Do
    * this till nextLink is not null to fetch all the Virtual Machines.
    *
    * @param parameters Optional.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public Future<VirtualMachineListResponse> listAllAsync(final ListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineListResponse>() { 
            @Override
            public VirtualMachineListResponse call() throws Exception {
                return listAll(parameters);
            }
         });
    }
    
    /**
    * Gets the list of Virtual Machines in the subscription. Use nextLink
    * property in the response to get the next page of Virtual Machines. Do
    * this till nextLink is not null to fetch all the Virtual Machines.
    *
    * @param parameters Optional.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public VirtualMachineListResponse listAll(ListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        // Validate
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAllAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualMachine virtualMachineJsonInstance = new VirtualMachine();
                            result.getVirtualMachines().add(virtualMachineJsonInstance);
                            
                            JsonNode planValue = valueValue.get("plan");
                            if (planValue != null && planValue instanceof NullNode == false) {
                                Plan planInstance = new Plan();
                                virtualMachineJsonInstance.setPlan(planInstance);
                                
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                
                                JsonNode publisherValue = planValue.get("publisher");
                                if (publisherValue != null && publisherValue instanceof NullNode == false) {
                                    String publisherInstance;
                                    publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                
                                JsonNode productValue = planValue.get("product");
                                if (productValue != null && productValue instanceof NullNode == false) {
                                    String productInstance;
                                    productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                
                                JsonNode promotionCodeValue = planValue.get("promotionCode");
                                if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                                    String promotionCodeInstance;
                                    promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                                if (hardwareProfileValue != null && hardwareProfileValue instanceof NullNode == false) {
                                    HardwareProfile hardwareProfileInstance = new HardwareProfile();
                                    virtualMachineJsonInstance.setHardwareProfile(hardwareProfileInstance);
                                    
                                    JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                                    if (vmSizeValue != null && vmSizeValue instanceof NullNode == false) {
                                        String vmSizeInstance;
                                        vmSizeInstance = vmSizeValue.getTextValue();
                                        hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                                    }
                                }
                                
                                JsonNode storageProfileValue = propertiesValue.get("storageProfile");
                                if (storageProfileValue != null && storageProfileValue instanceof NullNode == false) {
                                    StorageProfile storageProfileInstance = new StorageProfile();
                                    virtualMachineJsonInstance.setStorageProfile(storageProfileInstance);
                                    
                                    JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                                    if (imageReferenceValue != null && imageReferenceValue instanceof NullNode == false) {
                                        ImageReference imageReferenceInstance = new ImageReference();
                                        storageProfileInstance.setImageReference(imageReferenceInstance);
                                        
                                        JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                        if (publisherValue2 != null && publisherValue2 instanceof NullNode == false) {
                                            String publisherInstance2;
                                            publisherInstance2 = publisherValue2.getTextValue();
                                            imageReferenceInstance.setPublisher(publisherInstance2);
                                        }
                                        
                                        JsonNode offerValue = imageReferenceValue.get("offer");
                                        if (offerValue != null && offerValue instanceof NullNode == false) {
                                            String offerInstance;
                                            offerInstance = offerValue.getTextValue();
                                            imageReferenceInstance.setOffer(offerInstance);
                                        }
                                        
                                        JsonNode skuValue = imageReferenceValue.get("sku");
                                        if (skuValue != null && skuValue instanceof NullNode == false) {
                                            String skuInstance;
                                            skuInstance = skuValue.getTextValue();
                                            imageReferenceInstance.setSku(skuInstance);
                                        }
                                        
                                        JsonNode versionValue = imageReferenceValue.get("version");
                                        if (versionValue != null && versionValue instanceof NullNode == false) {
                                            String versionInstance;
                                            versionInstance = versionValue.getTextValue();
                                            imageReferenceInstance.setVersion(versionInstance);
                                        }
                                    }
                                    
                                    JsonNode osDiskValue = storageProfileValue.get("osDisk");
                                    if (osDiskValue != null && osDiskValue instanceof NullNode == false) {
                                        OSDisk osDiskInstance = new OSDisk();
                                        storageProfileInstance.setOSDisk(osDiskInstance);
                                        
                                        JsonNode osTypeValue = osDiskValue.get("osType");
                                        if (osTypeValue != null && osTypeValue instanceof NullNode == false) {
                                            String osTypeInstance;
                                            osTypeInstance = osTypeValue.getTextValue();
                                            osDiskInstance.setOperatingSystemType(osTypeInstance);
                                        }
                                        
                                        JsonNode nameValue2 = osDiskValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            osDiskInstance.setName(nameInstance2);
                                        }
                                        
                                        JsonNode vhdValue = osDiskValue.get("vhd");
                                        if (vhdValue != null && vhdValue instanceof NullNode == false) {
                                            VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                            osDiskInstance.setVirtualHardDisk(vhdInstance);
                                            
                                            JsonNode uriValue = vhdValue.get("uri");
                                            if (uriValue != null && uriValue instanceof NullNode == false) {
                                                String uriInstance;
                                                uriInstance = uriValue.getTextValue();
                                                vhdInstance.setUri(uriInstance);
                                            }
                                        }
                                        
                                        JsonNode imageValue = osDiskValue.get("image");
                                        if (imageValue != null && imageValue instanceof NullNode == false) {
                                            VirtualHardDisk imageInstance = new VirtualHardDisk();
                                            osDiskInstance.setSourceImage(imageInstance);
                                            
                                            JsonNode uriValue2 = imageValue.get("uri");
                                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                                String uriInstance2;
                                                uriInstance2 = uriValue2.getTextValue();
                                                imageInstance.setUri(uriInstance2);
                                            }
                                        }
                                        
                                        JsonNode cachingValue = osDiskValue.get("caching");
                                        if (cachingValue != null && cachingValue instanceof NullNode == false) {
                                            String cachingInstance;
                                            cachingInstance = cachingValue.getTextValue();
                                            osDiskInstance.setCaching(cachingInstance);
                                        }
                                        
                                        JsonNode createOptionValue = osDiskValue.get("createOption");
                                        if (createOptionValue != null && createOptionValue instanceof NullNode == false) {
                                            String createOptionInstance;
                                            createOptionInstance = createOptionValue.getTextValue();
                                            osDiskInstance.setCreateOption(createOptionInstance);
                                        }
                                        
                                        JsonNode diskSizeGBValue = osDiskValue.get("diskSizeGB");
                                        if (diskSizeGBValue != null && diskSizeGBValue instanceof NullNode == false) {
                                            int diskSizeGBInstance;
                                            diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                            osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                        }
                                    }
                                    
                                    JsonNode dataDisksArray = storageProfileValue.get("dataDisks");
                                    if (dataDisksArray != null && dataDisksArray instanceof NullNode == false) {
                                        for (JsonNode dataDisksValue : ((ArrayNode) dataDisksArray)) {
                                            DataDisk dataDiskInstance = new DataDisk();
                                            storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                            
                                            JsonNode lunValue = dataDisksValue.get("lun");
                                            if (lunValue != null && lunValue instanceof NullNode == false) {
                                                int lunInstance;
                                                lunInstance = lunValue.getIntValue();
                                                dataDiskInstance.setLun(lunInstance);
                                            }
                                            
                                            JsonNode nameValue3 = dataDisksValue.get("name");
                                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                                String nameInstance3;
                                                nameInstance3 = nameValue3.getTextValue();
                                                dataDiskInstance.setName(nameInstance3);
                                            }
                                            
                                            JsonNode vhdValue2 = dataDisksValue.get("vhd");
                                            if (vhdValue2 != null && vhdValue2 instanceof NullNode == false) {
                                                VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                                
                                                JsonNode uriValue3 = vhdValue2.get("uri");
                                                if (uriValue3 != null && uriValue3 instanceof NullNode == false) {
                                                    String uriInstance3;
                                                    uriInstance3 = uriValue3.getTextValue();
                                                    vhdInstance2.setUri(uriInstance3);
                                                }
                                            }
                                            
                                            JsonNode imageValue2 = dataDisksValue.get("image");
                                            if (imageValue2 != null && imageValue2 instanceof NullNode == false) {
                                                VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setSourceImage(imageInstance2);
                                                
                                                JsonNode uriValue4 = imageValue2.get("uri");
                                                if (uriValue4 != null && uriValue4 instanceof NullNode == false) {
                                                    String uriInstance4;
                                                    uriInstance4 = uriValue4.getTextValue();
                                                    imageInstance2.setUri(uriInstance4);
                                                }
                                            }
                                            
                                            JsonNode cachingValue2 = dataDisksValue.get("caching");
                                            if (cachingValue2 != null && cachingValue2 instanceof NullNode == false) {
                                                String cachingInstance2;
                                                cachingInstance2 = cachingValue2.getTextValue();
                                                dataDiskInstance.setCaching(cachingInstance2);
                                            }
                                            
                                            JsonNode createOptionValue2 = dataDisksValue.get("createOption");
                                            if (createOptionValue2 != null && createOptionValue2 instanceof NullNode == false) {
                                                String createOptionInstance2;
                                                createOptionInstance2 = createOptionValue2.getTextValue();
                                                dataDiskInstance.setCreateOption(createOptionInstance2);
                                            }
                                            
                                            JsonNode diskSizeGBValue2 = dataDisksValue.get("diskSizeGB");
                                            if (diskSizeGBValue2 != null && diskSizeGBValue2 instanceof NullNode == false) {
                                                int diskSizeGBInstance2;
                                                diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                                dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode osProfileValue = propertiesValue.get("osProfile");
                                if (osProfileValue != null && osProfileValue instanceof NullNode == false) {
                                    OSProfile osProfileInstance = new OSProfile();
                                    virtualMachineJsonInstance.setOSProfile(osProfileInstance);
                                    
                                    JsonNode computerNameValue = osProfileValue.get("computerName");
                                    if (computerNameValue != null && computerNameValue instanceof NullNode == false) {
                                        String computerNameInstance;
                                        computerNameInstance = computerNameValue.getTextValue();
                                        osProfileInstance.setComputerName(computerNameInstance);
                                    }
                                    
                                    JsonNode adminUsernameValue = osProfileValue.get("adminUsername");
                                    if (adminUsernameValue != null && adminUsernameValue instanceof NullNode == false) {
                                        String adminUsernameInstance;
                                        adminUsernameInstance = adminUsernameValue.getTextValue();
                                        osProfileInstance.setAdminUsername(adminUsernameInstance);
                                    }
                                    
                                    JsonNode adminPasswordValue = osProfileValue.get("adminPassword");
                                    if (adminPasswordValue != null && adminPasswordValue instanceof NullNode == false) {
                                        String adminPasswordInstance;
                                        adminPasswordInstance = adminPasswordValue.getTextValue();
                                        osProfileInstance.setAdminPassword(adminPasswordInstance);
                                    }
                                    
                                    JsonNode customDataValue = osProfileValue.get("customData");
                                    if (customDataValue != null && customDataValue instanceof NullNode == false) {
                                        String customDataInstance;
                                        customDataInstance = customDataValue.getTextValue();
                                        osProfileInstance.setCustomData(customDataInstance);
                                    }
                                    
                                    JsonNode windowsConfigurationValue = osProfileValue.get("windowsConfiguration");
                                    if (windowsConfigurationValue != null && windowsConfigurationValue instanceof NullNode == false) {
                                        WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                        osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                        
                                        JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                        if (provisionVMAgentValue != null && provisionVMAgentValue instanceof NullNode == false) {
                                            boolean provisionVMAgentInstance;
                                            provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                            windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                        }
                                        
                                        JsonNode enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates");
                                        if (enableAutomaticUpdatesValue != null && enableAutomaticUpdatesValue instanceof NullNode == false) {
                                            boolean enableAutomaticUpdatesInstance;
                                            enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                            windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                        }
                                        
                                        JsonNode timeZoneValue = windowsConfigurationValue.get("timeZone");
                                        if (timeZoneValue != null && timeZoneValue instanceof NullNode == false) {
                                            String timeZoneInstance;
                                            timeZoneInstance = timeZoneValue.getTextValue();
                                            windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                        }
                                        
                                        JsonNode additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent");
                                        if (additionalUnattendContentArray != null && additionalUnattendContentArray instanceof NullNode == false) {
                                            for (JsonNode additionalUnattendContentValue : ((ArrayNode) additionalUnattendContentArray)) {
                                                AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                                windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                                
                                                JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                                if (passNameValue != null && passNameValue instanceof NullNode == false) {
                                                    String passNameInstance;
                                                    passNameInstance = passNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setPassName(passNameInstance);
                                                }
                                                
                                                JsonNode componentNameValue = additionalUnattendContentValue.get("componentName");
                                                if (componentNameValue != null && componentNameValue instanceof NullNode == false) {
                                                    String componentNameInstance;
                                                    componentNameInstance = componentNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                                }
                                                
                                                JsonNode settingNameValue = additionalUnattendContentValue.get("settingName");
                                                if (settingNameValue != null && settingNameValue instanceof NullNode == false) {
                                                    String settingNameInstance;
                                                    settingNameInstance = settingNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                                }
                                                
                                                JsonNode contentValue = additionalUnattendContentValue.get("content");
                                                if (contentValue != null && contentValue instanceof NullNode == false) {
                                                    String contentInstance;
                                                    contentInstance = contentValue.getTextValue();
                                                    additionalUnattendContentInstance.setContent(contentInstance);
                                                }
                                            }
                                        }
                                        
                                        JsonNode winRMValue = windowsConfigurationValue.get("winRM");
                                        if (winRMValue != null && winRMValue instanceof NullNode == false) {
                                            WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                            windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                            
                                            JsonNode listenersArray = winRMValue.get("listeners");
                                            if (listenersArray != null && listenersArray instanceof NullNode == false) {
                                                for (JsonNode listenersValue : ((ArrayNode) listenersArray)) {
                                                    WinRMListener winRMListenerInstance = new WinRMListener();
                                                    winRMInstance.getListeners().add(winRMListenerInstance);
                                                    
                                                    JsonNode protocolValue = listenersValue.get("protocol");
                                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                        String protocolInstance;
                                                        protocolInstance = protocolValue.getTextValue();
                                                        winRMListenerInstance.setProtocol(protocolInstance);
                                                    }
                                                    
                                                    JsonNode certificateUrlValue = listenersValue.get("certificateUrl");
                                                    if (certificateUrlValue != null && certificateUrlValue instanceof NullNode == false) {
                                                        URI certificateUrlInstance;
                                                        certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                        winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode linuxConfigurationValue = osProfileValue.get("linuxConfiguration");
                                    if (linuxConfigurationValue != null && linuxConfigurationValue instanceof NullNode == false) {
                                        LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                        osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                        
                                        JsonNode disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                        if (disablePasswordAuthenticationValue != null && disablePasswordAuthenticationValue instanceof NullNode == false) {
                                            boolean disablePasswordAuthenticationInstance;
                                            disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                            linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                        }
                                        
                                        JsonNode sshValue = linuxConfigurationValue.get("ssh");
                                        if (sshValue != null && sshValue instanceof NullNode == false) {
                                            SshConfiguration sshInstance = new SshConfiguration();
                                            linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                            
                                            JsonNode publicKeysArray = sshValue.get("publicKeys");
                                            if (publicKeysArray != null && publicKeysArray instanceof NullNode == false) {
                                                for (JsonNode publicKeysValue : ((ArrayNode) publicKeysArray)) {
                                                    SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                                    sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                                    
                                                    JsonNode pathValue = publicKeysValue.get("path");
                                                    if (pathValue != null && pathValue instanceof NullNode == false) {
                                                        String pathInstance;
                                                        pathInstance = pathValue.getTextValue();
                                                        sshPublicKeyInstance.setPath(pathInstance);
                                                    }
                                                    
                                                    JsonNode keyDataValue = publicKeysValue.get("keyData");
                                                    if (keyDataValue != null && keyDataValue instanceof NullNode == false) {
                                                        String keyDataInstance;
                                                        keyDataInstance = keyDataValue.getTextValue();
                                                        sshPublicKeyInstance.setKeyData(keyDataInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode secretsArray = osProfileValue.get("secrets");
                                    if (secretsArray != null && secretsArray instanceof NullNode == false) {
                                        for (JsonNode secretsValue : ((ArrayNode) secretsArray)) {
                                            VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                            osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                            
                                            JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                            if (sourceVaultValue != null && sourceVaultValue instanceof NullNode == false) {
                                                SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                                vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                                
                                                JsonNode idValue = sourceVaultValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    sourceVaultInstance.setReferenceUri(idInstance);
                                                }
                                            }
                                            
                                            JsonNode vaultCertificatesArray = secretsValue.get("vaultCertificates");
                                            if (vaultCertificatesArray != null && vaultCertificatesArray instanceof NullNode == false) {
                                                for (JsonNode vaultCertificatesValue : ((ArrayNode) vaultCertificatesArray)) {
                                                    VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                                    vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                                    
                                                    JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                                    if (certificateUrlValue2 != null && certificateUrlValue2 instanceof NullNode == false) {
                                                        String certificateUrlInstance2;
                                                        certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                        vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                                    }
                                                    
                                                    JsonNode certificateStoreValue = vaultCertificatesValue.get("certificateStore");
                                                    if (certificateStoreValue != null && certificateStoreValue instanceof NullNode == false) {
                                                        String certificateStoreInstance;
                                                        certificateStoreInstance = certificateStoreValue.getTextValue();
                                                        vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode networkProfileValue = propertiesValue.get("networkProfile");
                                if (networkProfileValue != null && networkProfileValue instanceof NullNode == false) {
                                    NetworkProfile networkProfileInstance = new NetworkProfile();
                                    virtualMachineJsonInstance.setNetworkProfile(networkProfileInstance);
                                    
                                    JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                                    if (networkInterfacesArray != null && networkInterfacesArray instanceof NullNode == false) {
                                        for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray)) {
                                            NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                            networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                            
                                            JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                                JsonNode primaryValue = propertiesValue2.get("primary");
                                                if (primaryValue != null && primaryValue instanceof NullNode == false) {
                                                    boolean primaryInstance;
                                                    primaryInstance = primaryValue.getBooleanValue();
                                                    networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                                }
                                            }
                                            
                                            JsonNode idValue2 = networkInterfacesValue.get("id");
                                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                String idInstance2;
                                                idInstance2 = idValue2.getTextValue();
                                                networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile");
                                if (diagnosticsProfileValue != null && diagnosticsProfileValue instanceof NullNode == false) {
                                    DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                                    virtualMachineJsonInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                                    
                                    JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue != null && bootDiagnosticsValue instanceof NullNode == false) {
                                        BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                        diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                        
                                        JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                            boolean enabledInstance;
                                            enabledInstance = enabledValue.getBooleanValue();
                                            bootDiagnosticsInstance.setEnabled(enabledInstance);
                                        }
                                        
                                        JsonNode storageUriValue = bootDiagnosticsValue.get("storageUri");
                                        if (storageUriValue != null && storageUriValue instanceof NullNode == false) {
                                            URI storageUriInstance;
                                            storageUriInstance = new URI(storageUriValue.getTextValue());
                                            bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                        }
                                    }
                                }
                                
                                JsonNode availabilitySetValue = propertiesValue.get("availabilitySet");
                                if (availabilitySetValue != null && availabilitySetValue instanceof NullNode == false) {
                                    AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                                    virtualMachineJsonInstance.setAvailabilitySetReference(availabilitySetInstance);
                                    
                                    JsonNode idValue3 = availabilitySetValue.get("id");
                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                        String idInstance3;
                                        idInstance3 = idValue3.getTextValue();
                                        availabilitySetInstance.setReferenceUri(idInstance3);
                                    }
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    virtualMachineJsonInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode instanceViewValue = propertiesValue.get("instanceView");
                                if (instanceViewValue != null && instanceViewValue instanceof NullNode == false) {
                                    VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                                    virtualMachineJsonInstance.setInstanceView(instanceViewInstance);
                                    
                                    JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                                    if (platformUpdateDomainValue != null && platformUpdateDomainValue instanceof NullNode == false) {
                                        int platformUpdateDomainInstance;
                                        platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                                    }
                                    
                                    JsonNode platformFaultDomainValue = instanceViewValue.get("platformFaultDomain");
                                    if (platformFaultDomainValue != null && platformFaultDomainValue instanceof NullNode == false) {
                                        int platformFaultDomainInstance;
                                        platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                                    }
                                    
                                    JsonNode rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint");
                                    if (rdpThumbPrintValue != null && rdpThumbPrintValue instanceof NullNode == false) {
                                        String rdpThumbPrintInstance;
                                        rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                        instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                                    }
                                    
                                    JsonNode vmAgentValue = instanceViewValue.get("vmAgent");
                                    if (vmAgentValue != null && vmAgentValue instanceof NullNode == false) {
                                        VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                        instanceViewInstance.setVMAgent(vmAgentInstance);
                                        
                                        JsonNode vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                        if (vmAgentVersionValue != null && vmAgentVersionValue instanceof NullNode == false) {
                                            String vmAgentVersionInstance;
                                            vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                            vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                        }
                                        
                                        JsonNode extensionHandlersArray = vmAgentValue.get("extensionHandlers");
                                        if (extensionHandlersArray != null && extensionHandlersArray instanceof NullNode == false) {
                                            for (JsonNode extensionHandlersValue : ((ArrayNode) extensionHandlersArray)) {
                                                VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                                vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                                
                                                JsonNode typeValue = extensionHandlersValue.get("type");
                                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                                    String typeInstance;
                                                    typeInstance = typeValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                                }
                                                
                                                JsonNode typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion");
                                                if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                                                    String typeHandlerVersionInstance;
                                                    typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                                }
                                                
                                                JsonNode statusValue = extensionHandlersValue.get("status");
                                                if (statusValue != null && statusValue instanceof NullNode == false) {
                                                    InstanceViewStatus statusInstance = new InstanceViewStatus();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                                    
                                                    JsonNode codeValue = statusValue.get("code");
                                                    if (codeValue != null && codeValue instanceof NullNode == false) {
                                                        String codeInstance;
                                                        codeInstance = codeValue.getTextValue();
                                                        statusInstance.setCode(codeInstance);
                                                    }
                                                    
                                                    JsonNode levelValue = statusValue.get("level");
                                                    if (levelValue != null && levelValue instanceof NullNode == false) {
                                                        String levelInstance;
                                                        levelInstance = levelValue.getTextValue();
                                                        statusInstance.setLevel(levelInstance);
                                                    }
                                                    
                                                    JsonNode displayStatusValue = statusValue.get("displayStatus");
                                                    if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                                        String displayStatusInstance;
                                                        displayStatusInstance = displayStatusValue.getTextValue();
                                                        statusInstance.setDisplayStatus(displayStatusInstance);
                                                    }
                                                    
                                                    JsonNode messageValue = statusValue.get("message");
                                                    if (messageValue != null && messageValue instanceof NullNode == false) {
                                                        String messageInstance;
                                                        messageInstance = messageValue.getTextValue();
                                                        statusInstance.setMessage(messageInstance);
                                                    }
                                                    
                                                    JsonNode timeValue = statusValue.get("time");
                                                    if (timeValue != null && timeValue instanceof NullNode == false) {
                                                        Calendar timeInstance;
                                                        timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                                        statusInstance.setTime(timeInstance);
                                                    }
                                                }
                                            }
                                        }
                                        
                                        JsonNode statusesArray = vmAgentValue.get("statuses");
                                        if (statusesArray != null && statusesArray instanceof NullNode == false) {
                                            for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                                vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                                
                                                JsonNode codeValue2 = statusesValue.get("code");
                                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                                    String codeInstance2;
                                                    codeInstance2 = codeValue2.getTextValue();
                                                    instanceViewStatusInstance.setCode(codeInstance2);
                                                }
                                                
                                                JsonNode levelValue2 = statusesValue.get("level");
                                                if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                                    String levelInstance2;
                                                    levelInstance2 = levelValue2.getTextValue();
                                                    instanceViewStatusInstance.setLevel(levelInstance2);
                                                }
                                                
                                                JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                                if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                                    String displayStatusInstance2;
                                                    displayStatusInstance2 = displayStatusValue2.getTextValue();
                                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                                }
                                                
                                                JsonNode messageValue2 = statusesValue.get("message");
                                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                                    String messageInstance2;
                                                    messageInstance2 = messageValue2.getTextValue();
                                                    instanceViewStatusInstance.setMessage(messageInstance2);
                                                }
                                                
                                                JsonNode timeValue2 = statusesValue.get("time");
                                                if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                                    Calendar timeInstance2;
                                                    timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                                    instanceViewStatusInstance.setTime(timeInstance2);
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode disksArray = instanceViewValue.get("disks");
                                    if (disksArray != null && disksArray instanceof NullNode == false) {
                                        for (JsonNode disksValue : ((ArrayNode) disksArray)) {
                                            DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                            instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                            
                                            JsonNode nameValue4 = disksValue.get("name");
                                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                String nameInstance4;
                                                nameInstance4 = nameValue4.getTextValue();
                                                diskInstanceViewInstance.setName(nameInstance4);
                                            }
                                            
                                            JsonNode statusesArray2 = disksValue.get("statuses");
                                            if (statusesArray2 != null && statusesArray2 instanceof NullNode == false) {
                                                for (JsonNode statusesValue2 : ((ArrayNode) statusesArray2)) {
                                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                                    diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                                    
                                                    JsonNode codeValue3 = statusesValue2.get("code");
                                                    if (codeValue3 != null && codeValue3 instanceof NullNode == false) {
                                                        String codeInstance3;
                                                        codeInstance3 = codeValue3.getTextValue();
                                                        instanceViewStatusInstance2.setCode(codeInstance3);
                                                    }
                                                    
                                                    JsonNode levelValue3 = statusesValue2.get("level");
                                                    if (levelValue3 != null && levelValue3 instanceof NullNode == false) {
                                                        String levelInstance3;
                                                        levelInstance3 = levelValue3.getTextValue();
                                                        instanceViewStatusInstance2.setLevel(levelInstance3);
                                                    }
                                                    
                                                    JsonNode displayStatusValue3 = statusesValue2.get("displayStatus");
                                                    if (displayStatusValue3 != null && displayStatusValue3 instanceof NullNode == false) {
                                                        String displayStatusInstance3;
                                                        displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                                    }
                                                    
                                                    JsonNode messageValue3 = statusesValue2.get("message");
                                                    if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                                        String messageInstance3;
                                                        messageInstance3 = messageValue3.getTextValue();
                                                        instanceViewStatusInstance2.setMessage(messageInstance3);
                                                    }
                                                    
                                                    JsonNode timeValue3 = statusesValue2.get("time");
                                                    if (timeValue3 != null && timeValue3 instanceof NullNode == false) {
                                                        Calendar timeInstance3;
                                                        timeInstance3 = DatatypeConverter.parseDateTime(timeValue3.getTextValue());
                                                        instanceViewStatusInstance2.setTime(timeInstance3);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode extensionsArray = instanceViewValue.get("extensions");
                                    if (extensionsArray != null && extensionsArray instanceof NullNode == false) {
                                        for (JsonNode extensionsValue : ((ArrayNode) extensionsArray)) {
                                            VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                            instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                            
                                            JsonNode nameValue5 = extensionsValue.get("name");
                                            if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                                String nameInstance5;
                                                nameInstance5 = nameValue5.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                            }
                                            
                                            JsonNode typeValue2 = extensionsValue.get("type");
                                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                                String typeInstance2;
                                                typeInstance2 = typeValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                            }
                                            
                                            JsonNode typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion");
                                            if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                                String typeHandlerVersionInstance2;
                                                typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                            }
                                            
                                            JsonNode substatusesArray = extensionsValue.get("substatuses");
                                            if (substatusesArray != null && substatusesArray instanceof NullNode == false) {
                                                for (JsonNode substatusesValue : ((ArrayNode) substatusesArray)) {
                                                    InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                                    
                                                    JsonNode codeValue4 = substatusesValue.get("code");
                                                    if (codeValue4 != null && codeValue4 instanceof NullNode == false) {
                                                        String codeInstance4;
                                                        codeInstance4 = codeValue4.getTextValue();
                                                        instanceViewStatusInstance3.setCode(codeInstance4);
                                                    }
                                                    
                                                    JsonNode levelValue4 = substatusesValue.get("level");
                                                    if (levelValue4 != null && levelValue4 instanceof NullNode == false) {
                                                        String levelInstance4;
                                                        levelInstance4 = levelValue4.getTextValue();
                                                        instanceViewStatusInstance3.setLevel(levelInstance4);
                                                    }
                                                    
                                                    JsonNode displayStatusValue4 = substatusesValue.get("displayStatus");
                                                    if (displayStatusValue4 != null && displayStatusValue4 instanceof NullNode == false) {
                                                        String displayStatusInstance4;
                                                        displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                        instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                                    }
                                                    
                                                    JsonNode messageValue4 = substatusesValue.get("message");
                                                    if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                                        String messageInstance4;
                                                        messageInstance4 = messageValue4.getTextValue();
                                                        instanceViewStatusInstance3.setMessage(messageInstance4);
                                                    }
                                                    
                                                    JsonNode timeValue4 = substatusesValue.get("time");
                                                    if (timeValue4 != null && timeValue4 instanceof NullNode == false) {
                                                        Calendar timeInstance4;
                                                        timeInstance4 = DatatypeConverter.parseDateTime(timeValue4.getTextValue());
                                                        instanceViewStatusInstance3.setTime(timeInstance4);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode statusesArray3 = extensionsValue.get("statuses");
                                            if (statusesArray3 != null && statusesArray3 instanceof NullNode == false) {
                                                for (JsonNode statusesValue3 : ((ArrayNode) statusesArray3)) {
                                                    InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                                    
                                                    JsonNode codeValue5 = statusesValue3.get("code");
                                                    if (codeValue5 != null && codeValue5 instanceof NullNode == false) {
                                                        String codeInstance5;
                                                        codeInstance5 = codeValue5.getTextValue();
                                                        instanceViewStatusInstance4.setCode(codeInstance5);
                                                    }
                                                    
                                                    JsonNode levelValue5 = statusesValue3.get("level");
                                                    if (levelValue5 != null && levelValue5 instanceof NullNode == false) {
                                                        String levelInstance5;
                                                        levelInstance5 = levelValue5.getTextValue();
                                                        instanceViewStatusInstance4.setLevel(levelInstance5);
                                                    }
                                                    
                                                    JsonNode displayStatusValue5 = statusesValue3.get("displayStatus");
                                                    if (displayStatusValue5 != null && displayStatusValue5 instanceof NullNode == false) {
                                                        String displayStatusInstance5;
                                                        displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                        instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                                    }
                                                    
                                                    JsonNode messageValue5 = statusesValue3.get("message");
                                                    if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                                        String messageInstance5;
                                                        messageInstance5 = messageValue5.getTextValue();
                                                        instanceViewStatusInstance4.setMessage(messageInstance5);
                                                    }
                                                    
                                                    JsonNode timeValue5 = statusesValue3.get("time");
                                                    if (timeValue5 != null && timeValue5 instanceof NullNode == false) {
                                                        Calendar timeInstance5;
                                                        timeInstance5 = DatatypeConverter.parseDateTime(timeValue5.getTextValue());
                                                        instanceViewStatusInstance4.setTime(timeInstance5);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue2 != null && bootDiagnosticsValue2 instanceof NullNode == false) {
                                        BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                        instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                        
                                        JsonNode consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                        if (consoleScreenshotBlobUriValue != null && consoleScreenshotBlobUriValue instanceof NullNode == false) {
                                            URI consoleScreenshotBlobUriInstance;
                                            consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                        }
                                        
                                        JsonNode serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri");
                                        if (serialConsoleLogBlobUriValue != null && serialConsoleLogBlobUriValue instanceof NullNode == false) {
                                            URI serialConsoleLogBlobUriInstance;
                                            serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                        }
                                    }
                                    
                                    JsonNode statusesArray4 = instanceViewValue.get("statuses");
                                    if (statusesArray4 != null && statusesArray4 instanceof NullNode == false) {
                                        for (JsonNode statusesValue4 : ((ArrayNode) statusesArray4)) {
                                            InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                            instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                            
                                            JsonNode codeValue6 = statusesValue4.get("code");
                                            if (codeValue6 != null && codeValue6 instanceof NullNode == false) {
                                                String codeInstance6;
                                                codeInstance6 = codeValue6.getTextValue();
                                                instanceViewStatusInstance5.setCode(codeInstance6);
                                            }
                                            
                                            JsonNode levelValue6 = statusesValue4.get("level");
                                            if (levelValue6 != null && levelValue6 instanceof NullNode == false) {
                                                String levelInstance6;
                                                levelInstance6 = levelValue6.getTextValue();
                                                instanceViewStatusInstance5.setLevel(levelInstance6);
                                            }
                                            
                                            JsonNode displayStatusValue6 = statusesValue4.get("displayStatus");
                                            if (displayStatusValue6 != null && displayStatusValue6 instanceof NullNode == false) {
                                                String displayStatusInstance6;
                                                displayStatusInstance6 = displayStatusValue6.getTextValue();
                                                instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                            }
                                            
                                            JsonNode messageValue6 = statusesValue4.get("message");
                                            if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                                String messageInstance6;
                                                messageInstance6 = messageValue6.getTextValue();
                                                instanceViewStatusInstance5.setMessage(messageInstance6);
                                            }
                                            
                                            JsonNode timeValue6 = statusesValue4.get("time");
                                            if (timeValue6 != null && timeValue6 instanceof NullNode == false) {
                                                Calendar timeInstance6;
                                                timeInstance6 = DatatypeConverter.parseDateTime(timeValue6.getTextValue());
                                                instanceViewStatusInstance5.setTime(timeInstance6);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode resourcesArray = valueValue.get("resources");
                            if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                                virtualMachineJsonInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                                for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                                    VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                                    virtualMachineJsonInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                                    
                                    JsonNode propertiesValue3 = resourcesValue.get("properties");
                                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                        JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                        if (publisherValue3 != null && publisherValue3 instanceof NullNode == false) {
                                            String publisherInstance3;
                                            publisherInstance3 = publisherValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                        }
                                        
                                        JsonNode typeValue3 = propertiesValue3.get("type");
                                        if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                            String typeInstance3;
                                            typeInstance3 = typeValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                        }
                                        
                                        JsonNode typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion");
                                        if (typeHandlerVersionValue3 != null && typeHandlerVersionValue3 instanceof NullNode == false) {
                                            String typeHandlerVersionInstance3;
                                            typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                        }
                                        
                                        JsonNode autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion");
                                        if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                                            boolean autoUpgradeMinorVersionInstance;
                                            autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                            virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                        }
                                        
                                        JsonNode settingsValue = propertiesValue3.get("settings");
                                        if (settingsValue != null && settingsValue instanceof NullNode == false) {
                                            String settingsInstance;
                                            settingsInstance = settingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                        }
                                        
                                        JsonNode protectedSettingsValue = propertiesValue3.get("protectedSettings");
                                        if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                                            String protectedSettingsInstance;
                                            protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                        }
                                        
                                        JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                            String provisioningStateInstance2;
                                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                        }
                                        
                                        JsonNode instanceViewValue2 = propertiesValue3.get("instanceView");
                                        if (instanceViewValue2 != null && instanceViewValue2 instanceof NullNode == false) {
                                            VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                            virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                            
                                            JsonNode nameValue6 = instanceViewValue2.get("name");
                                            if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                                String nameInstance6;
                                                nameInstance6 = nameValue6.getTextValue();
                                                instanceViewInstance2.setName(nameInstance6);
                                            }
                                            
                                            JsonNode typeValue4 = instanceViewValue2.get("type");
                                            if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                String typeInstance4;
                                                typeInstance4 = typeValue4.getTextValue();
                                                instanceViewInstance2.setExtensionType(typeInstance4);
                                            }
                                            
                                            JsonNode typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion");
                                            if (typeHandlerVersionValue4 != null && typeHandlerVersionValue4 instanceof NullNode == false) {
                                                String typeHandlerVersionInstance4;
                                                typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                                instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                            }
                                            
                                            JsonNode substatusesArray2 = instanceViewValue2.get("substatuses");
                                            if (substatusesArray2 != null && substatusesArray2 instanceof NullNode == false) {
                                                for (JsonNode substatusesValue2 : ((ArrayNode) substatusesArray2)) {
                                                    InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                                    instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                                    
                                                    JsonNode codeValue7 = substatusesValue2.get("code");
                                                    if (codeValue7 != null && codeValue7 instanceof NullNode == false) {
                                                        String codeInstance7;
                                                        codeInstance7 = codeValue7.getTextValue();
                                                        instanceViewStatusInstance6.setCode(codeInstance7);
                                                    }
                                                    
                                                    JsonNode levelValue7 = substatusesValue2.get("level");
                                                    if (levelValue7 != null && levelValue7 instanceof NullNode == false) {
                                                        String levelInstance7;
                                                        levelInstance7 = levelValue7.getTextValue();
                                                        instanceViewStatusInstance6.setLevel(levelInstance7);
                                                    }
                                                    
                                                    JsonNode displayStatusValue7 = substatusesValue2.get("displayStatus");
                                                    if (displayStatusValue7 != null && displayStatusValue7 instanceof NullNode == false) {
                                                        String displayStatusInstance7;
                                                        displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                        instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                                    }
                                                    
                                                    JsonNode messageValue7 = substatusesValue2.get("message");
                                                    if (messageValue7 != null && messageValue7 instanceof NullNode == false) {
                                                        String messageInstance7;
                                                        messageInstance7 = messageValue7.getTextValue();
                                                        instanceViewStatusInstance6.setMessage(messageInstance7);
                                                    }
                                                    
                                                    JsonNode timeValue7 = substatusesValue2.get("time");
                                                    if (timeValue7 != null && timeValue7 instanceof NullNode == false) {
                                                        Calendar timeInstance7;
                                                        timeInstance7 = DatatypeConverter.parseDateTime(timeValue7.getTextValue());
                                                        instanceViewStatusInstance6.setTime(timeInstance7);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode statusesArray5 = instanceViewValue2.get("statuses");
                                            if (statusesArray5 != null && statusesArray5 instanceof NullNode == false) {
                                                for (JsonNode statusesValue5 : ((ArrayNode) statusesArray5)) {
                                                    InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                                    instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                                    
                                                    JsonNode codeValue8 = statusesValue5.get("code");
                                                    if (codeValue8 != null && codeValue8 instanceof NullNode == false) {
                                                        String codeInstance8;
                                                        codeInstance8 = codeValue8.getTextValue();
                                                        instanceViewStatusInstance7.setCode(codeInstance8);
                                                    }
                                                    
                                                    JsonNode levelValue8 = statusesValue5.get("level");
                                                    if (levelValue8 != null && levelValue8 instanceof NullNode == false) {
                                                        String levelInstance8;
                                                        levelInstance8 = levelValue8.getTextValue();
                                                        instanceViewStatusInstance7.setLevel(levelInstance8);
                                                    }
                                                    
                                                    JsonNode displayStatusValue8 = statusesValue5.get("displayStatus");
                                                    if (displayStatusValue8 != null && displayStatusValue8 instanceof NullNode == false) {
                                                        String displayStatusInstance8;
                                                        displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                        instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                                    }
                                                    
                                                    JsonNode messageValue8 = statusesValue5.get("message");
                                                    if (messageValue8 != null && messageValue8 instanceof NullNode == false) {
                                                        String messageInstance8;
                                                        messageInstance8 = messageValue8.getTextValue();
                                                        instanceViewStatusInstance7.setMessage(messageInstance8);
                                                    }
                                                    
                                                    JsonNode timeValue8 = statusesValue5.get("time");
                                                    if (timeValue8 != null && timeValue8 instanceof NullNode == false) {
                                                        Calendar timeInstance8;
                                                        timeInstance8 = DatatypeConverter.parseDateTime(timeValue8.getTextValue());
                                                        instanceViewStatusInstance7.setTime(timeInstance8);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode idValue4 = resourcesValue.get("id");
                                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                        String idInstance4;
                                        idInstance4 = idValue4.getTextValue();
                                        virtualMachineExtensionJsonInstance.setId(idInstance4);
                                    }
                                    
                                    JsonNode nameValue7 = resourcesValue.get("name");
                                    if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                        String nameInstance7;
                                        nameInstance7 = nameValue7.getTextValue();
                                        virtualMachineExtensionJsonInstance.setName(nameInstance7);
                                    }
                                    
                                    JsonNode typeValue5 = resourcesValue.get("type");
                                    if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                        String typeInstance5;
                                        typeInstance5 = typeValue5.getTextValue();
                                        virtualMachineExtensionJsonInstance.setType(typeInstance5);
                                    }
                                    
                                    JsonNode locationValue = resourcesValue.get("location");
                                    if (locationValue != null && locationValue instanceof NullNode == false) {
                                        String locationInstance;
                                        locationInstance = locationValue.getTextValue();
                                        virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                                    }
                                    
                                    JsonNode tagsSequenceElement = ((JsonNode) resourcesValue.get("tags"));
                                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry<String, JsonNode> property = itr.next();
                                            String tagsKey = property.getKey();
                                            String tagsValue = property.getValue().getTextValue();
                                            virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue5 = valueValue.get("id");
                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                String idInstance5;
                                idInstance5 = idValue5.getTextValue();
                                virtualMachineJsonInstance.setId(idInstance5);
                            }
                            
                            JsonNode nameValue8 = valueValue.get("name");
                            if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                String nameInstance8;
                                nameInstance8 = nameValue8.getTextValue();
                                virtualMachineJsonInstance.setName(nameInstance8);
                            }
                            
                            JsonNode typeValue6 = valueValue.get("type");
                            if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                String typeInstance6;
                                typeInstance6 = typeValue6.getTextValue();
                                virtualMachineJsonInstance.setType(typeInstance6);
                            }
                            
                            JsonNode locationValue2 = valueValue.get("location");
                            if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                String locationInstance2;
                                locationInstance2 = locationValue2.getTextValue();
                                virtualMachineJsonInstance.setLocation(locationInstance2);
                            }
                            
                            JsonNode tagsSequenceElement2 = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                    String tagsKey2 = property2.getKey();
                                    String tagsValue2 = property2.getValue().getTextValue();
                                    virtualMachineJsonInstance.getTags().put(tagsKey2, tagsValue2);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists virtual-machine-sizes available to be used for a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public Future<VirtualMachineSizeListResponse> listAvailableSizesAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineSizeListResponse>() { 
            @Override
            public VirtualMachineSizeListResponse call() throws Exception {
                return listAvailableSizes(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * Lists virtual-machine-sizes available to be used for a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public VirtualMachineSizeListResponse listAvailableSizes(String resourceGroupName, String vmName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "listAvailableSizesAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/vmSizes";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineSizeListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineSizeListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualMachineSize virtualMachineSizeInstance = new VirtualMachineSize();
                            result.getVirtualMachineSizes().add(virtualMachineSizeInstance);
                            
                            JsonNode nameValue = valueValue.get("name");
                            if (nameValue != null && nameValue instanceof NullNode == false) {
                                String nameInstance;
                                nameInstance = nameValue.getTextValue();
                                virtualMachineSizeInstance.setName(nameInstance);
                            }
                            
                            JsonNode numberOfCoresValue = valueValue.get("numberOfCores");
                            if (numberOfCoresValue != null && numberOfCoresValue instanceof NullNode == false) {
                                int numberOfCoresInstance;
                                numberOfCoresInstance = numberOfCoresValue.getIntValue();
                                virtualMachineSizeInstance.setNumberOfCores(numberOfCoresInstance);
                            }
                            
                            JsonNode osDiskSizeInMBValue = valueValue.get("osDiskSizeInMB");
                            if (osDiskSizeInMBValue != null && osDiskSizeInMBValue instanceof NullNode == false) {
                                int osDiskSizeInMBInstance;
                                osDiskSizeInMBInstance = osDiskSizeInMBValue.getIntValue();
                                virtualMachineSizeInstance.setOSDiskSizeInMB(osDiskSizeInMBInstance);
                            }
                            
                            JsonNode resourceDiskSizeInMBValue = valueValue.get("resourceDiskSizeInMB");
                            if (resourceDiskSizeInMBValue != null && resourceDiskSizeInMBValue instanceof NullNode == false) {
                                int resourceDiskSizeInMBInstance;
                                resourceDiskSizeInMBInstance = resourceDiskSizeInMBValue.getIntValue();
                                virtualMachineSizeInstance.setResourceDiskSizeInMB(resourceDiskSizeInMBInstance);
                            }
                            
                            JsonNode memoryInMBValue = valueValue.get("memoryInMB");
                            if (memoryInMBValue != null && memoryInMBValue instanceof NullNode == false) {
                                int memoryInMBInstance;
                                memoryInMBInstance = memoryInMBValue.getIntValue();
                                virtualMachineSizeInstance.setMemoryInMB(memoryInMBInstance);
                            }
                            
                            JsonNode maxDataDiskCountValue = valueValue.get("maxDataDiskCount");
                            if (maxDataDiskCountValue != null && maxDataDiskCountValue instanceof NullNode == false) {
                                int maxDataDiskCountInstance;
                                maxDataDiskCountInstance = maxDataDiskCountValue.getIntValue();
                                virtualMachineSizeInstance.setMaxDataDiskCount(maxDataDiskCountInstance);
                            }
                        }
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets the next page of Virtual Machines. NextLink is obtained by making a
    * ListAll() callwhich fetches the first page of Virtual Machines and a
    * link to fetch the next page.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * ListVirtualMachines operation.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public Future<VirtualMachineListResponse> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineListResponse>() { 
            @Override
            public VirtualMachineListResponse call() throws Exception {
                return listNext(nextLink);
            }
         });
    }
    
    /**
    * Gets the next page of Virtual Machines. NextLink is obtained by making a
    * ListAll() callwhich fetches the first page of Virtual Machines and a
    * link to fetch the next page.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * ListVirtualMachines operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The List Virtual Machine operation response.
    */
    @Override
    public VirtualMachineListResponse listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            VirtualMachineListResponse result = null;
            // Deserialize Response
            if (statusCode == HttpStatus.SC_OK) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (responseContent == null == false) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                
                if (responseDoc != null && responseDoc instanceof NullNode == false) {
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && valueArray instanceof NullNode == false) {
                        for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                            VirtualMachine virtualMachineJsonInstance = new VirtualMachine();
                            result.getVirtualMachines().add(virtualMachineJsonInstance);
                            
                            JsonNode planValue = valueValue.get("plan");
                            if (planValue != null && planValue instanceof NullNode == false) {
                                Plan planInstance = new Plan();
                                virtualMachineJsonInstance.setPlan(planInstance);
                                
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && nameValue instanceof NullNode == false) {
                                    String nameInstance;
                                    nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                
                                JsonNode publisherValue = planValue.get("publisher");
                                if (publisherValue != null && publisherValue instanceof NullNode == false) {
                                    String publisherInstance;
                                    publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                
                                JsonNode productValue = planValue.get("product");
                                if (productValue != null && productValue instanceof NullNode == false) {
                                    String productInstance;
                                    productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                
                                JsonNode promotionCodeValue = planValue.get("promotionCode");
                                if (promotionCodeValue != null && promotionCodeValue instanceof NullNode == false) {
                                    String promotionCodeInstance;
                                    promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            
                            JsonNode propertiesValue = valueValue.get("properties");
                            if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                                JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                                if (hardwareProfileValue != null && hardwareProfileValue instanceof NullNode == false) {
                                    HardwareProfile hardwareProfileInstance = new HardwareProfile();
                                    virtualMachineJsonInstance.setHardwareProfile(hardwareProfileInstance);
                                    
                                    JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                                    if (vmSizeValue != null && vmSizeValue instanceof NullNode == false) {
                                        String vmSizeInstance;
                                        vmSizeInstance = vmSizeValue.getTextValue();
                                        hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                                    }
                                }
                                
                                JsonNode storageProfileValue = propertiesValue.get("storageProfile");
                                if (storageProfileValue != null && storageProfileValue instanceof NullNode == false) {
                                    StorageProfile storageProfileInstance = new StorageProfile();
                                    virtualMachineJsonInstance.setStorageProfile(storageProfileInstance);
                                    
                                    JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                                    if (imageReferenceValue != null && imageReferenceValue instanceof NullNode == false) {
                                        ImageReference imageReferenceInstance = new ImageReference();
                                        storageProfileInstance.setImageReference(imageReferenceInstance);
                                        
                                        JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                        if (publisherValue2 != null && publisherValue2 instanceof NullNode == false) {
                                            String publisherInstance2;
                                            publisherInstance2 = publisherValue2.getTextValue();
                                            imageReferenceInstance.setPublisher(publisherInstance2);
                                        }
                                        
                                        JsonNode offerValue = imageReferenceValue.get("offer");
                                        if (offerValue != null && offerValue instanceof NullNode == false) {
                                            String offerInstance;
                                            offerInstance = offerValue.getTextValue();
                                            imageReferenceInstance.setOffer(offerInstance);
                                        }
                                        
                                        JsonNode skuValue = imageReferenceValue.get("sku");
                                        if (skuValue != null && skuValue instanceof NullNode == false) {
                                            String skuInstance;
                                            skuInstance = skuValue.getTextValue();
                                            imageReferenceInstance.setSku(skuInstance);
                                        }
                                        
                                        JsonNode versionValue = imageReferenceValue.get("version");
                                        if (versionValue != null && versionValue instanceof NullNode == false) {
                                            String versionInstance;
                                            versionInstance = versionValue.getTextValue();
                                            imageReferenceInstance.setVersion(versionInstance);
                                        }
                                    }
                                    
                                    JsonNode osDiskValue = storageProfileValue.get("osDisk");
                                    if (osDiskValue != null && osDiskValue instanceof NullNode == false) {
                                        OSDisk osDiskInstance = new OSDisk();
                                        storageProfileInstance.setOSDisk(osDiskInstance);
                                        
                                        JsonNode osTypeValue = osDiskValue.get("osType");
                                        if (osTypeValue != null && osTypeValue instanceof NullNode == false) {
                                            String osTypeInstance;
                                            osTypeInstance = osTypeValue.getTextValue();
                                            osDiskInstance.setOperatingSystemType(osTypeInstance);
                                        }
                                        
                                        JsonNode nameValue2 = osDiskValue.get("name");
                                        if (nameValue2 != null && nameValue2 instanceof NullNode == false) {
                                            String nameInstance2;
                                            nameInstance2 = nameValue2.getTextValue();
                                            osDiskInstance.setName(nameInstance2);
                                        }
                                        
                                        JsonNode vhdValue = osDiskValue.get("vhd");
                                        if (vhdValue != null && vhdValue instanceof NullNode == false) {
                                            VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                            osDiskInstance.setVirtualHardDisk(vhdInstance);
                                            
                                            JsonNode uriValue = vhdValue.get("uri");
                                            if (uriValue != null && uriValue instanceof NullNode == false) {
                                                String uriInstance;
                                                uriInstance = uriValue.getTextValue();
                                                vhdInstance.setUri(uriInstance);
                                            }
                                        }
                                        
                                        JsonNode imageValue = osDiskValue.get("image");
                                        if (imageValue != null && imageValue instanceof NullNode == false) {
                                            VirtualHardDisk imageInstance = new VirtualHardDisk();
                                            osDiskInstance.setSourceImage(imageInstance);
                                            
                                            JsonNode uriValue2 = imageValue.get("uri");
                                            if (uriValue2 != null && uriValue2 instanceof NullNode == false) {
                                                String uriInstance2;
                                                uriInstance2 = uriValue2.getTextValue();
                                                imageInstance.setUri(uriInstance2);
                                            }
                                        }
                                        
                                        JsonNode cachingValue = osDiskValue.get("caching");
                                        if (cachingValue != null && cachingValue instanceof NullNode == false) {
                                            String cachingInstance;
                                            cachingInstance = cachingValue.getTextValue();
                                            osDiskInstance.setCaching(cachingInstance);
                                        }
                                        
                                        JsonNode createOptionValue = osDiskValue.get("createOption");
                                        if (createOptionValue != null && createOptionValue instanceof NullNode == false) {
                                            String createOptionInstance;
                                            createOptionInstance = createOptionValue.getTextValue();
                                            osDiskInstance.setCreateOption(createOptionInstance);
                                        }
                                        
                                        JsonNode diskSizeGBValue = osDiskValue.get("diskSizeGB");
                                        if (diskSizeGBValue != null && diskSizeGBValue instanceof NullNode == false) {
                                            int diskSizeGBInstance;
                                            diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                            osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                        }
                                    }
                                    
                                    JsonNode dataDisksArray = storageProfileValue.get("dataDisks");
                                    if (dataDisksArray != null && dataDisksArray instanceof NullNode == false) {
                                        for (JsonNode dataDisksValue : ((ArrayNode) dataDisksArray)) {
                                            DataDisk dataDiskInstance = new DataDisk();
                                            storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                            
                                            JsonNode lunValue = dataDisksValue.get("lun");
                                            if (lunValue != null && lunValue instanceof NullNode == false) {
                                                int lunInstance;
                                                lunInstance = lunValue.getIntValue();
                                                dataDiskInstance.setLun(lunInstance);
                                            }
                                            
                                            JsonNode nameValue3 = dataDisksValue.get("name");
                                            if (nameValue3 != null && nameValue3 instanceof NullNode == false) {
                                                String nameInstance3;
                                                nameInstance3 = nameValue3.getTextValue();
                                                dataDiskInstance.setName(nameInstance3);
                                            }
                                            
                                            JsonNode vhdValue2 = dataDisksValue.get("vhd");
                                            if (vhdValue2 != null && vhdValue2 instanceof NullNode == false) {
                                                VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                                
                                                JsonNode uriValue3 = vhdValue2.get("uri");
                                                if (uriValue3 != null && uriValue3 instanceof NullNode == false) {
                                                    String uriInstance3;
                                                    uriInstance3 = uriValue3.getTextValue();
                                                    vhdInstance2.setUri(uriInstance3);
                                                }
                                            }
                                            
                                            JsonNode imageValue2 = dataDisksValue.get("image");
                                            if (imageValue2 != null && imageValue2 instanceof NullNode == false) {
                                                VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setSourceImage(imageInstance2);
                                                
                                                JsonNode uriValue4 = imageValue2.get("uri");
                                                if (uriValue4 != null && uriValue4 instanceof NullNode == false) {
                                                    String uriInstance4;
                                                    uriInstance4 = uriValue4.getTextValue();
                                                    imageInstance2.setUri(uriInstance4);
                                                }
                                            }
                                            
                                            JsonNode cachingValue2 = dataDisksValue.get("caching");
                                            if (cachingValue2 != null && cachingValue2 instanceof NullNode == false) {
                                                String cachingInstance2;
                                                cachingInstance2 = cachingValue2.getTextValue();
                                                dataDiskInstance.setCaching(cachingInstance2);
                                            }
                                            
                                            JsonNode createOptionValue2 = dataDisksValue.get("createOption");
                                            if (createOptionValue2 != null && createOptionValue2 instanceof NullNode == false) {
                                                String createOptionInstance2;
                                                createOptionInstance2 = createOptionValue2.getTextValue();
                                                dataDiskInstance.setCreateOption(createOptionInstance2);
                                            }
                                            
                                            JsonNode diskSizeGBValue2 = dataDisksValue.get("diskSizeGB");
                                            if (diskSizeGBValue2 != null && diskSizeGBValue2 instanceof NullNode == false) {
                                                int diskSizeGBInstance2;
                                                diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                                dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode osProfileValue = propertiesValue.get("osProfile");
                                if (osProfileValue != null && osProfileValue instanceof NullNode == false) {
                                    OSProfile osProfileInstance = new OSProfile();
                                    virtualMachineJsonInstance.setOSProfile(osProfileInstance);
                                    
                                    JsonNode computerNameValue = osProfileValue.get("computerName");
                                    if (computerNameValue != null && computerNameValue instanceof NullNode == false) {
                                        String computerNameInstance;
                                        computerNameInstance = computerNameValue.getTextValue();
                                        osProfileInstance.setComputerName(computerNameInstance);
                                    }
                                    
                                    JsonNode adminUsernameValue = osProfileValue.get("adminUsername");
                                    if (adminUsernameValue != null && adminUsernameValue instanceof NullNode == false) {
                                        String adminUsernameInstance;
                                        adminUsernameInstance = adminUsernameValue.getTextValue();
                                        osProfileInstance.setAdminUsername(adminUsernameInstance);
                                    }
                                    
                                    JsonNode adminPasswordValue = osProfileValue.get("adminPassword");
                                    if (adminPasswordValue != null && adminPasswordValue instanceof NullNode == false) {
                                        String adminPasswordInstance;
                                        adminPasswordInstance = adminPasswordValue.getTextValue();
                                        osProfileInstance.setAdminPassword(adminPasswordInstance);
                                    }
                                    
                                    JsonNode customDataValue = osProfileValue.get("customData");
                                    if (customDataValue != null && customDataValue instanceof NullNode == false) {
                                        String customDataInstance;
                                        customDataInstance = customDataValue.getTextValue();
                                        osProfileInstance.setCustomData(customDataInstance);
                                    }
                                    
                                    JsonNode windowsConfigurationValue = osProfileValue.get("windowsConfiguration");
                                    if (windowsConfigurationValue != null && windowsConfigurationValue instanceof NullNode == false) {
                                        WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                        osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                        
                                        JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                        if (provisionVMAgentValue != null && provisionVMAgentValue instanceof NullNode == false) {
                                            boolean provisionVMAgentInstance;
                                            provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                            windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                        }
                                        
                                        JsonNode enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates");
                                        if (enableAutomaticUpdatesValue != null && enableAutomaticUpdatesValue instanceof NullNode == false) {
                                            boolean enableAutomaticUpdatesInstance;
                                            enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                            windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                        }
                                        
                                        JsonNode timeZoneValue = windowsConfigurationValue.get("timeZone");
                                        if (timeZoneValue != null && timeZoneValue instanceof NullNode == false) {
                                            String timeZoneInstance;
                                            timeZoneInstance = timeZoneValue.getTextValue();
                                            windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                        }
                                        
                                        JsonNode additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent");
                                        if (additionalUnattendContentArray != null && additionalUnattendContentArray instanceof NullNode == false) {
                                            for (JsonNode additionalUnattendContentValue : ((ArrayNode) additionalUnattendContentArray)) {
                                                AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                                windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                                
                                                JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                                if (passNameValue != null && passNameValue instanceof NullNode == false) {
                                                    String passNameInstance;
                                                    passNameInstance = passNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setPassName(passNameInstance);
                                                }
                                                
                                                JsonNode componentNameValue = additionalUnattendContentValue.get("componentName");
                                                if (componentNameValue != null && componentNameValue instanceof NullNode == false) {
                                                    String componentNameInstance;
                                                    componentNameInstance = componentNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                                }
                                                
                                                JsonNode settingNameValue = additionalUnattendContentValue.get("settingName");
                                                if (settingNameValue != null && settingNameValue instanceof NullNode == false) {
                                                    String settingNameInstance;
                                                    settingNameInstance = settingNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                                }
                                                
                                                JsonNode contentValue = additionalUnattendContentValue.get("content");
                                                if (contentValue != null && contentValue instanceof NullNode == false) {
                                                    String contentInstance;
                                                    contentInstance = contentValue.getTextValue();
                                                    additionalUnattendContentInstance.setContent(contentInstance);
                                                }
                                            }
                                        }
                                        
                                        JsonNode winRMValue = windowsConfigurationValue.get("winRM");
                                        if (winRMValue != null && winRMValue instanceof NullNode == false) {
                                            WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                            windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                            
                                            JsonNode listenersArray = winRMValue.get("listeners");
                                            if (listenersArray != null && listenersArray instanceof NullNode == false) {
                                                for (JsonNode listenersValue : ((ArrayNode) listenersArray)) {
                                                    WinRMListener winRMListenerInstance = new WinRMListener();
                                                    winRMInstance.getListeners().add(winRMListenerInstance);
                                                    
                                                    JsonNode protocolValue = listenersValue.get("protocol");
                                                    if (protocolValue != null && protocolValue instanceof NullNode == false) {
                                                        String protocolInstance;
                                                        protocolInstance = protocolValue.getTextValue();
                                                        winRMListenerInstance.setProtocol(protocolInstance);
                                                    }
                                                    
                                                    JsonNode certificateUrlValue = listenersValue.get("certificateUrl");
                                                    if (certificateUrlValue != null && certificateUrlValue instanceof NullNode == false) {
                                                        URI certificateUrlInstance;
                                                        certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                        winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode linuxConfigurationValue = osProfileValue.get("linuxConfiguration");
                                    if (linuxConfigurationValue != null && linuxConfigurationValue instanceof NullNode == false) {
                                        LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                        osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                        
                                        JsonNode disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                        if (disablePasswordAuthenticationValue != null && disablePasswordAuthenticationValue instanceof NullNode == false) {
                                            boolean disablePasswordAuthenticationInstance;
                                            disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                            linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                        }
                                        
                                        JsonNode sshValue = linuxConfigurationValue.get("ssh");
                                        if (sshValue != null && sshValue instanceof NullNode == false) {
                                            SshConfiguration sshInstance = new SshConfiguration();
                                            linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                            
                                            JsonNode publicKeysArray = sshValue.get("publicKeys");
                                            if (publicKeysArray != null && publicKeysArray instanceof NullNode == false) {
                                                for (JsonNode publicKeysValue : ((ArrayNode) publicKeysArray)) {
                                                    SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                                    sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                                    
                                                    JsonNode pathValue = publicKeysValue.get("path");
                                                    if (pathValue != null && pathValue instanceof NullNode == false) {
                                                        String pathInstance;
                                                        pathInstance = pathValue.getTextValue();
                                                        sshPublicKeyInstance.setPath(pathInstance);
                                                    }
                                                    
                                                    JsonNode keyDataValue = publicKeysValue.get("keyData");
                                                    if (keyDataValue != null && keyDataValue instanceof NullNode == false) {
                                                        String keyDataInstance;
                                                        keyDataInstance = keyDataValue.getTextValue();
                                                        sshPublicKeyInstance.setKeyData(keyDataInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode secretsArray = osProfileValue.get("secrets");
                                    if (secretsArray != null && secretsArray instanceof NullNode == false) {
                                        for (JsonNode secretsValue : ((ArrayNode) secretsArray)) {
                                            VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                            osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                            
                                            JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                            if (sourceVaultValue != null && sourceVaultValue instanceof NullNode == false) {
                                                SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                                vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                                
                                                JsonNode idValue = sourceVaultValue.get("id");
                                                if (idValue != null && idValue instanceof NullNode == false) {
                                                    String idInstance;
                                                    idInstance = idValue.getTextValue();
                                                    sourceVaultInstance.setReferenceUri(idInstance);
                                                }
                                            }
                                            
                                            JsonNode vaultCertificatesArray = secretsValue.get("vaultCertificates");
                                            if (vaultCertificatesArray != null && vaultCertificatesArray instanceof NullNode == false) {
                                                for (JsonNode vaultCertificatesValue : ((ArrayNode) vaultCertificatesArray)) {
                                                    VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                                    vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                                    
                                                    JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                                    if (certificateUrlValue2 != null && certificateUrlValue2 instanceof NullNode == false) {
                                                        String certificateUrlInstance2;
                                                        certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                        vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                                    }
                                                    
                                                    JsonNode certificateStoreValue = vaultCertificatesValue.get("certificateStore");
                                                    if (certificateStoreValue != null && certificateStoreValue instanceof NullNode == false) {
                                                        String certificateStoreInstance;
                                                        certificateStoreInstance = certificateStoreValue.getTextValue();
                                                        vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode networkProfileValue = propertiesValue.get("networkProfile");
                                if (networkProfileValue != null && networkProfileValue instanceof NullNode == false) {
                                    NetworkProfile networkProfileInstance = new NetworkProfile();
                                    virtualMachineJsonInstance.setNetworkProfile(networkProfileInstance);
                                    
                                    JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                                    if (networkInterfacesArray != null && networkInterfacesArray instanceof NullNode == false) {
                                        for (JsonNode networkInterfacesValue : ((ArrayNode) networkInterfacesArray)) {
                                            NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                            networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                            
                                            JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                            if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                                                JsonNode primaryValue = propertiesValue2.get("primary");
                                                if (primaryValue != null && primaryValue instanceof NullNode == false) {
                                                    boolean primaryInstance;
                                                    primaryInstance = primaryValue.getBooleanValue();
                                                    networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                                }
                                            }
                                            
                                            JsonNode idValue2 = networkInterfacesValue.get("id");
                                            if (idValue2 != null && idValue2 instanceof NullNode == false) {
                                                String idInstance2;
                                                idInstance2 = idValue2.getTextValue();
                                                networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                            }
                                        }
                                    }
                                }
                                
                                JsonNode diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile");
                                if (diagnosticsProfileValue != null && diagnosticsProfileValue instanceof NullNode == false) {
                                    DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                                    virtualMachineJsonInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                                    
                                    JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue != null && bootDiagnosticsValue instanceof NullNode == false) {
                                        BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                        diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                        
                                        JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                        if (enabledValue != null && enabledValue instanceof NullNode == false) {
                                            boolean enabledInstance;
                                            enabledInstance = enabledValue.getBooleanValue();
                                            bootDiagnosticsInstance.setEnabled(enabledInstance);
                                        }
                                        
                                        JsonNode storageUriValue = bootDiagnosticsValue.get("storageUri");
                                        if (storageUriValue != null && storageUriValue instanceof NullNode == false) {
                                            URI storageUriInstance;
                                            storageUriInstance = new URI(storageUriValue.getTextValue());
                                            bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                        }
                                    }
                                }
                                
                                JsonNode availabilitySetValue = propertiesValue.get("availabilitySet");
                                if (availabilitySetValue != null && availabilitySetValue instanceof NullNode == false) {
                                    AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                                    virtualMachineJsonInstance.setAvailabilitySetReference(availabilitySetInstance);
                                    
                                    JsonNode idValue3 = availabilitySetValue.get("id");
                                    if (idValue3 != null && idValue3 instanceof NullNode == false) {
                                        String idInstance3;
                                        idInstance3 = idValue3.getTextValue();
                                        availabilitySetInstance.setReferenceUri(idInstance3);
                                    }
                                }
                                
                                JsonNode provisioningStateValue = propertiesValue.get("provisioningState");
                                if (provisioningStateValue != null && provisioningStateValue instanceof NullNode == false) {
                                    String provisioningStateInstance;
                                    provisioningStateInstance = provisioningStateValue.getTextValue();
                                    virtualMachineJsonInstance.setProvisioningState(provisioningStateInstance);
                                }
                                
                                JsonNode instanceViewValue = propertiesValue.get("instanceView");
                                if (instanceViewValue != null && instanceViewValue instanceof NullNode == false) {
                                    VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                                    virtualMachineJsonInstance.setInstanceView(instanceViewInstance);
                                    
                                    JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                                    if (platformUpdateDomainValue != null && platformUpdateDomainValue instanceof NullNode == false) {
                                        int platformUpdateDomainInstance;
                                        platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                                    }
                                    
                                    JsonNode platformFaultDomainValue = instanceViewValue.get("platformFaultDomain");
                                    if (platformFaultDomainValue != null && platformFaultDomainValue instanceof NullNode == false) {
                                        int platformFaultDomainInstance;
                                        platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                                    }
                                    
                                    JsonNode rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint");
                                    if (rdpThumbPrintValue != null && rdpThumbPrintValue instanceof NullNode == false) {
                                        String rdpThumbPrintInstance;
                                        rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                        instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                                    }
                                    
                                    JsonNode vmAgentValue = instanceViewValue.get("vmAgent");
                                    if (vmAgentValue != null && vmAgentValue instanceof NullNode == false) {
                                        VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                        instanceViewInstance.setVMAgent(vmAgentInstance);
                                        
                                        JsonNode vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                        if (vmAgentVersionValue != null && vmAgentVersionValue instanceof NullNode == false) {
                                            String vmAgentVersionInstance;
                                            vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                            vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                        }
                                        
                                        JsonNode extensionHandlersArray = vmAgentValue.get("extensionHandlers");
                                        if (extensionHandlersArray != null && extensionHandlersArray instanceof NullNode == false) {
                                            for (JsonNode extensionHandlersValue : ((ArrayNode) extensionHandlersArray)) {
                                                VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                                vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                                
                                                JsonNode typeValue = extensionHandlersValue.get("type");
                                                if (typeValue != null && typeValue instanceof NullNode == false) {
                                                    String typeInstance;
                                                    typeInstance = typeValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                                }
                                                
                                                JsonNode typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion");
                                                if (typeHandlerVersionValue != null && typeHandlerVersionValue instanceof NullNode == false) {
                                                    String typeHandlerVersionInstance;
                                                    typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                                }
                                                
                                                JsonNode statusValue = extensionHandlersValue.get("status");
                                                if (statusValue != null && statusValue instanceof NullNode == false) {
                                                    InstanceViewStatus statusInstance = new InstanceViewStatus();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                                    
                                                    JsonNode codeValue = statusValue.get("code");
                                                    if (codeValue != null && codeValue instanceof NullNode == false) {
                                                        String codeInstance;
                                                        codeInstance = codeValue.getTextValue();
                                                        statusInstance.setCode(codeInstance);
                                                    }
                                                    
                                                    JsonNode levelValue = statusValue.get("level");
                                                    if (levelValue != null && levelValue instanceof NullNode == false) {
                                                        String levelInstance;
                                                        levelInstance = levelValue.getTextValue();
                                                        statusInstance.setLevel(levelInstance);
                                                    }
                                                    
                                                    JsonNode displayStatusValue = statusValue.get("displayStatus");
                                                    if (displayStatusValue != null && displayStatusValue instanceof NullNode == false) {
                                                        String displayStatusInstance;
                                                        displayStatusInstance = displayStatusValue.getTextValue();
                                                        statusInstance.setDisplayStatus(displayStatusInstance);
                                                    }
                                                    
                                                    JsonNode messageValue = statusValue.get("message");
                                                    if (messageValue != null && messageValue instanceof NullNode == false) {
                                                        String messageInstance;
                                                        messageInstance = messageValue.getTextValue();
                                                        statusInstance.setMessage(messageInstance);
                                                    }
                                                    
                                                    JsonNode timeValue = statusValue.get("time");
                                                    if (timeValue != null && timeValue instanceof NullNode == false) {
                                                        Calendar timeInstance;
                                                        timeInstance = DatatypeConverter.parseDateTime(timeValue.getTextValue());
                                                        statusInstance.setTime(timeInstance);
                                                    }
                                                }
                                            }
                                        }
                                        
                                        JsonNode statusesArray = vmAgentValue.get("statuses");
                                        if (statusesArray != null && statusesArray instanceof NullNode == false) {
                                            for (JsonNode statusesValue : ((ArrayNode) statusesArray)) {
                                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                                vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                                
                                                JsonNode codeValue2 = statusesValue.get("code");
                                                if (codeValue2 != null && codeValue2 instanceof NullNode == false) {
                                                    String codeInstance2;
                                                    codeInstance2 = codeValue2.getTextValue();
                                                    instanceViewStatusInstance.setCode(codeInstance2);
                                                }
                                                
                                                JsonNode levelValue2 = statusesValue.get("level");
                                                if (levelValue2 != null && levelValue2 instanceof NullNode == false) {
                                                    String levelInstance2;
                                                    levelInstance2 = levelValue2.getTextValue();
                                                    instanceViewStatusInstance.setLevel(levelInstance2);
                                                }
                                                
                                                JsonNode displayStatusValue2 = statusesValue.get("displayStatus");
                                                if (displayStatusValue2 != null && displayStatusValue2 instanceof NullNode == false) {
                                                    String displayStatusInstance2;
                                                    displayStatusInstance2 = displayStatusValue2.getTextValue();
                                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                                }
                                                
                                                JsonNode messageValue2 = statusesValue.get("message");
                                                if (messageValue2 != null && messageValue2 instanceof NullNode == false) {
                                                    String messageInstance2;
                                                    messageInstance2 = messageValue2.getTextValue();
                                                    instanceViewStatusInstance.setMessage(messageInstance2);
                                                }
                                                
                                                JsonNode timeValue2 = statusesValue.get("time");
                                                if (timeValue2 != null && timeValue2 instanceof NullNode == false) {
                                                    Calendar timeInstance2;
                                                    timeInstance2 = DatatypeConverter.parseDateTime(timeValue2.getTextValue());
                                                    instanceViewStatusInstance.setTime(timeInstance2);
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode disksArray = instanceViewValue.get("disks");
                                    if (disksArray != null && disksArray instanceof NullNode == false) {
                                        for (JsonNode disksValue : ((ArrayNode) disksArray)) {
                                            DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                            instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                            
                                            JsonNode nameValue4 = disksValue.get("name");
                                            if (nameValue4 != null && nameValue4 instanceof NullNode == false) {
                                                String nameInstance4;
                                                nameInstance4 = nameValue4.getTextValue();
                                                diskInstanceViewInstance.setName(nameInstance4);
                                            }
                                            
                                            JsonNode statusesArray2 = disksValue.get("statuses");
                                            if (statusesArray2 != null && statusesArray2 instanceof NullNode == false) {
                                                for (JsonNode statusesValue2 : ((ArrayNode) statusesArray2)) {
                                                    InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                                    diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                                    
                                                    JsonNode codeValue3 = statusesValue2.get("code");
                                                    if (codeValue3 != null && codeValue3 instanceof NullNode == false) {
                                                        String codeInstance3;
                                                        codeInstance3 = codeValue3.getTextValue();
                                                        instanceViewStatusInstance2.setCode(codeInstance3);
                                                    }
                                                    
                                                    JsonNode levelValue3 = statusesValue2.get("level");
                                                    if (levelValue3 != null && levelValue3 instanceof NullNode == false) {
                                                        String levelInstance3;
                                                        levelInstance3 = levelValue3.getTextValue();
                                                        instanceViewStatusInstance2.setLevel(levelInstance3);
                                                    }
                                                    
                                                    JsonNode displayStatusValue3 = statusesValue2.get("displayStatus");
                                                    if (displayStatusValue3 != null && displayStatusValue3 instanceof NullNode == false) {
                                                        String displayStatusInstance3;
                                                        displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                        instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                                    }
                                                    
                                                    JsonNode messageValue3 = statusesValue2.get("message");
                                                    if (messageValue3 != null && messageValue3 instanceof NullNode == false) {
                                                        String messageInstance3;
                                                        messageInstance3 = messageValue3.getTextValue();
                                                        instanceViewStatusInstance2.setMessage(messageInstance3);
                                                    }
                                                    
                                                    JsonNode timeValue3 = statusesValue2.get("time");
                                                    if (timeValue3 != null && timeValue3 instanceof NullNode == false) {
                                                        Calendar timeInstance3;
                                                        timeInstance3 = DatatypeConverter.parseDateTime(timeValue3.getTextValue());
                                                        instanceViewStatusInstance2.setTime(timeInstance3);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode extensionsArray = instanceViewValue.get("extensions");
                                    if (extensionsArray != null && extensionsArray instanceof NullNode == false) {
                                        for (JsonNode extensionsValue : ((ArrayNode) extensionsArray)) {
                                            VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                            instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                            
                                            JsonNode nameValue5 = extensionsValue.get("name");
                                            if (nameValue5 != null && nameValue5 instanceof NullNode == false) {
                                                String nameInstance5;
                                                nameInstance5 = nameValue5.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                            }
                                            
                                            JsonNode typeValue2 = extensionsValue.get("type");
                                            if (typeValue2 != null && typeValue2 instanceof NullNode == false) {
                                                String typeInstance2;
                                                typeInstance2 = typeValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                            }
                                            
                                            JsonNode typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion");
                                            if (typeHandlerVersionValue2 != null && typeHandlerVersionValue2 instanceof NullNode == false) {
                                                String typeHandlerVersionInstance2;
                                                typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                            }
                                            
                                            JsonNode substatusesArray = extensionsValue.get("substatuses");
                                            if (substatusesArray != null && substatusesArray instanceof NullNode == false) {
                                                for (JsonNode substatusesValue : ((ArrayNode) substatusesArray)) {
                                                    InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                                    
                                                    JsonNode codeValue4 = substatusesValue.get("code");
                                                    if (codeValue4 != null && codeValue4 instanceof NullNode == false) {
                                                        String codeInstance4;
                                                        codeInstance4 = codeValue4.getTextValue();
                                                        instanceViewStatusInstance3.setCode(codeInstance4);
                                                    }
                                                    
                                                    JsonNode levelValue4 = substatusesValue.get("level");
                                                    if (levelValue4 != null && levelValue4 instanceof NullNode == false) {
                                                        String levelInstance4;
                                                        levelInstance4 = levelValue4.getTextValue();
                                                        instanceViewStatusInstance3.setLevel(levelInstance4);
                                                    }
                                                    
                                                    JsonNode displayStatusValue4 = substatusesValue.get("displayStatus");
                                                    if (displayStatusValue4 != null && displayStatusValue4 instanceof NullNode == false) {
                                                        String displayStatusInstance4;
                                                        displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                        instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                                    }
                                                    
                                                    JsonNode messageValue4 = substatusesValue.get("message");
                                                    if (messageValue4 != null && messageValue4 instanceof NullNode == false) {
                                                        String messageInstance4;
                                                        messageInstance4 = messageValue4.getTextValue();
                                                        instanceViewStatusInstance3.setMessage(messageInstance4);
                                                    }
                                                    
                                                    JsonNode timeValue4 = substatusesValue.get("time");
                                                    if (timeValue4 != null && timeValue4 instanceof NullNode == false) {
                                                        Calendar timeInstance4;
                                                        timeInstance4 = DatatypeConverter.parseDateTime(timeValue4.getTextValue());
                                                        instanceViewStatusInstance3.setTime(timeInstance4);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode statusesArray3 = extensionsValue.get("statuses");
                                            if (statusesArray3 != null && statusesArray3 instanceof NullNode == false) {
                                                for (JsonNode statusesValue3 : ((ArrayNode) statusesArray3)) {
                                                    InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                                    
                                                    JsonNode codeValue5 = statusesValue3.get("code");
                                                    if (codeValue5 != null && codeValue5 instanceof NullNode == false) {
                                                        String codeInstance5;
                                                        codeInstance5 = codeValue5.getTextValue();
                                                        instanceViewStatusInstance4.setCode(codeInstance5);
                                                    }
                                                    
                                                    JsonNode levelValue5 = statusesValue3.get("level");
                                                    if (levelValue5 != null && levelValue5 instanceof NullNode == false) {
                                                        String levelInstance5;
                                                        levelInstance5 = levelValue5.getTextValue();
                                                        instanceViewStatusInstance4.setLevel(levelInstance5);
                                                    }
                                                    
                                                    JsonNode displayStatusValue5 = statusesValue3.get("displayStatus");
                                                    if (displayStatusValue5 != null && displayStatusValue5 instanceof NullNode == false) {
                                                        String displayStatusInstance5;
                                                        displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                        instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                                    }
                                                    
                                                    JsonNode messageValue5 = statusesValue3.get("message");
                                                    if (messageValue5 != null && messageValue5 instanceof NullNode == false) {
                                                        String messageInstance5;
                                                        messageInstance5 = messageValue5.getTextValue();
                                                        instanceViewStatusInstance4.setMessage(messageInstance5);
                                                    }
                                                    
                                                    JsonNode timeValue5 = statusesValue3.get("time");
                                                    if (timeValue5 != null && timeValue5 instanceof NullNode == false) {
                                                        Calendar timeInstance5;
                                                        timeInstance5 = DatatypeConverter.parseDateTime(timeValue5.getTextValue());
                                                        instanceViewStatusInstance4.setTime(timeInstance5);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue2 != null && bootDiagnosticsValue2 instanceof NullNode == false) {
                                        BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                        instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                        
                                        JsonNode consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                        if (consoleScreenshotBlobUriValue != null && consoleScreenshotBlobUriValue instanceof NullNode == false) {
                                            URI consoleScreenshotBlobUriInstance;
                                            consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                        }
                                        
                                        JsonNode serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri");
                                        if (serialConsoleLogBlobUriValue != null && serialConsoleLogBlobUriValue instanceof NullNode == false) {
                                            URI serialConsoleLogBlobUriInstance;
                                            serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                        }
                                    }
                                    
                                    JsonNode statusesArray4 = instanceViewValue.get("statuses");
                                    if (statusesArray4 != null && statusesArray4 instanceof NullNode == false) {
                                        for (JsonNode statusesValue4 : ((ArrayNode) statusesArray4)) {
                                            InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                            instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                            
                                            JsonNode codeValue6 = statusesValue4.get("code");
                                            if (codeValue6 != null && codeValue6 instanceof NullNode == false) {
                                                String codeInstance6;
                                                codeInstance6 = codeValue6.getTextValue();
                                                instanceViewStatusInstance5.setCode(codeInstance6);
                                            }
                                            
                                            JsonNode levelValue6 = statusesValue4.get("level");
                                            if (levelValue6 != null && levelValue6 instanceof NullNode == false) {
                                                String levelInstance6;
                                                levelInstance6 = levelValue6.getTextValue();
                                                instanceViewStatusInstance5.setLevel(levelInstance6);
                                            }
                                            
                                            JsonNode displayStatusValue6 = statusesValue4.get("displayStatus");
                                            if (displayStatusValue6 != null && displayStatusValue6 instanceof NullNode == false) {
                                                String displayStatusInstance6;
                                                displayStatusInstance6 = displayStatusValue6.getTextValue();
                                                instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                            }
                                            
                                            JsonNode messageValue6 = statusesValue4.get("message");
                                            if (messageValue6 != null && messageValue6 instanceof NullNode == false) {
                                                String messageInstance6;
                                                messageInstance6 = messageValue6.getTextValue();
                                                instanceViewStatusInstance5.setMessage(messageInstance6);
                                            }
                                            
                                            JsonNode timeValue6 = statusesValue4.get("time");
                                            if (timeValue6 != null && timeValue6 instanceof NullNode == false) {
                                                Calendar timeInstance6;
                                                timeInstance6 = DatatypeConverter.parseDateTime(timeValue6.getTextValue());
                                                instanceViewStatusInstance5.setTime(timeInstance6);
                                            }
                                        }
                                    }
                                }
                            }
                            
                            JsonNode resourcesArray = valueValue.get("resources");
                            if (resourcesArray != null && resourcesArray instanceof NullNode == false) {
                                virtualMachineJsonInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                                for (JsonNode resourcesValue : ((ArrayNode) resourcesArray)) {
                                    VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                                    virtualMachineJsonInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                                    
                                    JsonNode propertiesValue3 = resourcesValue.get("properties");
                                    if (propertiesValue3 != null && propertiesValue3 instanceof NullNode == false) {
                                        JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                        if (publisherValue3 != null && publisherValue3 instanceof NullNode == false) {
                                            String publisherInstance3;
                                            publisherInstance3 = publisherValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                        }
                                        
                                        JsonNode typeValue3 = propertiesValue3.get("type");
                                        if (typeValue3 != null && typeValue3 instanceof NullNode == false) {
                                            String typeInstance3;
                                            typeInstance3 = typeValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                        }
                                        
                                        JsonNode typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion");
                                        if (typeHandlerVersionValue3 != null && typeHandlerVersionValue3 instanceof NullNode == false) {
                                            String typeHandlerVersionInstance3;
                                            typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                        }
                                        
                                        JsonNode autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion");
                                        if (autoUpgradeMinorVersionValue != null && autoUpgradeMinorVersionValue instanceof NullNode == false) {
                                            boolean autoUpgradeMinorVersionInstance;
                                            autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                            virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                        }
                                        
                                        JsonNode settingsValue = propertiesValue3.get("settings");
                                        if (settingsValue != null && settingsValue instanceof NullNode == false) {
                                            String settingsInstance;
                                            settingsInstance = settingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                        }
                                        
                                        JsonNode protectedSettingsValue = propertiesValue3.get("protectedSettings");
                                        if (protectedSettingsValue != null && protectedSettingsValue instanceof NullNode == false) {
                                            String protectedSettingsInstance;
                                            protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                        }
                                        
                                        JsonNode provisioningStateValue2 = propertiesValue3.get("provisioningState");
                                        if (provisioningStateValue2 != null && provisioningStateValue2 instanceof NullNode == false) {
                                            String provisioningStateInstance2;
                                            provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                        }
                                        
                                        JsonNode instanceViewValue2 = propertiesValue3.get("instanceView");
                                        if (instanceViewValue2 != null && instanceViewValue2 instanceof NullNode == false) {
                                            VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                            virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                            
                                            JsonNode nameValue6 = instanceViewValue2.get("name");
                                            if (nameValue6 != null && nameValue6 instanceof NullNode == false) {
                                                String nameInstance6;
                                                nameInstance6 = nameValue6.getTextValue();
                                                instanceViewInstance2.setName(nameInstance6);
                                            }
                                            
                                            JsonNode typeValue4 = instanceViewValue2.get("type");
                                            if (typeValue4 != null && typeValue4 instanceof NullNode == false) {
                                                String typeInstance4;
                                                typeInstance4 = typeValue4.getTextValue();
                                                instanceViewInstance2.setExtensionType(typeInstance4);
                                            }
                                            
                                            JsonNode typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion");
                                            if (typeHandlerVersionValue4 != null && typeHandlerVersionValue4 instanceof NullNode == false) {
                                                String typeHandlerVersionInstance4;
                                                typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                                instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                            }
                                            
                                            JsonNode substatusesArray2 = instanceViewValue2.get("substatuses");
                                            if (substatusesArray2 != null && substatusesArray2 instanceof NullNode == false) {
                                                for (JsonNode substatusesValue2 : ((ArrayNode) substatusesArray2)) {
                                                    InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                                    instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                                    
                                                    JsonNode codeValue7 = substatusesValue2.get("code");
                                                    if (codeValue7 != null && codeValue7 instanceof NullNode == false) {
                                                        String codeInstance7;
                                                        codeInstance7 = codeValue7.getTextValue();
                                                        instanceViewStatusInstance6.setCode(codeInstance7);
                                                    }
                                                    
                                                    JsonNode levelValue7 = substatusesValue2.get("level");
                                                    if (levelValue7 != null && levelValue7 instanceof NullNode == false) {
                                                        String levelInstance7;
                                                        levelInstance7 = levelValue7.getTextValue();
                                                        instanceViewStatusInstance6.setLevel(levelInstance7);
                                                    }
                                                    
                                                    JsonNode displayStatusValue7 = substatusesValue2.get("displayStatus");
                                                    if (displayStatusValue7 != null && displayStatusValue7 instanceof NullNode == false) {
                                                        String displayStatusInstance7;
                                                        displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                        instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                                    }
                                                    
                                                    JsonNode messageValue7 = substatusesValue2.get("message");
                                                    if (messageValue7 != null && messageValue7 instanceof NullNode == false) {
                                                        String messageInstance7;
                                                        messageInstance7 = messageValue7.getTextValue();
                                                        instanceViewStatusInstance6.setMessage(messageInstance7);
                                                    }
                                                    
                                                    JsonNode timeValue7 = substatusesValue2.get("time");
                                                    if (timeValue7 != null && timeValue7 instanceof NullNode == false) {
                                                        Calendar timeInstance7;
                                                        timeInstance7 = DatatypeConverter.parseDateTime(timeValue7.getTextValue());
                                                        instanceViewStatusInstance6.setTime(timeInstance7);
                                                    }
                                                }
                                            }
                                            
                                            JsonNode statusesArray5 = instanceViewValue2.get("statuses");
                                            if (statusesArray5 != null && statusesArray5 instanceof NullNode == false) {
                                                for (JsonNode statusesValue5 : ((ArrayNode) statusesArray5)) {
                                                    InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                                    instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                                    
                                                    JsonNode codeValue8 = statusesValue5.get("code");
                                                    if (codeValue8 != null && codeValue8 instanceof NullNode == false) {
                                                        String codeInstance8;
                                                        codeInstance8 = codeValue8.getTextValue();
                                                        instanceViewStatusInstance7.setCode(codeInstance8);
                                                    }
                                                    
                                                    JsonNode levelValue8 = statusesValue5.get("level");
                                                    if (levelValue8 != null && levelValue8 instanceof NullNode == false) {
                                                        String levelInstance8;
                                                        levelInstance8 = levelValue8.getTextValue();
                                                        instanceViewStatusInstance7.setLevel(levelInstance8);
                                                    }
                                                    
                                                    JsonNode displayStatusValue8 = statusesValue5.get("displayStatus");
                                                    if (displayStatusValue8 != null && displayStatusValue8 instanceof NullNode == false) {
                                                        String displayStatusInstance8;
                                                        displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                        instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                                    }
                                                    
                                                    JsonNode messageValue8 = statusesValue5.get("message");
                                                    if (messageValue8 != null && messageValue8 instanceof NullNode == false) {
                                                        String messageInstance8;
                                                        messageInstance8 = messageValue8.getTextValue();
                                                        instanceViewStatusInstance7.setMessage(messageInstance8);
                                                    }
                                                    
                                                    JsonNode timeValue8 = statusesValue5.get("time");
                                                    if (timeValue8 != null && timeValue8 instanceof NullNode == false) {
                                                        Calendar timeInstance8;
                                                        timeInstance8 = DatatypeConverter.parseDateTime(timeValue8.getTextValue());
                                                        instanceViewStatusInstance7.setTime(timeInstance8);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    
                                    JsonNode idValue4 = resourcesValue.get("id");
                                    if (idValue4 != null && idValue4 instanceof NullNode == false) {
                                        String idInstance4;
                                        idInstance4 = idValue4.getTextValue();
                                        virtualMachineExtensionJsonInstance.setId(idInstance4);
                                    }
                                    
                                    JsonNode nameValue7 = resourcesValue.get("name");
                                    if (nameValue7 != null && nameValue7 instanceof NullNode == false) {
                                        String nameInstance7;
                                        nameInstance7 = nameValue7.getTextValue();
                                        virtualMachineExtensionJsonInstance.setName(nameInstance7);
                                    }
                                    
                                    JsonNode typeValue5 = resourcesValue.get("type");
                                    if (typeValue5 != null && typeValue5 instanceof NullNode == false) {
                                        String typeInstance5;
                                        typeInstance5 = typeValue5.getTextValue();
                                        virtualMachineExtensionJsonInstance.setType(typeInstance5);
                                    }
                                    
                                    JsonNode locationValue = resourcesValue.get("location");
                                    if (locationValue != null && locationValue instanceof NullNode == false) {
                                        String locationInstance;
                                        locationInstance = locationValue.getTextValue();
                                        virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                                    }
                                    
                                    JsonNode tagsSequenceElement = ((JsonNode) resourcesValue.get("tags"));
                                    if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                                        Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                                        while (itr.hasNext()) {
                                            Map.Entry<String, JsonNode> property = itr.next();
                                            String tagsKey = property.getKey();
                                            String tagsValue = property.getValue().getTextValue();
                                            virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                                        }
                                    }
                                }
                            }
                            
                            JsonNode idValue5 = valueValue.get("id");
                            if (idValue5 != null && idValue5 instanceof NullNode == false) {
                                String idInstance5;
                                idInstance5 = idValue5.getTextValue();
                                virtualMachineJsonInstance.setId(idInstance5);
                            }
                            
                            JsonNode nameValue8 = valueValue.get("name");
                            if (nameValue8 != null && nameValue8 instanceof NullNode == false) {
                                String nameInstance8;
                                nameInstance8 = nameValue8.getTextValue();
                                virtualMachineJsonInstance.setName(nameInstance8);
                            }
                            
                            JsonNode typeValue6 = valueValue.get("type");
                            if (typeValue6 != null && typeValue6 instanceof NullNode == false) {
                                String typeInstance6;
                                typeInstance6 = typeValue6.getTextValue();
                                virtualMachineJsonInstance.setType(typeInstance6);
                            }
                            
                            JsonNode locationValue2 = valueValue.get("location");
                            if (locationValue2 != null && locationValue2 instanceof NullNode == false) {
                                String locationInstance2;
                                locationInstance2 = locationValue2.getTextValue();
                                virtualMachineJsonInstance.setLocation(locationInstance2);
                            }
                            
                            JsonNode tagsSequenceElement2 = ((JsonNode) valueValue.get("tags"));
                            if (tagsSequenceElement2 != null && tagsSequenceElement2 instanceof NullNode == false) {
                                Iterator<Map.Entry<String, JsonNode>> itr2 = tagsSequenceElement2.getFields();
                                while (itr2.hasNext()) {
                                    Map.Entry<String, JsonNode> property2 = itr2.next();
                                    String tagsKey2 = property2.getKey();
                                    String tagsValue2 = property2.getValue().getTextValue();
                                    virtualMachineJsonInstance.getTags().put(tagsKey2, tagsValue2);
                                }
                            }
                        }
                    }
                    
                    JsonNode nextLinkValue = responseDoc.get("nextLink");
                    if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                        String nextLinkInstance;
                        nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
                
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The operation to power off (stop) a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public Future<ComputeLongRunningOperationResponse> powerOffAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>() { 
            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return powerOff(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to power off (stop) a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public ComputeLongRunningOperationResponse powerOff(String resourceGroupName, String vmName) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "powerOffAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginPoweringOffAsync(resourceGroupName, vmName).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(com.microsoft.azure.management.compute.models.ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The operation to restart a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public Future<ComputeLongRunningOperationResponse> restartAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>() { 
            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return restart(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to restart a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public ComputeLongRunningOperationResponse restart(String resourceGroupName, String vmName) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "restartAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginRestartingAsync(resourceGroupName, vmName).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(com.microsoft.azure.management.compute.models.ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The operation to start a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public Future<ComputeLongRunningOperationResponse> startAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>() { 
            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return start(resourceGroupName, vmName);
            }
         });
    }
    
    /**
    * The operation to start a virtual machine.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param vmName Required. The name of the virtual machine.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The Compute service response for long-running operations.
    */
    @Override
    public ComputeLongRunningOperationResponse start(String resourceGroupName, String vmName) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter(invocationId, this, "startAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginStartingAsync(resourceGroupName, vmName).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals(com.microsoft.azure.management.compute.models.ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}
