/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Describes a disk.
*/
public class Disk {
    private String caching;
    
    /**
    * Optional. Gets or sets the caching type.
    * @return The Caching value.
    */
    public String getCaching() {
        return this.caching;
    }
    
    /**
    * Optional. Gets or sets the caching type.
    * @param cachingValue The Caching value.
    */
    public void setCaching(final String cachingValue) {
        this.caching = cachingValue;
    }
    
    private String createOption;
    
    /**
    * Required. Gets or sets the create option.
    * @return The CreateOption value.
    */
    public String getCreateOption() {
        return this.createOption;
    }
    
    /**
    * Required. Gets or sets the create option.
    * @param createOptionValue The CreateOption value.
    */
    public void setCreateOption(final String createOptionValue) {
        this.createOption = createOptionValue;
    }
    
    private Integer diskSizeGB;
    
    /**
    * Optional. Gets or sets the initial disk size in GB for blank data disks,
    * and the new desired size for existing OS and Data disks.
    * @return The DiskSizeGB value.
    */
    public Integer getDiskSizeGB() {
        return this.diskSizeGB;
    }
    
    /**
    * Optional. Gets or sets the initial disk size in GB for blank data disks,
    * and the new desired size for existing OS and Data disks.
    * @param diskSizeGBValue The DiskSizeGB value.
    */
    public void setDiskSizeGB(final Integer diskSizeGBValue) {
        this.diskSizeGB = diskSizeGBValue;
    }
    
    private String name;
    
    /**
    * Required. Gets or sets the disk name.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Required. Gets or sets the disk name.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private VirtualHardDisk sourceImage;
    
    /**
    * Optional. Gets or sets the Source User Image VirtualHardDisk. This
    * VirtualHardDisk will be copied before using it to attach to the Virtual
    * Machine.If SourceImage is provided, the destination VirtualHardDisk
    * should not exist.
    * @return The SourceImage value.
    */
    public VirtualHardDisk getSourceImage() {
        return this.sourceImage;
    }
    
    /**
    * Optional. Gets or sets the Source User Image VirtualHardDisk. This
    * VirtualHardDisk will be copied before using it to attach to the Virtual
    * Machine.If SourceImage is provided, the destination VirtualHardDisk
    * should not exist.
    * @param sourceImageValue The SourceImage value.
    */
    public void setSourceImage(final VirtualHardDisk sourceImageValue) {
        this.sourceImage = sourceImageValue;
    }
    
    private VirtualHardDisk virtualHardDisk;
    
    /**
    * Required. Gets or sets the Virtual Hard Disk.
    * @return The VirtualHardDisk value.
    */
    public VirtualHardDisk getVirtualHardDisk() {
        return this.virtualHardDisk;
    }
    
    /**
    * Required. Gets or sets the Virtual Hard Disk.
    * @param virtualHardDiskValue The VirtualHardDisk value.
    */
    public void setVirtualHardDisk(final VirtualHardDisk virtualHardDiskValue) {
        this.virtualHardDisk = virtualHardDiskValue;
    }
    
    /**
    * Initializes a new instance of the Disk class.
    *
    */
    public Disk() {
    }
    
    /**
    * Initializes a new instance of the Disk class with required arguments.
    *
    * @param name Gets or sets the disk name.
    * @param virtualHardDisk Gets or sets the Virtual Hard Disk.
    * @param createOption Gets or sets the create option.
    */
    public Disk(String name, VirtualHardDisk virtualHardDisk, String createOption) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (virtualHardDisk == null) {
            throw new NullPointerException("virtualHardDisk");
        }
        if (createOption == null) {
            throw new NullPointerException("createOption");
        }
        this.setName(name);
        this.setVirtualHardDisk(virtualHardDisk);
        this.setCreateOption(createOption);
    }
}
