/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Describes an Operating System disk.
*/
public class OSDisk extends Disk {
    private String operatingSystemType;
    
    /**
    * Optional. Gets or sets the Operating System type.
    * @return The OperatingSystemType value.
    */
    public String getOperatingSystemType() {
        return this.operatingSystemType;
    }
    
    /**
    * Optional. Gets or sets the Operating System type.
    * @param operatingSystemTypeValue The OperatingSystemType value.
    */
    public void setOperatingSystemType(final String operatingSystemTypeValue) {
        this.operatingSystemType = operatingSystemTypeValue;
    }
    
    /**
    * Initializes a new instance of the OSDisk class.
    *
    */
    public OSDisk() {
        super();
    }
    
    /**
    * Initializes a new instance of the OSDisk class with required arguments.
    *
    * @param name Gets or sets the disk name.
    * @param virtualHardDisk Gets or sets the Virtual Hard Disk.
    * @param createOption Gets or sets the create option.
    */
    public OSDisk(String name, VirtualHardDisk virtualHardDisk, String createOption) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (virtualHardDisk == null) {
            throw new NullPointerException("virtualHardDisk");
        }
        if (createOption == null) {
            throw new NullPointerException("createOption");
        }
        this.setName(name);
        this.setVirtualHardDisk(virtualHardDisk);
        this.setCreateOption(createOption);
    }
}
