/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Contains the os disk image information.
*/
public class OSDiskImage {
    private String operatingSystem;
    
    /**
    * Required. Gets or sets the operating system of the osDiskImage.
    * @return The OperatingSystem value.
    */
    public String getOperatingSystem() {
        return this.operatingSystem;
    }
    
    /**
    * Required. Gets or sets the operating system of the osDiskImage.
    * @param operatingSystemValue The OperatingSystem value.
    */
    public void setOperatingSystem(final String operatingSystemValue) {
        this.operatingSystem = operatingSystemValue;
    }
    
    /**
    * Initializes a new instance of the OSDiskImage class.
    *
    */
    public OSDiskImage() {
    }
    
    /**
    * Initializes a new instance of the OSDiskImage class with required
    * arguments.
    *
    * @param operatingSystem Gets or sets the operating system of the
    * osDiskImage.
    */
    public OSDiskImage(String operatingSystem) {
        if (operatingSystem == null) {
            throw new NullPointerException("operatingSystem");
        }
        this.setOperatingSystem(operatingSystem);
    }
}
