/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Contains information about SSH certificate public key and the path on the
* Linux VM where the public key is placed.
*/
public class SshPublicKey {
    private String keyData;
    
    /**
    * Optional. Gets or sets Certificate public key used to authenticate with
    * VM through SSH.The certificate must be in Pem format with or without
    * headers.
    * @return The KeyData value.
    */
    public String getKeyData() {
        return this.keyData;
    }
    
    /**
    * Optional. Gets or sets Certificate public key used to authenticate with
    * VM through SSH.The certificate must be in Pem format with or without
    * headers.
    * @param keyDataValue The KeyData value.
    */
    public void setKeyData(final String keyDataValue) {
        this.keyData = keyDataValue;
    }
    
    private String path;
    
    /**
    * Optional. Gets or sets the full path on the created VM where SSH public
    * key is stored. If the file already exists, the specified key is appended
    * to the file.
    * @return The Path value.
    */
    public String getPath() {
        return this.path;
    }
    
    /**
    * Optional. Gets or sets the full path on the created VM where SSH public
    * key is stored. If the file already exists, the specified key is appended
    * to the file.
    * @param pathValue The Path value.
    */
    public void setPath(final String pathValue) {
        this.path = pathValue;
    }
}
