/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Describes a single certificate reference in a Key Vault, and where the
* certificate should reside on the VM.
*/
public class VaultCertificate {
    private String certificateStore;
    
    /**
    * Optional. Gets or sets the Certificate store in LocalMachine to add the
    * certificate to on Windows, leave empty on Linux.
    * @return The CertificateStore value.
    */
    public String getCertificateStore() {
        return this.certificateStore;
    }
    
    /**
    * Optional. Gets or sets the Certificate store in LocalMachine to add the
    * certificate to on Windows, leave empty on Linux.
    * @param certificateStoreValue The CertificateStore value.
    */
    public void setCertificateStore(final String certificateStoreValue) {
        this.certificateStore = certificateStoreValue;
    }
    
    private String certificateUrl;
    
    /**
    * Optional. Gets or sets the URL referencing a secret in a Key Vault which
    * contains a properly formatted certificate.
    * @return The CertificateUrl value.
    */
    public String getCertificateUrl() {
        return this.certificateUrl;
    }
    
    /**
    * Optional. Gets or sets the URL referencing a secret in a Key Vault which
    * contains a properly formatted certificate.
    * @param certificateUrlValue The CertificateUrl value.
    */
    public void setCertificateUrl(final String certificateUrlValue) {
        this.certificateUrl = certificateUrlValue;
    }
}
