/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Capture Virtual Machine parameters.
*/
public class VirtualMachineCaptureParameters {
    private String destinationContainerName;
    
    /**
    * Required. Gets or sets the destination container name.
    * @return The DestinationContainerName value.
    */
    public String getDestinationContainerName() {
        return this.destinationContainerName;
    }
    
    /**
    * Required. Gets or sets the destination container name.
    * @param destinationContainerNameValue The DestinationContainerName value.
    */
    public void setDestinationContainerName(final String destinationContainerNameValue) {
        this.destinationContainerName = destinationContainerNameValue;
    }
    
    private boolean overwrite;
    
    /**
    * Required. Gets or sets whether it overwrites destination VirtualHardDisk
    * if true, in case of conflict.
    * @return The Overwrite value.
    */
    public boolean isOverwrite() {
        return this.overwrite;
    }
    
    /**
    * Required. Gets or sets whether it overwrites destination VirtualHardDisk
    * if true, in case of conflict.
    * @param overwriteValue The Overwrite value.
    */
    public void setOverwrite(final boolean overwriteValue) {
        this.overwrite = overwriteValue;
    }
    
    private String virtualHardDiskNamePrefix;
    
    /**
    * Required. Gets or sets the captured VirtualHardDisk's name prefix.
    * @return The VirtualHardDiskNamePrefix value.
    */
    public String getVirtualHardDiskNamePrefix() {
        return this.virtualHardDiskNamePrefix;
    }
    
    /**
    * Required. Gets or sets the captured VirtualHardDisk's name prefix.
    * @param virtualHardDiskNamePrefixValue The VirtualHardDiskNamePrefix value.
    */
    public void setVirtualHardDiskNamePrefix(final String virtualHardDiskNamePrefixValue) {
        this.virtualHardDiskNamePrefix = virtualHardDiskNamePrefixValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineCaptureParameters class.
    *
    */
    public VirtualMachineCaptureParameters() {
    }
    
    /**
    * Initializes a new instance of the VirtualMachineCaptureParameters class
    * with required arguments.
    *
    * @param virtualHardDiskNamePrefix Gets or sets the captured
    * VirtualHardDisk's name prefix.
    * @param destinationContainerName Gets or sets the destination container
    * name.
    * @param overwrite Gets or sets whether it overwrites destination
    * VirtualHardDisk if true, in case of conflict.
    */
    public VirtualMachineCaptureParameters(String virtualHardDiskNamePrefix, String destinationContainerName, boolean overwrite) {
        if (virtualHardDiskNamePrefix == null) {
            throw new NullPointerException("virtualHardDiskNamePrefix");
        }
        if (destinationContainerName == null) {
            throw new NullPointerException("destinationContainerName");
        }
        this.setVirtualHardDiskNamePrefix(virtualHardDiskNamePrefix);
        this.setDestinationContainerName(destinationContainerName);
        this.setOverwrite(overwrite);
    }
}
