/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

import com.microsoft.windowsazure.core.ResourceBaseExtended;

/**
* Describes a Virtual Machine Extension.
*/
public class VirtualMachineExtension extends ResourceBaseExtended {
    private boolean autoUpgradeMinorVersion;
    
    /**
    * Optional. Gets or sets whether the extension handler should be
    * automatically upgraded across minor versions.
    * @return The AutoUpgradeMinorVersion value.
    */
    public boolean isAutoUpgradeMinorVersion() {
        return this.autoUpgradeMinorVersion;
    }
    
    /**
    * Optional. Gets or sets whether the extension handler should be
    * automatically upgraded across minor versions.
    * @param autoUpgradeMinorVersionValue The AutoUpgradeMinorVersion value.
    */
    public void setAutoUpgradeMinorVersion(final boolean autoUpgradeMinorVersionValue) {
        this.autoUpgradeMinorVersion = autoUpgradeMinorVersionValue;
    }
    
    private String extensionType;
    
    /**
    * Optional. Gets or sets the type of the extension handler.
    * @return The ExtensionType value.
    */
    public String getExtensionType() {
        return this.extensionType;
    }
    
    /**
    * Optional. Gets or sets the type of the extension handler.
    * @param extensionTypeValue The ExtensionType value.
    */
    public void setExtensionType(final String extensionTypeValue) {
        this.extensionType = extensionTypeValue;
    }
    
    private VirtualMachineExtensionInstanceView instanceView;
    
    /**
    * Optional. Gets or sets the virtual machine extension instance view.
    * @return The InstanceView value.
    */
    public VirtualMachineExtensionInstanceView getInstanceView() {
        return this.instanceView;
    }
    
    /**
    * Optional. Gets or sets the virtual machine extension instance view.
    * @param instanceViewValue The InstanceView value.
    */
    public void setInstanceView(final VirtualMachineExtensionInstanceView instanceViewValue) {
        this.instanceView = instanceViewValue;
    }
    
    private String protectedSettings;
    
    /**
    * Optional. Gets or sets Json formatted protected settings for the
    * extension.
    * @return The ProtectedSettings value.
    */
    public String getProtectedSettings() {
        return this.protectedSettings;
    }
    
    /**
    * Optional. Gets or sets Json formatted protected settings for the
    * extension.
    * @param protectedSettingsValue The ProtectedSettings value.
    */
    public void setProtectedSettings(final String protectedSettingsValue) {
        this.protectedSettings = protectedSettingsValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets the provisioning state, which only appears in the
    * response.
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets the provisioning state, which only appears in the
    * response.
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private String publisher;
    
    /**
    * Optional. Gets or sets the name of the extension handler publisher.
    * @return The Publisher value.
    */
    public String getPublisher() {
        return this.publisher;
    }
    
    /**
    * Optional. Gets or sets the name of the extension handler publisher.
    * @param publisherValue The Publisher value.
    */
    public void setPublisher(final String publisherValue) {
        this.publisher = publisherValue;
    }
    
    private String settings;
    
    /**
    * Optional. Gets or sets Json formatted public settings for the extension.
    * @return The Settings value.
    */
    public String getSettings() {
        return this.settings;
    }
    
    /**
    * Optional. Gets or sets Json formatted public settings for the extension.
    * @param settingsValue The Settings value.
    */
    public void setSettings(final String settingsValue) {
        this.settings = settingsValue;
    }
    
    private String typeHandlerVersion;
    
    /**
    * Optional. Gets or sets the type version of the extension handler.
    * @return The TypeHandlerVersion value.
    */
    public String getTypeHandlerVersion() {
        return this.typeHandlerVersion;
    }
    
    /**
    * Optional. Gets or sets the type version of the extension handler.
    * @param typeHandlerVersionValue The TypeHandlerVersion value.
    */
    public void setTypeHandlerVersion(final String typeHandlerVersionValue) {
        this.typeHandlerVersion = typeHandlerVersionValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineExtension class.
    *
    */
    public VirtualMachineExtension() {
        super();
    }
    
    /**
    * Initializes a new instance of the VirtualMachineExtension class with
    * required arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public VirtualMachineExtension(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
