/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Contains the parameteres required to list virtual machine extension image
* versions.
*/
public class VirtualMachineExtensionImageListVersionsParameters extends VirtualMachineExtensionImageListTypesParameters {
    private String filterExpression;
    
    /**
    * Optional. ODAta filter
    * expression.https://msdn.microsoft.com/en-us/library/hh169248(v=nav.70).aspxSupported
    * operatives: -eq -startswith Examples:    To list the all version that
    * begin with 1.0 $filter=startswith(name, ‘1.0’)    To get the latest
    * version $filter= name eq ‘latest’
    * @return The FilterExpression value.
    */
    public String getFilterExpression() {
        return this.filterExpression;
    }
    
    /**
    * Optional. ODAta filter
    * expression.https://msdn.microsoft.com/en-us/library/hh169248(v=nav.70).aspxSupported
    * operatives: -eq -startswith Examples:    To list the all version that
    * begin with 1.0 $filter=startswith(name, ‘1.0’)    To get the latest
    * version $filter= name eq ‘latest’
    * @param filterExpressionValue The FilterExpression value.
    */
    public void setFilterExpression(final String filterExpressionValue) {
        this.filterExpression = filterExpressionValue;
    }
    
    private String type;
    
    /**
    * Required. Unique (across the publisher) identifier to distinguish an
    * extension for this publisher. Example: 'BGInfo' or 'VMAccess'.The
    * allowed characters are uppercase or lowercase letters, digit, hypen(-),
    * period (.)Dot or hyphen is not allowed the end of value. Max length is
    * 64.
    * @return The Type value.
    */
    public String getType() {
        return this.type;
    }
    
    /**
    * Required. Unique (across the publisher) identifier to distinguish an
    * extension for this publisher. Example: 'BGInfo' or 'VMAccess'.The
    * allowed characters are uppercase or lowercase letters, digit, hypen(-),
    * period (.)Dot or hyphen is not allowed the end of value. Max length is
    * 64.
    * @param typeValue The Type value.
    */
    public void setType(final String typeValue) {
        this.type = typeValue;
    }
    
    /**
    * Initializes a new instance of the
    * VirtualMachineExtensionImageListVersionsParameters class.
    *
    */
    public VirtualMachineExtensionImageListVersionsParameters() {
        super();
    }
    
    /**
    * Initializes a new instance of the
    * VirtualMachineExtensionImageListVersionsParameters class with required
    * arguments.
    *
    * @param type Unique (across the publisher) identifier to distinguish an
    * extension for this publisher. Example: 'BGInfo' or 'VMAccess'.The
    * allowed characters are uppercase or lowercase letters, digit, hypen(-),
    * period (.)Dot or hyphen is not allowed the end of value. Max length is
    * 64.
    * @param location Location of the PIR, used for orchestration and required
    * by CSM to direct request to appropriate PIR region. Example: westus,
    * eastus.
    * @param publisherName Publisher identifier. For example: Microsoft.Windows
    * or Canonical.
    */
    public VirtualMachineExtensionImageListVersionsParameters(String type, String location, String publisherName) {
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (publisherName == null) {
            throw new NullPointerException("publisherName");
        }
        this.setType(type);
        this.setLocation(location);
        this.setPublisherName(publisherName);
    }
}
