/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Contains the parameters required to list skus.
*/
public class VirtualMachineImageListSkusParameters extends VirtualMachineImageListOffersParameters {
    private String offer;
    
    /**
    * Required. Unique identifier to distinguish an image. The vmImageName must
    * be unique within publisher’s namespace. Example: WindowsServer2012
    * @return The Offer value.
    */
    public String getOffer() {
        return this.offer;
    }
    
    /**
    * Required. Unique identifier to distinguish an image. The vmImageName must
    * be unique within publisher’s namespace. Example: WindowsServer2012
    * @param offerValue The Offer value.
    */
    public void setOffer(final String offerValue) {
        this.offer = offerValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineImageListSkusParameters
    * class.
    *
    */
    public VirtualMachineImageListSkusParameters() {
        super();
    }
    
    /**
    * Initializes a new instance of the VirtualMachineImageListSkusParameters
    * class with required arguments.
    *
    * @param offer Unique identifier to distinguish an image. The vmImageName
    * must be unique within publisher’s namespace. Example: WindowsServer2012
    * @param publisherName Publisher identifier. For example: Microsoft.Windows
    * or Canonical.
    * @param location Location of the PIR, used for orchestration and required
    * by CSM to direct request to appropriate PIR region. Example: westus,
    * eastus.
    */
    public VirtualMachineImageListSkusParameters(String offer, String publisherName, String location) {
        if (offer == null) {
            throw new NullPointerException("offer");
        }
        if (publisherName == null) {
            throw new NullPointerException("publisherName");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setOffer(offer);
        this.setPublisherName(publisherName);
        this.setLocation(location);
    }
}
