/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import com.microsoft.windowsazure.core.OperationResponse;

import java.util.ArrayList;

/**
* The List Virtual Machine operation response.
*/
public class VirtualMachineListResponse extends OperationResponse {
    private String nextLink;
    
    /**
    * Optional. Gets or sets the uri to fetch the next page of VMs. Call
    * ListNext() with this to fetch the next page of Virtual Machines.
    * @return The NextLink value.
    */
    public String getNextLink() {
        return this.nextLink;
    }
    
    /**
    * Optional. Gets or sets the uri to fetch the next page of VMs. Call
    * ListNext() with this to fetch the next page of Virtual Machines.
    * @param nextLinkValue The NextLink value.
    */
    public void setNextLink(final String nextLinkValue) {
        this.nextLink = nextLinkValue;
    }
    
    private ArrayList<VirtualMachine> virtualMachines;
    
    /**
    * Optional. Gets or sets the list of virtual machines.
    * @return The VirtualMachines value.
    */
    public ArrayList<VirtualMachine> getVirtualMachines() {
        return this.virtualMachines;
    }
    
    /**
    * Optional. Gets or sets the list of virtual machines.
    * @param virtualMachinesValue The VirtualMachines value.
    */
    public void setVirtualMachines(final ArrayList<VirtualMachine> virtualMachinesValue) {
        this.virtualMachines = virtualMachinesValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineListResponse class.
    *
    */
    public VirtualMachineListResponse() {
        super();
        this.setVirtualMachines(new LazyArrayList<VirtualMachine>());
    }
}
