/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns;

import com.microsoft.azure.management.dns.models.ZoneCreateOrUpdateParameters;
import com.microsoft.azure.management.dns.models.ZoneCreateOrUpdateResponse;
import com.microsoft.azure.management.dns.models.ZoneDeleteParameters;
import com.microsoft.azure.management.dns.models.ZoneGetResponse;
import com.microsoft.azure.management.dns.models.ZoneListParameters;
import com.microsoft.azure.management.dns.models.ZoneListResponse;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.exception.ServiceException;

import java.io.IOException;
import java.util.concurrent.Future;

/**
* Operations for managing DNS zones.
*/
public interface ZoneOperations {
    /**
    * Creates a DNS zone within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @param parameters Required. Parameters supplied to the CreateOrUpdate
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Zone CreateOrUpdate operation.
    */
    ZoneCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String zoneName, ZoneCreateOrUpdateParameters parameters) throws IOException, ServiceException;
    
    /**
    * Creates a DNS zone within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @param parameters Required. Parameters supplied to the CreateOrUpdate
    * operation.
    * @return The response to a Zone CreateOrUpdate operation.
    */
    Future<ZoneCreateOrUpdateResponse> createOrUpdateAsync(String resourceGroupName, String zoneName, ZoneCreateOrUpdateParameters parameters);
    
    /**
    * Removes a DNS zone from a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @param parameters Required. The parameters supplied to delete a zone
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String resourceGroupName, String zoneName, ZoneDeleteParameters parameters) throws IOException, ServiceException;
    
    /**
    * Removes a DNS zone from a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @param parameters Required. The parameters supplied to delete a zone
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String resourceGroupName, String zoneName, ZoneDeleteParameters parameters);
    
    /**
    * Gets a DNS zone.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Zone Get operation.
    */
    ZoneGetResponse get(String resourceGroupName, String zoneName) throws IOException, ServiceException;
    
    /**
    * Gets a DNS zone.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @return The response to a Zone Get operation.
    */
    Future<ZoneGetResponse> getAsync(String resourceGroupName, String zoneName);
    
    /**
    * Lists the DNS zones within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Optional. Query parameters. If null is passed returns
    * the default number of zones.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Zone List or ListAll operation.
    */
    ZoneListResponse list(String resourceGroupName, ZoneListParameters parameters) throws IOException, ServiceException;
    
    /**
    * Lists the DNS zones within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Optional. Query parameters. If null is passed returns
    * the default number of zones.
    * @return The response to a Zone List or ListAll operation.
    */
    Future<ZoneListResponse> listAsync(String resourceGroupName, ZoneListParameters parameters);
    
    /**
    * Lists the DNS zones within a resource group.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Zone List or ListAll operation.
    */
    ZoneListResponse listNext(String nextLink) throws IOException, ServiceException;
    
    /**
    * Lists the DNS zones within a resource group.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return The response to a Zone List or ListAll operation.
    */
    Future<ZoneListResponse> listNextAsync(String nextLink);
}
