/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.dns;

import com.microsoft.azure.management.dns.models.Zone;
import com.microsoft.azure.management.dns.models.ZoneCreateOrUpdateParameters;
import com.microsoft.azure.management.dns.models.ZoneCreateOrUpdateResponse;
import com.microsoft.azure.management.dns.models.ZoneDeleteParameters;
import com.microsoft.azure.management.dns.models.ZoneGetResponse;
import com.microsoft.azure.management.dns.models.ZoneListParameters;
import com.microsoft.azure.management.dns.models.ZoneListResponse;
import com.microsoft.azure.management.dns.models.ZoneProperties;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
* Operations for managing DNS zones.
*/
public class ZoneOperationsImpl implements ServiceOperations<DnsManagementClientImpl>, ZoneOperations {
    /**
    * Initializes a new instance of the ZoneOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    ZoneOperationsImpl(DnsManagementClientImpl client) {
        this.client = client;
    }
    
    private DnsManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.azure.management.dns.DnsManagementClientImpl.
    * @return The Client value.
    */
    public DnsManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * Creates a DNS zone within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @param parameters Required. Parameters supplied to the CreateOrUpdate
    * operation.
    * @return The response to a Zone CreateOrUpdate operation.
    */
    @Override
    public Future<ZoneCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final String zoneName, final ZoneCreateOrUpdateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ZoneCreateOrUpdateResponse>() { 
            @Override
            public ZoneCreateOrUpdateResponse call() throws Exception {
                return createOrUpdate(resourceGroupName, zoneName, parameters);
            }
         });
    }
    
    /**
    * Creates a DNS zone within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @param parameters Required. Parameters supplied to the CreateOrUpdate
    * operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Zone CreateOrUpdate operation.
    */
    @Override
    public ZoneCreateOrUpdateResponse createOrUpdate(String resourceGroupName, String zoneName, ZoneCreateOrUpdateParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getZone() == null) {
            throw new NullPointerException("parameters.Zone");
        }
        if (parameters.getZone().getLocation() == null) {
            throw new NullPointerException("parameters.Zone.Location");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createOrUpdateAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPut httpRequest = new HttpPut(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("If-Match", parameters.getZone().getETag());
        httpRequest.setHeader("If-None-Match", parameters.getIfNoneMatch());
        
        // Serialize Request
        String requestContent = null;
        JsonNode requestDoc = null;
        
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode zoneCreateOrUpdateParametersValue = objectMapper.createObjectNode();
        requestDoc = zoneCreateOrUpdateParametersValue;
        
        if (parameters.getZone().getETag() != null) {
            ((ObjectNode) zoneCreateOrUpdateParametersValue).put("etag", parameters.getZone().getETag());
        }
        
        if (parameters.getZone().getProperties() != null) {
            ObjectNode propertiesValue = objectMapper.createObjectNode();
            ((ObjectNode) zoneCreateOrUpdateParametersValue).put("properties", propertiesValue);
            
            if (parameters.getZone().getProperties().getMaxNumberOfRecordSets() != null) {
                ((ObjectNode) propertiesValue).put("maxNumberOfRecordSets", parameters.getZone().getProperties().getMaxNumberOfRecordSets());
            }
            
            if (parameters.getZone().getProperties().getNumberOfRecordSets() != null) {
                ((ObjectNode) propertiesValue).put("numberOfRecordSets", parameters.getZone().getProperties().getNumberOfRecordSets());
            }
        }
        
        if (parameters.getZone().getId() != null) {
            ((ObjectNode) zoneCreateOrUpdateParametersValue).put("id", parameters.getZone().getId());
        }
        
        if (parameters.getZone().getName() != null) {
            ((ObjectNode) zoneCreateOrUpdateParametersValue).put("name", parameters.getZone().getName());
        }
        
        if (parameters.getZone().getType() != null) {
            ((ObjectNode) zoneCreateOrUpdateParametersValue).put("type", parameters.getZone().getType());
        }
        
        ((ObjectNode) zoneCreateOrUpdateParametersValue).put("location", parameters.getZone().getLocation());
        
        if (parameters.getZone().getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry<String, String> entry : parameters.getZone().getTags().entrySet()) {
                String tagsKey = entry.getKey();
                String tagsValue = entry.getValue();
                ((ObjectNode) tagsDictionary).put(tagsKey, tagsValue);
            }
            ((ObjectNode) zoneCreateOrUpdateParametersValue).put("tags", tagsDictionary);
        }
        
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue(stringWriter, requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ZoneCreateOrUpdateResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ZoneCreateOrUpdateResponse();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                Zone zoneInstance = new Zone();
                result.setZone(zoneInstance);
                
                JsonNode etagValue = responseDoc.get("etag");
                if (etagValue != null && etagValue instanceof NullNode == false) {
                    String etagInstance;
                    etagInstance = etagValue.getTextValue();
                    zoneInstance.setETag(etagInstance);
                }
                
                JsonNode propertiesValue2 = responseDoc.get("properties");
                if (propertiesValue2 != null && propertiesValue2 instanceof NullNode == false) {
                    ZoneProperties propertiesInstance = new ZoneProperties();
                    zoneInstance.setProperties(propertiesInstance);
                    
                    JsonNode maxNumberOfRecordSetsValue = propertiesValue2.get("maxNumberOfRecordSets");
                    if (maxNumberOfRecordSetsValue != null && maxNumberOfRecordSetsValue instanceof NullNode == false) {
                        long maxNumberOfRecordSetsInstance;
                        maxNumberOfRecordSetsInstance = maxNumberOfRecordSetsValue.getLongValue();
                        propertiesInstance.setMaxNumberOfRecordSets(maxNumberOfRecordSetsInstance);
                    }
                    
                    JsonNode numberOfRecordSetsValue = propertiesValue2.get("numberOfRecordSets");
                    if (numberOfRecordSetsValue != null && numberOfRecordSetsValue instanceof NullNode == false) {
                        long numberOfRecordSetsInstance;
                        numberOfRecordSetsInstance = numberOfRecordSetsValue.getLongValue();
                        propertiesInstance.setNumberOfRecordSets(numberOfRecordSetsInstance);
                    }
                }
                
                JsonNode idValue = responseDoc.get("id");
                if (idValue != null && idValue instanceof NullNode == false) {
                    String idInstance;
                    idInstance = idValue.getTextValue();
                    zoneInstance.setId(idInstance);
                }
                
                JsonNode nameValue = responseDoc.get("name");
                if (nameValue != null && nameValue instanceof NullNode == false) {
                    String nameInstance;
                    nameInstance = nameValue.getTextValue();
                    zoneInstance.setName(nameInstance);
                }
                
                JsonNode typeValue = responseDoc.get("type");
                if (typeValue != null && typeValue instanceof NullNode == false) {
                    String typeInstance;
                    typeInstance = typeValue.getTextValue();
                    zoneInstance.setType(typeInstance);
                }
                
                JsonNode locationValue = responseDoc.get("location");
                if (locationValue != null && locationValue instanceof NullNode == false) {
                    String locationInstance;
                    locationInstance = locationValue.getTextValue();
                    zoneInstance.setLocation(locationInstance);
                }
                
                JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                    Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry<String, JsonNode> property = itr.next();
                        String tagsKey2 = property.getKey();
                        String tagsValue2 = property.getValue().getTextValue();
                        zoneInstance.getTags().put(tagsKey2, tagsValue2);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Removes a DNS zone from a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @param parameters Required. The parameters supplied to delete a zone
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String zoneName, final ZoneDeleteParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return delete(resourceGroupName, zoneName, parameters);
            }
         });
    }
    
    /**
    * Removes a DNS zone from a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @param parameters Required. The parameters supplied to delete a zone
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse delete(String resourceGroupName, String zoneName, ZoneDeleteParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "deleteAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        httpRequest.setHeader("If-Match", parameters.getIfMatch());
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            // Deserialize Response
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Gets a DNS zone.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @return The response to a Zone Get operation.
    */
    @Override
    public Future<ZoneGetResponse> getAsync(final String resourceGroupName, final String zoneName) {
        return this.getClient().getExecutorService().submit(new Callable<ZoneGetResponse>() { 
            @Override
            public ZoneGetResponse call() throws Exception {
                return get(resourceGroupName, zoneName);
            }
         });
    }
    
    /**
    * Gets a DNS zone.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param zoneName Required. The name of the zone without a terminating dot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Zone Get operation.
    */
    @Override
    public ZoneGetResponse get(String resourceGroupName, String zoneName) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (zoneName == null) {
            throw new NullPointerException("zoneName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("zoneName", zoneName);
            CloudTracing.enter(invocationId, this, "getAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones/";
        url = url + URLEncoder.encode(zoneName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=" + "2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ZoneGetResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ZoneGetResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                Zone zoneInstance = new Zone();
                result.setZone(zoneInstance);
                
                JsonNode etagValue = responseDoc.get("etag");
                if (etagValue != null && etagValue instanceof NullNode == false) {
                    String etagInstance;
                    etagInstance = etagValue.getTextValue();
                    zoneInstance.setETag(etagInstance);
                }
                
                JsonNode propertiesValue = responseDoc.get("properties");
                if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                    ZoneProperties propertiesInstance = new ZoneProperties();
                    zoneInstance.setProperties(propertiesInstance);
                    
                    JsonNode maxNumberOfRecordSetsValue = propertiesValue.get("maxNumberOfRecordSets");
                    if (maxNumberOfRecordSetsValue != null && maxNumberOfRecordSetsValue instanceof NullNode == false) {
                        long maxNumberOfRecordSetsInstance;
                        maxNumberOfRecordSetsInstance = maxNumberOfRecordSetsValue.getLongValue();
                        propertiesInstance.setMaxNumberOfRecordSets(maxNumberOfRecordSetsInstance);
                    }
                    
                    JsonNode numberOfRecordSetsValue = propertiesValue.get("numberOfRecordSets");
                    if (numberOfRecordSetsValue != null && numberOfRecordSetsValue instanceof NullNode == false) {
                        long numberOfRecordSetsInstance;
                        numberOfRecordSetsInstance = numberOfRecordSetsValue.getLongValue();
                        propertiesInstance.setNumberOfRecordSets(numberOfRecordSetsInstance);
                    }
                }
                
                JsonNode idValue = responseDoc.get("id");
                if (idValue != null && idValue instanceof NullNode == false) {
                    String idInstance;
                    idInstance = idValue.getTextValue();
                    zoneInstance.setId(idInstance);
                }
                
                JsonNode nameValue = responseDoc.get("name");
                if (nameValue != null && nameValue instanceof NullNode == false) {
                    String nameInstance;
                    nameInstance = nameValue.getTextValue();
                    zoneInstance.setName(nameInstance);
                }
                
                JsonNode typeValue = responseDoc.get("type");
                if (typeValue != null && typeValue instanceof NullNode == false) {
                    String typeInstance;
                    typeInstance = typeValue.getTextValue();
                    zoneInstance.setType(typeInstance);
                }
                
                JsonNode locationValue = responseDoc.get("location");
                if (locationValue != null && locationValue instanceof NullNode == false) {
                    String locationInstance;
                    locationInstance = locationValue.getTextValue();
                    zoneInstance.setLocation(locationInstance);
                }
                
                JsonNode tagsSequenceElement = ((JsonNode) responseDoc.get("tags"));
                if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                    Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                    while (itr.hasNext()) {
                        Map.Entry<String, JsonNode> property = itr.next();
                        String tagsKey = property.getKey();
                        String tagsValue = property.getValue().getTextValue();
                        zoneInstance.getTags().put(tagsKey, tagsValue);
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists the DNS zones within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Optional. Query parameters. If null is passed returns
    * the default number of zones.
    * @return The response to a Zone List or ListAll operation.
    */
    @Override
    public Future<ZoneListResponse> listAsync(final String resourceGroupName, final ZoneListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ZoneListResponse>() { 
            @Override
            public ZoneListResponse call() throws Exception {
                return list(resourceGroupName, parameters);
            }
         });
    }
    
    /**
    * Lists the DNS zones within a resource group.
    *
    * @param resourceGroupName Required. The name of the resource group.
    * @param parameters Optional. Query parameters. If null is passed returns
    * the default number of zones.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Zone List or ListAll operation.
    */
    @Override
    public ZoneListResponse list(String resourceGroupName, ZoneListParameters parameters) throws IOException, ServiceException {
        // Validate
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "listAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Network";
        url = url + "/dnszones";
        ArrayList<String> queryParameters = new ArrayList<String>();
        if (parameters != null && parameters.getTop() != null) {
            queryParameters.add("$top=" + URLEncoder.encode(parameters.getTop(), "UTF-8"));
        }
        ArrayList<String> odataFilter = new ArrayList<String>();
        if (parameters != null && parameters.getFilter() != null) {
            odataFilter.add(URLEncoder.encode(parameters.getFilter(), "UTF-8"));
        }
        if (odataFilter.size() > 0) {
            queryParameters.add("$filter=" + CollectionStringBuilder.join(odataFilter, null));
        }
        queryParameters.add("api-version=" + "2015-05-04-preview");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, "&");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ZoneListResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ZoneListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                JsonNode valueArray = responseDoc.get("value");
                if (valueArray != null && valueArray instanceof NullNode == false) {
                    for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                        Zone zoneInstance = new Zone();
                        result.getZones().add(zoneInstance);
                        
                        JsonNode etagValue = valueValue.get("etag");
                        if (etagValue != null && etagValue instanceof NullNode == false) {
                            String etagInstance;
                            etagInstance = etagValue.getTextValue();
                            zoneInstance.setETag(etagInstance);
                        }
                        
                        JsonNode propertiesValue = valueValue.get("properties");
                        if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                            ZoneProperties propertiesInstance = new ZoneProperties();
                            zoneInstance.setProperties(propertiesInstance);
                            
                            JsonNode maxNumberOfRecordSetsValue = propertiesValue.get("maxNumberOfRecordSets");
                            if (maxNumberOfRecordSetsValue != null && maxNumberOfRecordSetsValue instanceof NullNode == false) {
                                long maxNumberOfRecordSetsInstance;
                                maxNumberOfRecordSetsInstance = maxNumberOfRecordSetsValue.getLongValue();
                                propertiesInstance.setMaxNumberOfRecordSets(maxNumberOfRecordSetsInstance);
                            }
                            
                            JsonNode numberOfRecordSetsValue = propertiesValue.get("numberOfRecordSets");
                            if (numberOfRecordSetsValue != null && numberOfRecordSetsValue instanceof NullNode == false) {
                                long numberOfRecordSetsInstance;
                                numberOfRecordSetsInstance = numberOfRecordSetsValue.getLongValue();
                                propertiesInstance.setNumberOfRecordSets(numberOfRecordSetsInstance);
                            }
                        }
                        
                        JsonNode idValue = valueValue.get("id");
                        if (idValue != null && idValue instanceof NullNode == false) {
                            String idInstance;
                            idInstance = idValue.getTextValue();
                            zoneInstance.setId(idInstance);
                        }
                        
                        JsonNode nameValue = valueValue.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            zoneInstance.setName(nameInstance);
                        }
                        
                        JsonNode typeValue = valueValue.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            String typeInstance;
                            typeInstance = typeValue.getTextValue();
                            zoneInstance.setType(typeInstance);
                        }
                        
                        JsonNode locationValue = valueValue.get("location");
                        if (locationValue != null && locationValue instanceof NullNode == false) {
                            String locationInstance;
                            locationInstance = locationValue.getTextValue();
                            zoneInstance.setLocation(locationInstance);
                        }
                        
                        JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                        if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                            Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry<String, JsonNode> property = itr.next();
                                String tagsKey = property.getKey();
                                String tagsValue = property.getValue().getTextValue();
                                zoneInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                }
                
                JsonNode nextLinkValue = responseDoc.get("nextLink");
                if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                    String nextLinkInstance;
                    nextLinkInstance = nextLinkValue.getTextValue();
                    result.setNextLink(nextLinkInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Lists the DNS zones within a resource group.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @return The response to a Zone List or ListAll operation.
    */
    @Override
    public Future<ZoneListResponse> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<ZoneListResponse>() { 
            @Override
            public ZoneListResponse call() throws Exception {
                return listNext(nextLink);
            }
         });
    }
    
    /**
    * Lists the DNS zones within a resource group.
    *
    * @param nextLink Required. NextLink from the previous successful call to
    * List operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response to a Zone List or ListAll operation.
    */
    @Override
    public ZoneListResponse listNext(String nextLink) throws IOException, ServiceException {
        // Validate
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter(invocationId, this, "listNextAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode >= HttpStatus.SC_BAD_REQUEST) {
                ServiceException ex = ServiceException.createFromJson(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            ZoneListResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new ZoneListResponse();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode responseDoc = null;
            if (responseContent == null == false) {
                responseDoc = objectMapper.readTree(responseContent);
            }
            
            if (responseDoc != null && responseDoc instanceof NullNode == false) {
                JsonNode valueArray = responseDoc.get("value");
                if (valueArray != null && valueArray instanceof NullNode == false) {
                    for (JsonNode valueValue : ((ArrayNode) valueArray)) {
                        Zone zoneInstance = new Zone();
                        result.getZones().add(zoneInstance);
                        
                        JsonNode etagValue = valueValue.get("etag");
                        if (etagValue != null && etagValue instanceof NullNode == false) {
                            String etagInstance;
                            etagInstance = etagValue.getTextValue();
                            zoneInstance.setETag(etagInstance);
                        }
                        
                        JsonNode propertiesValue = valueValue.get("properties");
                        if (propertiesValue != null && propertiesValue instanceof NullNode == false) {
                            ZoneProperties propertiesInstance = new ZoneProperties();
                            zoneInstance.setProperties(propertiesInstance);
                            
                            JsonNode maxNumberOfRecordSetsValue = propertiesValue.get("maxNumberOfRecordSets");
                            if (maxNumberOfRecordSetsValue != null && maxNumberOfRecordSetsValue instanceof NullNode == false) {
                                long maxNumberOfRecordSetsInstance;
                                maxNumberOfRecordSetsInstance = maxNumberOfRecordSetsValue.getLongValue();
                                propertiesInstance.setMaxNumberOfRecordSets(maxNumberOfRecordSetsInstance);
                            }
                            
                            JsonNode numberOfRecordSetsValue = propertiesValue.get("numberOfRecordSets");
                            if (numberOfRecordSetsValue != null && numberOfRecordSetsValue instanceof NullNode == false) {
                                long numberOfRecordSetsInstance;
                                numberOfRecordSetsInstance = numberOfRecordSetsValue.getLongValue();
                                propertiesInstance.setNumberOfRecordSets(numberOfRecordSetsInstance);
                            }
                        }
                        
                        JsonNode idValue = valueValue.get("id");
                        if (idValue != null && idValue instanceof NullNode == false) {
                            String idInstance;
                            idInstance = idValue.getTextValue();
                            zoneInstance.setId(idInstance);
                        }
                        
                        JsonNode nameValue = valueValue.get("name");
                        if (nameValue != null && nameValue instanceof NullNode == false) {
                            String nameInstance;
                            nameInstance = nameValue.getTextValue();
                            zoneInstance.setName(nameInstance);
                        }
                        
                        JsonNode typeValue = valueValue.get("type");
                        if (typeValue != null && typeValue instanceof NullNode == false) {
                            String typeInstance;
                            typeInstance = typeValue.getTextValue();
                            zoneInstance.setType(typeInstance);
                        }
                        
                        JsonNode locationValue = valueValue.get("location");
                        if (locationValue != null && locationValue instanceof NullNode == false) {
                            String locationInstance;
                            locationInstance = locationValue.getTextValue();
                            zoneInstance.setLocation(locationInstance);
                        }
                        
                        JsonNode tagsSequenceElement = ((JsonNode) valueValue.get("tags"));
                        if (tagsSequenceElement != null && tagsSequenceElement instanceof NullNode == false) {
                            Iterator<Map.Entry<String, JsonNode>> itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry<String, JsonNode> property = itr.next();
                                String tagsKey = property.getKey();
                                String tagsValue = property.getValue().getTextValue();
                                zoneInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                }
                
                JsonNode nextLinkValue = responseDoc.get("nextLink");
                if (nextLinkValue != null && nextLinkValue instanceof NullNode == false) {
                    String nextLinkInstance;
                    nextLinkInstance = nextLinkValue.getTextValue();
                    result.setNextLink(nextLinkInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}
